

CREATE TABLE `demo_plan_agent` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `agent_id` mediumtext NOT NULL,
  `agent_unique_number` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `address` mediumtext NOT NULL,
  `city` mediumtext NOT NULL,
  `state` mediumtext NOT NULL,
  `chit_id` mediumtext NOT NULL,
  `chit_details` mediumtext NOT NULL,
  `commission` mediumtext NOT NULL,
  `login_user_name` mediumtext NOT NULL,
  `password` mediumtext NOT NULL,
  `fund_wallet` double NOT NULL,
  `commission_wallet` double NOT NULL,
  `merge_wallet` double NOT NULL,
  `total_wallet` double NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;


INSERT INTO demo_plan_agent (id, created_date_time, creator, creator_name, agent_id, agent_unique_number, name, mobile_number, address, city, state, chit_id, chit_details, commission, login_user_name, password, fund_wallet, commission_wallet, merge_wallet, total_wallet, deleted) VALUES ('1','2023-01-14 05:32:28','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','51326870644342476457356b','5957646c626e52664d5451774d5449774d6a4d774e544d794d6a68664d44453d','4d6a41794d30464856444178','566b6c4b51566c4254673d3d','4e7a55354f4455334f4441344f413d3d','554574544a43516b5531525352555655','55326c325957746863326b3d','5647467461577767546d466b64513d3d','59326870644638784d5441784d6a41794d7a41324d7a51794e3138774d513d3d','4d6a557749454e5351554e4c52564a5449464e42566b6c4f5279425451306846545555674b446b67545739756447687365536b3d','10%','4e7a55354f4455334f4441344f413d3d','51575274615734784d6a4e41','0','0','0','0','0');


CREATE TABLE `demo_plan_category` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `category_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `lowercase_name` mediumtext NOT NULL,
  `ordering` int(11) NOT NULL,
  `show_frontend` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;


INSERT INTO demo_plan_category (id, created_date_time, creator, creator_name, category_id, name, lowercase_name, ordering, show_frontend, deleted) VALUES ('1','2023-01-14 06:00:32','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','51326870644342476457356b','593246305a576476636e6c664d5451774d5449774d6a4d774e6a41774d7a4a664d44453d','55306c4f5230784649464e4954315254','63326c755a32786c49484e6f6233527a','1','0','0');


CREATE TABLE `demo_plan_chit` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `chit_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `chit_name` mediumtext NOT NULL,
  `lower_case_chit_name` mediumtext NOT NULL,
  `maturity_value` mediumtext NOT NULL,
  `type` mediumtext NOT NULL,
  `due_amount` double NOT NULL,
  `due_duration` double NOT NULL,
  `due_days` int(100) NOT NULL,
  `due_reminder_days` int(100) NOT NULL,
  `payable_amount` double NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `last_date_to_join` date NOT NULL,
  `booking_open_date` date NOT NULL,
  `no_of_users` double NOT NULL,
  `chit_image` mediumtext NOT NULL,
  `penalty_duration` double NOT NULL,
  `penalty_value` mediumtext NOT NULL,
  `min_value` double NOT NULL,
  `max_value` double NOT NULL,
  `accept_advance_amount` int(100) NOT NULL,
  `accept_previous_due` int(100) NOT NULL,
  `allow_termination` int(100) NOT NULL,
  `termination_days` int(100) NOT NULL,
  `allow_split_up_due_payment` int(100) NOT NULL,
  `allow_agent` int(100) NOT NULL,
  `agent_commission` mediumtext NOT NULL,
  `add_transport_charges` int(100) NOT NULL,
  `allow_merge_completed_wallet` int(100) NOT NULL,
  `add_due_without_penalty` int(100) NOT NULL,
  `upi_id` mediumtext NOT NULL,
  `upi_id_image` mediumtext NOT NULL,
  `terms_conditions` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;


INSERT INTO demo_plan_chit (id, created_date_time, creator, creator_name, chit_id, name, chit_name, lower_case_chit_name, maturity_value, type, due_amount, due_duration, due_days, due_reminder_days, payable_amount, start_date, end_date, last_date_to_join, booking_open_date, no_of_users, chit_image, penalty_duration, penalty_value, min_value, max_value, accept_advance_amount, accept_previous_due, allow_termination, termination_days, allow_split_up_due_payment, allow_agent, agent_commission, add_transport_charges, allow_merge_completed_wallet, add_due_without_penalty, upi_id, upi_id_image, terms_conditions, deleted) VALUES ('1','2023-01-11 06:34:26','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','51326870644342476457356b','59326870644638784d5441784d6a41794d7a41324d7a51794e3138774d513d3d','4d6a557749454e5351554e4c52564a5449464e42566b6c4f52794254513068465455553d','4d6a557749454e5351554e4c52564a5449464e42566b6c4f5279425451306846545555674b446b67545739756447687365536b3d','4d6a557749474e7959574e725a584a7a49484e68646d6c755a79427a5932686c625755674b446b67545739756447687365536b3d','2500','545739756447687365513d3d','250','9','10','5','2250','2023-01-10','2023-10-10','2023-02-10','2023-10-11','100','chit_image_14_01_2023_05_21_59.webp','0','','0','0','1','1','2','0','2','1','10%','1','1','1','NULL','NULL','NULL','0');

INSERT INTO demo_plan_chit (id, created_date_time, creator, creator_name, chit_id, name, chit_name, lower_case_chit_name, maturity_value, type, due_amount, due_duration, due_days, due_reminder_days, payable_amount, start_date, end_date, last_date_to_join, booking_open_date, no_of_users, chit_image, penalty_duration, penalty_value, min_value, max_value, accept_advance_amount, accept_previous_due, allow_termination, termination_days, allow_split_up_due_payment, allow_agent, agent_commission, add_transport_charges, allow_merge_completed_wallet, add_due_without_penalty, upi_id, upi_id_image, terms_conditions, deleted) VALUES ('2','2023-01-14 06:08:03','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','51326870644342476457356b','59326870644638784e4441784d6a41794d7a41324d4467774d3138774d673d3d','4e54417749454e5351554e4c52564a5449464e42566b6c4f52794254513068465455553d','4e54417749454e5351554e4c52564a5449464e42566b6c4f5279425451306846545555674b446b67545739756447687365536b3d','4e54417749474e7959574e725a584a7a49484e68646d6c755a79427a5932686c625755674b446b67545739756447687365536b3d','5000','545739756447687365513d3d','500','9','10','5','4500','2023-01-10','2023-10-10','2023-02-10','2023-10-15','100','NULL','0','','0','0','2','2','2','0','2','2','0','2','2','2','NULL','NULL','NULL','0');


CREATE TABLE `demo_plan_city` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `state_name` mediumtext NOT NULL,
  `city_name` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;


INSERT INTO demo_plan_city (id, created_date_time, creator, creator_name, state_name, city_name, deleted) VALUES ('1','2023-01-06 13:01:05','','','Tamil Nadu','Sivakasi','0');


CREATE TABLE `demo_plan_company` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `company_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `logo` mediumtext NOT NULL,
  `address` mediumtext NOT NULL,
  `city` mediumtext NOT NULL,
  `pincode` mediumtext NOT NULL,
  `state` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `email` mediumtext NOT NULL,
  `gst_number` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;


INSERT INTO demo_plan_company (id, created_date_time, creator, creator_name, company_id, name, lower_case_name, logo, address, city, pincode, state, mobile_number, email, gst_number, deleted) VALUES ('1','2022-11-09 15:30:39','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','51326870644342476457356b','5932397463474675655638774f5445784d6a41794d6a417a4d7a417a4f5638774d513d3d','55334a7049464e686133526f61585a6c6243424761584a6c6432397961334d3d','63334a7049484e686133526f61585a6c6243426d61584a6c6432397961334d3d','logo_21_12_2022_07_09_31.webp','5457563064474674595778686153776755326c325957746863326b674c5342545958523064584967556d5173','55326c325957746863326b3d','4e6a49324d546735','5647467461577767546d466b64513d3d','4e7a55354f4455674e7a67774f44673d','63334a706332467264476870646d56735a6d6c795a586476636d747a5147647459576c734c6d4e7662513d3d','NULL','0');


CREATE TABLE `demo_plan_customer` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `customer_id` mediumtext NOT NULL,
  `customer_unique_number` mediumtext NOT NULL,
  `agent_id` mediumtext NOT NULL,
  `agent_details` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `address` mediumtext NOT NULL,
  `city` mediumtext NOT NULL,
  `state` mediumtext NOT NULL,
  `proof_type` mediumtext NOT NULL,
  `proof_number` mediumtext NOT NULL,
  `proof_image` mediumtext NOT NULL,
  `login_user_name` mediumtext NOT NULL,
  `password` mediumtext NOT NULL,
  `new_customer` int(100) NOT NULL,
  `fund_wallet` double NOT NULL,
  `merge_wallet` double NOT NULL,
  `total_wallet` double NOT NULL,
  `previously_in_fund` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;


INSERT INTO demo_plan_customer (id, created_date_time, creator, creator_name, customer_id, customer_unique_number, agent_id, agent_details, name, mobile_number, address, city, state, proof_type, proof_number, proof_image, login_user_name, password, new_customer, fund_wallet, merge_wallet, total_wallet, previously_in_fund, deleted) VALUES ('1','2023-01-14 05:34:21','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','51326870644342476457356b','5933567a644739745a584a664d5451774d5449774d6a4d774e544d304d6a46664d44453d','4d6a41794d304e56557a4178','NULL','NULL','5569354b51553542556c52495155354254673d3d','4e7a55354f4449344d6a6b7a4d513d3d','554574544a43516b5531525352555655','55326c325957746863326b3d','5647467461577767546d466b64513d3d','5433526f5a584a7a','4d54497a4d54493d','NULL','4e7a55354f4449344d6a6b7a4d513d3d','5955524e535534784d6a4e41','0','0','0','0','0','0');

INSERT INTO demo_plan_customer (id, created_date_time, creator, creator_name, customer_id, customer_unique_number, agent_id, agent_details, name, mobile_number, address, city, state, proof_type, proof_number, proof_image, login_user_name, password, new_customer, fund_wallet, merge_wallet, total_wallet, previously_in_fund, deleted) VALUES ('2','2023-01-14 05:37:10','5933567a644739745a584a664d5451774d5449774d6a4d774e544d334d5442664d44493d','51326870644342476457356b','5933567a644739745a584a664d5451774d5449774d6a4d774e544d334d5442664d44493d','4d6a41794d304e56557a4179','NULL','NULL','55314a4a49456842556b6b3d','4f4459784d4459784f5449334f413d3d','546b39535645676b4a43525456464a465256513d','55326c325957746863326b3d','5647467461577767546d466b64513d3d','5433526f5a584a7a','NULL','NULL','4f4459784d4459784f5449334f413d3d','5955524e535534784d6a4e41','0','250','0','250','0','0');


CREATE TABLE `demo_plan_customer_chit` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `customer_chit_id` mediumtext NOT NULL,
  `customer_chit_unique_number` mediumtext NOT NULL,
  `agent_id` mediumtext NOT NULL,
  `agent_details` mediumtext NOT NULL,
  `customer_id` mediumtext NOT NULL,
  `customer_details` mediumtext NOT NULL,
  `chit_id` mediumtext NOT NULL,
  `chit_details` mediumtext NOT NULL,
  `maturity_value` double NOT NULL,
  `chit_type` mediumtext NOT NULL,
  `due_amount` double NOT NULL,
  `due_duration` double NOT NULL,
  `due_days` int(100) NOT NULL,
  `due_reminder_days` int(100) NOT NULL,
  `payable_amount` double NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `booking_open_date` date NOT NULL,
  `penalty_duration` double NOT NULL,
  `penalty_value` mediumtext NOT NULL,
  `min_value` double NOT NULL,
  `max_value` double NOT NULL,
  `allow_split_up_due_payment` int(100) NOT NULL,
  `accept_advance_amount` int(100) NOT NULL,
  `accept_previous_due` int(100) NOT NULL,
  `allow_termination` int(100) NOT NULL,
  `termination_days` int(100) NOT NULL,
  `allow_agent` int(100) NOT NULL,
  `add_transport_charges` int(100) NOT NULL,
  `allow_merge_completed_wallet` int(100) NOT NULL,
  `add_due_without_penalty` int(100) NOT NULL,
  `completed_date` date NOT NULL,
  `due_count` int(100) NOT NULL,
  `last_paid_date` date NOT NULL,
  `next_due_date` date NOT NULL,
  `penalty_amount` double NOT NULL,
  `wallet` double NOT NULL,
  `commission` double NOT NULL,
  `amount_to_use_order_agent` double NOT NULL,
  `amount_to_use_order_customer` double NOT NULL,
  `account_merger_id` mediumtext NOT NULL,
  `order_id` mediumtext NOT NULL,
  `admin_approval` int(100) NOT NULL,
  `cancelled` int(100) NOT NULL,
  `cancel_date` date NOT NULL,
  `cancel_remarks` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;


INSERT INTO demo_plan_customer_chit (id, created_date_time, creator, creator_name, customer_chit_id, customer_chit_unique_number, agent_id, agent_details, customer_id, customer_details, chit_id, chit_details, maturity_value, chit_type, due_amount, due_duration, due_days, due_reminder_days, payable_amount, start_date, end_date, booking_open_date, penalty_duration, penalty_value, min_value, max_value, allow_split_up_due_payment, accept_advance_amount, accept_previous_due, allow_termination, termination_days, allow_agent, add_transport_charges, allow_merge_completed_wallet, add_due_without_penalty, completed_date, due_count, last_paid_date, next_due_date, penalty_amount, wallet, commission, amount_to_use_order_agent, amount_to_use_order_customer, account_merger_id, order_id, admin_approval, cancelled, cancel_date, cancel_remarks, deleted) VALUES ('1','2023-01-14 05:38:22','5933567a644739745a584a664d5451774d5449774d6a4d774e544d334d5442664d44493d','51326870644342476457356b','5933567a644739745a584a6659326870644638784e4441784d6a41794d7a41314d7a67794d6c38774d513d3d','4d6a41794d304e554d44453d','NULL','NULL','5933567a644739745a584a664d5451774d5449774d6a4d774e544d334d5442664d44493d','55314a4a49456842556b6b674b4467324d5441324d546b794e7a6770','59326870644638784d5441784d6a41794d7a41324d7a51794e3138774d513d3d','4d6a557749454e5351554e4c52564a5449464e42566b6c4f5279425451306846545555674b446b67545739756447687365536b3d','2500','545739756447687365513d3d','250','9','10','5','2250','2023-01-10','2023-10-10','2023-10-11','0','','0','0','2','1','1','2','0','1','1','1','1','0000-00-00','1','2023-01-14','2023-02-14','0','250','0','0','250','NULL','NULL','1','0','0000-00-00','NULL','0');

INSERT INTO demo_plan_customer_chit (id, created_date_time, creator, creator_name, customer_chit_id, customer_chit_unique_number, agent_id, agent_details, customer_id, customer_details, chit_id, chit_details, maturity_value, chit_type, due_amount, due_duration, due_days, due_reminder_days, payable_amount, start_date, end_date, booking_open_date, penalty_duration, penalty_value, min_value, max_value, allow_split_up_due_payment, accept_advance_amount, accept_previous_due, allow_termination, termination_days, allow_agent, add_transport_charges, allow_merge_completed_wallet, add_due_without_penalty, completed_date, due_count, last_paid_date, next_due_date, penalty_amount, wallet, commission, amount_to_use_order_agent, amount_to_use_order_customer, account_merger_id, order_id, admin_approval, cancelled, cancel_date, cancel_remarks, deleted) VALUES ('2','2023-01-14 05:56:40','5933567a644739745a584a664d5451774d5449774d6a4d774e544d304d6a46664d44453d','5569354b51553542556c52495155354254673d3d','5933567a644739745a584a6659326870644638784e4441784d6a41794d7a41314e5459304d4638774d673d3d','4d6a41794d304e554d44493d','NULL','NULL','5933567a644739745a584a664d5451774d5449774d6a4d774e544d304d6a46664d44453d','5569354b51553542556c5249515535425469416f4e7a55354f4449344d6a6b7a4d536b3d','59326870644638784d5441784d6a41794d7a41324d7a51794e3138774d513d3d','4d6a557749454e5351554e4c52564a5449464e42566b6c4f5279425451306846545555674b446b67545739756447687365536b3d','2500','545739756447687365513d3d','250','9','10','5','2250','2023-01-10','2023-10-10','2023-10-11','0','','0','0','2','1','1','2','0','1','1','1','1','0000-00-00','0','0000-00-00','0000-00-00','0','0','0','0','0','NULL','NULL','1','0','0000-00-00','NULL','0');

INSERT INTO demo_plan_customer_chit (id, created_date_time, creator, creator_name, customer_chit_id, customer_chit_unique_number, agent_id, agent_details, customer_id, customer_details, chit_id, chit_details, maturity_value, chit_type, due_amount, due_duration, due_days, due_reminder_days, payable_amount, start_date, end_date, booking_open_date, penalty_duration, penalty_value, min_value, max_value, allow_split_up_due_payment, accept_advance_amount, accept_previous_due, allow_termination, termination_days, allow_agent, add_transport_charges, allow_merge_completed_wallet, add_due_without_penalty, completed_date, due_count, last_paid_date, next_due_date, penalty_amount, wallet, commission, amount_to_use_order_agent, amount_to_use_order_customer, account_merger_id, order_id, admin_approval, cancelled, cancel_date, cancel_remarks, deleted) VALUES ('3','2023-01-14 06:10:35','5933567a644739745a584a664d5451774d5449774d6a4d774e544d304d6a46664d44453d','5569354b51553542556c52495155354254673d3d','5933567a644739745a584a6659326870644638784e4441784d6a41794d7a41324d54417a4e5638774d773d3d','4d6a41794d304e554d444d3d','NULL','NULL','5933567a644739745a584a664d5451774d5449774d6a4d774e544d304d6a46664d44453d','5569354b51553542556c5249515535425469416f4e7a55354f4449344d6a6b7a4d536b3d','59326870644638784e4441784d6a41794d7a41324d4467774d3138774d673d3d','4e54417749454e5351554e4c52564a5449464e42566b6c4f5279425451306846545555674b446b67545739756447687365536b3d','5000','545739756447687365513d3d','500','9','10','5','4500','2023-01-10','2023-10-10','2023-10-15','0','','0','0','2','2','2','2','0','2','2','2','2','0000-00-00','0','0000-00-00','0000-00-00','0','0','0','0','0','NULL','NULL','1','0','0000-00-00','NULL','0');

INSERT INTO demo_plan_customer_chit (id, created_date_time, creator, creator_name, customer_chit_id, customer_chit_unique_number, agent_id, agent_details, customer_id, customer_details, chit_id, chit_details, maturity_value, chit_type, due_amount, due_duration, due_days, due_reminder_days, payable_amount, start_date, end_date, booking_open_date, penalty_duration, penalty_value, min_value, max_value, allow_split_up_due_payment, accept_advance_amount, accept_previous_due, allow_termination, termination_days, allow_agent, add_transport_charges, allow_merge_completed_wallet, add_due_without_penalty, completed_date, due_count, last_paid_date, next_due_date, penalty_amount, wallet, commission, amount_to_use_order_agent, amount_to_use_order_customer, account_merger_id, order_id, admin_approval, cancelled, cancel_date, cancel_remarks, deleted) VALUES ('4','2023-01-14 06:12:00','5933567a644739745a584a664d5451774d5449774d6a4d774e544d304d6a46664d44453d','51326870644342476457356b','5933567a644739745a584a6659326870644638784e4441784d6a41794d7a41324d5449774d4638774e413d3d','4d6a41794d304e554d44513d','NULL','NULL','5933567a644739745a584a664d5451774d5449774d6a4d774e544d304d6a46664d44453d','5569354b51553542556c5249515535425469416f4e7a55354f4449344d6a6b7a4d536b3d','59326870644638784d5441784d6a41794d7a41324d7a51794e3138774d513d3d','4d6a557749454e5351554e4c52564a5449464e42566b6c4f5279425451306846545555674b446b67545739756447687365536b3d','2500','545739756447687365513d3d','250','9','10','5','2250','2023-01-10','2023-10-10','2023-10-11','0','','0','0','2','1','1','2','0','1','1','1','1','0000-00-00','0','0000-00-00','0000-00-00','0','0','0','0','0','NULL','NULL','1','0','0000-00-00','NULL','0');


CREATE TABLE `demo_plan_customer_chit_merge` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `merge_request_id` mediumtext NOT NULL,
  `customer_chit_unique_number` mediumtext NOT NULL,
  `customer_chit_id` mediumtext NOT NULL,
  `wallet` double NOT NULL,
  `admin_approval` int(100) NOT NULL,
  `cancelled` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



CREATE TABLE `demo_plan_login` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `loginer_name` mediumtext NOT NULL,
  `login_date_time` datetime NOT NULL,
  `logout_date_time` datetime NOT NULL,
  `ip_address` mediumtext NOT NULL,
  `browser` mediumtext NOT NULL,
  `os_detail` mediumtext NOT NULL,
  `type` mediumtext NOT NULL,
  `user_id` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4;


INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('1','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-04 18:05:20','2023-01-04 18:05:50','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Windows NT DESKTOP-1O194FK 10.0 build 19045 (Windows 10) AMD64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('2','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-06 12:47:33','2023-01-06 12:47:49','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Windows NT DESKTOP-1O194FK 10.0 build 19045 (Windows 10) AMD64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('3','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-06 12:58:08','2023-01-06 12:58:51','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Windows NT DESKTOP-1O194FK 10.0 build 19045 (Windows 10) AMD64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('4','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-06 13:00:19','0000-00-00 00:00:00','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Windows NT DESKTOP-1O194FK 10.0 build 19045 (Windows 10) AMD64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('5','55326868626d31315a324567554746755a476c686269416f4e7a41784d4467334e5467784e436b3d','2023-01-06 13:02:41','2023-01-06 13:04:11','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Windows NT DESKTOP-1O194FK 10.0 build 19045 (Windows 10) AMD64','Customer','5933567a644739745a584a664d4459774d5449774d6a4d774d5441794d6a64664d44453d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('6','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-06 13:04:17','2023-01-06 13:06:44','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Windows NT DESKTOP-1O194FK 10.0 build 19045 (Windows 10) AMD64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('7','55326868626d31315a324567554746755a476c686269416f4e7a41784d4467334e5467784e436b3d','2023-01-06 13:07:02','2023-01-06 13:07:12','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Windows NT DESKTOP-1O194FK 10.0 build 19045 (Windows 10) AMD64','Customer','5933567a644739745a584a664d4459774d5449774d6a4d774d5441794d6a64664d44453d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('8','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-06 17:23:38','2023-01-06 18:00:07','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Windows NT DESKTOP-1O194FK 10.0 build 19045 (Windows 10) AMD64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('9','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-07 11:53:27','2023-01-07 11:53:39','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Windows NT DESKTOP-1O194FK 10.0 build 19045 (Windows 10) AMD64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('10','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-07 11:53:44','0000-00-00 00:00:00','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Windows NT DESKTOP-1O194FK 10.0 build 19045 (Windows 10) AMD64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('11','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-07 20:01:53','2023-01-07 20:02:00','103.104.68.138','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Linux sg2plzcpnl479129.prod.sin2.secureserver.net 2.6.32-954.3.5.lve1.4.86.el6.x86_64 #1 SMP Tue Aug 31 17:08:39 UTC 2021 x86_64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('12','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-11 06:12:14','0000-00-00 00:00:00','144.48.49.120','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Linux sg2plzcpnl479129.prod.sin2.secureserver.net 2.6.32-954.3.5.lve1.4.86.el6.x86_64 #1 SMP Tue Aug 31 17:08:39 UTC 2021 x86_64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('13','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-11 12:05:32','2023-01-11 12:05:40','103.104.68.152','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36','Linux sg2plzcpnl479129.prod.sin2.secureserver.net 2.6.32-954.3.5.lve1.4.86.el6.x86_64 #1 SMP Tue Aug 31 17:08:39 UTC 2021 x86_64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('14','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-14 05:08:14','2023-01-14 05:29:16','223.187.125.246','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Linux sg2plzcpnl479129.prod.sin2.secureserver.net 2.6.32-954.3.5.lve1.4.86.el6.x86_64 #1 SMP Tue Aug 31 17:08:39 UTC 2021 x86_64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('15','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-14 05:30:46','0000-00-00 00:00:00','223.187.125.246','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Linux sg2plzcpnl479129.prod.sin2.secureserver.net 2.6.32-954.3.5.lve1.4.86.el6.x86_64 #1 SMP Tue Aug 31 17:08:39 UTC 2021 x86_64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('16','55314a4a49456842556b6b674b4467324d5441324d546b794e7a6770','2023-01-14 05:37:47','0000-00-00 00:00:00','223.187.125.246','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Linux sg2plzcpnl479129.prod.sin2.secureserver.net 2.6.32-954.3.5.lve1.4.86.el6.x86_64 #1 SMP Tue Aug 31 17:08:39 UTC 2021 x86_64','Customer','5933567a644739745a584a664d5451774d5449774d6a4d774e544d334d5442664d44493d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('17','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-14 05:41:39','2023-01-14 05:43:21','223.187.125.246','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Linux sg2plzcpnl479129.prod.sin2.secureserver.net 2.6.32-954.3.5.lve1.4.86.el6.x86_64 #1 SMP Tue Aug 31 17:08:39 UTC 2021 x86_64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('18','55314a4a49456842556b6b674b4467324d5441324d546b794e7a6770','2023-01-14 05:43:57','0000-00-00 00:00:00','223.187.125.246','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Linux sg2plzcpnl479129.prod.sin2.secureserver.net 2.6.32-954.3.5.lve1.4.86.el6.x86_64 #1 SMP Tue Aug 31 17:08:39 UTC 2021 x86_64','Customer','5933567a644739745a584a664d5451774d5449774d6a4d774e544d334d5442664d44493d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('19','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-14 05:51:50','2023-01-14 05:54:42','223.187.125.246','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Linux sg2plzcpnl479129.prod.sin2.secureserver.net 2.6.32-954.3.5.lve1.4.86.el6.x86_64 #1 SMP Tue Aug 31 17:08:39 UTC 2021 x86_64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('20','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-14 05:55:43','0000-00-00 00:00:00','223.187.125.246','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Linux sg2plzcpnl479129.prod.sin2.secureserver.net 2.6.32-954.3.5.lve1.4.86.el6.x86_64 #1 SMP Tue Aug 31 17:08:39 UTC 2021 x86_64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('21','5569354b51553542556c5249515535425469416f4e7a55354f4449344d6a6b7a4d536b3d','2023-01-14 05:56:23','2023-01-14 05:58:03','223.187.125.246','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Linux sg2plzcpnl479129.prod.sin2.secureserver.net 2.6.32-954.3.5.lve1.4.86.el6.x86_64 #1 SMP Tue Aug 31 17:08:39 UTC 2021 x86_64','Customer','5933567a644739745a584a664d5451774d5449774d6a4d774e544d304d6a46664d44453d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('22','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-14 05:58:49','2023-01-14 06:09:26','223.187.125.246','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Linux sg2plzcpnl479129.prod.sin2.secureserver.net 2.6.32-954.3.5.lve1.4.86.el6.x86_64 #1 SMP Tue Aug 31 17:08:39 UTC 2021 x86_64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('23','5569354b51553542556c5249515535425469416f4e7a55354f4449344d6a6b7a4d536b3d','2023-01-14 06:10:18','0000-00-00 00:00:00','223.187.125.246','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Linux sg2plzcpnl479129.prod.sin2.secureserver.net 2.6.32-954.3.5.lve1.4.86.el6.x86_64 #1 SMP Tue Aug 31 17:08:39 UTC 2021 x86_64','Customer','5933567a644739745a584a664d5451774d5449774d6a4d774e544d304d6a46664d44453d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('24','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-14 06:12:51','2023-01-14 06:13:47','223.187.125.246','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Linux sg2plzcpnl479129.prod.sin2.secureserver.net 2.6.32-954.3.5.lve1.4.86.el6.x86_64 #1 SMP Tue Aug 31 17:08:39 UTC 2021 x86_64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');

INSERT INTO demo_plan_login (id, loginer_name, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('25','51326870644342476457356b494367334e5441794d6a45774f444d314b513d3d','2023-01-14 12:26:21','0000-00-00 00:00:00','103.104.68.175','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:108.0) Gecko/20100101 Firefox/108.0','Linux sg2plzcpnl479129.prod.sin2.secureserver.net 2.6.32-954.3.5.lve1.4.86.el6.x86_64 #1 SMP Tue Aug 31 17:08:39 UTC 2021 x86_64','Admin','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','0');


CREATE TABLE `demo_plan_orders` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `order_id` mediumtext NOT NULL,
  `order_number` mediumtext NOT NULL,
  `order_date` date NOT NULL,
  `company_details` mediumtext NOT NULL,
  `agent_id` mediumtext NOT NULL,
  `customer_id` mediumtext NOT NULL,
  `customer_name` mediumtext NOT NULL,
  `customer_mobile_number` mediumtext NOT NULL,
  `customer_city` mediumtext NOT NULL,
  `customer_state` mediumtext NOT NULL,
  `customer_details` mediumtext NOT NULL,
  `delivery_address` mediumtext NOT NULL,
  `customer_chit_ids` mediumtext NOT NULL,
  `customer_chit_details` mediumtext NOT NULL,
  `category_id` mediumtext NOT NULL,
  `category_name` mediumtext NOT NULL,
  `product_id` mediumtext NOT NULL,
  `product_code` mediumtext NOT NULL,
  `product_name` mediumtext NOT NULL,
  `product_content` mediumtext NOT NULL,
  `quantity` mediumtext NOT NULL,
  `price` mediumtext NOT NULL,
  `discount` mediumtext NOT NULL,
  `packing_charges` mediumtext NOT NULL,
  `packing_charges_option` int(100) NOT NULL,
  `total_amount` mediumtext NOT NULL,
  `new_order` int(100) NOT NULL,
  `confirmed` int(100) NOT NULL,
  `chit_ids` mediumtext NOT NULL,
  `despatched` int(100) NOT NULL,
  `delivered` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



CREATE TABLE `demo_plan_orders_chit` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `order_id` mediumtext NOT NULL,
  `agent_id` mediumtext NOT NULL,
  `customer_id` mediumtext NOT NULL,
  `customer_chit_id` mediumtext NOT NULL,
  `amount` double NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



CREATE TABLE `demo_plan_orders_despatch` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `order_number` mediumtext NOT NULL,
  `despatch_date` date NOT NULL,
  `lr_number` mediumtext NOT NULL,
  `transport_name` mediumtext NOT NULL,
  `transfer_details` mediumtext NOT NULL,
  `lr_number_image` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



CREATE TABLE `demo_plan_otp_send_phone_numbers` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `send_date` date NOT NULL,
  `phone_number` mediumtext NOT NULL,
  `otp_number` double NOT NULL,
  `otp_send_count` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;


INSERT INTO demo_plan_otp_send_phone_numbers (id, send_date, phone_number, otp_number, otp_send_count, deleted) VALUES ('1','2023-01-14','8610619278','4591','1','0');


CREATE TABLE `demo_plan_private_settings` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `name` mediumtext NOT NULL,
  `value` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4;


INSERT INTO demo_plan_private_settings (id, name, value, deleted) VALUES ('1','allow_booking','1','0');

INSERT INTO demo_plan_private_settings (id, name, value, deleted) VALUES ('2','allow_discount','2','0');

INSERT INTO demo_plan_private_settings (id, name, value, deleted) VALUES ('3','allow_sms','1','0');

INSERT INTO demo_plan_private_settings (id, name, value, deleted) VALUES ('4','sms_count','3000','0');

INSERT INTO demo_plan_private_settings (id, name, value, deleted) VALUES ('5','due_reminder_secret_key','4f5467334e6a55304d7a49784d413d3d','0');


CREATE TABLE `demo_plan_product` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `product_id` mediumtext NOT NULL,
  `category_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `lowercase_name` mediumtext NOT NULL,
  `product_code` mediumtext NOT NULL,
  `product_content` mediumtext NOT NULL,
  `price` mediumtext NOT NULL,
  `product_image` mediumtext NOT NULL,
  `product_video` mediumtext NOT NULL,
  `ordering` int(100) NOT NULL,
  `show_frontend` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;


INSERT INTO demo_plan_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lowercase_name, product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('1','2023-01-14 06:02:22','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','51326870644342476457356b','55464a5052465644564638784e4441784d6a41794d7a41324d4449794d6c38774d513d3d','593246305a576476636e6c664d5451774d5449774d6a4d774e6a41774d7a4a664d44453d','4e69424d515574545345314a','4e6942735957747a61473170','4d513d3d','4e53425155773d3d','50','NULL','NULL','1','0','0');


CREATE TABLE `demo_plan_receipt` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `receipt_id` mediumtext NOT NULL,
  `receipt_unique_number` mediumtext NOT NULL,
  `receipt_date` date NOT NULL,
  `agent_id` mediumtext NOT NULL,
  `agent_details` mediumtext NOT NULL,
  `agent_commission` double NOT NULL,
  `customer_id` mediumtext NOT NULL,
  `customer_details` mediumtext NOT NULL,
  `receipter_details` mediumtext NOT NULL,
  `customer_chit_id` mediumtext NOT NULL,
  `customer_chit_details` mediumtext NOT NULL,
  `chit_due_amount` double NOT NULL,
  `chit_due_count` int(100) NOT NULL,
  `amount` double NOT NULL,
  `penalty_amount` double NOT NULL,
  `total_amount` double NOT NULL,
  `split_up_amount` int(100) NOT NULL,
  `payment_mode` mediumtext NOT NULL,
  `transaction_id` mediumtext NOT NULL,
  `transaction_screenshot` mediumtext NOT NULL,
  `admin_approval` int(100) NOT NULL,
  `later_due` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;


INSERT INTO demo_plan_receipt (id, created_date_time, creator, creator_name, receipt_id, receipt_unique_number, receipt_date, agent_id, agent_details, agent_commission, customer_id, customer_details, receipter_details, customer_chit_id, customer_chit_details, chit_due_amount, chit_due_count, amount, penalty_amount, total_amount, split_up_amount, payment_mode, transaction_id, transaction_screenshot, admin_approval, later_due, deleted) VALUES ('1','2023-01-14 05:49:22','5933567a644739745a584a664d5451774d5449774d6a4d774e544d334d5442664d44493d','51326870644342476457356b','636d566a5a576c77644638784e4441784d6a41794d7a41314e446b794d6c38774d513d3d','4d6a41794d314a5156444178','2023-01-14','NULL','NULL','0','5933567a644739745a584a664d5451774d5449774d6a4d774e544d334d5442664d44493d','55314a4a49456842556b6b674b4467324d5441324d546b794e7a6770','55314a4a49456842556b6b6d62485137596e496d5a335137546b39535645676d62485137596e496d5a33513755315253525556554a6d78304f324a794a6d64304f314e70646d467259584e704c434255595731706243424f59575231','5933567a644739745a584a6659326870644638784e4441784d6a41794d7a41314d7a67794d6c38774d513d3d','4d6a41794d304e554d44456d62485137596e496d5a3351374d6a557749454e5351554e4c52564a5449464e42566b6c4f5279425451306846545555674b446b67545739756447687365536b3d','1','1','250','0','250','2','5132467a61413d3d','NULL','NULL','1','0','0');


CREATE TABLE `demo_plan_settings` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `name` mediumtext NOT NULL,
  `value` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4;


INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('1','backend_theme_color','#800000','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('2','backend_theme_text_color','#ffffff','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('3','frontend_theme_color','#800000','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('4','frontend_theme_text_color','#ffffff','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('5','current_year_diwali_date','14-11-2023','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('6','allow_excess_wallet_amount_purchase','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('7','transport_charges_option','2','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('8','admin_forgot_password_otp_sms','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('9','frontend_new_customer_register_sms','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('10','request_sms_for_joining_chit','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('11','request_sms_for_receipt_created_user','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('12','request_sms_for_merging_chit','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('13','booking_sms_from_user','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('14','agent_forgot_password_otp_sms','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('15','customer_register_otp_sms','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('16','customer_forgot_password_otp_sms','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('17','approval_sms_for_joining_chit','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('18','approval_sms_for_receipt_created_user','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('19','approval_sms_for_merging_chit','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('20','due_amount_paid_sms_to_user','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('21','due_reminder_sms_to_user','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('22','chit_close_sms_to_user','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('23','terminate_from_chit_sms_to_user','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('24','booking_opening_date_sms_to_user','1','0');

INSERT INTO demo_plan_settings (id, name, value, deleted) VALUES ('25','delivery_sms_to_user','1','0');


CREATE TABLE `demo_plan_shipping_address` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `shipping_address_id` mediumtext NOT NULL,
  `agent_id` mediumtext NOT NULL,
  `customer_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `address` mediumtext NOT NULL,
  `city` mediumtext NOT NULL,
  `state` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



CREATE TABLE `demo_plan_sms_count` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `sms_type` mediumtext NOT NULL,
  `sms_count` double NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4;


INSERT INTO demo_plan_sms_count (id, sms_type, sms_count, deleted) VALUES ('1','frontend_new_customer_register_sms','1','0');

INSERT INTO demo_plan_sms_count (id, sms_type, sms_count, deleted) VALUES ('2','request_sms_for_joining_chit','4','0');

INSERT INTO demo_plan_sms_count (id, sms_type, sms_count, deleted) VALUES ('3','approval_sms_for_joining_chit','4','0');

INSERT INTO demo_plan_sms_count (id, sms_type, sms_count, deleted) VALUES ('4','request_sms_for_receipt_created_user','1','0');

INSERT INTO demo_plan_sms_count (id, sms_type, sms_count, deleted) VALUES ('5','approval_sms_for_receipt_created_user','1','0');

INSERT INTO demo_plan_sms_count (id, sms_type, sms_count, deleted) VALUES ('6','due_amount_paid_sms_to_user','1','0');


CREATE TABLE `demo_plan_sms_histroy` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `send_date` date NOT NULL,
  `sms_type` mediumtext NOT NULL,
  `action` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4;


INSERT INTO demo_plan_sms_histroy (id, send_date, sms_type, action, deleted) VALUES ('1','2023-01-14','user_forgot_password_otp_sms','4e4455354d587854636d6b675532467264476870646d567349455a70636d563362334a7263773d3d','0');

INSERT INTO demo_plan_sms_histroy (id, send_date, sms_type, action, deleted) VALUES ('2','2023-01-14','frontend_new_customer_register_sms','556d566e61584e305a584a6c5a487854556b6b6753454653535877344e6a45774e6a45354d6a633466464e70646d467259584e704c434255595731706243424f59575231','0');

INSERT INTO demo_plan_sms_histroy (id, send_date, sms_type, action, deleted) VALUES ('3','2023-01-14','request_sms_for_joining_chit','5132687064487854556b6b67534546535353416f4f4459784d4459784f5449334f436c384d6a41794d304e554d4445674c5341794e54416751314a4251307446556c4d67553046575355354849464e445345564e5253416f4f53424e62323530614778354b513d3d','0');

INSERT INTO demo_plan_sms_histroy (id, send_date, sms_type, action, deleted) VALUES ('4','2023-01-14','approval_sms_for_joining_chit','4d6a557749454e5351554e4c52564a5449464e42566b6c4f5279425451306846545555674b446b67545739756447687365536c384d6a41794d304e554d44463855334a7049464e686133526f61585a6c6243424761584a6c6432397961334d3d','0');

INSERT INTO demo_plan_sms_histroy (id, send_date, sms_type, action, deleted) VALUES ('5','2023-01-14','request_sms_for_receipt_created_user','51574e72626d39336247566b5a3256745a573530664449774d6a4e53554651774d587854556b6b67534546535353416f4f4459784d4459784f5449334f436c384d6a557749454e5351554e4c52564a5449464e42566b6c4f5279425451306846545555674b446b67545739756447687365536b3d','0');

INSERT INTO demo_plan_sms_histroy (id, send_date, sms_type, action, deleted) VALUES ('6','2023-01-14','approval_sms_for_receipt_created_user','55314a4a49456842556b6c384d6a557749454e5351554e4c52564a5449464e42566b6c4f5279425451306846545555674b446b67545739756447687365536c384d6a41794d314a515644417866464e79615342545957743061476c325a577767526d6c795a586476636d747a','0');

INSERT INTO demo_plan_sms_histroy (id, send_date, sms_type, action, deleted) VALUES ('7','2023-01-14','due_amount_paid_sms_to_user','55314a4a49456842556b6c384d6a557749454e5351554e4c52564a5449464e42566b6c4f5279425451306846545555674b446b67545739756447687365536c384d6a41794d314a515644417866464e79615342545957743061476c325a577767526d6c795a586476636d747a','0');

INSERT INTO demo_plan_sms_histroy (id, send_date, sms_type, action, deleted) VALUES ('8','2023-01-14','request_sms_for_joining_chit','51326870644878534c6b7042546b465356456842546b464f494367334e546b344d6a67794f544d784b5877794d44497a513151774d694174494449314d434244556b4644533056535579425451565a4a546b636755304e49525531464943673549453176626e526f62486b70','0');

INSERT INTO demo_plan_sms_histroy (id, send_date, sms_type, action, deleted) VALUES ('9','2023-01-14','approval_sms_for_joining_chit','4d6a557749454e5351554e4c52564a5449464e42566b6c4f5279425451306846545555674b446b67545739756447687365536c384d6a41794d304e554d444a3855334a7049464e686133526f61585a6c6243424761584a6c6432397961334d3d','0');

INSERT INTO demo_plan_sms_histroy (id, send_date, sms_type, action, deleted) VALUES ('10','2023-01-14','request_sms_for_joining_chit','51326870644878534c6b7042546b465356456842546b464f494367334e546b344d6a67794f544d784b5877794d44497a513151774d794174494455774d434244556b4644533056535579425451565a4a546b636755304e49525531464943673549453176626e526f62486b70','0');

INSERT INTO demo_plan_sms_histroy (id, send_date, sms_type, action, deleted) VALUES ('11','2023-01-14','approval_sms_for_joining_chit','4e54417749454e5351554e4c52564a5449464e42566b6c4f5279425451306846545555674b446b67545739756447687365536c384d6a41794d304e554d444e3855334a7049464e686133526f61585a6c6243424761584a6c6432397961334d3d','0');

INSERT INTO demo_plan_sms_histroy (id, send_date, sms_type, action, deleted) VALUES ('12','2023-01-14','request_sms_for_joining_chit','51326870644878534c6b7042546b465356456842546b464f494367334e546b344d6a67794f544d784b5877794d44497a513151774e434174494449314d434244556b4644533056535579425451565a4a546b636755304e49525531464943673549453176626e526f62486b70','0');

INSERT INTO demo_plan_sms_histroy (id, send_date, sms_type, action, deleted) VALUES ('13','2023-01-14','approval_sms_for_joining_chit','4d6a557749454e5351554e4c52564a5449464e42566b6c4f5279425451306846545555674b446b67545739756447687365536c384d6a41794d304e554d44523855334a7049464e686133526f61585a6c6243424761584a6c6432397961334d3d','0');


CREATE TABLE `demo_plan_state` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `state_name` mediumtext NOT NULL,
  `transport_charges` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;


INSERT INTO demo_plan_state (id, created_date_time, creator, creator_name, state_name, transport_charges, deleted) VALUES ('1','2023-01-06 13:00:30','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','51326870644342476457356b','Tamil Nadu','250','0');

INSERT INTO demo_plan_state (id, created_date_time, creator, creator_name, state_name, transport_charges, deleted) VALUES ('2','2023-01-11 06:14:33','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','51326870644342476457356b','Andhra Pradesh','350','0');


CREATE TABLE `demo_plan_user` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `user_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `user_login_id` mediumtext NOT NULL,
  `password` mediumtext NOT NULL,
  `admin` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;


INSERT INTO demo_plan_user (id, created_date_time, creator, creator_name, user_id, name, mobile_number, user_login_id, password, admin, deleted) VALUES ('1','2022-11-09 15:05:12','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','52476c335957787049454e6f6158513d','56564e46556c38774f5445784d6a41794d6a45314d4455784d6c38774d513d3d','51326870644342476457356b','4e7a55774d6a49784d44677a4e513d3d','55314a4a5530394756466442556b5661','51575274615734784d6a4e41','1','0');


CREATE TABLE `demo_plan_voucher` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `voucher_id` mediumtext NOT NULL,
  `voucher_unique_number` mediumtext NOT NULL,
  `voucher_date` date NOT NULL,
  `agent_id` mediumtext NOT NULL,
  `agent_details` mediumtext NOT NULL,
  `voucher_details` mediumtext NOT NULL,
  `customer_chit_id` mediumtext NOT NULL,
  `customer_chit_details` mediumtext NOT NULL,
  `amount` double NOT NULL,
  `payment_mode` mediumtext NOT NULL,
  `transaction_id` mediumtext NOT NULL,
  `transaction_screenshot` mediumtext NOT NULL,
  `remarks` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

