<?php
    include("../include.php");
	
	$chit_list = array();
	$chit_list = $obj->getTerminateCustomerChitList();
    
    $company_list = array();
    $company_list = $obj->getTableRecords($GLOBALS['company_table'], '', '');

    foreach($company_list as $data){
        $company_name = ""; $company_address = ""; $company_mobile = ""; $company_email = ""; $logo = "";

        if(!empty($data['name'])) {
            $company_name = $obj->encode_decode('decrypt', $data['name']);
        }
        if(!empty($data['logo']) && $data['logo'] != $GLOBALS['null_value']) {
            $logo = $data['logo'];
        }
        if(!empty($data['address']) && $data['address'] != $GLOBALS['null_value']) {
            $company_address = $obj->encode_decode('decrypt', $data['address']);
            $company_address = str_replace("$$$", " ", $company_address);
        }
        if(!empty($data['mobile_number'])) {
            $company_mobile = $obj->encode_decode('decrypt', $data['mobile_number']);
        }
        if(!empty($data['email'])) {
            $company_email = $obj->encode_decode('decrypt', $data['email']);
        }
    }

    $target_dir = '../include/images/upload/';

    require_once('../fpdf/fpdf.php');
    $pdf = new FPDF('P','mm','A4');
    $pdf->AliasNbPages(); 
    $pdf->AddPage();
    $pdf->SetAutoPageBreak(true);
    $pdf->SetTitle('Customer Chit List');
    $pdf->SetFont('Arial','B',10);
    $pdf->SetY(10);
    $pdf->Cell(0,5,strtoupper($company_name),0,1,'C',0);
    $pdf->SetFont('Arial','',7);
    $pdf->Cell(0,4,$company_address,0,1,'C',0);
    $pdf->Cell(0,4,'E-mail : '.$company_email.'   Phone : '.$company_mobile,0,1,'C',0);
        
    if(!empty($logo) && file_exists($target_dir.$logo)){
        $pdf->Image($target_dir.$logo,10,7,25,20);
    }
    
    $pdf->SetY(7);
    $pdf->Cell(0,20,'',1,1,'L',0);
    $pdf->SetFont('Arial','B',9);
    $pdf->Cell(0,6,'Customer Chit List',1,1,'C',0);
    $pdf->SetFont('Arial','B',8);
    $pdf->SetX(10);
    $pdf->Cell(10,5,'S.No',1,0,'C',0);
    $pdf->SetX(20);
    $pdf->Cell(25,5,'Agent',1,0,'C',0);
    $pdf->SetX(45);
    $pdf->Cell(25,5,'Customer',1,0,'C',0);
    $pdf->SetX(70);
    $pdf->Cell(20,5,'Chit ID',1,0,'C',0);
    $pdf->SetX(90);
    $pdf->Cell(30,5,'Chit Name',1,0,'C',0);
    $pdf->SetX(120);
    $pdf->Cell(20,5,'Wallet',1,0,'C',0);
    $pdf->SetX(140);
    $pdf->Cell(20,5,'Last Paid Date',1,0,'C',0);
    $pdf->SetX(160);
    $pdf->Cell(20,5,'Cancel Date',1,0,'C',0);
    $pdf->SetX(180);
    $pdf->Cell(20,5,'No.of Days',1,1,'C',0);
    $pdf->SetFont('Arial','',8);

    if(!empty($chit_list)) {
        $sno = 1;
        foreach($chit_list as $data) {
            if($pdf->GetY()>260){
                $pdf->SetY(-10);
                $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);
                $pdf->AddPage();
                $pdf->SetFont('Arial','B',10);
                $pdf->SetY(10);
                $pdf->Cell(0,5,strtoupper($company_name),0,1,'C',0);
                $pdf->SetFont('Arial','',7);
                $pdf->Cell(0,4,$company_address,0,1,'C',0);
                $pdf->Cell(0,4,'E-mail : '.$company_email.'   Phone : '.$company_mobile,0,1,'C',0);

                if(!empty($logo) && file_exists($target_dir.$logo)){
                    $pdf->Image($target_dir.$logo,10,7,25,20);
                }
                
                $pdf->SetY(7);
                $pdf->Cell(0,20,'',1,1,'L',0);
                $pdf->SetFont('Arial','B',9);
                $pdf->Cell(0,6,'Customer Chit List',1,1,'C',0);
                $pdf->SetFont('Arial','B',8);
                $pdf->SetX(10);
                $pdf->Cell(10,5,'S.No',1,0,'C',0);
                $pdf->SetX(20);
                $pdf->Cell(25,5,'Agent',1,0,'C',0);
                $pdf->SetX(45);
                $pdf->Cell(25,5,'Customer',1,0,'C',0);
                $pdf->SetX(70);
                $pdf->Cell(20,5,'Chit ID',1,0,'C',0);
                $pdf->SetX(90);
                $pdf->Cell(30,5,'Chit Name',1,0,'C',0);
                $pdf->SetX(120);
                $pdf->Cell(20,5,'Wallet',1,0,'C',0);
                $pdf->SetX(140);
                $pdf->Cell(20,5,'Last Paid Date',1,0,'C',0);
                $pdf->SetX(160);
                $pdf->Cell(20,5,'Cancel Date',1,0,'C',0);
                $pdf->SetX(180);
                $pdf->Cell(20,5,'No.of Days',1,1,'C',0);
                $pdf->SetFont('Arial','',8);
            }

            $agent_details = ""; $customer_details = ""; $customer_chit_unique_number = ""; $chit_details = ""; $wallet = ""; $last_paid_date = ""; $cancel_date = "";

            if(!empty($data['created_date_time']) && $data['created_date_time'] != "0000-00-00 00:00:00") { 
                $created_date = date("d-m-Y", strtotime($data['created_date_time'])); 
            }
            if(!empty($data['agent_details']) && $data['agent_details'] != $GLOBALS['null_value']) {
                $agent_details = $obj->encode_decode('decrypt', $data['agent_details']);
            }
            if(!empty($data['customer_details']) && $data['customer_details'] != $GLOBALS['null_value']) {
                $customer_details = $obj->encode_decode('decrypt', $data['customer_details']);                
            }
            
            if(!empty($data['customer_chit_unique_number'])) {
                $customer_chit_unique_number = $obj->encode_decode('decrypt', $data['customer_chit_unique_number']);
            }
            if(!empty($data['chit_details'])) {
                $chit_details = $obj->encode_decode('decrypt', $data['chit_details']);
            }

            if(!empty($data['amount_to_use_order_customer'])) {
                $wallet = $obj->truncate_number($data['amount_to_use_order_customer'], 2);
            }
            else if(!empty($data['amount_to_use_order_agent'])) {
                $wallet = $obj->truncate_number($data['amount_to_use_order_agent'], 2);
            }

            if(!empty($data['last_paid_date']) && $data['last_paid_date'] != "0000-00-00") {
                $last_paid_date = date("d-m-Y", strtotime($data['last_paid_date']));
            }
            if(!empty($data['cancel_date']) && $data['cancel_date'] != "0000-00-00") {
                $cancel_date = date("d-m-Y", strtotime($data['cancel_date']));
            }

            $numOfDays = 0;
            if(!empty($last_paid_date) && !empty($cancel_date)) {
                $dateDiff   = strtotime($cancel_date) - strtotime($last_paid_date);							
				$numOfDays  = $dateDiff / 86400;
            }

            $yaxis = $pdf->GetY();
            $pdf->SetX(10);
            $pdf->Cell(10,5,$sno,0,0,'C',0);
            $pdf->SetX(20);
            $pdf->MultiCell(25,5,$agent_details,0,'C',0);
            $agent_height = $pdf->GetY();
            $pdf->SetY($yaxis);
            $pdf->SetX(45);
            $pdf->MultiCell(25,5,$customer_details,0,'C',0);
            $customer_height = $pdf->GetY();
            $pdf->SetY($yaxis);
            $pdf->SetX(70);
            $pdf->Cell(20,5,$customer_chit_unique_number,0,0,'C',0);       
            $pdf->SetX(90);
            $pdf->MultiCell(30,5,$chit_details,0,'C',0);
            $chit_height = $pdf->GetY();
            $pdf->SetY($yaxis);
            $pdf->SetX(120);
            $pdf->Cell(20,5,$wallet,0,0,'C',0);
            $pdf->SetX(140);
            $pdf->Cell(20,5,$last_paid_date,0,0,'C',0);
            $pdf->SetX(160);
            $pdf->Cell(20,5,$cancel_date,0,0,'C',0);
            $pdf->SetX(180);
            $pdf->Cell(20,5,$numOfDays,0,0,'C',0);

            if($agent_height >= $customer_height && $agent_height >= $chit_height){
                $last_y = $agent_height;
            }
            else if($customer_height >= $agent_height && $customer_height >= $chit_height){
                $last_y = $customer_height;
            }
            else if($chit_height >= $agent_height && $chit_height >= $customer_height){
                $last_y = $chit_height;
            }

            $pdf->SetY($yaxis);
            $pdf->SetX(10);
            $pdf->Cell(10,$last_y-$yaxis,'',1,0,'C',0);
            $pdf->SetX(20);
            $pdf->Cell(25,$last_y-$yaxis,'',1,0,'C',0);
            $pdf->SetX(45);
            $pdf->Cell(25,$last_y-$yaxis,'',1,0,'C',0);
            $pdf->SetX(70);
            $pdf->Cell(20,$last_y-$yaxis,'',1,0,'C',0);
            $pdf->SetX(90);
            $pdf->Cell(30,$last_y-$yaxis,'',1,0,'C',0);
            $pdf->SetX(120);
            $pdf->Cell(20,$last_y-$yaxis,'',1,0,'C',0);
            $pdf->SetX(140);
            $pdf->Cell(20,$last_y-$yaxis,'',1,0,'C',0);
            $pdf->SetX(160);
            $pdf->Cell(20,$last_y-$yaxis,'',1,0,'C',0);
            $pdf->SetX(180);
            $pdf->Cell(0,$last_y-$yaxis,'',1,1,'L',0);

            $sno++;
        }
    }
    
    $pdf->SetY(-10);
    $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);

    $pdf->Output();
?>