<?php

//use PhpOffice\PhpSpreadsheet\Writer\Pdf;

    $order_id = ""; $paper_size = "";
    if(isset($_REQUEST['print_order_id'])){
        $order_id = $_REQUEST['print_order_id'];
    }

    if(isset($_REQUEST['paper_size'])){
        $paper_size = $_REQUEST['paper_size'];
    }
    
    include("../include.php");

    $order_number = ""; $order_date = ""; $customer_name = ""; $customer_mobile_number = ""; $customer_city = ""; $delivery_address = ""; $product_ids = array();
    $product_codes = array(); $product_names = array(); $product_contents = array(); $quantity_values = array(); $rate_values = array();
    $packing_charges = ""; $company_details = ""; $order_count = 0;

    $view_orders = array();
    $view_orders = $obj->getTableRecords($GLOBALS['order_table'], 'order_id', $order_id);
    if(!empty($view_orders)) {
        foreach($view_orders as $data) {
            if(!empty($data['order_number']) && $data['order_number'] != $GLOBALS['null_value']) {
                $order_number = $obj->encode_decode('decrypt', $data['order_number']);
            }
            if(!empty($data['order_date']) && $data['order_date'] != "0000-00-00") {
                $order_date = date("d-m-Y", strtotime($data['order_date']));
            }
            if(!empty($data['company_details'])) {
                $company_details = $obj->encode_decode('decrypt', $data['company_details']);
            }
            if(!empty($data['customer_name'])) {
                $customer_name = $obj->encode_decode('decrypt', $data['customer_name']);
            }
            if(!empty($data['customer_mobile_number'])) {
                $customer_mobile_number = $obj->encode_decode('decrypt', $data['customer_mobile_number']);
            }
            if(!empty($data['customer_city'])) {
                $customer_city = $obj->encode_decode('decrypt', $data['customer_city']);
            }
            if(!empty($data['delivery_address'])) {
                $delivery_address = $obj->encode_decode('decrypt', $data['delivery_address']);
                $delivery_address = str_replace("\r\n", "<br>", $delivery_address);
            }
            if(!empty($data['product_id'])) {
                $product_ids = explode(",", $data['product_id']);
                $order_count = count($product_ids);
            }
            if(!empty($data['product_code'])) {
                $product_codes = explode(",", $data['product_code']);
            }
            if(!empty($data['product_name'])) {
                $product_names = explode(",", $data['product_name']);
            }
            if(!empty($data['product_content'])) {
                $product_contents = explode(",", $data['product_content']);
            }
            if(!empty($data['quantity'])) {
                $quantity_values = explode(",", $data['quantity']);
            }
            if(!empty($data['price'])) {
                $rate_values = explode(",", $data['price']);
            }
            if(!empty($data['packing_charges']) && $data['packing_charges'] != $GLOBALS['null_value']) {
                $packing_charges = $data['packing_charges'];
            }
        }
    }

    $company_name = ""; $company_logo = ""; $company_address = ""; $company_mobile_number = ""; $company_email = ""; $company_city = ""; $company_state = "";
    if(!empty($company_details)) {
        $company_details = explode("<br>", $company_details);
        if(!empty($company_details['0'])) {
            $company_name = $company_details['0'];
        }
        if(!empty($company_details['1'])) {
            $company_address = $company_details['1'];
            if(!empty($company_address)) {
                $company_address = str_replace("$$$", "<br>", $company_address);
            }
        }
        if(!empty($company_details['2'])) {
            $company_city = $company_details['2'];
        }
        if(!empty($company_details['3'])) {
            $company_state = $company_details['3'];
        }
        if(!empty($company_details['4'])) {
            $company_mobile_number = $company_details['4'];
        }
        if(!empty($company_details['5'])) {
            $company_email = $company_details['5'];
        }
    }

    $company_list = array();
    $company_list = $obj->getTableRecords($GLOBALS['company_table'], '', '');
    if(!empty($company_list)){
        foreach($company_list as $list){
            if(!empty($list['logo']) && $list['logo'] != $GLOBALS['null_value']){
                $company_logo = $list['logo'];
            }
        }
    }

    $product_lists = array();
    for($i = 0; $i < count($product_names); $i++) {
        $product_code = "";$product_name = ""; $product_content = ""; $product_price = "";  $product_quantity = ""; $product_discount = 0;
        $product_amount = "";
        if(!empty($product_codes[$i])) {
            $product_code = $product_codes[$i];
        }
        if(!empty($product_names[$i])) {
            $product_name = $product_names[$i];
        }
        if(!empty($product_contents[$i])) {
            $product_content = $product_contents[$i];
        }
        if(!empty($rate_values[$i])) {
            $product_price = $rate_values[$i];
        }
        if(!empty($quantity_values[$i])) {
            $product_quantity = $quantity_values[$i];
        }

        $product_discount = 0;			
        if(!empty($product_quantity) && !empty($product_price)) {
            $product_amount = $product_quantity * $product_price;
            if(!empty($product_amount)) {
                $product_amount = number_format($product_amount, 2);
                $product_amount = str_replace(",", "", $product_amount);
            }
        }
        
        if(!empty($product_amount)) {		
            $product_lists[] = array('code' => $product_code, 'name' => $product_name, 'content' => $product_content, 'price' => $product_price, 'quantity' => $product_quantity, 'discount' => $product_discount, 'amount' => $product_amount);
        }
    }
    
    if(!empty($delivery_address)){
        $delivery_address = explode("<br>",$delivery_address);
    }
    if(!empty($product_lists)) {	
        $values = array();
        foreach($product_lists as $key => $row) {
            $values[$key] = $obj->encode_decode('decrypt', $row['code']);
        }
        array_multisort($values, SORT_ASC, $product_lists);
        
        $discounts = array();
        foreach($product_lists as $list) {
            if(!in_array($list['discount'], $discounts)) {
                $discounts[] = $list['discount'];
            }    
        }
        require_once('../fpdf/fpdf.php');
        if(count($product_lists)>15 || $paper_size == "a4"){
            $pdf = new FPDF('P','mm','A4');
            $pdf->AliasNbPages(); 
            $pdf->AddPage();
            $pdf->SetAutoPageBreak(true);
            $pdf->SetTitle('Estimate Report');
            $pdf->SetFont('Arial','',9);
            $pdf->SetY(7);
            $pdf->Cell(0,6,'Order No : '.$order_number,0,0,'L',0);
            $pdf->SetFont('Arial','B',9);
            $pdf->SetY(7);
            $pdf->Cell(0,6,'ESTIMATE',0,0,'C',0);
            $pdf->SetFont('Arial','',9);
            $pdf->SetY(7);
            $pdf->Cell(0,6,'Date : '.date("d-m-Y", strtotime($order_date)),0,1,'R',0);
            $pdf->SetY(7);
            $pdf->Cell(0,6,'',1,1,'L',0);
            $pdf->SetFont('Arial','B',9);
            $y = $pdf->GetY();
            $pdf->Cell(0,6,'Mobile : '.$company_mobile_number,0,0,'L',0);
            if(!empty($company_email)){
                $pdf->Cell(0,6,'E-mail : '.$company_email,0,1,'R',0);
            }else{
                $pdf->Cell(0,6,'',0,1,'R',0);
            }
            
            if(!empty($company_name)){
                $pdf->Cell(0,6,$company_name,0,1,'C',0);
                if(!empty($company_address)){
                    $company_address = explode("<br>", $company_address);
                    $pdf->SetFont('Arial','',9);
                    $pdf->Cell(0,4,$company_address[0],0,1,'C',0);
                    $pdf->Cell(0,4,$company_address[1],0,1,'C',0);
                }
                if(!empty($company_city)){
                    $pdf->SetFont('Arial','',9);
                    $pdf->Cell(0,4,$company_city,0,1,'C',0);
                }
                if(!empty($company_state)){
                    $pdf->SetFont('Arial','',9);
                    $pdf->Cell(0,4,$company_state,0,1,'C',0);
                }
            }
            
            $y1= $pdf->GetY();
            $pdf->SetY($y);
            $pdf->Cell(0,$y1-$y,'',1,1,'C',0);

            $yaxis = $pdf->GetY();
            $pdf->SetFont('Arial','B',9);
            $pdf->Cell(0,6,'Customer Details',0,1,'L',0);
            $pdf->SetFont('Arial','',8);
            
            if(!empty($customer_name)){
                $pdf->SetX(15);
                $pdf->Cell(0,4,$customer_name,0,1,'L',0);
            }
            if(!empty($customer_mobile_number)){
                $pdf->SetX(15);
                $pdf->Cell(0,4,$customer_mobile_number,0,1,'L',0);
            }
            if(!empty($customer_city)){
                $pdf->SetX(15);
                $pdf->Cell(0,4,$customer_city,0,1,'L',0);
            }
            $customer_height = $pdf->GetY();

            if(!empty($delivery_address)){
                $pdf->SetY($yaxis);
                $pdf->SetFont('Arial','B',9);
                $pdf->Cell(0,6,'Delivery Address',0,1,'R',0);
                $pdf->SetFont('Arial','',8);
                for($i=0;$i<count($delivery_address);$i++){
                    $pdf->Cell(0,4,$delivery_address[$i],0,1,'R',0);
                }
            }

            $delivery_height = $pdf->GetY();

            if($customer_height >= $delivery_height){
                $current_y = $customer_height;
            }
            else{
                $current_y = $delivery_height;
            }

            $pdf->SetY($yaxis);
            $pdf->Cell(0,$current_y - $yaxis,'',1,1,'L',0);

            $pdf->SetFont('Arial','B',9);
            $pdf->SetX(10);
            $pdf->Cell(10,4,'S.No',1,0,'C',0);
            $pdf->SetX(20);
            $pdf->Cell(15,4,'Code',1,0,'C',0);
            $pdf->SetX(35);
            $pdf->Cell(90,4,'Product Name',1,0,'C',0);
            $pdf->SetX(125);
            $pdf->Cell(15,4,'Content',1,0,'C',0);
            $pdf->SetX(140);
            $pdf->Cell(15,4,'Qty',1,0,'C',0);
            $pdf->SetX(155);
            $pdf->Cell(15,4,'Rate',1,0,'C',0);
            $pdf->SetX(170);
            $pdf->Cell(30,4,'Amount',1,1,'C',0);
            $overall_total = 0; $index = 1; $s_no = 1; $payable_amounts = array();

            $pdf->SetFont('Arial', '', 8);
            if(!empty($product_lists)) {
                $sub_total = 0; $discounted_total = 0;
                foreach($product_lists as $key => $data) {
                    if($pdf->GetY()>=250){
                        $pdf->SetY(-7);
                        $pdf->SetFont('Arial','I',7);
                        $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);
                        $pdf->AddPage();
                        $pdf->SetFont('Arial','',9);
                        $pdf->SetY(7);
                        $pdf->Cell(0,6,'Order No : '.$order_number,0,0,'L',0);
                        $pdf->SetFont('Arial','B',9);
                        $pdf->SetY(7);
                        $pdf->Cell(0,6,'ESTIMATE',0,0,'C',0);
                        $pdf->SetFont('Arial','',9);
                        $pdf->SetY(7);
                        $pdf->Cell(0,6,'Date : '.date("d-m-Y", strtotime($order_date)),0,1,'R',0);
                        $pdf->SetY(7);
                        $pdf->Cell(0,6,'',1,1,'L',0);
                        $pdf->SetFont('Arial','B',9);
                        $y = $pdf->GetY();
                        $pdf->Cell(0,6,'Mobile : '.$company_mobile_number,0,0,'L',0);
                        if(!empty($company_email)){
                            $pdf->Cell(0,6,'E-mail : '.$company_email,0,1,'R',0);
                        }else{
                            $pdf->Cell(0,6,'',0,1,'R',0);
                        }
                        
                        if(!empty($company_name)){
                            $pdf->Cell(0,6,$company_name,0,1,'C',0);
                            if(!empty($company_address)){
                                $pdf->SetFont('Arial','',9);
                                $pdf->Cell(0,4,$company_address[0],0,1,'C',0);
                                $pdf->Cell(0,4,$company_address[1],0,1,'C',0);
                            }
                            if(!empty($company_city)){
                                $pdf->SetFont('Arial','',9);
                                $pdf->Cell(0,4,$company_city,0,1,'C',0);
                            }
                            if(!empty($company_state)){
                                $pdf->SetFont('Arial','',9);
                                $pdf->Cell(0,4,$company_state,0,1,'C',0);
                            }
                        }
                        
                        $y1= $pdf->GetY();
                        $pdf->SetY($y);
                        $pdf->Cell(0,$y1-$y,'',1,1,'C',0);

                        $pdf->SetFont('Arial','B',9);
                        $pdf->SetX(10);
                        $pdf->Cell(10,4,'S.No',1,0,'C',0);
                        $pdf->SetX(20);
                        $pdf->Cell(15,4,'Code',1,0,'C',0);
                        $pdf->SetX(35);
                        $pdf->Cell(90,4,'Product Name',1,0,'C',0);
                        $pdf->SetX(125);
                        $pdf->Cell(15,4,'Content',1,0,'C',0);
                        $pdf->SetX(140);
                        $pdf->Cell(15,4,'Qty',1,0,'C',0);
                        $pdf->SetX(155);
                        $pdf->Cell(15,4,'Rate',1,0,'C',0);
                        $pdf->SetX(170);
                        $pdf->Cell(30,4,'Amount',1,1,'C',0);
                        $yaxis = $pdf->GetY();
                        $pdf->SetFont('Arial','',8);
                    }
                    $y_axis = $pdf->GetY();
                    $pdf->SetX(10);
                    $pdf->Cell(10,4,$s_no,0,0,'C',0);
                    $pdf->SetX(20);
                    if(!empty($data['code']) && $data['code']!='NULL'){
                        $data['code'] = $obj->encode_decode('decrypt', $data['code']);
                        $pdf->Cell(15,4,$data['code'],0,0,'C',0);
                    }
                    
                    $pdf->SetX(125);
                    if(!empty($data['content']) && $data['content']!='NULL'){
                        $data['content'] = $obj->encode_decode('decrypt', $data['content']);
                        $pdf->Cell(15,4,$data['content'],0,0,'C',0);
                    }
                    else{
                        $pdf->Cell(15,4,'',0,0,'C',0);
                    }
                    $pdf->SetX(140);
                    $pdf->Cell(15,4,$data['quantity'],0,0,'C',0);
                    $pdf->SetX(155);
                    $pdf->Cell(15,4,number_format($data['price'], 2),0,0,'R',0);
                    $pdf->SetX(170);
                    $pdf->Cell(30,4,number_format($data['amount'], 2),0,0,'R',0);
                    $pdf->SetX(36);
                    $data['name'] = html_entity_decode($obj->encode_decode('decrypt',$data['name']),ENT_QUOTES);
                    
                    $pdf->MultiCell(90,4,$data['name'],0,'L',0);
                    $pdf->Cell(35,1,'',0,1,'R',0);
                    
                    $s_no++;
                    $sub_total = $sub_total + $data['amount'];

                    $y_axis1 = $pdf->GetY();
                    $pdf->SetY($y_axis);
                    $pdf->SetX(10);
                    $pdf->Cell(10,$y_axis1-$y_axis,'',1,0,'C',0);
                    $pdf->SetX(20);
                    $pdf->Cell(15,$y_axis1-$y_axis,'',1,0,'C',0);
                    $pdf->SetX(35);
                    $pdf->Cell(90,$y_axis1-$y_axis,'',1,0,'C',0);
                    $pdf->SetX(125);
                    $pdf->Cell(15,$y_axis1-$y_axis,'',1,0,'C',0);
                    $pdf->SetX(140);
                    $pdf->Cell(15,$y_axis1-$y_axis,'',1,0,'C',0);
                    $pdf->SetX(155);
                    $pdf->Cell(15,$y_axis1-$y_axis,'',1,0,'C',0);
                    $pdf->SetX(170);
                    $pdf->Cell(30,$y_axis1-$y_axis,'',1,1,'C',0);
                }
            }
            if(!empty($sub_total)) { 
                $payable_amounts[] = $sub_total;
                $overall_total = $overall_total + $sub_total;
            }
            $net_total = 0; $net_total = $overall_total;

            $packing_charges_value = 0;
            if (strpos($packing_charges, '%') !== false) {
                $packing_charges = trim(str_replace("%", "", $packing_charges));
                $packing_charges_value = ($overall_total * $packing_charges) / 100;
                if(!empty($packing_charges_value)) {
                    $packing_charges_value = number_format($packing_charges_value, 2);
                    $packing_charges_value = trim(str_replace(",", "", $packing_charges_value));
                    $overall_total = $overall_total + $packing_charges_value;
                    $packing_charges = $packing_charges."%";
                }
            }
            else{
                if(!empty($packing_charges)){
                    $packing_charges_value = $packing_charges;
                    $overall_total = $overall_total + $packing_charges_value;
                }
            }

            $round_off_minus = "";
            if(!empty($overall_total)) {	
                $overall_total = $obj->truncate_number($overall_total, 2);
                if (strpos( $overall_total, "." ) !== false) {
                    $pos = strpos($overall_total, ".");
                    $decimal = substr($overall_total, ($pos + 1), strlen($overall_total));
                    $round_off = "";
                    if($decimal != "00") {
                        if(strlen($decimal) == 1) {
                            $decimal = $decimal."0";
                        }
                        if($decimal >= 50) {
                            $round_off = 100 - $decimal;
                            if(!empty($round_off) && $round_off < 10) {
                                $round_off = "0.0".$round_off;
                            }
                            else {
                                $round_off = "0.".$round_off;
                            }
                            $overall_total = str_replace(",", "", $overall_total);
                            $overall_total = $overall_total + $round_off;
                        }
                        else {
                            $round_off = $decimal;
                            if(!empty($round_off) && $round_off < 10) {
                                $round_off = "0.0".$round_off;
                            }
                            else {
                                $round_off = "0.".$round_off;
                            }
                            $overall_total = str_replace(",", "", $overall_total);
                            $overall_total = $overall_total - $round_off;
                            $round_off_minus = "minus";
                        }                                                                
                    }                    
                }
            }

            $height=0;
            if(empty($packing_charges)){
                $height+=8;
            }
            if(empty($round_off)){
                $height+=4;
            }

            if($pdf->GetY()<265){
                $pdf->SetX(10);
                $pdf->Cell(10,265+$height-$pdf->GetY(),'',1,0,'C',0);
                $pdf->SetX(20);
                $pdf->Cell(15,265+$height-$pdf->GetY(),'',1,0,'C',0);
                $pdf->SetX(35);
                $pdf->Cell(90,265+$height-$pdf->GetY(),'',1,0,'C',0);
                $pdf->SetX(125);
                $pdf->Cell(15,265+$height-$pdf->GetY(),'',1,0,'C',0);
                $pdf->SetX(140);
                $pdf->Cell(15,265+$height-$pdf->GetY(),'',1,0,'C',0);
                $pdf->SetX(155);
                $pdf->Cell(15,265+$height-$pdf->GetY(),'',1,0,'C',0);
                $pdf->SetX(170);
                $pdf->Cell(30,265+$height-$pdf->GetY(),'',1,1,'C',0);
            }

            $pdf->SetFont('Arial', 'B', 9);
            $pdf->SetFillColor(232,232,232);
            if(!empty($net_total)) {
                $pdf->SetX(10);
                if(!empty($payable_amounts) && count($payable_amounts) > 1) {
                    $payable_amounts = implode(" + ", $payable_amounts);
                    $pdf->Cell(160,4,"(".$payable_amounts.")".'   Net Total',1,0,'R',1);
                }
                else {
                    $pdf->Cell(160,4,'Net Total',1,0,'R',1);
                }
                $pdf->SetX(170);
                $pdf->Cell(30,4,number_format($net_total, 2),1,1,'R',1);
            }
            
            if(!empty($packing_charges)){
                $pdf->SetX(10);
                $pdf->Cell(160,4,'Packing Charges ( '.$packing_charges.' )',1,0,'R',1);
                $pdf->SetX(170);
                $pdf->Cell(30,4,number_format($packing_charges_value, 2),1,1,'R',1);
            }

            if(!empty($round_off)) {
                $pdf->SetX(10);
                if(!empty($round_off_minus)) {
                    $pdf->Cell(160,4,'Round Off (-)',1,0,'R',1);
                }
                else {
                    $pdf->Cell(160,4,'Round Off',1,0,'R',1);
                }
                $pdf->SetX(170);
                $pdf->Cell(30,4,"Rs.".number_format($round_off, 2),1,1,'R',1);
            }
            
            $pdf->SetFillColor(211,211,211);
            $pdf->SetX(10);
            $pdf->Cell(85,4,'Total Items : '.$order_count,1,0,'L',1);
            $pdf->SetX(95);
            $pdf->Cell(75,4,'Overall Total',1,0,'R',1);
            $pdf->SetX(170);
            $pdf->Cell(30,4,number_format($overall_total, 2),1,1,'R',1);

            $pdf->SetY(-7);
            $pdf->SetFont('Arial','I',7);
            if($pdf->PageNo()!="1"){
                $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);
            }
        }
        else{
            $pdf = new FPDF('P','mm','A5');
            $pdf->AliasNbPages(); 
            $pdf->AddPage();
            $pdf->SetAutoPageBreak(true);
            $pdf->SetTitle('Estimate Report');
            $pdf->SetFont('Arial','',9);
            $pdf->SetY(7);
            $pdf->Cell(0,6,'Order No : '.$order_number,0,0,'L',0);
            $pdf->SetFont('Arial','B',9);
            $pdf->SetY(7);
            $pdf->Cell(0,6,'ESTIMATE',0,0,'C',0);
            $pdf->SetFont('Arial','',9);
            $pdf->SetY(7);
            $pdf->Cell(0,6,'Date : '.date("d-m-Y", strtotime($order_date)),0,1,'R',0);
            $pdf->SetY(7);
            $pdf->Cell(0,6,'',1,1,'L',0);
            $pdf->SetFont('Arial','B',9);
            $y = $pdf->GetY();
            $pdf->Cell(0,6,'Mobile : '.$company_mobile_number,0,0,'L',0);
            if(!empty($company_email)){
                $pdf->Cell(0,6,'E-mail : '.$company_email,0,1,'R',0);
            }else{
                $pdf->Cell(0,6,'',0,1,'R',0);
            }
            
            if(!empty($company_name)){
                $pdf->Cell(0,6,$company_name,0,1,'C',0);
                if(!empty($company_address)){
                    $company_address = explode("<br>", $company_address);
                    $pdf->SetFont('Arial','',9);
                    $pdf->Cell(0,4,$company_address[0],0,1,'C',0);
                    $pdf->Cell(0,4,$company_address[1],0,1,'C',0);
                }
                if(!empty($company_city)){
                    $pdf->SetFont('Arial','',9);
                    $pdf->Cell(0,4,$company_city,0,1,'C',0);
                }
                if(!empty($company_state)){
                    $pdf->SetFont('Arial','',9);
                    $pdf->Cell(0,4,$company_state,0,1,'C',0);
                }
            }
            
            $y1= $pdf->GetY();
            $pdf->SetY($y);
            $pdf->Cell(0,$y1-$y,'',1,1,'C',0);

            $yaxis = $pdf->GetY();
            $pdf->SetFont('Arial','B',9);
            $pdf->Cell(0,6,'Customer Details',0,1,'L',0);
            $pdf->SetFont('Arial','',8);
            
            if(!empty($customer_name)){
                $pdf->SetX(15);
                $pdf->Cell(0,4,$customer_name,0,1,'L',0);
            }
            if(!empty($customer_mobile_number)){
                $pdf->SetX(15);
                $pdf->Cell(0,4,$customer_mobile_number,0,1,'L',0);
            }
            if(!empty($customer_city)){
                $pdf->SetX(15);
                $pdf->Cell(0,4,$customer_city,0,1,'L',0);
            }
            $customer_height = $pdf->GetY();

            if(!empty($delivery_address)){
                $pdf->SetY($yaxis);
                $pdf->SetFont('Arial','B',9);
                $pdf->Cell(0,6,'Delivery Address',0,1,'R',0);
                $pdf->SetFont('Arial','',8);
                for($i=0;$i<count($delivery_address);$i++){
                    $pdf->Cell(0,4,$delivery_address[$i],0,1,'R',0);
                }
            }

            $delivery_height = $pdf->GetY();

            if($customer_height >= $delivery_height){
                $current_y = $customer_height;
            }
            else{
                $current_y = $delivery_height;
            }

            $pdf->SetY($yaxis);
            $pdf->Cell(0,$current_y - $yaxis,'',1,1,'L',0);

            $pdf->SetFont('Arial','B',8);
            $pdf->SetX(10);
            $pdf->Cell(10,4,'S.No',1,0,'C',0);
            $pdf->SetX(20);
            $pdf->Cell(40,4,'Product Code & Name',1,0,'C',0);
            $pdf->SetX(60);
            $pdf->Cell(15,4,'Content',1,0,'C',0);
            $pdf->SetX(75);
            $pdf->Cell(15,4,'Qty',1,0,'C',0);
            $pdf->SetX(90);
            $pdf->Cell(20,4,'Rate',1,0,'C',0);
            $pdf->SetX(110);
            $pdf->Cell(28.5,4,'Amount',1,1,'C',0);
            $overall_total = 0; $index = 1; $s_no = 1; $payable_amounts = array();
            
            foreach($product_lists as $key => $data) {
                if($pdf->GetY()>=170){
                    $pdf->SetY(-7);
                    $pdf->SetFont('Arial','I',7);
                    $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);   
                    $pdf->AddPage();
                    $pdf->SetFont('Arial','',9);
                    $pdf->SetY(7);
                    $pdf->Cell(0,6,'Order No : '.$order_number,0,0,'L',0);
                    $pdf->SetFont('Arial','B',9);
                    $pdf->SetY(7);
                    $pdf->Cell(0,6,'ESTIMATE',0,0,'C',0);
                    $pdf->SetFont('Arial','',9);
                    $pdf->SetY(7);
                    $pdf->Cell(0,6,'Date : '.date("d-m-Y", strtotime($order_date)),0,1,'R',0);
                    $pdf->SetY(7);
                    $pdf->Cell(0,6,'',1,1,'L',0);
                    $pdf->SetFont('Arial','B',9);
                    $y = $pdf->GetY();
                    $pdf->Cell(0,6,'Mobile : '.$company_mobile_number,0,0,'L',0);
                    if(!empty($company_email)){
                        $pdf->Cell(0,6,'E-mail : '.$company_email,0,1,'R',0);
                    }else{
                        $pdf->Cell(0,6,'',0,1,'R',0);
                    }
                    
                    if(!empty($company_name)){
                        $pdf->Cell(0,6,$company_name,0,1,'C',0);
                        if(!empty($company_address)){
                            $pdf->SetFont('Arial','',9);
                            $pdf->Cell(0,4,$company_address[0],0,1,'C',0);
                            $pdf->Cell(0,4,$company_address[1],0,1,'C',0);
                        }
                        if(!empty($company_city)){
                            $pdf->SetFont('Arial','',9);
                            $pdf->Cell(0,4,$company_city,0,1,'C',0);
                        }
                        if(!empty($company_state)){
                            $pdf->SetFont('Arial','',9);
                            $pdf->Cell(0,4,$company_state,0,1,'C',0);
                        }
                    }
                    
                    $y1= $pdf->GetY();
                    $pdf->SetY($y);
                    $pdf->Cell(0,$y1-$y,'',1,1,'C',0);

                    $pdf->SetFont('Arial','B',8);
                    $pdf->SetX(10);
                    $pdf->Cell(10,4,'S.No',1,0,'C',0);
                    $pdf->SetX(20);
                    $pdf->Cell(40,4,'Product Code & Name',1,0,'C',0);
                    $pdf->SetX(60);
                    $pdf->Cell(15,4,'Content',1,0,'C',0);
                    $pdf->SetX(75);
                    $pdf->Cell(15,4,'Qty',1,0,'C',0);
                    $pdf->SetX(90);
                    $pdf->Cell(20,4,'Rate',1,0,'C',0);
                    $pdf->SetX(110);
                    $pdf->Cell(28.5,4,'Amount',1,1,'C',0);
                    $yaxis = $pdf->GetY();
                }
                $y_axis = $pdf->GetY();
                $pdf->SetFont('Arial','',8);
                if($s_no>1){
                    $pdf->Line(10,$pdf->GetY(),138.5,$pdf->GetY());
                    $pdf->Cell(10,1,'',0,1,'C',0);
                }
                $y3=$pdf->GetY();
                $pdf->SetX(10);
                $pdf->Cell(10,4,$s_no,0,0,'C',0);
                $pdf->SetX(20);
                if(!empty($data['code']) && $data['code']!='NULL'){
                    $data['code'] = $obj->encode_decode('decrypt', $data['code']);
                }
                
                $pdf->SetX(60);
                if(!empty($data['content']) && $data['content']!='NULL'){
                    $data['content'] = $obj->encode_decode('decrypt', $data['content']);
                    $pdf->Cell(15,4,$data['content'],0,0,'C',0);
                }
                else{
                    $pdf->Cell(15,4,'',0,0,'C',0);
                }
                
                $pdf->SetX(75);
                $pdf->Cell(15,4,$data['quantity'],0,0,'C',0);
                $pdf->SetX(90);
                $pdf->Cell(20,4,number_format($data['price'], 2),0,0,'R',0);
                $pdf->SetX(110);
                $pdf->Cell(28.5,4,number_format($data['amount'], 2),0,0,'R',0);
                $pdf->SetX(20);
                $data['name'] = html_entity_decode($obj->encode_decode('decrypt',$data['name']),ENT_QUOTES); 
                if($data['code']!='' && $data['code']!='NULL'){
                    $pdf->MultiCell(40,4,$data['code'].' - '.$data['name'],0,'L',0);
                }else{
                    $pdf->MultiCell(40,4,$data['name'],0,'L',0);
                }
                
                $y_axis1 = $pdf->GetY();
                $pdf->SetY($y_axis);
                $pdf->SetX(10);
                $pdf->Cell(10,$y_axis1-$y_axis,'',1,0,'C',0);
                $pdf->SetX(20);
                $pdf->Cell(40,$y_axis1-$y_axis,'',1,0,'C',0);
                $pdf->SetX(60);
                $pdf->Cell(15,$y_axis1-$y_axis,'',1,0,'C',0);
                $pdf->SetX(75);
                $pdf->Cell(15,$y_axis1-$y_axis,'',1,0,'C',0);
                $pdf->SetX(90);
                $pdf->Cell(20,$y_axis1-$y_axis,'',1,0,'C',0);
                $pdf->SetX(110);
                $pdf->Cell(28.5,$y_axis1-$y_axis,'',1,1,'C',0);
                
                $s_no++;
                $overall_total = $overall_total + $data['amount'];
            }
            
            
            $net_total = 0; $net_total = $overall_total;

            $packing_charges_value = 0;
            if (strpos($packing_charges, '%') !== false) {
                $packing_charges = trim(str_replace("%", "", $packing_charges));
                $packing_charges_value = ($overall_total * $packing_charges) / 100;
                if(!empty($packing_charges_value)) {
                    $packing_charges_value = number_format($packing_charges_value, 2);
                    $packing_charges_value = trim(str_replace(",", "", $packing_charges_value));
                    $overall_total = $overall_total + $packing_charges_value;
                    $packing_charges = $packing_charges."%";
                }
            }
            else{
                if(!empty($packing_charges)){
                    $packing_charges_value = $packing_charges;
                    $overall_total = $overall_total + $packing_charges_value;
                }
            }

            

            $round_off_minus = "";
            if(!empty($overall_total)) {	
                $overall_total = $obj->truncate_number($overall_total, 2);
                if (strpos( $overall_total, "." ) !== false) {
                    $pos = strpos($overall_total, ".");
                    $decimal = substr($overall_total, ($pos + 1), strlen($overall_total));
                    $round_off = "";
                    if($decimal != "00") {
                        if(strlen($decimal) == 1) {
                            $decimal = $decimal."0";
                        }
                        if($decimal >= 50) {
                            $round_off = 100 - $decimal;
                            if(!empty($round_off) && $round_off < 10) {
                                $round_off = "0.0".$round_off;
                            }
                            else {
                                $round_off = "0.".$round_off;
                            }
                            $overall_total = str_replace(",", "", $overall_total);
                            $overall_total = $overall_total + $round_off;
                        }
                        else {
                            $round_off = $decimal;
                            if(!empty($round_off) && $round_off < 10) {
                                $round_off = "0.0".$round_off;
                            }
                            else {
                                $round_off = "0.".$round_off;
                            }
                            $overall_total = str_replace(",", "", $overall_total);
                            $overall_total = $overall_total - $round_off;
                            $round_off_minus = "minus";
                        }                                                                
                    }                    
                }
            }

            $height=0;
            if(empty($packing_charges)){
                $height+=8;
            }
            if(empty($round_off)){
                $height+=4;
            }

            if($pdf->GetY()<175){
                $pdf->SetX(10);
                $pdf->Cell(10,175+$height-$pdf->GetY(),'',1,0,'C',0);
                $pdf->SetX(20);
                $pdf->Cell(40,175+$height-$pdf->GetY(),'',1,0,'C',0);
                $pdf->SetX(60);
                $pdf->Cell(15,175+$height-$pdf->GetY(),'',1,0,'C',0);
                $pdf->SetX(75);
                $pdf->Cell(15,175+$height-$pdf->GetY(),'',1,0,'C',0);
                $pdf->SetX(90);
                $pdf->Cell(20,175+$height-$pdf->GetY(),'',1,0,'C',0);
                $pdf->SetX(110);
                $pdf->Cell(28.5,175+$height-$pdf->GetY(),'',1,1,'C',0);
            }
            
            $pdf->SetFont('Arial', 'B', 9);
            $pdf->SetFillColor(232,232,232);
            if(!empty($net_total)) {
                $pdf->SetX(10);
                if(!empty($payable_amounts) && count($payable_amounts) > 1) {
                    $payable_amounts = implode(" + ", $payable_amounts);
                    $pdf->Cell(100,4,"(".$payable_amounts.")".'  Net Total',1,0,'R',1);
                }
                else {
                    $pdf->Cell(100,4,'Net Total',1,0,'R',1);
                }
                $pdf->SetX(110);
                $pdf->Cell(28.5,4,number_format($net_total, 2),1,1,'R',1);
            }

            if(!empty($packing_charges)){
                $pdf->SetX(10);
                $pdf->Cell(100,4,'Packing Charges ( '.$packing_charges.' )',1,0,'R',1);
                $pdf->SetX(110);
                $pdf->Cell(28.5,4,number_format($packing_charges_value, 2),1,1,'R',1);
            }

            if(!empty($round_off)) {
                $pdf->SetX(10);
                if(!empty($round_off_minus)) {
                    $pdf->Cell(100,4,'Round Off (-)',1,0,'R',1);
                }
                else {
                    $pdf->Cell(100,4,'Round Off',1,0,'R',1);
                }
                $pdf->SetX(110);
                $pdf->Cell(28.5,4,"Rs.".number_format($round_off, 2),1,1,'R',1);
            }
            
            $pdf->SetFillColor(211,211,211);
            $pdf->SetX(10);
            $pdf->Cell(65,4,'Total Items : '.$order_count,1,0,'L',1);
            $pdf->SetX(75);
            $pdf->Cell(35,4,'Overall Total',1,0,'R',1);
            $pdf->SetX(110);
            $pdf->Cell(28.5,4,number_format($overall_total, 2),1,1,'R',1);

            if(!empty($promotion_code_price) && !empty($promotion_code_discount_value)) {
                $pdf->SetX(10);
                $pdf->Cell(100,4,"Coupon Discount (".$promotion_code_price.")",1,0,'R',1);
                $pdf->SetX(110);
                $pdf->Cell(28.5,4,"Rs.".number_format($promotion_code_discount_value, 2),1,1,'R',1);

                $overall_total = $overall_total - $promotion_code_discount_value;

                $pdf->SetX(10);
                $pdf->Cell(100,4,'Final Value',1,0,'R',1);
                $pdf->SetX(110);
                $pdf->Cell(28.5,4,"Rs.".number_format($overall_total, 2),1,1,'R',1);
            }

            $pdf->SetY(-7);
            $pdf->SetFont('Arial','I',7);
            if($pdf->PageNo()!="1"){
                $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);
            }
        }
        
    }

    $pdf->Output('D','estimate_bill.pdf');
?>