<?php
include 'include.php';

// Header This Application is a JSON APPLICATION
header('Content-Type: application/json; charset=utf-8');

// get Post Form Data on API
$json = file_get_contents('php://input');

// Decode JSON Format
$json_obj = json_decode($json);

// Output Result Array Variable
$output = array();

$result = "";

// Check User Id and Password is isset on API Parameter
if(isset($json_obj->print_order_id)) {
    $print_order_id = ""; $format = ""; $type = 1; $paper_size = ""; $printer_ip_address = ""; $printer_port_number = "";

    $print_order_id = $json_obj->print_order_id;		
    $print_order_id = trim($print_order_id);

    $format = $json_obj->format;		
    $format = trim($format);

    $type = $json_obj->type;		
    $type = trim($type);

    if(isset($json_obj->printer_ip_address)) {
        $printer_ip_address = $json_obj->printer_ip_address;
        $printer_ip_address = trim($printer_ip_address);
    }
    if(isset($json_obj->printer_port_number)) {
        $printer_port_number = $json_obj->printer_port_number;
        $printer_port_number = trim($printer_port_number);
    }
        
    if(!empty($print_order_id)) {
        $order_unique_id = "";
        $order_unique_id = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $print_order_id, 'id');
        if(preg_match("/^\d+$/", $order_unique_id)) {
            
            $format_error = "";
            if(!empty($format)) {
                if($format != "A4" && $format != "A5" && $format != "Thermal" && $format != "3-inch") {
                    $format_error = "Invalid Format";
                }
            }
            if(empty($format_error)) {

                $type_error = "";
                if(!empty($type)) {
                    if($type != "1" && $type != "2") {
                        $type_error = "Invalid Type";
                    }
                }
                if(empty($type_error)) {

                    $printout_file = "";
                    if(!empty($format)) {
                        if($format == "A4" || $format == "A5") {
                            if(!empty($type)) {
                                if($type == 1) {
                                    $printout_file = "https://www.sattursrigowthamcrackers.com/order/pdf/rpt_orders_format1.php?print_order_id=".$print_order_id."&paper_size=".$format;
                                }
                                else if($type == 2) {
                                    $printout_file = "https://www.sattursrigowthamcrackers.com/order/pdf/rpt_orders_format2.php?print_order_id=".$print_order_id."&paper_size=".$format;
                                }
                            }
                        }
                        else if($format == "Thermal") {
                            $printout_file = "https://www.sattursrigowthamcrackers.com/order/pdf/rpt_orders_format3.php?print_order_id=".$print_order_id;
                        }
                        else if($format == "3-inch") {
                            $printout_file = "https://www.sattursrigowthamcrackers.com/order/pdf/rpt_orders_format4.php?print_order_id=".$print_order_id;
                            /*if(!empty($printer_ip_address) && !empty($printer_port_number)) { // rpt_orders_format4.php
                                $printout_file = "https://www.sattursrigowthamcrackers.com/order/pdf/3_inch_app.php?print_order_id=".$print_order_id."&printer_ip_address=".$printer_ip_address."&printer_port_number=".$printer_port_number;
                            }*/
                        }
                    }

                    if(!empty($printout_file)) {
                        $output["head"]["code"] = 200;
                        $output["head"]["msg"] = "";
                        $output["head"]["printout_file"] = $printout_file;
                    }
                    else {
                        $output["head"]["code"] = 400;
                        $output["head"]["msg"] = "Prinout data not match";
                    }

                }
                else {
                    $output["head"]["code"] = 400;
                    $output["head"]["msg"] = $type_error;
                }

            }
            else {
                $output["head"]["code"] = 400;
                $output["head"]["msg"] = $format_error;
            }
            
        }
        else {
            $output["head"]["code"] = 400;
            $output["head"]["msg"] = 'Invalid order';
        }
    }
    else {
        $output["head"]["code"] = 400;
        $output["head"]["msg"] = 'Empty order';
    }
}

$result = json_encode($output, JSON_NUMERIC_CHECK);

echo $result;
?>