<?php
include 'include.php';

// Header This Application is a JSON APPLICATION
header('Content-Type: application/json; charset=utf-8');

// get Post Form Data on API
$json = file_get_contents('php://input');

// Decode JSON Format
$json_obj = json_decode($json);

// Output Result Array Variable
$output = array();

$result = "";

// Check User Id and Password is isset on API Parameter
if(isset($json_obj->equiry_admin_user_id)) {
    $user_error = ""; $valid_admin = 0;
 
    $equiry_admin_user_id = $json_obj->equiry_admin_user_id;		
    $equiry_admin_user_id = trim($equiry_admin_user_id);
    $user_error = $valid->common_validation($equiry_admin_user_id, 'user', 'text');
    if(!empty($user_error)) {
        $user_error = $user_error;
    }

    if(!empty($equiry_admin_user_id) && empty($user_error)) {
        $admin_unique_id = "";
        $admin_unique_id = $obj->getTableColumnValue($GLOBALS['user_table'], 'user_id', $equiry_admin_user_id, 'id');
        if(preg_match("/^\d+$/", $admin_unique_id)) {
            $valid_admin = 1;
        }
        else {
            $user_error = "Invalid User";
        }
    }

    $page_number = "";
    if(isset($json_obj->page_number)) {
        $page_number = $json_obj->page_number;
        $page_number = trim($page_number);
    }
    $page_limit = "";
    if(isset($json_obj->page_limit)) {
        $page_limit = $json_obj->page_limit;
        $page_limit = trim($page_limit);
    }

    $search_text = "";
    if(isset($json_obj->search_text)) {
        $search_text = $json_obj->search_text;
        $search_text = trim($search_text);
    }
    $from_date = "";
    if(isset($json_obj->from_date)) {
        $from_date = $json_obj->from_date;
        $from_date = trim($from_date);
    }
    $to_date = "";
    if(isset($json_obj->to_date)) {
        $to_date = $json_obj->to_date;
        $to_date = trim($to_date);
    }
    $filter_customer_id = "";
    if(isset($json_obj->filter_customer_id)) {
        $filter_customer_id = $json_obj->filter_customer_id;
        $filter_customer_id = trim($filter_customer_id);
    }

    $filter_staff_id = "";
    if(isset($json_obj->filter_staff_id)) {
        $filter_staff_id = $json_obj->filter_staff_id;
        $filter_staff_id = trim($filter_staff_id);
    }

    $filter_order_type = "";
    if(isset($json_obj->filter_order_type)) {
        $filter_order_type = $json_obj->filter_order_type;
        $filter_order_type = trim($filter_order_type);
    }

    $filter_promotion_code_id = "";
    if(isset($json_obj->filter_promotion_code_id)) {
        $filter_promotion_code_id = $json_obj->filter_promotion_code_id;
        $filter_promotion_code_id = trim($filter_promotion_code_id);
    }

    $filter_status = "";
    if(isset($json_obj->filter_status)) {
        $filter_status = $json_obj->filter_status;
        $filter_status = trim($filter_status);
    }
    
    if(empty($user_error)) {
        if(!empty($valid_admin) && $valid_admin == 1) {
            $total_records_list = array();
            $total_records_list = $obj->DisplayCrackerOrders($from_date, $to_date, $filter_customer_id, $filter_staff_id, $filter_status, $filter_order_type, $filter_promotion_code_id, '');

            if(!empty($search_text)) {
                $search_text = strtolower($search_text);
                $list = array();
                if(!empty($total_records_list)) {
                    foreach($total_records_list as $val) {
                        if(!empty($val['order_number']) && $val['order_number'] != $GLOBALS['null_value']) {
                            if(strpos(strtolower($obj->encode_decode('decrypt', $val['order_number'])), $search_text) !== false) {
                                $list[] = $val;
                            }
                        }
                    }
                }
                $total_records_list = $list;
            }

            $total_pages = 0;
            if(!empty($total_records_list)) {
                $total_pages = count($total_records_list);
            }
            
            $page_start = 0; $page_end = 0;
            if(!empty($page_number) && !empty($page_limit) && !empty($total_pages)) {
                if($total_pages > $page_limit) {
                    if($page_number) {
                        $page_start = ($page_number - 1) * $page_limit;
                        $page_end = $page_start + $page_limit;
                    }
                }
                else {
                    $page_start = 0;
                    $page_end = $page_limit;
                }

                $show_records_list = array();
                if(!empty($total_records_list)) {
                    foreach($total_records_list as $key => $val) {
                        if($key >= $page_start && $key < $page_end) {
                            $show_records_list[] = $val;
                        }
                    }
                }
            }
            else {
                $show_records_list = $total_records_list;
            }

            $staff_list = array();
            $staff_list = $obj->getTableRecords($GLOBALS['staff_table'], '', '');

            $customer_list = array();
            $customer_list = $obj->getTableRecords($GLOBALS['customer_table'], '', '');

            $enquiry_type_list = array('Frontend Order', 'Backend Order');

            $promotion_code_list = array();
            $promotion_code_list = $obj->getTableRecords($GLOBALS['promotion_code_table'], '', '');
            
            $show_promotion_code = 2;
            $show_promotion_code = $obj->getTableColumnValue($GLOBALS['settings_table'], 'name', 'show_promotion_code', 'value');

            $status_list = array('All', 'Confirmed', 'Despatched', 'Delivered', 'Status Not Updated', 'Unopened');$c = 0;
            if(!empty($customer_list)) {
                foreach($customer_list as $data) {
                    if(!empty($data['customer_id'])) {
                        $customer_id = $data['customer_id']; $customer_name = "";
                        
                        if(!empty($data['name'])) {
                            $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                            $customer_name = $data['name'];
                        }
                        if(!empty($data['mobile_number']) && $data['mobile_number'] != $GLOBALS['null_value']) {
                            $data['mobile_number'] = $obj->encode_decode('decrypt', $data['mobile_number']);
                            $customer_name = $customer_name." (".$data['mobile_number'].")";
                        }

                        $output['body']['customer'][$c] = array('filter_customer_id' => $customer_id, 'customer_name' => $customer_name);
                        $c++;
                    }
                }
            }
            else {
                $output['body']['customer'] = [];
            }

            $s = 0;
            if(!empty($staff_list)) {
                foreach($staff_list as $data) {
                    if(!empty($data['staff_id'])) {
                        $staff_id = $data['staff_id']; $staff_name = "";
                        
                        if(!empty($data['name'])) {
                            $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                            $staff_name = $data['name'];
                        }
                        if(!empty($data['mobile_number'])) {
                            $data['mobile_number'] = $obj->encode_decode('decrypt', $data['mobile_number']);
                            $staff_name = $staff_name." (".$data['mobile_number'].")";
                        }

                        $output['body']['staff'][$s] = array('filter_staff_id' => $staff_id, 'staff_name' => $staff_name);
                        $s++;
                    }
                }
            }
            else {
                $output['body']['staff'] = [];
            }

            $t = 0;
            if(!empty($enquiry_type_list)) {
                foreach($enquiry_type_list as $enquiry_type) {
                    if(!empty($enquiry_type)) {
                        $filter_order_type = "";
                        $filter_order_type = $obj->encode_decode('encrypt', $enquiry_type);
                        $output['body']['enquiry_type'][$t] = array('filter_order_type' => $filter_order_type, 'enquiry_type' => $enquiry_type);
                        $t++;
                    }
                }
            }
            else {
                $output['body']['enquiry_type'] = [];
            }

            if(!empty($show_promotion_code) && $show_promotion_code == 1) {
                $p = 0;
                if(!empty($promotion_code_list)) {
                    foreach($promotion_code_list as $data) {
                        if(!empty($data['promotion_code_id'])) {
                            $promotion_code_id = $data['promotion_code_id']; $promotion_code_name = "";
                            
                            if(!empty($data['name'])) {
                                $promotion_code_name = $obj->encode_decode('decrypt', $data['name']);
                            }

                            $output['body']['promotion_code'][$p] = array('filter_promotion_code_id' => $promotion_code_id, 'promotion_code_name' => $promotion_code_name);
                            $p++;
                        }
                    }
                }
                else {
                    $output['body']['promotion_code'] = [];
                }
            }
            else {
                $output['body']['promotion_code'] = [];
            }

            if(!empty($status_list)) {
                $s = 0;
                foreach($status_list as $key => $status) {
                    if(!empty($status)) {
                        $output['body']['status'][$s] = array('filter_status' => $key, 'status' => $status);
                    }
                    $s++;
                }
            }

            if(!empty($show_records_list)) {
                $output["head"]["code"] = 200;               

                $orders_count = 0;
                foreach($show_records_list as $data) {
                    $order_id = ""; $order_type = ""; $order_number = ""; $order_date = ""; $customer_name = ""; $customer_mobile_number = "";
                    $customer_details = ""; $delivery_address = ""; $total_amount = 0; $new_order = 0; $confirmed = 0; $despatched = 0; $delivered = 0;
                    $delivery_number = ""; $delivery_particulars = "";

                    if(!empty($data['order_id'])) {
                        $order_id = $data['order_id'];
                    }
                    if(!empty($data['order_type'])) {
                        $order_type = $data['order_type'];
                    }
                    if(!empty($order_type)) {
                        $order_type = $obj->encode_decode('decrypt', $order_type);
                    }
                    if(!empty($data['order_number']) && $data['order_number'] != $GLOBALS['null_value']) {
                        $order_number = $data['order_number'];
                    }
                    if(!empty($order_number)) {
                        $order_number = $obj->encode_decode('decrypt', $order_number);
                    }
                    if(!empty($data['order_date']) && $data['order_date'] != "0000-00-00") { 
                        $order_date = date("d-m-Y", strtotime($data['order_date'])); 
                        if(!empty($data['created_date_time']) && $data['created_date_time'] != "0000-00-00 00:00:00") { 
                            $order_date = $order_date." ".date("h:i:s A", strtotime($data['created_date_time'])); 
                        }
                    }
                    if(!empty($data['customer_details'])) { 
                        $customer_details = $obj->encode_decode('decrypt', $data['customer_details']);
                        $customer_details = explode("<br>", $customer_details);
                        if(!empty($customer_details['0'])) { 
                            $customer_name = $customer_details['0'];
                            if(!empty($customer_details['1'])) { 
                                $customer_mobile_number = $customer_details['1']; 
                            }
                        }
                    }
                    if(!empty($data['delivery_address'])) { 
                        $delivery_address = $obj->encode_decode('decrypt', $data['delivery_address']);
                        $delivery_address = str_replace("\r\n", "\n", $delivery_address);
                        $delivery_address = str_replace("<br>", "\n", $delivery_address);
                    }
                    /*if(!empty($data['total_amount'])) {  
                        $total_amount = number_format($data['total_amount'], 2); 
                    }*/

                    if(!empty($data['new_order'])) {
                        $new_order = $data['new_order'];
                    }
                    if(!empty($data['confirmed'])) {
                        $confirmed = $data['confirmed'];
                    }
                    if(!empty($data['despatched'])) {
                        $despatched = $data['despatched'];
                    }
                    if(!empty($data['delivered'])) {
                        $delivered = $data['delivered'];
                    }

                    if(!empty($data['delivery_number']) && $data['delivery_number'] != $GLOBALS['null_value']) {
                        $data['delivery_number'] = $obj->encode_decode('decrypt', $data['delivery_number']);
                        $delivery_number = $data['delivery_number'];
                    }
                    if(!empty($data['delivery_particulars']) && $data['delivery_particulars'] != $GLOBALS['null_value']) {
                        $data['delivery_particulars'] = $obj->encode_decode('decrypt', $data['delivery_particulars']);
                        $delivery_particulars = $data['delivery_particulars'];
                    }

                    $product_codes = array(); $product_names = array(); $product_contents = array(); $quantity_values = array(); $rate_values = array();
                    $discount_values = array();
                    if(!empty($data['product_code'])) {
                        $product_codes = explode(",", $data['product_code']);
                    }
                    if(!empty($data['product_name'])) {
                        $product_names = explode(",", $data['product_name']);
                    }
                    if(!empty($data['product_content'])) {
                        $product_contents = explode(",", $data['product_content']);
                    }
                    if(!empty($data['quantity'])) {
                        $quantity_values = explode(",", $data['quantity']);
                    }
                    if(!empty($data['price'])) {
                        $rate_values = explode(",", $data['price']);
                    }
                    if(!empty($data['discount'])) {
                        $discount_values = explode(",", $data['discount']);
                    }

                    $sub_total = 0; 
                    for($i = 0; $i < count($product_names); $i++) {
                        $product_code = ""; $product_name = ""; $product_content = ""; $product_price = "";  $product_quantity = ""; $product_discount = 0;
                        $product_amount = "";
                        if(!empty($product_codes[$i]) && $product_codes[$i] != $GLOBALS['null_value']) {
                            $product_code = $obj->encode_decode('decrypt', $product_codes[$i]);
                        }
                        if(!empty($product_names[$i])) {
                            $product_name = $obj->encode_decode('decrypt', $product_names[$i]);
                        }
                        if(!empty($product_contents[$i]) && $product_contents[$i] != $GLOBALS['null_value']) {
                            $product_content = $obj->encode_decode('decrypt', $product_contents[$i]);
                        }
                        if(!empty($rate_values[$i])) {
                            $product_price = $rate_values[$i];
                        }
                        if(!empty($quantity_values[$i])) {
                            $product_quantity = $quantity_values[$i];
                        }
                        if(!empty($order_type)) {
                            if(!empty($discount_values[$i])) {
                                $product_discount = $discount_values[$i];
                            }
                            else {
                                $product_discount = 0;
                            }
                        }	
                        
                        if(!empty($product_quantity) && !empty($product_price)) {
                            $product_amount = $product_quantity * $product_price;

                            if(!empty($product_amount)) {
                                $product_amount = number_format($product_amount, 2);
                                $product_amount = str_replace(",", "", $product_amount);
                                $sub_total = $sub_total + $product_amount;
                            }
                        }		
                        $output['body']['orders'][$orders_count]['product_list'][$i] = array('code' => $product_code, 'name' => $product_name, 'content' => $product_content, 'product_price' => $product_price, 'quantity' => $product_quantity, 'discount' => $product_discount, 'amount' => $product_amount);
                    }

                    $total_amount = 0; $extra_discount = 0; $extra_discount_value = 0; $extra_discount_total = 0; $coupon_discount = 0;
                    $coupon_discount_value = 0; $coupon_discount_total = 0; $packing_charges = 0; $packing_charges_value = 0; $grand_total = 0;
                    $round_off = 0;

                    if(!empty($sub_total)) {
                        $total_amount = $sub_total;
                    }
                    if(!empty($total_amount)) {
                        if(!empty($data['promotion_code_price']) && $data['promotion_code_price'] != $GLOBALS['null_value']) {
                            $coupon_discount = $data['promotion_code_price'];
                            $coupon_discount = trim($coupon_discount);
                        }
                        if(!empty($data['promotion_code_discount_value']) && $data['promotion_code_discount_value'] != $GLOBALS['null_value']) {
                            $coupon_discount_value = $data['promotion_code_discount_value'];
                            $coupon_discount_value = trim($coupon_discount_value);
                        }
                        if(!empty($coupon_discount) && !empty($coupon_discount_value)) {
                            if(preg_match("/^[0-9]+(\\.[0-9]+)?$/", $coupon_discount_value)) {
                                $total_amount = $total_amount - $coupon_discount_value;
                                $coupon_discount_total = $total_amount; 
                            }
                        }

                        if(!empty($data['packing_charges']) && $data['packing_charges'] != $GLOBALS['null_value']) {
                            $packing_charges = $data['packing_charges'];
                            $packing_charges = trim($packing_charges);
                            if(!empty($packing_charges)) {
                                if (strpos($packing_charges, '%') !== false) {
                                    $check_packing_charges = 0;
                                    $check_packing_charges = str_replace("%", "", $packing_charges);
                                    if(preg_match("/^[0-9]+(\\.[0-9]+)?$/", $check_packing_charges)) {
                                        $packing_charges_value = ($total_amount * $check_packing_charges) / 100;
                                        if(!empty($packing_charges_value)) {
                                            $packing_charges_value = number_format($packing_charges_value, 2);
                                            $packing_charges_value = str_replace(",", "", $packing_charges_value);
                                        }
                                    }
                                }
                                else {
                                    if(preg_match("/^[0-9]+(\\.[0-9]+)?$/", $packing_charges)) {
                                        $packing_charges_value = $packing_charges;
                                    }
                                }
                                if(preg_match("/^[0-9]+(\\.[0-9]+)?$/", $packing_charges_value)) {
                                    $total_amount = $total_amount + $packing_charges_value; 
                                    $grand_total = $total_amount;
                                }
                            }
                        }

                        if(!empty($data['extra_discount'])) {
                            $extra_discount = $data['extra_discount'];
                            $extra_discount = trim($extra_discount);
                            if(!empty($extra_discount)) {
                                if (strpos($extra_discount, '%') !== false) {
                                    $check_extra_discount = 0;
                                    $check_extra_discount = str_replace("%", "", $extra_discount);
                                    if(preg_match("/^[0-9]+(\\.[0-9]+)?$/", $check_extra_discount)) {
                                        $extra_discount_value = ($total_amount * $check_extra_discount) / 100;
                                        if(!empty($extra_discount_value)) {
                                            $extra_discount_value = number_format($extra_discount_value, 2);
                                            $extra_discount_value = str_replace(",", "", $extra_discount_value);
                                        }
                                    }
                                }
                                else {
                                    if(preg_match("/^[0-9]+(\\.[0-9]+)?$/", $extra_discount)) {
                                        $extra_discount_value = $extra_discount;
                                    }
                                }
                                if(preg_match("/^[0-9]+(\\.[0-9]+)?$/", $extra_discount_value)) {
                                    $total_amount = $total_amount - $extra_discount_value; 
                                    $extra_discount_total = $total_amount;
                                }
                            }
                        }

                        if(!empty($total_amount)) {	
                            $total_amount = $obj->truncate_number($total_amount, 2);
                            if (strpos( $total_amount, "." ) !== false) {
                                $pos = strpos($total_amount, ".");
                                $decimal = substr($total_amount, ($pos + 1), strlen($total_amount));
                                if($decimal != "00") {
                                    if(strlen($decimal) == 1) {
                                        $decimal = $decimal."0";
                                    }
                                    if($decimal >= 50) {
                                        $round_off = 100 - $decimal;
                                        $round_off = trim($round_off);
                                        if(strlen($round_off) == 1) {
                                            $round_off = '0.0'.$round_off;
                                        }
                                        else {
                                            $round_off = '0.'.$round_off;
                                        }
                                        $total_amount = $total_amount + $round_off;
                                    }
                                    else {
                                        $round_off = $decimal;
                                        $round_off = trim($round_off);
                                        if(strlen($round_off) == 1) {
                                            $round_off = '0.0'.$round_off;
                                        }
                                        else {
                                            $round_off = '0.'.$round_off;
                                        }
                                        $total_amount = $total_amount - $round_off;
                                        $round_off = "(-)".$round_off;
                                    }         
                                }
                            }
                        }

                    }

                    $output['body']['orders'][$orders_count]['order_id'] = $order_id;
                    $output['body']['orders'][$orders_count]['order_type'] = $order_type;
                    $output['body']['orders'][$orders_count]['order_number'] = $order_number;
                    $output['body']['orders'][$orders_count]['order_date'] = $order_date;
                    $output['body']['orders'][$orders_count]['customer_name'] = $customer_name;
                    $output['body']['orders'][$orders_count]['customer_mobile_number'] = $customer_mobile_number;
                    $output['body']['orders'][$orders_count]['delivery_address'] = $delivery_address;

                    $output['body']['orders'][$orders_count]['sub_total'] = $sub_total;
                    $output['body']['orders'][$orders_count]['extra_discount'] = $extra_discount;
                    $output['body']['orders'][$orders_count]['extra_discount_value'] = $extra_discount_value;
                    $output['body']['orders'][$orders_count]['extra_discount_total'] = $extra_discount_total;
                    $output['body']['orders'][$orders_count]['coupon_discount'] = $coupon_discount;
                    $output['body']['orders'][$orders_count]['coupon_discount_value'] = $coupon_discount_value;
                    $output['body']['orders'][$orders_count]['coupon_discount_total'] = $coupon_discount_total;
                    $output['body']['orders'][$orders_count]['packing_charges'] = $packing_charges;
                    $output['body']['orders'][$orders_count]['packing_charges_value'] = $packing_charges_value;
                    $output['body']['orders'][$orders_count]['grand_total'] = $grand_total;
                    $output['body']['orders'][$orders_count]['round_off'] = $round_off;
                    $output['body']['orders'][$orders_count]['total_amount'] = $total_amount;

                    $output['body']['orders'][$orders_count]['new_order'] = $new_order;
                    $output['body']['orders'][$orders_count]['confirmed'] = $confirmed;
                    $output['body']['orders'][$orders_count]['despatched'] = $despatched;
                    $output['body']['orders'][$orders_count]['delivered'] = $delivered;

                    $output['body']['orders'][$orders_count]['delivery_number'] = $delivery_number;
                    $output['body']['orders'][$orders_count]['delivery_particulars'] = $delivery_particulars;



                    $orders_count++;
                }
            }
            else {
                $output["head"]["code"] = 400;
                $output["head"]["msg"] = "Sorry! no orders found";
                $output['body']['orders'] = [];
            }

        }
        else {
            $output["head"]["code"] = 400;
            $output["head"]["msg"] = "Invalid User";
        }
    }
    else {
        $output["head"]["code"] = 400;
        $output["head"]["msg"] = $user_error;
    }
}


$result = json_encode($output, JSON_NUMERIC_CHECK);

echo $result;
?>