<!DOCTYPE html>
<html lang="en">
<head>
	<title> Ordering Position </title>   
<style>
    .draggable {
  cursor: move;
  margin-bottom: 1rem;
  user-select: none;
  align-items: center;
  display: flex;
  justify-content: center;
  height: 4rem;
  width: 16rem;
  border: 1px solid #cbd5e0;
}
</style>
</head>
<body>
    <div id="list">
        <div class="draggable">A</div>
        <div class="draggable">B</div>
        <div class="draggable">C</div>
        <div class="draggable">D</div>
        <div class="draggable">E</div>
    </div>
</body>
</html> 
<script type="text/javascript">
    // The current dragging item
    let draggingEle;

    // The current position of mouse relative to the dragging element
    let x = 0;
    let y = 0;

    const mouseDownHandler = function (e) {
        draggingEle = e.target;

        // Calculate the mouse position
        const rect = draggingEle.getBoundingClientRect();
        x = e.pageX - rect.left;
        y = e.pageY - rect.top;

        // Attach the listeners to `document`
        document.addEventListener('mousemove', mouseMoveHandler);
        document.addEventListener('mouseup', mouseUpHandler);
    };

    const mouseMoveHandler = function (e) {
        // Set position for dragging element
        draggingEle.style.position = 'absolute';
        draggingEle.style.top = `${e.pageY - y}px`;
        draggingEle.style.left = `${e.pageX - x}px`;
    };

    //The mouseup event handler will remove the position styles of dragging item and cleans up the event handlers:

    const mouseUpHandler = function () {
        // Remove the position styles
        draggingEle.style.removeProperty('top');
        draggingEle.style.removeProperty('left');
        draggingEle.style.removeProperty('position');

        x = null;
        y = null;
        draggingEle = null;

        // Remove the handlers of `mousemove` and `mouseup`
        document.removeEventListener('mousemove', mouseMoveHandler);
        document.removeEventListener('mouseup', mouseUpHandler);
    };

    // Query the list element
    const list = document.getElementById('list');

    // Query all items
    [].slice.call(list.querySelectorAll('.draggable')).forEach(function (item) {
        item.addEventListener('mousedown', mouseDownHandler);
    })

    let placeholder;
    let isDraggingStarted = false;

    const mouseMoveHandler = function(e) {
        const draggingRect = draggingEle.getBoundingClientRect();

        if (!isDraggingStarted) {
            // Update the flag
            isDraggingStarted = true;

            // Let the placeholder take the height of dragging element
            // So the next element won't move up
            placeholder = document.createElement('div');
            placeholder.classList.add('placeholder');
            draggingEle.parentNode.insertBefore(
                placeholder,
                draggingEle.nextSibling
            );

            // Set the placeholder's height
            placeholder.style.height = `${draggingRect.height}px`;
        }
    }

    const mouseUpHandler = function() {
        // Remove the placeholder
        placeholder && placeholder.parentNode.removeChild(placeholder);
        // Reset the flag
        isDraggingStarted = false;
    };
    const isAbove = function (nodeA, nodeB) {
        // Get the bounding rectangle of nodes
        const rectA = nodeA.getBoundingClientRect();
        const rectB = nodeB.getBoundingClientRect();

        return rectA.top + rectA.height / 2 < rectB.top + rectB.height / 2;
    };
    const mouseMoveHandler = function (e) {
        // The current order:
        // prevEle
        // draggingEle
        // placeholder
        // nextEle
        const prevEle = draggingEle.previousElementSibling;
        const nextEle = placeholder.nextElementSibling;
    };

    const mouseMoveHandler = function(e) {
        // User moves item to the top
        if (prevEle && isAbove(draggingEle, prevEle)) {
            // The current order    -> The new order
            // prevEle              -> placeholder
            // draggingEle          -> draggingEle
            // placeholder          -> prevEle
            swap(placeholder, draggingEle);
            swap(placeholder, prevEle);
            return;
        }
    };

    const mouseMoveHandler = function(e) {
        // User moves the dragging element to the bottom
        if (nextEle && isAbove(nextEle, draggingEle)) {
            // The current order    -> The new order
            // draggingEle          -> nextEle
            // placeholder          -> placeholder
            // nextEle              -> draggingEle
            swap(nextEle, placeholder);
            swap(nextEle, draggingEle);
        }
    };

    const swap = function (nodeA, nodeB) {
        const parentA = nodeA.parentNode;
        const siblingA = nodeA.nextSibling === nodeB ? nodeA : nodeA.nextSibling;

        // Move `nodeA` to before the `nodeB`
        nodeB.parentNode.insertBefore(nodeA, nodeB);

        // Move `nodeB` to before the sibling of `nodeA`
        parentA.insertBefore(nodeB, siblingA);
    };
</script>