<?php
    include("include_user_check.php");

	$page_title = "Orders View";
	
    $view_order_id = "";
	if(isset($_REQUEST['view_order_id'])) {
		$view_order_id = $_REQUEST['view_order_id'];
	}

	$order_number = ""; $order_date = ""; $customer_name = ""; $customer_mobile_number = ""; $customer_city = ""; $delivery_address = ""; $product_ids = array();
	$product_codes = array(); $product_names = array(); $product_contents = array(); $quantity_values = array(); $rate_values = array();
	$packing_charges = ""; $company_details = ""; $orders_unique_id = ""; $packing_charges = 0;

	if(!empty($view_order_id)) {
        $view_orders = array();
        $view_orders = $obj->getTableRecords($GLOBALS['order_table'], 'order_id', $view_order_id);
        if(!empty($view_orders)) {
            foreach($view_orders as $data) {
				if(!empty($data['id'])) {
					$orders_unique_id = $data['id'];
				}
                if(!empty($data['order_number']) && $data['order_number'] != $GLOBALS['null_value']) {
                    $order_number = $obj->encode_decode('decrypt', $data['order_number']);
                }
                if(!empty($data['order_date']) && $data['order_date'] != "0000-00-00") {
                    $order_date = date("d-m-Y", strtotime($data['order_date']));
                }
                if(!empty($data['company_details'])) {
                    $company_details = $obj->encode_decode('decrypt', $data['company_details']);
                }
                if(!empty($data['customer_name'])) {
                    $customer_name = $obj->encode_decode('decrypt', $data['customer_name']);
                }
				if(!empty($data['customer_mobile_number'])) {
                    $customer_mobile_number = $obj->encode_decode('decrypt', $data['customer_mobile_number']);
                }
				if(!empty($data['customer_city'])) {
                    $customer_city = $obj->encode_decode('decrypt', $data['customer_city']);
                }
                if(!empty($data['delivery_address'])) {
                    $delivery_address = $obj->encode_decode('decrypt', $data['delivery_address']);
                    $delivery_address = str_replace("\r\n", "<br>", $delivery_address);
                }
                if(!empty($data['product_id'])) {
                    $product_ids = explode(",", $data['product_id']);
                }
                if(!empty($data['product_code'])) {
                    $product_codes = explode(",", $data['product_code']);
                }
                if(!empty($data['product_name'])) {
                    $product_names = explode(",", $data['product_name']);
                }
                if(!empty($data['product_content'])) {
                    $product_contents = explode(",", $data['product_content']);
                }
                if(!empty($data['quantity'])) {
                    $quantity_values = explode(",", $data['quantity']);
                }
                if(!empty($data['price'])) {
                    $rate_values = explode(",", $data['price']);
                }
				if(!empty($data['packing_charges']) && $data['packing_charges'] != $GLOBALS['null_value']) {
					$packing_charges = $data['packing_charges'];
				}
            }
			$columns = array(); $values = array();						
			$columns = array('new_order');
			$values = array("'0'");
			$msg = $obj->UpdateSQL($GLOBALS['order_table'], $orders_unique_id, $columns, $values, '');
        }

        $company_name = ""; $company_logo = ""; $company_address = ""; $company_mobile_number = ""; $company_email = ""; $company_city = ""; $company_state = "";
        if(!empty($company_details)) {
            $company_details = explode("<br>", $company_details);
            if(!empty($company_details['0'])) {
                $company_name = $company_details['0'];
            }
            if(!empty($company_details['1'])) {
                $company_address = $company_details['1'];
				if(!empty($company_address)) {
					$company_address = str_replace("$$$", "<br>", $company_address);
				}
            }
            if(!empty($company_details['2'])) {
                $company_city = $company_details['2'];
            }
            if(!empty($company_details['3'])) {
                $company_state = $company_details['3'];
            }
			if(!empty($company_details['4'])) {
                $company_mobile_number = $company_details['4'];
            }
            if(!empty($company_details['5'])) {
                $company_email = $company_details['5'];
            }
        }

        $product_lists = array();
		for($i = 0; $i < count($product_names); $i++) {
			$product_code = "";$product_name = ""; $product_content = ""; $product_price = "";  $product_quantity = ""; $product_discount = 0;
            $product_amount = "";
			if(!empty($product_codes[$i])) {
				$product_code = $product_codes[$i];
			}
            if(!empty($product_names[$i])) {
				$product_name = $product_names[$i];
			}
			if(!empty($product_contents[$i])) {
				$product_content = $product_contents[$i];
			}
			if(!empty($rate_values[$i])) {
				$product_price = $rate_values[$i];
			}
			if(!empty($quantity_values[$i])) {
				$product_quantity = $quantity_values[$i];
			}

           $product_discount = 0;			
			if(!empty($product_quantity) && !empty($product_price)) {
				$product_amount = $product_quantity * $product_price;
				if(!empty($product_amount)) {
					$product_amount = number_format($product_amount, 2);
                    $product_amount = str_replace(",", "", $product_amount);
				}
			}
			
			if(!empty($product_amount)) {		
				$product_lists[] = array('code' => $product_code, 'name' => $product_name, 'content' => $product_content, 'price' => $product_price, 'quantity' => $product_quantity, 'discount' => $product_discount, 'amount' => $product_amount);
			}
		}
	}	

	if(!empty($product_lists)) {	
		$values = array();
		foreach($product_lists as $key => $row) {
			if($row['code'] != $GLOBALS['null_value']) {
				$values[$key] = $obj->encode_decode('decrypt', $row['code']);
			}
			else {
				$values[$key] = "";
			}
		}
		array_multisort($values, SORT_ASC, $product_lists);

		$discounts = array();
		foreach($product_lists as $list) {
			if(!in_array($list['discount'], $discounts)) {
				$discounts[] = $list['discount'];
			}    
		}
	}	
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title> <?php if(!empty($project_title)) { echo $project_title; } ?> - <?php if(!empty($page_title)) { echo $page_title; } ?> </title>
	<?php include "link_style_script.php"; ?>
	<script type="text/javascript" src="include/js/common.js"></script>
	<script type="text/javascript" src="include/js/chit.js"></script>
</head>
<body>
	<?php include "header.php";  ?>
	<!-- sidebar-wrapper  -->          
	<div class="page-wrapper chiller-theme toggled">
		<main class="page-content">
			<div class="container-fluid px-lg-5">
				<div class="border card-box">

					<div class="card-header">                        
						<div class="row">
							<div class="col-6">
								<h5 class="headfnt edit_title"><?php if(!empty($page_title)) { echo $page_title." View"; } ?></h5>
							</div>
							<div class="col-6">
								<div class="d-flex align-items-center float-right">
									<?php $paper_size = ""; ?>
									<select name="paper_size" id="paper_size" class="form-control">
										<option value="">Select Paper Size</option>
										<option value="a4" <?php if($paper_size == "a4"){ ?> selected <?php } ?>>A4</option>
										<?php if(count($product_ids)<=15){ ?><option value="a5" <?php if($paper_size == "a5"){ ?> selected <?php } ?>>A5</option><?php } ?>
										<option value="thermal" <?php if($paper_size == "thermal"){ ?> selected <?php } ?> >Thermal</option>
									</select>

									<button class="btn btn-dark poppins mx-3" style="font-size:11px; width: 100px; white-space: nowrap;" type="button" id='btn_format1' onClick="window.open('reports/rpt_orders_format1.php?print_order_id=<?php if(!empty($view_order_id)) { echo $view_order_id; } ?>&paper_size='+document.getElementById('paper_size').value,'_blank')"> <i class="fa fa-print"></i> &ensp; PDF</button>

									<a href="orders.php" class="btn btn-danger">Back</a>
								</div>
							</div>
						</div>
					</div>

					<div id="order_view_cover" class="table-responsive poppins px-3 py-3">
						<div id="report_area" class="w-100">
							<?php if(!empty($order_number)) { ?>
							<table cellpadding="0" cellspacing="0" class="report_table print_order" style="width: 1000px;">
								<thead>
									<tr>
										<th colspan="7" style="padding: 2px 5px; border: 1px solid #000; border-bottom: none; text-align: center; font-size: 15px;">
											<div style="display: table; width: 100%;">
												<div style="display: table-row;">
													<div style="display: table-cell; text-align: left; width: 33.3%; padding-left: 10px; font-size: 12px; font-weight: normal;">
														<?php if(!empty($order_number)) { echo "Enquiry No : ".$order_number; } ?>
													</div>
													<div style="display: table-cell; text-align: center; width: 33.3%; padding-left: 10px; font-size: 15px;">ESTIMATE</div>
													<div style="display: table-cell; text-align: right; padding-right: 10px; width: 33.3%; font-size: 12px; font-weight: normal;">
														<?php if(!empty($order_date)) { echo "Date : ".date("d-m-Y", strtotime($order_date)); } ?> 
													</div>
												</div>
											</div>
										</th>
									</tr>
									<tr>
										<th colspan="7" style="padding: 2px 5px; border: 1px solid #000; text-align: center; font-size: 15px;">
											<div style="display: table; width: 100%;">
												<div style="display: table-row;">
													<div style="display: table-cell; text-align: center;">
														<?php if(!empty($company_mobile_number)) { ?>
														<div style="display: table;">
															<div style="display: table-row;">
																<div style="display: table-cell; text-align: left; padding-left: 10px;">Mobile : </div>
																<div style="display: table-cell; text-align: left; padding-left: 10px;">
																	<?php
																		$company_mobile_number = str_replace(",", "<br>", $company_mobile_number);
																		echo $company_mobile_number;
																	?>
																</div>
															</div>
														</div>
														<?php } ?>
													</div>
													<div style="display: table-cell; text-align: right; vertical-align: top; padding-right: 10px;">
														<?php if(!empty($company_email)) { echo "E-mail : ".$company_email; } ?> 
													</div>
												</div>
											</div>

											<div style="display: table; width: auto; margin: auto;">
												<div style="display: table-row;">
													<div style="display: table-cell; text-align: center; vertical-align: top;">
														<?php if(!empty($company_name)) { ?>
															<div style="width: 100%; font-size: 25px; line-height: 30px;"><?php echo $company_name; ?></div>
														<?php } ?>
														<?php if(!empty($company_address)) { ?>
															<div style="width: 100%; font-weight: normal;"><?php echo $company_address; ?></div>
														<?php } ?>
														<?php if(!empty($company_city)) { ?>
															<div style="width: 100%; font-weight: normal;"><?php echo $company_city; ?></div>
														<?php } ?>
														<?php if(!empty($company_state)) { ?>
															<div style="width: 100%; font-weight: normal;"><?php echo $company_state; ?></div>
														<?php } ?>    
													</div>
												</div>
											</div>
										</th>
									</tr>
									<tr>
										<td colspan="7" style="padding: 2px 5px; border: 1px solid #000; font-size: 13px; line-height: 15px;">
											<div style="display: table; width: 100%;">
												<div style="display: table-row;">
													<div style="display: table-cell; width: 50%;">
														<div style="width: 100%; text-align: center; margin-bottom: 5px; font-weight: bold;">Customer Details</div>
														<?php if(!empty($customer_name)) { ?>
															<div style="width: 100%; padding-left: 10px;"><?php echo $customer_name; ?></div>
														<?php } ?>
														<?php if(!empty($customer_mobile_number)) { ?>
															<div style="width: 100%; padding-left: 10px;"><?php echo "Mobile No : ".$customer_mobile_number; ?></div>
														<?php } ?>
														<?php if(!empty($customer_city)) { ?>
															<div style="width: 100%; padding-left: 10px;"><?php echo $customer_city; ?></div>
														<?php } ?>
													</div>
													<div style="display: table-cell; width: 50%;"> 
														<div style="width: 100%; text-align: center; margin-bottom: 5px; font-weight: bold;">Delivery Address</div>
														<?php if(!empty($delivery_address)) { ?>
															<div style="width: 100%; padding-right: 10px; text-align: right;"><?php echo $delivery_address; ?></div>
														<?php } ?>
													</div>
												</div>
											</div>
										</td>
									</tr>
									<tr>
										<th style="padding: 2px 5px; border: 1px solid #000; text-align: center; width: 10px; font-size: 12px;">S.No</th>
										<th style="padding: 2px 5px; border: 1px solid #000; border-left: none; text-align: center; width: 50px; font-size: 12px;">Code</th>
										<th style="padding: 2px 5px; border: 1px solid #000; border-left: none; text-align: center; font-size: 12px;">Product Name</th>
										<th style="padding: 2px 5px; border: 1px solid #000; border-left: none; text-align: center; width: 75px; font-size: 12px;">Content</th>
										<th style="padding: 2px 5px; border: 1px solid #000; border-left: none; text-align: center; width: 75px; font-size: 12px;">Quantity</th>
										<th style="padding: 2px 5px; border: 1px solid #000; border-left: none; text-align: center; width: 100px; font-size: 12px;">Rate (Rs)</th>
										<th style="padding: 2px 5px; border: 1px solid #000; border-left: none; text-align: center; width: 125px; font-size: 12px;">Amount (Rs)</th>
									</tr>
								</thead>
								<tbody>
									<?php
										$overall_total = 0; $index = 1; $payable_amounts = array();
										if(!empty($discounts)) {
											foreach($discounts as $discount) {
									?>
												<?php
													if(!empty($product_lists)) {
														$sub_total = 0;
														foreach($product_lists as $data) {
												?>
															<tr>
																<td style="padding: 2px 5px; border: 1px solid #000; text-align: center; width: 10px; font-size: 12px;">
																	<?php if(!empty($index)) { echo $index; } ?>
																</td>
																<td style="padding: 2px 5px; border: 1px solid #000; border-left: none; text-align: center; width: 50px; font-size: 12px;">
																	<?php
																		if(!empty($data['code']) && $data['code'] != $GLOBALS['null_value']) {
																			$data['code'] = $obj->encode_decode('decrypt', $data['code']);
																			echo $data['code'];
																		}
																	?>
																</td>
																<td style="padding: 2px 10px; border: 1px solid #000; border-left: none; font-size: 12px;">
																	<?php
																		if(!empty($data['name'])) {
																			$data['name'] = $obj->encode_decode('decrypt', $data['name']);
																			$data['name'] = str_replace("$", '"', $data['name']);
																			$data['name'] = str_replace("'''", '"', $data['name']);
																			echo $data['name'];
																		}
																	?>
																</td>
																<td style="padding: 2px 5px; border: 1px solid #000; border-left: none; text-align: center; width: 75px; font-size: 12px;">
																	<?php
																		if(!empty($data['content']) && $data['content'] != $GLOBALS['null_value']) {
																			$data['content'] = $obj->encode_decode('decrypt', $data['content']);
																			echo $data['content'];
																		}
																	?>
																</td>
																<td style="padding: 2px 5px; border: 1px solid #000; border-left: none; text-align: center; width: 75px; font-size: 12px;">
																	<?php if(!empty($data['quantity'])) { echo $data['quantity']; } ?>
																</td>
																<td style="padding: 2px 10px; border: 1px solid #000; border-left: none; text-align: right; width: 75px; font-size: 12px;">
																	<?php if(!empty($data['price'])) { echo number_format($data['price'], 2); } ?>
																</td>
																<td style="padding: 2px 10px; border: 1px solid #000; border-left: none; text-align: right; width: 125px; font-size: 12px;">
																	<?php 
																		if(!empty($data['amount'])) { 
																			$sub_total = $sub_total + $data['amount'];
																			echo number_format($data['amount'], 2); 
																		} 
																	?>
																</td>
															</tr>
												<?php
															$index = $index + 1;
														}
													}
													if(!empty($sub_total)) {
												?>
														<tr>
															<th colspan="6" style="padding: 2px 10px; border: 1px solid #000; border-right: none; text-align: right; font-size: 12px;">
																Total
															</th>
															<th style="padding: 2px 5px; border: 1px solid #000; text-align: right; font-size: 12px; width: 125px;">
																<?php 
																	if(!empty($sub_total)) { 
																		$payable_amounts[] = $sub_total;
																		$overall_total = $overall_total + $sub_total;
																		echo number_format($sub_total, 2); 
																	} 
																?>
															</th>
														</tr>
												<?php  
													}
												?>
									<?php    
											}
										} 
									?>

									<?php
										if(!empty($packing_charges)) {
											$packing_charges_value = 0;
											if (strpos($packing_charges, '%') !== false) {
												$packing_charges = trim(str_replace("%", "", $packing_charges));
												$packing_charges_value = ($overall_total * $packing_charges) / 100;
												if(!empty($packing_charges_value)) {
													$packing_charges_value = number_format($packing_charges_value, 2);
													$packing_charges_value = trim(str_replace(",", "", $packing_charges_value));
													$overall_total = $overall_total + $packing_charges_value;
													$packing_charges = $packing_charges."%";
												}
											}
											else{
												if(!empty($packing_charges)){
													$packing_charges_value = $packing_charges;
													$overall_total = $overall_total + $packing_charges_value;
												}
											}
									?>
											<tr>
												<th colspan="6" style="padding: 2px 10px; border: 1px solid #000; border-right: none; text-align: right; font-size: 12px;">
													Packing Charges <?php if(!empty($packing_charges)) { echo "(".$packing_charges.")"; } ?>
												</th>
												<th style="padding: 2px 5px; border: 1px solid #000; text-align: right; font-size: 12px; width: 125px;">
													<?php if(!empty($packing_charges_value)) { echo number_format($packing_charges_value, 2); } ?>
												</th>
											</tr>
									<?php        
										}
									?>

									<?php
										if(!empty($overall_total)) {	
											$overall_total = $obj->truncate_number($overall_total, 2);
											if (strpos( $overall_total, "." ) !== false) {
												$pos = strpos($overall_total, ".");
												$decimal = substr($overall_total, ($pos + 1), strlen($overall_total));
												$round_off = ""; $sign = "";
												if($decimal != "00") {
													if(strlen($decimal) == 1) {
														$decimal = $decimal."0";
													}
													if($decimal >= 50) {
														$round_off = 100 - $decimal;
														$round_off = "0.".$round_off;
														$overall_total = $overall_total + $round_off;
													}
													else {
														$round_off = $decimal;
														if(!empty($round_off) && $round_off < 10) {
															$round_off = "0.0".$round_off;
														}
														else {
															$round_off = "0.".$round_off;
														}
														$overall_total = $overall_total - $round_off;
														$sign = "minus";
													}
													$overall_total = str_replace(",", "", $overall_total);                                        
												}
												if(!empty($round_off)) {
									?>
													<tr>
														<th colspan="6" style="padding: 2px 10px; border: 1px solid #000; border-right: none; text-align: right; font-size: 12px;">
															Round Off <?php if(!empty($sign)) { echo " ( - ) "; } ?>
														</th>
														<th style="padding: 2px 5px; border: 1px solid #000; text-align: right; font-size: 12px; width: 125px;">
															<?php echo "Rs.".number_format($round_off, 2); ?>
														</th>
													</tr>
									<?php
												}
											}
												
									?>
									<?php } ?>
									<tr>
										<th colspan="3" style="padding: 2px 10px; border: 1px solid #000; border-right: none; text-align: left; font-size: 12px;">
											Total Items : <?php if(!empty($index) && $index > 1) { echo $index - 1; } else { echo $index; } ?>
										</th>
										<th colspan="3" style="padding: 2px 10px; border: 1px solid #000; border-right: none; text-align: right; font-size: 12px;">
											Overall Total
										</th>
										<th style="padding: 2px 5px; border: 1px solid #000; text-align: right; font-size: 12px; width: 125px;">
											<?php if(!empty($overall_total)) { echo number_format($overall_total, 2); } ?>
										</th>
									</tr>
								</tbody>
							</table>
							<?php 
								} 
							?>
						</div>
					</div>

				</div>
			</div>
		</main>
	</div>  
	<!-- page-wrapper -->

	<script>
		jQuery(document).ready(function(){
			jQuery("#bookingactive").addClass("active");
			jQuery("#ordersactive").addClass("active");
		});
	</script>

	<?php include "footer.php"; ?>

    </body>
</html>