<?php

header('Content-Type: application/json; charset=utf-8');

$json = file_get_contents('php://input');

$json_obj = json_decode($json);

$output = array();

$result = "";

$domain_name = ""; $admin_folder_name = "";
if(isset($json_obj->domain_name)) { 
    $domain_name = $json_obj->domain_name;		
    $domain_name = trim($domain_name);

    if(isset($json_obj->admin_folder_name)) { 
        $admin_folder_name = $json_obj->admin_folder_name;		
        $admin_folder_name = trim($admin_folder_name);
    }

    if(!empty($domain_name) && !empty($admin_folder_name)) {
        $domain_admin_path = "../".$domain_name."/".$admin_folder_name."/include.php";
        
        include($domain_admin_path);

        if (isset($json_obj->get_category_list)) {
            if (isset($json_obj->get_category_list) == 1) {
                $total_records_list = array();
                $query = 'SELECT * FROM  ' . $GLOBALS['category_table'] . ' WHERE deleted = 0 ORDER BY ordering ASC';
                $total_records_list = $obj->getQueryRecords('', $query);
        
                $category_name = "";
                $category_id = "";
                $show_frontend = 0;
                $creator_name = "";
                if (!empty($total_records_list)) {
                    $data_array = array();
                    foreach ($total_records_list as $key => $data) {
                        if (!empty($data['name'])) {
                            $category_name = $obj->encode_decode('decrypt', $data['name']);
                            $category_name = str_replace("$", '"', $category_name);
                            $category_name = str_replace("'''", '"', $category_name);
                            $category_name = trim($category_name);
                        }
                        if (!empty($data['creator_name'])) {
                            $creator_name = $obj->encode_decode('decrypt', $data['creator_name']);
                        }
                        if (!empty($data['category_id'])) {
                            $category_id = $data['category_id'];
                        }
        
                        $show_frontend = $data['show_frontend'];
        
                        $data_array[] = [
                            "category_name" => $category_name,
                            "category_id" => $category_id,
                            "show_frontend" => $show_frontend,
                            "creator_name" => $creator_name
                        ];
                    }
                    $output["head"]["code"] = 200;
                    $output["head"]["msg"] = $data_array;
                } else {
                    $output["head"]["code"] = 200;
                    $output["head"]["msg"] = "Invalid Request";
                }
            }
        }
        
        if (isset($json_obj->show_category_id)) {
            if (!empty($json_obj->show_category_id)) {
                $total_records_list = array();
                $total_records_list = $obj->getTableRecords($GLOBALS['category_table'], 'category_id', $json_obj->show_category_id);
        
                $category_name = "";
                $category_id = "";
                $show_frontend = "";
                if (!empty($total_records_list)) {
                    $data_array = array();
                    foreach ($total_records_list as $key => $data) {
                        if (!empty($data['name'])) {
                            $category_name = $obj->encode_decode('decrypt', $data['name']);
                            $category_name = str_replace("$", '"', $category_name);
                            $category_name = str_replace("'''", '"', $category_name);
                            $category_name = trim($category_name);
                        }
        
                        if (!empty($data['category_id'])) {
                            $category_id = $data['category_id'];
                        }
        
                        $data_array[] = [
                            "category_name" => $category_name,
                            "category_id" => $category_id
                        ];
                    }
                    $output["head"]["code"] = 200;
                    $output["head"]["msg"] = $data_array;
                } else {
                    $output["head"]["code"] = 200;
                    $output["head"]["msg"] = "Invalid Request";
                }
            } else {
                $output["head"]["code"] = 200;
                $output["head"]["msg"] = "Category id missing";
            }
        }
        
        if (isset($json_obj->edit_category_id)) {
            if (!empty($json_obj->edit_category_id)) {
                $name = "";
                $name = $json_obj->category_name;
        
                if (!empty($name)) {
                    $creator_name = "";
                    $created_date_time = $GLOBALS['create_date_time_label'];
                    $creator = $json_obj->creator_id;
                    $creator_name = $obj->getTableColumnValue($GLOBALS['user_table'], 'user_id', $creator, 'name');
        
                    $lower_case_name = "";
                    if (!empty($name)) {
                        $name = str_replace("''", "$", $name);
                        $name = str_replace('"', "$", $name);
                        $lower_case_name = strtolower($name);
                        $lower_case_name = $obj->encode_decode('encrypt', $lower_case_name);
                        $name = $obj->encode_decode('encrypt', $name);
                    }
        
                    if ($json_obj->edit_category_id != 'null') {
                        $getUniqueID = "";
                        $getUniqueID = $obj->getTableColumnValue($GLOBALS['category_table'], 'category_id', $json_obj->edit_category_id, 'id');
        
                        if (preg_match("/^\d+$/", $getUniqueID)) {
        
                            $columns = array();
                            $values = array();
                            $columns = array('created_date_time', 'creator', 'creator_name',  'name', 'lower_case_name');
                            $values = array("'" . $created_date_time . "'", "'" . $creator . "'", "'" . $creator_name . "'", "'" . $name . "'", "'" . $lower_case_name . "'");
                            $category_update_id = $obj->UpdateSQL($GLOBALS['category_table'], $getUniqueID, $columns, $values, '');
                            if (preg_match("/^\d+$/", $category_update_id)) {
                                $output["head"]["code"] = 200;
                                $output["head"]["msg"] = "Updated Successfully";
                            } else {
                                $output["head"]["code"] = 400;
                                $output["head"]["msg"] = $category_update_id;
                            }
                        }
                    } else {
                        $action = "";
                        $ordering_number = "";
                        $ordering_number = $obj->getOrderingNumber($GLOBALS['category_table'], '');
        
                        $null_value = $GLOBALS['null_value'];
                        $columns = array('created_date_time', 'creator', 'creator_name', 'category_id', 'name', 'lower_case_name', 'ordering', 'show_frontend', 'deleted');
                        $values = array("'" . $created_date_time . "'", "'" . $creator . "'", "'" . $creator_name . "'", "'" . $null_value . "'", "'" . $name . "'", "'" . $lower_case_name . "'", "'" . $ordering_number . "'", "'0'", "'0'");
                        $category_insert_id = $obj->InsertSQL($GLOBALS['category_table'], $columns, $values, $action);
                        if (preg_match("/^\d+$/", $category_insert_id)) {
                            $category_id = "";
                            if ($category_insert_id < 10) {
                                $category_id = "category_0" . $category_insert_id;
                            } else {
                                $category_id = "category_" . $category_insert_id;
                            }
                            if (!empty($category_id)) {
                                $category_id = $obj->encode_decode('encrypt', $category_id);
                            }
                            $columns = array();
                            $values = array();
                            $columns = array('category_id');
                            $values = array("'" . $category_id . "'");
                            $category_update_id = $obj->UpdateSQL($GLOBALS['category_table'], $category_insert_id, $columns, $values, '');
                            if (preg_match("/^\d+$/", $category_update_id)) {
                                $output["head"]["code"] = 200;
                                $output["head"]["msg"] = "Category Created";
                            } else {
                                $output["head"]["code"] = 400;
                                $output["head"]["msg"] = $category_update_id;
                            }
                        } else {
                            $output["head"]["code"] = 400;
                            $output["head"]["msg"] = $category_insert_id;
                        }
                    }
                }
            } else {
                $output["head"]["code"] = 400;
                $output["head"]["msg"] = "Category id missing";
            }
        }
        
        if (isset($json_obj->edit_category_id_frontend)) {
            if (!empty($json_obj->edit_category_id_frontend)) {
                $value = "";
                $value = $json_obj->value;
        
                $creator_name = "";
                $created_date_time = $GLOBALS['create_date_time_label'];
                $creator = $json_obj->creator_id;
                $creator_name = $obj->getTableColumnValue($GLOBALS['user_table'], 'user_id', $creator, 'name');
        
                $category_unique_id = "";
                $category_unique_id = $obj->getTableColumnValue($GLOBALS['category_table'], 'category_id', $json_obj->edit_category_id_frontend, 'id');
                if (preg_match("/^\d+$/", $category_unique_id)) {
                    $columns = array();
                    $values = array();
                    $columns = array('created_date_time', 'creator', 'creator_name', 'show_frontend');
                    $values = array("'" . $created_date_time . "'", "'" . $creator . "'", "'" . $creator_name . "'", $value);
                    $msg = $obj->UpdateSQL($GLOBALS['category_table'], $category_unique_id, $columns, $values, '');
                    if (preg_match("/^\d+$/", $category_unique_id)) {
                        $output["head"]["code"] = 200;
                        $output["head"]["msg"] = "Updated Successfully";
                    } else {
                        $output["head"]["code"] = 400;
                        $output["head"]["msg"] = $msg;
                    }
                }
            } else {
                $output["head"]["code"] = 400;
                $output["head"]["msg"] = "Category id missing";
            }
        }
        
        if (isset($json_obj->edit_category_id_ordering)) {
            if (!empty($json_obj->edit_category_id_ordering)) {
        
                $category_list = array();
                $category_list = $json_obj->edit_category_id_ordering;
        
                $creator_name = "";
                $created_date_time = $GLOBALS['create_date_time_label'];
                $creator = $json_obj->creator_id;
                $creator_name = $obj->getTableColumnValue($GLOBALS['user_table'], 'user_id', $creator, 'name');
        
                foreach ($category_list as $value) {
        
                    $category_id = $value->category_id;
                    $controller_text = $value->controller_text;
        
                    if (!empty($category_id) && !empty($controller_text)) {
                        $getUniqueID = "";
                        $getUniqueID = $obj->getTableColumnValue($GLOBALS['category_table'], 'category_id', $category_id, 'id');
        
                        if (preg_match("/^\d+$/", $getUniqueID)) {
                            $columns = array();
                            $values = array();
                            $columns = array('created_date_time', 'creator', 'creator_name', 'ordering');
                            $values = array("'" . $created_date_time . "'", "'" . $creator . "'", "'" . $creator_name . "'", "'" . $controller_text . "'");
                            $category_update_id = $obj->UpdateSQL($GLOBALS['category_table'], $getUniqueID, $columns, $values, '');
                            if (preg_match("/^\d+$/", $category_update_id)) {
                                $output["head"]["code"] = 200;
                                $output["head"]["msg"] = "Updated Successfully";
                            } else {
                                $output["head"]["code"] = 400;
                                $output["head"]["msg"] = $category_update_id;
                            }
                        } else {
                            $output["head"]["code"] = 400;
                            $output["head"]["msg"] = "Some feilds are empty";
                        }
                    }
                }
            } else {
                $output["head"]["code"] = 400;
                $output["head"]["msg"] = "Category id missing";
            }
        }
        
        if (isset($json_obj->delete_category_id)) {
            if (!empty($json_obj->delete_category_id)) {
                $delete_category_id = $json_obj->delete_category_id;
                $msg = "";
                if(!empty($delete_category_id)) {	
                    $product_list = array(); $products_count = 0;
                    $product_list = $obj->getTableRecords($GLOBALS['product_table'], 'category_id', $delete_category_id);
                    if(!empty($product_list)) {
                        $products_count = count($product_list);
                    }
        
                    if(empty($products_count)) {
                        $category_unique_id = "";
                        $category_unique_id = $obj->getTableColumnValue($GLOBALS['category_table'], 'category_id', $delete_category_id, 'id');
                        if(preg_match("/^\d+$/", $category_unique_id)) {
                            $name = "";
                            $name = $obj->getTableColumnValue($GLOBALS['category_table'], 'category_id', $delete_category_id, 'name');
                        
                            $action = "";
                            if(!empty($name)) {
                                $action = "Category Deleted. Name - ".$obj->encode_decode('decrypt', $name);
                            }
                        
                            $columns = array(); $values = array();						
                            $columns = array('deleted');
                            $values = array("'1'");
                            $msg = $obj->UpdateSQL($GLOBALS['category_table'], $category_unique_id, $columns, $values, $action);
                            $output["head"]["code"] = 200;
                            $output["head"]["msg"] = "Deleted Successfully";
                        }
                    }
                    else {
                        $output["head"]["code"] = 400;
                        $output["head"]["msg"] = "Unable To Delete";
                    }
                }
            } else {
                $output["head"]["code"] = 400;
                $output["head"]["msg"] = "Category id missing";
            }
        }
    }
}

$result = json_encode($output, JSON_NUMERIC_CHECK);

echo $result;
