<?php
include('domain_config.php');

if (isset($json_obj->get_otp)) {
    if ($json_obj->get_otp == 1) {
        $total_records_list = array();
        $total_records_list = $obj->getTableRecords($GLOBALS['otp_send_phone_numbers_table'], '', '');
        
        $output["head"]["code"] = 200;
        $output["head"]["msg"] = ["otp_data" => $total_records_list];

    } else {
        $output["head"]["code"] = 400;
        $output["head"]["msg"] = "Invalid Request";
    }
} else if(isset($json_obj->get_otp_report)) {
    $total_order_sms_count = 0;
    $total_otp_sms_count = 0;
    $total_otp_sms_resend_count = 0;

    $total_orders_list = array();

    $from_date = isset($json_obj->from_date) ? $json_obj->from_date : date('Y-m-d');
    $to_date = isset($json_obj->to_date) ? $json_obj->to_date : date('Y-m-d');

    $total_orders_list_query = "
        SELECT COUNT(*) AS total_orders 
        FROM " . $GLOBALS['order_table'] . " 
        WHERE order_date >= '" . $from_date . "' 
        AND order_date <= '" . $to_date . "'
    ";

    $total_orders_list = $obj->getQueryRecords('', $total_orders_list_query);
    if(!empty($total_orders_list)) {
        $total_order_sms_count = $total_orders_list[0]['total_orders'];
    }

    $otp_send_count_query = "
        SELECT COUNT(*) AS total_otp_send
        FROM " . $GLOBALS['otp_send_phone_numbers_table'] . "
        WHERE send_date_time >= '" . $from_date . "' 
        AND send_date_time <= '" . $to_date . "' AND otp_send_count = 1
    ";

    $otp_send_count_list = $obj->getQueryRecords('', $otp_send_count_query);
    if(!empty($otp_send_count_list)) {
        $total_otp_sms_count = $otp_send_count_list[0]['total_otp_send'];
    }

    $otp_resend_count_query = "
        SELECT otp_send_count
        FROM " . $GLOBALS['otp_send_phone_numbers_table'] . "
        WHERE DATE(send_date_time) >= '" . $from_date . "' 
        AND DATE(send_date_time) <= '" . $to_date . "' AND otp_send_count != 1
    ";

    $otp_resend_count_list = $obj->getQueryRecords('', $otp_resend_count_query);
    if(!empty($otp_resend_count_list)) {
        foreach($otp_resend_count_list as $otp_resend_count) {
            $total_otp_sms_resend_count += ($otp_resend_count['otp_send_count'] - 1);
        }
    }

    $overall_sms_count = $total_order_sms_count + $total_otp_sms_count + $total_otp_sms_resend_count;

    $output["head"]["code"] = 200;
    $output["head"]["msg"] = ["total_order_sms_count" => $total_order_sms_count, "total_otp_sms_count" => $total_otp_sms_count, "total_otp_sms_resend_count" => $total_otp_sms_resend_count, "overall_sms_count" => $overall_sms_count];
} else {
    $output["head"]["code"] = 400;
    $output["head"]["msg"] = "Invalid Request";

}

$result = json_encode($output, JSON_NUMERIC_CHECK);

echo $result;
