<?php
include('domain_config.php');

if (isset($json_obj->get_product_list)) {
    if ($json_obj->get_product_list == 1) {
        $page_number = $json_obj->page_number;
        $page_limit = $json_obj->page_limit;

        if (empty($page_number)) {
            $page_number = 1;
        }

        if (empty($page_limit)) {
            $page_limit = 10;
        }

        $filter_category_id = "";
        if (isset($json_obj->filter_category_id)) {
            $filter_category_id = $json_obj->filter_category_id;
        }

        $total_records_list = array();
        if (!empty($filter_category_id)) {
            $total_records_list = $obj->getTableRecords($GLOBALS['product_table'], 'category_id', $filter_category_id);
        } else {
            $total_records_list = $obj->getTableRecords($GLOBALS['product_table'], '', '');
        }

        $data_length = 0;
        $data_length = count($total_records_list);

        $total_pages = 0;
        if (!empty($total_records_list) && is_array($total_records_list)) {
            $total_pages = count($total_records_list);
        }

        $page_start = 0;
        $page_end = 0;
        if (!empty($page_number) && !empty($page_limit) && !empty($total_pages)) {
            if ($total_pages > $page_limit) {
                if ($page_number) {
                    $page_start = ($page_number - 1) * $page_limit;
                    $page_end = $page_start + $page_limit;
                }
            } else {
                $page_start = 0;
                $page_end = $page_limit;
            }
        }

        $show_records_list = array();
        if (!empty($total_records_list)) {
            foreach ($total_records_list as $key => $val) {
                if ($key >= $page_start && $key < $page_end) {
                    $show_records_list[] = $val;
                }
            }
        }

        $product_code = "";
        $category_name = "";
        $product_name = "";
        $actual_price = "";
        $sales_price = "";
        $show_frontend = 0;
        $product_id = "";
        $creator_name = "";

        $format = 1;
        $format = $obj->getTableColumnValue($GLOBALS['settings_table'], 'name', 'product_price_display_format', 'value');

        if (!empty($show_records_list)) {
            $product_data_array = array();
            foreach ($show_records_list as $key => $data) {
                $category_discount = 0;
                $category_discount = $obj->getCategoryDiscount($data['category_id']);

                if (!empty($data['product_id'])) {
                    $product_id = $data['product_id'];
                }
                if (!empty($data['product_code'])) {
                    $data['product_code'] = $obj->encode_decode('decrypt', $data['product_code']);
                    $product_code = $data['product_code'];
                }
                if (empty($filter_category_id)) {
                    if (!empty($data['category_name'])) {
                        $data['category_name'] = $obj->encode_decode('decrypt', $data['category_name']);
                        $data['category_name'] = str_replace("$", '"', $data['category_name']);
                        $data['category_name'] = str_replace("'''", '"', $data['category_name']);
                        $category_name = $data['category_name'];
                    }
                }
                if (!empty($data['name'])) {
                    $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                    $data['name'] = str_replace("$", '"', $data['name']);
                    $data['name'] = str_replace("'''", '"', $data['name']);
                    $product_name = $data['name'];
                }

                if (!empty($format)) {
                    if ($format == 1) {
                        if (!empty($data['price'])) {
                            $actual_price = $data['price'];
                            if (!empty($category_discount)) {
                                $discounted_value = 0;
                                $discounted_value = ($actual_price * $category_discount) / 100;
                                if (!empty($discounted_value)) {
                                    $discounted_value = number_format($discounted_value, 2);
                                    $discounted_value = str_replace(",", "", $discounted_value);
                                    $sales_price = $actual_price - $discounted_value;
                                }
                            } else {
                                $sales_price = $actual_price;
                            }
                        }
                    } else if ($format == 2) {
                        if (!empty($data['price'])) {
                            $sales_price = $data['price'];
                            if (!empty($sales_price)) {
                                if (!empty($category_discount) && !empty($sales_price)) {
                                    $actual_price = $obj->getActualPrice($sales_price, $category_discount);
                                } else {
                                    $actual_price = $sales_price;
                                }
                            }
                        }
                    }
                }
                if (!empty($actual_price)) {
                    $actual_price = number_format($actual_price, 2);
                }
                if (!empty($sales_price)) {
                    $sales_price = number_format($sales_price, 2);
                }

                $show_frontend = $data['show_frontend'];

                if (!empty($data['creator_name'])) {
                    $creator_name = $obj->encode_decode('decrypt', $data['creator_name']);
                }

                $product_data_array[] = [
                    "creator_name" => $creator_name,
                    "product_id" => $product_id,
                    "product_code" => $product_code,
                    "category_name" => $category_name,
                    "name" => $product_name,
                    "actual_price" => $actual_price,
                    "sales_price" => $sales_price,
                    "show_frontend" => $show_frontend
                ];
            }

            $category_list = array();
            $category_list = $obj->getTableRecords($GLOBALS['category_table'], '', '');

            $category_id_from_table = "";
            $category_name_from_table = "";
            if (!empty($category_list)) {
                $category_data_array = array();
                foreach ($category_list as $data) {
                    if (!empty($data['category_id'])) {
                        $category_id_from_table = $data['category_id'];
                    }
                    if (!empty($data['name'])) {
                        $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                        $data['name'] = str_replace("$", '"', $data['name']);
                        $category_name_from_table = $data['name'];
                    }
                    $category_data_array[] = [
                        "category_id" => $category_id_from_table,
                        "category_name" => $category_name_from_table,
                    ];
                }
            }

            $output["head"]["code"] = 200;
            $output["head"]["msg"] = [
                "product_data" => $product_data_array,
                "category_data" => $category_data_array,
                "data_length" => $data_length,
            ];
        } else {
            $output["head"]["code"] = 400;
            $output["head"]["msg"] = "Data is empty";
        }
    }
}

if (isset($json_obj->get_product_list_ordering)) {
    $total_records_list = array();
    $query = 'SELECT * FROM  ' . $GLOBALS['product_table'] . ' WHERE category_id = "' . $json_obj->get_product_list_ordering . '" AND deleted = 0 ORDER BY ordering ASC';
    $total_records_list = $obj->getQueryRecords('', $query);

    $product_name = "";
    $category_name = "";
    $ordering = "";
    $actual_price = "";
    $sales_price = "";

    $format = 1;
    $format = $obj->getTableColumnValue($GLOBALS['settings_table'], 'name', 'product_price_display_format', 'value');

    if (!empty($total_records_list)) {
        $product_data_array = array();
        foreach ($total_records_list as $key => $data) {
            if (!empty($data['product_id'])) {
                $product_id = $data['product_id'];
            }

            if (!empty($data['name'])) {
                $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                $data['name'] = str_replace("$", '"', $data['name']);
                $data['name'] = str_replace("'''", '"', $data['name']);
                $product_name = $data['name'];
            }

            if (!empty($data['ordering'])) {
                $ordering = $data['ordering'];
            }

            if (!empty($format)) {
                if ($format == 1) {
                    if (!empty($data['price'])) {
                        $actual_price = $data['price'];
                        if (!empty($category_discount)) {
                            $discounted_value = 0;
                            $discounted_value = ($actual_price * $category_discount) / 100;
                            if (!empty($discounted_value)) {
                                $discounted_value = number_format($discounted_value, 2);
                                $discounted_value = str_replace(",", "", $discounted_value);
                                $sales_price = $actual_price - $discounted_value;
                            }
                        } else {
                            $sales_price = $actual_price;
                        }
                    }
                } else if ($format == 2) {
                    if (!empty($data['price'])) {
                        $sales_price = $data['price'];
                        if (!empty($sales_price)) {
                            if (!empty($category_discount) && !empty($sales_price)) {
                                $actual_price = $obj->getActualPrice($sales_price, $category_discount);
                            } else {
                                $actual_price = $sales_price;
                            }
                        }
                    }
                }
            }
            if (!empty($actual_price)) {
                $actual_price = str_replace(',', '', $actual_price);
            }

            $product_data_array[] = [
                "product_id" => $product_id,
                "name" => $product_name,
                "ordering" => $ordering,
                "actual_price" => $actual_price,
            ];
        }

        $output["head"]["code"] = 200;
        $output["head"]["msg"] = $product_data_array;
    } else {
        $output["head"]["code"] = 400;
        $output["head"]["msg"] = "Data is empty";
    }
}

if (isset($json_obj->edit_product_id_frontend)) {
    if (!empty($json_obj->edit_product_id_frontend)) {
        $value = "";
        $value = $json_obj->value;

        $creator_name = "";
        $created_date_time = $GLOBALS['create_date_time_label'];
        $creator = $json_obj->creator_id;
        $creator_name = $obj->getTableColumnValue($GLOBALS['user_table'], 'user_id', $creator, 'name');

        $product_unique_id = "";
        $product_unique_id = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $json_obj->edit_product_id_frontend, 'id');
        if (preg_match("/^\d+$/", $product_unique_id)) {
            $columns = array();
            $values = array();
            $columns = array('created_date_time', 'creator', 'creator_name', 'show_frontend');
            $values = array("'" . $created_date_time . "'", "'" . $creator . "'", "'" . $creator_name . "'", $value);
            $msg = $obj->UpdateSQL($GLOBALS['product_table'], $product_unique_id, $columns, $values, '');
            if (preg_match("/^\d+$/", $product_unique_id)) {
                $output["head"]["code"] = 200;
                $output["head"]["msg"] = "Updated Successfully";
            } else {
                $output["head"]["code"] = 400;
                $output["head"]["msg"] = $msg;
            }
        }
    } else {
        $output["head"]["code"] = 400;
        $output["head"]["msg"] = "Product id missing";
    }
}

if (isset($json_obj->update_product_list_ordering)) {
    if (!empty($json_obj->update_product_list_ordering)) {

        $product_list = array();
        $product_list = $json_obj->update_product_list_ordering;

        $creator_name = "";
        $created_date_time = $GLOBALS['create_date_time_label'];
        $creator = $json_obj->creator_id;
        $creator_name = $obj->getTableColumnValue($GLOBALS['user_table'], 'user_id', $creator, 'name');

        foreach ($product_list as $value) {

            $product_id = $value->product_id;
            $controller_text = $value->controller_text;

            if (!empty($product_id) && !empty($controller_text)) {
                $getUniqueID = "";
                $getUniqueID = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $product_id, 'id');

                if (preg_match("/^\d+$/", $getUniqueID)) {
                    $columns = array();
                    $values = array();
                    $columns = array('created_date_time', 'creator', 'creator_name', 'ordering');
                    $values = array("'" . $created_date_time . "'", "'" . $creator . "'", "'" . $creator_name . "'", "'" . $controller_text . "'");
                    $category_update_id = $obj->UpdateSQL($GLOBALS['product_table'], $getUniqueID, $columns, $values, '');
                    if (preg_match("/^\d+$/", $category_update_id)) {
                        $output["head"]["code"] = 200;
                        $output["head"]["msg"] = "Updated Successfully";
                    } else {
                        $output["head"]["code"] = 400;
                        $output["head"]["msg"] = $category_update_id;
                    }
                } else {
                    $output["head"]["code"] = 400;
                    $output["head"]["msg"] = "Some feilds are empty";
                }
            }
        }
    } else {
        $output["head"]["code"] = 400;
        $output["head"]["msg"] = "Product id missing";
    }
}

if (isset($json_obj->update_product_list_price)) {
    if (!empty($json_obj->update_product_list_price)) {
        $product_list = array();
        $product_list = $json_obj->update_product_list_price;

        foreach ($product_list as $data) {
            $price_change_product_id = $data->product_id;
            $change_price =  $data->modified_price;
            $change_price = trim(str_replace(",", "", $change_price));
            $change_price = $valid->clean_value($change_price);

            if (!empty($price_change_product_id) && !empty($change_price)) {
                if (preg_match("/^[0-9]+(\\.[0-9]+)?$/", $change_price)) {

                    $product_unique_id = "";
                    $product_unique_id = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $price_change_product_id, 'id');
                    if (preg_match("/^\d+$/", $product_unique_id)) {

                        $product_list = array();
                        $category_id = "";
                        $product_code = "";
                        $name = "";
                        $product_list = $obj->getTableRecords($GLOBALS['product_table'], 'id', $product_unique_id);
                        if (!empty($product_list)) {
                            foreach ($product_list as $data) {
                                if (!empty($data['category_id'])) {
                                    $category_id = $data['category_id'];
                                }
                                if (!empty($data['product_code'])) {
                                    $product_code = $data['product_code'];
                                }
                                if (!empty($data['name'])) {
                                    $name = $data['name'];
                                }
                            }
                        }

                        $actual_price = 0;
                        $sales_price = 0;
                        $category_discount = 0;
                        $category_discount = $obj->getCategoryDiscount($category_id);
                        //echo "category_discount - ".$category_discount."<br>";

                        // $format = 1;
                        // $format = $obj->getTableColumnValue($GLOBALS['settings_table'], 'name', 'product_price_display_format', 'value');
                        // if (!empty($format) && $format == 1) {
                        //     if (!empty($change_price)) {
                        //         if (!empty($category_discount) && !empty($change_price)) {
                        //             $change_price = $obj->getActualPrice($change_price, $category_discount);
                        //         }
                        //     }
                        // }

                        $action = "";
                        $columns = array();
                        $values = array();
                        $columns = array('price');
                        $values = array("'" . $change_price . "'");
                        $msg = $obj->UpdateSQL($GLOBALS['product_table'], $product_unique_id, $columns, $values, $action);
                    }
                }
            }
        }
        $output["head"]["code"] = 200;
        $output["head"]["msg"] = "Updated Successfully";
    } else {
        $output["head"]["code"] = 400;
        $output["head"]["msg"] = "Invalid Request";
    }
}

if (isset($json_obj->show_product_id)) {
    $show_product_id = $json_obj->show_product_id;

    $category_id = "";
    $name = "";
    $product_code = "";
    $product_content = "";
    $price = "";
    $product_image = "";
    $product_video = "";


    if (!empty($show_product_id)) {
        $product_list = array();
        $product_list = $obj->getTableRecords($GLOBALS['product_table'], 'product_id', $show_product_id);
        if (!empty($product_list)) {
            $product_data_array = array();

            foreach ($product_list as $data) {
                if (!empty($data['category_id'])) {
                    $category_id = $data['category_id'];
                }
                if (!empty($data['name'])) {
                    $name = $obj->encode_decode('decrypt', $data['name']);
                    $name = str_replace("$", "''", $name);
                }
                if (!empty($data['product_code'])) {
                    $product_code = $obj->encode_decode('decrypt', $data['product_code']);
                }
                if (!empty($data['product_content'])) {
                    $product_content = $obj->encode_decode('decrypt', $data['product_content']);
                }
                if (!empty($data['price'])) {
                    $price = $data['price'];
                }
                if (!empty($data['product_video']) && $data['product_video'] != $GLOBALS['null_value']) {
                    $product_video = $obj->encode_decode('decrypt', $data['product_video']);
                }

                if (!empty($data['product_image']) && $data['product_image'] != $GLOBALS['null_value']) {
                    $product_image = $domain_name . "/images/upload/" . $data['product_image'];
                }

                $product_data_array[] = [
                    "category_id" => $category_id,
                    "name" => $name,
                    "product_code" => $product_code,
                    "product_content" => $product_content,
                    "price" => $price,
                    "product_video" => $product_video,
                    "product_image" => $product_image
                ];
            }

            $category_list = array();
            $category_list = $obj->getTableRecords($GLOBALS['category_table'], '', '');

            $category_id_from_table = "";
            $category_name_from_table = "";
            if (!empty($category_list)) {
                $category_data_array = array();
                foreach ($category_list as $data) {
                    if (!empty($data['category_id'])) {
                        $category_id_from_table = $data['category_id'];
                    }
                    if (!empty($data['name'])) {
                        $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                        $data['name'] = str_replace("$", '"', $data['name']);
                        $category_name_from_table = $data['name'];
                    }
                    $category_data_array[] = [
                        "category_id" => $category_id_from_table,
                        "category_name" => $category_name_from_table,
                    ];
                }
            }
            $output["head"]["code"] = 200;
            $output["head"]["msg"] = [
                "product_data" => $product_data_array,
                "category_data" => $category_data_array,
            ];
        } else {
            $output["head"]["code"] = 400;
            $output["head"]["msg"] = "Data is empty";
        }
    } else {
        $category_list = array();
        $category_list = $obj->getTableRecords($GLOBALS['category_table'], '', '');

        $category_id_from_table = "";
        $category_name_from_table = "";
        if (!empty($category_list)) {
            $category_data_array = array();
            foreach ($category_list as $data) {
                if (!empty($data['category_id'])) {
                    $category_id_from_table = $data['category_id'];
                }
                if (!empty($data['name'])) {
                    $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                    $data['name'] = str_replace("$", '"', $data['name']);
                    $category_name_from_table = $data['name'];
                }
                $category_data_array[] = [
                    "category_id" => $category_id_from_table,
                    "category_name" => $category_name_from_table,
                ];
            }
        }

        $product_data_array[] = [
            "category_id" => "",
            "name" => "",
            "product_code" => "",
            "product_content" => "",
            "price" => "",
            "product_video" => ""
        ];
        $output["head"]["code"] = 200;
        $output["head"]["msg"] = [
            "product_data" => $product_data_array,
            "category_data" => $category_data_array,
        ];
    }
}

if (isset($json_obj->edit_product_id)) {
    $category_id = "";
    $category_id_error = "";
    $name = "";
    $name_error = "";
    $product_code = "";
    $product_code_error = "";
    $product_content = "";
    $product_content_error = "";
    $price = "";
    $price_error = "";
    $product_video = "";

    $valid_product = "";

    $category_id = $json_obj->category_id;
    $category_id = $valid->clean_value($category_id);
    if (empty($category_id)) {
        $category_id_error = "Select the category";
    }
    if (!empty($category_id) && empty($category_id_error)) {
        $category_unique_id = "";
        $category_unique_id = $obj->getTableColumnValue($GLOBALS['category_table'], 'category_id', $category_id, 'id');
        if (!preg_match("/^\d+$/", $category_unique_id)) {
            $category_id_error = "Invalid category";
        }
    }
    if (!empty($category_id_error)) {
        $valid_product = $category_id_error;
    }

    $name = $json_obj->product_name;
    $name = $valid->clean_value($name);
    $name_error = $valid->common_validation($name, "name", "text");
    if (!empty($name) && empty($name_error)) {
        if (strlen($name) > 60) {
            $name_error = "Product name is max 60 characters are allowed";
        }
    }
    if (!empty($name_error)) {
        if (!empty($valid_product)) {
            $valid_product = $valid_product . $name_error;
        } else {
            $valid_product = $valid_product;
        }
    }

    $product_code = $json_obj->product_code;
    $product_code = $valid->clean_value($product_code);
    $product_code_error = $valid->common_validation($product_code, "product code", "text");
    if (!empty($product_code_error)) {
        if (!empty($valid_product)) {
            $valid_product = $valid_product . $product_code_error;
        } else {
            $valid_product = $valid_product;
        }
    }

    $product_content =  $json_obj->product_content;
    $product_content = $valid->clean_value($product_content);
    $product_content_error = $valid->common_validation($product_content, "product content", "text");
    if (!empty($product_content_error)) {
        if (!empty($valid_product)) {
            $valid_product = $valid_product . " " . $product_content_error;
        } else {
            $valid_product = $valid_product;
        }
    }

    $price = $json_obj->price;
    $price = trim(str_replace(",", "", $price));
    $price = $valid->clean_value($price);
    $price_error = $valid->valid_price($price, "Price", "1");
    if (!empty($price_error)) {
        if (!empty($valid_product)) {
            $valid_product = $valid_product . " " . $price_error;
        } else {
            $valid_product =  $valid_product;
        }
    }

    if (isset($json_obj->video_url)) {
        $product_video = $json_obj->video_url;
        $product_video = $valid->clean_value($product_video);
    }

    if (isset($json_obj->edit_product_id)) {
        $edit_id = $json_obj->edit_product_id;
    }

    $result = "";


    if (empty($valid_product)) {
        $lower_case_name = "";
        $lower_case_product_code = "";
        if (!empty($name)) {
            $name = str_replace("''", "$", $name);
            $name = str_replace('"', "$", $name);
            $lower_case_name = strtolower($name);
            $lower_case_name = $obj->encode_decode('encrypt', $lower_case_name);
            $name = $obj->encode_decode('encrypt', $name);
        }
        if (!empty($product_code) && $product_code != $GLOBALS['null_value']) {
            $lower_case_product_code = strtolower($product_code);
            $lower_case_product_code = $obj->encode_decode('encrypt', $lower_case_product_code);
            $product_code = $obj->encode_decode('encrypt', $product_code);
        } else {
            $product_code = $GLOBALS['null_value'];
        }

        if (!empty($product_content)) {
            $product_content = $obj->encode_decode('encrypt', $product_content);
        }

        if (!empty($product_video)) {
            $product_video = $obj->encode_decode('encrypt', $product_video);
        } else {
            $product_video = $GLOBALS['null_value'];
        }

        $prev_product_id = "";
        $product_error = "";

        if (!empty($lower_case_product_code) && empty($product_error)) {
            if (empty($edit_id)) {
                $prev_product_id = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_code', $lower_case_product_code, 'product_id');
                if (!empty($prev_product_id)) {
                    $product_error = "This product code already exist";
                }
            }
        }

        if (empty($edit_id)) {
            if (empty($prev_product_id)) {
                $created_date_time = $GLOBALS['create_date_time_label'];
                $creator = $json_obj->creator_id;
                $creator_name = $obj->getTableColumnValue($GLOBALS['user_table'], 'user_id', $creator, 'name');

                $ordering_number = "";
                $ordering_number = $obj->getOrderingNumber($GLOBALS['product_table'], $category_id);

                $null_value = $GLOBALS['null_value'];
                $columns = array('created_date_time', 'creator', 'creator_name', 'product_id', 'category_id', 'name', 'lower_case_name', 'product_code', 'product_content', 'price', 'product_image', 'product_video', 'ordering', 'show_frontend', 'deleted');
                $values = array("'" . $created_date_time . "'", "'" . $creator . "'", "'" . $creator_name . "'", "'" . $null_value . "'", "'" . $category_id . "'", "'" . $name . "'", "'" . $lower_case_name . "'", "'" . $product_code . "'", "'" . $product_content . "'", "'" . $price . "'", "'" . $null_value . "'", "'" . $product_video . "'", "'" . $ordering_number . "'", "'0'", "'0'");
                $product_insert_id = $obj->InsertSQL($GLOBALS['product_table'], $columns, $values, '');
                if (preg_match("/^\d+$/", $product_insert_id)) {
                    $product_id = "";
                    if ($product_insert_id < 10) {
                        $product_id = "PRODUCT_0" . $product_insert_id;
                    } else {
                        $product_id = "PRODUCT_" . $product_insert_id;
                    }
                    if (!empty($product_id)) {
                        $product_id = $obj->encode_decode('encrypt', $product_id);
                    }

                    $columns = array();
                    $values = array();
                    $columns = array('product_id');
                    $values = array("'" . $product_id . "'");
                    $product_update_id = $obj->UpdateSQL($GLOBALS['product_table'], $product_insert_id, $columns, $values, '');
                    if (preg_match("/^\d+$/", $product_update_id)) {
                        $output["head"]["code"] = 200;
                        $output["head"]["msg"] = 'Product Successfully Created';
                    } else {
                        $output["head"]["code"] = 400;
                        $output["head"]["msg"] = $product_update_id;
                    }
                } else {
                    $output["head"]["code"] = 400;
                    $output["head"]["msg"] = $product_insert_id;
                }
            } else {
                $output["head"]["code"] = 400;
                $output["head"]["msg"] = $product_error;
            }
        } else {
            if (empty($prev_product_id) || $prev_product_id == $edit_id) {
                $getUniqueID = "";
                $getUniqueID = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $edit_id, 'id');
                if (preg_match("/^\d+$/", $getUniqueID)) {

                    $columns = array();
                    $values = array();
                    $columns = array('category_id', 'name', 'lower_case_name', 'product_code', 'product_content', 'price', 'product_video');
                    $values = array("'" . $category_id . "'", "'" . $name . "'", "'" . $lower_case_name . "'", "'" . $product_code . "'", "'" . $product_content . "'", "'" . $price . "'", "'" . $product_video . "'");
                    $product_update_id = $obj->UpdateSQL($GLOBALS['product_table'], $getUniqueID, $columns, $values, $action);
                    if (preg_match("/^\d+$/", $product_update_id)) {
                        $output["head"]["code"] = 200;
                        $output["head"]["msg"] = 'Updated Successfully';
                    } else {
                        $output["head"]["code"] = 400;
                        $output["head"]["msg"] = $product_update_id;
                    }
                }
            } else {
                $output["head"]["code"] = 400;
                $output["head"]["msg"] = $product_error;
            }
        }
    } else {
        if (!empty($valid_product)) {
            $output["head"]["code"] = 400;
            $output["head"]["msg"] = $valid_product;
        }
    }
}

if (isset($json_obj->show_hide_product_id)) {
    $show_hide_product_id = $json_obj->show_hide_product_id;
    $show_frontend = $json_obj->show_frontend;
    $msg = "";
    if (!empty($show_hide_product_id)) {
        $product_unique_id = "";
        $product_unique_id = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $show_hide_product_id, 'id');
        if (preg_match("/^\d+$/", $product_unique_id)) {
            $product_code = "";
            $product_code = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $show_hide_product_id, 'product_code');

            $name = "";
            $name = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $show_hide_product_id, 'name');

            $columns = array();
            $values = array();
            $columns = array('show_frontend');
            $values = array("'" . $show_frontend . "'");
            $msg = $obj->UpdateSQL($GLOBALS['product_table'], $product_unique_id, $columns, $values, '');
            if (preg_match("/^\d+$/", $msg)) {
                $output["head"]["code"] = 200;
                $output["head"]["msg"] = "Product hided in frontend";
            } else {
                $output["head"]["code"] = 400;
                $output["head"]["msg"] = $msg;
            }
        }
    } else {
        $output["head"]["code"] = 400;
        $output["head"]["msg"] = "Product Id Missing";
    }
}

if (isset($json_obj->delete_product_id)) {
    $delete_product_id = $json_obj->delete_product_id;
    $msg = "";
    if (!empty($delete_product_id)) {
        $product_unique_id = "";
        $product_unique_id = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $delete_product_id, 'id');
        if (preg_match("/^\d+$/", $product_unique_id)) {
            $product_code = "";
            $product_code = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $delete_product_id, 'product_code');

            $name = "";
            $name = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $delete_product_id, 'name');

            $action = "";
            if (!empty($name)) {
                $action = "Product Deleted. Code - " . $obj->encode_decode('decrypt', $product_code) . " Name - " . str_replace("$", '"', $obj->encode_decode('decrypt', $name));
            }

            $columns = array();
            $values = array();
            $columns = array('deleted');
            $values = array("'1'");
            $msg = $obj->UpdateSQL($GLOBALS['product_table'], $product_unique_id, $columns, $values, $action);
            if (preg_match("/^\d+$/", $msg)) {
                $output["head"]["code"] = 200;
                $output["head"]["msg"] = "Product Deleted";
            } else {
                $output["head"]["code"] = 400;
                $output["head"]["msg"] = $msg;
            }
        } else {
            $output["head"]["code"] = 400;
            $output["head"]["msg"] = "Product not found";
        }
    } else {
        $output["head"]["code"] = 400;
        $output["head"]["msg"] = "Product Id Missing";
    }
}

if (isset($json_obj->price_change_product_id)) {
    $price_change_product_id = $json_obj->price_change_product_id;
    $change_price = $json_obj->change_price;
    $change_price = trim(str_replace(",", "", $change_price));
    $change_price = $valid->clean_value($change_price);

    $msg = "";
    if (!empty($price_change_product_id) && !empty($change_price)) {
        if (preg_match("/^[0-9]+(\\.[0-9]+)?$/", $change_price)) {

            $product_unique_id = "";
            $product_unique_id = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $price_change_product_id, 'id');
            if (preg_match("/^\d+$/", $product_unique_id)) {

                $product_list = array();
                $category_id = "";
                $product_code = "";
                $name = "";
                $product_list = $obj->getTableRecords($GLOBALS['product_table'], 'id', $product_unique_id);
                if (!empty($product_list)) {
                    foreach ($product_list as $data) {
                        if (!empty($data['category_id'])) {
                            $category_id = $data['category_id'];
                        }
                        if (!empty($data['product_code'])) {
                            $product_code = $data['product_code'];
                        }
                        if (!empty($data['name'])) {
                            $name = $data['name'];
                        }
                    }
                }

                $actual_price = 0;
                $sales_price = 0;
                $category_discount = 0;
                $category_discount = $obj->getCategoryDiscount($category_id);
                //echo "category_discount - ".$category_discount."<br>";

                $format = 1;
                $format = $obj->getTableColumnValue($GLOBALS['settings_table'], 'name', 'product_price_display_format', 'value');
                if (!empty($format) && $format == 1) {
                    if (!empty($change_price)) {
                        if (!empty($category_discount) && !empty($change_price)) {
                            $change_price = $obj->getActualPrice($change_price, $category_discount);
                        }
                    }
                }

                $columns = array();
                $values = array();
                $columns = array('price');
                $values = array("'" . $change_price . "'");
                $msg = $obj->UpdateSQL($GLOBALS['product_table'], $product_unique_id, $columns, $values, '');
                if (preg_match("/^\d+$/", $msg)) {
                    $output["head"]["code"] = 200;
                    $output["head"]["msg"] = "Product price updated";
                } else {
                    $output["head"]["code"] = 400;
                    $output["head"]["msg"] = $msg;
                }
            } else {
                $output["head"]["code"] = 400;
                $output["head"]["msg"] = "Invalid Product";
            }
        } else {
            $output["head"]["code"] = 400;
            $output["head"]["msg"] = "Invalid Price";
        }
    } else {
        $output["head"]["code"] = 400;
        $output["head"]["msg"] = "Price Missing";
    }
}

if (isset($json_obj->get_pricelist_excel)) {
    $pricelist = array();
    $pricelist = $obj->ProductPricelist('1');

    if ($json_obj->get_pricelist_excel == 1) {

        $product_data = array();
        $category_data = array();
        $category_name = "";
        $product_name = "";
        $price = "";
        if (!empty($pricelist)) {
            foreach ($pricelist as $data) {
                $category_name = $data['category_name'];

                if (!empty($category_name)) {
                    $category_name = $obj->encode_decode('decrypt', $category_name);
                }

                foreach ($data['product_list'] as $value) {
                    $product_name = $value['name'];
                    $price = $value['price'];

                    if (!empty($product_name)) {
                        $product_name = $obj->encode_decode('decrypt', $product_name);
                    }

                    $product_data[] = ["product_name" => $product_name, "price" => $price];
                }

                $category_data[] = ["category_name" => $category_name, "product_list" => $product_data];
            }
            $output["head"]["code"] = 200;
            $output["head"]["msg"] = $category_data;
        } else {
            $output["head"]["code"] = 400;
            $output["head"]["msg"] = "Empty Data";
        }
    } else {
        $output["head"]["code"] = 400;
        $output["head"]["msg"] = "Invalid Request";
    }
}

if (isset($json_obj->get_pricelist_pdf)) {
    $product_price_display_format = 1;
    $product_price_display_format = $obj->getTableColumnValue($GLOBALS['settings_table'], 'name', 'product_price_display_format', 'value');

    if ($json_obj->get_pricelist_pdf == 1) {
        $pdf_url = "" . $domain_name . "/order/pdf/rpt_price_list.php?format=$product_price_display_format";

        $output["head"]["code"] = 200;
        $output["head"]["msg"] = ["pdf_url" => $pdf_url];
    } else {
        $output["head"]["code"] = 400;
        $output["head"]["msg"] = "Invalid Request";
    }
}

$result = json_encode($output, JSON_NUMERIC_CHECK);

echo $result;