<?php

header('Content-Type: application/json; charset=utf-8');

$json = file_get_contents('php://input');

$json_obj = json_decode($json);

$output = array();

$result = "";

$domain_name = ""; $admin_folder_name = "";
if(isset($json_obj->domain_name)) { 
    $domain_name = $json_obj->domain_name;		
    $domain_name = trim($domain_name);

    if(isset($json_obj->admin_folder_name)) { 
        $admin_folder_name = $json_obj->admin_folder_name;		
        $admin_folder_name = trim($admin_folder_name);
    }

    if(!empty($domain_name) && !empty($admin_folder_name)) {
        $domain_admin_path = "../".$domain_name."/".$admin_folder_name."/include.php";

        include($domain_admin_path);

        if (isset($json_obj->get_product_sales_list)) {
            if ($json_obj->get_product_sales_list == 1) {
                $from_date = $json_obj->from_date;
                $to_date = $json_obj->to_date;
        
                $status = '';
                $status = $json_obj->status;
        
                $total_records_list = array();

                $list = array();
                $where = "";
                
                if (!empty($from_date)) {
                    $from_date = date("Y-m-d", strtotime($from_date));
                    $where = "DATE(order_date) >= '" . $from_date . "'";
                }
                if (!empty($to_date)) {
                    $to_date = date("Y-m-d", strtotime($to_date));
                    if (!empty($where)) {
                        $where = $where . " AND DATE(order_date) <= '" . $to_date . "'";
                    } else {
                        $where = "DATE(order_date) <= '" . $to_date . "'";
                    }
                }
                
                if (!empty($status)) {
                    $condition = "";
                    if ($status == "1") {
                        $condition = "confirmed='1' and despatched='' and delivered='' ";
                    } else if ($status == "2") {
                        $condition = "confirmed='1' and despatched='1' and delivered='' ";
                    } else if ($status == "3") {
                        $condition = "confirmed='1' and despatched='1' and delivered='1' ";
                    } else if ($status == "4") {
                        $condition = "confirmed='' and despatched='' and delivered='' ";
                    } else if ($status == "5") {
                        $condition = "new_order=1";
                    }
                
                    if (!empty($condition)) {
                        if (!empty($where)) {
                            $where = $where . " AND " . $condition;
                        } else {
                            $where = $condition;
                        }
                    }
                }
                
                $select_query = "";
                if (!empty($where)) {
                    $select_query = "SELECT * FROM " . $GLOBALS['order_table'] . " WHERE " . $where . " AND deleted = '0' ORDER BY id DESC";
                } else {
                    $select_query = "SELECT * FROM " . $GLOBALS['order_table'] . " WHERE deleted = '0' ORDER BY id DESC";
                }
                
                if (!empty($select_query)) {
                    $list = $obj->getQueryRecords($GLOBALS['order_table'], $select_query);
                }

                $total_records_list = $list;

                $product_array = array();
        
                foreach ($total_records_list as $data) {
                    $product_ids = explode(',', $data['product_id']);
                    $product_names = explode(',', $data['product_name']);
                    $quantities = explode(',', $data['quantity']);
        
                    for ($i = 0; $i < count($product_ids); $i++) {
                        $product_id = trim($product_ids[$i]);
                        $product_name = trim($product_names[$i]);
                        $quantity = trim($quantities[$i]);
        
                        $found = false;
                        foreach ($product_array as &$product) {
                            if ($product['product_id'] == $product_id) {
                                $product['quantity'] += $quantity;
                                $found = true;
                                break;
                            }
                        }
        
                        if (!$found) {
                            $product_array[] = array(
                                'product_id' => $product_id,
                                'product_name' => $obj->encode_decode('decrypt', $product_name),
                                'quantity' => $quantity
                            );
                        }
                    }
                }
                unset($quantity_array);
        
                $output["head"]["code"] = 200;
                $output["head"]["msg"] = $product_array;
            } else {
                $output["head"]["code"] = 400;
                $output["head"]["msg"] = "Invalid Request";
            }
        }        
    }
}

$result = json_encode($output, JSON_NUMERIC_CHECK);

echo $result;
