<?php
    class Process_Functions extends Common_Functions {	

		public function getNewArrivalsProductList() {
			$con = $this->connect(); $list = array(); $select_query = "";
			$new_arrivals_category_count = 0;
			$new_arrivals_category_count = $this->getTableColumnValue($GLOBALS['settings_table'], 'name', 'new_arrivals_category_count', 'value');
			if(!empty($new_arrivals_category_count) && $new_arrivals_category_count != $GLOBALS['null_value']) {

				$new_arrivals_headings = ""; $new_arrivals_products = "";
				$new_arrivals_headings = $this->getTableColumnValue($GLOBALS['settings_table'], 'name', 'new_arrivals_headings', 'value');				
				$new_arrivals_products = $this->getTableColumnValue($GLOBALS['settings_table'], 'name', 'new_arrivals_products', 'value');
				if(!empty($new_arrivals_headings) && $new_arrivals_headings != $GLOBALS['null_value']) {
					$new_arrivals_headings = explode("$$$", $new_arrivals_headings);

					if(!empty($new_arrivals_products) && $new_arrivals_products != $GLOBALS['null_value']) {
						$new_arrivals_products = explode("$$$", $new_arrivals_products);
					}

					for($i = 0; $i < count($new_arrivals_headings); $i++) {
						if(!empty($new_arrivals_headings[$i])) {
							$product_list = array(); $select_query = "";
							if(!empty($new_arrivals_products[$i])) {
								$select_query = "SELECT * FROM ".$GLOBALS['product_table']." WHERE 
													FIND_IN_SET(product_id, :product_ids) AND show_frontend = '0' AND deleted = '0'";
								if(!empty($select_query)) {
									$result = 0; $pdo = "";			
									$pdo = $con->prepare($select_query);
									$pdo->bindParam(':product_ids', $new_arrivals_products[$i], PDO::PARAM_STR);
									$pdo->execute();	
									$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
									if(!empty($result)) {
										foreach($pdo->fetchAll() as $row) {
											$product_list[] = $row;
										}
									}
								}
							}
							if(!empty($product_list)) {
								$list[] = array('category_name' => $new_arrivals_headings[$i], 'product_list' => $product_list);
							}
						}
					}
				}
			}
			return $list;
		}

		public function getClearTableRecords($tables) {
			$success = 0; $con = $this->connect();
			if(!empty($tables)) {
				foreach($tables as $table) {
					if(!empty($table)) {
						$table = trim(str_replace("'", "", $table));
						$update_query = "";
						$update_query = "UPDATE ".$table." SET deleted = '1'";
						if(!empty($update_query)) {							
							$result = $con->prepare($update_query);
							if($result->execute() === TRUE) {
								$success++;	
							}
						}
					}
				}
				if($success == count($tables)) {
					$success = 1;
				}
				else {
					$success = "Unable to clear";
				}
			}
			return $success;
		}

		public function getNthRecord($table, $number) {
			$con = $this->connect(); $unique_id = 0;
			if(!empty($table) && !empty($number)) {
				$number = $number - 1;
				$list = array(); $select_query = "";
				$select_query = "SELECT id FROM ".$table." ORDER BY ID LIMIT ".$number.", 1";
				if(!empty($select_query)) {
					$result = 0; $pdo = "";			
					$pdo = $con->prepare($select_query);
					$pdo->execute();	
					$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
					if(!empty($result)) {
						foreach($pdo->fetchAll() as $row) {
							if(!empty($row['id'])) {
								$unique_id = $row['id'];
							}
						}
					}
				}
			}
			return $unique_id;	
		}

		public function DisplayCustomerStates() {
			$con = $this->connect(); $list = array(); $select_query = "";
			$select_query = "SELECT * FROM ".$GLOBALS['state_city_table']." WHERE deleted = '0' ORDER BY id ASC";
			if(!empty($select_query)) {
				$result = 0; $pdo = "";			
				$pdo = $con->prepare($select_query);
				$pdo->execute();	
				$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
				if(!empty($result)) {
					foreach($pdo->fetchAll() as $row) {
						$list[] = $row;
					}
				}
			}
			return $list;
		}

		public function DisplayMinOrderAmountPacking($state) {
			$con = $this->connect(); $list = array(); $select_query = ""; $minimum_order_amount = 0; $packing_charges = 0; $details = array();
			if(!empty($state)) {
				$select_query = "SELECT * FROM ".$GLOBALS['state_city_table']." WHERE state = :state AND deleted = '0' ORDER BY id ASC";
				if(!empty($select_query)) {
					$result = 0; $pdo = "";			
					$pdo = $con->prepare($select_query);
					$pdo->bindParam(':state', $state, PDO::PARAM_STR);
					$pdo->execute();	
					$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
					if(!empty($result)) {
						foreach($pdo->fetchAll() as $row) {
							$list[] = $row;
						}
					}
				}
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['minimum_order_amount']) && $data['minimum_order_amount'] != $GLOBALS['null_value']) {
							$minimum_order_amount = $data['minimum_order_amount'];
						}
						if(!empty($data['packing_charges']) && $data['packing_charges'] != $GLOBALS['null_value']) {
							$packing_charges = $data['packing_charges'];
						}
					}
				}
				$details = array('minimum_order_amount' => $minimum_order_amount, 'packing_charges' => $packing_charges);
			}

			return $details;
		}

		public function DisplayCitiesByState($state) {
			$con = $this->connect(); $list = array(); $select_query = "";
			if(!empty($state)) {
				$select_query = "SELECT * FROM ".$GLOBALS['state_city_table']." WHERE state = :state AND deleted = '0' ORDER BY id ASC";
				if(!empty($select_query)) {
					$result = 0; $pdo = "";			
					$pdo = $con->prepare($select_query);
					$pdo->bindParam(':state', $state, PDO::PARAM_STR);
					$pdo->execute();	
					$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
					if(!empty($result)) {
						foreach($pdo->fetchAll() as $row) {
							$cities = "";
							if(!empty($row['cities']) && $row['cities'] != $GLOBALS['null_value']) {
								$cities = $this->encode_decode('decrypt', $row['cities']);
								if(!empty($cities)) {
                        			$list = explode("$$$", $cities);
								}
							}
						}
					}
				}
			}
			return $list;
		}

        public function getOrderingNumber($table, $category_id) {
			$con = $this->connect(); $ordering_number = 1; $select_query = "";
			if(!empty($table)) {
				if(!empty($category_id)) {
					$select_query = "SELECT ordering FROM ".$table." WHERE category_id = :category_id AND deleted = '0' ORDER BY ordering DESC LIMIT 1";
				}
				else {
					$select_query = "SELECT ordering FROM ".$table." WHERE deleted = '0' ORDER BY ordering DESC LIMIT 1";
				}
				if(!empty($select_query)) {
					$result = 0; $pdo = "";			
					$pdo = $con->prepare($select_query);
					if(!empty($category_id)) {
						$pdo->bindParam(':category_id', $category_id, PDO::PARAM_STR);
					}
					$pdo->execute();	
					$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
					if(!empty($result)) {
						foreach($pdo->fetchAll() as $row) {
							if(!empty($row['ordering'])) {
								$ordering_number = $row['ordering'] + 1;
							}
						}
					}
				}
			}
			return $ordering_number;
		}

		public function DisplayCategoryByOrder() {
			$con = $this->connect(); $list = array(); $select_query = "";
			$select_query = "SELECT * FROM ".$GLOBALS['category_table']." WHERE deleted = '0' ORDER BY ordering ASC";
			if(!empty($select_query)) {
				$result = 0; $pdo = "";			
				$pdo = $con->prepare($select_query);
				$pdo->execute();	
				$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
				if(!empty($result)) {
					foreach($pdo->fetchAll() as $row) {
						$list[] = $row;
					}
				}
			}
			return $list;
		}

		public function DisplayCategoryProductsByOrder($category_id) {
			$con = $this->connect(); $list = array(); $select_query = "";
			if(!empty($category_id)) {
				$select_query = "SELECT * FROM ".$GLOBALS['product_table']." WHERE category_id = :category_id AND deleted = '0' ORDER BY ordering ASC";
				if(!empty($select_query)) {
					$result = 0; $pdo = "";			
					$pdo = $con->prepare($select_query);
					$pdo->bindParam(':category_id', $category_id, PDO::PARAM_STR);
					$pdo->execute();	
					$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
					if(!empty($result)) {
						foreach($pdo->fetchAll() as $row) {
							$list[] = $row;
						}
					}
				}
			}
			return $list;
		}

		public function getCategoryDiscount($category_id) {
			$con = $this->connect(); $select_query = ""; $discount = 0;
			if(!empty($category_id)) {
				$select_query = "SELECT discount FROM ".$GLOBALS['discount_table']." WHERE FIND_IN_SET(:category_id, category_ids) 
									AND show_frontend = '0' AND deleted = '0' ORDER BY id ASC";
				if(!empty($select_query)) {
					$result = 0; $pdo = "";			
					$pdo = $con->prepare($select_query);
					$pdo->bindParam(':category_id', $category_id, PDO::PARAM_STR);
					$pdo->execute();	
					$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
					if(!empty($result)) {
						foreach($pdo->fetchAll() as $row) {
							if(!empty($row['discount'])) {
								$discount = $row['discount'];
							}
						}
					}
				}
			}
			return $discount;
		}

		public function ProductPricelist($frontend) {
			$company_logo = ""; $company_list = array();
			$company_list = $this->getTableRecords($GLOBALS['company_table'], '', '');
			if(!empty($company_list)) {
				foreach($company_list as $data) {
					if(!empty($data['logo']) && $data['logo'] != $GLOBALS['null_value']) {
						$company_logo = $data['logo'];
					}
				}
			}

			$target_dir = "";
    		$target_dir = $this->image_directory();
			$target_dir = str_replace("../", "", $target_dir);

			$category_list = array(); $frontend_pricelist = array(); $backend_pricelist = array(); $pricelist = array();
			$category_list = $this->DisplayCategoryByOrder();
			if(!empty($category_list)) {
				foreach($category_list as $data) {

					if(!empty($frontend) && $frontend == 1) {
						if(empty($data['show_frontend'])) {
							if(!empty($data['category_id']) && !empty($data['name'])) {

								$discount = 0;
								$discount = $this->getCategoryDiscount($data['category_id']);

								$product_list = array();
								$product_list = $this->DisplayCategoryProductsByOrder($data['category_id']);
								if(!empty($product_list)) {
									$frontend_products = array();
									foreach($product_list as $product) {
										if(!empty($product['product_image'])) {

											$product_images = array(); $product_image = ""; $sub_images = array();
											$product_images = explode("$$$", $product['product_image']);
											if(!empty($product_images)) {
												for($p = 0; $p < count($product_images); $p++) {
													if(!empty($p)) {
														if(!empty($product_images[$p])) {
															$sub_images[] = $product_images[$p];
														}
													}
													else {
														if(!empty($product_images[$p])) {
															$product_image = $product_images[$p];
															/*if(!empty($product_image) && file_exists($target_dir.$product_image)) {
																$product['product_image'] = "thumb_".$product_image;
															}*/
														}
													}
												}
												if(!empty($sub_images) && count($sub_images) > 0) {
													$product['sub_images'] = $sub_images;
												}
												else {
													$product['sub_images'] = $GLOBALS['null_value'];
												}
											}
											if(!file_exists($target_dir.$product_image)) {
												/*if(file_exists($target_dir.$company_logo)) {
													$product['product_image'] = "thumb_".$company_logo;
												}*/
												if(file_exists($target_dir.$company_logo)) {
													$product['product_image'] = $company_logo;
												}
											}
											else {
												if(file_exists($target_dir.$product_image)) {
													$product['product_image'] = $product_image;
												}
											}
										}
										$video_id = "";
										if(!empty($product['product_video']) && $product['product_video'] != $GLOBALS['null_value']) {
											$product['product_video'] = $this->encode_decode('decrypt', $product['product_video']);
											if(strpos($product['product_video'], "youtu.be/" ) !== false) {
												$matches = "";
												preg_match('/(https:|http:|)(\/\/www\.|\/\/|)(.*?)\/(.{11})/i', $product['product_video'], $matches);
												if(!empty($matches) && is_array($matches)) {
													if(!empty($matches['4'])) {
														$video_id = $matches['4'];
													}
												}
											}
											else if(strpos($product['product_video'], "youtube.com/shorts" ) !== false) {
												$videos = array();
												$videos = explode("?", $product['product_video']);
												if(!empty($videos['0'])) {
													$last_position = 0;
													$last_position = strrpos($videos['0'], "/");
													if(!empty($last_position)) {
														$video_id = substr($videos['0'], $last_position + 1, strlen($videos['0']));
													}
												}
											}
										}
										$product['product_video_id'] = $video_id;

										if(empty($product['show_frontend'])) {
											$frontend_products[] = $product;
										}
									}
									$product_list = $frontend_products;
								}
								if(!empty($product_list)) {
									$frontend_pricelist[] = array('category_id' => $data['category_id'], 'category_name' => $data['name'], 'discount' => $discount, 'product_list' => $product_list);
								}
							}
						}
					}
					else {
						if(!empty($data['category_id']) && !empty($data['name'])) {
							$product_list = array();
							$product_list = $this->DisplayCategoryProductsByOrder($data['category_id']);
							if(!empty($product_list)) {
								$backend_pricelist[] = array('category_id' => $data['category_id'], 'category_name' => $data['name'], 'product_list' => $product_list);
							}
						}
					}

				}
			}

			if(!empty($frontend) && $frontend == 1) {
				$pricelist = $frontend_pricelist;
			}
			else {
				$pricelist = $backend_pricelist;
			}
			return $pricelist;
		}

		public function NoDiscountCategories($discount_edit_id) {
			$con = $this->connect(); $no_discount_category = array(); $category_list = array(); $discount_category_ids = "";
			if(!empty($discount_edit_id)) {
				$select_query = "SELECT * FROM ".$GLOBALS['discount_table']." WHERE discount_id = :discount_edit_id AND deleted = '0'";
				if(!empty($select_query)) {
					$result = 0; $pdo = "";			
					$pdo = $con->prepare($select_query);
					$pdo->bindParam(':discount_edit_id', $discount_edit_id, PDO::PARAM_STR);
					$pdo->execute();	
					$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
					if(!empty($result)) {
						foreach($pdo->fetchAll() as $row) {
							if(!empty($row['category_ids'])) {
								$discount_category_ids = explode(",", $row['category_ids']);
							}
						}
					}
				}
			}
			$category_list = $this->DisplayCategoryByOrder();
			if(!empty($category_list)) {
				foreach($category_list as $data) {
					if(!empty($data['category_id']) && !empty($data['name'])) {

						if(!empty($discount_category_ids) && in_array($data['category_id'], $discount_category_ids)) {
							$no_discount_category[] = array('category_id' => $data['category_id'], 'name' => $data['name']);
						}
						else {
							$list = array(); $select_query = ""; $discount = 0;
							$select_query = "SELECT * FROM ".$GLOBALS['discount_table']." WHERE FIND_IN_SET(:check_category_id, category_ids) AND deleted = '0' 
												ORDER BY id ASC";
							if(!empty($select_query)) {
								$result = 0; $pdo = "";			
								$pdo = $con->prepare($select_query);
								$pdo->bindParam(':check_category_id', $data['category_id'], PDO::PARAM_STR);
								$pdo->execute();	
								$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
								if(!empty($result)) {
									foreach($pdo->fetchAll() as $row) {
										if(!empty($row['discount_id'])) {
											$discount = 1;
										}
									}
								}
							}
							if(empty($discount)) {
								$no_discount_category[] = array('category_id' => $data['category_id'], 'name' => $data['name']);
							}
						}
					}
				}
			}
			return $no_discount_category;
		}

		public function DisplayCrackerOrders($from_date, $to_date, $customer_id, $staff_id, $status, $order_type, $promotion_code_id, $access_orders) {
			$con = $this->connect(); $list = array(); $where = []; $params = [];

			// From date
			if (!empty($from_date)) {
				$from_date = date("Y-m-d", strtotime($from_date));
				$where[] = "DATE(order_date) >= :from_date";
				$params[':from_date'] = $from_date;
			}

			// To date
			if (!empty($to_date)) {
				$to_date = date("Y-m-d", strtotime($to_date));
				$where[] = "DATE(order_date) <= :to_date";
				$params[':to_date'] = $to_date;
			}

			// Customer ID
			if (!empty($customer_id)) {
				$where[] = "customer_id = :customer_id";
				$params[':customer_id'] = $customer_id;
			}

			// Promotion Code ID
			if (!empty($promotion_code_id)) {
				$where[] = "promotion_code_id = :promotion_code_id";
				$params[':promotion_code_id'] = $promotion_code_id;
			}

			// Staff / Order type
			$staff_where = [];
			if (!empty($staff_id)) {
				$staff_where[] = "creator = :staff_id";
				$params[':staff_id'] = $staff_id;

				if (!empty($access_orders) && $access_orders == 1) {
					$frontend_order = $GLOBALS['frontend_order']; 
					if (!empty($frontend_order)) {
						$frontend_order = $this->encode_decode('encrypt', $frontend_order);
						$staff_where[] = "order_type = :frontend_order";
						$params[':frontend_order'] = $frontend_order;
					}
				}
			} 
			elseif (!empty($order_type)) {
				$where[] = "order_type = :order_type";
				$params[':order_type'] = $order_type;
			}

			if (!empty($staff_where)) {
				$where[] = "(" . implode(" OR ", $staff_where) . ")";
			}

			// Status filter
			if (!empty($status)) {
				$condition = "";
				switch ($status) {
					case "1":
						$condition = "confirmed='1' AND despatched='' AND delivered=''";
						break;
					case "2":
						$condition = "confirmed='1' AND despatched='1' AND delivered=''";
						break;
					case "3":
						$condition = "confirmed='1' AND despatched='1' AND delivered='1'";
						break;
					case "4":
						$condition = "confirmed='' AND despatched='' AND delivered=''";
						break;
					case "5":
						$condition = "new_order=1";
						break;
				}
				if (!empty($condition)) {
					$where[] = $condition; // no params, static condition
				}
			}

			// Build final SQL
			$sql = "SELECT * FROM ".$GLOBALS['order_table']." WHERE deleted = '0'";
			if (!empty($where)) {
				$sql .= " AND " . implode(" AND ", $where);
			}
			$sql .= " ORDER BY id DESC";

			// Run PDO query
			$pdo = $con->prepare($sql);
			$pdo->execute($params);
			$list = $pdo->fetchAll(PDO::FETCH_ASSOC);

			return $list;
		}

		public function StaffCreatedCustomers($staff_id, $frontend_customer) {
			$con = $this->connect();

			$staff_user_id = "";
			if (!empty($staff_id)) {
				$staff_user_id = $this->getTableColumnValue($GLOBALS['user_table'],	'staff_id', $staff_id, 'user_id');
			}

			$other_user_ids = [];
			$user_list = $this->getTableRecords($GLOBALS['user_table'], '', '');
			if (!empty($user_list)) {
				foreach ($user_list as $data) {
					if (!empty($data['staff_id']) && $data['staff_id'] != $staff_id) {
						if (!empty($data['user_id']) && !in_array($data['user_id'], $other_user_ids)) {
							$other_user_ids[] = $data['user_id'];
						}
					}
				}
			}

			// Build WHERE conditions safely
			$where = []; $params = [];

			if (!empty($staff_user_id)) {
				$where[] = "c.creator = :staff_user_id";
				$params[':staff_user_id'] = $staff_user_id;
			}

			if (!empty($other_user_ids)) {
				// Make placeholders dynamically
				$placeholders = implode(",", array_fill(0, count($other_user_ids), "?"));
				$where[] = "c.creator NOT IN ($placeholders)";
				$params = array_merge($params, $other_user_ids);
			}

			// Base query
			$sql = "SELECT c.* FROM ".$GLOBALS['customer_table']." as c WHERE c.deleted = '0'";

			if (!empty($staff_id) && !empty($where)) {
				if (!empty($frontend_customer) && $frontend_customer == 1) {
					$sql .= " AND (" . implode(" AND ", $where) . " OR c.creator = c.customer_id)";
				} else {
					$sql .= " AND " . implode(" AND ", $where);
				}
			}

			$sql .= " ORDER BY c.id DESC";

			// Prepare + execute
			$pdo = $con->prepare($sql);
			$pdo->execute(array_values($params));
			$list = $pdo->fetchAll(PDO::FETCH_ASSOC);

			return $list;
		}

		public function getDiscountValueByPromotionCode($promotion_code, $sub_total) {
			$result = "";
			if(!empty($promotion_code) && !empty($sub_total)) {
				$promotion_code = strtolower($promotion_code);
				$promotion_code = $this->encode_decode('encrypt', $promotion_code);

				$list = array();
				$list = $this->getTableRecords($GLOBALS['promotion_code_table'], 'lower_case_name', $promotion_code);
				if(!empty($list)) {
					if(count($list) > 1) {
						$temp = array();
						foreach($list as $key => $data) {
							if(empty($key)) {
								$temp[] = $data;
							}
						}
						$list = $temp;
					}
					$price = 0; $expiry_date = ""; $minimum_order_amount = 0; $discount_upto_value = 0;
					foreach($list as $data) {
						if(!empty($data['price'])) {
							$price = $data['price'];
						}
						if(!empty($data['expiry_date']) && $data['expiry_date'] != "0000-00-00") {
							$expiry_date = date("d-m-Y", strtotime($data['expiry_date']));
						}
						if(!empty($data['minimum_order_amount'])) {
							$minimum_order_amount = $data['minimum_order_amount'];
						}
						if(!empty($data['discount_upto_value'])) {
							$discount_upto_value = $data['discount_upto_value'];
						}
					}
					$current_date = date("d-m-Y");
					if(!empty($price)) {
						if(!empty($expiry_date) && strtotime($current_date) <= strtotime($expiry_date)) {
							if(!empty($minimum_order_amount) && $sub_total >= $minimum_order_amount) {
								if(strpos($price, '%') !== false) {
									$price = str_replace("%", "", $price);
									$price = trim($price);

									$discount_value = 0;
									$discount_value = ($sub_total * $price) / 100;
									if(!empty($discount_value)) {
										$discount_value = number_format($discount_value, 2);
										$discount_value = str_replace(",", "", $discount_value);
										$result = $discount_value;
										if(!empty($discount_upto_value)) {
											if($result > $discount_upto_value) {
												$result = $discount_upto_value;
											}
										}
									}
								}
								else {
									$result = $price;
								}
							}
							else {
								$result = "Invalid Code";
							}
						}
						else {
							$result = "Invalid Code";
						}
					}
				}
				else {
					$result = "Invalid Code";
				}
			}

			return $result;
		}

		public function getOTPNumber() {
			$select_query = ""; $list = array(); $new_otp_number = ""; $otp_unique_id = ""; $otp_number = mt_rand(100000, 999999);
			if(!empty($otp_number)) {
				$otp_unique_id = $this->getTableColumnValue($GLOBALS['order_table'], 'otp_number', $otp_number, 'id');
				if(!empty($otp_unique_id)) {
					$this->getOTPNumber();
				}
				else {
					$new_otp_number = $otp_number;
				}
			}
			return $new_otp_number;
		}

		public function getOTPSendCount($otp_send_date, $otp_receive_mobile_number) {
            $con = $this->connect(); $select_query = ""; $list = array(); $otp_send_count = 0;
			if(!empty($otp_send_date) && !empty($otp_receive_mobile_number)) {
				$select_query = "SELECT otp_send_count FROM ".$GLOBALS['otp_send_phone_numbers_table']." 
									WHERE DATE(send_date_time) = :otp_send_date AND phone_number = :otp_receive_mobile_number AND deleted = '0' 
									ORDER BY id DESC LIMIT 1";
				if(!empty($select_query)) {
					$result = 0; $pdo = "";			
					$pdo = $con->prepare($select_query);
					$pdo->bindParam(':otp_send_date', $otp_send_date, PDO::PARAM_STR);
					$pdo->bindParam(':otp_receive_mobile_number', $otp_receive_mobile_number, PDO::PARAM_STR);
					$pdo->execute();	
					$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
					if(!empty($result)) {
						foreach($pdo->fetchAll() as $row) {
							if(!empty($row['otp_send_count'])) {
								$otp_send_count = $row['otp_send_count'];
							}
						}
					}
				}
			}
			return $otp_send_count;
        }

		public function getOTPSendUniqueID($otp_send_date, $otp_receive_mobile_number) {
            $con = $this->connect(); $select_query = ""; $unique_id = "";
			if(!empty($otp_send_date) && !empty($otp_receive_mobile_number)) {
				$select_query = "SELECT id FROM ".$GLOBALS['otp_send_phone_numbers_table']." 
									WHERE DATE(send_date_time) = :otp_send_date AND phone_number = :otp_receive_mobile_number AND deleted = '0' 
									ORDER BY id DESC LIMIT 1";
				if(!empty($select_query)) {
					$result = 0; $pdo = "";			
					$pdo = $con->prepare($select_query);
					$pdo->bindParam(':otp_send_date', $otp_send_date, PDO::PARAM_STR);
					$pdo->bindParam(':otp_receive_mobile_number', $otp_receive_mobile_number, PDO::PARAM_STR);
					$pdo->execute();	
					$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
					if(!empty($result)) {
						foreach($pdo->fetchAll() as $row) {
							if(!empty($row['id'])) {
								$unique_id = $row['id'];
							}
						}
					}
				}
			}
			return $unique_id;
        }

		public function getStaffRedirectionPage($staff_id) {
			$con = $this->connect(); $list = array(); $select_query = ""; $redirection_page = "";
			if(!empty($staff_id)) {
				$select_query = "SELECT access_pages FROM ".$GLOBALS['staff_table']." WHERE staff_id = :staff_id AND deleted = '0'";
				if(!empty($select_query)) {
					$result = 0; $pdo = "";			
					$pdo = $con->prepare($select_query);
					$pdo->bindParam(':staff_id', $staff_id, PDO::PARAM_STR);
					$pdo->execute();	
					$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
					if(!empty($result)) {
						foreach($pdo->fetchAll() as $row) {
							if(!empty($row['access_pages'])) {
								$access_pages = $row['access_pages'];
							}
						}
					}
				}
			}
			if(!empty($access_pages)) {
				$access_pages = explode(",", $access_pages);
				if(!empty($access_pages['0'])) {
					$page = $this->encode_decode('decrypt', $access_pages['0']); $page_list = $GLOBALS['staff_access_pages'];
					$redirection_pages = $GLOBALS['staff_redirection_pages'];
					if(!empty($page_list)) {
						for($p = 0; $p <= count($page_list); $p++) {
							if(!empty($page_list[$p]) && $page_list[$p] == $page) {
								if(!empty($redirection_pages[$p])) {
									$redirection_page = $redirection_pages[$p];
								}
							}
						}
					}
				}
			}
			return $redirection_page;
		}

		public function CheckStaffAccessPage($staff_id, $permission_page) {
			$list = array(); $select_query = ""; $acccess_permission = 0;
			if(!empty($staff_id)) {
				$select_query = "SELECT * FROM ".$GLOBALS['staff_table']." WHERE staff_id = '".$staff_id."' AND deleted = '0'";
			}
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['staff_table'], $select_query);
				if(!empty($list)) {
					$access_pages = "";
					foreach($list as $data) {
						if(!empty($data['access_pages'])) {
							$access_pages = $data['access_pages'];
						}
					}

					if(!empty($access_pages)) {
						$access_pages = explode(",", $access_pages);
						if(!empty($permission_page)) {
							$permission_page = $this->encode_decode('encrypt', $permission_page);
							if(in_array($permission_page, $access_pages)) {
								$acccess_permission = 1;
							}
						}
					}
				}
			}
			return $acccess_permission;
		}

		public function TodayOrdersCountAmount($count, $amount, $order_type) {
			$con = $this->connect();
			$today = date("Y-m-d");

			$result = 0;
			$params = [':today' => $today];

			// Encrypt order type if provided
			if (!empty($order_type)) {
				$order_type = $this->encode_decode('encrypt', $order_type);
				$params[':order_type'] = $order_type;
			}

			// Decide which field to calculate
			if ((!empty($count) && $count == 1) && empty($amount)) {
				$sql = "SELECT COUNT(id) as result FROM ".$GLOBALS['order_table']." WHERE DATE(order_date) = :today AND deleted = '0'";
				if (!empty($order_type)) {
					$sql .= " AND order_type = :order_type";
				}
			} 
			elseif (empty($count) && (!empty($amount) && $amount == 1)) {
				$sql = "SELECT SUM(total_amount) as result FROM ".$GLOBALS['order_table']." WHERE DATE(order_date) = :today AND deleted = '0'";
				if (!empty($order_type)) {
					$sql .= " AND order_type = :order_type";
				}
			} 
			else {
				return 0; // neither count nor amount requested
			}

			// Run query
			$pdo = $con->prepare($sql);
			$pdo->execute($params);
			$row = $pdo->fetch(PDO::FETCH_ASSOC);

			if (!empty($row['result'])) {
				$result = $row['result'];
			}

			return $result;
		}

		public function CountOrdersByStatus($status) {
			$con = $this->connect(); $result = 0;

			// Map status → fixed condition
			$conditions = [
				"1" => "confirmed='1' AND despatched='' AND delivered=''",
				"2" => "despatched='1' AND confirmed='1' AND delivered=''",
				"3" => "confirmed='1' AND despatched='1' AND delivered='1'",
				"4" => "confirmed='' AND despatched='' AND delivered=''",
				"5" => "new_order=1"
			];

			$where = isset($conditions[$status]) ? $conditions[$status] : "";

			// Build query
			$sql = "SELECT COUNT(id) as result FROM ".$GLOBALS['order_table']." WHERE deleted = '0'";
			if (!empty($where)) {
				$sql .= " AND $where";
			}

			// Execute
			$pdo = $con->prepare($sql);
			$pdo->execute();
			$row = $pdo->fetch(PDO::FETCH_ASSOC);

			if (!empty($row['result'])) {
				$result = $row['result'];
			}

			return $result;
		}

		public function UpdateCategoryProductLowercaseName() {
			$con = $this->connect(); $category_list = array(); $select_query = ""; $updated = 1;
			$category_select_query = "SELECT id, category_id, name FROM ".$GLOBALS['category_table']." ORDER BY id ASC";
			if(!empty($category_select_query)) {
				$category_result = 0; $category_pdo = "";			
				$category_pdo = $con->prepare($category_select_query);
				$category_pdo->execute();	
				$category_result = $category_pdo->setFetchMode(PDO::FETCH_ASSOC);
				if(!empty($category_result)) {
					foreach($category_pdo->fetchAll() as $category_row) {
						$category_list[] = $category_row;
					}
				}
				if(!empty($category_list)) {
					foreach($category_list as $row1) {
						if(!empty($row1['name'])) {
							$category_name = "";
							if(!empty($row1['name'])) {
								$category_name = $this->encode_decode('decrypt', $row1['name']);
								$category_lower_case_name = "";
								if(!empty($category_name)) {
									$category_name = str_replace("''", "$", $category_name);
									$category_name = str_replace('"', "$", $category_name);
									$category_lower_case_name = strtolower($category_name);					
									$category_lower_case_name = $this->encode_decode('encrypt', $category_lower_case_name);

									$columns = array(); $values = array(); $category_update_id = "";					
									$columns = array('lower_case_name');
									$values = array("'".$category_lower_case_name."'");
									$category_update_id = $this->UpdateSQL($GLOBALS['category_table'], $row1['id'], $columns, $values, '');
									if(preg_match("/^\d+$/", $category_update_id)) {
										if(!empty($row1['category_id'])) {
											$product_list = array();
											$product_select_query = "SELECT id, name, product_code FROM ".$GLOBALS['product_table']." 
																		WHERE category_id = :product_category_id ORDER BY id ASC";
											if(!empty($product_select_query)) {
												$product_result = 0; $product_pdo = "";			
												$product_pdo = $con->prepare($product_select_query);
												$product_pdo->bindParam(':product_category_id', $row1['category_id'], PDO::PARAM_STR);
												$product_pdo->execute();	
												$product_result = $product_pdo->setFetchMode(PDO::FETCH_ASSOC);
												if(!empty($product_result)) {
													foreach($product_pdo->fetchAll() as $product_row) {
														$product_list[] = $product_row;
													}
												}
												if(!empty($product_list)) {
													foreach($product_list as $row2) {
														$product_name = ""; $product_code = "";
														if(!empty($row2['name'])) {
															$product_name = $this->encode_decode('decrypt', $row2['name']);
															$product_lower_case_name = "";
															if(!empty($product_name)) {
																$product_name = str_replace("''", "$", $product_name);
																$product_name = str_replace('"', "$", $product_name);
																$product_lower_case_name = strtolower($product_name);
																$product_lower_case_name = $this->encode_decode('encrypt', $product_lower_case_name);
															}

															$lower_case_product_code = "";
															if(!empty($row2['product_code']) && $row2['product_code'] != $GLOBALS['null_value']) {
																$lower_case_product_code = $this->encode_decode('decrypt', $row2['product_code']);
																$lower_case_product_code = strtolower($lower_case_product_code);
																$lower_case_product_code = $this->encode_decode('encrypt', $lower_case_product_code);
															}

															$columns = array(); $values = array(); $product_update_id = "";					
															$columns = array('lower_case_name', 'lower_case_product_code');
															$values = array("'".$product_lower_case_name."'", "'".$lower_case_product_code."'");
															$product_update_id = $this->UpdateSQL($GLOBALS['product_table'], $row2['id'], $columns, $values, '');

														}
													}
												}
											}		
										}
									}

								}
							}
						}
					}
				}
			}
			return $updated;
		}	

    }
?>