<?php

    //order/pdf/3_inch_app.php?print_order_id=63306378614756335132787555456c7455303555636a4d7a6258525855543039&printer_ip_address=192.168.0.145&printer_port_number=9100
    
    include("../../include.php");
    require_once('../esc_pos/autoload.php');

    $order_id = ""; $printer_ip_address = ""; $printer_port_number = "";

    if(isset($_REQUEST['print_order_id'])){
        $order_id = $_REQUEST['print_order_id'];
        $order_id = trim($order_id);
    }
    
    if(isset($_REQUEST['printer_ip_address'])){
        $printer_ip_address = $_REQUEST['printer_ip_address'];
        $printer_ip_address = trim($printer_ip_address);
    }

    if(isset($_REQUEST['printer_port_number'])){
        $printer_port_number = $_REQUEST['printer_port_number'];
        $printer_port_number = trim($printer_port_number);
    }

    use Mike42\Escpos\Printer;
    //use Mike42\Escpos\PrintConnectors\NetworkPrintConnector;
    use Mike42\Escpos\PrintConnectors\FilePrintConnector;

    //$connector = new NetworkPrintConnector($printer_ip_address, $printer_port_number);
    $connector = new FilePrintConnector("result.txt");
    $printer = new Printer($connector);
    $printer -> setJustification(Printer::JUSTIFY_CENTER);

    $order_type = ""; $order_number = ""; $order_date = ""; $customer_details = ""; $delivery_address = ""; $ = array();
    $product_codes = array(); $product_names = array(); $product_contents = array(); $quantity_values = array(); $rate_values = array();
    $actual_rate_values = array(); $discount_values = array(); $extra_discount = ""; $extra_discount_extension = ""; $show_extra_discount_amount = 2;
    $packing_charges = ""; $company_details = ""; $bank_details = ""; $order_count = 0; $promotion_code_price = ""; $promotion_code_discount_value = "";

    $view_orders = array();
    $view_orders = $obj->getTableRecords($GLOBALS['order_table'], 'order_id', $order_id);
    if(!empty($view_orders)) {
        foreach($view_orders as $data) {
            if(!empty($data['order_type'])) {
                $order_type = $obj->encode_decode('decrypt', $data['order_type']);
            }
            if(!empty($data['order_number']) && $data['order_number'] != $GLOBALS['null_value']) {
                $order_number = $obj->encode_decode('decrypt', $data['order_number']);
            }
            if(!empty($data['order_date']) && $data['order_date'] != "0000-00-00") {
                $order_date = date("d-m-Y", strtotime($data['order_date']));
            }
            if(!empty($data['company_details'])) {
                $company_details = $obj->encode_decode('decrypt', $data['company_details']);
            }
            if(!empty($data['bank_details'])) {
                $bank_details = $obj->encode_decode('decrypt', $data['bank_details']);
            }
            if(!empty($data['customer_details'])) {
                $customer_details = $obj->encode_decode('decrypt', $data['customer_details']);
            }
            if(!empty($data['delivery_address'])) {
                $delivery_address = $obj->encode_decode('decrypt', $data['delivery_address']);
                $delivery_address = str_replace("\r\n", "<br>", $delivery_address);
            }
            if(!empty($data['product_id'])) {
                $ = explode(",", $data['product_id']);
                $order_count = count($);
            }
            if(!empty($data['product_code'])) {
                $product_codes = explode(",", $data['product_code']);
            }
            if(!empty($data['product_name'])) {
                $product_names = explode(",", $data['product_name']);
            }
            if(!empty($data['product_content'])) {
                $product_contents = explode(",", $data['product_content']);
            }
            if(!empty($data['quantity'])) {
                $quantity_values = explode(",", $data['quantity']);
            }
            if(!empty($data['actual_price'])) {
                $actual_rate_values = explode(",", $data['actual_price']);
            }
            if(!empty($data['price'])) {
                $rate_values = explode(",", $data['price']);
            }
            if(!empty($data['discount'])) {
                $discount_values = explode(",", $data['discount']);
            }
            if(!empty($data['extra_discount'])) {
                $extra_discount = $data['extra_discount'];
                if (strpos($extra_discount, '%') !== false) {
                    $extra_discount = str_replace("%", "", $extra_discount);
                    $extra_discount_extension = "percentage";
                }
                else {
                    $extra_discount_extension = "rupees";
                }
            }
            if(!empty($data['show_extra_discount_amount'])) {
                $show_extra_discount_amount = $data['show_extra_discount_amount'];
            }
            if(!empty($data['packing_charges']) && $data['packing_charges'] != $GLOBALS['null_value']) {
                $packing_charges = $data['packing_charges'];
            }
            if(!empty($data['promotion_code_price']) && $data['promotion_code_price'] != $GLOBALS['null_value']) {
                $promotion_code_price = $data['promotion_code_price'];
            }
            if(!empty($data['promotion_code_discount_value']) && $data['promotion_code_discount_value'] != $GLOBALS['null_value']) {
                $promotion_code_discount_value = $data['promotion_code_discount_value'];
            }
        }
    }

    $company_name = ""; $company_logo = ""; $company_address = ""; $company_mobile_number = ""; $company_email = "";
    $ac_name = ""; $ac_number= ""; $ac_type = ""; $bank_name = ""; $ifsc_code = "";
    
    if(!empty($bank_details)) {
        $bank_details = explode("<br>", $bank_details);
        if(!empty($bank_details['0'])) {
            $ac_name = $bank_details['0'];
        }
        if(!empty($bank_details['1'])) {
            $ac_number = $bank_details['1'];
        }
        if(!empty($bank_details['2'])) {
            $ac_type = $bank_details['2'];
        }
        if(!empty($bank_details['3'])) {
            $bank_name = $bank_details['3'];
        }
        if(!empty($bank_details['4'])) {
            $ifsc_code = $bank_details['4'];
        }
    }

    $pdf_font_size = array(); $font_size = "";
    $pdf_font_size = $obj->getTableRecords($GLOBALS['settings_table'], 'name', 'pdf_font_size');

    foreach($pdf_font_size as $data){
        $font_size = $data['value'];
    }

    $target_dir = $obj->image_directory();

    $product_lists = array();
    for($i = 0; $i < count($product_names); $i++) {
        $product_code = "";$product_name = ""; $product_content = ""; $actual_price = ""; $product_price = "";  $product_quantity = ""; $product_discount = 0;
        $product_amount = "";
        if(!empty($product_codes[$i]) && $product_codes[$i] != $GLOBALS['null_value']) {
            $product_code = $product_codes[$i];
        }
        if(!empty($product_names[$i])) {
            $product_name = $product_names[$i];
        }
        if(!empty($product_contents[$i]) && $product_contents[$i] != $GLOBALS['null_value']) {
            $product_content = $product_contents[$i];
        }
        if(!empty($actual_rate_values[$i])) {
            $actual_price = $actual_rate_values[$i];
        }
        if(!empty($rate_values[$i])) {
            $product_price = $rate_values[$i];
        }
        if(!empty($quantity_values[$i])) {
            $product_quantity = $quantity_values[$i];
        }
        if(!empty($order_type)) {
            if(!empty($discount_values[$i])) {
                $product_discount = $discount_values[$i];
            }
            else {
                $product_discount = 0;
            }
        }		
        
        if(!empty($product_quantity) && !empty($product_price)) {
            $product_amount = $product_quantity * $product_price;

            if(!empty($product_amount)) {
                $product_amount = number_format($product_amount, 2);
                $product_amount = str_replace(",", "", $product_amount);
            }
        }
        
        if(!empty($product_amount)) {		
            $product_lists[] = array('code' => $product_code, 'name' => $product_name, 'content' => $product_content, 'actual_price' => $actual_price, 'product_price' => $product_price, 'quantity' => $product_quantity, 'discount' => $product_discount, 'amount' => $product_amount);
        }
    }

    function split_string($string) {
        $new_string = array(); $text_count = 15; $total_char_count = 0; $remin_char_count = 0; $last_position = 0;
        if(!empty($string)) {
            $total_char_count = strlen($string);
            if(!empty($total_char_count) && $total_char_count > $text_count) {
                $i = 1;
                while($i == 1) {
                    $display_text = substr($string, $remin_char_count, $text_count); 
                    $display_text = trim($display_text);
                    //echo "display_text - ".$display_text."<br>";
                    $last_position = strrpos($display_text, ".");
                    if(!empty($last_position)) {
                        //echo "last_position 1 - ".$last_position."<br>";
                    }
                    if(empty($last_position)) {
                        $last_position = strrpos($display_text, ",");
                        //echo "last_position 2 - ".$last_position."<br>";
                    }
                    if(empty($last_position)) {
                        $last_position = strrpos($display_text, " ");
                        //echo "last_position 3 - ".$last_position."<br>";
                    }
                    if(empty($last_position)) {
                        $last_position = strlen($display_text);
                        //echo "last_position 4 - ".$last_position."<br>";
                        $i = 2;
                    }
                    if(!empty($last_position)) {
                        $last_position = $last_position;
                        $text = "";
                        $text = substr($string, $remin_char_count, $last_position);
                        //echo "text - ".$text."<br>";
                        $remin_char_count = $remin_char_count + $last_position;
                        if(!empty($text)) {
                            $new_string[] = $text;
                        } 
                        $remin_char_count = $remin_char_count + 1;
                    }
                }
            }
            else {
                $new_string[] = $string;
            }
            //print_r($new_string); echo "<br>";
            $list = array();
            for($i = 0; $i < count($new_string); $i++) {
                if(!empty($i)) {
                    $total_length = 0;
                    $total_length = strlen($new_string[$i]) + strlen($list[count($list) - 1]);
                    //echo "total_length - ".$total_length."<br>";
                    if($total_length <= $text_count) {
                        $list[count($list) - 1] = $list[count($list) - 1]." ".$new_string[$i];
                    }
                    else {
                        $list[] = $new_string[$i];  
                    }
                }
                else {
                    $list[] = $new_string[$i];
                }
            }
            $new_string = $list;
            //print_r($new_string); exit;
        }
        return $new_string;
    }

    if(!empty($product_lists) && !empty($printer_ip_address) && !empty($printer_port_number)) {	
        $values = array();
        foreach($product_lists as $key => $row) {
            $values[$key] = $obj->encode_decode('decrypt', $row['code']);
        }
        array_multisort($values, SORT_ASC, $product_lists);
        
        $discounts = array();
        foreach($product_lists as $list) {
            if(!in_array($list['discount'], $discounts)) {
                $discounts[] = $list['discount'];
            }    
        }

        if(!empty($company_details)) {
            $company_details = explode("<br>", $company_details);
            for($i = 0; $i < count($company_details); $i++) {
                if(!empty($company_details[$i]) && $company_details[$i] != $GLOBALS['null_value']) {
                    if(empty($i))
                    {
                        $printer -> text(html_entity_decode($company_details[$i])."\n");
                    }
                    else if($i == 1){
                        $printer -> text(html_entity_decode($company_details[$i])."\n");
                    }
                    else if($i == 2) {
                        $printer -> text('Phone : '.html_entity_decode($company_details[$i])."\n");
                    }
                    else if($i == 3) {
                        $printer -> text(html_entity_decode($company_details[$i])."\n");
                    }
                }
	        }
        }

        $printer -> text("------------------------------------------"."\n");

        $printer -> setJustification(Printer::JUSTIFY_LEFT);
        $printer -> text('No : '.$order_number);

        $printer -> setJustification(Printer::JUSTIFY_RIGHT);
        $printer -> text('          Date : '.date("d-m-Y", strtotime($order_date))."\n");

        $printer -> text("------------------------------------------"."\n");

        $printer -> setJustification(Printer::JUSTIFY_LEFT);
        $printer -> text('Bill To'."\n");
        if(!empty($customer_details)) {
            $customer_details = explode("<br>", $customer_details);
            for($i = 0; $i < count($customer_details); $i++) {
                if(!empty($customer_details[$i]) && $customer_details[$i] != $GLOBALS['null_value']) {
                   $printer -> text('     '.html_entity_decode($customer_details[$i])."\n");
                }
	        }
        }
        if(!empty($delivery_address)) {
            $delivery_address = explode("<br>", $delivery_address);
            for($i = 0; $i < count($delivery_address); $i++) {
                if(!empty($delivery_address[$i]) && $delivery_address[$i] != $GLOBALS['null_value']) {
                   $printer -> text('     '.html_entity_decode($delivery_address[$i])."\n");
                }
	        }
        }

        $printer -> text("------------------------------------------"."\n");
        $printer -> text(sprintf('%10s', 'Product'));
        $printer -> text(sprintf('%12s', 'Qty'));
        $printer -> text(sprintf('%10s', 'Rate'));
        $printer -> text(sprintf('%12s', 'Amount'."\n"));
        $printer -> text("------------------------------------------"."\n");

        $overall_total = 0;
        if(!empty($discounts)) {
            foreach($discounts as $discount) {
                if(!empty($discount)) {
                    $printer -> text($discount." Products\n");
                }
                else {
                    $printer -> text("Net Rate Products\n");
                }
                if(!empty($product_lists)) {
                    $total = 0;
                    foreach($product_lists as $data) {
                        if($data['discount'] == $discount) {
                            $product_name = "";
                            if(!empty($data['name'])) {
                                $product_name = $obj->encode_decode('decrypt', $data['name']);
                                $product_name = str_replace("$", '"', $product_name);
                                $product_name = str_replace("'''", '"', $product_name);
                                $product_name = stripslashes($product_name);
                                $product_name = iconv('UTF-8', 'windows-1252', $product_name);
                            }

                            if(!empty($data['code']) && $data['code'] != 'NULL'){
                                $product_name = $obj->encode_decode('decrypt', $data['code'])." - ".$product_name;
                            }

                            if(!empty($product_name)) {
                                $printer -> setJustification(Printer::JUSTIFY_LEFT);
                                $product_name = split_string($product_name);
                                //$product_name = implode("\n", $product_name);
                                //print_r($product_name);
                                $printer -> text(sprintf('%-8.40s', $product_name['0']));
                                $printer -> text(sprintf('%12s', $data['quantity']));
                                $printer -> text(sprintf('%10s', number_format($data['product_price'], 2)));
                                $printer -> text(sprintf('%12s', number_format($data['amount'], 2)));
                                $printer -> text("\n");
                            }

                            $total = $total + $data['amount'];
                        }
                    }
                    $printer -> setJustification(Printer::JUSTIFY_RIGHT);
                    $printer -> text('Total : '.$total."\n");
                    $overall_total = $overall_total + $total;
                }
            }
            $printer -> setJustification(Printer::JUSTIFY_RIGHT);
            $printer -> text('Net Total : '.$overall_total."\n");

            if(!empty($extra_discount) && !empty($extra_discount_extension)) {
                $extra_discount_value = "";
                if(preg_match("/^[0-9]*$/", $extra_discount)) {
                    if ($extra_discount_extension == "percentage") {
                        $extra_discount_value = ($overall_total * $extra_discount) / 100;
                        if(!empty($extra_discount_value)) {
                            $extra_discount_value = number_format($extra_discount_value, 2);
                            $extra_discount_value = trim(str_replace(",", "", $extra_discount_value));
                            $extra_discount = $extra_discount."%";
                        }
                    }
                    else {
                        $extra_discount_value = $extra_discount;
                    }
                    if(!empty($extra_discount_value)) {
                        $overall_total = $overall_total - $extra_discount_value;
                    }
                }
                if(!empty($extra_discount_value)) {
                    $printer -> setJustification(Printer::JUSTIFY_RIGHT);
                    $printer -> text("Extra Discount (".$extra_discount.") : ".number_format($extra_discount_value, 2)."\n");

                    $printer -> setJustification(Printer::JUSTIFY_RIGHT);
                    $printer -> text("Extra Discount Total : ".number_format($overall_total, 2)."\n");
                }
            }

            if(!empty($promotion_code_price) && !empty($promotion_code_discount_value)) {
                $overall_total = $overall_total - $promotion_code_discount_value;
                $printer -> setJustification(Printer::JUSTIFY_RIGHT);
                $printer -> text("Coupon Discount (".$promotion_code_price.") : ".number_format($promotion_code_discount_value, 2)."\n");

                $printer -> setJustification(Printer::JUSTIFY_RIGHT);
                $printer -> text("Extra Discount Total : ".number_format($overall_total, 2)."\n");
            }

            $packing_charges_value = 0;
            if(!empty($packing_charges)) {
                if (strpos($packing_charges, '%') !== false) {
                    $packing_charges = trim(str_replace("%", "", $packing_charges));
                    $packing_charges_value = ($overall_total * $packing_charges) / 100;
                    if(!empty($packing_charges_value)) {
                        $packing_charges_value = number_format($packing_charges_value, 2);
                        $packing_charges_value = trim(str_replace(",", "", $packing_charges_value));
                        $overall_total = $overall_total + $packing_charges_value;
                        $packing_charges = $packing_charges."%";
                    }
                }
                else {
                    $packing_charges_value = $packing_charges;
                    $overall_total = $overall_total + $packing_charges_value;
                }
                if(!empty($packing_charges_value)) {
                    $printer -> setJustification(Printer::JUSTIFY_RIGHT);
                    $printer -> text("Packing Charges (".$packing_charges.") : ".number_format($packing_charges_value, 2)."\n");

                    $printer -> setJustification(Printer::JUSTIFY_RIGHT);
                    $printer -> text("Grand Total : ".number_format($overall_total, 2)."\n");
                }
            }

            $round_off_minus = "";
            if(!empty($overall_total)) {	
                $overall_total = $obj->truncate_number($overall_total, 2);
                if (strpos( $overall_total, "." ) !== false) {
                    $pos = strpos($overall_total, ".");
                    $decimal = substr($overall_total, ($pos + 1), strlen($overall_total));
                    $round_off = "";
                    if($decimal != "00") {
                        if(strlen($decimal) == 1) {
                            $decimal = $decimal."0";
                        }
                        if($decimal >= 50) {
                            $round_off = 100 - $decimal;
                            $round_off = trim($round_off);
                            if(strlen($round_off) == 1) {
                                $round_off = '0.0'.$round_off;
                            }
                            else {
                                $round_off = '0.'.$round_off;
                            }
                            $overall_total = str_replace(",", "", $overall_total);
                            $overall_total = $overall_total + $round_off;
                        }
                        else {
                            $round_off = $decimal;
                            $round_off = trim($round_off);
                            if(strlen($round_off) == 1) {
                                $round_off = '0.0'.$round_off;
                            }
                            else {
                                $round_off = '0.'.$round_off;
                            }
                            $overall_total = str_replace(",", "", $overall_total);
                            $overall_total = $overall_total - $round_off;
                            $round_off_minus = "minus";
                        }                                                                
                    }                    
                }
            }

            if(!empty($round_off)) {
                if(!empty($round_off_minus)) {
                    $printer -> text("Round Off (-) : ".number_format($round_off, 2)."\n");
                }
                else {
                    $printer -> text("Round Off : ".number_format($round_off, 2)."\n");
                }
            }

            $printer -> setJustification(Printer::JUSTIFY_RIGHT);
            $printer -> text('Overall Total : '.$overall_total."\n");

            $printer -> setJustification(Printer::JUSTIFY_CENTER);
            $printer -> text('Total Items : '.$order_count."\n");

        }
    }    

    $printer -> feed();
    $printer -> cut();
    $printer -> close();
?>