<?php
    $order_id = "";
    if(isset($_REQUEST['print_order_id'])){
        $order_id = $_REQUEST['print_order_id'];
    }
    
    if(isset($pdf_frontend) && !empty($pdf_frontend) && $pdf_frontend == 1) {
        include("../../../include.php");
        require_once('../../fpdf/fpdf.php');
    } 
    else {
        include("../../include.php");
        require_once('../../../order/fpdf/fpdf.php');
    }

    $order_type = ""; $order_number = ""; $order_date = ""; $customer_details = ""; $delivery_address = ""; $product_ids = array();
    $product_codes = array(); $product_names = array(); $product_contents = array(); $quantity_values = array(); $rate_values = array();
    $actual_rate_values = array(); $discount_values = array(); $extra_discount = ""; $extra_discount_extension = ""; $show_extra_discount_amount = 2;
    $packing_charges = ""; $company_details = ""; $bank_details = ""; $order_count = 0; $promotion_code_name = ""; $promotion_code_price = "";
    $promotion_code_discount_value = "";

    $view_orders = array();
    $view_orders = $obj->getTableRecords($GLOBALS['order_table'], 'order_id', $order_id);
    if(!empty($view_orders)) {
        foreach($view_orders as $data) {
            if(!empty($data['order_type'])) {
                $order_type = $obj->encode_decode('decrypt', $data['order_type']);
            }
            if(!empty($data['order_number']) && $data['order_number'] != $GLOBALS['null_value']) {
                $order_number = $obj->encode_decode('decrypt', $data['order_number']);
            }
            if(!empty($data['order_date']) && $data['order_date'] != "0000-00-00") {
                $order_date = date("d-m-Y", strtotime($data['order_date']));
            }
            if(!empty($data['company_details'])) {
                $company_details = $obj->encode_decode('decrypt', $data['company_details']);
            }
            if(!empty($data['bank_details'])) {
                $bank_details = $obj->encode_decode('decrypt', $data['bank_details']);
            }
            if(!empty($data['customer_details'])) {
                $customer_details = $obj->encode_decode('decrypt', $data['customer_details']);
            }
            if(!empty($data['delivery_address'])) {
                $delivery_address = $obj->encode_decode('decrypt', $data['delivery_address']);
                $delivery_address = str_replace("\r\n", "<br>", $delivery_address);
            }
            if(!empty($data['product_id'])) {
                $product_ids = explode(",", $data['product_id']);
                $order_count = count($product_ids);
            }
            if(!empty($data['product_code'])) {
                $product_codes = explode(",", $data['product_code']);
            }
            if(!empty($data['product_name'])) {
                $product_names = explode(",", $data['product_name']);
            }
            if(!empty($data['product_content'])) {
                $product_contents = explode(",", $data['product_content']);
            }
            if(!empty($data['quantity'])) {
                $quantity_values = explode(",", $data['quantity']);
            }
            if(!empty($data['actual_price'])) {
                $actual_rate_values = explode(",", $data['actual_price']);
            }
            if(!empty($data['price'])) {
                $rate_values = explode(",", $data['price']);
            }
            if(!empty($data['discount'])) {
                $discount_values = explode(",", $data['discount']);
            }
            if(!empty($data['extra_discount'])) {
                $extra_discount = $data['extra_discount'];
                if (strpos($extra_discount, '%') !== false) {
                    $extra_discount = str_replace("%", "", $extra_discount);
                    $extra_discount_extension = "percentage";
                }
                else {
                    $extra_discount_extension = "rupees";
                }
            }
            if(!empty($data['show_extra_discount_amount'])) {
                $show_extra_discount_amount = $data['show_extra_discount_amount'];
            }
            if(!empty($data['packing_charges']) && $data['packing_charges'] != $GLOBALS['null_value']) {
                $packing_charges = $data['packing_charges'];
            }
            if(!empty($data['promotion_code_name']) && $data['promotion_code_name'] != $GLOBALS['null_value']) {
                $promotion_code_name = $obj->encode_decode('decrypt', $data['promotion_code_name']);
            }
            if(!empty($data['promotion_code_price']) && $data['promotion_code_price'] != $GLOBALS['null_value']) {
                $promotion_code_price = $data['promotion_code_price'];
            }
            if(!empty($data['promotion_code_discount_value']) && $data['promotion_code_discount_value'] != $GLOBALS['null_value']) {
                $promotion_code_discount_value = $data['promotion_code_discount_value'];
            }
        }
    }

    $company_name = ""; $company_logo = ""; $company_address = ""; $company_mobile_number = ""; $company_email = "";
    $ac_name = ""; $ac_number= ""; $ac_type = ""; $bank_name = ""; $ifsc_code = "";
    
    if(!empty($bank_details)) {
        $bank_details = explode("<br>", $bank_details);
        if(!empty($bank_details['0'])) {
            $ac_name = $bank_details['0'];
        }
        if(!empty($bank_details['1'])) {
            $ac_number = $bank_details['1'];
        }
        if(!empty($bank_details['2'])) {
            $ac_type = $bank_details['2'];
        }
        if(!empty($bank_details['3'])) {
            $bank_name = $bank_details['3'];
        }
        if(!empty($bank_details['4'])) {
            $ifsc_code = $bank_details['4'];
        }
    }

    $pdf_font_size = array(); $font_size = "";
    $pdf_font_size = $obj->getTableRecords($GLOBALS['settings_table'], 'name', 'pdf_font_size');

    foreach($pdf_font_size as $data){
        $font_size = $data['value'];
    }

    $target_dir = $obj->image_directory();

    $product_lists = array();
		for($i = 0; $i < count($product_names); $i++) {
			$product_code = "";$product_name = ""; $product_content = ""; $actual_price = ""; $product_price = "";  $product_quantity = ""; $product_discount = 0;
            $product_amount = "";
			if(!empty($product_codes[$i])) {
				$product_code = $product_codes[$i];
			}
            if(!empty($product_names[$i])) {
				$product_name = $product_names[$i];
			}
			if(!empty($product_contents[$i])) {
				$product_content = $product_contents[$i];
			}
            if(!empty($rate_values[$i])) {
				$product_price = $rate_values[$i];
			}
            $old = 0;
			if(!empty($actual_rate_values[$i])) {
				$actual_price = $actual_rate_values[$i];
			}
            else {
                if(!empty($product_price)) {
                    $old = 1;
                    $actual_price = $product_price;
                }
            }
			if(!empty($quantity_values[$i])) {
				$product_quantity = $quantity_values[$i];
			}
            $discounted_value = 0;
            if(!empty($order_type)) {
                if(!empty($discount_values[$i])) {
                    $product_discount = $discount_values[$i]; 
                    $product_discount = str_replace("%", "", $product_discount);
                    if(!empty($actual_price)) {                   
                        $discounted_value = ($actual_price * $product_discount) / 100;
                        if(!empty($discounted_value)) {
                            $discounted_value = number_format($discounted_value, 2);
                            $discounted_value = str_replace(",", "", $discounted_value);
                        }
                    }
                    $product_discount = $product_discount."%";
                    if(!empty($old) && $old == 1) {
                        $product_price = $product_price - $discounted_value;
                    }
                }
                else {
                    $product_discount = 0;
                }
            }	
            
			if(!empty($product_quantity) && !empty($product_price)) {
                $product_amount = $product_quantity * $product_price;

				if(!empty($product_amount)) {
					$product_amount = number_format($product_amount, 2);
                    $product_amount = str_replace(",", "", $product_amount);
				}
			}
			
			//if(!empty($product_amount)) {		
				$product_lists[] = array('code' => $product_code, 'name' => $product_name, 'content' => $product_content, 'actual_price' => $actual_price, 'discounted_value' => $discounted_value, 'product_price' => $product_price, 'quantity' => $product_quantity, 'discount' => $product_discount, 'amount' => $product_amount);
			//}
		}

    if(!empty($product_lists)) {
        $discounts = array();
        foreach($product_lists as $list) {
            if(!empty($list['discount'])) {
                $list['discount'] = str_replace("%", "", $list['discount']);
                $list['discount'] = $list['discount']."%";
            }
            if(!in_array($list['discount'], $discounts)) {
                $discounts[] = $list['discount'];
            }    
        }

        $values = array();
        foreach($product_lists as $key => $row) {
            if(!empty($row['code']) && $row['code'] != $GLOBALS['null_value']) {
                $values[$key] = $obj->encode_decode('decrypt', $row['code']);
            }
            else {
                $values[$key] = 0;
            }
        }
        array_multisort($values, SORT_ASC, $product_lists);

        $pdf = new FPDF('P','mm',[80,297]);
        $pdf->AliasNbPages(); 
        $pdf->AddPage();
        $pdf->SetAutoPageBreak(false);
        $pdf->SetTitle('Estimate Bill');
        $pdf->SetY(5);
        $company_details=explode("<br>",$company_details);
        $pdf->SetFont('times','',7);
        $display='';
        for($i=0;$i<count($company_details);$i++)
        {
            if($company_details[$i]!="NULL" && $company_details[$i]!="")
            {
                $pdf->SetFont('times','',7);
                $pdf->SetX(1);
                if($i==0)
                {
                    $pdf->SetFont('times','B',12);
                    $pdf->MultiCell(75,4,$company_details[$i],0,'C',0);
                    $pdf->Cell(0,1,'',0,1,'C',0);
                }
                else if($i==1){
                    $display=$company_details[$i];
                }
                else if($i==2){
                    $display=$display.', '.$company_details[$i];
                }
                else if($i==3) {
                    $display=$display.', '.$company_details[$i];
                }
            }
        }
        $pdf->SetX(1);
        $pdf->MultiCell(75,4,$display,0,'C',0);
        
        
        $pdf->Cell(0,2,'',0,1,'C',0);
        $pdf->SetFont('times','',8);
        $pdf->SetX(1);
        $pdf->Cell(39,4,'No : '.$order_number,0,0,'L',0);
        
        $pdf->SetX(40);
        $pdf->Cell(40,4,'Date : '.date("d-m-Y", strtotime($order_date)),0,1,'L',0);
        $pdf->SetFont('times','',7);
        $pdf->Cell(0,2,'',0,1,'C',0);
        
        $pdf->SetX(1);
        $pdf->Cell(0,4,'Bill To',0,1,'L',0);
        $customer_details=explode("<br>",$customer_details);
        $pdf->SetFont('times','',8.5);
        for($i=0;$i<count($customer_details);$i++){
            $pdf->Cell(40,4,$customer_details[$i],0,1,'L',0);
        }
        if(!empty($delivery_address)){
            $delivery_address=explode("<br>",$delivery_address);
            for($i=0;$i<count($delivery_address);$i++){
                $pdf->MultiCell(40,4,$delivery_address[$i],0,'L',0);
            }
        }

        $pdf->Cell(0,2,'',0,1,'C',0);
        
        $y = $pdf->GetY();
        $pdf->SetFont('times','',8.5);
        $pdf->Line(2,$y,78,$y);
        $pdf->SetX(1);
        $pdf->Cell(34,4,'Product',0,0,'L',0);
        $pdf->SetX(35);
        $pdf->Cell(10,4,'Qty',0,0,'L',0);
        $pdf->SetX(45);
        $pdf->Cell(15,4,'Rate',0,0,'R',0);
        $pdf->SetX(60);
        $pdf->Cell(18,4,'Amount',0,1,'R',0);
        $y=$pdf->Gety();
        $pdf->Line(2,$y,78,$y);

        $pdf->SetFont('times','',8);
        $pdf->Cell(34,1,'',0,1,'R',0);

        $overall_total = 0; $index = 1; $s_no = 1; $payable_amounts = array();
        
        if(!empty($discounts)) {
            foreach($discounts as $discount) {
                if($pdf->GetY()>=270){
                    $pdf->AddPage();
                }
                if(!empty($discount)) {
                    $pdf->SetFont('Arial','B',7);
                    if($s_no!="1"){
                        $pdf->Line(2,$pdf->GetY(),78,$pdf->GetY());
                    }
                    
                    if (strpos($discount, '%') !== false) {
                        $pdf->SetX(1);
                        $pdf->Cell(0,4,$discount." Products",0,1,'L',0);
                    }
                    else {
                        $pdf->SetX(1);
                        $pdf->Cell(0,4,"Rs.".$discount." Products",0,1,'L',0);
                    }
                    //$discount = str_replace("%", "", $discount);
                    $pdf->Line(2,$pdf->GetY(),78,$pdf->GetY());
                    $y_axis=$pdf->GetY();
                    $pdf->SetFont('Arial','',7);
                    if(!empty($product_lists)) {
                        $sub_total = 0; $discounted_total = 0; 
                        $yaxis = $pdf->GetY();
                        $pdf-> Cell(0,1,'',0,1,'L',0);
                        foreach($product_lists as $key => $data) {
                            if($s_no>1){
                                $pdf->Line(2,$pdf->GetY(),78,$pdf->GetY());
                            }
                            if($pdf->GetY()>=270){
                                $pdf->AddPage();
                            }
                            if(!empty($data['discount']) && $data['discount'] == $discount) {
                                $y3=$pdf->GetY();
                                if(!empty($data['code']) && $data['code']!='NULL'){
                                    $data['code'] = $obj->encode_decode('decrypt', $data['code']);
                                }
                                
                                $pdf->SetX(35);
                                $pdf->Cell(10,4,$data['quantity'],0,0,'C',0);
                                $pdf->SetX(45);
                                $pdf->Cell(15,4,number_format($data['product_price'], 2),0,0,'R',0);
                                $pdf->SetX(60);
                                $pdf->Cell(18,4,number_format($data['amount'], 2),0,0,'R',0);
                                $pdf->SetX(1);
                                $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                                $data['name'] = str_replace("$", '"', $data['name']);
                                $data['name'] = str_replace("'''", '"', $data['name']);
                                $data['name'] = stripslashes($data['name']);
                                    $data['name'] = iconv('UTF-8', 'windows-1252', $data['name']);
                                // $data['name'] = "Ground Chakkar Ashoka Ground Chakkar Ashoka Ground Chakkar Ashoka"; 
                                if($data['code']!='' && $data['code']!='NULL'){
                                    $pdf->MultiCell(34,4,$data['code']. ' - '.$data['name'],0,'L',0);
                                }
                                else{
                                    $pdf->MultiCell(34,4,$data['name'],0,'L',0);
                                }
                                
                                $pdf->Cell(0,2,'',0,1,'L',0);
                                $s_no++;
                                $sub_total = $sub_total + $data['amount'];
                            }
                        }
                        
                        if($pdf->GetY()>=270){
                            $pdf->AddPage();
                        }
                        if(!empty($sub_total)) {
                            $payable_amounts[] = $sub_total;
                                $overall_total = $overall_total + $sub_total;
                            $pdf->Line(2,$pdf->GetY(),78,$pdf->GetY());
                            $pdf->SetFont('Arial','',7.5);
                            if(!empty($discount)){
                                $pdf->SetX(20);
                                $pdf->Cell(30,4,'Total',0,0,'R',0);
                                $pdf->SetX(50);
                                $pdf->Cell(28,4,number_format($sub_total, 2),0,1,'R',0);
                            }
                            if($pdf->GetY()>=270){
                                $pdf->AddPage();
                            }
                        }
                        
                    }
                }
                else{
                    $pdf->SetFont('Arial','B',7);
                    if($s_no!="1"){
                        $pdf->Line(2,$pdf->GetY(),78,$pdf->GetY());
                    }
                    if($pdf->GetY()>=270){
                        $pdf->AddPage();
                    }
                    $pdf->SetX(1);
                    $pdf->Cell(0,4,"Net Rate Products",0,1,'L',0);
                    $pdf->Line(2,$pdf->GetY(),78,$pdf->GetY());
                    $pdf->SetFont('Arial','',7);
                    if(!empty($product_lists)) {
                        $sub_total = 0; $discounted_total = 0;
                        $y_axis = $pdf->GetY();
                        $pdf-> Cell(0,1,'',0,1,'L',0);
                        foreach($product_lists as $key => $data) {
                            if($pdf->GetY()>=270){
                                $pdf->AddPage();
                            }
                            if(empty($data['discount']) && $data['discount'] == $discount) {
                                $y3=$pdf->GetY();
                                if(!empty($data['code']) && $data['code']!='NULL'){
                                    $data['code'] = $obj->encode_decode('decrypt', $data['code']);
                                }
                                $pdf->SetX(35);
                                $pdf->Cell(10,4,$data['quantity'],0,0,'C',0);
                                $pdf->SetX(45);
                                $pdf->Cell(15,4,number_format($data['actual_price'], 2),0,0,'R',0);
                                $pdf->SetX(60);
                                $pdf->Cell(18,4,number_format($data['amount'], 2),0,0,'R',0);
                                $pdf->SetX(1);
                                $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                                $data['name'] = str_replace("$", '"', $data['name']);
                                $data['name'] = str_replace("'''", '"', $data['name']);
                                $data['name'] = stripslashes($data['name']);
                                    $data['name'] = iconv('UTF-8', 'windows-1252', $data['name']);
                                // $data['name'] = "Ground Chakkar Ashoka Ground Chakkar Ashoka Ground Chakkar Ashoka"; 
                                if(!empty($data['code']) && $data['code']!='NULL'){
                                    $pdf->MultiCell(34,4,$data['code']. ' - '.$data['name'],0,'L',0);
                                }else{
                                    $pdf->MultiCell(34,4,$data['name'],0,'L',0);
                                }
                                
                                $pdf->Cell(0,2,'',0,1,'L',0);
                                $s_no++;
                                $sub_total = $sub_total + $data['amount'];
                            }
                        }
                    }
                    if($pdf->GetY()>=270){
                        $pdf->AddPage();
                    }
                    $pdf->Line(2,$pdf->GetY(),78,$pdf->GetY());
                    $pdf->SetFont('Arial','',7);
                    $pdf->SetX(20);
                    $pdf->Cell(30,4,'Total',0,0,'R',0);
                    $pdf->SetX(50);
                    $pdf->Cell(28,4,number_format($sub_total, 2),0,1,'R',0);
                    if($pdf->GetY()>=270){
                        $pdf->AddPage();
                    }
                    if(!empty($sub_total)) { 
                        $payable_amounts[] = $sub_total;
                        $overall_total = $overall_total + $sub_total;
                    }
                    // $pdf->Line(2,$pdf->GetY(),47,$pdf->GetY());
                }
            }
            $net_total = 0; $net_total = $overall_total;
            
            if(!empty($net_total)) {
                if($pdf->GetY()>=270){
                    $pdf->AddPage();
                }
                $pdf->SetX(20);
                /*if(!empty($payable_amounts) && count($payable_amounts) > 1) {
                    $payable_amounts = implode(" + ", $payable_amounts);
                    $pdf->Cell(10,4,$payable_amounts.'  Net Total',0,0,'R',0);
                }
                else {*/
                    $pdf->Cell(30,4,'Net Total',0,0,'R',0);
                //}
                $pdf->SetX(50);
                $pdf->Cell(28,4,number_format($net_total, 2),0,1,'R',0);
            }

            if(!empty($promotion_code_price) && !empty($promotion_code_discount_value)) {
                if($pdf->GetY()>=270){
                    $pdf->AddPage();
                }
                $pdf->SetX(20);
                if(!empty($promotion_code_name)) {
                    $pdf->Cell(30,4,"Coupon : ".$promotion_code_name." (".$promotion_code_price.")",0,0,'R',0);
                }
                else {
                    $pdf->Cell(30,4,"Coupon Discount (".$promotion_code_price.")",0,0,'R',0);
                }
                $pdf->SetX(50);
                $pdf->Cell(28,4,number_format($promotion_code_discount_value, 2),0,1,'R',0);
                $overall_total = $overall_total - $promotion_code_discount_value;
            }

            $packing_charges_value = 0;
            if (strpos($packing_charges, '%') !== false) {
                $packing_charges = trim(str_replace("%", "", $packing_charges));
                $packing_charges_value = ($overall_total * $packing_charges) / 100;
                if(!empty($packing_charges_value)) {
                    $packing_charges_value = number_format($packing_charges_value, 2);
                    $packing_charges_value = trim(str_replace(",", "", $packing_charges_value));
                    $overall_total = $overall_total + $packing_charges_value;
                    $packing_charges = $packing_charges."%";
                }
            }
            else{
                if(!empty($packing_charges)){
                    $packing_charges_value = $packing_charges;
                    $overall_total = $overall_total + $packing_charges_value;
                    $packing_charges = "Rs.".$packing_charges;
                }
            }      

            if(!empty($packing_charges)){
                if($pdf->GetY()>=270){
                    $pdf->AddPage();
                }
                $pdf->SetX(20);
                $pdf->Cell(30,4,'Packing Charges ( '.$packing_charges.' )',0,0,'R',0);
                $pdf->SetX(50);
                $pdf->Cell(28,4,number_format($packing_charges_value, 2),0,1,'R',0);
            }     

            if(!empty($extra_discount) && !empty($extra_discount_extension)) {
                $extra_discount_value = "";
                if(preg_match("/^[0-9]*$/", $extra_discount)) {
                    if ($extra_discount_extension == "percentage") {
                        $extra_discount_value = ($overall_total * $extra_discount) / 100;
                        if(!empty($extra_discount_value)) {
                            $extra_discount_value = number_format($extra_discount_value, 2);
                            $extra_discount_value = trim(str_replace(",", "", $extra_discount_value));
                            $extra_discount = $extra_discount."%";
                        }
                    }
                    else {
                        $extra_discount_value = $extra_discount;
                        $extra_discount = "Rs.".$extra_discount;
                    }
                    if(!empty($extra_discount_value)) {
                        $overall_total = $overall_total - $extra_discount_value;
                    }
                }
                if(!empty($extra_discount_value)) {
                    if($pdf->GetY()>=270){
                        $pdf->AddPage();
                    }
                    $pdf->SetX(20);
                    $pdf->Cell(30,4,"Extra Discount (".$extra_discount.")",0,0,'R',0);
                    $pdf->SetX(50);
                    $pdf->Cell(28,4,number_format($extra_discount_value, 2),0,1,'R',0);
                }
            } 

            $round_off_minus = "";
            if(!empty($overall_total)) {	
                $overall_total = $obj->truncate_number($overall_total, 2);
                if (strpos( $overall_total, "." ) !== false) {
                    $pos = strpos($overall_total, ".");
                    $decimal = substr($overall_total, ($pos + 1), strlen($overall_total));
                    $round_off = "";
                    if($decimal != "00") {
                        if(strlen($decimal) == 1) {
                            $decimal = $decimal."0";
                        }
                        if($decimal >= 50) {
                            $round_off = 100 - $decimal;
                            $round_off = trim($round_off);
                            if(strlen($round_off) == 1) {
                                $round_off = '0.0'.$round_off;
                            }
                            else {
                                $round_off = '0.'.$round_off;
                            }
                            $overall_total = str_replace(",", "", $overall_total);
                            $overall_total = $overall_total + $round_off;
                        }
                        else {
                            $round_off = $decimal;
                            $round_off = trim($round_off);
                            if(strlen($round_off) == 1) {
                                $round_off = '0.0'.$round_off;
                            }
                            else {
                                $round_off = '0.'.$round_off;
                            }
                            $overall_total = str_replace(",", "", $overall_total);
                            $overall_total = $overall_total - $round_off;
                            $round_off_minus = "minus";
                        }                                                                
                    }                    
                }
            }

            if(!empty($round_off)) {
                if($pdf->GetY()>=270){
                    $pdf->AddPage();
                }
                $pdf->SetX(20);
                if(!empty($round_off_minus)) {
                    $pdf->Cell(30,4,'Round Off (-)',0,0,'R',0);
                }
                else {
                    $pdf->Cell(30,4,'Round Off',0,0,'R',0);
                }
                $pdf->SetX(50);
                $pdf->Cell(28,4,number_format($round_off, 2),0,1,'R',0);
            }
            
            if($pdf->GetY()>=270){
                $pdf->AddPage();
            }
            $pdf->Line(2,$pdf->GetY(),78,$pdf->GetY());
            $pdf->SetX(20);
            $pdf->Cell(30,4,'Overall Total',0,0,'R',0);
            $pdf->SetX(50);
            $pdf->Cell(28,4,number_format($overall_total, 2),0,1,'R',0);

            $pdf->Line(2,$pdf->GetY(),78,$pdf->GetY());
            $pdf->SetFont('Arial','B',7);
            // $pdf->SetX(1);
            $pdf->Cell(0,4,'Total Items : '.$order_count,0,1,'C',0);
        }
        
    }

    $pdf->Output();
?>