<?php 
	$page_title = "Dashboard";
	include("include_user_check_and_files.php");
    include("include/billing_functions.php");
	$page_number = $GLOBALS['page_number']; $page_limit = $GLOBALS['page_limit'];


    if(isset($_POST['bill_company_id'])) {
		$bill_company_id = ""; $bill_company_id_error = "";
		$bill_company_id = $_POST['bill_company_id'];
		if(empty($bill_company_id)) {
			$bill_company_id_error = "Select the bill company";
		}
		$result = "";
		if(empty($bill_company_id_error)) {
			if(isset($_SESSION['bill_company_id'])) {
				unset($_SESSION['bill_company_id']);
			}	
			$_SESSION['bill_company_id'] = $bill_company_id;				
			$_SESSION['primary_company'] = $obj->getTableColumnValue($GLOBALS['company_table'], 'company_id', $bill_company_id, 'primary_company');

			$result = array('number' => '1', 'msg' => "Updated Successfully");
            $success = 1;
		}
		else {
			$result = array('number' => '2', 'msg' => $bill_company_id_error);
		}

		if(!empty($result)) {
			$result = json_encode($result);
		}

		echo $result;
		exit;
	}

    if(!empty($_SESSION['bill_company_id'])){
        $bill_company_id = $_SESSION['bill_company_id'];
    }

    $company_list = array();
	$company_list = $obj->getTableRecords($GLOBALS['company_table'], '', '');

    $payment_list = array();
    $payment_list = $obj->getPaymentReportDashboard();

    function combineAndSumUp ($myArray) {

        // print_r($myArray);

        $finalArray = Array ();
    
        foreach ($myArray as $nkey => $nvalue) {
    
            $has = false;
            $fk = false;
    
            // Remove comma from numbers
            // $nvalue['Pageviews'] = str_replace(",","",$nvalue["Pageviews"]);
    
            foreach ($finalArray as $fkey => $fvalue) {
                if ( ($fvalue['party_id'] == $nvalue['party_id'])) {
                    $has = true;
                    $fk = $fkey;
                    break;
                }
            }
    
            if ( $has === false ) {
                $finalArray[] = $nvalue;
            } else {
                $finalArray[$fk]['amount'] += $nvalue['amount'];
                // $finalArray[$fk]['Pageviews'] += $nvalue['Pageviews'];
                // $finalArray[$fk]['Revenue'] += $nvalue['Revenue'];
            }
    
        }
        return $finalArray;
    }
    
?>

<?php include "header.php"; ?>
<!--Right Content-->
    <div class="pcoded-content">
        <div class="page-header card">
            <div class="row">
            <div class="col-12 col-md-6 col-lg-6 mt-3">
                    <div class="border">
                        <div class="text-white card-header">Payment Report - <?php echo date("d-m-Y"); ?></div>
                        <div class="table-responsive" style="height: 200px;">
                            <div id="report_area1" class="w-100">
                                <table class="table display report_table no_number_format">
                                    <thead>
                                        <tr>
                                            <th style="border: 1px solid #000!important; width: 5%; text-align: center; padding: 2px 10px; font-size: 13px;">S.No</th>
                                            <th style="border: 1px solid #000 !important; width: 24%; text-align: center; padding: 2px 10px; font-size: 13px;">Party</th>
                                            <th style="border-top: 1px solid #000 !important; border-bottom: 1px solid #000; border-right: 1px solid #000; width: 10%; text-align: center; padding: 2px 10px; font-size: 13px;">Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $sno = 1;
                                        $net_received_amount = 0;
                                        if(!empty($payment_list)) { 
                                            foreach($payment_list as $report) {
                                                $member_id = "";
                                                $member_id = $report['member_id'];
                                                $name = "";

                                                $name = $obj->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $member_id, 'member_name');
                                                if(empty($name)) {
                                                    $name = $obj->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $member_id, 'manager_name');
                                                }
                                                $name = $obj -> encode_decode('decrypt',$name); ?>

                                                <tr>
                                                    <td style="border: 1px solid #000; width: 5%; text-align: center; padding: 2px 10px; font-size: 13px;"><?php echo $sno; ?></td>
                                                    <td style="border: 1px solid #000; width: 24%; text-align: center; padding: 2px 10px; font-size: 13px;"><?php echo $name; ?></td>
                                                    <td style="border-top: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; width: 10%; text-align: right; padding: 2px 10px; font-size: 13px;"><?php echo number_format($report['amount'],2); ?></td>
                                                </tr>
                                            <?php $sno++; $net_received_amount+=($report['amount']); }
                                        }
                                        else{ ?>
                                            <td style="border: 1px solid #000; width: 5%;   text-align: center; padding: 2px 10px; font-size: 13px;" colspan="3">No Records Found</td>
                                        <?php } ?>
                                    </tbody>
                                    <?php if(!empty($net_received_amount)){ ?>
                                        <tfoot>
                                            <tr>
                                                <th style="border: 1px solid #000; width: 5%;   text-align: right; padding: 2px 10px; font-size: 13px;" colspan="2">Total Amount</th>
                                                <th style="border-top: 1px solid #000; border-bottom: 1px solid #000; border-right: 1px solid #000; width: 10%; text-align: right; padding: 2px 10px; font-size: 13px;"><?php echo number_format($net_received_amount,2);
                                                ?></th>
                                            </tr>
                                        </tfoot>
                                    <?php } ?>
                                </table>
                            </div>
                        </div>  
                    </div>
                </div> 
            </div>
        </div>
    </div>
<!--Right Content End-->
<?php include "footer.php"; ?>
<script>
$(document).ready(function(){
$("#dashboard").addClass("active");
});
</script>
    

