<?php
	include("tamilarasi_fireworks_26032024.php");
	class Basic_Functions extends db {
		public $con;
		
		public function connect() {
			$con = parent::connect();
			return $con;
		}

		public function getProjectTitle() {
			$project_title = "";
			if(empty($project_title)) { $project_title = "Tamilarasi Fireworks"; }

			if(!empty($GLOBALS['bill_company_id'])) {
				$bill_company_name = "";
				$bill_company_name = $this->getTableColumnValue($GLOBALS['company_table'], 'company_id', $GLOBALS['bill_company_id'], 'name');
				if(!empty($bill_company_name)) {
					$project_title = $this->encode_decode('decrypt', $bill_company_name);
				}
			}

			return $project_title;
		}
		public function select_values($table, $columns, $values, $order)
		{
			$con = parent::connect();
			$select_query = "";
			$check = ''; $data_values = array();
			if(!empty($columns) && !empty($values) && empty($keyword)) {
				if(count($columns) == count($values)) {				
					for($r = 0; $r < count($columns); $r++) {
						$check = $check.$columns[$r]." = ".$values[$r]."";
						if(!empty($columns[$r+1]))
							$check = $check.' AND ';
					}
				}
				$check = trim($check);
				$select_query = "SELECT * FROM ".$table." WHERE ".$check;
			}
			else			
				$select_query = "SELECT * FROM ".$table;
				
			if(!empty($order)) {
				if(!empty($select_query))
					$select_query = $select_query." ORDER BY id ".$order;
			}
			
			if(!empty($select_query)) {
				$data_values = $this->getQueryRecords($table, $select_query);
			}
				
			return $data_values;			
		}

		public function encode_decode($action, $string) {
			$output = "";
			//encode
			if($action == 'encrypt') {
				$output = base64_encode($string);
				$output =  bin2hex($output);
				//$output = gzcompress($output, 9);
			}			
			//decode
			if($action == 'decrypt') {
				//$output = gzuncompress($string);
				$output = hex2bin($string);
				$output = base64_decode($output);
			}
			return $output;
		}
		
		public function InsertSQL($table, $columns, $values, $action) {
			$con = $this->connect(); $last_insert_id = "";
			
			if(!empty($columns) && !empty($values)) {
				if(count($columns) == count($values)) {					
					$columns = implode(",", $columns);
					$values = implode(",", $values);
					
					$result = "";
					$insert_query = "INSERT INTO ".$table." (".$columns.") VALUES (".$values.")";
					$result = $con->prepare($insert_query);
					if($result->execute() === TRUE) {
						$last_insert_id = $con->lastInsertId();
						$last_query_insert_id = "";
						if(preg_match("/^\d+$/", $last_insert_id)) {
							$last_log_id = $this->add_log($table, $last_insert_id, $insert_query, $action);
						}
					}
					else {
						$last_insert_id = "Unable to insert the data";
					}
				}
				else {
					$last_insert_id = "Columns are not match";
				}
			}			
					
			return $last_insert_id;
		}
		
		public function add_log($table, $table_unique_id, $query, $action) {
			$con = $this->connect(); $last_query_insert_id = "";
			if(!empty($query) && !empty($action)) {
				$query = $this->encode_decode('encrypt', $query);
				$action = $this->encode_decode('encrypt', $action);
				$table = $this->encode_decode('encrypt', $table);
			
				$create_date_time = $GLOBALS['create_date_time_label'];
				$creator = "";
				if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id']) && isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'])) {
					$creator = $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'];
				}
				$creator_type = "";
				if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_type']) && isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_type'])) {
					$creator_type = $this->encode_decode('encrypt', $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_type']);
				}
				$creator_name = "";
				if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_username']) && isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_username'])) {
					$creator_name = $this->encode_decode('encrypt', $_SESSION[$GLOBALS['site_name_user_prefix'].'_username']);
				}
				$creator_mobile_number = "";
				if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_mobile_number']) && isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_mobile_number'])) {
					$creator_mobile_number = $this->encode_decode('encrypt', $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_mobile_number']);
				}

				$actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

				if (strpos($actual_link, 'admin_mvm_crackers_26032024') !== false) {
					$log_backup_file = $GLOBALS['log_backup_file'];
				}
				else {
					$log_backup_file_new = $GLOBALS['log_backup_folder_name']."/log_".date("d_m_Y").".csv";
					$log_backup_file = $GLOBALS['admin_folder_name']."/".$log_backup_file_new;
				}

				// $log_backup_file = $GLOBALS['log_backup_file'];

				// if(empty($log_backup_file)) {
				// 	$log_backup_file_new = $GLOBALS['log_backup_folder_name']."/log_".date("d_m_Y").".csv";
				// }
				// if(!empty($log_backup_file_new)) {
				// 	if (strpos($actual_link, 'registration') !== false) {
				// 		$log_backup_file = $GLOBALS['admin_folder_name']."/".$log_backup_file_new;
				// 	}
				// }	
				$columns = array('type', 'created_date_time', 'creator', 'creator_name', 'creator_mobile_number', 'log_table', 'log_table_unique_id', 'action', 'query');	
				$values = array("'".$creator_type."'", "'".$create_date_time."'", "'".$creator."'", "'".$creator_name."'", "'".$creator_mobile_number."'", "'".$table."'", "'".$table_unique_id."'", "'".$action."'", "'".$query."'");			
				if(count($columns) == count($values)) {	
					$log_data = array();
					$log_data = array('type' => $creator_type, 'created_date_time' => $create_date_time, 'creator' => $creator, 'creator_name' => $creator_name, 'creator_mobile_number' => $creator_mobile_number, 'table' => $table, 'table_unique_id' => $table_unique_id, 'action' => $action, 'query' => $query);	
					if(!empty($log_data)) {
						$log_data = json_encode($log_data);
						
						if(file_exists($log_backup_file)) {
							file_put_contents($log_backup_file, $log_data, FILE_APPEND | LOCK_EX);
							file_put_contents($log_backup_file, "\n", FILE_APPEND | LOCK_EX);
						}
						else {
							$myfile = fopen($log_backup_file, "a+");
							fwrite($myfile, $log_data."\n");
							fclose($myfile);
						}
					}
				}
			}			
					
			return $last_query_insert_id;
		}
		
		public function UpdateSQL($table, $update_id, $columns, $values, $action) {
			$con = $this->connect(); $updated_data = ''; $msg = "";
			
			if(!empty($columns) && !empty($values)) {
			
				if(count($columns) == count($values)) {					
					for($r = 0; $r < count($columns); $r++) {
						$updated_data = $updated_data.$columns[$r]." = ".$values[$r]."";
						if(!empty($columns[$r+1])) {
							$updated_data = $updated_data.', ';
						}	
					}
					if(!empty($updated_data)) {
						$updated_data = trim($updated_data);
						$update_query = "UPDATE ".$table." SET ".$updated_data." WHERE id='".$update_id."'";
						$result = $con->prepare($update_query);
						if($result->execute() === TRUE) {
							$msg = 1;							
							$last_log_id = $this->add_log($table, $update_id, $update_query, $action);
						}
						else {
							$msg = "Unable to update the data";
						}
					}
					else {
						$msg = "Unable to update the data";
					}
				}
				else {
					$msg = "Columns are not match";
				}
			}
					
			return $msg;	
		}

		public function getTableColumnValue($table, $column, $value, $return_value) {
			$con = $this->connect();
			$table_column_value = ""; $select_query = "";
			if(!empty($column) && !empty($value) && !empty($return_value)) {
				$select_query = "SELECT ".$return_value." FROM ".$table." WHERE ".$column." = '".$value."' AND deleted = '0'";
					
				if(!empty($select_query)) {
					$result = 0; $pdo = "";			
					$pdo = $con->prepare($select_query);
					$pdo->execute();	
					$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
					if(!empty($result)) {
						foreach($pdo->fetchAll() as $row) {
							$table_column_value = $row[$return_value];
						}
					}
				}
			}
			return $table_column_value;
		}

		public function getTableRecords($table, $column, $value) {
			$con = $this->connect();
			$result = ""; $select_query = "";
			if(!empty($table)) {
				if($table == 'user'){
					if(!empty($column) && !empty($value)) {		
						$select_query = "SELECT * FROM ".$table." WHERE ".$column." = '".$value."'  AND deleted = '0' ORDER BY id DESC";	
					}
					else if(empty($column) && empty($value)) {		
						$select_query = "SELECT * FROM ".$table." WHERE deleted = '0' ORDER BY id DESC";	
					}
				}
				else{
					if(!empty($column) && !empty($value)) {		
						$select_query = "SELECT * FROM ".$table." WHERE ".$column." = '".$value."' AND deleted = '0' ORDER BY id DESC";	
					}
					else if(empty($column) && empty($value)) {		
						$select_query = "SELECT * FROM ".$table." WHERE deleted = '0' ORDER BY id DESC";	
					}
				}
				
			}		
			if(!empty($select_query)) {
				$result = $this->getQueryRecords($table, $select_query);
			}
			return $result;
		}
		public function getQueryRecords($table, $select_query) {
			$con = $this->connect(); $list = array();
			if(!empty($select_query)) {
				$result = 0; $pdo = "";			
				$pdo = $con->prepare($select_query);
				$pdo->execute();	
				$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
				if(!empty($result)) {
					foreach($pdo->fetchAll() as $row) {
						$table_column_array = "";	
						$table_column_array = array_keys($row);			
						if(!empty($table_column_array)) {
							for($i = 0; $i < count($table_column_array); $i++) {
								if(!empty($table_column_array[$i])) {
									$column = $table_column_array[$i];
									if($table == 'product' && ($column == "name" || $column == "product_code" || $column == "description")){
										$row[$column] = $this -> encode_decode('decrypt',$row[$column]);
										if(strpos($row[$column], '[SA-AS]') !== false) {
											$row[$column] = str_replace('[SA-AS]', "+", $row[$column]);
										} 
										if(strpos($row[$column], '[KA-AK]') !== false) {
											$row[$column] = str_replace('[KA-AK]', '&', $row[$column]);
										}
										if(strpos($row[$column], '[SVL-VSL]') !== false) {
											$row[$column] = str_replace('[SVL-VSL]', '"', $row[$column]);
										}
										if(strpos($row[$column], '[SKK-KSK]') !== false) {
											$row[$column] = str_replace('[SKK-KSK]', "'", $row[$column]);
										}
										if(strpos($row[$column], '[KIKA-KAKI]') !== false) {
											$row[$column] = str_replace('[KIKA-KAKI]', '$', $row[$column]);
										} 
										if(strpos($row[$column], '[AKSL-LSKA]') !== false) {
											$row[$column] = str_replace('[AKSL-LSKA]', '#', $row[$column]);
										} 
										$row[$column] = $this -> encode_decode('encrypt',$row[$column]);
									}
									// $row[$column] = htmlentities($row[$column],ENT_QUOTES);
									// $row[$column] = html_entity_decode($row[$column]);
									
								}
							}
						}
						$list[] = $row;
					}
				}
			}
			return $list;
		}

		public function daily_db_backup() {
			$con = $this->connect();
			$backupAlert = 0; $backup_file = ""; $file_name = ""; $dbname = $this->db_name;
			$tables = array();

			$actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

			if (strpos($actual_link, 'admin_mvm_crackers_26032024') !== false) {
				$path = $GLOBALS['backup_folder_name']."/"; 
			} else {
				$path = $GLOBALS['admin_folder_name']."/".$GLOBALS['backup_folder_name']."/";
			} 

			//$result = mysqli_query($con, "SHOW TABLES");
			$select_query = "SHOW TABLES";
			$result = 0; $pdo = "";			
			$pdo = $con->prepare($select_query);
			$pdo->execute();	
			$result = $pdo->fetchAll(PDO::FETCH_COLUMN); 
			if (!$result) {
				$backupAlert = 'Error found.<br/>ERROR : ' . mysqli_error($con) . 'ERROR NO :' . mysqli_errno($con);
			}
			else {
				$tables = array();
				foreach($result as $table_name) {
					if(!empty($table_name)) {
						$tables[] = $table_name;
					}
				}
				$output = '';
				if(!empty($tables)) {
					foreach($tables as $table) {
						$show_table_query = "SHOW CREATE TABLE " . $table . "";
						$statement = $con->prepare($show_table_query);
						$statement->execute();
						$show_table_result = $statement->fetchAll();

						foreach($show_table_result as $show_table_row) {
							$output .= "\n\n" . $show_table_row["Create Table"] . ";\n\n";
						}
						$select_query = "SELECT * FROM " . $table . "";
						$statement = $con->prepare($select_query);
						$statement->execute();
						$total_row = $statement->rowCount();
						for($count=0; $count<$total_row; $count++) {
							$single_result = $statement->fetch(\PDO::FETCH_ASSOC);
							$table_column_array = array_keys($single_result);
							$table_value_array = array_values($single_result);
							$output .= "\nINSERT INTO $table (";
							$output .= "" . implode(", ", $table_column_array) . ") VALUES (";
							$output .= "'" . implode("','", $table_value_array) . "');\n";
						}
					}
				}

				if(!empty($output)) {
					$file_name = $dbname.'.sql';
					$backup_file = $path.$file_name;
					file_put_contents($backup_file, $output);
					if(file_exists($backup_file)) {
						$backupAlert = 1;
					}
				}
			}

			$msg = "";
			if(!empty($backupAlert) && $backupAlert == 1) {
				$msg = $backup_file;
			}
			else {
				$msg = $backupAlert;
			}
			return $msg;
		}

		public function image_directory() {
			$target_dir = "include/images/upload/";
			return $target_dir;
		}
		public function image_directory1() {
			$target_dir1 = "admin_mvm_crackers_26032024/include/images/upload/";
			return $target_dir1;
		}
		public function temp_image_directory() {
			$temp_dir = "include/images/temp/";
			return $temp_dir;
		}
		public function temp_image_directory1() {
			$temp_dir1 = "admin_mvm_crackers_26032024/include/images/temp/";
			return $temp_dir1;
		}
		public function clear_temp_image_directory() {
			$temp_dir = "include/images/temp/";
			
			$files = glob($temp_dir.'*'); // get all file names
			foreach($files as $file){ // iterate files
			  if(is_file($file))
				unlink($file); // delete file
			}
			
			return true;
		}
		public function clear_temp_image_directory1() {
			$temp_dir1 = "admin_mvm_crackers_26032024/include/images/temp/";
			
			$files = glob($temp_dir1.'*'); // get all file names
			foreach($files as $file){ // iterate files
			  if(is_file($file))
				unlink($file); // delete file
			}
			
			return true;
		}
		
		/* public function check_user_id_ip_address() {
			$con = $this->connect();
			$select_query = ""; $check_login_id = "";
			
			if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id']) && isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'])) {
				$select_query = "SELECT id FROM ".$GLOBALS['login_table']." WHERE user_id = '".$_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id']."' AND ip_address = '".$_SESSION[$GLOBALS['site_name_user_prefix'].'_user_ip_address']."' AND logout_date_time = '0000-00-00 00:00:00' ORDER BY id DESC LIMIT 1";
				
				$result = 0; $pdo = "";			
				$pdo = $con->prepare($select_query);
				$pdo->execute();	
				$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
				if(!empty($result)) {
					foreach($pdo->fetchAll() as $row) {
						$check_login_id = $row['id'];
					}
				}
			}
			return $check_login_id;
		} */ 

		public function check_user_id_ip_address() {
			$select_query = ""; $list = array(); $check_login_id = "";	
					
			if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id']) && isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'])) {
				if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_ip_address']) && isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_ip_address'])) {
					$select_query = "SELECT l.id,
											CASE
												WHEN l.type = 'Super Admin' THEN u.id
												WHEN l.type = 'manager' THEN s.id
											END as user_unique_id
										FROM ".$GLOBALS['login_table']." as l 
										LEFT JOIN ".$GLOBALS['user_table']." as u ON u.user_id = l.user_id AND u.deleted = '0'
										LEFT JOIN ".$GLOBALS['manager_table']." as s ON s.manager_id = l.user_id AND s.deleted = '0'
										WHERE l.user_id = '".$_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id']."' 
											AND l.ip_address = '".$_SESSION[$GLOBALS['site_name_user_prefix'].'_user_ip_address']."' 
											AND l.logout_date_time = login_date_time ORDER BY l.id DESC LIMIT 1";
					$list = $this->getQueryRecords($GLOBALS['login_table'], $select_query);
					if(!empty($list)) {
						foreach($list as $row) {
							if(preg_match("/^\d+$/", $row['user_unique_id'])) {
								if(!empty($row['id'])) {
									$check_login_id = $row['id'];
								}
							}
						}
					}
				}
			}
			return $check_login_id;
		}
		
		public function checkUser() {	
			$user_id = ""; $select_query = ""; $list = array(); $login_user_id = "";

			$actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

			if (strpos($actual_link, 'admin_mvm_crackers_26032024') !== false) {
				if(isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'])) {
					$user_id = $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'];				
					$today = date('Y-m-d');					
					$select_query = "SELECT l.*,
										CASE
											WHEN l.type = 'Super Admin' THEN u.id
											WHEN l.type = 'manager' THEN s.id
										END as user_unique_id
										FROM ".$GLOBALS['login_table']." as l
										LEFT JOIN ".$GLOBALS['user_table']." as u ON u.user_id = l.user_id AND u.deleted = '0'
										LEFT JOIN ".$GLOBALS['manager_table']." as s ON s.manager_id = l.user_id AND s.deleted = '0'
										WHERE l.user_id = '".$user_id."' AND DATE(l.login_date_time) = '".$today."' AND logout_date_time = login_date_time 
										ORDER BY l.id DESC LIMIT 1";
					$list = $this->getQueryRecords($GLOBALS['login_table'], $select_query);
					if(!empty($list)) {
						foreach($list as $row) {
							if(preg_match("/^\d+$/", $row['user_unique_id'])) {
								if(!empty($row['user_id'])) {
									$login_user_id = $row['user_id'];
								}
							}
						}
					}
				}
			} 				
			else 
			{
				if(isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'])) {
					$user_id = $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'];				
					$today = date('Y-m-d');					
					$select_query = "SELECT l.*,
										CASE
											WHEN l.type = 'member' THEN u.id
											WHEN l.type = 'manager' THEN s.id
										END as user_unique_id
										FROM ".$GLOBALS['login_table']." as l
										LEFT JOIN ".$GLOBALS['member_table']." as u ON u.member_unique_id = l.user_id AND u.deleted = '0' and u.is_approved = '1' and u.is_rejected='0'	
										LEFT JOIN ".$GLOBALS['manager_table']." as s ON s.manager_unique_id = l.user_id AND s.deleted = '0'					
										WHERE l.user_id = '".$user_id."' AND DATE(l.login_date_time) = '".$today."' AND logout_date_time = login_date_time 
										ORDER BY l.id DESC LIMIT 1";
					$list = $this->getQueryRecords($GLOBALS['login_table'], $select_query);
					if(!empty($list)) {
						foreach($list as $row) {
							if(preg_match("/^\d+$/", $row['user_unique_id'])) {
								if(!empty($row['user_id'])) {
									$login_user_id = $row['user_id'];
								}
							}
						}
					}
				}
			}
			// echo $login_user_id."hi";
			return $login_user_id;
		}

		/* public function valid_user() {

			$login_member_id = "";
		
			if(isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'])) {
				$user_id = $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'];				
				$today = date('Y-m-d');					
				$select_query = "SELECT user_unique_id FROM 
				((SELECT g.manager_unique_id  as user_unique_id FROM ".$GLOBALS['manager_table']." as g WHERE deleted ='0')
				UNION ALL (SELECT k.member_unique_id  as user_unique_id FROM ".$GLOBALS['member_table']." as k WHERE k.deleted ='0' and k.is_approved='1' and k.is_rejected='0') ) as l WHERE l.user_unique_id ='".$user_id."' ";
				$list = $this->getQueryRecords($GLOBALS['login_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $row) {
						// if(preg_match("/^\d+$/", $row['user_unique_id'])) {
							if(!empty($row['user_unique_id'])) {
								$login_member_id = $row['user_unique_id'];
							}
						// }
					}
				}
			}

			// echo $login_member_id." hii";

			return $login_member_id;
		} */

		public function getDailyReport($from_date, $to_date) {
            $log_list = array(); $select_query = ""; $where = "";
			$log_backup_file = $GLOBALS['log_backup_file'];
			if(file_exists($log_backup_file)) {
				$myfile = fopen($log_backup_file, "r");
				while(!feof($myfile)) {
					$log = "";
					$log = fgets($myfile);
					$log = trim($log);
					if(!empty($log)) {
						$log = json_decode($log);
						$log_list[] = $log;
					}
				}
				fclose($myfile);
				if(!empty($log_list)) {
					$list = array();
					foreach($log_list as $row) {							
						if(!empty($from_date) && !empty($to_date)) {
							$success = 0; $action = "";
							foreach($row as $key => $value) {								
								if( (!empty($key) && $key == "action")) {
									$action = $value;
								}
							}
							if(!empty($action)) {
								foreach($row as $key => $value) {
									if( (!empty($key) && $key == "created_date_time")) {
										if( ( date("d-m-Y", strtotime($value)) >= date("d-m-Y", strtotime($from_date)) ) && ( date("d-m-Y", strtotime($value)) <= date("d-m-Y", strtotime($to_date)) ) ) {
											$success = 1;										
										}
									}
								}
							}
							if(!empty($success) && $success == 1) {
								$list[] = $row;
							}
						}
					}
					$log_list = $list;
				}
			}
			return $log_list;
        }

		/* public function send_mobile_details($phone_number, $msg) {		
			$phone_number = '91'.$phone_number;
			$mailin = new MailinSms($GLOBALS['mailin_sms_api_key']);
			$mailin->addTo($phone_number);
			$mailin->setFrom('ram');
			$mailin->setText($msg);
			$mailin->setTag('');
			$mailin->setType('');
			$mailin->setCallback('');
			$res = $mailin->send();
			return $res;
		} */


	
		public function CheckManagerAccessPage($manager_id,$permission_page) {
			$list = array(); $select_query = ""; $acccess_permission = 0;
			$select_query = "SELECT * FROM ".$GLOBALS['manager_table']." WHERE manager_id = '".$manager_id."' AND deleted = '0'";
			$list = $this->getQueryRecords($GLOBALS['manager_table'], $select_query);
			if(!empty($list)) {
				$access_pages = "";
				foreach($list as $data) {
					if(!empty($data['access_pages'])) {
						$access_pages = $data['access_pages'];
					}
				}

				if(!empty($access_pages)) {
					$access_pages = explode(",", $access_pages);
					if(!empty($permission_page)) {
						$permission_page = $this->encode_decode('encrypt', $permission_page);
						if(in_array($permission_page, $access_pages)) {
							$acccess_permission = 1;
						}
					}
				}
			}
			return $acccess_permission;
		}

		public function tamilarasi_automate_number($table, $column) {
			$last_number = ""; $last_id_number = "";
			$con = $this->connect();
			$select_query = ""; $unique_id = ""; $next_number = 1; $matches = array(); $match = array(); $last_number_array = array();
			$current_year = date("y"); $next_year = date("y")+1;

			$select_query = "SELECT ".$column." FROM ".$table." ORDER BY id DESC LIMIT 1";
			$result = 0; $pdo = "";			
			$pdo = $con->prepare($select_query);
			$pdo->execute();	
			$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
			if(!empty($result)) {
				foreach($pdo->fetchAll() as $row) {
					$last_number = $row[$column];
					if(!empty($last_number) && $last_number != $GLOBALS['null_value']) {
						$last_number = $this->encode_decode('decrypt', $last_number)."===";
					}						
					if(!empty($last_number)) { break; }
				}
			}	
			$last_id_number = $last_number;
			if(strpos($last_number, '/') !== false){
				$last_number_array = explode("/", $last_number);
				$last_number = $last_number_array[1];
				// $next_number = $next_number + 1;
			}

			if(!empty($last_number)) {
				preg_match_all('/([0-9]+|[a-zA-Z]+)/',$last_number, $matches);				
				if(!empty($matches)) {
					$last_number = "";
					 $match = $matches[count($matches) - 1];
					if(!empty($match)) {
						$last_number = $match[count($match) - 1];
						if(preg_match("/^\d+$/", $last_number)) {
							$next_number = $last_number + 1;
						}
					}
				}	
			}
			
			if(!empty($next_number)) {
				$year_prefix = date("Y");
							

				if(date("m") == date("01") || date("m") == date("02") || date("m") == date("03")) {
					$year_prefix = date("Y") - 1;
					$current_year = date("y") - 1; $next_year = date("y");
				}

				if(empty($last_number)){
					$last_number = 1;
				}
				if(date("d-m-Y") >= date("01-04-Y")) {
					if(strpos($last_id_number,$year_prefix) !== false || strpos($last_id_number,($current_year.'-'.$next_year)) !== false){
						
					}
				}

				if(!empty($table)) {
					
					if($table == $GLOBALS['manager_table']) {
						$bill_number_prefix = 'MVMMM'; 
					}

					if($table == $GLOBALS['member_table']) {
						$bill_number_prefix = 'MVMME'; 
					}
				}

				
				if(strlen($next_number) == "1"){
					$next_number = '00'.$next_number;
				}
				else if(strlen($next_number) == "2"){
					$next_number = '0'.$next_number;
				}
				
				if(($table == $GLOBALS['manager_table']) || ($table == $GLOBALS['member_table'])) {
					
					if(!empty($year_prefix) && !empty($bill_number_prefix)) {
						$next_number = $bill_number_prefix.'/'.$next_number;
					}
					
				}
				else {
					if(!empty($year_prefix) && !empty($bill_number_prefix)) {
						$next_number = $next_number.'/'.$bill_number_prefix.$current_year.'-'.$next_year;
					}
				}
				// }
			}
			return $next_number;
		}

		public function automate_number($table, $column) {
			$last_number = ""; $last_id_number = "";
			$con = $this->connect();
			$select_query = ""; $unique_id = ""; $next_number = 1; $matches = array(); $match = array();
			$current_year = date("y"); $next_year = date("y")+1;

			// $prefix_suffix = $this->getTableColumnValue($GLOBALS['settings_table'], 'settings_name', 'prefix_suffix', 'settings_value');
			
			$select_query = "SELECT ".$column." FROM ".$table." ORDER BY id DESC LIMIT 1";
			$result = 0; $pdo = "";			
			$pdo = $con->prepare($select_query);
			$pdo->execute();	
			$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
			if(!empty($result)) {
				foreach($pdo->fetchAll() as $row) {
					$last_number = $row[$column];
					if(!empty($last_number) && $last_number != $GLOBALS['null_value']) {
						$last_number = $this->encode_decode('decrypt', $last_number);
					}
					if(!empty($last_number)) { break; }
				}
			}	
			$last_id_number = $last_number;
			if(strpos($last_number, '/') !== false){
				$last_number = substr($last_number, 0, 3);
				$next_number = $next_number + 1;
			}

			if(!empty($last_number)) {
				preg_match_all('/([0-9]+|[a-zA-Z]+)/',$last_number,$matches);				
				if(!empty($matches)) {
					$last_number = ""; $match = $matches[count($matches) - 1];
					if(!empty($match)) {
						$last_number = $match[count($match) - 1];
						if(preg_match("/^\d+$/", $last_number)) {
							$next_number = $last_number + 1;
						}
					}
				}	
			}
			
			if(!empty($next_number)) {
				$year_prefix = date("Y");
								

				if(date("m") == date("01") || date("m") == date("02") || date("m") == date("03")) {
					$year_prefix = date("Y") - 1;
					$current_year = date("y") - 1; $next_year = date("y");
				}

				if(empty($last_number)){
					$last_number = 1;
				}
				
				if(!empty($table)) {
					if($table == $GLOBALS['receipt_table']) {
						$bill_number_prefix = 'RE'; 
					}
					if($table == $GLOBALS['plan_closure_table']) {
						$bill_number_prefix = 'PC'; 
					}					
				}

				if(strlen($next_number) == "1"){
					$next_number = '00'.$next_number;
				}
				else if(strlen($next_number) == "2"){
					$next_number = '0'.$next_number;
				}
				
				if(!empty($year_prefix) && !empty($bill_number_prefix)) {
					$next_number = $next_number.'/'.$bill_number_prefix.$current_year.'-'.$next_year;
				}
			}
			return $next_number;
		}

		public function send_mobile_details($mobile_number, $sms_number, $sms) {
			$res = true; $sms_link = "";
			if(!empty($mobile_number) && !empty($sms_number) && !empty($sms)) {
				//$sms_link = "https://www.fast2sms.com/dev/bulkV2?authorization=NmXuvhPO8nQ2bi6ZFMxYJdsL470jHlyqVEgfoU3wRAGp1BzCKcSlJyzk1LB8PiOjwMu3E6x9tCcNRWpG&route=dlt&sender_id=SRISOF&message=126873&variables_values=".$msg."|&flash=0&numbers=".$mobile_number;
				$fields = array(
					"sender_id" => "SRISOF",
					"message" => $sms_number,
					"variables_values" => $sms,
					"route" => "dlt",
					"numbers" => $mobile_number,
				);

				//echo "sms_number - ".$sms_number.", mobile_number - ".$mobile_number.", sms - ".$sms."<br>";
				
				$curl = curl_init();
				
				curl_setopt_array($curl, array(
				  CURLOPT_URL => "https://www.fast2sms.com/dev/bulkV2",
				  CURLOPT_RETURNTRANSFER => true,
				  CURLOPT_ENCODING => "",
				  CURLOPT_MAXREDIRS => 10,
				  CURLOPT_TIMEOUT => 30,
				  CURLOPT_SSL_VERIFYHOST => 0,
				  CURLOPT_SSL_VERIFYPEER => 0,
				  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				  CURLOPT_CUSTOMREQUEST => "POST",
				  CURLOPT_POSTFIELDS => json_encode($fields),
				  CURLOPT_HTTPHEADER => array(
					"authorization: VFxWy81QjDk3S2b6qo0JRNHaYCcZs4nmA5Xl7KMuGtwpTIPiUBV6LM5aSg7x84mfP2XyJtshdoFGEBrK",
					"cache-control: no-cache",
					"content-type: application/json"
				  ),
				));
				
				$response = curl_exec($curl);
				$err = curl_error($curl);
				
				curl_close($curl);
			}

			/*$phone_number = '91'.$phone_number;
			$mailin = new MailinSms($GLOBALS['mailin_sms_api_key']);
			$mailin->addTo($phone_number);
			$mailin->setFrom('ram');
			$mailin->setText($msg);
			$mailin->setTag('');
			$mailin->setType('');
			$mailin->setCallback('');
			$res = $mailin->send();*/
			return $res;
		}
	}	
?>