<?php
	include("include_files.php");
    include("include/billing_functions.php");

    if(isset($_POST['page_number'])) {
		$page_number = $_POST['page_number'];
		$page_limit = $_POST['page_limit'];
		$page_title = $_POST['page_title']; 

        $search_text = "";
		if(isset($_POST['search_text'])) {
			$search_text = $_POST['search_text'];
		} 

		$total_records_list = array();
		$total_records_list = $obj->getPendingApprovalList();

		if(!empty($search_text)) {
            $search_text = strtolower($search_text);
            $list = array();
            if(!empty($total_records_list)) {
                foreach($total_records_list as $val) {
                    $selected = 0;
                    if(strpos(strtolower($obj->encode_decode('decrypt', $val['member_name'])), $search_text) !== false || strpos($val['mobile_number'], $search_text) !== false) {
                        $selected = 1;
                    }
                    if(!empty($selected) && $selected == 1) {
                        $list[] = $val;
                    }
                }
            }
            $total_records_list = $list;
        }
        
        $total_pages = 0;	
        $total_pages = count($total_records_list);
        
        $page_start = 0; $page_end = 0;
        if(!empty($page_number) && !empty($page_limit) && !empty($total_pages)) {
            if($total_pages > $page_limit) {
                if($page_number) {
                    $page_start = ($page_number - 1) * $page_limit;
                    $page_end = $page_start + $page_limit;
                }
            }
            else {
                $page_start = 0;
                $page_end = $page_limit;
            }
        }
            
        $show_records_list = array();
        if(!empty($total_records_list)) {
            $show_records_list = array_slice($total_records_list, $page_start, $page_limit);
        } ?>
        
		<table class="table nowrap smallfnt bg-white text-center member_approval_table">
            <thead class="bg-light">
                <tr>
                    <th>#</th>
                    <th>Created Date</th>
                    <th>Manager</th>
                    <th>Member</th>
                    <th>Member Id</th>
                    <th>Referal Id</th>
                    <th>Referral Person No</th>                                        
                    <th>Plan Name</th>
                    <th>Payment Screen Shot</th>
                </tr>
            </thead>
            <tbody>
                <?php if(!empty($show_records_list)) {
                        // $edit_action = $obj->encode_decode('encrypt', 'edit_action');
                        foreach($show_records_list as $key => $list) {
                            $index = $key + 1; $manager_unique_id = ""; $reference = "";
                            if(!empty($prefix)) { $index = $index + $prefix; } ?>
                        <tr>
                            <td>
                                <input class="form-check-input mx-auto member_approval" type="checkbox" id="approval_checkbox" name="length_check" value="<?php if(!empty($list['member_unique_id'])) {echo $list['member_unique_id']; } ?>" id="defaultCheck1">
                                
                            </td>
                            <td>
                                <?php 
                                    if(!empty($list['created_date_time']) && $list['created_date_time'] != "0000-00-00 00:00:00") { 
                                        echo date("d-m-Y", strtotime($list['created_date_time'])); 
                                    } 
                                ?>
                            </td>
                            <td>
                                <?php if(!empty($list['manager_id'])) {
                                    $manager_unique_id = $list['manager_id'];
                                    $manager_name = "";
                                    $manager_name = $obj->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $manager_unique_id, 'manager_name');
                                    echo $obj->encode_decode("decrypt", $manager_name);
                                }
                                ?>
                            </td>
                            <td>
                                <?php if(!empty($list['member_name'])) {
                                    echo $obj->encode_decode("decrypt", $list['member_name']);
                                }
                                ?>
                            </td>
                            <td>
                                <?php if(!empty($list['member_unique_id'])) {
                                    echo $obj->encode_decode("decrypt", $list['member_unique_id']);
                                }
                                ?>
                            </td>  
                            <td>
                                <?php if(!empty($list['reference_id'])) {
                                    echo $obj->encode_decode("decrypt", $list['reference_id']);
                                }
                                ?>
                            </td>                          
                            <td>
                                <?php if(!empty($list['reference_id'])) {
                                    $reference = $obj->encode_decode("decrypt", $list['reference_id']);
                                    $reference = explode("/",$reference);
                                    if($reference[0] == "MVMMM") {
                                        $manager_id = $list['reference_id'];
                                        $reference_number = $obj->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $list['reference_id'], 'mobile_number');
                                    }
                                    else {
                                        $manager_id = $obj->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $list['reference_id'], 'manager_id');
                                        $reference_number = $obj->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $list['reference_id'], 'mobile_number');
                                    }

                                    if(!empty($reference_number)) {
                                        echo $obj->encode_decode("decrypt", $reference_number);
                                    }
                                }
                                ?>
                            </td>                            
                            <td>
                                <?php if(!empty($list['plan_id'])) {
                                    $plan_name = $obj->getTableColumnValue($GLOBALS['plan_table'], 'plan_id', $list['plan_id'], 'plan_name');
                                    echo $obj->encode_decode("decrypt", $plan_name);
                                }
                                ?>
                            <td>
                                <?php 
                                if(!empty($list['payment_screenshot']) && ($list['payment_screenshot'] !="NULL")) {
                                    $payment_screenshot = $list['payment_screenshot'];
                                    $target_dir = $obj->image_directory();
                                ?>
                                <!-- <img src="images/avatar-4.jpg" class="w-20 mx-auto d-block">  -->
                                <img id="payment_upi_preview" onClick="Javascript:ShowPaymentDetaills('<?php if(!empty($payment_screenshot)) { echo $payment_screenshot; } ?>', 'Member Approval')" class="w-20 mx-auto d-block" src="<?php if(!empty($payment_screenshot) && file_exists($target_dir.$payment_screenshot)) { echo $target_dir.$payment_screenshot; } ?>" style="max-width: 200px; max-height: 200px;" />
                                <?php } else {
                                    echo " - ";
                                } ?>
                            </td>
                        </tr>
                    <?php } 
                } else  {
                    ?>
                    <tr>
                        <td colspan="4" class="text-center">Sorry! No records found</td>
                    </tr>
            <?php }
                ?>
                
            </tbody>
        </table>
    <?php } ?>                     
	