<?php 
	$page_title = "Pricelist Upload";
	include("include_user_check_and_files.php");
	$page_number = $GLOBALS['page_number']; $page_limit = $GLOBALS['page_limit'];
    $pricelist_image = "pricelist.pdf";
    $target_dir = $obj->image_directory();

    $website_on = 0;
    $website_on = $obj->getTableColumnValue($GLOBALS['company_table'], 'primary_company', 1, 'website_on');
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title> <?php if(!empty($project_title)) { echo $project_title; } ?> - <?php if(!empty($page_title)) { echo $page_title; } ?> </title>
	<?php 
	include "link_style_script.php"; ?>
    <script type="text/javascript" src="include/js/cropper_image_upload.js"></script>
    <script type="text/javascript" src="include/js/action.js"></script>
</head>	
<body>
<?php include "header.php"; ?>
<!--Right Content-->
<div class="pcoded-content">
    <div class="page-header card">
        <div class="mt-2 border bg-white">
            <div class="card-header">
                <div class="row">
                    <div class="col-lg-8 col-md-8 col-8">
                        <h5 class="text-white">Pricelist Upload</h5>
                    </div>
                </div>
            </div>
			<div class="row p-3 success">
                <div class="col-lg-6 col-md-6 col-12 pb-3 text-center">
                    <!-- <img src="images/cloudupload.png" class="img-fluid w-25 mx-auto d-block" alt="Upload" title="Upload"> -->
                    <div class="text-center font-weight-bold">Pricelist PDF Upload</div>
                    <div class="text-center smallfnt">(Upload Pdf file Less than 2MB)</div>
                    <div id="pricelist_cover" class="form-group">
                    <div class="image-upload text-center">
                        <label for="pricelist">   
                            <div class="pricelist_list row">
                                <div class="col-12">
                                    <div class="cover">
                                        <?php if(!empty($pricelist_image) && file_exists($target_dir.$pricelist_image)) { ?>
                                            <button type="button" onclick="Javascript:delete_upload_image_before_save(this, 'pricelist_preview', '<?php if(!empty($pricelist_image) && file_exists($target_dir.$pricelist_image)) { echo $pricelist_image; } ?>');" class="btn btn-danger"><i class="fa fa-close"></i></button>
                                            <a href="<?php echo $target_dir.$pricelist_image ?>" class="btn btn-success delete_pdf" target="_blank">
                                                <i class="fa fa-file-pdf-o" style="font-size: 50px;"></i>
                                            </a>
                                            <input type="hidden" name="pricelist_name[]" value="<?php if(!empty($pricelist_image)) { echo $pricelist_image; } ?>">
                                        <?php } else { ?>
                                            <img id="pricelist_preview" src="images/cloudupload.png" style="max-width: 200px;" />
                                        <?php } ?>
                                    </div>
                                </div>        
                            </div>
                            <input type="file" name="pricelist" id="pricelist" style="display: none;" accept="application/pdf"/>
                        </label>
                    </div>                    
                    <div class="plan_upi_container" style="display: none;">
                        <canvas id="plan_upi_canvas"></canvas>
                    </div>
                </div>
                </div>
                <div class="col-lg-6 col-md-6 col-12 pb-3 text-center" id="pricelist_pdf">
                    <div class="custom-control custom-switch">
                        <input type="checkbox" class="custom-control-input" name="pricelist_option" id="pricelist_option" <?php if(!empty($website_on) && $website_on == 1) { ?> checked <?php } ?> value="<?php if(!empty($website_on)) { echo $website_on; } else { echo "0"; } ?>">
                        <label class="custom-control-label" onClick="Javascript:ShowPricelist(this, 'pricelist_option');" for="pricelist_option">Website Status</label>
                    </div>
                </div>
                <div class="col-md-12 pt-3 text-center d-none" id="pdf_submit_button">
                    <button class="btn btn-dark" type="button" onclick="Javascript:UploadImageToTargetFolder();"> Submit </button>
                </div>
			</div>
        </div>
    </div>
</div>
<button type="button" data-toggle="modal" data-target="#Pdfdeletemodal" class="d-none delete_pdf_modal_button"></button>
<div class="modal fade" id="Pdfdeletemodal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-md" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title h5">Delete</h1>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                Are you sure want to delete?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-success yes" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-danger no">Delete</button>
            </div>
        </div>
    </div>
</div>
<?php include "footer.php"; ?>
<script>
    $(document).ready(function(){
        $("#pricelistupload").addClass("active");
    });
</script>