<?php
	include("prabhucrackers_23012024.php");
	class Common_Functions extends db {
		public $con;
		
		public function connect() {
			$con = parent::connect();
			return $con;
		}

		public function encode_decode($action, $string) {
			$output = false;
		 
			$encrypt_method = "AES-256-CBC";
			$secret_key = 'This is my secret key';
			$secret_iv = 'This is my secret iv';
		 
			// hash
			$key = hash('sha256', $secret_key);
			
			// iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
			$iv = substr(hash('sha256', $secret_iv), 0, 16);
		 
			if( $action == 'encrypt' ) {
				$output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
				$output = base64_encode($output);
				$output =  bin2hex($output);
			}
			else if( $action == 'decrypt' ){
				$output = hex2bin($string);
				$output = base64_decode($output);
				$output = openssl_decrypt($output, $encrypt_method, $key, 0, $iv);
			}
		 
			return $output;
		}
		
		public function InsertSQL($table, $columns, $values, $action) {
			$con = $this->connect(); $last_insert_id = "";
			
			if(!empty($columns) && !empty($values)) {
				if(count($columns) == count($values)) {					
					$columns = implode(",", $columns);
					$values = implode(",", $values);
					
					$result = "";
					$insert_query = "INSERT INTO ".$table." (".$columns.") VALUES (".$values.")";
					$result = $con->prepare($insert_query);
					if($result->execute() === TRUE) {
						$last_insert_id = $con->lastInsertId();
						$last_query_insert_id = "";
						if(preg_match("/^\d+$/", $last_insert_id)) {
							$last_log_id = $this->add_log($table, $last_insert_id, $insert_query, $action);
						}
					}
					else {
						$last_insert_id = "Unable to insert the data";
					}
				}
				else {
					$last_insert_id = "Columns are not match";
				}
			}			
					
			return $last_insert_id;
		}
		
		public function add_log($table, $table_unique_id, $query, $action) {
			$con = $this->connect(); $last_query_insert_id = "";
			if(!empty($query) && !empty($action)) {
				$query = $this->encode_decode('encrypt', $query);
				$action = $this->encode_decode('encrypt', $action);
				$table = $this->encode_decode('encrypt', $table);
			
				$create_date_time = $GLOBALS['create_date_time_label'];
				$creator = "";
				if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id']) && isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'])) {
					$creator = $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'];
				}
				$creator_type = "";
				if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_type']) && isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_type'])) {
					$creator_type = $this->encode_decode('encrypt', $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_type']);
				}
				$creator_name = "";
				if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_name']) && isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_name'])) {
					$creator_name = $this->encode_decode('encrypt', $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_name']);
				}
				$creator_mobile_number = "";
				if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_mobile_number']) && isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_mobile_number'])) {
					$creator_mobile_number = $this->encode_decode('encrypt', $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_mobile_number']);
				}

				//$log_backup_file = $GLOBALS['log_backup_file'];

				$actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
				/*if(!empty($actual_link)) {
					if (strpos( $actual_link, $GLOBALS['admin_folder_name']) == false) {
						if (strpos( $actual_link, 'API') == true) {
							$log_backup_file = '../'.$GLOBALS['admin_folder_name']."/".$log_backup_file;
						}
						else {
							$log_backup_file = $GLOBALS['admin_folder_name']."/".$log_backup_file;
						}
					}
				}*/

				$log_backup_file = "";
				$dirpath = $GLOBALS['log_backup_folder_name'];
				$dirpath .= "/*.csv";
				$csv_files = array();
				$csv_files = glob($dirpath);
				usort($csv_files, function($x, $y) {
					return filemtime($x) < filemtime($y);
				});
				if(!empty($csv_files)) {
					$last_created_file = "";
					$last_created_file = $csv_files['0'];
					if(!empty($last_created_file)) {
						$log_backup_file = $last_created_file;
					}
				}
				if(empty($log_backup_file)) {
					$log_backup_file = $GLOBALS['log_backup_folder_name']."/log_".date("d_m_Y").".csv";
				}
				if(!empty($log_backup_file)) {
					if (strpos($actual_link, 'order') !== false) {
						$log_backup_file = "../".$GLOBALS['admin_folder_name']."/".$log_backup_file;
					}
					if (strpos($actual_link, 'API') !== false) {
						$log_backup_file = "../prabhucrackers.com/".$GLOBALS['admin_folder_name']."/".$log_backup_file;
					}
				}

				$columns = array('type', 'created_date_time', 'creator', 'creator_name', 'creator_mobile_number', 'log_table', 'log_table_unique_id', 'action', 'query');	
				$values = array("'".$creator_type."'", "'".$create_date_time."'", "'".$creator."'", "'".$creator_name."'", "'".$creator_mobile_number."'", "'".$table."'", "'".$table_unique_id."'", "'".$action."'", "'".$query."'");			
				/*if(count($columns) == count($values)) {	
					$log_data = array();
					$log_data = array('type' => $creator_type, 'created_date_time' => $create_date_time, 'creator' => $creator, 'creator_name' => $creator_name, 'creator_mobile_number' => $creator_mobile_number, 'table' => $table, 'table_unique_id' => $table_unique_id, 'action' => $action, 'query' => $query);	
					if(!empty($log_data)) {
						$log_data = json_encode($log_data);
						
						if(file_exists($log_backup_file)) {
							file_put_contents($log_backup_file, $log_data, FILE_APPEND | LOCK_EX);
							file_put_contents($log_backup_file, "\n", FILE_APPEND | LOCK_EX);
						}
						else {
							$myfile = fopen($log_backup_file, "a+");
							fwrite($myfile, $log_data."\n");
							fclose($myfile);
						}
					}
				}*/
				if(count($columns) == count($values)) {	
					$log_data = array();
					$log_data = array('type' => $creator_type, 'created_date_time' => $create_date_time, 'creator' => $creator, 'creator_name' => $creator_name, 'table' => $table, 'table_unique_id' => $table_unique_id, 'action' => $action, 'query' => $query);	
					if(!empty($log_data)) {
						$log_data = json_encode($log_data);	
						$values = array($creator_type, $create_date_time, $creator, $creator_name, $table, $table_unique_id, $action, $query);

						//echo "log_backup_file - ".$log_backup_file."<br>";

						if(file_exists($log_backup_file)) {
							$backup_file_size = 0;
							$backup_file_size = filesize($log_backup_file);

							if($backup_file_size > 0) {
								$backup_file_size = $backup_file_size / 1048576;

								$backup_files_count = 0; $max_log_file_size_mb = 0;
								$backup_files_count = count(glob($GLOBALS['log_backup_folder_name']."/*"));
								$max_log_file_size_mb = $GLOBALS['max_log_file_size_mb'];
								/*if(!empty($max_log_file_size_mb)) {
									$max_log_file_size_mb = $max_log_file_size_mb  * 1000000;
								}*/
								//echo "backup_file_size - ".$backup_file_size.", max_log_file_size_mb - ".$max_log_file_size_mb."<br>";
								if(!empty($backup_file_size) && !empty($max_log_file_size_mb) && $backup_file_size > $max_log_file_size_mb) {
									$backup_files_count = $backup_files_count + 1;
									$log_backup_file = $GLOBALS['log_backup_folder_name']."/log_".date("d_m_Y").".csv";
									if(!empty($log_backup_file)) {
										if (strpos($actual_link, 'order') !== false) {
											$log_backup_file = "../".$GLOBALS['admin_folder_name']."/".$log_backup_file;
										}
										if (strpos($actual_link, 'API') !== false) {
											$log_backup_file = "../prabhucrackers.com/".$GLOBALS['admin_folder_name']."/".$log_backup_file;
										}
									}
									$fp = fopen($log_backup_file,"w");
									$log_headings = array('type', 'created_date_time', 'creator', 'creator_name', 'creator_mobile_number', 'table', 'table_unique_id', 'action', 'query');
									fputcsv( $fp, $log_headings);
									fclose($fp);

									$myfile = fopen($log_backup_file, "a");
									fputcsv($myfile, $values);
									fclose($myfile);
								}
								else {
									$myfile = fopen($log_backup_file, "a");
									fputcsv($myfile, $values);
									fclose($myfile);

									$max_log_file_count = $GLOBALS['max_log_file_count'];
									//echo "backup_files_count - ".$backup_files_count.", max_log_file_count - ".$max_log_file_count;
									if(!empty($max_log_file_count) && $backup_files_count > $max_log_file_count) {
										$dirpath = $GLOBALS['log_backup_folder_name'];
										// set file pattern
										$dirpath .= "/*.csv";
										// copy filenames to array
										$csv_files = array();
										$csv_files = glob($dirpath);
										// sort files by last modified date
										usort($csv_files, function($x, $y) {
											return filemtime($x) < filemtime($y);
										});
										if(!empty($csv_files)) {
											$first_created_file = "";
											$first_created_file = $csv_files[count($csv_files) - 1];
											if(!empty($first_created_file)) {
												$last_modified_date_time = ""; $current_date_time = date("d-m-Y H:i:s");
												$last_modified_date_time = date ("d-m-Y H:i:s", filemtime($first_created_file));
												$datediff = strtotime($current_date_time) - strtotime($last_modified_date_time);
												$log_no_of_days = 0;
												$log_no_of_days = round($datediff / (60 * 60 * 24));
												if($log_no_of_days > $GLOBALS['expire_log_file_days']) {
													unlink($first_created_file);
												}
											}
										}
									}
								}
							}
						}
						else {
							$fp = fopen($log_backup_file,"w");
							$log_headings = array('type', 'created_date_time', 'creator', 'creator_name', 'creator_mobile_number', 'table', 'table_unique_id', 'action', 'query');
							fputcsv( $fp, $log_headings);
							fclose($fp);

							$myfile = fopen($log_backup_file, "a");
							fputcsv($myfile, $values);
							fclose($myfile);
						}

					}
				}
			}			
					
			return $last_query_insert_id;
		}
		
		public function UpdateSQL($table, $update_id, $columns, $values, $action) {
			$con = $this->connect();
			$msg = "";

			if (!empty($columns) && !empty($values)) {
				if (count($columns) == count($values)) {
					for($i = 0; $i < count($values); $i++) {
						if(!empty($values[$i])) {
							$values[$i] = str_replace("'", "", $values[$i]);
						}
					}
					// Build column placeholders
					$set_parts = [];
					foreach ($columns as $col) {
						$set_parts[] = "{$col} = ?";
					}
					$set_clause = implode(", ", $set_parts);

					// Build SQL
					$update_query = "UPDATE {$table} SET {$set_clause} WHERE id = ?";

					try {
						$stmt = $con->prepare($update_query);

						// Append update_id as the last value
						$params = array_merge($values, [$update_id]);

						if ($stmt->execute($params)) {
							$msg = 1;
							$this->add_log($table, $update_id, $update_query, $action);
						} else {
							$msg = "Unable to update the data";
						}
					} catch (PDOException $e) {
						$msg = "Update Error: " . $e->getMessage();
					}
				} else {
					$msg = "Columns and values count do not match";
				}
			}

			return $msg;
		}

		public function getTableColumnValue($table, $column, $value, $return_value) {
            $con = $this->connect();
            $table_column_value = "";

            // Validate required params
            if (!empty($table) && !empty($column) && !empty($value) && !empty($return_value)) {

                // Build query with placeholders
                $select_query = "SELECT {$return_value} FROM {$table} WHERE {$column} = :value AND deleted = 0 LIMIT 1";

                try {
                    $stmt = $con->prepare($select_query);
                    $stmt->bindParam(':value', $value, PDO::PARAM_STR);
                    $stmt->execute();

                    $row = $stmt->fetch(PDO::FETCH_ASSOC);
                    if ($row && isset($row[$return_value])) {
                        $table_column_value = $row[$return_value];
                    }
                } catch (PDOException $e) {
                    // Log or handle error
                    error_log("PDO Error: " . $e->getMessage());
                }
            }

            return $table_column_value;
        }

		public function getTableRecords($table, $column, $value) {
            $con = $this->connect();
            $result = [];

            if (!empty($table)) {
                try {
                    if (!empty($column) && !empty($value)) {
                        $select_query = "SELECT * FROM {$table} WHERE {$column} = :value AND deleted = 0 ORDER BY id DESC";
                        $stmt = $con->prepare($select_query);
                        $stmt->bindParam(':value', $value, PDO::PARAM_STR);
                    } else {
                        $select_query = "SELECT * FROM {$table} WHERE deleted = 0 ORDER BY id DESC";
                        $stmt = $con->prepare($select_query);
                    }

                    $stmt->execute();
                    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

                } catch (PDOException $e) {
                    // Log or handle error
                    error_log("PDO Error in getTableRecords: " . $e->getMessage());
                }
            }

            return $result;
        }

		public function getQueryRecords($table, $select_query) {
			$con = $this->connect(); $list = array();
			if(!empty($select_query)) {
				$result = 0; $pdo = "";			
				$pdo = $con->prepare($select_query);
				$pdo->execute();	
				$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
				if(!empty($result)) {
					foreach($pdo->fetchAll() as $row) {
						if(!empty($row['category_id'])) {
							$category_name = "";
							$category_name = $this->getTableColumnValue($GLOBALS['category_table'], 'category_id', $row['category_id'], 'name');
							if(!empty($category_name)) {
								$row['category_name'] = $category_name;
							}
						}
						$list[] = $row;
					}
				}
			}

			return $list;
		}
		
		public function check_user_id_ip_address() {
            $con = $this->connect();
            $check_login_id = ""; $select_query = "";
            if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id']) && isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'])) {
                $select_query = "SELECT id FROM ".$GLOBALS['login_table']." WHERE type = :type AND user_id = :user_id AND ip_address = :ip_address 
                                    AND logout_date_time = '0000-00-00 00:00:00' ORDER BY id DESC LIMIT 1";
                if(!empty($select_query)) {
                    $result = 0; $pdo = "";			
                    $pdo = $con->prepare($select_query);
                    $pdo->bindParam(':type', $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_type'], PDO::PARAM_STR);
                    $pdo->bindParam(':user_id', $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'], PDO::PARAM_STR);
                    $pdo->bindParam(':ip_address', $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_ip_address'], PDO::PARAM_STR);
                    $pdo->execute();	
                    $result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
                    if(!empty($result)) {
                        foreach($pdo->fetchAll() as $row) {
                            if(!empty($row['id'])) {
                                $check_login_id = $row['id'];
                            }
                        }
                    }
                }
            }
            return $check_login_id;
        }
		
		public function checkUser() {
			$con = $this->connect();			
			$user_id = ""; $select_query = "";
			if(isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'])) {
				$user_id = $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'];				
				$today = date('Y-m-d');	

				$select_query = "SELECT user_id FROM ".$GLOBALS['login_table']." WHERE user_id = :user_id AND DATE(login_date_time) = :today ORDER BY id DESC LIMIT 1";
				if(!empty($select_query)) {
					$result = 0; $pdo = "";			
					$pdo = $con->prepare($select_query);
					$pdo->bindParam(':user_id', $user_id, PDO::PARAM_STR);
					$pdo->bindParam(':today', $today, PDO::PARAM_STR);
					$pdo->execute();	
					$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
					if(!empty($result)) {
						foreach($pdo->fetchAll() as $row) {
							if(!empty($row['user_id'])) {
								$login_user_id = $row['user_id'];
							}
						}
					}
				}
			}
			return $login_user_id;
		}

		public function getUserLoginList($current_date) {
			$con = $this->connect(); $select_query = ""; $login_list = array();
			if(!empty($current_date)) {
				$select_query = "SELECT * FROM ".$GLOBALS['login_table']." WHERE DATE(login_date_time) = :current_date ORDER BY id DESC";
			}
			else {
				$select_query = "SELECT * FROM ".$GLOBALS['login_table']." ORDER BY id DESC";
			}
			if(!empty($select_query)) {
				$result = 0; $pdo = "";			
				$pdo = $con->prepare($select_query);
				if(!empty($current_date)) {
					$pdo->bindParam(':current_date', $current_date, PDO::PARAM_STR);
				}
				$pdo->execute();	
				$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
				if(!empty($result)) {
					foreach($pdo->fetchAll() as $row) {
						$login_list[] = $row;
					}
				}
			}
			return $login_list;
        }

		public function getDailyReport($from_date, $to_date) {
            $log_list = array();  $list = array();
			$log_backup_file = "";

			$log_backup_file = "";
			$dirpath = $GLOBALS['log_backup_folder_name'];
			$dirpath .= "/*.csv";
			$csv_files = array();
			$csv_files = glob($dirpath);
			usort($csv_files, function($x, $y) {
				return filemtime($x) < filemtime($y);
			});
			$action_list = array();
			if(!empty($csv_files)) {
				for($i = 0; $i < count($csv_files); $i++) {
					if(!empty($csv_files[$i])) {
						$log_backup_file = $csv_files[$i];
						//echo $i.", log_backup_file - ".$log_backup_file."<br>";
						if(file_exists($log_backup_file)) {
							$myfile = fopen($log_backup_file, "r");
							while(!feof($myfile)) {
								$log = "";
								$log = fgetcsv($myfile);
								if(!empty($log)) {
									//$log = json_decode($log);
									$log_list[] = $log;
								}
							}
							fclose($myfile);
							//print_r($log_list);
							if(!empty($log_list)) {								
								foreach($log_list as $key => $row) {	
									if(!empty($key) && !empty($row)) {
										$success = 0; $action = "";
										foreach($row as $index => $value) {
											if(!empty($value) && $index == 1) {
												//echo "index - ".$index.", value - ".$value.", from_date - ".$from_date.", to_date - ".$to_date."<br>";
												if( ( strtotime(date("d-m-Y", strtotime($value))) >= strtotime($from_date) ) && ( strtotime(date("d-m-Y", strtotime($value))) <= strtotime($to_date) ) ) {
													$success = 1;									
												}
											}
											if(!empty($success) && $success == 1) {
												if($index == 6) {
													$action = $value;
												}
											}
										}	
										//echo "success - ".$success."<br><br>";
										if( (!empty($success) && $success == 1) && !in_array($action, $action_list) ) {
											$list[] = $row;
											$action_list[] = $action;
										}
									}
								}
							}
						}
					}
				}
			}	
			//print_r($list);
			//exit;
			return $list;
        }
		
		public function automate_number($table, $column) {
			$con = $this->connect();
			$select_query = ""; $unique_id = ""; $next_number = 1; $matches = array();
			
			$select_query = "SELECT ".$column." FROM ".$table." ORDER BY id DESC LIMIT 1";
			$result = 0; $pdo = "";			
			$pdo = $con->prepare($select_query);
			$pdo->execute();	
			$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
			if(!empty($result)) {
				foreach($pdo->fetchAll() as $row) {
					$last_number = $row[$column];
					if(!empty($last_number) && $last_number != $GLOBALS['null_value']) {
						$last_number = $this->encode_decode('decrypt', $last_number);
					}						
					if(!empty($last_number)) { break; }
				}
			}		
			if(!empty($last_number)) {				
				preg_match_all('/([0-9]+|[a-zA-Z]+)/',$last_number,$matches);				
				if(!empty($matches)) {
					$last_number = ""; $match = $matches[count($matches) - 1];
					if(!empty($match)) {
						$last_number = $match[count($match) - 1];
						if(preg_match("/^\d+$/", $last_number)) {
							$next_number = $last_number + 1;
						}
					}
				}
			}
			
			if(!empty($next_number)) {
				$year_prefix = date("Y");

				$already_billing = 0;
				if(!empty($year_prefix)) {
					foreach($matches as $match) {
						foreach($match as $val) {
							if(!empty($val) && $val == $year_prefix) {
								$already_billing = 1;
							}
						}
					}
					if(empty($already_billing) && $next_number > 1) { $next_number = 1; }
				}

				$bill_number_prefix = "";
				if(!empty($table)) {
					if($table == $GLOBALS['order_table']) { 
						$company_list = array();
						$company_list = $this->getTableRecords($GLOBALS['company_table'], '', '');
						if(!empty($company_list)) {
							foreach($company_list as $data) {
								if(!empty($data['order_prefix']) && $data['order_prefix'] != $GLOBALS['null_value']) {
									$bill_number_prefix = $this->encode_decode('decrypt', $data['order_prefix']);
								}
							}
						}
						if(empty($bill_number_prefix)) {
							$bill_number_prefix = "ENQ"; 
						}
					}
				}

				if($next_number < 10) {
					$next_number = "0".$next_number;
				}

				if(!empty($bill_number_prefix) && !empty($year_prefix)) {
					$next_number = $year_prefix.$bill_number_prefix.$next_number;
				}
			}
			
			return $next_number;
		}

		public function send_mobile_details($company_mobile_number, $number, $sms) {
			$res = true; $sms_link = "";
			if(!empty($company_mobile_number) && !empty($number) && !empty($sms)) {
				//$sms_link = "https://www.fast2sms.com/dev/bulkV2?authorization=VFxWy81QjDk3S2b6qo0JRNHaYCcZs4nmA5Xl7KMuGtwpTIPiUBV6LM5aSg7x84mfP2XyJtshdoFGEBrK&route=dlt&sender_id=SRISOF&message=126873&variables_values=".$msg."|&flash=0&numbers=".$mobile_number;
				$fields = array(
					"sender_id" => "SRISOF",
					"message" => $number,
					"variables_values" => $sms,
					"route" => "dlt",
					"numbers" => $company_mobile_number,
				);
				
				$curl = curl_init();
				
				curl_setopt_array($curl, array(
				  CURLOPT_URL => "https://www.fast2sms.com/dev/bulkV2",
				  CURLOPT_RETURNTRANSFER => true,
				  CURLOPT_ENCODING => "",
				  CURLOPT_MAXREDIRS => 10,
				  CURLOPT_TIMEOUT => 30,
				  CURLOPT_SSL_VERIFYHOST => 0,
				  CURLOPT_SSL_VERIFYPEER => 0,
				  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				  CURLOPT_CUSTOMREQUEST => "POST",
				  CURLOPT_POSTFIELDS => json_encode($fields),
				  CURLOPT_HTTPHEADER => array(
					"authorization: VFxWy81QjDk3S2b6qo0JRNHaYCcZs4nmA5Xl7KMuGtwpTIPiUBV6LM5aSg7x84mfP2XyJtshdoFGEBrK",
					"accept: */*",
					"cache-control: no-cache",
					"content-type: application/json"
				  ),
				));
				
				$response = curl_exec($curl);
				$err = curl_error($curl);
				
				curl_close($curl);
				
				/*if ($err) {
				  echo "cURL Error #:" . $err;
				} else {
				  echo $response;
				}*/
			}
			return $res;
		}

		/*function send_email_details($from, $to, $detail, $title) {	
			$msg = "";
			$headers  = 'MIME-Version: 1.0' . "\r\n";
			$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
			$headers .= "From: ".$from;
			if(!mail($to, $title, $detail, $headers)) {
				$msg = "unable to send your mail";
			}  
			return $msg;
		}*/

		public function send_whatsapp_details($number, $sms) {
			$res = true; $sms_link = "";
			if(!empty($number) && !empty($sms)) {
				$fields = array(
					"messaging_product" => "whatsapp",
					"to" => $number,
					"type" => "template",
					"template" => array('name' => 'hello_world', 'language' => array('code' => 'en_US'))
				);
				
				//$fields = '{ "messaging_product": "whatsapp", "to": "917010875814", "type": "template", "template": { "name": "hello_world", "language": { "code": "en_US" } } }';
				
				$curl = curl_init();
				
				curl_setopt_array($curl, array(
				  CURLOPT_URL => "https://graph.facebook.com/v14.0/107712945457945/messages",
				  CURLOPT_RETURNTRANSFER => true,
				  CURLOPT_ENCODING => "",
				  CURLOPT_MAXREDIRS => 10,
				  CURLOPT_TIMEOUT => 30,
				  CURLOPT_SSL_VERIFYHOST => 0,
				  CURLOPT_SSL_VERIFYPEER => 0,
				  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				  CURLOPT_CUSTOMREQUEST => "POST",
				  CURLOPT_POSTFIELDS => json_encode($fields),
				  CURLOPT_HTTPHEADER => array(
					"authorization: EAAQ4wSlt4d4BAHm1jKDipGzxwOi6H9KZB6gstP7OcS21ouZCOfTWoGXvHGH1XQtEZCYZBTfVOKMB3f3ZBZAsX6rWEaVDsmugQAENIIHPcknrDMFwnYLlapSQ73C9ZCWRwRDl2KCseM2E9ZCxWZB1x8gLZBRh9Q1e4PAWyZBf0IUzYA8c41YSCRJ5eDK2elw51H4uetTRicdc1FtRCelZCzJnhIOMUO8xctJzUjkZD",
					"accept: */*",
					"cache-control: no-cache",
					"content-type: application/json"
				  ),
				));
				
				$response = curl_exec($curl);
				echo "response - ".$response;
				$err = curl_error($curl);
				
				curl_close($curl);
			}
			return $res;
		}

		public function send_email_details($to_emails, $detail, $title) {
			require_once "PHPMailer/phpmailer.php";

			if ( isset($_SERVER["OS"]) && $_SERVER["OS"] == "Windows_NT" ) {
				$hostname = strtolower($_SERVER["COMPUTERNAME"]);
			} else {
				$hostname = `hostname`;
				$hostnamearray = explode('.', $hostname);
				$hostname = $hostnamearray[0];
			}

			$mail = new PHPMailer();
    
            $mail->SMTPDebug = 0;  // Enable verbose debug output
            //SMTP settings start
            $mail->isSMTP(); // Set mailer to use SMTP
            if ( strpos($hostname, 'cpnl') === FALSE ) //if not cPanel
				$mail->Host = 'relay-hosting.secureserver.net';
			else
				$mail->Host = 'localhost';
				
            $mail->SMTPAuth = false; // Enable SMTP authentication
            $mail->From = 'admin@prabhucrackers.com';
			$mail -> FromName = 'Order Form';
            if(!empty($to_emails)) {
				foreach($to_emails as $key => $to) {
					if(!empty($key)) {
						$mail->AddBCC($to);
					}
					if(empty($key)) {
						$mail->addAddress($to);
					}
				}
			}
			$mail->Subject = $title;
			$mail->Body = $detail;
	
			$mailresult = $mail->Send();
			$mailconversation = nl2br(htmlspecialchars(ob_get_clean())); //captures the output of PHPMailer and htmlizes it
            if ( $mailresult ) {
				$msg = "Successfully Mail send";
            }
            else {
                $msg = 'FAIL: ' . $mail->ErrorInfo . '<br />' . $mailconversation;
            }
			return $msg;
		}public function CheckOrderNotifcationToSend() {
			$con = $this->connect(); $list = array(); $notification_list = array(); $result = 0;
            
            $select_query = "SELECT order_id, customer_details, total_amount FROM ".$GLOBALS['order_table']." 
								WHERE push_notification = '0' AND deleted = '0' ORDER BY id ASC";
			if(!empty($select_query)) {
				$result = 0; $pdo = "";			
				$pdo = $con->prepare($select_query);
				$pdo->execute();	
				$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
				if(!empty($result)) {
					foreach($pdo->fetchAll() as $row) {
						$list[] = $row;
					}
				}
			}        
            if (!empty($list)) {
                foreach ($list as $data) {
                    if (!empty($data['order_id'])) {
                        $notification_id = $data['order_id'];
                        $notification_title = "New Enquiry Received.";
                        $notification_body = "";
                        $customer_name = "";
                        $customer_mobile_number = "";
        
                        if (!empty($data['customer_details'])) {
                            $customer_details = $this->encode_decode('decrypt', $data['customer_details']);
                            $customer_details = explode("<br>", $customer_details);
                            if (!empty($customer_details[0])) {
                                $customer_name = $customer_details[0];
                                if (!empty($customer_details[1])) {
                                    $customer_mobile_number = $customer_details[1];
                                }
                            }
                        }
        
                        if (!empty($customer_name) && !empty($customer_mobile_number) && !empty($data['total_amount'])) {
                            $notification_body = $customer_name . " - " . $customer_mobile_number . " - Rs." . number_format($data['total_amount'], 2);
                        }

						$select_fcm_id_query = ""; $fcm_id_user_list = array();
						$select_fcm_id_query = "SELECT GROUP_CONCAT(fcm_id) notification_fcm_ids FROM " . $GLOBALS['user_table'] . " 
													WHERE (fcm_id != 'NULL' AND fcm_id != '') AND deleted = '0'";
						if(!empty($select_fcm_id_query)) {
							$result = 0; $pdo = "";			
							$pdo = $con->prepare($select_fcm_id_query);
							$pdo->execute();	
							$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
							if(!empty($result)) {
								foreach($pdo->fetchAll() as $row) {
									$fcm_id_user_list[] = $row;
								}
							}
						}        
                        if (!empty($fcm_id_user_list)) {
                            foreach ($fcm_id_user_list as $row) {
                                if (!empty($row['notification_fcm_ids'])) {
                                    $notification_fcm_ids = $row['notification_fcm_ids'];
                                }
                            }
                        }
        
                        if (!empty($notification_fcm_ids)) {
                            $notification_fcm_ids = explode(",", $notification_fcm_ids);
                            $notification_list[] = array(
                                'notification_id' => $notification_id,
                                'title' => $notification_title,
                                'body' => $notification_body,
                                'fcm_ids' => $notification_fcm_ids
                            );
                        }
                    }
                }
            }
        
            if (!empty($notification_list)) {
                $result = count($notification_list);

                foreach ($notification_list as $data) {
                    if (!empty($data['notification_id']) && !empty($data['title']) && !empty($data['body']) && !empty($data['fcm_ids'])) {
                        $notification_id = $data['notification_id'];
                        $title = $data['title'];
                        $body = $data['body'];
                        $fcm_ids = $data['fcm_ids'];

						$path = dirname(__DIR__).'/API/send_order_notification.php'; $cleanPath = "";
						if (preg_match('~(.*public_html)/.*/API/(.*)$~', $path, $matches)) {
							$cleanPath = $matches[1] . "/API/" . $matches[2];
						}
						if(file_exists($cleanPath)) {
							require_once $cleanPath;

							$notification_obj = new Notification();

							$result = $notification_obj->SendOrderNotification($fcm_ids, $title, $body, $notification_id);

							if(!empty($result)) {
								$notification_result = $this->UpdateNotification($result ,$fcm_ids, $notification_id);
							}
						}
                    }
                }
            }
        
            return $result;
        }

		public function SendOrderNotification($registration_ids, $title, $body, $notification_id) {
			$curl = curl_init(); $msg = "";

			if(!empty($notification_id) && !empty($title) && !empty($registration_ids)) {
				$fields = array(
					"registration_ids" => $registration_ids,
					"notification"=> array('body' => $body, 'title' => $title,  "sound" => true),
					"data" => array('redirect'=> "notification", 'notification_id' => $notification_id )
				);
					
				curl_setopt_array($curl, array(
					CURLOPT_URL => "https://fcm.googleapis.com/fcm/send",
					CURLOPT_RETURNTRANSFER => true,
					CURLOPT_ENCODING => "",
					CURLOPT_MAXREDIRS => 10,
					CURLOPT_TIMEOUT => 30,
					CURLOPT_SSL_VERIFYHOST => 0,
					CURLOPT_SSL_VERIFYPEER => 0,
					CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
					CURLOPT_CUSTOMREQUEST => "POST",
					CURLOPT_POSTFIELDS => json_encode($fields),
					CURLOPT_HTTPHEADER => array(
					"authorization: key=AAAAO8iOCuU:APA91bG1sANatCRW68hjDXCrKlWiKgAb7rw8wZzedcFUCs1oWIBlgL2ij9uZ3eRpZZSMlm6xz5IRaZbq_giEn02NRsmMLVg_lNW5xUyifaM2Lsoi8lPcjOBlm3j1iue5fQbHg42tXx64",
					"accept: */*",
					"cache-control: no-cache",
					"content-type: application/json"
					),
				));

				$response = curl_exec($curl);
				curl_close($curl);

				//print_r($response);

				if(!empty($response)) {
					$response = json_decode($response);
					$failure_count = 0; $failed_registration_ids = array();
					foreach($response as $key => $value) {
						if($key == "failure") {
							$failure_count = $value; 
						}
						if($key == "failed_registration_ids") {
							$failed_registration_ids = $value; 
						}
					}
					if(!empty($registration_ids)) {
						$fcm_ids = $registration_ids;
						if(!empty($fcm_ids)) {
							$list = array();
							foreach($fcm_ids as $fcm_id) {
								if(!empty($fcm_id) && !in_array($fcm_id, $failed_registration_ids)) {
									$list[] = $fcm_id;
								}
							}
							$fcm_ids = $list;
							if(!empty($notification_id) && !empty($fcm_ids)) {
								$fcm_ids = implode(",", $fcm_ids); $insert_id = "";
								$columns = array('notification_id', 'fcm_ids', 'send_date_time', 'deleted');
								$values = array("'".$notification_id."'", "'".$fcm_ids."'", "'".date("Y-m-d H:i:00")."'", "'0'");
								$insert_id = $this->InsertSQL($GLOBALS['notification_table'], $columns, $values, '', '', '');
								if(preg_match("/^\d+$/", $insert_id)) {
									$order_unique_id = "";
									$order_unique_id = $this->getTableColumnValue($GLOBALS['order_table'], 'order_id', $notification_id, 'id');
									if(preg_match("/^\d+$/", $order_unique_id)) {										
										$columns = array(); $values = array();	$update_id = "";					
										$columns = array('push_notification');
										$values = array("'1'");
										$update_id = $this->UpdateSQL($GLOBALS['order_table'], $order_unique_id, $columns, $values, '');
									}
								}
							}
						}
					}
				}
			}
			return $msg;
		}

        public function UpdateNotification($response ,$registration_ids, $notification_id) {
            $response = json_decode($response);
            $failure_count = 0; $failed_registration_ids = array();
            foreach($response as $key => $value) {
                if($key == "failure") {
                    $failure_count = $value;
                }
                if($key == "failed_registration_ids") {
                    $failed_registration_ids = $value;
                }
            }
            if(!empty($registration_ids)) {
                $fcm_ids = $registration_ids;
                if(!empty($fcm_ids)) {
                    $list = array();
                    foreach($fcm_ids as $fcm_id) {
                        if(!empty($fcm_id) && !in_array($fcm_id, $failed_registration_ids)) {
                            $list[] = $fcm_id;
                        }
                    }
                    $fcm_ids = $list;
                    if(!empty($notification_id) && !empty($fcm_ids)) {
                        $fcm_ids = implode(",", $fcm_ids); $insert_id = "";
                        $columns = array('notification_id', 'fcm_ids', 'send_date_time', 'deleted');
                        $values = array("'".$notification_id."'", "'".$fcm_ids."'", "'".date("Y-m-d H:i:00")."'", "'0'");
                        $insert_id = $this->InsertSQL($GLOBALS['notification_table'], $columns, $values, '', '', '');
                        if(preg_match("/^\d+$/", $insert_id)) {
                            $order_unique_id = "";
                            $order_unique_id = $this->getTableColumnValue($GLOBALS['order_table'], 'order_id', $notification_id, 'id');
                            if(preg_match("/^\d+$/", $order_unique_id)) {                         
                                $columns = array(); $values = array();    $update_id = "";                    
                                $columns = array('push_notification');
                                $values = array("'1'");
                                $update_id = $this->UpdateSQL($GLOBALS['order_table'], $order_unique_id, $columns, $values, '');
                            }
                        }
                    }
                }
            }
        }

		public function daily_db_backup() {
			$con = $this->connect();
			$backupAlert = 0; $backup_file = ""; $path = $GLOBALS['backup_folder_name']."/"; $file_name = ""; $dbname = $this->db_name;
			$tables = array();
			
			$select_query = "SHOW TABLES";
			$result = 0; $pdo = "";			
			$pdo = $con->prepare($select_query);
			$pdo->execute();	
			$result = $pdo->fetchAll(PDO::FETCH_COLUMN); 
			if(!empty($result)) {
				foreach($result as $table_name) {
					if(!empty($table_name)) {
						$tables[] = $table_name;
					}
				}
			}

			$output = '';
			if(!empty($tables)) {
				foreach($tables as $table) {
					if (strpos($table, $GLOBALS['table_prefix']) !== false) {
						$show_table_query = "SHOW CREATE TABLE " . $table . "";
						$statement = $con->prepare($show_table_query);
						$statement->execute();
						$show_table_result = $statement->fetchAll();

						foreach($show_table_result as $show_table_row) {
							$output .= "\n\n" . $show_table_row["Create Table"] . ";\n\n";
						}
						$select_query = "SELECT * FROM " . $table . "";
						$statement = $con->prepare($select_query);
						$statement->execute();
						$total_row = $statement->rowCount();
						for($count=0; $count<$total_row; $count++) {
							$single_result = $statement->fetch(\PDO::FETCH_ASSOC);
							$table_column_array = array_keys($single_result);
							$table_value_array = array_values($single_result);
							$output .= "\nINSERT INTO $table (";
							$output .= "" . implode(", ", $table_column_array) . ") VALUES (";
							$output .= "'" . implode("','", $table_value_array) . "');\n";
						}
					}	
				}
			}

			if(!empty($output)) {
				if(empty($file_name)) {
					$file_name = $dbname.'.sql';
				}
				$backup_file = $path.$file_name;
				file_put_contents($backup_file, $output);
				if(file_exists($backup_file)) {
					$backupAlert = 1;
				}
			}

			$msg = "";
			if(!empty($backupAlert) && $backupAlert == 1) {
				$msg = $backup_file;
			}
			else {
				$msg = $backupAlert;
			}
			return $msg;
		}

		public function image_directory() {
			$target_dir = "../images/upload/";
			return $target_dir;
		}
		public function temp_image_directory() {
			$temp_dir = "../images/temp/";
			return $temp_dir;
		}
		public function clear_temp_image_directory() {
			$temp_dir = "../images/temp/";
			
			$files = glob($temp_dir.'*'); // get all file names
			foreach($files as $file){ // iterate files
			  if(is_file($file))
				unlink($file); // delete file
			}
			
			return true;
		}

    public function UpdateOTPCount() {
        $count = 0;
        $unique_id = ""; $otp_count = 1; $updated = "";
        $unique_id = $this->getTableColumnValue($GLOBALS['settings_private_table'], 'name', 'otp_count', 'id');
        if(preg_match("/^\d+$/", $unique_id)) {
            $otp_count = $this->getTableColumnValue($GLOBALS['settings_private_table'], 'name', 'otp_count', 'value');
            if(preg_match("/^\d+$/", $otp_count)) {
                $otp_count = $otp_count + 1;
                $columns = array('value');
                $values = array("'".$otp_count."'");
                $updated = $this->UpdateSQL($GLOBALS['settings_private_table'], $unique_id, $columns, $values, '');
                if(preg_match("/^\d+$/", $updated)) {
                    $count = $otp_count;
                }
            }
        }
        else {
            $columns = array('name', 'value', 'deleted');
            $values = array("'otp_count'", "'".$otp_count."'", "'0'");
            $unique_id = $this->InsertSQL($GLOBALS['settings_private_table'], $columns, $values, '');
            if(preg_match("/^\d+$/", $unique_id)) {
                $count = $otp_count;
            }
        }
        return $count;
    }
    public function UpdateResendOTPCount() {
        $count = 0;
        $unique_id = ""; $resend_otp_count = 1; $updated = "";
        $unique_id = $this->getTableColumnValue($GLOBALS['settings_private_table'], 'name', 'resend_otp_count', 'id');
        if(preg_match("/^\d+$/", $unique_id)) {
            $resend_otp_count = $this->getTableColumnValue($GLOBALS['settings_private_table'], 'name', 'resend_otp_count', 'value');
            if(preg_match("/^\d+$/", $resend_otp_count)) {
                $resend_otp_count = $resend_otp_count + 1;
                $columns = array('value');
                $values = array("'".$resend_otp_count."'");
                $updated = $this->UpdateSQL($GLOBALS['settings_private_table'], $unique_id, $columns, $values, '');
                if(preg_match("/^\d+$/", $updated)) {
                    $count = $resend_otp_count;
                }
            }
        }
        else {
            $columns = array('name', 'value', 'deleted');
            $values = array("'resend_otp_count'", "'".$resend_otp_count."'", "'0'");
            $unique_id = $this->InsertSQL($GLOBALS['settings_private_table'], $columns, $values, '');
            if(preg_match("/^\d+$/", $unique_id)) {
                $count = $resend_otp_count;
            }
        }
        return $count;
    }
    public function UpdateOrderSMSCount() {
        $count = 0;
        $unique_id = ""; $order_sms_count = 1; $updated = "";
        $unique_id = $this->getTableColumnValue($GLOBALS['settings_private_table'], 'name', 'order_sms_count', 'id');
        if(preg_match("/^\d+$/", $unique_id)) {
            $order_sms_count = $this->getTableColumnValue($GLOBALS['settings_private_table'], 'name', 'order_sms_count', 'value');
            if(preg_match("/^\d+$/", $order_sms_count)) {
                $order_sms_count = $order_sms_count + 1;
                $columns = array('value');
                $values = array("'".$order_sms_count."'");
                $updated = $this->UpdateSQL($GLOBALS['settings_private_table'], $unique_id, $columns, $values, '');
                if(preg_match("/^\d+$/", $updated)) {
                    $count = $order_sms_count;
                }
            }
        }
        else {
            $columns = array('name', 'value', 'deleted');
            $values = array("'order_sms_count'", "'".$order_sms_count."'", "'0'");
            $unique_id = $this->InsertSQL($GLOBALS['settings_private_table'], $columns, $values, '');
            if(preg_match("/^\d+$/", $unique_id)) {
                $count = $order_sms_count;
            }
        }
        return $count;
    }

		public function CheckIPAlreadyExist($ip_address) {
			$con = $this->connect(); $login_count = 0; $select_query = "";
			if(!empty($ip_address)) {
				$select_query = "SELECT COUNT(id) as login_count FROM ".$GLOBALS['login_table']." WHERE ip_address = :ip_address";
				if(!empty($select_query)) {
					$result = 0; $pdo = "";			
					$pdo = $con->prepare($select_query);
					$pdo->bindParam(':ip_address', $ip_address, PDO::PARAM_STR);
					$pdo->execute();	
					$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
					if(!empty($result)) {
						foreach($pdo->fetchAll() as $row) {
							if(!empty($row['login_count'])) {
								$login_count = $row['login_count'];
							}
						}
					}
				}
			}
			return $login_count;
		}

		public function CheckOTPLoginExpiryTime($ip_address, $mobile_number) {
			$con = $this->connect(); $expired = ""; $current_date = date("Y-m-d");
			if(!empty($ip_address) && !empty($mobile_number)) {
				$login_count = 0;
				$login_count = $this->CheckIPAlreadyExist($ip_address);
				if(empty($login_count)) {
					$select_query = "SELECT id FROM ".$GLOBALS['otp_send_phone_numbers_table']." WHERE phone_number = :phone_number 
										AND DATE(send_date_time) = :current_date AND otp_send_count = '5' AND deleted = '0'";
					if(!empty($select_query)) {
						$result = 0; $pdo = "";			
						$pdo = $con->prepare($select_query);
						$pdo->bindParam(':phone_number', $mobile_number, PDO::PARAM_STR);
						$pdo->bindParam(':current_date', $current_date, PDO::PARAM_STR);
						$pdo->execute();	
						$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
						if(!empty($result)) {
							foreach($pdo->fetchAll() as $row) {
								if(!empty($row['id'])) {
									$expired = $row['id'];
								}
							}
						}
					}
				}
			}
			return $expired;
		}

		public function CheckLoginBlock() {
			$con = $this->connect(); $attempt_count = 0;
			$select_query = "SELECT * FROM ".$GLOBALS['settings_private_table']." WHERE name LIKE '%loginblock%'";
			if(!empty($select_query)) {
				$result = 0; $pdo = "";			
				$pdo = $con->prepare($select_query);
				$pdo->execute();	
				$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
				if(!empty($result)) {
					foreach($pdo->fetchAll() as $row) {
						if(!empty($row['deleted']) && $row['deleted'] == 1) {
							if(!empty($row['value'])) {
								$attempt_count = $row['value'];
							}
						}
					}
				}
			}
			return $attempt_count;
		}

		public function LoginBlock($ip_address) {
			$con = $this->connect(); $updated = ""; $attempt_count = 0; $list = array(); $unique_id = ""; $login_block_details = ""; 
			$attempt_date_time = $GLOBALS['create_date_time_label'];
			if(!empty($ip_address)) {
				$select_query = "SELECT * FROM ".$GLOBALS['settings_private_table']." WHERE name LIKE '%loginblock%' AND deleted = '0'";
				if(!empty($select_query)) {
					$result = 0; $pdo = "";			
					$pdo = $con->prepare($select_query);
					$pdo->execute();	
					$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
					if(!empty($result)) {
						foreach($pdo->fetchAll() as $row) {
							if(!empty($row['id'])) {
								$unique_id = $row['id'];
							}
							if(!empty($row['name'])) {
								$login_block_details = $row['name'];
							}
							if(!empty($row['value'])) {
								$attempt_count = $row['value'];
							}
						}
					}
				}
				if(preg_match("/^\d+$/", $unique_id)) {
					$prev_attempt_date_time = array(); $prev_ip = array(); $start_date_time = ""; $end_date_time = "";
					if(!empty($login_block_details)) {
						$login_block_details = explode("_", $login_block_details);
						if(!empty($login_block_details['1'])) {
							$prev_attempt_date_time = explode(",", $login_block_details['1']);
							if(!empty($prev_attempt_date_time)) {
								$prev_attempt_date_time[count($prev_attempt_date_time)] = $attempt_date_time;
							}
							if(count($prev_attempt_date_time) == 6) {
								$start_date_time = $prev_attempt_date_time['0'];
								$end_date_time = $prev_attempt_date_time['5'];
							}
							$prev_attempt_date_time = implode(",", $prev_attempt_date_time);
						}
						if(!empty($login_block_details['2'])) {
							$prev_ip = explode(",", $login_block_details['2']);
							if(!empty($prev_ip)) {
								$prev_ip[count($prev_ip)] = $ip_address;
							}
							$prev_ip = implode(",", $prev_ip);
						}
					}
					$login_block_details = "loginblock_".$prev_attempt_date_time."_".$prev_ip;
					$attempt_count = $attempt_count + 1;
					if($attempt_count <= 5) {
						$columns = array('name', 'value');
						$values = array("'".$login_block_details."'", "'".$attempt_count."'");
						$updated = $this->UpdateSQL($GLOBALS['settings_private_table'], $unique_id, $columns, $values, '');
					}
					else {
						if(!empty($start_date_time) && !empty($end_date_time)) {
							$minutes = 0;
							$minutes = (strtotime($end_date_time) - strtotime($start_date_time)) / 60;
							//echo "minutes - ".$minutes."<br>";
							if(!empty($minutes) && $minutes < 60) {
								$columns = array('deleted');
								$values = array("'1'");
								$updated = $this->UpdateSQL($GLOBALS['settings_private_table'], $unique_id, $columns, $values, '');
							}
						}	
					}
				}	
				else {
					$attempt = array($attempt_date_time);
					$attempt = implode(",", $attempt);

					$ip = array($ip_address);
					$ip = implode(",", $ip);

					$login_block_details = "loginblock_".$attempt."_".$ip;
					$columns = array('name', 'value', 'deleted');
					$values = array("'".$login_block_details."'", "'1'", "'0'");						
					$updated = $this->InsertSQL($GLOBALS['settings_private_table'], $columns, $values, '');
					if(preg_match("/^\d+$/", $updated)) {
						$attempt_count = 1;
					}
				}
			}
			return $attempt_count;
		}

		public function ReverseLoginBlock($ip_address) {
			$attempt_count = 0; $unique_id = "";
			if(!empty($ip_address)) {
				$select_query = "SELECT * FROM ".$GLOBALS['settings_private_table']." WHERE name LIKE '%loginblock%'";
				if(!empty($select_query)) {
					$result = 0; $pdo = "";			
					$pdo = $con->prepare($select_query);
					$pdo->execute();	
					$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
					if(!empty($result)) {
						foreach($pdo->fetchAll() as $row) {
							if(!empty($row['id'])) {
								$unique_id = $row['id'];
							}
							if(!empty($row['name'])) {
								$login_block_details = $row['name'];
							}
						}
					}
				}
				if(!empty($login_block_details)) {
					$login_block_details = explode("_", $login_block_details);
					if(!empty($login_block_details['1'])) {
						$prev_attempt_date_time = explode(",", $login_block_details['1']);
						$start_date_time = $prev_attempt_date_time['4'];
						$end_date_time = $GLOBALS['create_date_time_label'];
					}
					//echo "start_date_time - ".$start_date_time.", end_date_time - ".$end_date_time."<br>";
					if(!empty($start_date_time) && !empty($end_date_time)) {
						$minutes = 0;
						$minutes = (strtotime($end_date_time) - strtotime($start_date_time)) / 60;
						//echo "minutes - ".$minutes."<br>";
						if(!empty($minutes) && $minutes > 60) {
							$attempt_count = 1;
							$attempt = array($GLOBALS['create_date_time_label']);
							$attempt = implode(",", $attempt);

							$ip = array($ip_address);
							$ip = implode(",", $ip);

							$login_block_details = "loginblock_".$attempt."_".$ip;
							$columns = array('name', 'value', 'deleted');
							$values = array("'".$login_block_details."'", "'".$attempt_count."'", "'0'");
							$updated = $this->UpdateSQL($GLOBALS['settings_private_table'], $unique_id, $columns, $values, '');
						}
						else {
							$attempt_count = 5;
						}
					}
				}
			}	
			return $attempt_count;
		}

				public function CheckCustomerOrderCount($order_date, $customer_id, $ip_address, $otp_number, $total_amount) {
			$orders_count = 0; $where = ""; $list = array();
			if(!empty($order_date)) {
				$order_date = date("Y-m-d", strtotime($order_date));
				$where = "DATE(order_date) = '".$order_date."'";
			}
			/*if(!empty($customer_id)) {
				if(!empty($where)) {
					$where = $where." AND customer_id = '".$customer_id."'";
				}
				else {
					$where = "customer_id = '".$customer_id."'";
				}
			}*/
			if(!empty($ip_address)) {
				if(!empty($where)) {
					$where = $where." AND ip_address = '".$ip_address."'";
				}
				else {
					$where = "ip_address = '".$ip_address."'";
				}
			}
			/*if(!empty($otp_number)) {
				if(!empty($where)) {
					$where = $where." AND otp_number = '".$otp_number."'";
				}
				else {
					$where = "otp_number = '".$otp_number."'";
				}
			}
			if(!empty($total_amount)) {
				if(!empty($where)) {
					$where = $where." AND total_amount = '".$total_amount."'";
				}
				else {
					$where = "total_amount = '".$total_amount."'";
				}
			}*/
			if(!empty($where)) {
				$select_query = "SELECT COUNT(id) as orders_count FROM ".$GLOBALS['order_table']." WHERE ".$where." AND deleted = '0'";
				$list = $this->getQueryRecords($GLOBALS['order_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['orders_count'])) {
							$orders_count = $data['orders_count'];
						}
					}
				}
			}
			return $orders_count;
		}

		public function getRamdomCodeOrderCount($random_code) {
			$orders_count = 0;
			$select_query = "SELECT COUNT(id) as orders_count FROM ".$GLOBALS['order_table']." WHERE random_code = '".$random_code."'";
			$list = $this->getQueryRecords($GLOBALS['order_table'], $select_query);
			if(!empty($list)) {
				foreach($list as $data) {
					if(!empty($data['orders_count'])) {
						$orders_count = $data['orders_count'];
					}
				}
			}
			return $orders_count;
		}
		public function CheckIPBlocked($ip_address) {
			$blocked = 0;
			if(!empty($ip_address)) {
				$select_query = "SELECT id FROM ".$GLOBALS['order_validation_table']." WHERE ip_address = '".$ip_address."' AND blocked = '1'";
				$list = $this->getQueryRecords($GLOBALS['order_validation_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['id'])) {
							$blocked = 1;
						}
					}
				}
			}
			return $blocked;
		}

		public function CheckCalculationMatch($random_code, $calculate_value, $calculate_total) {
			$match = 0;
			$select_query = "SELECT id FROM ".$GLOBALS['order_validation_table']." WHERE random_code = '".$random_code."'
								AND calculate_value = '".$calculate_value."' AND calculate_total = '".$calculate_total."'";
			$list = $this->getQueryRecords($GLOBALS['order_validation_table'], $select_query);
			if(!empty($list)) {
				foreach($list as $data) {
					if(!empty($data['id'])) {
						$match = 1;
					}
				}
			}
			return $match;
		}

		public function getIPAddressOTPOrderCount($ip_address, $otp_verification, $order_date) {
			$con = $this->connect(); $ip_block = 0; $select_query = ""; $list = array(); $first_order_date_time = ""; $last_order_date_time = ""; $process_count = 0;

			if (!empty($otp_verification)) {
				if (!empty($ip_address)) {
					// For a specific IP
					if ($otp_verification == 1) {
						$select_query = "SELECT MIN(send_date_time) AS first_order_date_time, MAX(send_date_time) AS last_order_date_time, COUNT(id) AS process_count
											FROM ".$GLOBALS['otp_send_phone_numbers_table']." WHERE ip_address = :ip_address AND DATE(send_date_time) = :order_date";
					} 
					else if ($otp_verification == 2) {
						$select_query = "SELECT MIN(created_date_time) AS first_order_date_time, MAX(created_date_time) AS last_order_date_time,
											COUNT(id) AS process_count FROM ".$GLOBALS['order_table']." WHERE ip_address = :ip_address 
											AND DATE(created_date_time) = :order_date";
					}
				} 
				else {	
					if ($otp_verification == 1) {
						$select_query = "SELECT MIN(send_date_time) AS first_order_date_time, MAX(send_date_time) AS last_order_date_time, COUNT(id) AS process_count
											FROM ".$GLOBALS['otp_send_phone_numbers_table']." WHERE DATE(send_date_time) = :order_date";
					} 
					else if ($otp_verification == 2) {
						$select_query = "SELECT MIN(created_date_time) AS first_order_date_time, MAX(created_date_time) AS last_order_date_time,
											COUNT(id) AS process_count FROM ".$GLOBALS['order_table']." WHERE DATE(created_date_time) = :order_date";
					}
				}
				// Run query
				//echo $select_query;
				if(!empty($select_query)) {
					$result = 0; $pdo = "";			
					$pdo = $con->prepare($select_query);
					$pdo->bindParam(':order_date', $order_date, PDO::PARAM_STR);
					if(!empty($ip_address)) {
						$pdo->bindParam(':ip_address', $ip_address, PDO::PARAM_STR);
					}
					$pdo->execute();	
					$result = $pdo->setFetchMode(PDO::FETCH_ASSOC);
					if(!empty($result)) {
						foreach($pdo->fetchAll() as $row) {
							$list[] = $row;
						}
					}
				}
			}

			// Extract results
			if (!empty($list)) {
				foreach ($list as $data) {
					if (!empty($data['first_order_date_time'])) {
						$first_order_date_time = $data['first_order_date_time'];
					}
					if (!empty($data['last_order_date_time'])) {
						$last_order_date_time = $data['last_order_date_time'];
					}
					if (!empty($data['process_count'])) {
						$process_count = (int)$data['process_count'];
					}
				}
			}
			
			// Calculate seconds difference
			$order_seconds = 0;
			if (!empty($first_order_date_time) && !empty($last_order_date_time)) {
				//echo "ip_address - ".$ip_address.", start_date_time - ".$first_order_date_time.", end_date_time - ".$last_order_date_time."<br>";
				$start_date_time = strtotime($first_order_date_time);
				$end_date_time   = strtotime($last_order_date_time);
				$order_seconds   = $end_date_time - $start_date_time;
			}

			//echo "order_seconds - ".$order_seconds;

			// Apply blocking rules
			if ($process_count > 3 && !empty($ip_address)) {
				if ($order_seconds < 60) {
					$ip_block = 1;
				}
			}
			else if ($process_count > 50) {
				if ($order_seconds < 3600) {
					$ip_block = 1;
				}
			}

			return $ip_block;
		}

		public function CheckIPOrderSeconds($order_date, $ip_address) {
			$order_seconds = 0; $order_times = array(); $where = ""; $list = array();
			if(!empty($order_date)) {
				$order_date = date("Y-m-d", strtotime($order_date));
				$where = "DATE(send_date_time) = '".$order_date."'";
			}
			if(!empty($ip_address)) {
				if(!empty($where)) {
					$where = $where." AND ip_address = '".$ip_address."'";
				}
				else {
					$where = "ip_address = '".$ip_address."'";
				}
			}
			if(!empty($where)) {
				$select_query = "SELECT send_date_time FROM ".$GLOBALS['otp_send_phone_numbers_table']." WHERE ".$where." AND deleted = '0' ORDER BY id DESC LIMIT 3";
				//echo $select_query."<br>";
				$list = $this->getQueryRecords($GLOBALS['otp_send_phone_numbers_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['send_date_time'])) {
							$order_times[] = $data['send_date_time'];
						}
					}
				}
				if(!empty($order_times) && count($order_times) > 1) {
					usort($order_times, function($a, $b) {
						return $a <=> $b; // spaceship operator
					});
					//echo "OTP times <br>";
					//print_r($order_times); echo "<br>";
					$start_date_time = ""; $end_date_time = "";
					if(!empty($order_times['0'])) { $start_date_time = $order_times['0']; }
					//if(!empty($order_times[count($order_times) - 1])) { $end_date_time = $order_times[count($order_times) - 1]; }
					$end_date_time = $GLOBALS['create_date_time_label'];
					if(!empty($start_date_time) && !empty($end_date_time)) {
						//echo "start_date_time - ".$start_date_time.", end_date_time - ".$end_date_time."<br>";
						$start_date_time = strtotime($start_date_time);
						$end_date_time   = strtotime($end_date_time);
						$order_seconds = $end_date_time - $start_date_time;
						//echo "order_seconds - ".$order_seconds;
					}
				}
			}

			if(empty($order_seconds) || $order_seconds > 60) {
				$where = "";
				if(!empty($order_date)) {
					$order_date = date("Y-m-d", strtotime($order_date));
					$where = "DATE(order_date) = '".$order_date."'";
				}
				if(!empty($ip_address)) {
					if(!empty($where)) {
						$where = $where." AND ip_address = '".$ip_address."'";
					}
					else {
						$where = "ip_address = '".$ip_address."'";
					}
				}
				if(!empty($where)) {
					$select_query = "SELECT created_date_time FROM ".$GLOBALS['order_table']." WHERE ".$where." AND deleted = '0' ORDER BY id DESC LIMIT 3";
					//echo $select_query."<br>";
					$list = $this->getQueryRecords($GLOBALS['order_table'], $select_query);
					if(!empty($list)) {
						foreach($list as $data) {
							if(!empty($data['created_date_time'])) {
								$order_times[] = $data['created_date_time'];
							}
						}
					}
					if(!empty($order_times) && count($order_times) > 1) {
						usort($order_times, function($a, $b) {
							return $a <=> $b; // spaceship operator
						});
						//print_r($order_times); echo "<br>";
						$start_date_time = ""; $end_date_time = "";
						if(!empty($order_times['0'])) { $start_date_time = $order_times['0']; }
						//if(!empty($order_times[count($order_times) - 1])) { $end_date_time = $order_times[count($order_times) - 1]; }
						$end_date_time = $GLOBALS['create_date_time_label'];
						if(!empty($start_date_time) && !empty($end_date_time)) {
							$start_date_time = strtotime($start_date_time);
							$end_date_time   = strtotime($end_date_time);
							$order_seconds = $end_date_time - $start_date_time;
						}
					}
				}
			}
			return $order_seconds;
		}

	}	
?>