<?php
	include("include.php");
	
	if(isset($_REQUEST['show_promotion_code_id'])) {
        $show_promotion_code_id = $_REQUEST['show_promotion_code_id'];

        $name = ""; $price = 0; $expiry_date = ""; $minimum_order_amount = 0; $discount_upto_value = 0;
        if(!empty($show_promotion_code_id)) {
            $promotion_code_list = array();
			$promotion_code_list = $obj->getTableRecords($GLOBALS['promotion_code_table'], 'promotion_code_id', $show_promotion_code_id);
            if(!empty($promotion_code_list)) {
                foreach($promotion_code_list as $data) {
                    if(!empty($data['name'])) {
                        $name = $obj->encode_decode('decrypt', $data['name']);
						$name = str_replace("$", "''", $name);
					}
                    if(!empty($data['price'])) {
                        $price = $data['price'];
					}
                    if(!empty($data['expiry_date']) && $data['expiry_date'] != "0000-00-00") {
                        $expiry_date = date("d-m-Y", strtotime($data['expiry_date']));
					}
                    if(!empty($data['minimum_order_amount'])) {
                        $minimum_order_amount = $data['minimum_order_amount'];
					}
                    if(!empty($data['discount_upto_value'])) {
                        $discount_upto_value = $data['discount_upto_value'];
					}
                }
            }
		} ?>
		
        <form class="py-4 poppins pd-20 col-xl-6 mx-auto" name="promotion_code_form" method="POST">
            <div class="row">
                <input type="hidden" name="edit_id" value="<?php if(!empty($show_promotion_code_id)) { echo $show_promotion_code_id; } ?>">
                <div class="form-group col-12">
                    <div class="form-label-group in-border mb-0">
                        <input type="text" name="name" value="<?php if(!empty($name)) { echo $name; } ?>" class="form-control shadow-none" placeholder="Name">
                        <label>Name (*)</label>
                    </div>
                </div>
                <div class="col-12">
                    <div class="row">
                        <div class="form-group col-sm-6">
                            <div class="form-label-group in-border mb-0">
                                <input type="text" name="price" value="<?php if(!empty($price)) { echo $price; } ?>" class="form-control shadow-none" placeholder="Price">
                                <label>Price (*)</label>
                            </div>
                        </div>
                        <div class="form-group col-sm-6">
                            <div class="form-label-group in-border mb-0">
                                <input type="text" name="expiry_date" value="<?php if(!empty($expiry_date)) { echo $expiry_date; } ?>" class="form-control date_field shadow-none" placeholder="Expiry Date">
                                <label>Expiry Date(*)</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12">
                    <div class="row">
                        <div class="form-group col-sm-6">
                            <div class="form-label-group in-border mb-0">
                                <input type="text" name="minimum_order_amount" value="<?php if(!empty($minimum_order_amount)) { echo $minimum_order_amount; } ?>" class="form-control shadow-none" placeholder="Min.Order Amount">
                                <label>Min.Order Amount (*)</label>
                            </div>
                        </div>
                        <div class="form-group col-sm-6">
                            <div class="form-label-group in-border mb-0">
                                <input type="text" name="discount_upto_value" value="<?php if(!empty($discount_upto_value)) { echo $discount_upto_value; } ?>" class="form-control shadow-none" placeholder="Discount Upto Value">
                                <label>Discount Upto Value (*)</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12 pt-3 text-center">
                    <button class="btn btn-primary btnwidth submit_button" type="button" onClick="Javascript:SaveModalContent('promotion_code_form', 'promotion_code_changes.php', 'promotion_code.php');">Submit</button>
                </div>
            </div>
            <script type="text/javascript">
            jQuery(document).ready(function(){
                if(jQuery('.date_field').length > 0) {
                jQuery('.date_field').datepicker({
                    format: "dd-mm-yyyy",
                    autoclose: true,
                    startDate: "today"
                });
                }
            });    
            </script>
        </form>
<?php        
    }

    if(isset($_POST['name'])) {	
		$name = ""; $name_error = ""; $price = 0; $price_error = ""; $expiry_date = ""; $expiry_date_error = ""; $minimum_order_amount = 0;
        $minimum_order_amount_error = ""; $discount_upto_value = 0; $discount_upto_value_error = "";
		$valid_promotion_code = ""; $form_name = "promotion_code_form";
	
        $name = $_POST['name'];
		$name = $valid->clean_value($name);
        $name_error = $valid->common_validation($name, "name", "text");
		if(!empty($name_error)) {
			$valid_promotion_code = $valid->error_display($form_name, "name", $name_error, 'text');			
		}

        $price = $_POST['price'];
        $price = trim($price);
        $check_price = $price;
        if(!empty($check_price)) {
            $check_price = str_replace("%", "", $check_price);
        }
		$price_error = $valid->valid_price($check_price, "Price", "1");
		if(!empty($price_error)) {
			if(!empty($valid_promotion_code)) {
				$valid_promotion_code = $valid_promotion_code." ".$valid->error_display($form_name, "price", $price_error, 'text');
			}
			else {
				$valid_promotion_code = $valid->error_display($form_name, "price", $price_error, 'text');
			}
		}

        $expiry_date = $_POST['expiry_date'];
		$expiry_date_error = $valid->valid_date($expiry_date, "expiry date", "1");
		if(!empty($expiry_date_error)) {
			if(!empty($valid_promotion_code)) {
				$valid_promotion_code = $valid_promotion_code." ".$valid->error_display($form_name, "expiry_date", $expiry_date_error, 'text');
			}
			else {
				$valid_promotion_code = $valid->error_display($form_name, "expiry_date", $expiry_date_error, 'text');
			}
		}

        $minimum_order_amount = $_POST['minimum_order_amount'];
		$minimum_order_amount_error = $valid->valid_price($minimum_order_amount, "Min.order amount", "1");
		if(!empty($minimum_order_amount_error)) {
			if(!empty($valid_promotion_code)) {
				$valid_promotion_code = $valid_promotion_code." ".$valid->error_display($form_name, "minimum_order_amount", $minimum_order_amount_error, 'text');
			}
			else {
				$valid_promotion_code = $valid->error_display($form_name, "minimum_order_amount", $minimum_order_amount_error, 'text');
			}
		}


        if(!empty($price)) {
            if(strpos($price, '%') !== false) {
                $discount_upto_value = $_POST['discount_upto_value'];
                $discount_upto_value_error = $valid->valid_price($discount_upto_value, "Discount upto value", "1");
                if(!empty($discount_upto_value_error)) {
                    if(!empty($valid_promotion_code)) {
                        $valid_promotion_code = $valid_promotion_code." ".$valid->error_display($form_name, "discount_upto_value", $discount_upto_value_error, 'text');
                    }
                    else {
                        $valid_promotion_code = $valid->error_display($form_name, "discount_upto_value", $discount_upto_value_error, 'text');
                    }
                }
            }
        }

		if(isset($_POST['edit_id'])) {
			$edit_id = $_POST['edit_id'];
		}
		
		$result = "";
		
		if(empty($valid_promotion_code)) {
			$check_user_id_ip_address = "";
			$check_user_id_ip_address = $obj->check_user_id_ip_address();	
			if(preg_match("/^\d+$/", $check_user_id_ip_address)) {
				
                $lower_case_name = "";
				if(!empty($name)) {
                    $lower_case_name = $obj->encode_decode('encrypt', strtolower($name));
					$name = $obj->encode_decode('encrypt', $name);
				}

                if(!empty($expiry_date)) {
                    $expiry_date = date("Y-m-d", strtotime($expiry_date));
                }
                
				$prev_promotion_code_id = ""; $columns = array(); $values = array(); $check_promotion_codes = array(); $promotion_code_error = "";			
				if(!empty($name)) {
					$check_promotion_codes = $obj->getTableRecords($GLOBALS['promotion_code_table'], 'lower_case_name', $name);
					if(!empty($check_promotion_codes)) {
						foreach($check_promotion_codes as $data) {
							if(!empty($data['lower_case_name']) && $data['lower_case_name'] == $lower_case_name) {
								$prev_promotion_code_id = $data['promotion_code_id'];
							}
							if(!empty($prev_promotion_code_id)) {
                                $promotion_code_error = "This promotion_code is already exist";
								break;
							}
						}
					}
                }
				
				if(empty($edit_id)) {
					if(empty($prev_promotion_code_id)) {
						$created_date_time = $GLOBALS['create_date_time_label']; $creator = $GLOBALS['creator'];
                        $creator_name = $obj->encode_decode('encrypt', $GLOBALS['user_name']);
						
						$action = "";
						if(!empty($name)) {
							$action = "New Promotion Code Created. Name - ".str_replace("$", '"', $obj->encode_decode('decrypt', $name));
						}

						$null_value = $GLOBALS['null_value'];
                        $columns = array('created_date_time', 'creator', 'creator_name', 'promotion_code_id', 'name', 'lower_case_name', 'price', 'expiry_date', 'minimum_order_amount', 'discount_upto_value', 'deleted');
                        $values = array("'".$created_date_time."'", "'".$creator."'", "'".$creator_name."'", "'".$null_value."'", "'".$name."'", "'".$lower_case_name."'", "'".$price."'", "'".$expiry_date."'", "'".$minimum_order_amount."'", "'".$discount_upto_value."'", "'0'");
						$promotion_code_insert_id = $obj->InsertSQL($GLOBALS['promotion_code_table'], $columns, $values, $action);						
						if(preg_match("/^\d+$/", $promotion_code_insert_id)) {
							$promotion_code_id = "";
							if($promotion_code_insert_id < 10) {
								$promotion_code_id = "promotion_code_0".$promotion_code_insert_id;
							}
							else {
								$promotion_code_id = "promotion_code_".$promotion_code_insert_id;
							}
                            if(!empty($promotion_code_id)) {
                                $promotion_code_id = $obj->encode_decode('encrypt', $promotion_code_id);
                            }
                            $columns = array(); $values = array();						
                            $columns = array('promotion_code_id');
                            $values = array("'".$promotion_code_id."'");
                            $promotion_code_update_id = $obj->UpdateSQL($GLOBALS['promotion_code_table'], $promotion_code_insert_id, $columns, $values, '');
                            if(preg_match("/^\d+$/", $promotion_code_update_id)) {
                                $result = array('number' => '1', 'msg' => 'Promotion Code Successfully Created');					
                            }
                            else {
                                $result = array('number' => '2', 'msg' => $promotion_code_update_id);
                            }
						}
						else {
							$result = array('number' => '2', 'msg' => $promotion_code_insert_id);
						}
					}
					else {
						$result = array('number' => '2', 'msg' => $promotion_code_error);
					}
				}
				else {
					if(empty($prev_promotion_code_id) || $prev_promotion_code_id == $edit_id) {
						$getUniqueID = "";
						$getUniqueID = $obj->getTableColumnValue($GLOBALS['promotion_code_table'], 'promotion_code_id', $edit_id, 'id');
						if(preg_match("/^\d+$/", $getUniqueID)) {
							$action = "";
							if(!empty($name)) {
								$action = "Promotion Code Updated. Name - ".str_replace("$", '"', $obj->encode_decode('decrypt', $name));
							}
						
							$columns = array(); $values = array();						
							$columns = array('name', 'lower_case_name', 'price', 'expiry_date', 'minimum_order_amount', 'discount_upto_value');
							$values = array("'".$name."'", "'".$lower_case_name."'", "'".$price."'", "'".$expiry_date."'", "'".$minimum_order_amount."'", "'".$discount_upto_value."'");
							$promotion_code_update_id = $obj->UpdateSQL($GLOBALS['promotion_code_table'], $getUniqueID, $columns, $values, $action);
							if(preg_match("/^\d+$/", $promotion_code_update_id)) {			
								$result = array('number' => '1', 'msg' => 'Updated Successfully');						
							}
							else {
								$result = array('number' => '2', 'msg' => $promotion_code_update_id);
							}							
						}
					}
					else {
						$result = array('number' => '2', 'msg' => $promotion_code_error);
					}
                }

			}
			else {
				$result = array('number' => '2', 'msg' => 'Invalid IP');
			}
		}
		else {
			$result = array('number' => '3', 'msg' => $valid_promotion_code);
		}
		
		if(!empty($result)) {
			$result = json_encode($result);
		}
		echo $result; exit;
	}
	
	if(isset($_POST['page_number'])) {
		$page_number = $_POST['page_number'];
		$page_limit = $_POST['page_limit'];
		$page_title = $_POST['page_title'];

		$search_text = "";
		if(isset($_POST['search_text'])) {
			$search_text = $_POST['search_text'];
		}

		$total_records_list = array();
		$total_records_list = $obj->getTableRecords($GLOBALS['promotion_code_table'], '', '');

		if(!empty($search_text)) {
			$search_text = strtolower($search_text);
			$list = array();
			if(!empty($total_records_list)) {
				foreach($total_records_list as $val) {
					if(strpos(strtolower($obj->encode_decode('decrypt', $val['name'])), $search_text) !== false) {
						$list[] = $val;
					}
				}
			}
			$total_records_list = $list;
		}
		
		$total_pages = 0;
		if(!empty($total_records_list)) {
			$total_pages = count($total_records_list);
		}
		
		$page_start = 0; $page_end = 0;
		if(!empty($page_number) && !empty($page_limit) && !empty($total_pages)) {
			if($total_pages > $page_limit) {
				if($page_number) {
					$page_start = ($page_number - 1) * $page_limit;
					$page_end = $page_start + $page_limit;
				}
			}
			else {
				$page_start = 0;
				$page_end = $page_limit;
			}
		}

		$show_records_list = array();
        if(!empty($total_records_list)) {
            foreach($total_records_list as $key => $val) {
                if($key >= $page_start && $key < $page_end) {
                    $show_records_list[] = $val;
                }
            }
        }
?>
        
		<?php if($total_pages > $page_limit) { ?>
			<div class="pagination_cover mt-3"> 
				<?php
					include("pagination.php");
				?> 
			</div> 
		<?php } ?>

		<table class="table nowrap show_frontend_table">
            <thead>
                <tr>
					<th class="text-center px-2 py-2">S.No</th>
                    <!--<th class="text-center px-2 py-2">Created Date</th>-->
                    <th class="text-center px-2 py-2">Name</th>
                    <th class="text-center px-2 py-2">Price</th>
                    <th class="text-center px-2 py-2">Expiry Date</th>
                    <th class="text-center px-2 py-2">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php
                    if(!empty($show_records_list)) {
                        foreach($show_records_list as $key => $data) {
							$promotion_code_name = "";
							if(!empty($data['name'])) {
								$promotion_code_name = $obj->encode_decode('decrypt', $data['name']);
								$promotion_code_name = str_replace("$", '"', $promotion_code_name);
								$promotion_code_name = trim($promotion_code_name);
							}

							$current_date = date("Y-m-d"); $show_view_edit = 0;
							if(!empty($data['expiry_date']) && $data['expiry_date'] != "0000-00-00") {
								if($current_date <= $data['expiry_date']) {
									$show_view_edit = 1;
								}
							}
                ?>
							<tr>
								<td class="text-center px-2 py-2"><?php echo $key + 1; ?></td>
								<?php /* ?><td class="text-center px-2 py-2">
									<?php if(!empty($data['created_date_time']) && $data['created_date_time'] != "0000-00-00 00:00:00") { echo date("d-m-Y", strtotime($data['created_date_time'])); } ?>
								</td> <?php */ ?>
								<td class="px-2 py-2">
									<div class="w-100">
										<?php if(!empty($promotion_code_name)) { echo $promotion_code_name; } ?>
									</div>
									
									<?php
										if(!empty($data['creator_name'])) {
											$data['creator_name'] = $obj->encode_decode('decrypt', $data['creator_name']);
									?>
											<small><?php echo "creator : ".$data['creator_name']; ?></small>
									<?php		
										}
									?>
								</td>
                                <td class="text-center px-2 py-2">
                                    <?php if(!empty($data['price'])) { echo $data['price']; } ?>
                                </td>
                                <td class="text-center px-2 py-2">
                                    <?php if(!empty($data['expiry_date']) && $data['expiry_date'] != "0000-00-00") { echo date("d-m-Y", strtotime($data['expiry_date'])); } ?>
                                </td>
								<td class="text-center px-2 py-2">
									<?php //if(!empty($show_view_edit) && $show_view_edit == 1) { ?>
									<div class="dropdown">
										<a class="btn btn-dark poppins px-3" href="#" role="button" data-toggle="dropdown">
											<i class="fa fa-ellipsis-v text-white"></i>
										</a>
										<div class="dropdown-menu dropdown-menu-right dropdown-menu-icon-list">
											<a class="dropdown-item" href="Javascript:ShowModalContent('<?php if(!empty($page_title)) { echo $page_title; } ?>', '<?php if(!empty($data['promotion_code_id'])) { echo $data['promotion_code_id']; } ?>');"><i class="fa fa-pencil"></i> &ensp; View / Edit</a>
											<a class="dropdown-item" href="Javascript:DeleteModalContent('<?php if(!empty($page_title)) { echo $page_title; } ?>', '<?php if(!empty($data['promotion_code_id'])) { echo $data['promotion_code_id']; } ?>');"><i class="fa fa-trash"></i> &ensp; Delete</a>
										</div>
									</div>
									<?php //} ?>
								</td>
							</tr>
                <?php
                        }
                    }
                    else {
                ?>
                        <tr>
                            <td colspan="5" class="text-center">Sorry! No records found</td>
                        </tr>
                <?php } ?>
            </tbody>
        </table>
<?php	
	}
	
	if(isset($_REQUEST['delete_promotion_code_id'])) {
		$delete_promotion_code_id = $_REQUEST['delete_promotion_code_id'];
		$msg = "";
		if(!empty($delete_promotion_code_id)) {	
			$promotion_code_unique_id = "";
			$promotion_code_unique_id = $obj->getTableColumnValue($GLOBALS['promotion_code_table'], 'promotion_code_id', $delete_promotion_code_id, 'id');
            if(preg_match("/^\d+$/", $promotion_code_unique_id)) {
                $name = "";
                $name = $obj->getTableColumnValue($GLOBALS['promotion_code_table'], 'promotion_code_id', $delete_promotion_code_id, 'name');
            
                $action = "";
                if(!empty($name)) {
                    $action = "Promotion Code Deleted. Name - ".$obj->encode_decode('decrypt', $name);
                }
            
                $columns = array(); $values = array();						
                $columns = array('deleted');
                $values = array("'1'");
                $msg = $obj->UpdateSQL($GLOBALS['promotion_code_table'], $promotion_code_unique_id, $columns, $values, $action);
            }
		}
		echo $msg;
		exit;	
	}
?>