<?php
    $order_id = ""; $paper_size = "";
    if(isset($_REQUEST['print_order_id'])){
        $order_id = $_REQUEST['print_order_id'];
    }

    if(isset($_REQUEST['paper_size'])){
        $paper_size = $_REQUEST['paper_size'];
    }
    
    if(isset($pdf_frontend) && !empty($pdf_frontend) && $pdf_frontend == 1) {
        include("../../../include.php");
        require_once('../../fpdf/fpdf.php');
    } 
    else {
        include("../../include.php");
        require_once('../../../order/fpdf/fpdf.php');
    }

    $order_type = ""; $order_number = ""; $order_date = ""; $customer_details = ""; $delivery_address = ""; $product_ids = array();
    $product_codes = array(); $product_names = array(); $product_contents = array(); $quantity_values = array(); $rate_values = array();
    $discount_values = array(); $packing_charges = ""; $company_details = ""; $bank_details = ""; $order_count = 0;
    $promotion_code_price = ""; $promotion_code_discount_value = "";

    $view_orders = array();
    $view_orders = $obj->getTableRecords($GLOBALS['order_table'], 'order_id', $order_id);
    if(!empty($view_orders)) {
        foreach($view_orders as $data) {
            if(!empty($data['order_type'])) {
                $order_type = $obj->encode_decode('decrypt', $data['order_type']);
            }
            if(!empty($data['order_number']) && $data['order_number'] != $GLOBALS['null_value']) {
                $order_number = $obj->encode_decode('decrypt', $data['order_number']);
            }
            if(!empty($data['order_date']) && $data['order_date'] != "0000-00-00") {
                $order_date = date("d-m-Y", strtotime($data['order_date']));
            }
            if(!empty($data['company_details'])) {
                $company_details = $obj->encode_decode('decrypt', $data['company_details']);
            }
            if(!empty($data['bank_details'])) {
                $bank_details = $obj->encode_decode('decrypt', $data['bank_details']);
            }
            if(!empty($data['customer_details'])) {
                $customer_details = $obj->encode_decode('decrypt', $data['customer_details']);
            }
            if(!empty($data['delivery_address'])) {
                $delivery_address = $obj->encode_decode('decrypt', $data['delivery_address']);
                $delivery_address = str_replace("\r\n", "<br>", $delivery_address);
            }
            if(!empty($data['product_id'])) {
                $product_ids = explode(",", $data['product_id']);
                $order_count = count($product_ids);
            }
            if(!empty($data['product_code'])) {
                $product_codes = explode(",", $data['product_code']);
            }
            if(!empty($data['product_name'])) {
                $product_names = explode(",", $data['product_name']);
            }
            if(!empty($data['product_content'])) {
                $product_contents = explode(",", $data['product_content']);
            }
            if(!empty($data['quantity'])) {
                $quantity_values = explode(",", $data['quantity']);
            }
            if(!empty($data['actual_price'])) {
                $rate_values = explode(",", $data['actual_price']);
            }
            if(!empty($data['discount'])) {
                $discount_values = explode(",", $data['discount']);
            }
            if(!empty($data['packing_charges']) && $data['packing_charges'] != $GLOBALS['null_value']) {
                $packing_charges = $data['packing_charges'];
            }
            if(!empty($data['promotion_code_price']) && $data['promotion_code_price'] != $GLOBALS['null_value']) {
                $promotion_code_price = $data['promotion_code_price'];
            }
            if(!empty($data['promotion_code_discount_value']) && $data['promotion_code_discount_value'] != $GLOBALS['null_value']) {
                $promotion_code_discount_value = $data['promotion_code_discount_value'];
            }
        }
    }

    $company_name = ""; $company_logo = ""; $company_address = ""; $company_mobile_number = ""; $company_email = "";
    $ac_name = ""; $ac_number= ""; $ac_type = ""; $bank_name = ""; $ifsc_code = "";
    if(!empty($company_details)) {
        $company_details = explode("<br>", $company_details);
        if(!empty($company_details['0'])) {
            $company_name = $company_details['0'];
        }
        if(!empty($company_details['1'])) {
            $company_address = $company_details['1'];
        }
        if(!empty($company_details['2'])) {
            $company_mobile_number = $company_details['2'];
        }
        if(!empty($company_details['3'])) {
            $company_email = $company_details['3'];
        }
    }

    $pdf_font_size = array(); $font_size = "";
    $pdf_font_size = $obj->getTableRecords($GLOBALS['settings_table'], 'name', 'pdf_font_size');

    foreach($pdf_font_size as $data){
        $font_size = $data['value'];
    }

    if(!empty($bank_details)) {
        $bank_details = explode("<br>", $bank_details);
        if(!empty($bank_details['0'])) {
            $ac_name = $bank_details['0'];
        }
        if(!empty($bank_details['1'])) {
            $ac_number = $bank_details['1'];
        }
        if(!empty($bank_details['2'])) {
            $ac_type = $bank_details['2'];
        }
        if(!empty($bank_details['3'])) {
            $bank_name = $bank_details['3'];
        }
        if(!empty($bank_details['4'])) {
            $ifsc_code = $bank_details['4'];
        }
    }

    $target_dir = $obj->image_directory();

    $product_lists = array();
    for($i = 0; $i < count($product_names); $i++) {
        $product_code = "";$product_name = ""; $product_content = ""; $product_price = "";  $product_quantity = ""; $product_discount = 0;
        $product_amount = "";
        if(!empty($product_codes[$i]) && $product_codes[$i] != $GLOBALS['null_value']) {
            $product_code = $product_codes[$i];
        }
        if(!empty($product_names[$i])) {
            $product_name = $product_names[$i];
        }
        if(!empty($product_contents[$i]) && $product_contents[$i] != $GLOBALS['null_value']) {
            $product_content = $product_contents[$i];
        }
        if(!empty($rate_values[$i])) {
            $product_price = $rate_values[$i];
        }
        if(!empty($quantity_values[$i])) {
            $product_quantity = $quantity_values[$i];
        }
        if(!empty($order_type)) {
            if($order_type == $GLOBALS['backend_order']) {
                if(!empty($discount_values['0'])) {
                    $product_discount = $discount_values['0'];
                }
            }
            else if($order_type == $GLOBALS['frontend_order']) {
                if(!empty($discount_values[$i])) {
                    $product_discount = $discount_values[$i];
                    $product_discount = $product_discount."%";
                }
                else {
                    $product_discount = 0;
                }
            }
        }		
        
        if(!empty($product_quantity) && !empty($product_price)) {
            $product_amount = $product_quantity * $product_price;
            if(!empty($product_amount)) {
                $product_amount = number_format($product_amount, 2);
                $product_amount = str_replace(",", "", $product_amount);
            }
        }
        
        if(!empty($product_amount)) {		
            $product_lists[] = array('code' => $product_code, 'name' => $product_name, 'content' => $product_content, 'price' => $product_price, 'quantity' => $product_quantity, 'discount' => $product_discount, 'amount' => $product_amount);
        }
    }
    if(!empty($delivery_address)){
        $delivery_address = explode("<br>",$delivery_address);
    }
    if(!empty($product_lists)) {	
        $values = array();
        foreach($product_lists as $key => $row) {
            $values[$key] = $obj->encode_decode('decrypt', $row['code']);
        }
        array_multisort($values, SORT_ASC, $product_lists);
        
        $discounts = array();
        foreach($product_lists as $list) {
            if(!in_array($list['discount'], $discounts)) {
                $discounts[] = $list['discount'];
            }    
        }
        if(count($product_lists)>15 || $paper_size == "a4"){
            $pdf = new FPDF('P','mm','A4');
            $pdf->AliasNbPages(); 
            $pdf->AddPage();
            $pdf->SetAutoPageBreak(true);
            $pdf->SetTitle('Estimate Report');
            
            $pdf->SetY(7);
            $pdf->SetX(140);
            $pdf->SetFont('Arial','B',11);
            $pdf->SetTextColor(47,79,79);
            $pdf->Cell(0,6,'Estimate',0,1,'L',0);
            
            $pdf->SetFont('Arial','',8.5);
            $pdf->SetTextColor(0,0,0);
            $pdf->SetX(140);
            $pdf->Cell(0,4,'Date                        : '.date("d-m-Y", strtotime($order_date)),0,1,'L',0);
            $pdf->SetX(140);
            $pdf->Cell(0,4,'Estimate Number    : '.$order_number,0,1,'L',0);

            $pdf->SetY(7);
            $pdf->SetFont('Arial','B',15);
            $pdf->SetTextColor(47,79,79);
            if(!empty($company_name)){
                $pdf->Cell(0,6,strtoupper($company_name),0,1,'L',0);
            }
            $pdf->SetTextColor(0,0,0);
            $pdf->SetFont('Arial','',8.5);
            if(!empty($company_address)){
                $pdf->MultiCell(50,4,$company_address,0,'L',0);
            }
            if(!empty($company_mobile_number)){
                $pdf->MultiCell(50,4,$company_mobile_number,0,'L',0);
            }
            if(!empty($company_email)){
                $pdf->MultiCell(50,4,$company_email,0,'L',0);
            }

            $pdf->SetFont('Arial','B',8.5);
            $pdf->Cell(50,2,'',0,1,'C',0);
            $pdf->SetFillColor(47,79,79);
            $pdf->SetTextColor(255,255,255);

            $yaxis = $pdf->GetY();
            $pdf->SetX(10);
            $pdf->Cell(50,8,'Billed To',0,1,'L',1);

            $pdf->Cell(50,1,'',0,1,'C',0);
            $pdf->SetFont('Arial','',8.5);
            $pdf->SetTextColor(0,0,0);
            $customer_details1 = "";
            if(!empty($customer_details)){
                $customer_details1 = explode("<br>",$customer_details);
            }
            
            for($i=0;$i<count($customer_details1);$i++){
                $pdf->Cell(0,4,$customer_details1[$i],0,1,'L',0);
            }
            if(!empty($delivery_address)){
                for($i=0;$i<count($delivery_address);$i++){
                    $pdf->MultiCell(135,3,$delivery_address[$i],0,'L',0);
                }
            }
            $yaxis1=$pdf->GetY();
            
            if(!empty($bank_details)) {
                $pdf->SetY($yaxis);
                $pdf->SetFont('Arial','B',8.5);
                $pdf->SetTextColor(255,255,255);
                $pdf->SetX(140);
                $pdf->Cell(58,8,'Bank Account Details',0,1,'L',1);

                $pdf->Cell(50,1,'',0,1,'C',0);
                $pdf->SetFont('Arial','',8.5);
                $pdf->SetTextColor(0,0,0);
                if(!empty($ac_name)) {
                    $pdf->SetX(140);
                    $pdf->Cell(20,4,'A/C Name',0,0,'L',0);
                    $pdf->SetX(157);
                    $pdf->Cell(35,4,' : ',0,0,'L',0);
                    $pdf->SetX(160);
                    $pdf->Cell(35,4,$ac_name,0,1,'L',0);
                }
                if(!empty($ac_number)) {
                    $pdf->SetX(140);
                    $pdf->Cell(0,4,'A/C Number',0,0,'L',0);
                    $pdf->SetX(157);
                    $pdf->Cell(35,4,' : ',0,0,'L',0);
                    $pdf->SetX(160);
                    $pdf->Cell(35,4,$ac_number,0,1,'L',0);
                }
                if(!empty($ac_type)) {
                    $pdf->SetX(140);
                    $pdf->Cell(0,4,'A/C Type',0,0,'L',0);
                    $pdf->SetX(157);
                    $pdf->Cell(35,4,' : ',0,0,'L',0);
                    $pdf->SetX(160);
                    $pdf->Cell(35,4,$ac_type,0,1,'L',0);
                }
                if(!empty($bank_name)) {
                    $pdf->SetX(140);
                    $pdf->Cell(0,4,'Bank Name',0,0,'L',0); 
                    $pdf->SetX(157);
                    $pdf->Cell(35,4,' : ',0,0,'L',0);
                    $pdf->SetX(160);
                    $pdf->MultiCell(40,4,$bank_name,0,'L',0);
                }
                if(!empty($ifsc_code)) {
                    $pdf->SetX(140);
                    $pdf->Cell(0,4,'IFSC Code',0,0,'L',0); 
                    $pdf->SetX(157);
                    $pdf->Cell(35,4,' : ',0,0,'L',0);
                    $pdf->SetX(160);
                    $pdf->Cell(35,4,$ifsc_code,0,1,'L',0);
                }
            }
            $yaxis2 = $pdf->GetY();
            if($yaxis1>$yaxis2){
                $pdf->SetY($yaxis1);
            }
            else{
                $pdf->SetY($yaxis2);
            }

            $pdf->Cell(15,2,'',0,1,'L',0);
            $pdf->SetFont('Arial','B',8.5);
            $pdf->SetTextColor(255,255,255);
            $pdf->SetX(10);
            $pdf->Cell(15,8,'S.No',0,0,'L',1);
            $pdf->SetX(24);
            $pdf->Cell(94,8,'Product Code & Name',0,0,'L',1);
            $pdf->SetX(116);
            $pdf->Cell(29,8,'Content',0,0,'L',1);
            $pdf->SetX(134);
            $pdf->Cell(15,8,'Qty',0,0,'L',1);
            $pdf->SetX(149);
            $pdf->Cell(21,8,'Rate',0,0,'R',1);
            $pdf->SetX(169);
            $pdf->Cell(29,8,'Amount',0,1,'R',1);

            $pdf->SetTextColor(0,0,0);
            $s_no = 1; $overall_total = 0; $payable_amounts = array();
            if(!empty($discounts)) {
                foreach($discounts as $discount) {
                    if($pdf->GetY()>250){
                        $pdf->SetTextColor(255,255,255);
                        $pdf->SetFillColor(47,79,79);
                        $pdf->SetFont('Arial','BI',7);
                        $pdf->Cell(198,5,'Continued to Page No : '.$pdf->PageNo()+1,0,1,'R',1);
                        $pdf->SetY(-7);
                        $pdf->SetFont('Arial','I',7);
                        $pdf->SetTextColor(0,0,0);
                        $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);

                        $pdf->AddPage();
                        $pdf->SetFont('Arial','',8.5);
                        $pdf->SetTextColor(0,0,0);
                        $pdf->SetX(140);
                        $pdf->Cell(0,4,'Date                        : '.date("d-m-Y", strtotime($order_date)),0,1,'L',0);
                        $pdf->SetX(140);
                        $pdf->Cell(0,4,'Estimate Number    : '.$order_number,0,1,'L',0);

                        $pdf->SetY(7);
                        $pdf->SetFont('Arial','B',15);
                        $pdf->SetTextColor(47,79,79);
                        if(!empty($company_name)){
                            $pdf->Cell(0,6,strtoupper($company_name),0,1,'L',0);
                        }
                        $pdf->SetTextColor(0,0,0);
                        $pdf->SetFont('Arial','',8.5);
                        if(!empty($company_address)){
                            $pdf->MultiCell(50,4,$company_address,0,'L',0);
                        }
                        if(!empty($company_mobile_number)){
                            $pdf->MultiCell(50,4,$company_mobile_number,0,'L',0);
                        }
                        if(!empty($company_email)){
                            $pdf->MultiCell(50,4,$company_email,0,'L',0);
                        }

                        $pdf->Cell(15,2,'',0,1,'L',0);
                        $pdf->SetFont('Arial','B',8.5);
                        $pdf->SetTextColor(255,255,255);
                        $pdf->SetX(10);
                        $pdf->Cell(15,8,'S.No',0,0,'L',1);
                        $pdf->SetX(24);
                        $pdf->Cell(94,8,'Product Code & Name',0,0,'L',1);
                        $pdf->SetX(116);
                        $pdf->Cell(29,8,'Content',0,0,'L',1);
                        $pdf->SetX(134);
                        $pdf->Cell(15,8,'Qty',0,0,'L',1);
                        $pdf->SetX(149);
                        $pdf->Cell(21,8,'Rate',0,0,'R',1);
                        $pdf->SetX(169);
                        $pdf->Cell(29,8,'Amount',0,1,'R',1);
                        $y_axis = $pdf->GetY();
                        $pdf-> Cell(0,1,'',0,1,'L',0);
                        $pdf->SetFillColor(245,245,245);
                        $pdf->SetTextColor(0,0,0);
                        $pdf->SetFont('Arial','',$font_size);
                    }
                    $pdf->Cell(188,1,"",0,1,'L',0);
                    if(!empty($discount)) {
                        $pdf->SetFont('Arial','B',$font_size);
                        // $pdf->SetFillColor(232,232,232);
                        $pdf->SetFillColor(47,79,79);
                        $pdf->SetTextColor(255,255,255);
                        if (strpos($discount, '%') !== false) {
                            $pdf->SetX(10);
                            $pdf->Cell(188,6,$discount." Products",0,1,'L',1);
                        }
                        else {
                            $pdf->SetX(10);
                            $pdf->Cell(188,6,"Rs.".$discount." Products",0,1,'L',1);
                        }
                        $y_axis=$pdf->GetY();
                        $pdf->SetFont('Arial','',$font_size);
                        $pdf->SetFillColor(245,245,245);
                        $pdf->SetTextColor(0,0,0);
                        if(!empty($product_lists)) {
                            $sub_total = 0; $discounted_total = 0; 
                            $yaxis = $pdf->GetY();
                            $pdf-> Cell(0,1,'',0,1,'L',0);
                            foreach($product_lists as $key => $data) {
                               
                                if(empty($data['discount']) && $data['discount'] == $discount) {
                                    
                                    if($pdf->GetY()>250){
                                    $pdf->SetTextColor(255,255,255);
                                        $pdf->SetFillColor(47,79,79);
                                        $pdf->SetFont('Arial','BI',7);
                                        $pdf->Cell(188,5,'Continued to Page No : '.$pdf->PageNo()+1,0,1,'R',1);
                                        $pdf->SetY(-7);
                                        $pdf->SetFont('Arial','I',7);
                                        $pdf->SetTextColor(0,0,0);
                                        $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);
                                    
                                        $pdf->AddPage();
                                        $pdf->SetFont('Arial','',8.5);
                                        $pdf->SetTextColor(0,0,0);
                                        $pdf->SetX(140);
                                        $pdf->Cell(0,4,'Date                        : '.date("d-m-Y", strtotime($order_date)),0,1,'L',0);
                                        $pdf->SetX(140);
                                        $pdf->Cell(0,4,'Estimate Number    : '.$order_number,0,1,'L',0);

                                        $pdf->SetY(7);
                                        $pdf->SetFont('Arial','B',15);
                                        $pdf->SetTextColor(47,79,79);
                                        if(!empty($company_name)){
                                            $pdf->Cell(0,6,strtoupper($company_name),0,1,'L',0);
                                        }
                                        $pdf->SetTextColor(0,0,0);
                                        $pdf->SetFont('Arial','',8.5);
                                        if(!empty($company_address)){
                                            $pdf->MultiCell(50,4,$company_address,0,'L',0);
                                        }
                                        if(!empty($company_mobile_number)){
                                            $pdf->MultiCell(50,4,$company_mobile_number,0,'L',0);
                                        }
                                        if(!empty($company_email)){
                                            $pdf->MultiCell(50,4,$company_email,0,'L',0);
                                        }

                                        $pdf->Cell(15,2,'',0,1,'L',0);
                                        $pdf->SetFont('Arial','B',8.5);
                                        $pdf->SetTextColor(255,255,255);
                                        $pdf->Cell(15,2,'',0,1,'L',0);
                                        $pdf->SetFont('Arial','B',8.5);
                                        $pdf->SetTextColor(255,255,255);
                                        $pdf->SetX(10);
                                        $pdf->Cell(15,8,'S.No',0,0,'L',1);
                                        $pdf->SetX(24);
                                        $pdf->Cell(94,8,'Product Code & Name',0,0,'L',1);
                                        $pdf->SetX(116);
                                        $pdf->Cell(29,8,'Content',0,0,'L',1);
                                        $pdf->SetX(134);
                                        $pdf->Cell(15,8,'Qty',0,0,'L',1);
                                        $pdf->SetX(149);
                                        $pdf->Cell(21,8,'Rate',0,0,'R',1);
                                        $pdf->SetX(169);
                                        $pdf->Cell(29,8,'Amount',0,1,'R',1);
                                        $y_axis = $pdf->GetY();
                                        $pdf-> Cell(0,1,'',0,1,'L',0);
                                        $pdf->SetFillColor(245,245,245);
                                        $pdf->SetTextColor(0,0,0);
                                        $pdf->SetFont('Arial','',$font_size);
                                    }
                                    $y3=$pdf->GetY();
                                    
                                    $pdf->SetX(24);
                                    $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                                    $data['name'] = str_replace("$", '"', $data['name']);
                                    $data['name'] = str_replace("'''", '"', $data['name']);
                                    $data['name'] = stripslashes($data['name']);
                                    $data['name'] = iconv('UTF-8', 'windows-1252', $data['name']);
                                    
                                    // $data['name'] = "Ground Chakkar Ashoka Ground Chakkar Ashoka Ground Chakkar Ashoka"; 
                                    
                                    if(!empty($data['code']) && $data['code']!='NULL'){
                                        $data['code'] = $obj->encode_decode('decrypt', $data['code']);
                                        $pdf->MultiCell(94,4,$data['code'].' - '.$data['name'],0,'L',1);
                                    }
                                    else{
                                        $pdf->MultiCell(94,4,$data['name'],0,'L',1);
                                    }
                                    
                                    $y4 = $pdf->GetY();

                                    $height = 0;
                                    if($y3>$y4){
                                        $pdf->SetY($y3);
                                        $height = 4;
                                    }
                                    else{
                                        $pdf->SetY($y4);
                                        $height = $y4-$y3;
                                    }

                                    $pdf->SetY($y3);
                                    $pdf->SetX(10);
                                    $pdf->Cell(15,$height,$s_no,0,0,'C',1);
                                    $pdf->SetX(112);
                                    if(!empty($data['content']) && $data['content']!='NULL'){
                                        $data['content'] = $obj->encode_decode('decrypt', $data['content']);
                                        $pdf->Cell(29,$height,$data['content'],0,0,'L',1);
                                    }
                                    else
                                    {
                                        $pdf->Cell(29,$height,'',0,0,'L',1);
                                    }
                                    $pdf->SetX(130);
                                    $pdf->Cell(25,$height,$data['quantity'],0,0,'L',1);
                                    $pdf->SetX(154);
                                    $pdf->Cell(15,$height,number_format($data['price'], 2),0,0,'R',1);
                                    $pdf->SetX(169);
                                    $pdf->Cell(29,$height,number_format($data['amount'], 2),0,0,'R',1);
                                    $pdf->SetX(200);
                                    $pdf->Cell(35,$height,'',0,1,'R',0);
                                    
                                    $pdf->Cell(0,1.5,'',0,1,'R',0);
                                    $s_no++;
                                    $sub_total = $sub_total + $data['amount'];
                                }
                                if(!empty($data['discount']) && $data['discount'] == $discount) {
                                    if($pdf->GetY()>250){
                                        $pdf->SetTextColor(255,255,255);
                                            $pdf->SetFillColor(47,79,79);
                                            $pdf->SetFont('Arial','BI',7);
                                            $pdf->Cell(188,5,'Continued to Page No : '.$pdf->PageNo()+1,0,1,'R',1);
                                            $pdf->SetY(-7);
                                            $pdf->SetFont('Arial','I',7);
                                            $pdf->SetTextColor(0,0,0);
                                            $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);
                                        
                                            $pdf->AddPage();
                                            $pdf->SetFont('Arial','',8.5);
                                            $pdf->SetTextColor(0,0,0);
                                            $pdf->SetX(140);
                                            $pdf->Cell(0,4,'Date                        : '.date("d-m-Y", strtotime($order_date)),0,1,'L',0);
                                            $pdf->SetX(140);
                                            $pdf->Cell(0,4,'Estimate Number    : '.$order_number,0,1,'L',0);
    
                                            $pdf->SetY(7);
                                            $pdf->SetFont('Arial','B',15);
                                            $pdf->SetTextColor(47,79,79);
                                            if(!empty($company_name)){
                                                $pdf->Cell(0,6,strtoupper($company_name),0,1,'L',0);
                                            }
                                            $pdf->SetTextColor(0,0,0);
                                            $pdf->SetFont('Arial','',8.5);
                                            if(!empty($company_address)){
                                                $pdf->MultiCell(50,4,$company_address,0,'L',0);
                                            }
                                            if(!empty($company_mobile_number)){
                                                $pdf->MultiCell(50,4,$company_mobile_number,0,'L',0);
                                            }
                                            if(!empty($company_email)){
                                                $pdf->MultiCell(50,4,$company_email,0,'L',0);
                                            }
    
                                            $pdf->Cell(15,2,'',0,1,'L',0);
                                            $pdf->SetFont('Arial','B',8.5);
                                            $pdf->SetTextColor(255,255,255);
                                            $pdf->Cell(15,2,'',0,1,'L',0);
                                            $pdf->SetFont('Arial','B',8.5);
                                            $pdf->SetTextColor(255,255,255);
                                            $pdf->SetX(10);
                                            $pdf->Cell(15,8,'S.No',0,0,'L',1);
                                            $pdf->SetX(24);
                                            $pdf->Cell(94,8,'Product Code & Name',0,0,'L',1);
                                            $pdf->SetX(116);
                                            $pdf->Cell(29,8,'Content',0,0,'L',1);
                                            $pdf->SetX(134);
                                            $pdf->Cell(15,8,'Qty',0,0,'L',1);
                                            $pdf->SetX(149);
                                            $pdf->Cell(21,8,'Rate',0,0,'R',1);
                                            $pdf->SetX(169);
                                            $pdf->Cell(29,8,'Amount',0,1,'R',1);
                                            $y_axis = $pdf->GetY();
                                            $pdf-> Cell(0,1,'',0,1,'L',0);
                                            $pdf->SetFillColor(245,245,245);
                                            $pdf->SetTextColor(0,0,0);
                                            $pdf->SetFont('Arial','',$font_size);
                                        }
                                    $y3=$pdf->GetY();
                                   
                                    $pdf->SetX(24);
                                    $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                                    $data['name'] = str_replace("$", '"', $data['name']);
                                    $data['name'] = str_replace("'''", '"', $data['name']);
                                    $data['name'] = stripslashes($data['name']);
                                    $data['name'] = iconv('UTF-8', 'windows-1252', $data['name']);
                                    // $data['name'] = "Ground Chakkar Ashoka Ground Chakkar Ashoka Ground Chakkar Ashoka"; 
                                    if(!empty($data['code']) && $data['code']!='NULL'){
                                        $data['code'] = $obj->encode_decode('decrypt', $data['code']);
                                        $pdf->MultiCell(94,4,$data['code'].' - '.$data['name'],0,'L',1);
                                    }
                                    else{
                                        $pdf->MultiCell(94,4,$data['name'],0,'L',1);
                                    }
                                    $y4 = $pdf->GetY();

                                    $height = 0;
                                    if($y3>$y4){
                                        $pdf->SetY($y3);
                                        $height = 4;
                                    }
                                    else{
                                        $pdf->SetY($y4);
                                        $height = $y4-$y3;
                                    }

                                    $pdf->SetY($y3);
                                    $pdf->SetX(10);
                                    $pdf->Cell(15,$height,$s_no,0,0,'C',1);
                                    
                                    $pdf->SetX(116);
                                    if(!empty($data['content']) && $data['content']!='NULL'){
                                        $data['content'] = $obj->encode_decode('decrypt', $data['content']);
                                        $pdf->Cell(29,$height,$data['content'],0,0,'L',1);
                                    }
                                    else
                                    {
                                        $pdf->Cell(29,$height,'',0,0,'L',1);
                                    }
                                    $pdf->SetX(134);
                                    $pdf->Cell(15,$height,$data['quantity'],0,0,'L',1);
                                    $pdf->SetX(149);
                                    $pdf->Cell(21,$height,number_format($data['price'], 2),0,0,'R',1);
                                    $pdf->SetX(169);
                                    $pdf->Cell(29,$height,number_format($data['amount'], 2),0,0,'R',1);
                                    $pdf->SetX(200);
                                    $pdf->Cell(35,$height,'',0,1,'R',0);
                                    
                                    $pdf->Cell(0,1.5,'',0,1,'R',0);
                                    $s_no++;
                                    $sub_total = $sub_total + $data['amount'];
                                }
                            }
                            if(!empty($sub_total)) {
                                // $pdf->SetFillColor(232,232,232);
                                $pdf->SetFillColor(47,79,79);
                                // $pdf->SetTextColor(255,255,255);
                                $pdf->SetFont('Arial','B',$font_size);
                                if(!empty($discount)){
                                    $pdf->SetX(10);
                                    $pdf->Cell(153,4,'Sub Total',0,0,'R',0);
                                    $pdf->SetX(163);
                                    $pdf->Cell(35,4,number_format($sub_total, 2),0,1,'R',0);
                                }
                                
                                $discount_value = 0;
                                if (strpos($discount, '%') !== false) {
                                    $discount = trim(str_replace("%", "", $discount));
                                    $discount_value = ($sub_total * $discount) / 100;
                                    if(!empty($discount_value)) {
                                        // $discount_value = number_format($discount_value, 2);
                                        $discount_value = trim(str_replace(",", "", $discount_value));
                                        $discount = $discount."%";
                                    }
                                }
                                else {
                                    $discount_value = $discount;
                                    $discount = "Rs.".$discount;
                                }
                                if(!empty($discount_value)) {
                                    $sub_total = $sub_total - $discount_value;

                                    $pdf->SetX(10);
                                    $pdf->Cell(153,4,'Discount ( '.$discount.' )',0,0,'R',0);
                                    $pdf->SetX(163);
                                    $pdf->Cell(35,4,number_format($discount_value, 2),0,1,'R',0);
                                }
                                $pdf->SetX(10);
                                $pdf->Cell(153,4,'Total',0,0,'R',0);
                                if(!empty($sub_total)) { 
                                    $payable_amounts[] = $sub_total;
                                    $overall_total = $overall_total + $sub_total;
                                    $pdf->SetX(163);
                                    $pdf->Cell(35,4,number_format($sub_total, 2),0,1,'R',0);
                                }
                                
                            }
                            
                        }
                    }
                    else{
                        
                        $pdf->Cell(188,1,"",0,1,'L',0);
                        $pdf->SetFont('Arial','B',$font_size);
                        $pdf->SetX(10);
                        $pdf->SetTextColor(255,255,255);
                        // $pdf->SetFillColor(232,232,232);
                        $pdf->SetFillColor(47,79,79);
                        $pdf->Cell(188,5,"Net Rate Products",0,1,'L',1);
                        $pdf->SetTextColor(0,0,0);
                        $pdf->SetFont('Arial','',$font_size);
                        if(!empty($product_lists)) {
                            $sub_total = 0; $discounted_total = 0;
                            $y_axis = $pdf->GetY();
                            $pdf-> Cell(0,1,'',0,1,'L',0);
                            $pdf->SetFillColor(245,245,245);
                            foreach($product_lists as $key => $data) {
                                if(empty($data['discount']) && $data['discount'] == $discount) {
                                    if($pdf->GetY()>250){

                                        $pdf->SetTextColor(255,255,255);
                                        $pdf->SetFillColor(47,79,79);
                                        $pdf->SetFont('Arial','BI',7);
                                        $pdf->Cell(188,5,'Continued to Page No : '.$pdf->PageNo()+1,0,1,'R',1);
                                        $pdf->SetY(-7);
                                        $pdf->SetFont('Arial','I',7);
                                        $pdf->SetTextColor(0,0,0);
                                        $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);

                                        $pdf->AddPage();
                                        $pdf->SetFont('Arial','',8.5);
                                        $pdf->SetTextColor(0,0,0);
                                        $pdf->SetX(140);
                                        $pdf->Cell(0,4,'Date                        : '.date("d-m-Y", strtotime($order_date)),0,1,'L',0);
                                        $pdf->SetX(140);
                                        $pdf->Cell(0,4,'Estimate Number    : '.$order_number,0,1,'L',0);

                                        $pdf->SetY(7);
                                        $pdf->SetFont('Arial','B',15);
                                        $pdf->SetTextColor(47,79,79);
                                        if(!empty($company_name)){
                                            $pdf->Cell(0,6,strtoupper($company_name),0,1,'L',0);
                                        }
                                        $pdf->SetTextColor(0,0,0);
                                        $pdf->SetFont('Arial','',8.5);
                                        if(!empty($company_address)){
                                            $pdf->MultiCell(50,4,$company_address,0,'L',0);
                                        }
                                        if(!empty($company_mobile_number)){
                                            $pdf->MultiCell(50,4,$company_mobile_number,0,'L',0);
                                        }
                                        if(!empty($company_email)){
                                            $pdf->MultiCell(50,4,$company_email,0,'L',0);
                                        }

                                        $pdf->Cell(15,2,'',0,1,'L',0);
                                        $pdf->SetFont('Arial','B',8.5);
                                        $pdf->SetTextColor(255,255,255);
                                        $pdf->SetX(10);
                                        $pdf->Cell(15,8,'S.No',0,0,'L',1);
                                        $pdf->SetX(24);
                                        $pdf->Cell(94,8,'Product Code & Name',0,0,'L',1);
                                        $pdf->SetX(116);
                                        $pdf->Cell(29,8,'Content',0,0,'L',1);
                                        $pdf->SetX(134);
                                        $pdf->Cell(15,8,'Qty',0,0,'L',1);
                                        $pdf->SetX(149);
                                        $pdf->Cell(21,8,'Rate',0,0,'R',1);
                                        $pdf->SetX(169);
                                        $pdf->Cell(29,8,'Amount',0,1,'R',1);
                                        $y_axis = $pdf->GetY();
                                        $pdf-> Cell(0,1,'',0,1,'L',0);
                                        $pdf->SetFillColor(245,245,245);
                                        $pdf->SetTextColor(0,0,0);
                                        $pdf->SetFont('Arial','',$font_size);
                                    }
                                    $y3=$pdf->GetY();
                                    
                                    $pdf->SetX(24);
                                    $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                                    $data['name'] = str_replace("$", '"', $data['name']);
                                    $data['name'] = str_replace("'''", '"', $data['name']);
                                    $data['name'] = stripslashes($data['name']);
                                    $data['name'] = iconv('UTF-8', 'windows-1252', $data['name']);
                                    if(!empty($data['code']) && $data['code']!='NULL'){
                                        $data['code'] = $obj->encode_decode('decrypt', $data['code']);
                                        $pdf->MultiCell(94,4,$data['code'].' - '.$data['name'],0,'L',1);
                                    }
                                    else{
                                        $pdf->MultiCell(94,4,$data['name'],0,'L',1);
                                    }
                                    $y4 = $pdf->GetY();

                                    $height = 0;
                                    if($y3>$y4){
                                        $pdf->SetY($y3);
                                        $height = 4;
                                    }
                                    else{
                                        $pdf->SetY($y4);
                                        $height = $y4-$y3;
                                    }

                                    $pdf->SetY($y3);
                                    $pdf->SetX(10);
                                    $pdf->Cell(15,$height,$s_no,0,0,'C',1);
                                    
                                    $pdf->SetX(116);
                                    if(!empty($data['content']) && $data['content']!='NULL'){
                                        $data['content'] = $obj->encode_decode('decrypt', $data['content']);
                                        $pdf->Cell(29,$height,$data['content'],0,0,'L',1);
                                    }
                                    else
                                    {
                                        $pdf->Cell(29,$height,'',0,0,'L',1);
                                    }
                                    $pdf->SetX(134);
                                    $pdf->Cell(15,$height,$data['quantity'],0,0,'L',1);
                                    $pdf->SetX(149);
                                    $pdf->Cell(21,$height,number_format($data['price'], 2),0,0,'R',1);
                                    $pdf->SetX(169);
                                    $pdf->Cell(29,$height,number_format($data['amount'], 2),0,0,'R',1);
                                    $pdf->SetX(200);
                                    $pdf->Cell(35,$height,'',0,1,'R',0);
                                    
                                    $pdf->Cell(0,1.5,'',0,1,'R',0);
                                    $s_no++;
                                    $sub_total = $sub_total + $data['amount'];
                                }
                            }
                        }
                        $pdf->SetFont('Arial','B',$font_size);
                        $pdf->SetX(10);
                        // $pdf->SetFillColor(232,232,232);
                        $pdf->SetFillColor(47,79,79);
                        $pdf->Cell(153,4,'Total',0,0,'R',0);
                        $pdf->SetX(163);
                        $pdf->Cell(35,4,number_format($sub_total, 2),0,1,'R',0);
                        if(!empty($sub_total)) { 
                            $payable_amounts[] = $sub_total;
                            $overall_total = $overall_total + $sub_total;
                        }
                    }
                }
            }

            $net_total = 0; $net_total = $overall_total;

            if(!empty($promotion_code_discount_value)) {
                $overall_total = $overall_total - $promotion_code_discount_value;
            }

            

            if(empty($packing_charges) && empty($round_off)){
                $pdf->SetY(-30);
            }
            else if(empty($packing_charges)){
                $pdf->SetY(-34);
            }
            else if(empty($round_off)){
                $pdf->SetY(-38);
            }
            else{
                $pdf->SetY(-42);
            }
            

            $pdf->SetFillColor(232,232,232);
            if(!empty($net_total)) {
                $pdf->SetX(10);
                if(!empty($payable_amounts) && count($payable_amounts) > 1) {
                    $payable_amounts = implode(" + ", $payable_amounts);
                    $pdf->Cell(153,4,"(".$payable_amounts.")".'  Net Total',0,0,'R',0);
                }
                else {
                    $pdf->Cell(153,4,'Net Total',0,0,'R',0);
                }
                $pdf->SetX(163);
                $pdf->Cell(35,4,number_format($net_total, 2),0,1,'R',0);
            }

            if(!empty($promotion_code_price) && !empty($promotion_code_discount_value)) {
                $pdf->SetX(10);
                $pdf->Cell(153,4,"Coupon Discount (".$promotion_code_price.")",0,0,'R',0);
                $pdf->SetX(163);
                $pdf->Cell(35,4,"Rs.".number_format($promotion_code_discount_value, 2),0,1,'R',0);

                $pdf->SetX(10);
                $pdf->Cell(153,4,'Total',0,0,'R',0);
                $pdf->SetX(163);
                $pdf->Cell(35,4,"Rs.".number_format($overall_total, 2),0,1,'R',0);
            }

            $packing_charges_value = 0;
            if (strpos($packing_charges, '%') !== false) {
                $packing_charges = trim(str_replace("%", "", $packing_charges));
                $packing_charges_value = ($overall_total * $packing_charges) / 100;
                if(!empty($packing_charges_value)) {
                    $packing_charges_value = number_format($packing_charges_value, 2);
                    $packing_charges_value = trim(str_replace(",", "", $packing_charges_value));
                    $overall_total = $overall_total + $packing_charges_value;
                    $packing_charges = $packing_charges."%";
                }
            }
            else{
                if(!empty($packing_charges)){
                    $packing_charges_value = $packing_charges;
                    $overall_total = $overall_total + $packing_charges_value;
                }
            }

            $round_off_minus = "";
            if(!empty($overall_total)) {	
                $overall_total = $obj->truncate_number($overall_total, 2);
                if (strpos( $overall_total, "." ) !== false) {
                    $pos = strpos($overall_total, ".");
                    $decimal = substr($overall_total, ($pos + 1), strlen($overall_total));
                    $round_off = "";
                    if($decimal != "00") {
                        if(strlen($decimal) == 1) {
                            $decimal = $decimal."0";
                        }
                        if($decimal >= 50) {
                            $round_off = 100 - $decimal;
                            $round_off = trim($round_off);
                            if(strlen($round_off) == 1) {
                                $round_off = '0.0'.$round_off;
                            }
                            else {
                                $round_off = '0.'.$round_off;
                            }
                            $overall_total = str_replace(",", "", $overall_total);
                            $overall_total = $overall_total + $round_off;
                        }
                        else {
                            $round_off = $decimal;
                            $round_off = trim($round_off);
                            if(strlen($round_off) == 1) {
                                $round_off = '0.0'.$round_off;
                            }
                            else {
                                $round_off = '0.'.$round_off;
                            }
                            $overall_total = str_replace(",", "", $overall_total);
                            $overall_total = $overall_total - $round_off;
                            $round_off_minus = "minus";
                        }                                                                
                    }                    
                }
            }

            if(!empty($packing_charges)){
                $pdf->SetX(10);
                $pdf->Cell(153,4,'Packing Charges ( '.$packing_charges.' )',0,0,'R',0);
                $pdf->SetX(163);
                $pdf->Cell(35,4,number_format($packing_charges_value, 2),0,1,'R',0);
            }

            if(!empty($round_off)) {
                $pdf->SetX(10);
                if(!empty($round_off_minus)) {
                    $pdf->Cell(153,4,'Round Off (-)',0,0,'R',0);
                }
                else {
                    $pdf->Cell(153,4,'Round Off',0,0,'R',0);
                }
                $pdf->SetX(163);
                $pdf->Cell(35,4,"Rs.".number_format($round_off, 2),0,1,'R',0);
            }
            
            $pdf->SetX(10);
            $pdf->Cell(15,4,'Total Items',0,0,'L',0);
            $pdf->SetX(27);
            $pdf->Cell(10,4,' : '.$order_count,0,0,'L',0);
            $pdf->SetX(95);
            $pdf->Cell(68,4,'Overall Total',0,0,'R',0);
            $pdf->SetX(163);
            $pdf->Cell(35,4,number_format($overall_total, 2),0,1,'R',0);

            $pdf->Cell(35,3,'',0,1,'R',0);

            $pdf->SetTextColor(255,255,255);
            $pdf->SetFillColor(47,79,79);
            $pdf->SetFont('Arial','B',10);
            $y = $pdf->GetY();
            $pdf->Cell(188,5,'',0,1,'L',1);
            $pdf->SetY($y);
            $pdf->SetFont('Arial','B',7);
            $pdf->Cell(188,5,'Thanks, Should you have any doubts concerning this Estimate, please contact us.',0,1,'C',0);
            
            

            $pdf->SetY(-7);
            $pdf->SetFont('Arial','I',7);
            $pdf->SetTextColor(0,0,0);
            if($pdf->PageNo()!="1"){
                $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);
            }
        }
        else{
            $pdf = new FPDF('P','mm','A5');
            $pdf->AliasNbPages(); 
            $pdf->AddPage();
            $pdf->SetAutoPageBreak(true);
            $pdf->SetTitle('Estimate Report');
            
            $pdf->SetY(3);
            $pdf->SetX(90);
            $pdf->SetFont('Arial','B',11);
            $pdf->SetTextColor(47,79,79);
            $pdf->Cell(0,6,'Estimate',0,1,'L',0);
            
            $pdf->SetFont('Arial','',8.5);
            $pdf->SetTextColor(0,0,0);
            $pdf->SetX(90);
            $pdf->Cell(0,4,'Date                        : '.date("d-m-Y", strtotime($order_date)),0,1,'L',0);
            $pdf->SetX(90);
            $pdf->Cell(0,4,'Estimate Number    : '.$order_number,0,1,'L',0);
        
            $pdf->SetY(3);
            $pdf->SetFont('Arial','B',15);
            $pdf->SetTextColor(47,79,79);
            if(!empty($company_name)){
                $pdf->Cell(0,6,strtoupper($company_name),0,1,'L',0);
            }
            $pdf->SetTextColor(0,0,0);
            $pdf->SetFont('Arial','',8.5);
            if(!empty($company_address)){
                $pdf->MultiCell(50,4,$company_address,0,'L',0);
            }
            if(!empty($company_mobile_number)){
                $pdf->MultiCell(50,4,$company_mobile_number,0,'L',0);
            }
            if(!empty($company_email)){
                $pdf->MultiCell(50,4,$company_email,0,'L',0);
            }
        
            $pdf->SetFont('Arial','B',8.5);
            $pdf->Cell(50,2,'',0,1,'C',0);
            $pdf->SetFillColor(47,79,79);
            $pdf->SetTextColor(255,255,255);
        
            $yaxis = $pdf->GetY();
            $pdf->SetX(10);
            $pdf->Cell(50,8,'Billed To',0,1,'L',1);
        
            $pdf->Cell(50,1,'',0,1,'C',0);
            $pdf->SetFont('Arial','',8.5);
            $pdf->SetTextColor(0,0,0);
            $customer_details1 = "";
            if(!empty($customer_details)){
                $customer_details1 = explode("<br>",$customer_details);
            }
            
            for($i=0;$i<count($customer_details1);$i++){
                $pdf->Cell(0,4,$customer_details1[$i],0,1,'L',0);
            }
            if(!empty($delivery_address)){
                for($i=0;$i<count($delivery_address);$i++){
                    $pdf->Cell(85,3,$delivery_address[$i],0,'L',0);
                }
            }
            $yaxis1=$pdf->GetY();
            
            if(!empty($bank_details)) {
                $pdf->SetY($yaxis);
                $pdf->SetFont('Arial','B',8.5);
                $pdf->SetTextColor(255,255,255);
                $pdf->SetX(90);
                $pdf->Cell(48,8,'Bank Account Details',0,1,'L',1);
            
                $pdf->Cell(50,1,'',0,1,'C',0);
                $pdf->SetFont('Arial','',8.5);
                $pdf->SetTextColor(0,0,0);
                if(!empty($ac_name)) {
                    $pdf->SetX(90);
                    $pdf->Cell(20,4,'A/C Name',0,0,'L',0);
                    $pdf->SetX(107);
                    $pdf->Cell(35,4,' : ',0,0,'L',0);
                    $pdf->SetX(110);
                    $pdf->Cell(35,4,$ac_name,0,1,'L',0);
                }
                if(!empty($ac_number)) {
                    $pdf->SetX(90);
                    $pdf->Cell(0,4,'A/C Number',0,0,'L',0);
                    $pdf->SetX(107);
                    $pdf->Cell(35,4,' : ',0,0,'L',0);
                    $pdf->SetX(110);
                    $pdf->Cell(35,4,$ac_number,0,1,'L',0);
                }
                if(!empty($ac_type)) {
                    $pdf->SetX(90);
                    $pdf->Cell(0,4,'A/C Type',0,0,'L',0);
                    $pdf->SetX(107);
                    $pdf->Cell(35,4,' : ',0,0,'L',0);
                    $pdf->SetX(110);
                    $pdf->Cell(35,4,$ac_type,0,1,'L',0);
                }
                if(!empty($bank_name)) {
                    $pdf->SetX(90);
                    $pdf->Cell(0,4,'Bank Name',0,0,'L',0); 
                    $pdf->SetX(107);
                    $pdf->Cell(35,4,' : ',0,0,'L',0);
                    $pdf->SetX(110);
                    $pdf->MultiCell(40,4,$bank_name,0,'L',0);
                }
                if(!empty($ifsc_code)) {
                    $pdf->SetX(90);
                    $pdf->Cell(0,4,'IFSC Code',0,0,'L',0); 
                    $pdf->SetX(107);
                    $pdf->Cell(35,4,' : ',0,0,'L',0);
                    $pdf->SetX(110);
                    $pdf->Cell(35,4,$ifsc_code,0,1,'L',0);
                }
            }
            $yaxis2 = $pdf->GetY();
            if($yaxis1>$yaxis2){
                $pdf->SetY($yaxis1);
            }
            else{
                $pdf->SetY($yaxis2);
            }
        
            $pdf->Cell(15,2,'',0,1,'L',0);
            $pdf->SetFont('Arial','B',8.5);
            $pdf->SetTextColor(255,255,255);
            $pdf->SetX(10);
            $pdf->Cell(15,8,'S.No',0,0,'L',1);
            $pdf->SetX(24);
            $pdf->Cell(44,8,'Product Code & Name',0,0,'L',1);
            $pdf->SetX(64);
            $pdf->Cell(22,8,'Content',0,0,'L',1);
            $pdf->SetX(85);
            $pdf->Cell(15,8,'Qty',0,0,'L',1);
            $pdf->SetX(98);
            $pdf->Cell(15,8,'Rate',0,0,'R',1);
            $pdf->SetX(112);
            $pdf->Cell(26,8,'Amount',0,1,'R',1);
        
            $pdf->SetTextColor(0,0,0);
            $s_no = 1; $overall_total = 0; $payable_amounts = array();
            if(!empty($discounts)) {
                foreach($discounts as $discount) {
                    if($pdf->GetY()>170){
                        $pdf->SetTextColor(255,255,255);
                        $pdf->SetFillColor(47,79,79);
                        $pdf->SetFont('Arial','BI',7);
                        $pdf->Cell(128,5,'Continued to Page No : '.$pdf->PageNo()+1,0,1,'R',1);
                        $pdf->SetY(-7);
                        $pdf->SetFont('Arial','I',7);
                        $pdf->SetTextColor(0,0,0);
                        $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);
        
                        $pdf->AddPage();
                        $pdf->SetY(3);
                        $pdf->SetX(90);
                        $pdf->SetFont('Arial','B',11);
                        $pdf->SetTextColor(47,79,79);
                        $pdf->Cell(0,6,'Estimate',0,1,'L',0);
                        
                        $pdf->SetFont('Arial','',8.5);
                        $pdf->SetTextColor(0,0,0);
                        $pdf->SetX(90);
                        $pdf->Cell(0,4,'Date                        : '.date("d-m-Y", strtotime($order_date)),0,1,'L',0);
                        $pdf->SetX(90);
                        $pdf->Cell(0,4,'Estimate Number    : '.$order_number,0,1,'L',0);
                    
                        $pdf->SetY(3);
                        $pdf->SetFont('Arial','B',15);
                        $pdf->SetTextColor(47,79,79);
                        if(!empty($company_name)){
                            $pdf->Cell(0,6,strtoupper($company_name),0,1,'L',0);
                        }
                        $pdf->SetTextColor(0,0,0);
                        $pdf->SetFont('Arial','',8.5);
                        if(!empty($company_address)){
                            $pdf->MultiCell(50,4,$company_address,0,'L',0);
                        }
                        if(!empty($company_mobile_number)){
                            $pdf->MultiCell(50,4,$company_mobile_number,0,'L',0);
                        }
                        if(!empty($company_email)){
                            $pdf->MultiCell(50,4,$company_email,0,'L',0);
                        }
                    
                        $pdf->Cell(15,2,'',0,1,'L',0);
                        $pdf->SetFont('Arial','B',8.5);
                        $pdf->SetTextColor(255,255,255);
                        $pdf->SetX(10);
                        $pdf->Cell(15,8,'S.No',0,0,'L',1);
                        $pdf->SetX(24);
                        $pdf->Cell(44,8,'Product Code & Name',0,0,'L',1);
                        $pdf->SetX(64);
                        $pdf->Cell(22,8,'Content',0,0,'L',1);
                        $pdf->SetX(85);
                        $pdf->Cell(15,8,'Qty',0,0,'L',1);
                        $pdf->SetX(98);
                        $pdf->Cell(15,8,'Rate',0,0,'R',1);
                        $pdf->SetX(112);
                        $pdf->Cell(26,8,'Amount',0,1,'R',1);
                    
                        $pdf->SetTextColor(0,0,0);
                        $pdf->SetFillColor(245,245,245);
                        $pdf->SetFont('Arial','',$font_size);
                        $pdf->Cell(0,1,"",0,1,'L',0);
                    }
                    $pdf->Cell(128,1,"",0,1,'L',0);
                    if(!empty($discount)) {
                        $pdf->SetFont('Arial','B',$font_size);
                        // $pdf->SetFillColor(232,232,232);
                        $pdf->SetFillColor(47,79,79);
                        $pdf->SetTextColor(255,255,255);
                        if (strpos($discount, '%') !== false) {
                            $pdf->SetX(10);
                            $pdf->Cell(128,5,$discount." Products",0,1,'L',1);
                        }
                        else {
                            $pdf->SetX(10);
                            $pdf->Cell(128,5,"Rs.".$discount." Products",0,1,'L',1);
                        }
                        $y_axis=$pdf->GetY();
                        $pdf->SetFont('Arial','',$font_size);
                        $pdf->SetFillColor(245,245,245);
                        $pdf->SetTextColor(0,0,0);
                        if(!empty($product_lists)) {
                            $sub_total = 0; $discounted_total = 0; 
                            $yaxis = $pdf->GetY();
                            $pdf-> Cell(0,1,'',0,1,'L',0);
                            foreach($product_lists as $key => $data) {
                                if(!empty($data['discount']) && $data['discount'] == $discount) {
                                    if($pdf->GetY()>170){
                                        $pdf->SetTextColor(255,255,255);
                                        $pdf->SetFillColor(47,79,79);
                                        $pdf->SetFont('Arial','BI',7);
                                        $pdf->Cell(128,5,'Continued to Page No : '.$pdf->PageNo()+1,0,1,'R',1);
                                        $pdf->SetY(-7);
                                        $pdf->SetFont('Arial','I',7);
                                        $pdf->SetTextColor(0,0,0);
                                        $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);
                        
                                        $pdf->AddPage();
                                        $pdf->SetY(3);
                                        $pdf->SetX(90);
                                        $pdf->SetFont('Arial','B',11);
                                        $pdf->SetTextColor(47,79,79);
                                        $pdf->Cell(0,6,'Estimate',0,1,'L',0);
                                        
                                        $pdf->SetFont('Arial','',8.5);
                                        $pdf->SetTextColor(0,0,0);
                                        $pdf->SetX(90);
                                        $pdf->Cell(0,4,'Date                        : '.date("d-m-Y", strtotime($order_date)),0,1,'L',0);
                                        $pdf->SetX(90);
                                        $pdf->Cell(0,4,'Estimate Number    : '.$order_number,0,1,'L',0);
                                    
                                        $pdf->SetY(3);
                                        $pdf->SetFont('Arial','B',15);
                                        $pdf->SetTextColor(47,79,79);
                                        if(!empty($company_name)){
                                            $pdf->Cell(0,6,strtoupper($company_name),0,1,'L',0);
                                        }
                                        $pdf->SetTextColor(0,0,0);
                                        $pdf->SetFont('Arial','',8.5);
                                        if(!empty($company_address)){
                                            $pdf->MultiCell(50,4,$company_address,0,'L',0);
                                        }
                                        if(!empty($company_mobile_number)){
                                            $pdf->MultiCell(50,4,$company_mobile_number,0,'L',0);
                                        }
                                        if(!empty($company_email)){
                                            $pdf->MultiCell(50,4,$company_email,0,'L',0);
                                        }
                                    
                                        $pdf->Cell(15,2,'',0,1,'L',0);
                                        $pdf->SetFont('Arial','B',8.5);
                                        $pdf->SetTextColor(255,255,255);
                                        $pdf->SetX(10);
                                        $pdf->Cell(15,8,'S.No',0,0,'L',1);
                                        $pdf->SetX(24);
                                        $pdf->Cell(44,8,'Product Code & Name',0,0,'L',1);
                                        $pdf->SetX(64);
                                        $pdf->Cell(22,8,'Content',0,0,'L',1);
                                        $pdf->SetX(85);
                                        $pdf->Cell(15,8,'Qty',0,0,'L',1);
                                        $pdf->SetX(98);
                                        $pdf->Cell(15,8,'Rate',0,0,'R',1);
                                        $pdf->SetX(112);
                                        $pdf->Cell(26,8,'Amount',0,1,'R',1);
                                    
                                        $pdf->SetTextColor(0,0,0);
                                        $pdf->SetFillColor(245,245,245);
                                        $pdf->SetFont('Arial','',$font_size);
                                        $pdf->Cell(0,1,"",0,1,'L',0);
                                    }
                                    $y3=$pdf->GetY();
                                    
                                    $pdf->SetX(24);
                                    $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                                    $data['name'] = str_replace("$", '"', $data['name']);
                                    $data['name'] = str_replace("'''", '"', $data['name']);
                                    $data['name'] = stripslashes($data['name']);
                                    $data['name'] = iconv('UTF-8', 'windows-1252', $data['name']);
                                    // $data['name'] = "Ground Chakkar Ashoka Ground Chakkar Ashoka Ground Chakkar Ashoka"; 
                                    if(!empty($data['code']) && $data['code']!='NULL'){
                                        $data['code'] = $obj->encode_decode('decrypt', $data['code']);
                                        $pdf->MultiCell(40,4,$data['code'].' - '.$data['name'],0,'L',1);
                                    }
                                    else{
                                        $pdf->MultiCell(40,4,$data['name'],0,'L',1);
                                    }
                                    $y4 = $pdf->GetY();
        
                                    $height = 0;
                                    if($y3>$y4){
                                        $pdf->SetY($y3);
                                        $height = 4;
                                    }
                                    else{
                                        $pdf->SetY($y4);
                                        $height = $y4-$y3;
                                    }
        
                                    $pdf->SetY($y3);
                                    $pdf->SetX(10);
                                    $pdf->Cell(15,$height,$s_no,0,0,'L',1);
                                    
                                    $pdf->SetX(64);
                                    if(!empty($data['content']) && $data['content']!='NULL'){
                                        $data['content'] = $obj->encode_decode('decrypt', $data['content']);
                                        $pdf->Cell(22,$height,$data['content'],0,0,'L',1);
                                    }
                                    else
                                    {
                                        $pdf->Cell(22,$height,'',0,0,'L',1);
                                    }
                                    $pdf->SetX(85);
                                    $pdf->Cell(15,$height,$data['quantity'],0,0,'L',1);
                                    $pdf->SetX(98);
                                    $pdf->Cell(15,$height,number_format($data['price'], 2),0,0,'R',1);
                                    $pdf->SetX(112);
                                    $pdf->Cell(26,$height,number_format($data['amount'], 2),0,0,'R',1);
                                    $pdf->SetX(138);
                                    $pdf->Cell(5,$height,'',0,1,'R',0);
                                    
                                    $pdf->Cell(0,1.5,'',0,1,'R',0);
                                    $s_no++;
                                    $sub_total = $sub_total + $data['amount'];
                                }
                            }
                            if($pdf->GetY()>160){
                                $pdf->SetTextColor(255,255,255);
                                $pdf->SetFillColor(47,79,79);
                                $pdf->SetFont('Arial','BI',7);
                                $pdf->Cell(128,5,'Continued to Page No : '.$pdf->PageNo()+1,0,1,'R',1);
                                $pdf->SetY(-7);
                                $pdf->SetFont('Arial','I',7);
                                $pdf->SetTextColor(0,0,0);
                                $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);
                
                                $pdf->AddPage();
                                $pdf->SetY(3);
                                $pdf->SetX(90);
                                $pdf->SetFont('Arial','B',11);
                                $pdf->SetTextColor(47,79,79);
                                $pdf->Cell(0,6,'Estimate',0,1,'L',0);
                                
                                $pdf->SetFont('Arial','',8.5);
                                $pdf->SetTextColor(0,0,0);
                                $pdf->SetX(90);
                                $pdf->Cell(0,4,'Date                        : '.date("d-m-Y", strtotime($order_date)),0,1,'L',0);
                                $pdf->SetX(90);
                                $pdf->Cell(0,4,'Estimate Number    : '.$order_number,0,1,'L',0);
                            
                                $pdf->SetY(3);
                                $pdf->SetFont('Arial','B',15);
                                $pdf->SetTextColor(47,79,79);
                                if(!empty($company_name)){
                                    $pdf->Cell(0,6,strtoupper($company_name),0,1,'L',0);
                                }
                                $pdf->SetTextColor(0,0,0);
                                $pdf->SetFont('Arial','',8.5);
                                if(!empty($company_address)){
                                    $pdf->MultiCell(50,4,$company_address,0,'L',0);
                                }
                                if(!empty($company_mobile_number)){
                                    $pdf->MultiCell(50,4,$company_mobile_number,0,'L',0);
                                }
                                if(!empty($company_email)){
                                    $pdf->MultiCell(50,4,$company_email,0,'L',0);
                                }
                            
                                $pdf->Cell(15,2,'',0,1,'L',0);
                                $pdf->SetFont('Arial','B',8.5);
                                $pdf->SetTextColor(255,255,255);
                                $pdf->SetX(10);
                                $pdf->Cell(15,8,'S.No',0,0,'L',1);
                                $pdf->SetX(24);
                                $pdf->Cell(44,8,'Product Code & Name',0,0,'L',1);
                                $pdf->SetX(64);
                                $pdf->Cell(22,8,'Content',0,0,'L',1);
                                $pdf->SetX(85);
                                $pdf->Cell(15,8,'Qty',0,0,'L',1);
                                $pdf->SetX(98);
                                $pdf->Cell(15,8,'Rate',0,0,'R',1);
                                $pdf->SetX(112);
                                $pdf->Cell(26,8,'Amount',0,1,'R',1);
                            
                                $pdf->SetTextColor(0,0,0);
                                $pdf->SetFillColor(245,245,245);
                                $pdf->SetFont('Arial','',$font_size);
                                $pdf->Cell(0,1,"",0,1,'L',0);
                            }
                            if(!empty($sub_total)) {
                                // $pdf->SetFillColor(232,232,232);
                                $pdf->SetFillColor(47,79,79);
                                // $pdf->SetTextColor(255,255,255);
                                $pdf->SetFont('Arial','B',$font_size);
                                if(!empty($discount)){
                                    $pdf->SetX(10);
                                    $pdf->Cell(105,4,'Sub Total',0,0,'R',0);
                                    $pdf->SetX(114);
                                    $pdf->Cell(24,4,number_format($sub_total, 2),0,1,'R',0);
                                }
                                
                                $discount_value = 0;
                                if (strpos($discount, '%') !== false) {
                                    $discount = trim(str_replace("%", "", $discount));
                                    $discount_value = ($sub_total * $discount) / 100;
                                    if(!empty($discount_value)) {
                                        // $discount_value = number_format($discount_value, 2);
                                        $discount_value = trim(str_replace(",", "", $discount_value));
                                        $discount = $discount."%";
                                    }
                                }
                                else {
                                    $discount_value = $discount;
                                    $discount = "Rs.".$discount;
                                }
                                if(!empty($discount_value)) {
                                    $sub_total = $sub_total - $discount_value;
        
                                    $pdf->SetX(10);
                                    $pdf->Cell(105,4,'Discount ( '.$discount.' )',0,0,'R',0);
                                    $pdf->SetX(114);
                                    $pdf->Cell(24,4,number_format($discount_value, 2),0,1,'R',0);
                                }
                                $pdf->SetX(10);
                                $pdf->Cell(105,4,'Total',0,0,'R',0);
                                if(!empty($sub_total)) { 
                                    $payable_amounts[] = $sub_total;
                                    $overall_total = $overall_total + $sub_total;
                                    $pdf->SetX(114);
                                    $pdf->Cell(24,4,number_format($sub_total, 2),0,1,'R',0);
                                }
                                
                            }
                            
                        }
                    }
                    else{
                        
                        $pdf->Cell(128,1,"",0,1,'L',0);
                        $pdf->SetFont('Arial','B',$font_size);
                        $pdf->SetX(10);
                        $pdf->SetTextColor(255,255,255);
                        // $pdf->SetFillColor(232,232,232);
                        $pdf->SetFillColor(47,79,79);
                        $pdf->Cell(128,5,"Net Rate Products",0,1,'L',1);
                        $pdf->SetTextColor(0,0,0);
                        $pdf->SetFont('Arial','',$font_size);
                        if(!empty($product_lists)) {
                            $sub_total = 0; $discounted_total = 0;
                            $y_axis = $pdf->GetY();
                            $pdf-> Cell(0,1,'',0,1,'L',0);
                            $pdf->SetFillColor(245,245,245);
                            foreach($product_lists as $key => $data) {
                                if(empty($data['discount']) && $data['discount'] == $discount) {
                                    if($pdf->GetY()>170){
        
                                        $pdf->SetTextColor(255,255,255);
                                        $pdf->SetFillColor(47,79,79);
                                        $pdf->SetFont('Arial','BI',7);
                                        $pdf->Cell(128,5,'Continued to Page No : '.$pdf->PageNo()+1,0,1,'R',1);
                                        $pdf->SetY(-7);
                                        $pdf->SetFont('Arial','I',7);
                                        $pdf->SetTextColor(0,0,0);
                                        $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);
        
                                        $pdf->AddPage();
                                        $pdf->SetY(3);
                                        $pdf->SetX(90);
                                        $pdf->SetFont('Arial','B',11);
                                        $pdf->SetTextColor(47,79,79);
                                        $pdf->Cell(0,6,'Estimate',0,1,'L',0);
                                        
                                        $pdf->SetFont('Arial','',8.5);
                                        $pdf->SetTextColor(0,0,0);
                                        $pdf->SetX(90);
                                        $pdf->Cell(0,4,'Date                        : '.date("d-m-Y", strtotime($order_date)),0,1,'L',0);
                                        $pdf->SetX(90);
                                        $pdf->Cell(0,4,'Estimate Number    : '.$order_number,0,1,'L',0);
                                    
                                        $pdf->SetY(3);
                                        $pdf->SetFont('Arial','B',15);
                                        $pdf->SetTextColor(47,79,79);
                                        if(!empty($company_name)){
                                            $pdf->Cell(0,6,strtoupper($company_name),0,1,'L',0);
                                        }
                                        $pdf->SetTextColor(0,0,0);
                                        $pdf->SetFont('Arial','',8.5);
                                        if(!empty($company_address)){
                                            $pdf->MultiCell(50,4,$company_address,0,'L',0);
                                        }
                                        if(!empty($company_mobile_number)){
                                            $pdf->MultiCell(50,4,$company_mobile_number,0,'L',0);
                                        }
                                        if(!empty($company_email)){
                                            $pdf->MultiCell(50,4,$company_email,0,'L',0);
                                        }
                                    
                                        $pdf->Cell(15,2,'',0,1,'L',0);
                                        $pdf->SetFont('Arial','B',8.5);
                                        $pdf->SetTextColor(255,255,255);
                                        $pdf->SetX(10);
                                        $pdf->Cell(15,8,'S.No',0,0,'L',1);
                                        $pdf->SetX(24);
                                        $pdf->Cell(44,8,'Product Code & Name',0,0,'L',1);
                                        $pdf->SetX(64);
                                        $pdf->Cell(22,8,'Content',0,0,'L',1);
                                        $pdf->SetX(85);
                                        $pdf->Cell(15,8,'Qty',0,0,'L',1);
                                        $pdf->SetX(98);
                                        $pdf->Cell(15,8,'Rate',0,0,'R',1);
                                        $pdf->SetX(112);
                                        $pdf->Cell(26,8,'Amount',0,1,'R',1);
                                    
                                        $pdf->SetTextColor(0,0,0);
                                        $pdf->SetFillColor(245,245,245);
                                        $pdf->SetFont('Arial','',$font_size);
                                        $pdf->Cell(0,1,"",0,1,'L',0);
                                    }
                                    $y3=$pdf->GetY();
                                    
                                    $pdf->SetX(24);
                                    $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                                    $data['name'] = str_replace("$", '"', $data['name']);
                                    $data['name'] = str_replace("'''", '"', $data['name']);
                                    $data['name'] = stripslashes($data['name']);
                                    $data['name'] = iconv('UTF-8', 'windows-1252', $data['name']);
                                    if(!empty($data['code']) && $data['code']!='NULL'){
                                        $data['code'] = $obj->encode_decode('decrypt', $data['code']);
                                        $pdf->MultiCell(40,4,$data['code'].' - '.$data['name'],0,'L',1);
                                    }
                                    else{
                                        $pdf->MultiCell(40,4,$data['name'],0,'L',1);
                                    }
                                    $y4 = $pdf->GetY();
        
                                    $height = 0;
                                    if($y3>$y4){
                                        $pdf->SetY($y3);
                                        $height = 4;
                                    }
                                    else{
                                        $pdf->SetY($y4);
                                        $height = $y4-$y3;
                                    }
        
                                    $pdf->SetY($y3);
                                    $pdf->SetX(10);
                                    $pdf->Cell(15,$height,$s_no,0,0,'L',1);
                                    
                                    $pdf->SetX(64);
                                    if(!empty($data['content']) && $data['content']!='NULL'){
                                        $data['content'] = $obj->encode_decode('decrypt', $data['content']);
                                        $pdf->Cell(22,$height,$data['content'],0,0,'L',1);
                                    }
                                    else
                                    {
                                        $pdf->Cell(22,$height,'',0,0,'L',1);
                                    }
                                    $pdf->SetX(85);
                                    $pdf->Cell(15,$height,$data['quantity'],0,0,'L',1);
                                    $pdf->SetX(98);
                                    $pdf->Cell(15,$height,number_format($data['price'], 2),0,0,'R',1);
                                    $pdf->SetX(112);
                                    $pdf->Cell(26,$height,number_format($data['amount'], 2),0,0,'R',1);
                                    $pdf->SetX(138);
                                    $pdf->Cell(5,$height,'',0,1,'R',0);
                                    
                                    $pdf->Cell(0,1.5,'',0,1,'R',0);
                                    $s_no++;
                                    $sub_total = $sub_total + $data['amount'];
                                }
                            }
                        }
                        $pdf->SetFont('Arial','B',$font_size);
                        $pdf->SetX(10);
                        // $pdf->SetFillColor(232,232,232);
                        $pdf->SetFillColor(47,79,79);
                        $pdf->Cell(153,4,'Total',0,0,'R',0);
                        $pdf->SetX(163);
                        $pdf->Cell(35,4,number_format($sub_total, 2),0,1,'R',0);
                        if(!empty($sub_total)) { 
                            $payable_amounts[] = $sub_total;
                            $overall_total = $overall_total + $sub_total;
                        }
                    }
                }
            }
        
            $net_total = 0; $net_total = $overall_total;

            if(!empty($promotion_code_discount_value)) {
                $overall_total = $overall_total - $promotion_code_discount_value;
            }
        
            
            
            if(empty($packing_charges) && empty($round_off)){
                $pdf->SetY(-25);
            }
            else if(empty($packing_charges)){
                $pdf->SetY(-30);
            }
            else if(empty($round_off)){
                $pdf->SetY(-34);
            }
            else{
                $pdf->SetY(-38);
            }
            
        
            $pdf->SetFillColor(232,232,232);
            if(!empty($net_total)) {
                $pdf->SetX(10);
                if(!empty($payable_amounts) && count($payable_amounts) > 1) {
                    $payable_amounts = implode(" + ", $payable_amounts);
                    $pdf->Cell(105,4,"(".$payable_amounts.")".'  Net Total',0,0,'R',0);
                }
                else {
                    $pdf->Cell(105,4,'Net Total',0,0,'R',0);
                }
                $pdf->SetX(115);
                $pdf->Cell(24,4,number_format($net_total, 2),0,1,'R',0);
            }

            if(!empty($promotion_code_price) && !empty($promotion_code_discount_value)) {
                $pdf->SetX(10);
                $pdf->Cell(105,4,"Coupon Discount (".$promotion_code_price.")",0,0,'R',0);
                $pdf->SetX(115);
                $pdf->Cell(24,4,"Rs.".number_format($promotion_code_discount_value, 2),0,1,'R',0);

                $pdf->SetX(10);
                $pdf->Cell(105,4,'Total',0,0,'R',0);
                $pdf->SetX(115);
                $pdf->Cell(24,4,"Rs.".number_format($overall_total, 2),0,1,'R',0);
            }
        
            $packing_charges_value = 0;
            if (strpos($packing_charges, '%') !== false) {
                $packing_charges = trim(str_replace("%", "", $packing_charges));
                $packing_charges_value = ($overall_total * $packing_charges) / 100;
                if(!empty($packing_charges_value)) {
                    $packing_charges_value = number_format($packing_charges_value, 2);
                    $packing_charges_value = trim(str_replace(",", "", $packing_charges_value));
                    $overall_total = $overall_total + $packing_charges_value;
                    $packing_charges = $packing_charges."%";
                }
            }
            else{
                if(!empty($packing_charges)){
                    $packing_charges_value = $packing_charges;
                    $overall_total = $overall_total + $packing_charges_value;
                }
            }

            $round_off_minus = "";
            if(!empty($overall_total)) {	
                $overall_total = $obj->truncate_number($overall_total, 2);
                if (strpos( $overall_total, "." ) !== false) {
                    $pos = strpos($overall_total, ".");
                    $decimal = substr($overall_total, ($pos + 1), strlen($overall_total));
                    $round_off = "";
                    if($decimal != "00") {
                        if(strlen($decimal) == 1) {
                            $decimal = $decimal."0";
                        }
                        if($decimal >= 50) {
                            $round_off = 100 - $decimal;
                            if(!empty($round_off) && $round_off < 10) {
                                $round_off = "0.0".$round_off;
                            }
                            else {
                                $round_off = "0.".$round_off;
                            }
                            $overall_total = str_replace(",", "", $overall_total);
                            $overall_total = $overall_total + $round_off;
                        }
                        else {
                            $round_off = $decimal;
                            if(!empty($round_off) && $round_off < 10) {
                                $round_off = "0.0".$round_off;
                            }
                            else {
                                $round_off = "0.".$round_off;
                            }
                            $overall_total = str_replace(",", "", $overall_total);
                            $overall_total = $overall_total - $round_off;
                            $round_off_minus = "minus";
                        }                                                                
                    }                    
                }
            }
            
            if(!empty($packing_charges)){
                $pdf->SetX(10);
                $pdf->Cell(105,4,'Packing Charges ( '.$packing_charges.' )',0,0,'R',0);
                $pdf->SetX(115);
                $pdf->Cell(24,4,number_format($packing_charges_value, 2),0,1,'R',0);
            }
        
            if(!empty($round_off)) {
                $pdf->SetX(10);
                if(!empty($round_off_minus)) {
                    $pdf->Cell(105,4,'Round Off (-)',0,0,'R',0);
                }
                else {
                    $pdf->Cell(105,4,'Round Off',0,0,'R',0);
                }
                $pdf->SetX(115);
                $pdf->Cell(24,4,"Rs.".number_format($round_off, 2),0,1,'R',0);
            }
            
            $pdf->SetX(10);
            $pdf->Cell(15,4,'Total Items',0,0,'L',0);
            $pdf->SetX(27);
            $pdf->Cell(10,4,' : '.$order_count,0,0,'L',0);
            $pdf->SetX(95);
            $pdf->Cell(20,4,'Overall Total',0,0,'R',0);
            $pdf->SetX(115);
            $pdf->Cell(24,4,number_format($overall_total, 2),0,1,'R',0);
        
            $pdf->Cell(128,2,'',0,1,'L',0);
            $pdf->SetTextColor(255,255,255);
            $pdf->SetFillColor(47,79,79);
            $pdf->SetFont('Arial','B',10);
            $y = $pdf->GetY();
            $pdf->Cell(128,5,'',0,1,'L',1);
            $pdf->SetY($y);
            // $pdf->Cell(128,5,'Thank you for your Business!',0,1,'C',0);
            $pdf->SetFont('Arial','B',7);
            $pdf->Cell(128,5,'Thanks, Should you have any doubts concerning this Estimate, please contact us.',0,1,'C',0);
            
            
        
            $pdf->SetY(-7);
            $pdf->SetFont('Arial','I',7);
            $pdf->SetTextColor(0,0,0);
            if($pdf->PageNo()!="1"){
                $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);
            }
            
        }
        
    }

    $pdf->Output('','estimate_bill.pdf');
?>