

CREATE TABLE `sgc_2023_category` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `category_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `ordering` int(11) NOT NULL,
  `show_frontend` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO sgc_2023_category (id, created_date_time, creator, creator_name, category_id, name, lower_case_name, ordering, show_frontend, deleted) VALUES ('1','2023-08-10 15:39:22','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039','554539714d6c6c5262584a6d4d315a324e557036516c6b775655744a4f576846626e4d34566a6448576c46565655396e596e6c43614652575754303d','4d6d645a4f444e464d316c4565576c6956314e305530744c5458466c54454661613078575a474a4e523030784f48465a6547564c4c7a4242617a303d','1','0','0');

INSERT INTO sgc_2023_category (id, created_date_time, creator, creator_name, category_id, name, lower_case_name, ordering, show_frontend, deleted) VALUES ('2','2023-08-10 15:39:26','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','643068765a585a6a576b526f5a6c5271576d5177526a4135533349305a7a3039','6347633061576b34636a64424b304e7a64446c52534667775a55746b647a3039','5131707063444e76546d633062475648566a4a715233525664324a585a7a3039','2','0','0');

INSERT INTO sgc_2023_category (id, created_date_time, creator, creator_name, category_id, name, lower_case_name, ordering, show_frontend, deleted) VALUES ('3','2023-08-10 15:39:29','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','5233564a516c4a724e57316d5157457756477036556b645a63584a6855543039','565846365356427a4d48687464316479644568744e306c6a61335a3655543039','55484644547a4e75526d704a56554a535246513151323072576d673151543039','3','0','0');

INSERT INTO sgc_2023_category (id, created_date_time, creator, creator_name, category_id, name, lower_case_name, ordering, show_frontend, deleted) VALUES ('4','2023-08-10 15:39:34','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','5648704f4e4646584d6c4a7959793947556d644b4e6d4652574842575a7a3039','62533975526d77725255746b553364684f57526e6147314a53306f7651543039','4f453958555842546343396b57444279546c56424d324e5756465258647a3039','4','0','0');

INSERT INTO sgc_2023_category (id, created_date_time, creator, creator_name, category_id, name, lower_case_name, ordering, show_frontend, deleted) VALUES ('5','2023-08-10 15:39:36','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','62585a53535546446545684e6254553153575132515339715344424e5a7a3039','616b4644596e6c49516c684864565673596e526c566d644d51335648647a3039','64444e464d57397456457335546e466e4f446442626b6f304d6e6b3151543039','5','0','0');

INSERT INTO sgc_2023_category (id, created_date_time, creator, creator_name, category_id, name, lower_case_name, ordering, show_frontend, deleted) VALUES ('6','2023-08-10 15:39:39','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','59325a7362464a4b53556476526d5a3655327470543068774e44453055543039','63573433593078795345463364584e4c4e4463325754464d56475a45647a3039','5533564c567a6c364e584579614549305a46524c56456b324d47314851543039','6','0','0');

INSERT INTO sgc_2023_category (id, created_date_time, creator, creator_name, category_id, name, lower_case_name, ordering, show_frontend, deleted) VALUES ('7','2023-08-10 15:39:44','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','65574a75636b52554d6c7056547a51315433644b4f55707a626b567a55543039','526d354e4e6c5a56516d4e6b4f476b7a4e7a6b7a63314e6e525373345a7a3039','526e52725a456c7664306732626d39775656644a4c7a645465576c4455543039','7','0','0');

INSERT INTO sgc_2023_category (id, created_date_time, creator, creator_name, category_id, name, lower_case_name, ordering, show_frontend, deleted) VALUES ('8','2023-08-10 15:39:46','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','6130464963455a75544852455255524664455a31546d3872636e41345a7a3039','63576f304d6d68565a6e6c4f52585645626d746864454a436254686e61533953516d777862577448544646735232744353446861566c51775354303d','51574a6a51326f78656b465a5645527952464274646c68575233426a64584278556b78574c33567657554a71614756494e54524e5a45644a5354303d','8','0','0');

INSERT INTO sgc_2023_category (id, created_date_time, creator, creator_name, category_id, name, lower_case_name, ordering, show_frontend, deleted) VALUES ('9','2023-08-10 15:39:48','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','596a5234553251314d58686d616e5271563256764f466c4b627a4978647a3039','576b784c4d3234795744684b5a6b5644563264744d6a55794f544e5551543039','566e6b35556d5676625464584d306871614531424f576c5556456f77647a3039','9','0','0');

INSERT INTO sgc_2023_category (id, created_date_time, creator, creator_name, category_id, name, lower_case_name, ordering, show_frontend, deleted) VALUES ('10','2023-08-10 15:39:51','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','526d6c305557637865573954556e4e53595668695a6e6849644642725a7a3039','5746684c556b7473596d39354c303133555374475357643654476c485754564a563031315554464957586376656e4a6955693956546d5279597a303d','4f584e43566a644e4c3035724d58704861317036566a5a7959306c74526a5935616a4e6a54486c716345686a636e6c48536b393151316c5a597a303d','10','0','0');

INSERT INTO sgc_2023_category (id, created_date_time, creator, creator_name, category_id, name, lower_case_name, ordering, show_frontend, deleted) VALUES ('11','2023-08-10 15:39:57','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','5a314e544e793949646b637952564644636a4a505648687a566c563351543039','4f57644f556b52364e4468506545465055444d354d47746d6448423255543039','61485a6c557a686f515573774e315a3362457049555774345133553151543039','11','0','0');

INSERT INTO sgc_2023_category (id, created_date_time, creator, creator_name, category_id, name, lower_case_name, ordering, show_frontend, deleted) VALUES ('12','2023-08-10 15:40:00','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4f566c585a32355959555268615646615a33704e656a64764d6e6c765a7a3039','4e6c673362546c55626c705255306c7a6154564a536c424b5332683351543039','656d643263584976634856595754464563334257613056324b306835647a3039','12','0','0');

INSERT INTO sgc_2023_category (id, created_date_time, creator, creator_name, category_id, name, lower_case_name, ordering, show_frontend, deleted) VALUES ('13','2023-08-10 15:40:04','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','527a56454e6e4242593263725630464d613252504e487034643230345a7a3039','4f47526c5132354764326b324f484e714d6d4a7a656d4a534d557455647a3039','4f537436656a464a64537475626e644753464e6a65585a316157683251543039','13','0','0');

INSERT INTO sgc_2023_category (id, created_date_time, creator, creator_name, category_id, name, lower_case_name, ordering, show_frontend, deleted) VALUES ('14','2023-08-10 15:40:11','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','636b394e4e3170754d7a56565a6b4a4652325a6e625868306543743451543039','656e52545a6a6334535746705a465253513039524e335a455232313656465675556d5a5864323830624574445a444e5a5954423364454677637a303d','4b3039725332593561316c4854566858624567774b33424a646b74324d537430637a4654626d74755a5339505a485278616b524b556c56475354303d','14','0','0');

INSERT INTO sgc_2023_category (id, created_date_time, creator, creator_name, category_id, name, lower_case_name, ordering, show_frontend, deleted) VALUES ('15','2023-08-10 15:40:17','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4d6d4e6b596d564c595845785757633157575a344d304a6c59315a715a7a3039','576d684b5454523462587069544535324d444a5362693949626d3835646a5a735955687464466f3462316777536b7072567a526a4f445a685354303d','64576c3261486448645468426154553255577072634374596231524f53445650534446505256493561474e4c5a47316d4b7a6854623235465a7a303d','15','0','0');

INSERT INTO sgc_2023_category (id, created_date_time, creator, creator_name, category_id, name, lower_case_name, ordering, show_frontend, deleted) VALUES ('16','2023-08-10 15:40:24','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','545531426432646e4e457869636c5a485a307444576c4e484d544e495a7a3039','5330777a576d74565a58566a53334a46645564425155467854316c736231637a556c5249536d5233626b4d7a614864774e5530345a7a45795a7a303d','524664505a446856553064534e3046755644526f62454a48563231485332704359546c746344686c616a646c656c5a4b5357705a4e554a4f5554303d','16','0','0');

INSERT INTO sgc_2023_category (id, created_date_time, creator, creator_name, category_id, name, lower_case_name, ordering, show_frontend, deleted) VALUES ('17','2023-08-10 15:40:34','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','635552445a546c79616d7035564568425357314b4b3155774d30647555543039','5630733554485a74636c467862573877556c42594f474e735a306442616d4e554e455976513368776545646f4e7a4a4754465a6f62455978617a303d','526d6c735156525754586c324d586c496244633263307473534778554e6b7034575773765255686c4e554668543031785a6e6c4e5a6b64525454303d','17','0','0');

INSERT INTO sgc_2023_category (id, created_date_time, creator, creator_name, category_id, name, lower_case_name, ordering, show_frontend, deleted) VALUES ('18','2023-08-10 15:40:45','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','556e464b4e335179516c42455a6e5a68525568496244684a51306c735a7a3039','526c425163316f3057555572615670524e45777253314e49574739724e485a4263335a526231646c54433959526b4a6d5a57524f4b305a73637a303d','5a32744d574463794e3342514e6d63776247785264544a485130686d526d6c6a556d5a76566a424a556c6c51536b6b325653393664476471597a303d','18','0','0');

INSERT INTO sgc_2023_category (id, created_date_time, creator, creator_name, category_id, name, lower_case_name, ordering, show_frontend, deleted) VALUES ('19','2023-08-10 15:40:55','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','51305249535668615a46524b52304a4a64564e74554664335a6c4e4755543039','526d526d52564278643277326556425a4f454d76537a6c5a6544424b62466878556b387252464e744d7a45304e6a64795444526c53323949647a303d','4e556379614570425453746c526a41726444646d5755784f64306857626e6b72536b5230563368684e456c735643744462576430616b68615754303d','19','0','0');

INSERT INTO sgc_2023_category (id, created_date_time, creator, creator_name, category_id, name, lower_case_name, ordering, show_frontend, deleted) VALUES ('20','2023-08-10 15:41:07','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','64466776565446705a316b7a5330557a51555a3559546b325256527351543039','4d6c6454556b39315258704a546a59336133646e63444278625538785a6d396c54473835515670325a303832636e64766255786a565468715454303d','5553394962554d35616e4a6e5a47686b54473170557a52765a557454616a526d4d6c684a515768525258566d546c51344b7973724b304a735654303d','20','0','0');

INSERT INTO sgc_2023_category (id, created_date_time, creator, creator_name, category_id, name, lower_case_name, ordering, show_frontend, deleted) VALUES ('21','2023-08-10 15:41:10','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','5545316c4d55564464586b7a64324e4a616a526c52584530513141305a7a3039','4d45646b5a6a4a314c7a417a5655316a5a7938314f544177544852306333684c535374314d32684f556a4e314f455a7154464a6a596b35525a7a303d','62586c44576e70716357526f563270336433527852564e5854544e4d5a484e514c3046514e306c34634774595a6e4a57555852525a324e445a7a303d','21','0','0');

INSERT INTO sgc_2023_category (id, created_date_time, creator, creator_name, category_id, name, lower_case_name, ordering, show_frontend, deleted) VALUES ('22','2023-08-10 15:41:23','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','576a4643563246724d6e4e786346424855457331513031774e6a564355543039','56553472556b464c61545651526d73326358685a5230687956324a5055543039','22','0','0');


CREATE TABLE `sgc_2023_company` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `company_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `logo` mediumtext NOT NULL,
  `address` mediumtext NOT NULL,
  `contact_numbers` mediumtext NOT NULL,
  `whatsapp_number` mediumtext NOT NULL,
  `call_us_number` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `email` mediumtext NOT NULL,
  `ac_name` mediumtext NOT NULL,
  `ac_number` mediumtext NOT NULL,
  `ac_type` mediumtext NOT NULL,
  `bank_name` mediumtext NOT NULL,
  `ifsc_code` mediumtext NOT NULL,
  `running_text` mediumtext NOT NULL,
  `running_text_color` mediumtext NOT NULL,
  `running_text_back_color` mediumtext NOT NULL,
  `running_text_duration` mediumtext NOT NULL,
  `order_prefix` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO sgc_2023_company (id, created_date_time, creator, creator_name, company_id, name, logo, address, contact_numbers, whatsapp_number, call_us_number, mobile_number, email, ac_name, ac_number, ac_type, bank_name, ifsc_code, running_text, running_text_color, running_text_back_color, running_text_duration, order_prefix, deleted) VALUES ('1','2023-06-28 09:35:45','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','56334d7a626e6450526c6c7a636a4a425132563552484e4c625552335647317865574e3553316c305546593257454e5255326f764c336877627a303d','64336c445a486f354d6d355453464d30556c6f3451306476645442725a7a3039','565567346144647a646e426d4b7974615a7a46794e4534775a314248555570575656425161466b78536b3549554578486257646959554a6a5654303d','logo_16_10_2023_11_25_05.webp','5a5770364b33564e52314a696245397263485a3055456869545663776256423061444578546e4a684b3264304e465659626a6376637a464c52476b784e335a76616d59795a45357164553570596e5252576d6b7a63584d7956456830656c7057596d39565a6a4132655868445a33466b4e314e5365575530566e5a475555465253545a3463485a5857575976525764686431527861546c47566a68424e6c4a4d55304e70624452715958493d','4b335a685333566d5755356e6430466857444247516b4a6c4c3145324e7a646c4c325a326348704c555770464e6b394b52326c6d635745335754303d','53576873546a42545355467462336f355355565962477332624570715a7a3039','65584e31557973785a7a4576553145356543746b616a557965545172647a3039','53576873546a42545355467462336f355355565962477332624570715a7a3039','646b5630546c5659546c6730576d685062324a70523368744d7a5657613235696254565555697458566b74784e6b6f77516c704f52457443597a303d','NULL','NULL','NULL','NULL','NULL','596c6434615456455a6e4d35526e4673634539334c30355159544134617a4a445a4442555a57706d4d4535794e316c485a6a4632546d31795a564135576d70705331637a4e43393563324673596b5a555258704655567046526c68546131564a55454a77545846776455747a543359355645524d5457685855575269537a5a574f55314b5445783263577845556e633257475a4d545339776548686853554e49656e637952324a5953566835616b597252564e724f454e585a6d6c3663544e57596c56484b3149724d545a5a6445677865486c57536c637a65554978526b64734d6d786a50513d3d','#ffffff','#dd1f21','12000','53485a4c5657593065544d3264485a535a6a427665475a7063484930647a3039','0');


CREATE TABLE `sgc_2023_customer` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `customer_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `email` mediumtext NOT NULL,
  `address` mediumtext NOT NULL,
  `city` mediumtext NOT NULL,
  `state` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO sgc_2023_customer (id, created_date_time, creator, creator_name, customer_id, name, mobile_number, email, address, city, state, deleted) VALUES ('1','2023-08-12 10:42:24','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','576b4a46556b354e526b34724f5868736346493262564e6b53485a3551543039','5a324576536e6c70566b34355458427054327848566b4e775130394955543039','4d304e565954677a5257787a63323536643031754e48687751546c4b5a7a3039','NULL','4c7a6c54566d7843624531685a5339344e47705064453170516a6c54647a3039','59576b30616e52426345673353316c4d546b78795a33704e616b3830647a3039','656b4a7956476f344e6a42685132357057546c73626e466e5647703051543039','0');

INSERT INTO sgc_2023_customer (id, created_date_time, creator, creator_name, customer_id, name, mobile_number, email, address, city, state, deleted) VALUES ('2','2023-08-12 12:47:19','4f57686e596e64724d797443557a5672636b317153474978596a6450647a3039','5a324576536e6c70566b34355458427054327848566b4e775130394955543039','4f57686e596e64724d797443557a5672636b317153474978596a6450647a3039','5a324576536e6c70566b34355458427054327848566b4e775130394955543039','64324a4b6353744955307377636d3972636974586358704b566d52585a7a3039','NULL','4c304e6961576c7161586772533368525233684e54586873546b77725a6b4d79626d5a506157706e656d4533565852344e5842315a6b5a504e44303d','59576b30616e52426345673353316c4d546b78795a33704e616b3830647a3039','656b4a7956476f344e6a42685132357057546c73626e466e5647703051543039','0');

INSERT INTO sgc_2023_customer (id, created_date_time, creator, creator_name, customer_id, name, mobile_number, email, address, city, state, deleted) VALUES ('3','2023-10-14 11:20:42','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','65484e304c304e6b543355305954557a62564e36564339694c304a4d5a7a3039','5332315554544e594e6e644c6357457a556e5676593352534c79746155543039','62586334596a46534d6a465a4e474e3156586333636b4934515856615a7a3039','NULL','4c33517955325a33566d744b53446c4a613252544f585656595535585a7a3039','59576b30616e52426345673353316c4d546b78795a33704e616b3830647a3039','656b4a7956476f344e6a42685132357057546c73626e466e5647703051543039','0');


CREATE TABLE `sgc_2023_discount` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `discount_id` mediumtext NOT NULL,
  `discount` int(100) NOT NULL,
  `category_ids` mediumtext NOT NULL,
  `show_frontend` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO sgc_2023_discount (id, created_date_time, creator, creator_name, discount_id, discount, category_ids, show_frontend, deleted) VALUES ('1','2023-08-11 09:34:45','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','656a4a5552335657626c52504e456c6a6145526d59577051526b34305a7a3039','80','537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039,643068765a585a6a576b526f5a6c5271576d5177526a4135533349305a7a3039,5233564a516c4a724e57316d5157457756477036556b645a63584a6855543039,5648704f4e4646584d6c4a7959793947556d644b4e6d4652574842575a7a3039,62585a53535546446545684e6254553153575132515339715344424e5a7a3039,59325a7362464a4b53556476526d5a3655327470543068774e44453055543039,65574a75636b52554d6c7056547a51315433644b4f55707a626b567a55543039,6130464963455a75544852455255524664455a31546d3872636e41345a7a3039,596a5234553251314d58686d616e5271563256764f466c4b627a4978647a3039,526d6c305557637865573954556e4e53595668695a6e6849644642725a7a3039,5a314e544e793949646b637952564644636a4a505648687a566c563351543039,4f566c585a32355959555268615646615a33704e656a64764d6e6c765a7a3039,636b394e4e3170754d7a56565a6b4a4652325a6e625868306543743451543039,4d6d4e6b596d564c595845785757633157575a344d304a6c59315a715a7a3039,545531426432646e4e457869636c5a485a307444576c4e484d544e495a7a3039,635552445a546c79616d7035564568425357314b4b3155774d30647555543039,556e464b4e335179516c42455a6e5a68525568496244684a51306c735a7a3039,51305249535668615a46524b52304a4a64564e74554664335a6c4e4755543039,64466776565446705a316b7a5330557a51555a3559546b325256527351543039,5545316c4d55564464586b7a64324e4a616a526c52584530513141305a7a3039','0','0');


CREATE TABLE `sgc_2023_enquiry_customer` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `customer_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `login` int(100) NOT NULL,
  `login_details` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO sgc_2023_enquiry_customer (id, created_date_time, customer_id, name, mobile_number, login, login_details, deleted) VALUES ('1','2023-08-12 12:29:11','51573570566e427054486c6a616d5533646c643655325642556d30334b30354454305934643151794c335659576d526e4e544e3559334277617a303d','57465648614668504e3231764e305a35516e6c714f47704261455247647a3039','51304a455330686859553979544452474d586c70576b68314d6a643351543039','0','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','0');


CREATE TABLE `sgc_2023_home_banner` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `home_banner_id` mediumtext NOT NULL,
  `home_banner` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `sgc_2023_login` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `login_date_time` datetime NOT NULL,
  `logout_date_time` datetime NOT NULL,
  `ip_address` mediumtext NOT NULL,
  `browser` mediumtext NOT NULL,
  `os_detail` mediumtext NOT NULL,
  `type` mediumtext NOT NULL,
  `user_id` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO sgc_2023_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id) VALUES ('1','2023-08-10 15:36:51','2023-08-10 15:42:51','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/116.0','Windows NT DESKTOP-1O194FK 10.0 build 22621 (Windows 11) AMD64','Super Admin','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039');

INSERT INTO sgc_2023_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id) VALUES ('2','2023-08-10 17:16:03','2023-08-10 17:16:07','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/116.0','Windows NT DESKTOP-1O194FK 10.0 build 22621 (Windows 11) AMD64','Super Admin','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039');

INSERT INTO sgc_2023_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id) VALUES ('3','2023-08-11 09:28:06','2023-08-11 09:47:19','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/116.0','Windows NT DESKTOP-1O194FK 10.0 build 22621 (Windows 11) AMD64','Super Admin','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039');

INSERT INTO sgc_2023_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id) VALUES ('4','2023-08-12 09:50:01','2023-08-12 09:50:13','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/116.0','Windows NT DESKTOP-1O194FK 10.0 build 22621 (Windows 11) AMD64','Super Admin','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039');

INSERT INTO sgc_2023_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id) VALUES ('5','2023-08-12 10:22:22','2023-08-12 10:22:56','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/116.0','Windows NT DESKTOP-1O194FK 10.0 build 22621 (Windows 11) AMD64','Super Admin','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039');

INSERT INTO sgc_2023_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id) VALUES ('6','2023-08-12 10:41:58','2023-08-12 10:45:31','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/116.0','Windows NT DESKTOP-1O194FK 10.0 build 22621 (Windows 11) AMD64','Super Admin','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039');

INSERT INTO sgc_2023_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id) VALUES ('7','2023-08-12 12:26:54','0000-00-00 00:00:00','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/116.0','Windows NT DESKTOP-1O194FK 10.0 build 22621 (Windows 11) AMD64','Super Admin','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039');

INSERT INTO sgc_2023_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id) VALUES ('8','2023-08-12 12:59:44','2023-08-12 13:36:58','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/116.0','Windows NT DESKTOP-1O194FK 10.0 build 22621 (Windows 11) AMD64','Super Admin','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039');

INSERT INTO sgc_2023_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id) VALUES ('9','2023-08-12 14:44:03','2023-08-12 15:56:02','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/116.0','Windows NT DESKTOP-1O194FK 10.0 build 22621 (Windows 11) AMD64','Super Admin','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039');

INSERT INTO sgc_2023_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id) VALUES ('10','2023-08-12 15:16:25','2023-08-12 15:43:32','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/116.0','Windows NT DESKTOP-1O194FK 10.0 build 22621 (Windows 11) AMD64','Staff','517a67784d6e6c534e6b314e636a644765456b32554556494d6a5646647a3039');

INSERT INTO sgc_2023_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id) VALUES ('11','2023-08-14 11:46:20','0000-00-00 00:00:00','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/116.0','Windows NT DESKTOP-1O194FK 10.0 build 22621 (Windows 11) AMD64','Super Admin','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039');

INSERT INTO sgc_2023_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id) VALUES ('12','2023-10-14 11:19:57','0000-00-00 00:00:00','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/118.0','Windows NT DESKTOP-RC16R56 10.0 build 19045 (Windows 10) AMD64','Super Admin','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039');

INSERT INTO sgc_2023_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id) VALUES ('13','2023-10-16 11:21:39','0000-00-00 00:00:00','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/118.0','Windows NT DESKTOP-RC16R56 10.0 build 19045 (Windows 10) AMD64','Super Admin','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039');

INSERT INTO sgc_2023_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id) VALUES ('14','2023-10-20 10:38:23','2023-10-20 10:39:05','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/118.0','Windows NT DESKTOP-1O194FK 10.0 build 22621 (Windows 11) AMD64','Super Admin','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039');

INSERT INTO sgc_2023_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id) VALUES ('15','2023-10-20 10:39:46','0000-00-00 00:00:00','127.0.0.1','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/118.0','Windows NT DESKTOP-1O194FK 10.0 build 22621 (Windows 11) AMD64','Super Admin','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039');


CREATE TABLE `sgc_2023_mobile_banner` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `mobile_banner_id` mediumtext NOT NULL,
  `mobile_banner` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `sgc_2023_order_notification_send` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `notification_id` mediumtext NOT NULL,
  `fcm_ids` mediumtext NOT NULL,
  `send_date_time` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `sgc_2023_orders` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `order_id` mediumtext NOT NULL,
  `order_type` mediumtext NOT NULL,
  `order_number` mediumtext NOT NULL,
  `order_date` date NOT NULL,
  `company_details` mediumtext NOT NULL,
  `bank_details` mediumtext NOT NULL,
  `customer_id` mediumtext NOT NULL,
  `customer_details` mediumtext NOT NULL,
  `customer_city` mediumtext NOT NULL,
  `delivery_address` mediumtext NOT NULL,
  `category_id` mediumtext NOT NULL,
  `category_name` mediumtext NOT NULL,
  `product_id` mediumtext NOT NULL,
  `product_code` mediumtext NOT NULL,
  `product_name` mediumtext NOT NULL,
  `product_content` mediumtext NOT NULL,
  `quantity` mediumtext NOT NULL,
  `actual_price` mediumtext NOT NULL,
  `price` mediumtext NOT NULL,
  `discount` mediumtext NOT NULL,
  `extra_discount` mediumtext NOT NULL,
  `show_extra_discount_amount` int(100) NOT NULL,
  `minimum_order_amount` mediumtext NOT NULL,
  `packing_charges` mediumtext NOT NULL,
  `promotion_code_id` mediumtext NOT NULL,
  `promotion_code_name` mediumtext NOT NULL,
  `promotion_code_price` mediumtext NOT NULL,
  `promotion_code_discount_value` mediumtext NOT NULL,
  `otp_number` mediumtext NOT NULL,
  `total_amount` mediumtext NOT NULL,
  `new_order` int(100) NOT NULL,
  `confirmed` int(100) NOT NULL,
  `despatched` int(100) NOT NULL,
  `delivered` int(100) NOT NULL,
  `push_notification` int(100) NOT NULL,
  `delivery_number` mediumtext NOT NULL,
  `delivery_particulars` mediumtext NOT NULL,
  `delivery_photo` mediumtext NOT NULL,
  `send_sms_email` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO sgc_2023_orders (id, created_date_time, creator, creator_name, order_id, order_type, order_number, order_date, company_details, bank_details, customer_id, customer_details, customer_city, delivery_address, category_id, category_name, product_id, product_code, product_name, product_content, quantity, actual_price, price, discount, extra_discount, show_extra_discount_amount, minimum_order_amount, packing_charges, promotion_code_id, promotion_code_name, promotion_code_price, promotion_code_discount_value, otp_number, total_amount, new_order, confirmed, despatched, delivered, push_notification, delivery_number, delivery_particulars, delivery_photo, send_sms_email, deleted) VALUES ('1','2023-08-12 10:43:02','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','63306378614756335132787555456c7455303555636a4d7a6258525855543039','57564270546d4658646d4933633031534e334279645764455931683055543039','4f48557954474a724f557857626b5646575339545330315862306f3151543039','2023-08-12','574442494c32564962474e56544751355a544e49596e4a6a4e6b68445132645563573134526974564b7a684f614668524d4734796132396153486c50617a4e356346566c52486856656b563456336471555746566230524c6156493052793936516d6c5a5456687255465a594e6d4a35564768525658684d61446c4854546c55563342494e315a5a64445a5363314a484d57684e52457869616b7444576c68355456426e525468615555513d','','576b4a46556b354e526b34724f5868736346493262564e6b53485a3551543039','625539314d6b6334526c70736231706e63576c424d6e4649545668584f48426c596a46466444683263565a7a4e466c6154484a3065566c70597a303d','59576b30616e52426345673353316c4d546b78795a33704e616b3830647a3039','57586848536d35316130354359315a774d314a72534739574b7a4e505154497a4d7a4a7857454a5256454d79556c55335557703559556c31647a303d','4d6d4e6b596d564c595845785757633157575a344d304a6c59315a715a7a3039,636b394e4e3170754d7a56565a6b4a4652325a6e625868306543743451543039,4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','576d684b5454523462587069544535324d444a5362693949626d3835646a5a735955687464466f3462316777536b7072567a526a4f445a685354303d,656e52545a6a6334535746705a465253513039524e335a455232313656465675556d5a5864323830624574445a444e5a5954423364454677637a303d,576a4643563246724d6e4e786346424855457331513031774e6a564355543039','6153383455446c506356567961444255526d30776546464a656b747251543039,53314e7663484530565868304e33686f5353746b5a6d4a685a6d4a745a7a3039,4d586c424d484a71524668715a554d35634546575555314a636b7461647a3039','636b4e7962445a7757564a47616e51725a6d3135576a6c6a566c633151543039,5a464e4653465673626d356e61584a58557939524e476c46637a56745a7a3039,6330786c6132567a4e32645953585276633142735132453056305642647a3039','5355644a516d4632536b7830555574575a3070764e6c6b794f58597a5a7a3039,4d556c5664465a69636e6c5961486c30576d785657464a775630527a593059304d584e4c646d7445617a4a435630567253446857536c4d34617a303d,4f574e584f4751785956557263317049655842494e55686e543034724e554e354f5863775a3145775a315244575759345a565a36546b4a315354303d','527a68795744564251316f72596c4635544552756558566e615756795a7a3039,527a68795744564251316f72596c4635544552756558566e615756795a7a3039,527a68795744564251316f72596c4635544552756558566e615756795a7a3039','5,5,5','119.80,179.80,65.00','119.80,179.80,65.00','0,0,0','878','1','NULL','3%','NULL','NULL','NULL','NULL','NULL','1000','0','1','1','1','0','4d31465a616e6f7a4e5531554f5730314d48497857564643537a5a5955543039','4d555a524f564a515348566c644578515755354d6479395864484e545a7a3039','NULL','0','0');

INSERT INTO sgc_2023_orders (id, created_date_time, creator, creator_name, order_id, order_type, order_number, order_date, company_details, bank_details, customer_id, customer_details, customer_city, delivery_address, category_id, category_name, product_id, product_code, product_name, product_content, quantity, actual_price, price, discount, extra_discount, show_extra_discount_amount, minimum_order_amount, packing_charges, promotion_code_id, promotion_code_name, promotion_code_price, promotion_code_discount_value, otp_number, total_amount, new_order, confirmed, despatched, delivered, push_notification, delivery_number, delivery_particulars, delivery_photo, send_sms_email, deleted) VALUES ('2','2023-08-12 12:27:12','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4d6a68555a575a78535574335433466d636c4258575546324d6b6c4655543039','57564270546d4658646d4933633031534e334279645764455931683055543039','6230523452566c435a6d7047524656506233524e59585653626b4e3451543039','2023-08-12','574442494c32564962474e56544751355a544e49596e4a6a4e6b68445132645563573134526974564b7a684f614668524d4734796132396153486c50617a4e356346566c52486856656b563456336471555746566230524c6156493052793936516d6c5a5456687255465a594e6d4a35564768525658684d61446c4854546c55563342494e315a5a64445a5363314a484d57684e52457869616b7444576c68355456426e525468615555513d','','576b4a46556b354e526b34724f5868736346493262564e6b53485a3551543039','625539314d6b6334526c70736231706e63576c424d6e4649545668584f48426c596a46466444683263565a7a4e466c6154484a3065566c70597a303d','59576b30616e52426345673353316c4d546b78795a33704e616b3830647a3039','57586848536d35316130354359315a774d314a72534739574b7a4e505154497a4d7a4a7857454a5256454d79556c55335557703559556c31647a303d','556e464b4e335179516c42455a6e5a68525568496244684a51306c735a7a3039,4d6d4e6b596d564c595845785757633157575a344d304a6c59315a715a7a3039,636b394e4e3170754d7a56565a6b4a4652325a6e625868306543743451543039,4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','526c425163316f3057555572615670524e45777253314e49574739724e485a4263335a526231646c54433959526b4a6d5a57524f4b305a73637a303d,576d684b5454523462587069544535324d444a5362693949626d3835646a5a735955687464466f3462316777536b7072567a526a4f445a685354303d,656e52545a6a6334535746705a465253513039524e335a455232313656465675556d5a5864323830624574445a444e5a5954423364454677637a303d,576a4643563246724d6e4e786346424855457331513031774e6a564355543039','5257644b517a4130516e63335a46524c4f576861627a426b4d32464a647a3039,6153383455446c506356567961444255526d30776546464a656b747251543039,53314e7663484530565868304e33686f5353746b5a6d4a685a6d4a745a7a3039,4d586c424d484a71524668715a554d35634546575555314a636b7461647a3039','4c314e6d4e554e6d5a6b4a426554526e536d3968643368714f465a515a7a3039,636b4e7962445a7757564a47616e51725a6d3135576a6c6a566c633151543039,5a464e4653465673626d356e61584a58557939524e476c46637a56745a7a3039,6330786c6132567a4e32645953585276633142735132453056305642647a3039','536b527a557a56344e43394d61465a45513146364d48557a63456843647a3039,5355644a516d4632536b7830555574575a3070764e6c6b794f58597a5a7a3039,4d556c5664465a69636e6c5961486c30576d785657464a775630527a593059304d584e4c646d7445617a4a435630567253446857536c4d34617a303d,4f574e584f4751785956557263317049655842494e55686e543034724e554e354f5863775a3145775a315244575759345a565a36546b4a315354303d','527a68795744564251316f72596c4635544552756558566e615756795a7a3039,527a68795744564251316f72596c4635544552756558566e615756795a7a3039,527a68795744564251316f72596c4635544552756558566e615756795a7a3039,527a68795744564251316f72596c4635544552756558566e615756795a7a3039','5,5,5,5','519.80,119.80,179.80,65.00','519.80,119.80,179.80,65.00','0,0,0,0','878','1','NULL','3%','NULL','NULL','NULL','NULL','NULL','3677','0','0','0','0','0','NULL','NULL','NULL','0','0');

INSERT INTO sgc_2023_orders (id, created_date_time, creator, creator_name, order_id, order_type, order_number, order_date, company_details, bank_details, customer_id, customer_details, customer_city, delivery_address, category_id, category_name, product_id, product_code, product_name, product_content, quantity, actual_price, price, discount, extra_discount, show_extra_discount_amount, minimum_order_amount, packing_charges, promotion_code_id, promotion_code_name, promotion_code_price, promotion_code_discount_value, otp_number, total_amount, new_order, confirmed, despatched, delivered, push_notification, delivery_number, delivery_particulars, delivery_photo, send_sms_email, deleted) VALUES ('3','2023-08-12 12:47:19','4f57686e596e64724d797443557a5672636b317153474978596a6450647a3039','5a324576536e6c70566b34355458427054327848566b4e775130394955543039','59315275643370544e46424461444530526c52584d6d64444e565a4c5a7a3039','4b316c434e544676554668525a7a4a5061474a4b4f554e6f626e4d77647a3039','515778696430357059585a42526c6f7a554768755446706c526d64715a7a3039','2023-08-12','574442494c32564962474e56544751355a544e49596e4a6a4e6b68445132645563573134526974564b7a684f614668524d4734796132396153486c50617a4e356346566c52486856656b563456336471555746566230524c6156493052793936516d6c5a5456687255465a594e6d4a35564768525658684d61446c4854546c55563342494e315a5a64445a5363314a484d57684e52457869616b7444576c68355456426e525468615555513d','','4f57686e596e64724d797443557a5672636b317153474978596a6450647a3039','4e465a4b62446b35546d51314e6a6b32545535684d476f35556c4e615556646a564531745a5846336330394a516a6c504d6d4933646b3130597a303d','59576b30616e52426345673353316c4d546b78795a33704e616b3830647a3039','4c304e6961576c7161586772533368525233684e54586873546b77725a6b4d79626d5a506157706e656d4533565852344e5842315a6b5a504e44303d','537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039,537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039,537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039,537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039,537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039,537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039,643068765a585a6a576b526f5a6c5271576d5177526a4135533349305a7a3039,643068765a585a6a576b526f5a6c5271576d5177526a4135533349305a7a3039,643068765a585a6a576b526f5a6c5271576d5177526a4135533349305a7a3039,643068765a585a6a576b526f5a6c5271576d5177526a4135533349305a7a3039','554539714d6c6c5262584a6d4d315a324e557036516c6b775655744a4f576846626e4d34566a6448576c46565655396e596e6c43614652575754303d,554539714d6c6c5262584a6d4d315a324e557036516c6b775655744a4f576846626e4d34566a6448576c46565655396e596e6c43614652575754303d,554539714d6c6c5262584a6d4d315a324e557036516c6b775655744a4f576846626e4d34566a6448576c46565655396e596e6c43614652575754303d,554539714d6c6c5262584a6d4d315a324e557036516c6b775655744a4f576846626e4d34566a6448576c46565655396e596e6c43614652575754303d,554539714d6c6c5262584a6d4d315a324e557036516c6b775655744a4f576846626e4d34566a6448576c46565655396e596e6c43614652575754303d,554539714d6c6c5262584a6d4d315a324e557036516c6b775655744a4f576846626e4d34566a6448576c46565655396e596e6c43614652575754303d,6347633061576b34636a64424b304e7a64446c52534667775a55746b647a3039,6347633061576b34636a64424b304e7a64446c52534667775a55746b647a3039,6347633061576b34636a64424b304e7a64446c52534667775a55746b647a3039,6347633061576b34636a64424b304e7a64446c52534667775a55746b647a3039','4d6d68774d314e5656465257546d5179564756445a553544616d744451543039,4f464e6a4e7a45304d334e52596d52454b7a684265557376556a51325a7a3039,526c565264445a794d6d73725a30355a4d6a52455a69393053556f34647a3039,5645343152545a345a46566f62584e59526b77354d6d4e574e6d7051647a3039,64316c495a5568504b7a5a4b5553744f56327470566b394c536d467751543039,5a444a5a596b4e5955557471616b7850553238794d6d64695532785351543039,566c64464f54673556465647546c4a61526b5a735a6a6442617a5a4551543039,5545706d61566c734e45314e55574a555a336c5152326875596e42765a7a3039,64315254595864505556673062325242597a4572644656474f487043647a3039,4e54466c576d566b55575a5952545679576d5a54626b685761554a43647a3039','54574e444e466f78516974304d334669634739616433524f517a5a455a7a3039,545756575a3239505233524e5a326845565656535131645a5a45733351543039,63326f34544752615530744759584978656974784e584e7864445a6f647a3039,6554457a64453172645752574e455274596d6c75565573334e5568455a7a3039,4c3273786347686d4c79746953314e745230307854334e4753557372647a3039,5333647465565a7352327450544751796255497256545a455632744f55543039,5a444e444d6d39335345463564546848576b56354d324a55646b55335a7a3039,52556436596b3531616b6c4b54574a6d635731684b3035725a30355951543039,5233525855544d315757644563316844533064516331644257586f7755543039,636b4e715a6e5634626b527462456479554531354c316c464e54645155543039','5756427054335576656b7848546b6333527a566b5446426e597a466955543039,5a474635567a5235574852365658426c614756315356647656555249647a3039,546a4e764f454e344e5756545a6a517652576c766146564757466473647a3039,634859304f44684461586f7655476c4e535746345a3073775255307261576f3156486c3153444272646e465454323930645568495a6b38335454303d,6447746c59325134547a5676635855356232706b4f546c305933426163444a6852475a345647646152456334544339785269744d5769746c4d44303d,633259305132564a5a6d59785a3342355a56704754546471533346464e465a445a335a4864315a6d5931593461464a6e4c30397064336c71597a303d,526e524f6148424e6355394c5445303556474d345a32593055555a4c596b746a53585a53544464524b30745262577455626b5a4c4b3252795154303d,644464444c316c47526b49314c3064455356424762444a74636d3970656c5a43627a5a52644756455231565655464e7754553976565734724e44303d,635663354e5778716231567051574a4f6353743352314e735669737a656e5a5863557730547a4a474f44684455584933656e453553575a455754303d,596b314d596939305246464d4f484a30636a4e514f486c3553455978633231544f5856354e586c42576e527a4e464e74636e6442595552685154303d','647a684b5a30646f517a525955324e425758703262474e765432744355543039,647a684b5a30646f517a525955324e425758703262474e765432744355543039,647a684b5a30646f517a525955324e425758703262474e765432744355543039,647a684b5a30646f517a525955324e425758703262474e765432744355543039,647a684b5a30646f517a525955324e425758703262474e765432744355543039,647a684b5a30646f517a525955324e425758703262474e765432744355543039,527a68795744564251316f72596c4635544552756558566e615756795a7a3039,527a68795744564251316f72596c4635544552756558566e615756795a7a3039,527a68795744564251316f72596c4635544552756558566e615756795a7a3039,527a68795744564251316f72596c4635544552756558566e615756795a7a3039','5,5,5,5,5,5,4,4,4,4','300.00,350.00,175.00,495.00,495.00,525.00,845.00,995.00,1345.00,2495.00','60,70,35,99,99,105,169,199,269,499','80,80,80,80,80,80,80,80,80,80','','0','2000','0','NULL','NULL','NULL','0','NULL','6884','1','0','0','0','0','NULL','NULL','NULL','0','0');

INSERT INTO sgc_2023_orders (id, created_date_time, creator, creator_name, order_id, order_type, order_number, order_date, company_details, bank_details, customer_id, customer_details, customer_city, delivery_address, category_id, category_name, product_id, product_code, product_name, product_content, quantity, actual_price, price, discount, extra_discount, show_extra_discount_amount, minimum_order_amount, packing_charges, promotion_code_id, promotion_code_name, promotion_code_price, promotion_code_discount_value, otp_number, total_amount, new_order, confirmed, despatched, delivered, push_notification, delivery_number, delivery_particulars, delivery_photo, send_sms_email, deleted) VALUES ('4','2023-08-12 12:48:17','4f57686e596e64724d797443557a5672636b317153474978596a6450647a3039','5a324576536e6c70566b34355458427054327848566b4e775130394955543039','4e6b644d64574e56537a4a4957564a736255467656326c4d5a585a4451543039','4b316c434e544676554668525a7a4a5061474a4b4f554e6f626e4d77647a3039','6257646b536c55795547777852317075565756355130565a6357353555543039','2023-08-12','574442494c32564962474e56544751355a544e49596e4a6a4e6b68445132645563573134526974564b7a684f614668524d4734796132396153486c50617a4e356346566c52486856656b563456336471555746566230524c6156493052793936516d6c5a5456687255465a594e6d4a35564768525658684d61446c4854546c55563342494e315a5a64445a5363314a484d57684e52457869616b7444576c68355456426e525468615555513d','','4f57686e596e64724d797443557a5672636b317153474978596a6450647a3039','4e465a4b62446b35546d51314e6a6b32545535684d476f35556c4e615556646a564531745a5846336330394a516a6c504d6d4933646b3130597a303d','59576b30616e52426345673353316c4d546b78795a33704e616b3830647a3039','4c304e6961576c7161586772533368525233684e54586873546b77725a6b4d79626d5a506157706e656d4533565852344e5842315a6b5a504e44303d','537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039,537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039,537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039,537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039,537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039,537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039','554539714d6c6c5262584a6d4d315a324e557036516c6b775655744a4f576846626e4d34566a6448576c46565655396e596e6c43614652575754303d,554539714d6c6c5262584a6d4d315a324e557036516c6b775655744a4f576846626e4d34566a6448576c46565655396e596e6c43614652575754303d,554539714d6c6c5262584a6d4d315a324e557036516c6b775655744a4f576846626e4d34566a6448576c46565655396e596e6c43614652575754303d,554539714d6c6c5262584a6d4d315a324e557036516c6b775655744a4f576846626e4d34566a6448576c46565655396e596e6c43614652575754303d,554539714d6c6c5262584a6d4d315a324e557036516c6b775655744a4f576846626e4d34566a6448576c46565655396e596e6c43614652575754303d,554539714d6c6c5262584a6d4d315a324e557036516c6b775655744a4f576846626e4d34566a6448576c46565655396e596e6c43614652575754303d','4d6d68774d314e5656465257546d5179564756445a553544616d744451543039,4f464e6a4e7a45304d334e52596d52454b7a684265557376556a51325a7a3039,526c565264445a794d6d73725a30355a4d6a52455a69393053556f34647a3039,5645343152545a345a46566f62584e59526b77354d6d4e574e6d7051647a3039,64316c495a5568504b7a5a4b5553744f56327470566b394c536d467751543039,5a444a5a596b4e5955557471616b7850553238794d6d64695532785351543039','54574e444e466f78516974304d334669634739616433524f517a5a455a7a3039,545756575a3239505233524e5a326845565656535131645a5a45733351543039,63326f34544752615530744759584978656974784e584e7864445a6f647a3039,6554457a64453172645752574e455274596d6c75565573334e5568455a7a3039,4c3273786347686d4c79746953314e745230307854334e4753557372647a3039,5333647465565a7352327450544751796255497256545a455632744f55543039','5756427054335576656b7848546b6333527a566b5446426e597a466955543039,5a474635567a5235574852365658426c614756315356647656555249647a3039,546a4e764f454e344e5756545a6a517652576c766146564757466473647a3039,634859304f44684461586f7655476c4e535746345a3073775255307261576f3156486c3153444272646e465454323930645568495a6b38335454303d,6447746c59325134547a5676635855356232706b4f546c305933426163444a6852475a345647646152456334544339785269744d5769746c4d44303d,633259305132564a5a6d59785a3342355a56704754546471533346464e465a445a335a4864315a6d5931593461464a6e4c30397064336c71597a303d','647a684b5a30646f517a525955324e425758703262474e765432744355543039,647a684b5a30646f517a525955324e425758703262474e765432744355543039,647a684b5a30646f517a525955324e425758703262474e765432744355543039,647a684b5a30646f517a525955324e425758703262474e765432744355543039,647a684b5a30646f517a525955324e425758703262474e765432744355543039,647a684b5a30646f517a525955324e425758703262474e765432744355543039','5,5,5,5,5,5','300.00,350.00,175.00,495.00,495.00,525.00','60,70,35,99,99,105','80,80,80,80,80,80','','0','2000','0','NULL','NULL','NULL','0','NULL','2340','1','0','0','0','0','NULL','NULL','NULL','1','0');

INSERT INTO sgc_2023_orders (id, created_date_time, creator, creator_name, order_id, order_type, order_number, order_date, company_details, bank_details, customer_id, customer_details, customer_city, delivery_address, category_id, category_name, product_id, product_code, product_name, product_content, quantity, actual_price, price, discount, extra_discount, show_extra_discount_amount, minimum_order_amount, packing_charges, promotion_code_id, promotion_code_name, promotion_code_price, promotion_code_discount_value, otp_number, total_amount, new_order, confirmed, despatched, delivered, push_notification, delivery_number, delivery_particulars, delivery_photo, send_sms_email, deleted) VALUES ('5','2023-08-12 12:51:37','4f57686e596e64724d797443557a5672636b317153474978596a6450647a3039','5a324576536e6c70566b34355458427054327848566b4e775130394955543039','4b314e6f54315255654745325958644f646e466a655756774e30465151543039','4b316c434e544676554668525a7a4a5061474a4b4f554e6f626e4d77647a3039','52565a59596c4a465547526b596d3872655656345754464f64556477647a3039','2023-08-12','574442494c32564962474e56544751355a544e49596e4a6a4e6b68445132645563573134526974564b7a684f614668524d4734796132396153486c50617a4e356346566c52486856656b563456336471555746566230524c6156493052793936516d6c5a5456687255465a594e6d4a35564768525658684d61446c4854546c55563342494e315a5a64445a5363314a484d57684e52457869616b7444576c68355456426e525468615555513d','','4f57686e596e64724d797443557a5672636b317153474978596a6450647a3039','4e465a4b62446b35546d51314e6a6b32545535684d476f35556c4e615556646a564531745a5846336330394a516a6c504d6d4933646b3130597a303d','59576b30616e52426345673353316c4d546b78795a33704e616b3830647a3039','4c304e6961576c7161586772533368525233684e54586873546b77725a6b4d79626d5a506157706e656d4533565852344e5842315a6b5a504e44303d','537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039,537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039,537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039,537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039,537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039,537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039,643068765a585a6a576b526f5a6c5271576d5177526a4135533349305a7a3039,643068765a585a6a576b526f5a6c5271576d5177526a4135533349305a7a3039,643068765a585a6a576b526f5a6c5271576d5177526a4135533349305a7a3039,643068765a585a6a576b526f5a6c5271576d5177526a4135533349305a7a3039','554539714d6c6c5262584a6d4d315a324e557036516c6b775655744a4f576846626e4d34566a6448576c46565655396e596e6c43614652575754303d,554539714d6c6c5262584a6d4d315a324e557036516c6b775655744a4f576846626e4d34566a6448576c46565655396e596e6c43614652575754303d,554539714d6c6c5262584a6d4d315a324e557036516c6b775655744a4f576846626e4d34566a6448576c46565655396e596e6c43614652575754303d,554539714d6c6c5262584a6d4d315a324e557036516c6b775655744a4f576846626e4d34566a6448576c46565655396e596e6c43614652575754303d,554539714d6c6c5262584a6d4d315a324e557036516c6b775655744a4f576846626e4d34566a6448576c46565655396e596e6c43614652575754303d,554539714d6c6c5262584a6d4d315a324e557036516c6b775655744a4f576846626e4d34566a6448576c46565655396e596e6c43614652575754303d,6347633061576b34636a64424b304e7a64446c52534667775a55746b647a3039,6347633061576b34636a64424b304e7a64446c52534667775a55746b647a3039,6347633061576b34636a64424b304e7a64446c52534667775a55746b647a3039,6347633061576b34636a64424b304e7a64446c52534667775a55746b647a3039','4d6d68774d314e5656465257546d5179564756445a553544616d744451543039,4f464e6a4e7a45304d334e52596d52454b7a684265557376556a51325a7a3039,526c565264445a794d6d73725a30355a4d6a52455a69393053556f34647a3039,5645343152545a345a46566f62584e59526b77354d6d4e574e6d7051647a3039,64316c495a5568504b7a5a4b5553744f56327470566b394c536d467751543039,5a444a5a596b4e5955557471616b7850553238794d6d64695532785351543039,566c64464f54673556465647546c4a61526b5a735a6a6442617a5a4551543039,5545706d61566c734e45314e55574a555a336c5152326875596e42765a7a3039,64315254595864505556673062325242597a4572644656474f487043647a3039,4e54466c576d566b55575a5952545679576d5a54626b685761554a43647a3039','54574e444e466f78516974304d334669634739616433524f517a5a455a7a3039,545756575a3239505233524e5a326845565656535131645a5a45733351543039,63326f34544752615530744759584978656974784e584e7864445a6f647a3039,6554457a64453172645752574e455274596d6c75565573334e5568455a7a3039,4c3273786347686d4c79746953314e745230307854334e4753557372647a3039,5333647465565a7352327450544751796255497256545a455632744f55543039,5a444e444d6d39335345463564546848576b56354d324a55646b55335a7a3039,52556436596b3531616b6c4b54574a6d635731684b3035725a30355951543039,5233525855544d315757644563316844533064516331644257586f7755543039,636b4e715a6e5634626b527462456479554531354c316c464e54645155543039','5756427054335576656b7848546b6333527a566b5446426e597a466955543039,5a474635567a5235574852365658426c614756315356647656555249647a3039,546a4e764f454e344e5756545a6a517652576c766146564757466473647a3039,634859304f44684461586f7655476c4e535746345a3073775255307261576f3156486c3153444272646e465454323930645568495a6b38335454303d,6447746c59325134547a5676635855356232706b4f546c305933426163444a6852475a345647646152456334544339785269744d5769746c4d44303d,633259305132564a5a6d59785a3342355a56704754546471533346464e465a445a335a4864315a6d5931593461464a6e4c30397064336c71597a303d,526e524f6148424e6355394c5445303556474d345a32593055555a4c596b746a53585a53544464524b30745262577455626b5a4c4b3252795154303d,644464444c316c47526b49314c3064455356424762444a74636d3970656c5a43627a5a52644756455231565655464e7754553976565734724e44303d,635663354e5778716231567051574a4f6353743352314e735669737a656e5a5863557730547a4a474f44684455584933656e453553575a455754303d,596b314d596939305246464d4f484a30636a4e514f486c3553455978633231544f5856354e586c42576e527a4e464e74636e6442595552685154303d','647a684b5a30646f517a525955324e425758703262474e765432744355543039,647a684b5a30646f517a525955324e425758703262474e765432744355543039,647a684b5a30646f517a525955324e425758703262474e765432744355543039,647a684b5a30646f517a525955324e425758703262474e765432744355543039,647a684b5a30646f517a525955324e425758703262474e765432744355543039,647a684b5a30646f517a525955324e425758703262474e765432744355543039,527a68795744564251316f72596c4635544552756558566e615756795a7a3039,527a68795744564251316f72596c4635544552756558566e615756795a7a3039,527a68795744564251316f72596c4635544552756558566e615756795a7a3039,527a68795744564251316f72596c4635544552756558566e615756795a7a3039','5,5,5,5,5,5,5,5,5,5','300.00,350.00,175.00,495.00,495.00,525.00,845.00,995.00,1345.00,2495.00','60,70,35,99,99,105,169,199,269,499','80,80,80,80,80,80,80,80,80,80','','0','2000','0','NULL','NULL','NULL','0','NULL','8020','1','0','0','0','0','NULL','NULL','NULL','1','0');

INSERT INTO sgc_2023_orders (id, created_date_time, creator, creator_name, order_id, order_type, order_number, order_date, company_details, bank_details, customer_id, customer_details, customer_city, delivery_address, category_id, category_name, product_id, product_code, product_name, product_content, quantity, actual_price, price, discount, extra_discount, show_extra_discount_amount, minimum_order_amount, packing_charges, promotion_code_id, promotion_code_name, promotion_code_price, promotion_code_discount_value, otp_number, total_amount, new_order, confirmed, despatched, delivered, push_notification, delivery_number, delivery_particulars, delivery_photo, send_sms_email, deleted) VALUES ('6','2023-08-12 12:58:44','4f57686e596e64724d797443557a5672636b317153474978596a6450647a3039','5a324576536e6c70566b34355458427054327848566b4e775130394955543039','644756446247466e6547527362334a475154677954455657635846545a7a3039','4b316c434e544676554668525a7a4a5061474a4b4f554e6f626e4d77647a3039','5257464461486334576b6c52614768344c324654523039684e554a735a7a3039','2023-08-12','574442494c32564962474e56544751355a544e49596e4a6a4e6b68445132645563573134526974564b7a684f614668524d4734796132396153486c50617a4e356346566c52486856656b563456336471555746566230524c6156493052793936516d6c5a5456687255465a594e6d4a35564768525658684d61446c4854546c55563342494e315a5a64445a5363314a484d57684e52457869616b7444576c68355456426e525468615555513d','','4f57686e596e64724d797443557a5672636b317153474978596a6450647a3039','4e465a4b62446b35546d51314e6a6b32545535684d476f35556c4e615556646a564531745a5846336330394a516a6c504d6d4933646b3130597a303d','59576b30616e52426345673353316c4d546b78795a33704e616b3830647a3039','4c304e6961576c7161586772533368525233684e54586873546b77725a6b4d79626d5a506157706e656d4533565852344e5842315a6b5a504e44303d','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039,4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039,4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039,4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039,4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','576a4643563246724d6e4e786346424855457331513031774e6a564355543039,576a4643563246724d6e4e786346424855457331513031774e6a564355543039,576a4643563246724d6e4e786346424855457331513031774e6a564355543039,576a4643563246724d6e4e786346424855457331513031774e6a564355543039,576a4643563246724d6e4e786346424855457331513031774e6a564355543039','61476c494e474e3254325a6b6244637253444a4d4c31637265554e465a7a3039,6555356f636b746a65697461526e56614f467043526b677756484a7a51543039,5a57744559554a7964314246596a564b52456c4f5245743063555a6951543039,5347745052437461596e4a334e6b4e614d454935624752465532686b647a3039,5555687a4d4338725a474a51556b4e4b59545932536e526f5a46424951543039','4e7a686b5158524a61564930616b314d626a6c555330744d5645567a51543039,54566b724d6c6c7852484130576b3149524668554d584a4a61474e5455543039,4c7a5a734e585678525642526445746e5531466b64475135516d6731647a3039,564749304e32564e646b4e4a4f48466a566a68705a6b4e345130646d5a7a3039,4d32354f6455773053316451556c4e6c62577056536e4a764d464a785a7a3039','544668725a7a56515a30315a5a3345315956465063586c3654474e78636a524d5230315364454e52634867334e6e633561554a61645756335a7a303d,515441784d4546345a6a52494d6d3479537a6c4b64474979616e707765576c524b334e314d316c4b53464e47534778724d573558523055305a7a303d,4e545a42625852466346704a576e4a79555774325357645a53455172566a5654646d564c4e5664474d32566e5344564861316c58525738764f44303d,616e564565474a5465546c71636a46594e6a4a6f617a424f6355684a5a474a35656a4135525756444d6b6843576a5236566e4270626a68765154303d,534745355a6e52355a57357661465a50567a564455306c684b324670626d64726333425362484a74546c6845646b30315a5738354d6c64575354303d','527a68795744564251316f72596c4635544552756558566e615756795a7a3039,527a68795744564251316f72596c4635544552756558566e615756795a7a3039,527a68795744564251316f72596c4635544552756558566e615756795a7a3039,527a68795744564251316f72596c4635544552756558566e615756795a7a3039,527a68795744564251316f72596c4635544552756558566e615756795a7a3039','5,5,5,5,5','145,160,190,210,250','145,160,190,210,250','0,0,0,0,0','','0','2000','0','NULL','NULL','NULL','0','NULL','4775','1','0','0','0','0','NULL','NULL','NULL','1','0');

INSERT INTO sgc_2023_orders (id, created_date_time, creator, creator_name, order_id, order_type, order_number, order_date, company_details, bank_details, customer_id, customer_details, customer_city, delivery_address, category_id, category_name, product_id, product_code, product_name, product_content, quantity, actual_price, price, discount, extra_discount, show_extra_discount_amount, minimum_order_amount, packing_charges, promotion_code_id, promotion_code_name, promotion_code_price, promotion_code_discount_value, otp_number, total_amount, new_order, confirmed, despatched, delivered, push_notification, delivery_number, delivery_particulars, delivery_photo, send_sms_email, deleted) VALUES ('7','2023-08-12 15:32:05','517a67784d6e6c534e6b314e636a644765456b32554556494d6a5646647a3039','62316c7762325244626c45304d546c725653396e52473175623356335a7a3039','5357704c546c5a42574768334e574a4d5255644e4d305256565531595a7a3039','57564270546d4658646d4933633031534e334279645764455931683055543039','656b395856544a6a5247354c4c336b31546d786e6154527a5157313355543039','2023-08-12','574442494c32564962474e56544751355a544e49596e4a6a4e6b68445132645563573134526974564b7a684f614668524d4734796132396153486c50617a4e356346566c52486856656b563456336471555746566230524c6156493052793936516d6c5a5456687255465a594e6d4a35564768525658684d61446c4854546c55563342494e315a5a64445a5363314a484d57684e52457869616b7444576c68355456426e525468615555513d','','4f57686e596e64724d797443557a5672636b317153474978596a6450647a3039','4e465a4b62446b35546d51314e6a6b32545535684d476f35556c4e615556646a564531745a5846336330394a516a6c504d6d4933646b3130597a303d','59576b30616e52426345673353316c4d546b78795a33704e616b3830647a3039','656b3145596d396156456c595432354854474e54534446685557317161564e7264327073626a4a7353556f79596e4634526e6c70534664745254524a536c707956326f72553370595357746b62326f31576a644e55773d3d','527a56454e6e4242593263725630464d613252504e487034643230345a7a3039,4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','4f47526c5132354764326b324f484e714d6d4a7a656d4a534d557455647a3039,576a4643563246724d6e4e786346424855457331513031774e6a564355543039','63585a575356687453315a51576c686e4d6e6c77597a41355244645455543039,576d6f3152315243595535425230356c52566c455a30303352555233647a3039','5a557075614777775a7a51315a697430576b34795430687357464e685a7a3039,5356687863474632656b6443646c4642566e564d4f45395a56477846647a3039','536c4252656c704c53303570596a4e6b6145466f536b347a6430707a647a3039,656b56325332315853454a74646b5a4254565a71614768425956453257457474626d683563545134533277304d4842574d433970593249795a7a303d','527a68795744564251316f72596c4635544552756558566e615756795a7a3039,527a68795744564251316f72596c4635544552756558566e615756795a7a3039','5,5','310.00,270.00','310.00,270.00','0,0','87','1','NULL','3%','NULL','NULL','NULL','NULL','NULL','2900.00','0','0','0','0','0','NULL','NULL','NULL','0','0');

INSERT INTO sgc_2023_orders (id, created_date_time, creator, creator_name, order_id, order_type, order_number, order_date, company_details, bank_details, customer_id, customer_details, customer_city, delivery_address, category_id, category_name, product_id, product_code, product_name, product_content, quantity, actual_price, price, discount, extra_discount, show_extra_discount_amount, minimum_order_amount, packing_charges, promotion_code_id, promotion_code_name, promotion_code_price, promotion_code_discount_value, otp_number, total_amount, new_order, confirmed, despatched, delivered, push_notification, delivery_number, delivery_particulars, delivery_photo, send_sms_email, deleted) VALUES ('8','2023-08-14 11:55:57','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4d584931645563304c3168365930396d626d3977637a644559324a61647a3039','57564270546d4658646d4933633031534e334279645764455931683055543039','546a6b77656c5a5652433954566d395a4d6a4257596a644e6145705851543039','2023-08-14','574442494c32564962474e56544751355a544e49596e4a6a4e6b68445132645563573134526974564b7a684f614668524d4734796132396153486c50617a4e356346566c52486856656b563456336471555746566230524c6156493052793936516d6c5a5456687255465a594e6d4a35564768525658684d61446c4854546c55563342494e315a5a64445a5363314a484d57684e52457869616b7444576c68355456426e525468615555513d','','4f57686e596e64724d797443557a5672636b317153474978596a6450647a3039','4e465a4b62446b35546d51314e6a6b32545535684d476f35556c4e615556646a564531745a5846336330394a516a6c504d6d4933646b3130597a303d','59576b30616e52426345673353316c4d546b78795a33704e616b3830647a3039','656b3145596d396156456c595432354854474e54534446685557317161564e7264327073626a4a7353556f79596e4634526e6c70534664745254524a536c707956326f72553370595357746b62326f31576a644e55773d3d','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','576a4643563246724d6e4e786346424855457331513031774e6a564355543039','625564504c3346694f44425464304d354f573433563356546257497a647a3039','5631646d4e453031576a5a6d56316f795a6c4e31537939535a5764355a7a3039','56546845566a644b4e4863784e4578745557643657564e324c30567a4c314a4c52334e495330315552303072576a52704d324a4d547a4a555354303d','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','5','650.00','650.00','0','NULL','1','NULL','NULL','NULL','NULL','NULL','NULL','NULL','3250','0','0','0','0','0','NULL','NULL','NULL','0','0');


CREATE TABLE `sgc_2023_otp_send_phone_numbers` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `send_date_time` datetime NOT NULL,
  `phone_number` mediumtext NOT NULL,
  `otp_number` mediumtext NOT NULL,
  `otp_send_count` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `sgc_2023_product` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `product_id` mediumtext NOT NULL,
  `category_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `product_code` mediumtext NOT NULL,
  `lower_case_product_code` mediumtext NOT NULL,
  `product_content` mediumtext NOT NULL,
  `price` mediumtext NOT NULL,
  `product_image` mediumtext NOT NULL,
  `product_video` mediumtext NOT NULL,
  `ordering` int(100) NOT NULL,
  `show_frontend` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=123 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('1','2023-08-10 15:39:22','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4d6d68774d314e5656465257546d5179564756445a553544616d744451543039','537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039','5756427054335576656b7848546b6333527a566b5446426e597a466955543039','5a6d5a5155577731616a5a71567a4e456432553259565a314e54566c55543039','54574e444e466f78516974304d334669634739616433524f517a5a455a7a3039','54574e444e466f78516974304d334669634739616433524f517a5a455a7a3039','647a684b5a30646f517a525955324e425758703262474e765432744355543039','60','NULL','NULL','1','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('2','2023-08-10 15:39:23','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4f464e6a4e7a45304d334e52596d52454b7a684265557376556a51325a7a3039','537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039','5a474635567a5235574852365658426c614756315356647656555249647a3039','4e6b4a55534455315455467953444e465243395763555668576b7732647a3039','545756575a3239505233524e5a326845565656535131645a5a45733351543039','545756575a3239505233524e5a326845565656535131645a5a45733351543039','647a684b5a30646f517a525955324e425758703262474e765432744355543039','70','NULL','NULL','2','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('3','2023-08-10 15:39:24','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','526c565264445a794d6d73725a30355a4d6a52455a69393053556f34647a3039','537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039','546a4e764f454e344e5756545a6a517652576c766146564757466473647a3039','567a6c445a31524e5130703563474a59536b78454e57524b656e4134647a3039','63326f34544752615530744759584978656974784e584e7864445a6f647a3039','63326f34544752615530744759584978656974784e584e7864445a6f647a3039','647a684b5a30646f517a525955324e425758703262474e765432744355543039','35','NULL','NULL','3','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('4','2023-08-10 15:39:24','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','5645343152545a345a46566f62584e59526b77354d6d4e574e6d7051647a3039','537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039','634859304f44684461586f7655476c4e535746345a3073775255307261576f3156486c3153444272646e465454323930645568495a6b38335454303d','57455a52644652514b32786154303542656d30725656525164565178656939546157567a4d485a334d4759304d464e334c7a5679656d566f637a303d','6554457a64453172645752574e455274596d6c75565573334e5568455a7a3039','6554457a64453172645752574e455274596d6c75565573334e5568455a7a3039','647a684b5a30646f517a525955324e425758703262474e765432744355543039','99','NULL','NULL','4','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('5','2023-08-10 15:39:25','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','64316c495a5568504b7a5a4b5553744f56327470566b394c536d467751543039','537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039','6447746c59325134547a5676635855356232706b4f546c305933426163444a6852475a345647646152456334544339785269744d5769746c4d44303d','53334e42553352354d30703262484d314f57746e625756744d3046495358645857573032536b6832516d5533613274715454426f645339695454303d','4c3273786347686d4c79746953314e745230307854334e4753557372647a3039','4c3273786347686d4c79746953314e745230307854334e4753557372647a3039','647a684b5a30646f517a525955324e425758703262474e765432744355543039','99','NULL','NULL','5','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('6','2023-08-10 15:39:25','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','5a444a5a596b4e5955557471616b7850553238794d6d64695532785351543039','537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039','633259305132564a5a6d59785a3342355a56704754546471533346464e465a445a335a4864315a6d5931593461464a6e4c30397064336c71597a303d','566d3136516a68325130745164306b304e4864534e3234725347784353454e504e57706c5a564a58526d49336430565556584a346132786d5554303d','5333647465565a7352327450544751796255497256545a455632744f55543039','5333647465565a7352327450544751796255497256545a455632744f55543039','647a684b5a30646f517a525955324e425758703262474e765432744355543039','105','NULL','NULL','6','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('7','2023-08-10 15:39:27','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','566c64464f54673556465647546c4a61526b5a735a6a6442617a5a4551543039','643068765a585a6a576b526f5a6c5271576d5177526a4135533349305a7a3039','526e524f6148424e6355394c5445303556474d345a32593055555a4c596b746a53585a53544464524b30745262577455626b5a4c4b3252795154303d','5a58706e616c637a56566446557a493251574a5254555249655852754d5446684b326b7a4e4555334e486c684f566444626b566f4d484d764e44303d','5a444e444d6d39335345463564546848576b56354d324a55646b55335a7a3039','5a444e444d6d39335345463564546848576b56354d324a55646b55335a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','169','NULL','NULL','1','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('8','2023-08-10 15:39:27','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','5545706d61566c734e45314e55574a555a336c5152326875596e42765a7a3039','643068765a585a6a576b526f5a6c5271576d5177526a4135533349305a7a3039','644464444c316c47526b49314c3064455356424762444a74636d3970656c5a43627a5a52644756455231565655464e7754553976565734724e44303d','634564794e324e4d6156424e6455563354454e4e53444a58546a56464d577432564468616333705263465a6e57576c734d5746444e455a69647a303d','52556436596b3531616b6c4b54574a6d635731684b3035725a30355951543039','52556436596b3531616b6c4b54574a6d635731684b3035725a30355951543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','199','NULL','NULL','2','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('9','2023-08-10 15:39:28','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','64315254595864505556673062325242597a4572644656474f487043647a3039','643068765a585a6a576b526f5a6c5271576d5177526a4135533349305a7a3039','635663354e5778716231567051574a4f6353743352314e735669737a656e5a5863557730547a4a474f44684455584933656e453553575a455754303d','55304e5862564a555630497761585232516a52754d6a64534e3342734d5768694d6e4e5864314254636c46304e324e4f576d5272557a464a5454303d','5233525855544d315757644563316844533064516331644257586f7755543039','5233525855544d315757644563316844533064516331644257586f7755543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','269','NULL','NULL','3','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('10','2023-08-10 15:39:28','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4e54466c576d566b55575a5952545679576d5a54626b685761554a43647a3039','643068765a585a6a576b526f5a6c5271576d5177526a4135533349305a7a3039','596b314d596939305246464d4f484a30636a4e514f486c3553455978633231544f5856354e586c42576e527a4e464e74636e6442595552685154303d','613231435a31424d4b32704f547a6c6857586c43637a5a764d44524e6547387752444e50536b31516432744a6243396c63576c5057464579627a303d','636b4e715a6e5634626b527462456479554531354c316c464e54645155543039','636b4e715a6e5634626b527462456479554531354c316c464e54645155543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','499','NULL','NULL','4','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('11','2023-08-10 15:39:30','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','6230597a4c7a5a534e7a4e76636c4e4b52314a68654456444e56685451543039','5233564a516c4a724e57316d5157457756477036556b645a63584a6855543039','543278305a7a4e45616a42304b324671626b4674536c524d65553561537a68755646467a554664685347343162476c58566c6847656a564d5654303d','645456575a314e305456704d516e7071523031484f58704363555178556b6c55553368685257747464456448616e686e59326468526d4e4b4f44303d','4d6d773155577435626a4e74636e4e4b55586c58613035744e464a3555543039','4d6d773155577435626a4e74636e4e4b55586c58613035744e464a3555543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','199','NULL','NULL','1','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('12','2023-08-10 15:39:30','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','55444a4f5248704f4d6a59725645387a64554e73646e426a5930303155543039','5233564a516c4a724e57316d5157457756477036556b645a63584a6855543039','5a545671596e5a6f556b645065586858593367354e6d52424d6c424a647a3039','5532746c526a4a75546a517854306878566c52524d7a42364c32465451543039','4c7a524255474a495332704e4e6c646d4f5770555a3231574b304e4f5a7a3039','4c7a524255474a495332704e4e6c646d4f5770555a3231574b304e4f5a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','299','NULL','NULL','2','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('13','2023-08-10 15:39:31','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','5a4656796144566d563031686431647963314a7362446b31596b733355543039','5233564a516c4a724e57316d5157457756477036556b645a63584a6855543039','64324a545232784f64565530516a647555485248576e526b655770785446424854457059526d39305a3052454b334d79617a685a5745684e647a303d','5345686d526c7050516b5635646c647162584a7a51574a525545314e656d526c4d6b78786447686a4e30684f5a546c475569737852545a48647a303d','536c5255516d4e43626c4a54633146456556466b4f47355861446c315a7a3039','536c5255516d4e43626c4a54633146456556466b4f47355861446c315a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','299','NULL','NULL','3','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('14','2023-08-10 15:39:32','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','544774614e6e52586246566b6154564452584272563141775645684f55543039','5233564a516c4a724e57316d5157457756477036556b645a63584a6855543039','52445243537a417a556d3033566d4e7961444275536d4e44634445324d33705a63576c5851334e476433686e595556524b7a417952475a6d5254303d','4c3068366131593363334a4459335a52596b68525a4870794f484e34524778504f566c34654870506330684d56453078616e4a556131566d4d44303d','544570735979744b54325677535668455555684c626a45335332347a51543039','544570735979744b54325677535668455555684c626a45335332347a51543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','60','NULL','NULL','4','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('15','2023-08-10 15:39:32','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','63306f776569746b655864774d4531506356646b513031585233467755543039','5233564a516c4a724e57316d5157457756477036556b645a63584a6855543039','576a6833527a425a625535584d437478646e49346432347264334a556445465a53555a53563368764e7a68425333646f63454534535545355654303d','627a6461517a6c774e6d706e596c70754e6c67304c324e47524852585a474e77516b6c5063555650626b3557536e4a57553273314f5667345454303d','65553135524668545a474e3553574a7a54476772525373345357397a51543039','65553135524668545a474e3553574a7a54476772525373345357397a51543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','640','NULL','NULL','5','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('16','2023-08-10 15:39:33','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','656b5a344f4564735932464d6254426c4d5338764c326732656e56595a7a3039','5233564a516c4a724e57316d5157457756477036556b645a63584a6855543039','5956707a4e5731734e564a58556a4e454f57687665464a735648567057577046547a68715554466b52566b31596c4d304d6e5931574868684e44303d','4f56513059334e755344467157556445636a564a61454a6a6369394a5a444252656b5a584e566f3056315a43567a63724d546c584c3056344e44303d','626c4e5355474e695648417754557458556c6778536938325656524f647a3039','626c4e5355474e695648417754557458556c6778536938325656524f647a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','599','NULL','NULL','6','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('17','2023-08-10 15:39:34','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','5130567065557054614652716244425864304e4f645570335554686951543039','5233564a516c4a724e57316d5157457756477036556b645a63584a6855543039','543074694d6b566b5a54426f576b645555315a4752476433646d4a775a30353365446c495333637a655339474e3370545a484e7453456c4d647a303d','53576f785669746a595552506333637a52577856623051315a6a645251576f31566b6c72564555334e6b354b566d74564f554d7a516c5a44597a303d','4b334a584e555a68626d466a4f555a784d544d775747645657557443647a3039','4b334a584e555a68626d466a4f555a784d544d775747645657557443647a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','440','NULL','NULL','7','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('18','2023-08-10 15:39:35','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','635456694d334e54526d68305455773454336449566c6869536b356b51543039','5648704f4e4646584d6c4a7959793947556d644b4e6d4652574842575a7a3039','57555654557a686163454e795a47394d5244517951305661556a46555755784c4d4764344e5446335a305532516a4e4a55454d77656d356b637a303d','626e63315a6e6c486147645855554672554774434d574a505a6a464c63546873536b746161325a7564576c31646d4d794e456872566e56445654303d','516e56564d6c4a4d6230524a546a46335a6c6c6c4d6c4a49596d5a765a7a3039','516e56564d6c4a4d6230524a546a46335a6c6c6c4d6c4a49596d5a765a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','99','NULL','NULL','1','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('19','2023-08-10 15:39:36','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','543239725a336372556c64686248565156303533627a526a626d684e647a3039','5648704f4e4646584d6c4a7959793947556d644b4e6d4652574842575a7a3039','6557707556565668535646535755744e6154466c616a52785a45685354584a345244687265446c54566a46334e6d786c56306c4962575a724d44303d','65546858633277794e544a7a5130314b5a7a6b764e6e6c426554644263454a55543055335157464b5a6d307a65466c6d565442494d6b59335254303d','4e6d6832546939496357513455586f7a636c4273647a51354d314a5351543039','4e6d6832546939496357513455586f7a636c4273647a51354d314a5351543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','249','NULL','NULL','2','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('20','2023-08-10 15:39:37','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','53564a515532356e4c7a4e4b6156705565584a4f59325a566332524b55543039','62585a53535546446545684e6254553153575132515339715344424e5a7a3039','633356534e54425457546c4b57584649593277776146424d5a46527351543039','556b3975526b316c4d6b7076516e6c716546707454466f31626a644d55543039','5a56685a54336f775331564662314a34625568454d31683154564e3155543039','5a56685a54336f775331564662314a34625568454d31683154564e3155543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','169','NULL','NULL','1','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('21','2023-08-10 15:39:37','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','5a334a5a4d573577516e464c54445645516d74694d6d355352477073647a3039','62585a53535546446545684e6254553153575132515339715344424e5a7a3039','656d784e6346567a4d6b7461644735744d4539546457785164444633647a3039','6332396b5432356e4e545275516c6852526a466d52464d775431464555543039','65484a584e6d4e46524870504c7a46735158564f55555a746130744455543039','65484a584e6d4e46524870504c7a46735158564f55555a746130744455543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','199','NULL','NULL','2','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('22','2023-08-10 15:39:38','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4d324e6a6145564752484a6a534374506130566a59304e505254677755543039','62585a53535546446545684e6254553153575132515339715344424e5a7a3039','54476871546c4244626d6432554731785a30747062475a686444673551543039','52323157536b567a62454a745a5567764f586b78617a417a63584634647a3039','61564a5a4e55677a556e5634576c6f334e7a6c6d576c553551545a4755543039','61564a5a4e55677a556e5634576c6f334e7a6c6d576c553551545a4755543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','499','NULL','NULL','3','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('23','2023-08-10 15:39:39','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','6444464a59546b346158526d5958644f526e68785a45704652486c6c647a3039','62585a53535546446545684e6254553153575132515339715344424e5a7a3039','5557524b567a5a6e614570764b304933576c70314e3064464b334672556b566b54455135636b786f62487050626c6c6f5257743055575a30647a303d','5a6d706d626a4d34516c6733636b5a725930526d516b5135596e6451654452444f554a3452575a7a526b64724e444a4d52454a724c336c6e5754303d','525774334c3064764d6b56694e4463354e693943553149724d32517855543039','525774334c3064764d6b56694e4463354e693943553149724d32517855543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','649','NULL','NULL','4','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('24','2023-08-10 15:39:40','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','617a517761556c316454684a516c5a71654656495a56707a636b394d51543039','59325a7362464a4b53556476526d5a3655327470543068774e44453055543039','576c4235536c4e7059556871515768534c7a64314f5864474d454a7955543039','6457397861577852646b4a504d46425a64334e344e44424d5754685651543039','5a6c4234624545795957524353326852516b787757475242556c557851543039','5a6c4234624545795957524353326852516b787757475242556c557851543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','260','NULL','NULL','1','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('25','2023-08-10 15:39:41','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','553070424e555a6e646a52306545356d51574a76566c46304d314a7a55543039','59325a7362464a4b53556476526d5a3655327470543068774e44453055543039','646c64514d6a4e4d55456c706333564f616b39446345493263304977647a3039','575574694e54685361335a78576d5535636d4e5765484a4f516b64345a7a3039','57585a5157454632616b6459617a644d616d64764f4339614f545a7751543039','57585a5157454632616b6459617a644d616d64764f4339614f545a7751543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','340','NULL','NULL','2','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('26','2023-08-10 15:39:41','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4f485a68596b464c56323550565770614d6c4d325633526e556b3831647a3039','59325a7362464a4b53556476526d5a3655327470543068774e44453055543039','4e4868534e466478617a517865546c6163453946656b70486447355655543039','644845326258493464335a5064574e36526b687357573945656d4531647a3039','526b4a4d576d354f59546330543068564c31424e52466c6c597a684b55543039','526b4a4d576d354f59546330543068564c31424e52466c6c597a684b55543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','440','NULL','NULL','3','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('27','2023-08-10 15:39:42','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','55554e5a52486830624646445158646d5247786155474530536c63775a7a3039','59325a7362464a4b53556476526d5a3655327470543068774e44453055543039','654568575133564a4e54684664324a6c5753744a616e46564b304e5651543039','523364365347744f4c33464252544a4655553177567a6c4d4b32777751543039','62484244554463725353747354335652624338356155347a5a44684c5a7a3039','62484244554463725353747354335652624338356155347a5a44684c5a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','699','NULL','NULL','4','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('28','2023-08-10 15:39:42','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','656b705855566f3261566b785747466162334a424f484578536d743551543039','59325a7362464a4b53556476526d5a3655327470543068774e44453055543039','4f55704c6445786b61446444564852555558684a51306c305a7a4a5461555a764d6b68445a33564856485a59616d313152307477567a64325354303d','59325177656e6b3151306434647a6c726232354964303579627a4a4d64336b77546e644e64473953546a413062573569595868444d324972597a303d','62575a5363554a55647a5a555545466d576e46334b31465a62484e755a7a3039','62575a5363554a55647a5a555545466d576e46334b31465a62484e755a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','245','NULL','NULL','5','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('29','2023-08-10 15:39:43','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','54477847513052456145567955485a534d6b317852484e496157317355543039','59325a7362464a4b53556476526d5a3655327470543068774e44453055543039','52326c685a6d744c55556b78595456694d325236616c593252444e53647a3039','4f454535626d316c546d4a754c304a30546c55315a7a5a334e6c647951543039','4e306c5052565655516e4e4b554664554f444649536b497852304d7851543039','4e306c5052565655516e4e4b554664554f444649536b497852304d7851543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','449','NULL','NULL','6','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('30','2023-08-10 15:39:44','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','6131673153797475646b73775a4735424b32393056565a5865454661647a3039','65574a75636b52554d6c7056547a51315433644b4f55707a626b567a55543039','546e68584d545a794d47644654556451556c4a4d4e31644464484131645556775530786e52314e455157565a576d314662335a34575664485654303d','5a6b4e544e476c575a586f72526e705a4d4642444d4735465a32745a5a454e4c623346505a30566d62324673626e5a6d516e644564477835637a303d','56576f785a7a4a57596e4d304e565232647a5a7451327846616b785951543039','56576f785a7a4a57596e4d304e565232647a5a7451327846616b785951543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','130','NULL','NULL','1','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('31','2023-08-10 15:39:45','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','55314d725630457251323156636a423165477876543068686547526851543039','65574a75636b52554d6c7056547a51315433644b4f55707a626b567a55543039','5548526e6432705863484530655570695a6a5a4464336c7a5444643651554e5864576c47574570544d477050546a6442636d6b7764474579627a303d','4b3068714b3078464c303879645768586456687164574672553235556346497656555649556c4e7a546a64685357745161576b354b3064535554303d','633031495953747761797458546c567865444e4464584636626b7777647a3039','633031495953747761797458546c567865444e4464584636626b7777647a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','140','NULL','NULL','2','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('32','2023-08-10 15:39:46','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','61565272627a4a7a62335a56556e424b63334a3652456c6e546e4e7751543039','6130464963455a75544852455255524664455a31546d3872636e41345a7a3039','516e5279516b7445565564316157315654306c424d566c6f5658525655543039','5447316a574442526558557a55576b72546b6c6b6256566b4e6e645a647a3039','636c646f6147745063445a6d4d5573784e6b5675556d685a5154677755543039','636c646f6147745063445a6d4d5573784e6b5675556d685a5154677755543039','63316c6c634868695169744c5755597955307446644539785a556b785a7a3039','60','NULL','NULL','1','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('33','2023-08-10 15:39:47','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','646b4a6e4b30786b54586c7252553878625556425a55704556474a51647a3039','6130464963455a75544852455255524664455a31546d3872636e41345a7a3039','556d46474d465631567a597a627a4a44556c7077626a4a33616b4a78647a3039','4e79746b4d486734555774575a6d704351586c4a56446c694b33644d5a7a3039','566d5a52647a6c56516a523154454e4b56324e5262454a6b55306f7951543039','566d5a52647a6c56516a523154454e4b56324e5262454a6b55306f7951543039','63316c6c634868695169744c5755597955307446644539785a556b785a7a3039','89','NULL','NULL','2','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('34','2023-08-10 15:39:48','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','556a59765346673351335a32523141774d304e314d58565154335a6f51543039','6130464963455a75544852455255524664455a31546d3872636e41345a7a3039','615668555a6e68494e6b6732556a5178547a45795157465054555a5651543039','554852705a6a4a3353554a4a557a5a7354545a5451554a31546c46695a7a3039','4f465a7a4e44465a636e704c63554a7a5756557964544a4f4c7a566f55543039','4f465a7a4e44465a636e704c63554a7a5756557964544a4f4c7a566f55543039','63316c6c634868695169744c5755597955307446644539785a556b785a7a3039','199','NULL','NULL','3','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('35','2023-08-10 15:39:49','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','596c5a47536d38325a32644261576842625756596455787353486c685a7a3039','596a5234553251314d58686d616e5271563256764f466c4b627a4978647a3039','655763304d48426c4e475a6e516e4e584d5339335a47557a5743394d4c7a426b6458647459305251645763724b325532546b64775a326c36637a303d','4e3368434e586474554849315758684e5448493151586732656d4d76527a6c6f546b4d7663585650564852515247785454456c4661544a44637a303d','566d70594f4641306130466c4d326474656b7436575841305a6c5130647a3039','566d70594f4641306130466c4d326474656b7436575841305a6c5130647a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','199','NULL','NULL','1','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('36','2023-08-10 15:39:50','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4c3055764b3364775a334e54643149334d475a55544734784e324644647a3039','596a5234553251314d58686d616e5271563256764f466c4b627a4978647a3039','556d744e546d7851555464344e6e466b5432394e65544e6d546b685852457074517a64764d475a745331457857567049596c4e75623346525654303d','54484a775a6d5250536b73765a53394d614574704d6b316a546e4a545457396f556a6c56546a6c59526b647a523368736445684551323476597a303d','4e6c644b516d7779565442475a7a5a59635456315a6d4a756255563355543039','4e6c644b516d7779565442475a7a5a59635456315a6d4a756255563355543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','299','NULL','NULL','2','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('37','2023-08-10 15:39:50','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4d475a354b324e3062456b7a566e646e64556c786347746e6154566d55543039','596a5234553251314d58686d616e5271563256764f466c4b627a4978647a3039','635664614e325254563077314d55394863484e7162323972576d31486147513163303161626d354e5747684f4c7a6c3257465a6b565642525a7a303d','5954647453485a55516b557a4e6c56784e5445335246644555584a554c31526b625846794d565231536a4a554e53737a5a544a4b645456745554303d','64334a514d486c544e47706e62324e7861314e725630557953336c7555543039','64334a514d486c544e47706e62324e7861314e725630557953336c7555543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','799','NULL','NULL','3','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('38','2023-08-10 15:39:51','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','53326c44613235594d45643252334e695544524955314a6b57484e735a7a3039','526d6c305557637865573954556e4e53595668695a6e6849644642725a7a3039','4c31525257457861566b4e43656e687751576731616d597963453147576c64764f485530646c56444f4764554f58464e596b644752553936647a303d','65544245656c6f32616d39745646464d4d5846536433426b51577332516d78785446646161323878645559775a57706d51325643524545775354303d','5156465855334d3255557447574778505a30566f6547395353575a4d51543039','5156465855334d3255557447574778505a30566f6547395353575a4d51543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','199','NULL','NULL','1','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('39','2023-08-10 15:39:52','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','6558704d5a6d6772596a4e4f5a553077636d4e6863533936636d5572647a3039','526d6c305557637865573954556e4e53595668695a6e6849644642725a7a3039','4e46497a625663784f5852755a30394d566e424a524531335131687a5a5446745448647a4d46567052324677526c7030576d31364d336f305154303d','6257784c6557687357533931616b73724b336c7657464e4c53455531624535725a453033533342324b3046425a6a685a4b315a564d484252637a303d','4d6e56716456527456566c4b4e5552555a314a496146466f5257704c5a7a3039','4d6e56716456527456566c4b4e5552555a314a496146466f5257704c5a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','299','NULL','NULL','2','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('40','2023-08-10 15:39:53','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','61575254626d643164454a7859336378646c5a30646e52745a5464765a7a3039','526d6c305557637865573954556e4e53595668695a6e6849644642725a7a3039','626d7078556b784a4b32457a5a3252526446464e545846725647684753545a76617a4e32647a6869656e645664475255526b684e576e56465254303d','6130396c54334e76626a4a74516d3472556e426159574676546b706a5455564f52545a78646c5248596b6c4f6354686d616d3434543156514f44303d','6154453554557448625870725a6d356856474e33546e70454e6e4d7651543039','6154453554557448625870725a6d356856474e33546e70454e6e4d7651543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','450','NULL','NULL','3','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('41','2023-08-10 15:39:53','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','634863354c31493356316f324e4656786343395a526d357564437442647a3039','526d6c305557637865573954556e4e53595668695a6e6849644642725a7a3039','4f486432614852504e444a504d30357752555645626d74715a556c774e326376636d73306132465965553545515551765345354e596b3561597a303d','4e31464262477055564568784f4778314f44683563335253645551315a445a444e6d6b34656c41765254566b633031435155704e63444a6e5554303d','6245387656585636645452475a6b314361554d776258643051544a4d5a7a3039','6245387656585636645452475a6b314361554d776258643051544a4d5a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','799','NULL','NULL','4','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('42','2023-08-10 15:39:55','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4f444e7352545172596a6c7762314e536433467951314e336154424a55543039','526d6c305557637865573954556e4e53595668695a6e6849644642725a7a3039','4e6a463662464531546d70754e453557616b78705a484a4e5a3270495331647556476b315158567354464935574652585a486858574546684d44303d','626c64354e5768766133526b547974494d4574445247566a62314d3262546850616c4e316448466f52454668616b7433556a4934546938764f44303d','57474e5463444a45623356584e433833596b59725769744e6356704b55543039','57474e5463444a45623356584e433833596b59725769744e6356704b55543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','1199','NULL','NULL','5','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('43','2023-08-10 15:39:55','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','65575a6a4d486c4f5a6d6475566b56726257527554485a7763553953647a3039','526d6c305557637865573954556e4e53595668695a6e6849644642725a7a3039','4f44644c61324a7761556835596c565361446448655842735655644a636d3157645670524d315a46536b6435644668716132356e5a3363325354303d','4e464a756333703254444a715a45526b635755766154417a616c6c5064304976626b5a34596a63794d544e3652565a4357566c4f646b784c5154303d','576b357951314a5464334a4e5930707853555a57526b464c5246457a647a3039','576b357951314a5464334a4e5930707853555a57526b464c5246457a647a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','2199','NULL','NULL','6','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('44','2023-08-10 15:39:56','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4f45397a5158424b614774706243397362453534526d705857556f79647a3039','526d6c305557637865573954556e4e53595668695a6e6849644642725a7a3039','4d43395457486c56576b34315255396c52565a6e6457354e5979394c6431464865577069566d68354b304d7953444e304e544930527a4d775554303d','556b5a4d4c334e4b5931597265545a6e57466b32523168555a5735696157457a636e55304d5467314b3264745a574d33623368444d3074564f44303d','61336475626b463065445a6c6333706c5958513164486c785430557a55543039','61336475626b463065445a6c6333706c5958513164486c785430557a55543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','5399','NULL','NULL','7','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('45','2023-08-10 15:39:56','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','596b6c476347786c556b5272626b6776516e417a5548467061326f3251543039','526d6c305557637865573954556e4e53595668695a6e6849644642725a7a3039','5448704663544e4b636e564351316c504e573876596e4e49615868484e586331536e4678526a6c794c3342585a6e46764d6d35304d6e56345654303d','4e33706d527a4e765a6d314e645549325a6a68494e30307751546875627a59765348426155486461555452445356567952574e6a61326f345154303d','52576c424d6e5278543068564b31706f53556c536230744c4b314a4a5a7a3039','52576c424d6e5278543068564b31706f53556c536230744c4b314a4a5a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','9999','NULL','NULL','8','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('46','2023-08-10 15:39:58','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','636d5a535630786f4b30744355456779596b5257646b564e525467325a7a3039','5a314e544e793949646b637952564644636a4a505648687a566c563351543039','5256593355555a454d474a3657553575646d7045526a63315a573972647a3039','4d30704f64304a784e58525864574a7662566c486257646c546a646d51543039','55444533555774715a4570745355647561455a42597a4a69646b5978647a3039','55444533555774715a4570745355647561455a42597a4a69646b5978647a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','70','NULL','NULL','1','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('47','2023-08-10 15:39:58','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','6448683459585652644442564b3256616333646f636b355a59324e555a7a3039','5a314e544e793949646b637952564644636a4a505648687a566c563351543039','526c6c35566a4236656c70744e46686b613074535556704d623156505a7a3039','4f54565363544e6d4e44526f645738795158467a5a7a6c4c4e56644955543039','4b32787555545259617a4a6a534567766547784d566b315853475a3355543039','4b32787555545259617a4a6a534567766547784d566b315853475a3355543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','199','NULL','NULL','2','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('48','2023-08-10 15:39:59','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','64453577616d737761566852624664305347564f4e6b5a784d6b6c7751543039','5a314e544e793949646b637952564644636a4a505648687a566c563351543039','646a6376595852355a584a4d636d7071525774324f5467314d30746d647a3039','5758645954433947656e4e786353396b5233566f5a484a5a574739465a7a3039','556b7434516a465055554a724e585247626a685059546c754d484e79647a3039','556b7434516a465055554a724e585247626a685059546c754d484e79647a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','299','NULL','NULL','3','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('49','2023-08-10 15:40:00','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','516c4135566a52444e314a69636d31776557464a55585a6a55576c4b51543039','5a314e544e793949646b637952564644636a4a505648687a566c563351543039','545856504d564a42595770486253746d4c7a464259564e43636e565456556f354e6c4e585a3156344d464a49566e5a74536d70794b324a535354303d','5933564d566c5a6e626e4d314d7973765a6c5236525849305432787a6355737a554546364b304a5a59556378654778574e485a6161444a6d637a303d','62473155646d4e796130645a5955354e53325271536a52545256684e51543039','62473155646d4e796130645a5955354e53325271536a52545256684e51543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','349','NULL','NULL','4','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('50','2023-08-10 15:40:01','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','565339546332684d4f47497a53564250633034774e6d394e5253394e55543039','4f566c585a32355959555268615646615a33704e656a64764d6e6c765a7a3039','52556b7661553578533170776157737256554d76537a46754f4755765a3235424f555a68536a67795755684f4e4451304b3077776247397756336468656b706161317058636a5a475447356959586b7a5446423054673d3d','5532686e4e6d31334d6d707356585a6a4d54524e4e586843616e4d7a545767305a57737752445a3351565679565777315a5570424f58563256325a61636c6b33646e5268596a45795a314a42646a4279536a497963773d3d','656b597752475177517a6c69534770476147354d53445572556e513155543039','656b597752475177517a6c69534770476147354d53445572556e513155543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','999','NULL','NULL','1','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('51','2023-08-10 15:40:02','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','597a644d54544a325269396b613159335979394f646c6c6856554534647a3039','4f566c585a32355959555268615646615a33704e656a64764d6e6c765a7a3039','62575a4956544e4953316435566d316c4d45464f4d334d3559576c4c63466c345330564b54576454626c41795a33564d566a4177646e70325a7a303d','4e544274576d396d4e7a4d324c3368464e546c705253744d646c5a6c526c704b4c3268454e46425a636d784e574842524f4659356445707a5454303d','55474d7a6456426c5533466b4d5768424f55746952327077556a464355543039','55474d7a6456426c5533466b4d5768424f55746952327077556a464355543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','799','NULL','NULL','2','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('52','2023-08-10 15:40:02','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4e553168566e6c546448684264487044614651324e5452315546464651543039','4f566c585a32355959555268615646615a33704e656a64764d6e6c765a7a3039','4d6b5261645646524e324577656d63335556464b6332746864464e325a334e566446457a5656464e4f47524b5132746962315276646a5578627a303d','53793931536d646b5554526b5a6a4a4a647a644d63565a4e563246445933673162314659556b4e5654465972626c5233643278436231426d617a303d','4f57394d6148686e5a566c754f4545344e6e41324e4752775a30463655543039','4f57394d6148686e5a566c754f4545344e6e41324e4752775a30463655543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','599','NULL','NULL','3','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('53','2023-08-10 15:40:03','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4d474a4b526e6869596a64464d465a7a516e644e5256464d6331683651543039','4f566c585a32355959555268615646615a33704e656a64764d6e6c765a7a3039','4c30646c5233466a4f454e735330317357574a526331647864335a32646b52496346704c4e44524453474655556b7445645374516455354c5654303d','5245745655484246616d354356554d315547706d546d4670654855786546457864475a73516b3955575574594f546c734d334130575570355754303d','56564a734d6a6c566332314e62325a7054585a345633704d64566833647a3039','56564a734d6a6c566332314e62325a7054585a345633704d64566833647a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','599','NULL','NULL','4','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('54','2023-08-10 15:40:04','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4d555a78526a4e4d645539514d56646c5a57704e4e33517a5557744855543039','527a56454e6e4242593263725630464d613252504e487034643230345a7a3039','4e4464455555746a563231305530464a556d6332516e4e774d6e4657565468305357466d5a6d5271645656554b30564a5a6b524562555a445754303d','516b357251545978564735794f555274544842334e586c6a52475a6d596b3575516c5244546a6b77546d317253584e4463556c5053575a785254303d','626974475a565650636c46584e7a55345255355a64577850644764355a7a3039','626974475a565650636c46584e7a55345255355a64577850644764355a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','699','NULL','NULL','1','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('55','2023-08-10 15:40:05','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4e6c55725656566161464e714d6e5a7a57445643596c464a556c564355543039','527a56454e6e4242593263725630464d613252504e487034643230345a7a3039','4c7a5a4953577372656c4e424e305a565a57647a64577047556b7443616e4636596b5a6e63315135533142315231513261565932526c424e637a303d','6433526c56455a7a545456344e306b7a56466458636a6c58646b773053325134616c4d35576e686a556a4a756443397663575a78636b56514e44303d','526c597a636c5a524d485a4a636c67314f454651536a5a7a576d31325a7a3039','526c597a636c5a524d485a4a636c67314f454651536a5a7a576d31325a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','899','NULL','NULL','2','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('56','2023-08-10 15:40:05','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','654546754e484e494b7a42574e6e6c774b32526d56304a5052576c5055543039','527a56454e6e4242593263725630464d613252504e487034643230345a7a3039','4e6d5a704f553548637a5254566b68694b31564a56485a505279745564446c555a485661566b6332556e49794c326b7a526d3953644463795654303d','4f5845774d6a5645646d786e5a6e46724f584668646e4269576d4a54624535595a55315356325676646a5669636b464c4e6d64685a3363345654303d','5a465a75546d4e4c55306c784f5570594f5652434f48466b626d707451543039','5a465a75546d4e4c55306c784f5570594f5652434f48466b626d707451543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','699','NULL','NULL','3','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('57','2023-08-10 15:40:06','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4e3245345a557869615646446356524b546c524c4d3052354e473952647a3039','527a56454e6e4242593263725630464d613252504e487034643230345a7a3039','64564a56646b4a58516b5578546e4e7064335236566974615430466e647a3039','516b68365645784c59697472635546734b303831596e45766469745151543039','597a4632575464365958567756464d3363454e6b516b6335563074355a7a3039','597a4632575464365958567756464d3363454e6b516b6335563074355a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','799','NULL','NULL','4','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('58','2023-08-10 15:40:07','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','536c70515a7a684f65544172566d46684f5852785a444d3264484e42647a3039','527a56454e6e4242593263725630464d613252504e487034643230345a7a3039','4d7a6843526a4532566d6c764d30566b53446c535448453361306733593278704e5870424d57684352545a7053566850576e6730576b35535a7a303d','57464a4d4e484a686356643365476b77534551335247687251314d72516c5a424d334e7952564a494b305532526b684a4e3074574d4856775254303d','4e56466162546459525373765530733354466c53634778545a4446365a7a3039','4e56466162546459525373765530733354466c53634778545a4446365a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','1199','NULL','NULL','5','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('59','2023-08-10 15:40:08','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','5155314a62454e7565554933546b77344e6c64796230566f62334e68647a3039','527a56454e6e4242593263725630464d613252504e487034643230345a7a3039','5347707063584a325745356b53586c4b535852525654645564446830647a3039','61466861543035554e437431554655725253743365546c535a3346695a7a3039','526b4e336245787956335242564452495155643555573533646a557255543039','526b4e336245787956335242564452495155643555573533646a557255543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','249','NULL','NULL','6','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('60','2023-08-10 15:40:09','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','63585a575356687453315a51576c686e4d6e6c77597a41355244645455543039','527a56454e6e4242593263725630464d613252504e487034643230345a7a3039','536c4252656c704c53303570596a4e6b6145466f536b347a6430707a647a3039','62314177614452505a30564f4b7a685359564a545a6b394f544568595a7a3039','5a557075614777775a7a51315a697430576b34795430687357464e685a7a3039','5a557075614777775a7a51315a697430576b34795430687357464e685a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','310','NULL','NULL','7','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('61','2023-08-10 15:40:10','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','646c593063336f31596d4a53576b4a6e646c4e485a79746e56445a74647a3039','527a56454e6e4242593263725630464d613252504e487034643230345a7a3039','624730314d57646c525452356132685261326f774e3368475348427555543039','626b7059593170696445645464475636616a464f5632644a65575633647a3039','5458564b4e476c7062544a596447314e56553573543270764c31426a55543039','5458564b4e476c7062544a596447314e56553573543270764c31426a55543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','999','NULL','NULL','8','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('62','2023-08-10 15:40:12','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','526e6b7a526b7858513346696246424855574652626c5a434e6a5a6b55543039','636b394e4e3170754d7a56565a6b4a4652325a6e625868306543743451543039','536b4a70516d4e4c4e6d686a517a5a6965456b7a534456754e3234345a7a3039','57576f774b325648656d78794e53746c536e6f345632733063444a45647a3039','5a336c366158424e61586b3159314a446248524351314a7a645864615a7a3039','5a336c366158424e61586b3159314a446248524351314a7a645864615a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','899','NULL','NULL','1','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('63','2023-08-10 15:40:14','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','64464a30576b5a544e6d745461585a79636d3146537a4a31526a564d55543039','636b394e4e3170754d7a56565a6b4a4652325a6e625868306543743451543039','4d4559344f5646685955746c5a6c4e50576d52775a6a46615253397764305a49544856315131423455485a7a556b4a7755445a79595452445754303d','5a6a523163544647636d707a4d48703457464931655564724e55746864316458536e4a43567a4e3455464a356258517a5156424a5a6e6f725654303d','4c305134513067785a564e435a46466d55556f31516b773062485659647a3039','4c305134513067785a564e435a46466d55556f31516b773062485659647a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','899','NULL','NULL','2','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('64','2023-08-10 15:40:15','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','53314e7663484530565868304e33686f5353746b5a6d4a685a6d4a745a7a3039','636b394e4e3170754d7a56565a6b4a4652325a6e625868306543743451543039','4d556c5664465a69636e6c5961486c30576d785657464a775630527a593059304d584e4c646d7445617a4a435630567253446857536c4d34617a303d','6158557956475653656c457a546d5533526e63725557397753474e36547a5a76565670764e6d4678565652466354645357486433546e59765554303d','5a464e4653465673626d356e61584a58557939524e476c46637a56745a7a3039','5a464e4653465673626d356e61584a58557939524e476c46637a56745a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','899','NULL','NULL','3','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('65','2023-08-10 15:40:16','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','526974544c324e36593352716555395664303942545856365344467951543039','636b394e4e3170754d7a56565a6b4a4652325a6e625868306543743451543039','63466468545752474e47686d556c6443536c70334e7a4a48517a646f55543039','545442506431706161304a325369746e52315643535555305347644c647a3039','6358467656324e6c597a4e5a595852534f4778335357355a523074515a7a3039','6358467656324e6c597a4e5a595852534f4778335357355a523074515a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','899','NULL','NULL','4','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('66','2023-08-10 15:40:18','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','53324a6954564e726457744b61584e6e4d5568754e6c45316244464351543039','4d6d4e6b596d564c595845785757633157575a344d304a6c59315a715a7a3039','5a564659655663784d556458616c4a5363565a6e4f554a7665486868647a3039','5754644c597a5a485a4859325655744c5769393362554a456248523251543039','61564e33656d784f5647396c57585930513164735645354d6131704c55543039','61564e33656d784f5647396c57585930513164735645354d6131704c55543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','599','NULL','NULL','1','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('67','2023-08-10 15:40:18','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','63537472516e4e79636e6f7763455935656e4e4555306830626d6c4755543039','4d6d4e6b596d564c595845785757633157575a344d304a6c59315a715a7a3039','59564135636c686d5648465063465668646e4a785747453155574a6d51543039','636b685a61335a685a464e304e45524f6330686b59314e43616a6c335a7a3039','4d6c6c7764557878623146694e3368554c336c5663334e7053464e715a7a3039','4d6c6c7764557878623146694e3368554c336c5663334e7053464e715a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','599','NULL','NULL','2','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('68','2023-08-10 15:40:19','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','5a58426b5633597a4f473556535751324b3142794d474e4c646d4e435a7a3039','4d6d4e6b596d564c595845785757633157575a344d304a6c59315a715a7a3039','6332706f54574e566146526c625842776547315a5a564270546d5635647a3039','637a64705657637657484a3354476c734d32354554475a526545637955543039','61584a68616d59785a465a56526e4e36564449774d475a5963545a555a7a3039','61584a68616d59785a465a56526e4e36564449774d475a5963545a555a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','599','NULL','NULL','3','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('69','2023-08-10 15:40:20','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','56575270626b70514f445249557a684556323973596b63324d57465151543039','4d6d4e6b596d564c595845785757633157575a344d304a6c59315a715a7a3039','5432557259564977524463356232526b63466c6c6555705664336475647a3039','4d31413356586854636a5a6b53455a6c566a5230623256524b30687655543039','536e4234596c6461646e5259645864355258513459315635596b395455543039','536e4234596c6461646e5259645864355258513459315635596b395455543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','599','NULL','NULL','4','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('70','2023-08-10 15:40:21','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','6153383455446c506356567961444255526d30776546464a656b747251543039','4d6d4e6b596d564c595845785757633157575a344d304a6c59315a715a7a3039','5355644a516d4632536b7830555574575a3070764e6c6b794f58597a5a7a3039','63555531576a52614d566c5065464a7a576b6c7663545a7a52565a755a7a3039','636b4e7962445a7757564a47616e51725a6d3135576a6c6a566c633151543039','636b4e7962445a7757564a47616e51725a6d3135576a6c6a566c633151543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','599','NULL','NULL','5','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('71','2023-08-10 15:40:23','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','526b637a53325a616455314b556c6c3554484e73556c46785957743551543039','4d6d4e6b596d564c595845785757633157575a344d304a6c59315a715a7a3039','61475a7a576a5a764d316c325a55316e6458684c595731485657787655543039','5532637764544a695a573953646a68564e7973314c334656535664555a7a3039','5347356c6332645054304e616258647555485a42517a4a524e576846647a3039','5347356c6332645054304e616258647555485a42517a4a524e576846647a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','599','NULL','NULL','6','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('72','2023-08-10 15:40:25','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','6557684b62586456565442795a57395962584a324e6b31504e54463355543039','545531426432646e4e457869636c5a485a307444576c4e484d544e495a7a3039','536a4a4751304e4f526a566f64466c79576b68494d5339545554425355543039','626b5a56596b5a55626c425a4b7a424a4f58637855456c364f576f7a647a3039','63565a58516c704d6546646d654670726448425453466c4655316c5351543039','63565a58516c704d6546646d654670726448425453466c4655316c5351543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','1299','NULL','NULL','1','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('73','2023-08-10 15:40:27','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','5355354a4d5870784e5668305a6c703554456830536b38324e5652795a7a3039','545531426432646e4e457869636c5a485a307444576c4e484d544e495a7a3039','576d394f5932705264564646566a46595969744663306c755a6c4d32647a3039','5a575a36633259345954567462324935556c6c46646c70555130394d51543039','5330787359315a71526d68735355396e4d5752485933524e63586431647a3039','5330787359315a71526d68735355396e4d5752485933524e63586431647a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','1299','NULL','NULL','2','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('74','2023-08-10 15:40:28','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','62564a35556d466163467068536e6c7862584657614667764f545a4c51543039','545531426432646e4e457869636c5a485a307444576c4e484d544e495a7a3039','5445686f4d3068685a325653566a564d516a6b774b3056516130314d647a3039','626e5a7563314e724f586855564759355547684f596d526a4d53747655543039','5757395951564e79544531315446633155564a364e6b6876636d4a4e647a3039','5757395951564e79544531315446633155564a364e6b6876636d4a4e647a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','1299','NULL','NULL','3','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('75','2023-08-10 15:40:30','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','5155564f526c6b72626d567954564e48596b685354545a784d54563451543039','545531426432646e4e457869636c5a485a307444576c4e484d544e495a7a3039','656c64755555526d61464d3362545930646c4e746145784a5357785255543039','4d56526d5644646a546c5a745355647763476468536b68756431567955543039','566d7068556d564b626c6f795a5531684d565a6f5a57646f53304e36647a3039','566d7068556d564b626c6f795a5531684d565a6f5a57646f53304e36647a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','1299','NULL','NULL','4','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('76','2023-08-10 15:40:31','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4e4735306253394a54486c5352586851655535494c3356335a5864515a7a3039','545531426432646e4e457869636c5a485a307444576c4e484d544e495a7a3039','65464e57596d314b52544678554568766348687164565a684d3268775a7a3039','65464a56647a4e70557a6b34613074355456646e5745746b6557687251543039','4d5568564f473831516c64795533567a544374304e6b31335a464e5851543039','4d5568564f473831516c64795533567a544374304e6b31335a464e5851543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','1299','NULL','NULL','5','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('77','2023-08-10 15:40:33','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','54314d7a644534344f474e325433706a5754424962444a756346705455543039','545531426432646e4e457869636c5a485a307444576c4e484d544e495a7a3039','645459765a6a5668656c4259566c5977537a527659325579525870315a7a3039','55444e34526b5a6e624751794d437330546d644a59574e59636d567a647a3039','56456859575552594d444e6c536b5a79576e4653623031435930395951543039','56456859575552594d444e6c536b5a79576e4653623031435930395951543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','1299','NULL','NULL','6','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('78','2023-08-10 15:40:36','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','5546684e63486470656e68304e6c59345a303147593152304c3149335a7a3039','635552445a546c79616d7035564568425357314b4b3155774d30647555543039','63445233626a6c335345393053316468533141775632563554334254647a3039','62466845646c4e5653585a5462325978596a4e78564770326546685751543039','5745685052475230646d5a365a485978645642765a306c695654465751543039','5745685052475230646d5a365a485978645642765a306c695654465751543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','1199','NULL','NULL','1','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('79','2023-08-10 15:40:37','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','595570494c304a4d4e6a6c6a576a4634576b39745a4778524f5842785a7a3039','635552445a546c79616d7035564568425357314b4b3155774d30647555543039','596e706d6430707552326b7a4e315572633277795954423156454e30647a3039','4e45566d636a6c3265453954526b3030566d524765474a775632686d647a3039','6357685951564a714c30565a4d475a4d636a4258516a6875646c4578647a3039','6357685951564a714c30565a4d475a4d636a4258516a6875646c4578647a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','1199','NULL','NULL','2','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('80','2023-08-10 15:40:39','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','567a6c7363314676516b73784c306b7a63325268636b35505445707055543039','635552445a546c79616d7035564568425357314b4b3155774d30647555543039','63544a31656d52544d3078494d79387752454a5a5647597a5458673555543039','4f544a6d4b3263305a466f7751566b786153395454315a4b546a4a3355543039','4e455a496557354c546e7033613164425345564d596e55795630526c55543039','4e455a496557354c546e7033613164425345564d596e55795630526c55543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','1199','NULL','NULL','3','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('81','2023-08-10 15:40:40','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','576b567065584234616a4e7a5133524d56316c6b576e7054656939725a7a3039','635552445a546c79616d7035564568425357314b4b3155774d30647555543039','55573551636c59785548684652334671646b56545a474a524e6e56725a7a3039','5a4452535548704962324e7652306733564656474e5546595356427351543039','53533832616d4a6e5545396a576d467353574a5a55475a6f5a474e5351543039','53533832616d4a6e5545396a576d467353574a5a55475a6f5a474e5351543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','1199','NULL','NULL','4','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('82','2023-08-10 15:40:42','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','55307036635868326448646d5345643254334d79656a4e35646d78525a7a3039','635552445a546c79616d7035564568425357314b4b3155774d30647555543039','536a6c4d513252565331493361304632534546685545355463444e4b5a7a3039','64545179546d7435656d3072636d4e515247687165475677626974795a7a3039','526e6c7a554667325a476c464e6a4e56576e42316332526e5531457a5a7a3039','526e6c7a554667325a476c464e6a4e56576e42316332526e5531457a5a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','1199','NULL','NULL','5','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('83','2023-08-10 15:40:43','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','56584a5153306c6e63544d354f5868355457703262564a684c32704a55543039','635552445a546c79616d7035564568425357314b4b3155774d30647555543039','54574a5061456c4751307877613342495430644f4e4734314f55706c647a3039','4e6d6c335a6b354351545a5a5a5664715954465153484a52626c427a55543039','596c6c70554859794e48524e555746685257744e4f554e54626b684955543039','596c6c70554859794e48524e555746685257744e4f554e54626b684955543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','1199','NULL','NULL','6','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('84','2023-08-10 15:40:47','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','54457047574538346554464e624463315a6d565262485669526c464a51543039','556e464b4e335179516c42455a6e5a68525568496244684a51306c735a7a3039','5446524652304e744d57353055336f7a5254565751697477636c4a7a5a7a3039','556d51356247316e596b70685a6a4a4e5a7a68316457315a5258553551543039','636c566f4e7a4a6f6147526f526a4e52646a5a7556334e324e305a6955543039','636c566f4e7a4a6f6147526f526a4e52646a5a7556334e324e305a6955543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','2599','NULL','NULL','1','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('85','2023-08-10 15:40:49','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','5257644b517a4130516e63335a46524c4f576861627a426b4d32464a647a3039','556e464b4e335179516c42455a6e5a68525568496244684a51306c735a7a3039','536b527a557a56344e43394d61465a45513146364d48557a63456843647a3039','647a6470563346325a334653636c64364c3170354b33426a61324a5751543039','4c314e6d4e554e6d5a6b4a426554526e536d3968643368714f465a515a7a3039','4c314e6d4e554e6d5a6b4a426554526e536d3968643368714f465a515a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','2599','NULL','NULL','2','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('86','2023-08-10 15:40:51','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','5a6e467053476f314e314a5952307733513342575a6b566e4d314a3551543039','556e464b4e335179516c42455a6e5a68525568496244684a51306c735a7a3039','5330637965555a47516d46785153733163544a3159326831564539715a7a3039','536b5a346355565463545a3262554a316558703653315a75576d316f55543039','4b3038346132705565486330623364356255673155336c7752576b77647a3039','4b3038346132705565486330623364356255673155336c7752576b77647a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','2599','NULL','NULL','3','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('87','2023-08-10 15:40:52','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4e6a5a775a455230597a6334527a5648646d5a5a5a4468305556633451543039','556e464b4e335179516c42455a6e5a68525568496244684a51306c735a7a3039','4d4652614b3355725246703352544a77543068594e305a57646c55305a7a3039','546e4a42545764734c314e5261444a566446687053575977546c647751543039','576b5a6f566b464551556c716156644a5a58644f547a4a49636c497651543039','576b5a6f566b464551556c716156644a5a58644f547a4a49636c497651543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','2599','NULL','NULL','4','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('88','2023-08-10 15:40:57','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','516e644a6258684d51584e6d65457877554464525a4535545a6b744c55543039','51305249535668615a46524b52304a4a64564e74554664335a6c4e4755543039','516c52434f57467761567048596c645359564a565258457a6458686e647a3039','596d3032634464314f484a775455396c526b6852544464315a30354e51543039','6354457254316c5253305233624731315a7a425362316c35526b5a3555543039','6354457254316c5253305233624731315a7a425362316c35526b5a3555543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','2999','NULL','NULL','1','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('89','2023-08-10 15:40:59','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','627a524d616c7046546b4a565556424854336447526c6436624456465a7a3039','51305249535668615a46524b52304a4a64564e74554664335a6c4e4755543039','646c7051545545794e46427761486b7a4f4564775930566a5454527355543039','55454e7a634664464b304a4f616d74774e6b6c7063564e3254554a745a7a3039','57464a366353396a64454a51636c41344e546b77626e70455a565272647a3039','57464a366353396a64454a51636c41344e546b77626e70455a565272647a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','2999','NULL','NULL','2','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('90','2023-08-10 15:41:01','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','5754686f52576c364d325259597a4a77526c52494d4774354d57565955543039','51305249535668615a46524b52304a4a64564e74554664335a6c4e4755543039','574652765a6e6853545746594d5745764e465a306144643154456c4d55543039','6457396d54485a525746524953324a615555356d556c424c53566c795a7a3039','57545a505a304534635870545758564d4e32467459315a4956305a4e51543039','57545a505a304534635870545758564d4e32467459315a4956305a4e51543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','2999','NULL','NULL','3','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('91','2023-08-10 15:41:03','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','6157394b54577046543168694d475a4b63574a5352305a425a32647155543039','51305249535668615a46524b52304a4a64564e74554664335a6c4e4755543039','656b5a54526c645963564a454d33467559566c4c5358424a61455657647a3039','4d575a7064554a684e5656325758647255445130616a4e5a5669744b647a3039','62445a4d524468344f45684e535555345247303563323949536c5a7155543039','62445a4d524468344f45684e535555345247303563323949536c5a7155543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','2999','NULL','NULL','4','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('92','2023-08-10 15:41:05','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4d6d6f724e45354a5a454a4952334635515538785632316c526d744a5a7a3039','51305249535668615a46524b52304a4a64564e74554664335a6c4e4755543039','53464a46616b3551616e706f4d6a566f52324a57526b5a6d6154524b51543039','5a47396d596b6435576b356f64474a765747706f62484e4262545a6c5a7a3039','516e4a47616a5a584e6d396f535574364e4573794f564246525852715a7a3039','516e4a47616a5a584e6d396f535574364e4573794f564246525852715a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','2999','NULL','NULL','5','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('93','2023-08-10 15:41:09','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','55465131536a4e5862316c47516b685a563234354b3268755133646b55543039','64466776565446705a316b7a5330557a51555a3559546b325256527351543039','57564d3154304d7a626a567456307835544563784d32497963574678636d4a515355453259554e6f627a5a304d484a4f5a314d3162304e524d44303d','4b3268795231707a63575a76656b4e73513239334c3231355548524d57585a4863564a7a51564674656a644952574e61626b673154576b32597a303d','535870535646704e52586855646e563661566c6b567a5a70516e49775a7a3039','535870535646704e52586855646e563661566c6b567a5a70516e49775a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','1299','NULL','NULL','1','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('94','2023-08-10 15:41:12','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','6255394e524777314c3170724d5574764c314e364f4445324c33425751543039','5545316c4d55564464586b7a64324e4a616a526c52584530513141305a7a3039','64554e3363575a354f5773776255704b5a305a4d556c56555a444e3251543039','54566851593349765a314655564535616432356e593359336558464255543039','5957644c54325657636d56344e6b706e4c3270454e56563254545a5a647a3039','5957644c54325657636d56344e6b706e4c3270454e56563254545a5a647a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','699','NULL','NULL','1','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('95','2023-08-10 15:41:13','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','553070584e6a526b516c5650557a4d724f553477535670425a546459647a3039','5545316c4d55564464586b7a64324e4a616a526c52584530513141305a7a3039','557a6b7a65446c4d4d556873556b354e57456c325a5745324c334535616a4a365a6e4e495669747162573032646e68595433526c4b3170725554303d','5344685053327456617a6c5955545a73623068714d457033623056354e544e6a63573168576d397a576e684b5355746d655842434d335a4b4e44303d','62584e3363554d765448686b62306830566d70746245523353475a795a7a3039','62584e3363554d765448686b62306830566d70746245523353475a795a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','899','NULL','NULL','2','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('96','2023-08-10 15:41:15','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','526d4d3451315a686545705455564e4561577458564846495a44467255543039','5545316c4d55564464586b7a64324e4a616a526c52584530513141305a7a3039','6230704761575a46645642464d6c424c59533872623356444e3235456332647952316f355157466a5258644956457873616d4533513034765a7a303d','5957466b53797335616c566f5a6a4a3164554a6d646b4a705a6b64345530706952465a3257554e4652584932646c5a4957573533646c45785654303d','564868515255467559304e4b596d51774e79396f52576832596e4a5055543039','564868515255467559304e4b596d51774e79396f52576832596e4a5055543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','1499','NULL','NULL','3','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('97','2023-08-10 15:41:17','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4e32647a536a52695644557262316c6e6455785a4e7a567963325a365a7a3039','5545316c4d55564464586b7a64324e4a616a526c52584530513141305a7a3039','543052504e7a4642645749354d6a46464d466331565870525132313065446c325257567364335252564456536332347957475250656c7079597a303d','4b304e6f59316861576b52735956527a556b67345a55707162314e32524774454e56644a5a6c55776547644953304e56616d6856616a5a70597a303d','596b314565474672644441304e6c4a7555454653566b704f643342325a7a3039','596b314565474672644441304e6c4a7555454653566b704f643342325a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','2999','NULL','NULL','4','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('98','2023-08-10 15:41:19','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','6130777a636b52426257705a6145787362586330534846435657746c5a7a3039','5545316c4d55564464586b7a64324e4a616a526c52584530513141305a7a3039','5158417a4d3370334d566f7262556b79536d68536330524952575a7a6130354b62546c756145397154475670576d3179566b6776513367335554303d','54304e4d536e7052526b4d31553156474d6973346244643061577455556c526b627a6c5a645756616445647762564a49556e4a554d565a345654303d','6545643464457454616d317863486c344e464250545746525a6b5a4c51543039','6545643464457454616d317863486c344e464250545746525a6b5a4c51543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','5999','NULL','NULL','5','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('99','2023-08-10 15:41:21','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4e58705654585269646c41774f564e4e4d4670534d6a4e745a6a6b3255543039','5545316c4d55564464586b7a64324e4a616a526c52584530513141305a7a3039','6332644b53456c4a4e476f786447785a4e6e704555584a795955396e54315242656e55764e574578646d78795657307a5a465a334c304e524e44303d','5130564f616b356c516c6c5057484648634670535156464964457335636a567a6130566d59316c486545497657554a72526b5a3356314e36647a303d','52465a44516b56345a476c744d574e74565846614b30355a56797442647a3039','52465a44516b56345a476c744d574e74565846614b30355a56797442647a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','11999','NULL','NULL','6','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('100','2023-08-10 15:41:25','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','596c49765454686d4f456c4f6546527952555a4e61475977537a4e4f5a7a3039','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','5132464c515842776330525155317047533142434f56457a6130395664324535516a425652454e77596c424a656d52455343395654476f33617a303d','55566c335431646d4f466c6a56575a5a6248706f5a6c707a52304a334d6b464e5a574d78546e6c6e5747783255316855516d39785454566c4d44303d','566b4e57536d7330625452735a475a7559305a5854554a6c536c4e3151543039','566b4e57536d7330625452735a475a7559305a5854554a6c536c4e3151543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','54','NULL','NULL','1','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('101','2023-08-10 15:41:27','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','5a5373726330387964314273566b314e63304e48567a6b31593034355a7a3039','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','53314247617a6868556a4d334c3270594d7a4658565739544b307032636d4a736355646861304e724e6b4e4c5357526953574a6b57446c45627a303d','4d6c41795a3142785a6d6b31535549324f575a7754485a5256335a584f46493462484e6c54544e4456546b325633564b596939714e445a465354303d','5754423465456735626a68364f47397562303076546b314f4d54645855543039','5754423465456735626a68364f47397562303076546b314f4d54645855543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','60','NULL','NULL','2','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('102','2023-08-10 15:41:29','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4d586c424d484a71524668715a554d35634546575555314a636b7461647a3039','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','4f574e584f4751785956557263317049655842494e55686e543034724e554e354f5863775a3145775a315244575759345a565a36546b4a315354303d','53554e6e4e7a5674615667304b314d794e6c4d72566d3535546b787657544e684e32316955304579546a424b52574d7a654374774c303478597a303d','6330786c6132567a4e32645953585276633142735132453056305642647a3039','6330786c6132567a4e32645953585276633142735132453056305642647a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','65','NULL','NULL','3','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('103','2023-08-10 15:41:30','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4d5556754c30685654304e305255786d616d5630536e6c445a6e5a6f51543039','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','6154463462565130596d78366146643659546b316145316a654555795545647762485a73625374364d54424b563167315746426f635652524d44303d','644649345a5446734c327874546b45316447784b526d74504c316469615664705254565a575642754e3064714d56564e4e5731535a57784d647a303d','63546c70593274345953744259546458596c42495557677a534749335a7a3039','63546c70593274345953744259546458596c42495557677a534749335a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','75','NULL','NULL','4','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('104','2023-08-10 15:41:31','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','5257466a5458417755464a6e556939356155645354586c4c4e484e4e55543039','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','527a6877646b5531516c6c5a556d4a3365474a55656d56494b334646546d5a6b57475a794c3234336256566d4f466c424f437477515670615154303d','4c336c45563352324d455279646b5a6b4f44687662335a4f4b32465a536c497853444172656a566e646b685151303559626b3976644574565754303d','516c5a48576a68684e4539424e6c6444515442796556566b5957744a5a7a3039','516c5a48576a68684e4539424e6c6444515442796556566b5957744a5a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','70','NULL','NULL','5','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('105','2023-08-10 15:41:33','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','53476c33645574686545354c64335654616c46574d6b4e4b517a687a51543039','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','4d465534564546344b3274694c334630576d34785a6b6c5152485a59566c42436255396f5555705857444261576b526b596d4634546e70315154303d','59577443646a56304d47737252334278556a46584b325a4e4d6c425a636a42484b3064585447517a5755557a4b31523455544e7554575674597a303d','64474e555556457a4f437459614546354b3368525a56593055476431647a3039','64474e555556457a4f437459614546354b3368525a56593055476431647a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','85','NULL','NULL','6','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('106','2023-08-10 15:41:35','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','626a4a344e54567163316f72554774335757684f637a67316556703651543039','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','616d6b344e5863304d486c505631567a636c4e434e6c566a63544e6b566b684a54576851556e6447626a5a46564778786444597a616b7833647a303d','4e6b4e755745633461585a6f4f5374564e553978574545344d466c7255464659656d7478597939335746705a63485a584d6b35574b31644d5a7a303d','616b3472544735314d4778476247647861327871644846525931686f647a3039','616b3472544735314d4778476247647861327871644846525931686f647a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','93','NULL','NULL','7','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('107','2023-08-10 15:41:38','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','536c56525469747759584d324b3078694c30786b535535515a57566b647a3039','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','534731525331647961304d354d574a464e564e5a5230647861454e614d5670685531564a61567070533149325257383452335a53636a4e744f44303d','565746524d304a304b323553596b3961643239434f475649646e646f4b314e6c5a6b4e4d51336b33535531695133564a65454579564546355254303d','566c6c4456474e6b6457684e6455644753326f3264314a346257343255543039','566c6c4456474e6b6457684e6455644753326f3264314a346257343255543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','108','NULL','NULL','8','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('108','2023-08-10 15:41:40','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','51304a7065473031656b4e5a613370544b30394e4f4452615257737a5a7a3039','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','626b7447563352366133644a57474a6952304a6f616c4231524655776157465164453551616d4634576b4645537a4e44556d6444593346484f44303d','51584530566e4934597a4e3657456331656c467052554a36656b6c6c5658683056545a4355554d7755566c76626c55325131646a5a6c52754f44303d','5a6b6c755a5339786145517a4e484e74524446595353396e564656795a7a3039','5a6b6c755a5339786145517a4e484e74524446595353396e564656795a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','115','NULL','NULL','9','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('109','2023-08-10 15:41:42','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4d56567255564a3563306477644464766255706b536c5a68614531685a7a3039','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','5132353162566b72527a6c704d544e5354325244595573774d473536567a6c5864334a4352554e6c65575a576547737a52566857524456534f44303d','515764304b324635565464596557343555444644576c5a355247564a62326c6c5432787753576f724f437476614663794b314a4e525446345354303d','55327334513049306245396b63444a79626d684e515774334e6b56445a7a3039','55327334513049306245396b63444a79626d684e515774334e6b56445a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','137','NULL','NULL','10','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('110','2023-08-10 15:41:44','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','61476c494e474e3254325a6b6244637253444a4d4c31637265554e465a7a3039','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','544668725a7a56515a30315a5a3345315956465063586c3654474e78636a524d5230315364454e52634867334e6e633561554a61645756335a7a303d','6458557859577331656e524d637a463654574e574f4764734e464e5a526b3570616c4a564f4446795a576c304e6c467755584d326457394b4d44303d','4e7a686b5158524a61564930616b314d626a6c555330744d5645567a51543039','4e7a686b5158524a61564930616b314d626a6c555330744d5645567a51543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','145','NULL','NULL','11','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('111','2023-08-10 15:41:45','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','6555356f636b746a65697461526e56614f467043526b677756484a7a51543039','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','515441784d4546345a6a52494d6d3479537a6c4b64474979616e707765576c524b334e314d316c4b53464e47534778724d573558523055305a7a303d','4e484d785530355565565576636b6c55546b4a52634768336231566e4d6a6c5155465a744f444a6c5554426c53316473596a523661586c54637a303d','54566b724d6c6c7852484130576b3149524668554d584a4a61474e5455543039','54566b724d6c6c7852484130576b3149524668554d584a4a61474e5455543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','160','NULL','NULL','12','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('112','2023-08-10 15:41:46','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','5a57744559554a7964314246596a564b52456c4f5245743063555a6951543039','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','4e545a42625852466346704a576e4a79555774325357645a53455172566a5654646d564c4e5664474d32566e5344564861316c58525738764f44303d','62304d3351314e6c616e686d4d48677955485135527a41314d553156644570775746705a635778684e7a5a4d525545765747784b52324d345154303d','4c7a5a734e585678525642526445746e5531466b64475135516d6731647a3039','4c7a5a734e585678525642526445746e5531466b64475135516d6731647a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','190','NULL','NULL','13','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('113','2023-08-10 15:41:48','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','5347745052437461596e4a334e6b4e614d454935624752465532686b647a3039','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','616e564565474a5465546c71636a46594e6a4a6f617a424f6355684a5a474a35656a4135525756444d6b6843576a5236566e4270626a68765154303d','61336459566e42335a6a6851536a56314e47777656554d346455744f623159314e6d78775931557856486c69546a553157587071566e6470647a303d','564749304e32564e646b4e4a4f48466a566a68705a6b4e345130646d5a7a3039','564749304e32564e646b4e4a4f48466a566a68705a6b4e345130646d5a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','210','NULL','NULL','14','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('114','2023-08-10 15:41:49','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','5555687a4d4338725a474a51556b4e4b59545932536e526f5a46424951543039','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','534745355a6e52355a57357661465a50567a564455306c684b324670626d64726333425362484a74546c6845646b30315a5738354d6c64575354303d','637a42316258647a5a6e70526430467264323531595552775357566e5155637853325a6b563164554e6e644554335a51564456314f464d32647a303d','4d32354f6455773053316451556c4e6c62577056536e4a764d464a785a7a3039','4d32354f6455773053316451556c4e6c62577056536e4a764d464a785a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','250','NULL','NULL','15','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('115','2023-08-10 15:41:50','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','6448513261326469576a4e3455445a3152486f766356687757555a3051543039','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','6557566c626a6c69565452725a30566957465652656a5a7a566a4a6f64445a70526d56744c7a56785930683357565535595767354e4456765754303d','6545646959316455596e4a5a645559795a4464614c3046685a476832546b707556584a5a5953747a57576873656e647855315a7a626d4a335254303d','6245356e65474e4e574452765755687262466f355a6d4a515132354951543039','6245356e65474e4e574452765755687262466f355a6d4a515132354951543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','270','NULL','NULL','16','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('116','2023-08-10 15:41:51','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','55324a5856314a356245464f535646335457785a55584d35576c6f7a55543039','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','6231637751314a32617a52534e454e4b596e4a54536974714b326f764b30467955484e6a5933686e596c6c476257396c614652515a5778424f44303d','566d5a616333685153324d305454686f56565577633055334d57566a54336b305445746d626a4e6b634868305a44523464304e6d533164724f44303d','4d6b4a6d516c566964576b3254546450526b646f645855305a446855647a3039','4d6b4a6d516c566964576b3254546450526b646f645855305a446855647a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','190','NULL','NULL','17','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('117','2023-08-10 15:41:53','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','6546457a52585268576d5a684c32566b636e5a4d543273306245513555543039','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','65586c4d59573543533034334d7a497756544d3563486c30546b3934576b4e445447777a536d78495155465457556b315530524552315a784f44303d','52334233626d524a576a64504c33646f526b6c5a536d52584c3346526353394354334576566e4e5759566832536c424f54475671623156545554303d','4f4641346432706f62473550516d6732526b6c545a3039685257644855543039','4f4641346432706f62473550516d6732526b6c545a3039685257644855543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','210','NULL','NULL','18','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('118','2023-08-10 15:41:54','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','6331553363444d775755315a4d6d354d52486c434d323143576d55725a7a3039','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','576c5a595a6b5a4b526e5a556248647363545249515339615a33466c557a597a636e703351533950546a6c7a4e54563265575a7655556c4d4d44303d','4d473968523277765955685657555255526d395662306732646e427a54586c31635770466455356d5457644a4e555933536d6c6d4c30394f5754303d','65484e52534463346555677652455647655778484d6c6c6a63555a715a7a3039','65484e52534463346555677652455647655778484d6c6c6a63555a715a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','250','NULL','NULL','19','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('119','2023-08-10 15:41:55','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','576d6f3152315243595535425230356c52566c455a30303352555233647a3039','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','656b56325332315853454a74646b5a4254565a71614768425956453257457474626d683563545134533277304d4842574d433970593249795a7a303d','57484e74576e4534564641765a6b77776545467952474e745932787362464972566b316b566d49766545353065466873615735785446706b617a303d','5356687863474632656b6443646c4642566e564d4f45395a56477846647a3039','5356687863474632656b6443646c4642566e564d4f45395a56477846647a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','270','NULL','NULL','20','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('120','2023-08-10 15:41:56','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','625564504c3346694f44425464304d354f573433563356546257497a647a3039','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','56546845566a644b4e4863784e4578745557643657564e324c30567a4c314a4c52334e495330315552303072576a52704d324a4d547a4a555354303d','4d4739755a6c686f64314e7654474e79597a4236625446584d55465563576877516c4e70646c4e445532683352584e745247354a576e4a545254303d','5631646d4e453031576a5a6d56316f795a6c4e31537939535a5764355a7a3039','5631646d4e453031576a5a6d56316f795a6c4e31537939535a5764355a7a3039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','650','NULL','NULL','21','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('121','2023-08-10 15:41:57','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4d6d5253515867794e307468516e4a4e553346455558564d5657633351543039','4e47786d615531556130356a576c6c5252464e79576b524e62544679647a3039','62587046636d4e6f63455a785a43394a623034784e305a304f5374315630557852554654556d5673645668306269394963456b76537a4a76647a303d','656b78684d6a686e57485a74623270685932684a4d6c426e51336c4d5657566962315a34636b4a4d6348566c634770525957354b524649785a7a303d','56464671634764614e7a6c4e536d685a513039345a4763795957314555543039','56464671634764614e7a6c4e536d685a513039345a4763795957314555543039','527a68795744564251316f72596c4635544552756558566e615756795a7a3039','750','NULL','NULL','22','0','0');

INSERT INTO sgc_2023_product (id, created_date_time, creator, creator_name, product_id, category_id, name, lower_case_name, product_code, lower_case_product_code, product_content, price, product_image, product_video, ordering, show_frontend, deleted) VALUES ('122','2023-08-12 15:55:16','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','6547354b61326c425a6c42574f556443624739575457396a6455677655543039','537a4a35624545724e6b38794d6e5a734d3142334e457454516e42615a7a3039','6546425864556471616d6875516e686b596b394e57554648516a5a57635374476254644f6154563361316c615a4778544e6a6845537a64444e56497a4d335577556c644c625664556456467362555276626d354762413d3d','59306334656b5669656d31754e316c4b513346534c325a4f623156534b7a4a36526c427a615868484d304a3561324e6b57477469616a567a57567032613164496158567856557472615556504f554e5a5448525759673d3d','636e6735636b59784b336c6f5557524765576461566a46686454423551543039','','526b6c3253454657525445345455567357466c615458563655545a6d55543039','50','NULL','NULL','7','0','0');


CREATE TABLE `sgc_2023_promotion_code` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `promotion_code_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `price` mediumtext NOT NULL,
  `expiry_date` date NOT NULL,
  `minimum_order_amount` double NOT NULL,
  `discount_upto_value` double NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `sgc_2023_settings` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `name` mediumtext NOT NULL,
  `value` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=91 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('1','top_portion_back_color','4d7a52536548525064314578613151774e5852316546465156544272647a3039','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('2','top_portion_text_color','55486c5652576c435545316e4e6d645363464531523164455357525651543039','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('3','table_header_back_color','4e485635535656484e585a714f56597a633264554e33647754327778647a3039','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('4','table_header_text_color','55486c5652576c435545316e4e6d645363464531523164455357525651543039','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('5','category_background_color','596b4d336432785763446c43566c4e7a53466851644841344e6e704951543039','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('6','category_text_color','5153744563586868616d3935596e4e77566c46754e6938355647357455543039','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('7','product_color1','54323554617a5a6f64565a716333526156556c7153466c4e5448424355543039','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('8','product_color2','54323554617a5a6f64565a716333526156556c7153466c4e5448424355543039','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('9','text_color','55486c5652576c435545316e4e6d645363464531523164455357525651543039','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('10','strike_color','55334672526d5230535870495955566d4f4468734f455a7152575a6851543039','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('11','rate_background_color','#ffff80','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('12','border_color','55486c5652576c435545316e4e6d645363464531523164455357525651543039','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('13','show_product_code','1','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('14','cart_background_color','5153744563586868616d3935596e4e77566c46754e6938355647357455543039','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('15','footer_content_message','65574e79655668346445315256454e7465454a6f56455a4e5a6a464e61477031513074465544517a516a466c4d564a34556b4a68626b5a586247466c563142454f545a435a5642474f55357151335a3056574a76597a4a79553056475755783354464d7a4d7a52706254565462586c35546b773064455243576d6c4e4d45314c5247465755554a774d4452535958463052464643616c647463454977553045354f445642526d5636616b56474e316b3152485a4e516c5676656a4a6d6430707664444654637a4d30623163354d455a455a303971546d4a4e6430643057564a425a466f345532316d526c4a485431703452303179597a6330546d6c71554652314e6b45765a54463665584d304f48524c5230315952575245626e684952466c43516c5a70646b643255314a764d7a597a4f5659354d6a597a646b6c6154335979576c646f516c684f546c5a495a58565064446477556c51725a546c7764325535536b633263466452563252694b324e77646d466a63576851565745354d6b4673546b4e61566a4e4d63564a786233684b5358497862555a5357556330536d31365954646d65485a314d6d49334d6b773365486849537939754f58466c636a4e6b4d32737a5a544a6a4e6c686e65456c56624642525955746d6545566f556d5a4a4c316734536c644761576b764d324a3352335a5864325930614449764e546452536e6c4e517a6c47556b46454e5774454e446776613273315132646c53306c704e545253626d744d4f484e6c54464e4f5432527a62556c4f5a336c704d5852696158426d51334178556c42535a4868724c32786b656a5a4d57565972597939545956566a5a30705353304a454d3074615654525a654374734d6b5a7365544a365a464e56555770524d6b30315a6c6c54527a4a36636b746b61554d795a6b7054556a4a47616b7734567a526d4d6a45315133426f576d52545a306c6f5653733261476c3053334130566d35454b7a4248556c6c4c576b64755979744b4c305a546144527351565633597a6843656d31576558703555453550644559785331646c567a557863576f314d465a4255476445626a6c54643170435155787952465a7a6330565a52553832526b3157556b354e556e4a6a57486c324e57746c6346463256304d33566d685352565671576b463057544e44554570774f575a704b3234324d693930596e5676516e55324d6c4a544d6e68544e7a5a3351585277526b5a4e5244565862576f3161323543576d5254617a4a6f4e6e56536445563059336c4a65457869565456505455644c516d7376596c6c365a4574316447467256457061546b4e6a53576c785469397765584a466345354c56466c324f566b795969396d4e303030553068704e3031306358646e596b46695543396d54554a745556566d59314a5a5a6b4a71576a46335647464c4b304a7a524546314e323159523252486430357456475a714f446c6c4e3145796557646c4d6a426c4e6a46324d6e493063477430546b4e4b5254643363323556646a4632556b567856555a5357486844537a565a6558644c4d444e6d55464a77637a685952326f764f486c77636c5932566b6877576c687a61444d774f555a596254553556316c3253797456616b5977536b38324e6a517653454a5756575258636e4e565a544e7163453933554731524e474e7a5132704a545759326147645954544657544767765355644a64486447517a683363564678596d637956314e4a626d647052466c50556d777a4d5574724c7a52704d6c457a566d4a785545525455584d794d6b645664584e71575845326358426857456b31526d5a77626b356c6457684e52306c465254303d','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('16','thankyou_message','634764794e33673257464e4b4c305270546a5a7a56574d78616d6b775233466c5a324678646c59344d6e7076556b5a314e334650515768475154303d','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('17','frontend_layout','596c4a735743394862576b3265464e314c3046305a484a6e5a304a5151543039','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('18','giftbox','534846735956493157457734646a4e6b6246424753324e736443746c51543039','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('19','terms_conditions','NULL','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('20','desktop_layout','564564545931525a61553079533273305743393262304d3359305a7955543039','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('21','tab_layout','564564545931525a61553079533273305743393262304d3359305a7955543039','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('22','mobile_layout','564564545931525a61553079533273305743393262304d3359305a7955543039','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('23','disable_site','4b3168475955783161336c7163314e3152454635646a56614e6e6f72647a3039','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('24','enquiry_customer_order_link','NULL','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('25','enquiry_customer_order_code','NULL','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('26','list_top_portion_back_color','55334672526d5230535870495955566d4f4468734f455a7152575a6851543039','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('27','list_top_portion_text_color','5153744563586868616d3935596e4e77566c46754e6938355647357455543039','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('28','list_table_header_back_color','4d327436626e6f3363544e33537a4a444e56553565446c5a566a425051543039','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('29','list_table_header_text_color','55334672526d5230535870495955566d4f4468734f455a7152575a6851543039','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('30','list_category_background_color','#800000','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('31','list_category_text_color','#ffff80','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('32','list_product_color1','#ffff80','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('33','list_product_color2','#ffff80','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('34','list_text_color','#400000','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('35','list_strike_color','#000000','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('36','list_border_color','#000000','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('37','grid_top_portion_back_color','576c6c7455316c7a59544a4e626e5676556c4535516b526f6157787051543039','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('38','grid_top_portion_text_color','5153744563586868616d3935596e4e77566c46754e6938355647357455543039','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('39','grid_category_background_color','#ffff80','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('40','grid_category_text_color','#804040','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('41','grid_product_color1','#ffff80','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('42','grid_product_color2','#ffff80','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('43','grid_text_color','#000000','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('44','grid_strike_color','#8d8d8d','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('45','pdf_font_size','9','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('46','category_based_multiple_image_upload','NULL','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('47','show_promotion_code','2','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('48','otp_verification','2','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('49','desktop_box_count','NULL','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('50','list_topbar_background_color','#c3c3c3','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('51','list_topbar_text_color','#000000','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('52','list_topbar_category_background_color','#800000','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('53','list_topbar_category_text_color','#ffff80','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('54','list_topbar_rupees_background_color','#800000','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('55','list_topbar_rupees_text_color','#ffff80','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('56','list_table_head_color','#400040','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('57','list_table_head_text_color','#f1f1f1','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('58','grid_topbar_background_color','#ff8040','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('59','grid_topbar_text_color','#6c3600','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('60','grid_topbar_category_background_color','#ffff80','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('61','grid_topbar_category_text_color','#800040','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('62','grid_topbar_rupees_background_color','#800000','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('63','grid_topbar_rupees_text_color','#ffff80','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('64','grid_border_color','#000000','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('65','rate_text_color','#000000','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('66','grid_product_code_background_color','#ffff80','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('67','grid_product_code_text_color','#000000','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('68','box_topbar_background_color','#804040','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('69','box_topbar_text_color','#ffff80','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('70','box_topbar_category_background_color','#ffff80','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('71','box_topbar_category_text_color','#804040','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('72','box_topbar_rupees_background_color','#800000','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('73','box_topbar_rupees_text_color','#ffff80','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('74','box_category_background_color','#ffff80','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('75','box_category_text_color','#800000','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('76','box_strike_color','#000000','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('77','box_product_code_background_color','#ffff80','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('78','box_product_code_text_color','#800000','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('79','new_arrivals_category_count','1','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('80','new_arrivals_headings','NULL','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('81','new_arrivals_products','NULL','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('82','pricelist_display_in_home_page','2','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('83','download_pricelist_pdf_in_frontend','1','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('84','show_discoun_row','2','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('85','show_category_filter','2','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('86','show_search_filter','2','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('87','disable_page_form','2','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('88','disable_page_image','NULL','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('89','product_price_display_format','1','0');

INSERT INTO sgc_2023_settings (id, name, value, deleted) VALUES ('90','apply_frontend_actual_rate','1','0');


CREATE TABLE `sgc_2023_settings_private` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `name` mediumtext NOT NULL,
  `value` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `sgc_2023_staff` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `staff_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `user_id` mediumtext NOT NULL,
  `password` mediumtext NOT NULL,
  `access_pages` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO sgc_2023_staff (id, created_date_time, creator, creator_name, staff_id, name, mobile_number, user_id, password, access_pages, deleted) VALUES ('1','2023-08-12 15:16:09','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','517a67784d6e6c534e6b314e636a644765456b32554556494d6a5646647a3039','62316c7762325244626c45304d546c725653396e52473175623356335a7a3039','6130686c4d5339704c7a4d3252793935526c68435a306832643038785a7a3039','62316c7762325244626c45304d546c725653396e52473175623356335a7a3039','63455669576a64614d30643157444a5261304a785a79746e52565178647a3039','59324d35547a5a4f6157526164554a6e56566f72533170796248566c5a7a3039','0');


CREATE TABLE `sgc_2023_state_city` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `state` mediumtext NOT NULL,
  `minimum_order_amount` mediumtext NOT NULL,
  `packing_charges` mediumtext NOT NULL,
  `all_cities` int(100) NOT NULL,
  `cities` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO sgc_2023_state_city (id, state, minimum_order_amount, packing_charges, all_cities, cities, deleted) VALUES ('1','656b4a7956476f344e6a42685132357057546c73626e466e5647703051543039','NULL','NULL','1','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','0');


CREATE TABLE `sgc_2023_user` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `staff_id` mediumtext NOT NULL,
  `user_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `type` mediumtext NOT NULL,
  `code` mediumtext NOT NULL,
  `lower_case_code` mediumtext NOT NULL,
  `password` mediumtext NOT NULL,
  `admin` int(100) NOT NULL,
  `fcm_id` mediumtext NOT NULL,
  `deleted` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO sgc_2023_user (id, created_date_time, creator, creator_name, staff_id, user_id, name, mobile_number, type, code, lower_case_code, password, admin, fcm_id, deleted) VALUES ('1','2021-07-12 09:44:21','VzBuVkJYUEp1b0VHOVdyOVRCN05HZz09','5a6d746c4e6d4a346544566c51553174616e64696130686a544864495a7a3039','NULL','4e6b5a3054445a464e793946625574746447686c556a42436133426a55543039','644735724b326c4c4e586c6a5954424e4d4670364d476c34516c5a4955555a3555334533556a597752453835557a4e68625670785a47387a5154303d','4d304e565954677a5257787a63323536643031754e48687751546c4b5a7a3039','4f445a70596e4130656a593053324e55616e64565655645a563156585a7a3039','5a6d746c4e6d4a346544566c51553174616e64696130686a544864495a7a3039','5232684b4b3034345a305a7862315a316232356955587077544756334f44687a636d51344e6d5a51553278794d554e576244644f4e55633461453946557a567963577730523355794d57707a525546554d6d6451525664765433524a4d544e58547a42596345785355566c71656a4a73513342475a554e6b556c5a4964553933625852544d554e535369747953476339','63455669576a64614d30643157444a5261304a785a79746e52565178647a3039','1','','0');
