<button class="d-none otp_modal_button" data-toggle="modal" data-target="#otp_modal"></button>
<div class="modal fade model-forum" id="otp_modal" data-backdrop="static" data-keyboard="false" style="z-index:9999;">
    <div class="modal-dialog modal-width">
        <div class="modal-content" style="height: auto;">
            <div class="modal-header bg-green">
                <h1 class="fw-600 heading5 text-white mx-auto">OTP Verification</h1>
                <button type="button" class="close d-none" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <a href="Javascript:CloseOTPModal();" style="color: #fff; font-size: 30px; line-height: 30px; font-weight: bold;"><span aria-hidden="true">&times;</span></a>
            </div>
            <div class="modal-body mb-4">
                <form name="otp_form" class="digit-group text-center" data-group-name="digits" data-autosubmit="true" autocomplete="off">
                    <div class="row">
                        <div class="col-12">
                            <div class="pfnt fw-600 pb-4 text-center">We have sent an OTP on you number</div>
                            <div class="h-blue qfnt fw-600 text-center pb-4">Enter OTP</div>  
                            <input type="number" name="verify_otp_number" value="" class="form-control mx-auto" size="4" maxlength="4" style="width: auto;">
                            <div class="text-center pt-4 otp_action">
                                <button type="button" class="canvas-btn-submit" onClick="Javascript:VerifyOTPnumber();">Submit OTP</button>
                                &nbsp; <a href="Javascript:ResendOTP();" class="fw-400 h-blue text-center">Resend OTP?</a>
                            </div>
                        </div>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>

<style>
    .bg-green{background: #00BE74!important;}
</style>

<script type="text/javascript">
    function CloseOTPModal() {
        if(jQuery('#otp_modal').find('.modal-header').find('button.close').length > 0) {
            jQuery('#otp_modal').find('.modal-header').find('button.close').trigger('click');
        }
        if(jQuery('.submit_button').length > 0) {
            jQuery('.submit_button').attr('disabled', false);
        }
    }

    function ResendOTP() {
        if(jQuery('.digit-group').length > 0) {
            if(jQuery('.digit-group').find('.alert').length > 0) {
                jQuery('.digit-group').find('.alert').remove();
            }
            jQuery('.otp_action').before('<div class="alert alert-danger mb-2"> <button type="button" class="close" data-dismiss="alert">&times;</button>Processing</div>');
            var otp_insert_id = "";
            if(jQuery('input[name="verify_otp_number"]').length > 0) {
                otp_insert_id = jQuery('input[name="verify_otp_number"]').attr('max');
                otp_insert_id = jQuery.trim(otp_insert_id);
                jQuery.ajax({
                    type: 'POST',
                    url: "otp_changes.php",
                    data: {otp_id:otp_insert_id},
                    success: function(result){
                        result = jQuery.trim(result);

                        if(jQuery('.digit-group').find('.alert').length > 0) {
                            jQuery('.digit-group').find('.alert').remove();
                        }

                        var intRegex = /^\d+$/;
                        if(intRegex.test(result) == true) {
                            jQuery('.otp_action').before('<div class="alert alert-success mb-2"> <button type="button" class="close" data-dismiss="alert">&times;</button>OTP number is resend to register phone number</div>');
                        }
                        else {
                            jQuery('.otp_action').before('<div class="alert alert-danger mb-2"> <button type="button" class="close" data-dismiss="alert">&times;</button>'+result+'</div>');
                        }
                    }
                });
            }
        }
    }

    function VerifyOTPnumber() {
        if(jQuery('.digit-group').length > 0) {
            if(jQuery('.digit-group').find('.alert').length > 0) {
                jQuery('.digit-group').find('.alert').remove();
            }
            jQuery('.otp_action').before('<div class="alert alert-danger mb-2"> <button type="button" class="close" data-dismiss="alert">&times;</button>Processing</div>');
            var otp_insert_id = "";
            if(jQuery('input[name="verify_otp_number"]').length > 0) {
                otp_insert_id = jQuery('input[name="verify_otp_number"]').attr('max');
                otp_insert_id = jQuery.trim(otp_insert_id);

                otp_number = jQuery('input[name="verify_otp_number"]').val();
                otp_number = jQuery.trim(otp_number);

                jQuery.ajax({
                    type: 'POST',
                    url: "otp_changes.php",
                    data: {verify_otp_id:otp_insert_id, verify_otp_number:otp_number},
                    success: function(result){
                        result = jQuery.trim(result);

                        if(jQuery('.digit-group').find('.alert').length > 0) {
                            jQuery('.digit-group').find('.alert').remove();
                        }

                        var intRegex = /^\d+$/;
                        if(intRegex.test(result) == true) {
                            if(jQuery('#otp_modal').find('.modal-header').find('button').length > 0) {
                                jQuery('#otp_modal').find('.modal-header').find('button').trigger("click");
                            }

                            if(jQuery('input[name="otp_number"]').length > 0) {
                                jQuery('input[name="otp_number"]').val(otp_number);
                            }
                            
                            SaveModalContent('login_form', 'user_changes.php', 'dashboard.php');
                        }
                        else {
                            jQuery('.otp_action').before('<div class="alert alert-danger mb-2"> <button type="button" class="close" data-dismiss="alert">&times;</button>'+result+'</div>');
                        }
                    }
                });
            }            
        }
    }
</script>