<?php
	include("include.php");
	
	if(isset($_POST['page_number'])) {
		$page_number = $_POST['page_number'];
		$page_limit = $_POST['page_limit'];
		$page_title = $_POST['page_title'];

		$search_text = "";
		if(isset($_POST['search_text'])) {
			$search_text = $_POST['search_text'];
		}

		$total_records_list = array();
		$total_records_list = $obj->getTableRecords($GLOBALS['customer_table'], '', '');

		if(!empty($search_text)) {
			$search_text = strtolower($search_text);
			$list = array();
			if(!empty($total_records_list)) {
				foreach($total_records_list as $val) {
					if(strpos(strtolower($obj->encode_decode('decrypt', $val['name'])), $search_text) !== false || strpos(strtolower($obj->encode_decode('decrypt', $val['mobile_number'])), $search_text) !== false) {
						$list[] = $val;
					}
				}
			}
			$total_records_list = $list;
		}
		
		$total_pages = 0;
		if(!empty($total_records_list)) {
			$total_pages = count($total_records_list);
		}
		
		$page_start = 0; $page_end = 0;
		if(!empty($page_number) && !empty($page_limit) && !empty($total_pages)) {
			if($total_pages > $page_limit) {
				if($page_number) {
					$page_start = ($page_number - 1) * $page_limit;
					$page_end = $page_start + $page_limit;
				}
			}
			else {
				$page_start = 0;
				$page_end = $page_limit;
			}
		}

		$show_records_list = array();
        if(!empty($total_records_list)) {
            foreach($total_records_list as $key => $val) {
                if($key >= $page_start && $key < $page_end) {
                    $show_records_list[] = $val;
                }
            }
        }
?>
        
		<?php if($total_pages > $page_limit) { ?>
			<div class="pagination_cover mt-3"> 
				<?php
					include("pagination.php");
				?> 
			</div> 
		<?php } ?>

		<table class="table nowrap show_frontend_table">
            <thead>
                <tr>
					<th class="text-center px-2 py-2">S.No</th>
                    <!--<th class="text-center px-2 py-2">Created Date</th>-->
                    <th class="text-center px-2 py-2">Customer Name</th>
					<th class="text-center px-2 py-2">Mobile Number</th>
					<th class="text-center px-2 py-2">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php
                    if(!empty($show_records_list)) {
                        foreach($show_records_list as $key => $data) {
                ?>
							<tr>
								<td class="text-center px-2 py-2"><?php echo $key + 1; ?></td>
								<?php /* ?><td class="text-center px-2 py-2">
									<?php if(!empty($data['created_date_time']) && $data['created_date_time'] != "0000-00-00 00:00:00") { echo date("d-m-Y", strtotime($data['created_date_time'])); } ?>
								</td> <?php */ ?>
								<td class="px-2 py-2">
									<div class="w-100">
										<?php
											if(!empty($data['name'])) {
												$data['name'] = $obj->encode_decode('decrypt', $data['name']);
												echo $data['name'];
											}
										?>
									</div>
									
									<?php
										if(!empty($data['creator_name'])) {
											$data['creator_name'] = $obj->encode_decode('decrypt', $data['creator_name']);
									?>
											<small><?php echo "creator : ".$data['creator_name']; ?></small>
									<?php		
										}
									?>
								</td>
								<td class="text-center px-2 py-2">
                                    <?php
                                        if(!empty($data['mobile_number'])) {
                                            $data['mobile_number'] = $obj->encode_decode('decrypt', $data['mobile_number']);
                                            echo $data['mobile_number'];
                                        }
                                    ?>
								</td>
                                <td class="text-center px-2 py-2">
									<div class="dropdown">
										<a class="btn btn-dark poppins px-3" href="#" role="button" data-toggle="dropdown">
											<i class="fa fa-ellipsis-v text-white"></i>
										</a>
										<div class="dropdown-menu dropdown-menu-right dropdown-menu-icon-list">
											<a class="dropdown-item" href="Javascript:UpdateCustomer('<?php if(!empty($data['customer_id'])) { echo $data['customer_id']; } ?>');"><i class="fa fa-pencil"></i> &ensp; View / Edit</a>
										</div>
									</div>
								</td>
							</tr>
                <?php
                        }
                    }
                    else {
                ?>
                        <tr>
                            <td colspan="4" class="text-center">Sorry! No records found</td>
                        </tr>
                <?php } ?>
            </tbody>
        </table>
<?php	
	}
?>