<?php
    include("../include.php");
    require_once('../../order/fpdf/fpdf.php');
	
	$company_list = array();
    $company_list = $obj->getTableRecords($GLOBALS['company_table'], '', '');

    foreach($company_list as $data){
        $company_name = ""; $company_address = ""; $company_mobile = ""; $company_email = ""; $logo = "";

        if(!empty($data['name'])) {
            $company_name = $obj->encode_decode('decrypt', $data['name']);
        }
        if(!empty($data['logo']) && $data['logo'] != $GLOBALS['null_value']) {
            $logo = $data['logo'];
        }
        if(!empty($data['address']) && $data['address'] != $GLOBALS['null_value']) {
            $company_address = $obj->encode_decode('decrypt', $data['address']);
        }
        if(!empty($data['mobile_number'])) {
            $company_mobile = $obj->encode_decode('decrypt', $data['mobile_number']);
        }
        if(!empty($data['email'])) {
            $company_email = $obj->encode_decode('decrypt', $data['email']);
        }
    }

    $from_date = ""; $to_date = ""; $customer_id = ""; $staff_id = ""; $status = ""; $order_type = "";

    if(!empty($_REQUEST['from_date'])){
        $from_date = $_REQUEST['from_date'];
    }
    if(!empty($_REQUEST['to_date'])){
        $to_date = $_REQUEST['to_date'];
    }
    if(!empty($_REQUEST['customer_id'])){
        $customer_id = $_REQUEST['customer_id'];
    }
    if(!empty($_REQUEST['staff_id'])){
        $staff_id = $_REQUEST['staff_id'];
    }
    if(!empty($_REQUEST['status'])){
        $status = $_REQUEST['status'];
    }
    if(!empty($_REQUEST['order_type'])){
        $order_type = $_REQUEST['order_type'];
    }
    
    $orders_list = array();
    $orders_list = $obj->DisplayCrackerOrders($from_date, $to_date, $customer_id, $staff_id, $status, $order_type, '', '', '', '');

    $logo = "../../images/logo.png";
    
    $pdf = new FPDF('P','mm','A4');
    $pdf->AliasNbPages(); 
    $pdf->AddPage();
    $pdf->SetAutoPageBreak(true);
    $pdf->SetTitle('Orders List');
    $pdf->SetFont('Arial','B',10);
    $pdf->SetY(10);
    $pdf->Cell(0,5,strtoupper($company_name),0,1,'C',0);
    $pdf->SetFont('Arial','',7);
    $pdf->Cell(0,4,$company_address,0,1,'C',0);
    $pdf->Cell(0,4,'E-mail : '.$company_email.'   Phone : '.$company_mobile,0,1,'C',0);

    if(!empty($logo)){
        $pdf->Image($logo,10,7,25,20);
    }
    $heading = "";
    if(!empty($customer_id)) {
        $customer_name = "";
        $customer_name = $obj->getTableColumnValue($GLOBALS['customer_table'], 'customer_id', $customer_id, 'name');
        if(!empty($customer_name)) {
            $customer_name = $obj->encode_decode('decrypt', $customer_name);
            $heading = $customer_name." Order Report";
        }
    }
    else{
        $heading = 'Order Report';
    }

    if(!empty($from_date) || !empty($to_date)) {
        $heading = $heading." - ( ";
        if(!empty($from_date)) { 
            $heading = $heading."From Date : ".date("d-m-Y", strtotime($from_date)); 
            if(!empty($to_date)) { $heading = $heading." "; }
        }
        if(!empty($to_date)) { $heading = $heading."To Date : ".date("d-m-Y", strtotime($to_date)); }
        $heading = $heading." )";
    }
    
    $pdf->SetY(7);
    $pdf->Cell(0,20,'',1,1,'L',0);
    $pdf->SetFont('Arial','B',9);
    $pdf->Cell(0,6,$heading,1,1,'C',0);
    $pdf->SetFont('Arial','B',8);
    $pdf->SetX(10);
    $pdf->Cell(10,5,'S.No',1,0,'C',0);
    $pdf->SetX(20);
    $pdf->Cell(25,5,'Order Type',1,0,'C',0);
    $pdf->SetX(45);
    $pdf->Cell(20,5,'Order Number',1,0,'C',0);
    $pdf->SetX(65);
    $pdf->Cell(20,5,'Order Date',1,0,'C',0);
    $pdf->SetX(85);
    $pdf->Cell(40,5,'Customer Name',1,0,'C',0);
    $pdf->SetX(125);
    $pdf->Cell(25,5,'City',1,0,'C',0);
    $pdf->SetX(150);
    $pdf->Cell(25,5,'Mobile',1,0,'C',0);
    $pdf->SetX(175);
    $pdf->Cell(25,5,'Amount',1,1,'C',0);
    $pdf->SetFont('Arial','',8);

    if(!empty($orders_list)) {
        $sno = 1; $total_amount = 0;
        foreach($orders_list as $data) {

            if(!empty($data['total_amount'])) {
                $total_amount = $total_amount + $data['total_amount'];
            }

            if($pdf->GetY()>260){
                $pdf->AddPage();
                $pdf->SetFont('Arial','B',10);
                $pdf->SetY(10);
                $pdf->Cell(0,5,strtoupper($company_name),0,1,'C',0);
                $pdf->SetFont('Arial','',7);
                $pdf->Cell(0,4,$company_address,0,1,'C',0);
                $pdf->Cell(0,4,'E-mail : '.$company_email.'   Phone : '.$company_mobile,0,1,'C',0);

                if(!empty($logo)){
                    $pdf->Image($logo,10,7,25,20);
                }

                $heading = "";
                if(!empty($customer_id)) {
                    $customer_name = "";
                    $customer_name = $obj->getTableColumnValue($GLOBALS['customer_table'], 'customer_id', $customer_id, 'name');
                    if(!empty($customer_name)) {
                        $customer_name = $obj->encode_decode('decrypt', $customer_name);
                        $heading = $customer_name." Order Report";
                    }
                }
                else{
                    $heading = 'Order Report';
                }
                
                if(!empty($from_date) || !empty($to_date)) {
                    $heading = $heading." - ( ";
                    if(!empty($from_date)) { 
                        $heading = $heading."From Date : ".date("d-m-Y", strtotime($from_date)); 
                        if(!empty($to_date)) { $heading = $heading." "; }
                    }
                    if(!empty($to_date)) { $heading = $heading."To Date : ".date("d-m-Y", strtotime($to_date)); }
                    $heading = $heading." )";
                }
                
                $pdf->SetY(7);
                $pdf->Cell(0,20,'',1,1,'L',0);
                $pdf->SetFont('Arial','B',9);
                $pdf->Cell(0,6,$heading,1,1,'C',0);
                $pdf->SetFont('Arial','B',8);
                $pdf->SetX(10);
                $pdf->Cell(10,5,'S.No',1,0,'C',0);
                $pdf->SetX(20);
                $pdf->Cell(25,5,'Order Type',1,0,'C',0);
                $pdf->SetX(45);
                $pdf->Cell(20,5,'Order Number',1,0,'C',0);
                $pdf->SetX(65);
                $pdf->Cell(20,5,'Order Date',1,0,'C',0);
                $pdf->SetX(85);
                $pdf->Cell(40,5,'Customer Name',1,0,'C',0);
                $pdf->SetX(125);
                $pdf->Cell(25,5,'City',1,0,'C',0);
                $pdf->SetX(150);
                $pdf->Cell(25,5,'Mobile',1,0,'C',0);
                $pdf->SetX(175);
                $pdf->Cell(25,5,'Amount',1,1,'C',0);
                $pdf->SetFont('Arial','',8);
            }
            $yaxis = $pdf->GetY();
            $pdf->SetX(10);
            $pdf->Cell(10,5,$sno,0,0,'C',0);
            $pdf->SetX(20);
            $data['order_type'] = $obj->encode_decode('decrypt', $data['order_type']);
            $pdf->Cell(25,5,$data['order_type'],0,0,'C',0);
            $order_number = "";
            if(!empty($data['order_number']) && $data['order_number'] != $GLOBALS['null_value']) {
                $order_number = $obj->encode_decode('decrypt', $data['order_number']);
            }
            $pdf->SetX(45);
            $pdf->Cell(20,5,$order_number,0,0,'C',0);
            $pdf->SetX(65);
            $pdf->Cell(20,5,date("d-m-Y", strtotime($data['order_date'])),0,0,'C',0);
            $pdf->SetX(85);
            if(!empty($data['customer_details'])) {
                $data['customer_details'] = $obj->encode_decode('decrypt', $data['customer_details']);
                $customer_details = explode("<br>", $data['customer_details']);
            }
            $pdf->MultiCell(40,5,$customer_details['0'],0,'L',0);
            $pdf->SetY($yaxis);
            if(!empty($data['customer_id'])){
                $customer_id = "";
                $customer_id = $data['customer_id'];

                $customer_list = $obj->getTableRecords($GLOBALS['customer_table'],'customer_id',$customer_id);
                if(!empty($customer_list)){
                    foreach($customer_list as $customer){
                        $pdf->SetX(125);
                        $city = "";
                        if(!empty($data['customer_city']) && $data['customer_city'] != $GLOBALS['null_value']){
                            $city = $obj->encode_decode('decrypt',$data['customer_city']);
                        }
                        if(!empty($customer['mobile_number'])){
                            $customer['mobile_number'] = $obj->encode_decode('decrypt',$customer['mobile_number']);
                        }
                        $pdf->Cell(25,5,$city,0,0,'C',0);
                        $pdf->Cell(25,5,$customer['mobile_number'],0,0,'C',0);
                    }
                }
            }
            $yaxis1 = $pdf->GetY();
            $pdf->SetY($yaxis);
            $pdf->SetX(175);
            $pdf->Cell(25,5,number_format($data['total_amount'], 2),0,0,'R',0);

            $height = 5; $y="";
            if($yaxis1>$yaxis){
                $height = $yaxis1 - $yaxis;
            }
            $pdf->SetY($yaxis);
            $pdf->SetX(10);
            $pdf->Cell(10,$height,'',1,0,'C',0);
            $pdf->SetX(20);
            $pdf->Cell(25,$height,'',1,0,'C',0);
            $pdf->SetX(45);
            $pdf->Cell(20,$height,'',1,0,'C',0);
            $pdf->SetX(65);
            $pdf->Cell(20,$height,'',1,0,'C',0);
            $pdf->SetX(85);
            $pdf->Cell(40,$height,'',1,0,'C',0);
            $pdf->SetX(125);
            $pdf->Cell(25,$height,'',1,0,'C',0);
            $pdf->SetX(150);
            $pdf->Cell(25,$height,'',1,0,'C',0);
            $pdf->SetX(175);
            $pdf->Cell(25,$height,'',1,1,'C',0);

            $sno++;
        }
        $pdf->SetFont('Arial','B',8);
        $pdf->SetX(10);
        $pdf->Cell(165,5,'Total',1,0,'R',0);
        $pdf->SetX(175);
        $pdf->Cell(25,5,number_format($total_amount, 2),1,1,'R',0);
    }
    
    $pdf->SetY(-10);
    $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);

    $pdf->Output();
?>