<?php
    $total_records_list = array();
    $total_records_list = $obj->getCustomerChitListByFilter($filter_from_date, $filter_to_date, $filter_agent_id, $filter_customer_id, $filter_chit_id, $cancelled);

    if(!empty($search_text)) {
        $search_text = strtolower($search_text);
        $list = array();
        if(!empty($total_records_list)) {
            foreach($total_records_list as $val) {
                if( (strpos(strtolower($obj->encode_decode('decrypt', $val['customer_chit_unique_number'])), $search_text) !== false) || (strpos(strtolower($obj->encode_decode('decrypt', $val['chit_details'])), $search_text) !== false) ) {
                    $list[] = $val;
                }
            }
        }
        $total_records_list = $list;
    }
    
    $total_pages = 0;
    if(!empty($total_records_list)) {
        $total_pages = count($total_records_list);
    }
    
    $page_start = 0; $page_end = 0;
    if(!empty($page_number) && !empty($page_limit) && !empty($total_pages)) {
        if($total_pages > $page_limit) {
            if($page_number) {
                $page_start = ($page_number - 1) * $page_limit;
                $page_end = $page_start + $page_limit;
            }
        }
        else {
            $page_start = 0;
            $page_end = $page_limit;
        }
    }

    $show_records_list = array();
    if(!empty($total_records_list)) {
        $show_records_list = array_slice($total_records_list, $page_start, $page_limit);
    }
?>
<?php if($total_pages > $page_limit) { ?>
    <div class="pagination_cover mt-3"> 
        <?php
            include("pagination.php");
        ?> 
    </div> 
<?php } ?>

<table class="table nowrap">
    <thead class="thead-dark">
        <tr>
            <th class="text-center px-2 py-2" style="width: 50px;">S.No</th>
            <th class="text-center px-2 py-2" style="width: 125px;">Created Date</th>
            <th class="text-center px-2 py-2" style="width: 150px;">Agent</th>
            <th class="text-center px-2 py-2" style="width: 150px;">Customer</th>
            <th class="text-center px-2 py-2" style="width: 150px;">Chit ID</th>
            <th class="text-center px-2 py-2">Chit Name</th>
            <th class="text-center px-2 py-2" style="width: 100px;">Due Count</th>
            <th class="text-center px-2 py-2" style="width: 125px;">Balance</th>
            <th class="text-center px-2 py-2" style="<?php if(!empty($cancelled) && $cancelled == 1) { ?>width: 200px;<?php } else { ?>width: 100px;<?php } ?>">Action</th>
        </tr>
    </thead>
    <tbody>
    <?php
        if(!empty($show_records_list)) {
            foreach($show_records_list as $key => $data) {
                $index = $key + 1;
                if(!empty($page_number) && $page_number > 1) {
                    $prefix = 0;
                    $prefix = ($page_number * $page_limit) - $page_limit;
                    if(!empty($prefix)) {
                        $index = $prefix + $index;
                    }
                }
    ?>
                <tr>
                    <td class="text-center px-2 py-2" style="width: 75px;"><?php echo $index; ?></td>
                        <td class="text-center px-2 py-2">
                            <?php if(!empty($data['created_date_time']) && $data['created_date_time'] != "0000-00-00 00:00:00") { echo date("d-m-Y", strtotime($data['created_date_time'])); } ?>
                        </td>
                        <td class="text-center px-2 py-2">
                            <?php
                                if(!empty($data['agent_details']) && $data['agent_details'] != $GLOBALS['null_value']) {
                                    $data['agent_details'] = $obj->encode_decode('decrypt', $data['agent_details']);
                                    echo $data['agent_details'];
                                }
                            ?>
                        </td>
                        <td class="text-center px-2 py-2">
                            <?php
                                if(!empty($data['customer_details']) && $data['customer_details'] != $GLOBALS['null_value']) {
                                    $data['customer_details'] = $obj->encode_decode('decrypt', $data['customer_details']);
                                    $data['customer_details'] = str_replace("$$$", "<br>", $data['customer_details']);
                                    echo $data['customer_details'];
                                }
                            ?>
                        </td>
                        <td class="text-center px-2 py-2">
                            <?php
                                if(!empty($data['customer_chit_unique_number'])) {
                                    $data['customer_chit_unique_number'] = $obj->encode_decode('decrypt', $data['customer_chit_unique_number']);
                                    echo $data['customer_chit_unique_number'];
                                }
                            ?>
                        </td>
                        <td class="px-2 py-2">
                            <div class="w-100">
                                <?php
                                    if(!empty($data['chit_details'])) {
                                        $data['chit_details'] = $obj->encode_decode('decrypt', $data['chit_details']);
                                        echo $data['chit_details'];
                                    }
                                ?>
                            </div>
                            
                            <?php
                                if(!empty($data['creator_name'])) {
                                    $data['creator_name'] = $obj->encode_decode('decrypt', $data['creator_name']);
                            ?>
                                    <small><?php echo "Last Opened : ".$data['creator_name']; ?></small>
                            <?php		
                                }
                            ?>
                        </td>
                        <td class="text-center px-2 py-2">
                            <?php
                                if(!empty($data['due_count'])) {
                                    echo $data['due_count'];
                                }
                            ?>
                        </td>
                        <td class="text-left px-2 py-2">
                            <?php /*if(!empty($data['wallet'])) { ?>
                            <div class="w-100">
                                <?php
                                    $data['wallet'] = $obj->truncate_number($data['wallet'], 2);
                                    echo "Wallet : ".$data['wallet'];
                                ?>
                            </div>
                            <?php } ?>
                            <?php if(!empty($data['commission'])) { ?>
                            <div class="w-100">
                                <?php
                                    $data['commission'] = $obj->truncate_number($data['commission'], 2);
                                    echo "Commission : ".$data['commission'];
                                ?>
                            </div>
                            <?php }*/ ?>

                            <?php if(!empty($data['amount_to_use_order_agent'])) { ?>
                            <div class="w-100">
                                <?php
                                    $data['amount_to_use_order_agent'] = $obj->truncate_number($data['amount_to_use_order_agent'], 2);
                                    echo "Agent : ".$data['amount_to_use_order_agent'];
                                ?>
                            </div>
                            <?php } ?>
                            <?php if(!empty($data['amount_to_use_order_customer'])) { ?>
                            <div class="w-100">
                                <?php
                                    $data['amount_to_use_order_customer'] = $obj->truncate_number($data['amount_to_use_order_customer'], 2);
                                    echo "Customer : ".$data['amount_to_use_order_customer'];
                                ?>
                            </div>
                            <?php } ?>
                        </td>
                        <td class="text-center px-2 py-2">
                            <?php if(!empty($cancelled) && $cancelled == 1) { ?>
                                <?php
                                    if(!empty($data['cancel_remarks'])) {
                                        $data['cancel_remarks'] = $obj->encode_decode('decrypt', $data['cancel_remarks']);
                                        echo $data['cancel_remarks'];
                                    }
                                ?>
                            <?php } else { ?>
                            <div class="dropdown">
                                <a class="btn btn-dark poppins px-3" href="#" role="button" data-toggle="dropdown">
                                    <i class="fa fa-ellipsis-v text-white"></i>
                                </a>
                                <div class="dropdown-menu dropdown-menu-right dropdown-menu-icon-list">
                                    <a class="dropdown-item" href="Javascript:ShowModalContent('<?php if(!empty($page_title)) { echo $page_title; } ?>', '<?php if(!empty($data['customer_chit_id'])) { echo $data['customer_chit_id']; } ?>');"><i class="fa fa-pencil"></i> &ensp; View / Edit</a>
                                    <a class="dropdown-item" href="Javascript:CancelModalContent('<?php if(!empty($page_title)) { echo $page_title; } ?>', '<?php if(!empty($data['customer_chit_id'])) { echo $data['customer_chit_id']; } ?>');"><i class="fa fa-trash"></i> &ensp; Cancel</a>
                                </div>
                            </div>
                            <?php } ?>
                        </td>
                    </tr>
        <?php
                }
            }
            else {
        ?>
                <tr>
                    <td colspan="9" class="text-center">Sorry! No records found</td>
                </tr>
        <?php } ?>
    </tbody>
</table>