<?php
    include("include_user_check.php");

	$customer_list = array();
	$customer_list = $obj->getTableRecords($GLOBALS['customer_table'], '', '');

?>
<table class="table nowrap" id="table2excel_table">
    <thead class="thead-dark">
        <tr>
            <th class="text-center px-2 py-2" style="width: 75px;">S.No</th>
            <th class="text-center px-2 py-2" style="width: 125px;">Created Date</th>
            <th class="text-center px-2 py-2" style="width: 150px;">Customer ID</th>
            <th class="text-center px-2 py-2">Name</th>
            <th class="text-center px-2 py-2" style="width: 150px;">Mobile Number</th>
        </tr>
    </thead>
    <tbody>
    <?php
        if(!empty($customer_list)) {
            foreach($customer_list as $key => $data) {
                $index = $key + 1;
                if(!empty($page_number) && $page_number > 1) {
                    $prefix = 0;
                    $prefix = ($page_number * $page_limit) - $page_limit;
                    if(!empty($prefix)) {
                        $index = $prefix + $index;
                    }
                }
    ?>
                <tr>
                    <td class="text-center px-2 py-2" style="width: 75px;"><?php echo $index; ?></td>
                        <td class="text-center px-2 py-2">
                            <?php if(!empty($data['created_date_time']) && $data['created_date_time'] != "0000-00-00 00:00:00") { echo date("d-m-Y", strtotime($data['created_date_time'])); } ?>
                        </td>
                        <td class="text-center px-2 py-2">
                            <?php
                                if(!empty($data['customer_unique_number'])) {
                                    $data['customer_unique_number'] = $obj->encode_decode('decrypt', $data['customer_unique_number']);
                                    echo $data['customer_unique_number'];
                                }
                            ?>
                        </td>
                        <td class="px-2 py-2">
                            <?php
                                if(!empty($data['name'])) {
                                    $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                                    echo $data['name'];
                                }
                            ?>
                        </td>
                        <td class="text-center px-2 py-2">
                            <?php
                                if(!empty($data['mobile_number'])) {
                                    $data['mobile_number'] = $obj->encode_decode('decrypt', $data['mobile_number']);
                                    echo $data['mobile_number'];
                                }
                            ?>
                        </td>
                    </tr>
        <?php
                }
            }
            else {
        ?>
                <tr>
                    <td colspan="5" class="text-center">Sorry! No records found</td>
                </tr>
        <?php } ?>
    </tbody>
</table>

<?php include "footer.php"; ?>

<script type="text/javascript" src="include/js/xlsx.full.min.js"></script>
<script>
    function table2excel(table, name) {
        var uri = 'data:application/vnd.ms-excel;base64,'
            ,
            template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><meta http-equiv="content-type" content="application/vnd.ms-excel; charset=UTF-8"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body><table>{table}</table></body></html>'
            , base64 = function (s) {
                return window.btoa(unescape(encodeURIComponent(s)))
            }
            , format = function (s, c) {
                return s.replace(/{(\w+)}/g, function (m, p) {
                    return c[p];
                })
            }
        if (!table.nodeType) table = document.getElementById(table)
        var ctx = {worksheet: name || 'Worksheet', table: table.innerHTML}
        var a = document.createElement('a');
        a.href = uri + base64(format(template, ctx))
        a.download = name+'.xls';
        //triggering the function
        a.click();
    }

    $(document).ready(function(){
        $("#customeractive").addClass("active");

        table2excel('table2excel_table', 'customer');
        window.location = "customer.php";
    });
</script>