<?php
    class Booking_Functions extends Chit_Functions {
		// show booking orders
		public function ShowBookingOrders($agent_id, $customer_id) {
			$show_booking = 0; $chit_count = 0; $select_query = ""; $where = ""; $current_date = date("Y-m-d");

			$where = "'".$current_date."' >= DATE(booking_open_date)";
			if(!empty($customer_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_id = '".$customer_id."'";
                }
                else {
                    $where = "customer_id = '".$customer_id."'";
                }
            }
			else if(!empty($agent_id)) {
                if(!empty($where)) {
                    $where = $where." AND agent_id = '".$agent_id."'";
                }
                else {
                    $where = "agent_id = '".$agent_id."'";
                }
            }
			if(!empty($where)) {
				$select_query = "SELECT COUNT(id) as chit_count FROM ".$GLOBALS['customer_chit_table']." WHERE ".$where." AND admin_approval = '1' AND deleted = '0'";
			}
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['customer_chit_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['chit_count'])) {
							$chit_count = $data['chit_count'];
						}
					}
				}
			}
			if(!empty($chit_count)) {
				$show_booking = 1;
			}

			$current_year_diwali_date = "";
			$settings_list = array();
			$settings_list = $this->getTableRecords($GLOBALS['settings_table'], '', '');
			if(!empty($settings_list)) {
				foreach($settings_list as $data) {
					if( (!empty($data['name']) && $data['name'] == "current_year_diwali_date") && (!empty($data['value']) && $data['value'] != '0000-00-00') ) {
						$current_year_diwali_date = $data['value'];
					}
				}
			}

			if(!empty($current_date) && !empty($current_year_diwali_date)) {
				if(strtotime($current_date) > strtotime($current_year_diwali_date)) {
					$show_booking = 0;
				}
			}

			return $show_booking;
		}

		// get new customer list
		public function getNewCustomerList() {
			$list = array(); $select_query = "";

			$select_query = "SELECT * FROM ".$GLOBALS['customer_table']." WHERE new_customer = '1' AND deleted = '0'";
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['customer_table'], $select_query);
			}
			return $list;
		}

        // get ordering number
        public function getOrderingNumber($table, $category_id) {
			$ordering_number = 1; $select_query = "";

			if(!empty($table) && !empty($category_id)) {
				$select_query = "SELECT ordering FROM ".$table." WHERE category_id = '".$category_id."' AND deleted = '0' ORDER BY ordering DESC LIMIT 1";
			}
			else {
				$select_query = "SELECT ordering FROM ".$table." WHERE deleted = '0' ORDER BY ordering DESC LIMIT 1";
			}	

			if(!empty($select_query)) {
				$list = $this->getQueryRecords($table, $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['ordering'])) {
							$ordering_number = $data['ordering'] + 1;
						}
					}
				}
			}
			return $ordering_number;
		}

        // display category by ordering number
		public function DisplayCategoryByOrder() {
			$list = array(); $select_query = "";

			$select_query = "SELECT * FROM ".$GLOBALS['category_table']." WHERE deleted = '0' ORDER BY ordering ASC";
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['category_table'], $select_query);
			}
			return $list;
		}

        public function getClearTableRecords($tables) {
			$success = 0; $con = $this->connect();
			if(!empty($tables)) {
				foreach($tables as $table) {
					if(!empty($table)) {
						$table = trim(str_replace("'", "", $table));
						$update_query = "";
						$update_query = "UPDATE ".$table." SET deleted = '1'";
						if(!empty($update_query)) {							
							$result = $con->prepare($update_query);
							if($result->execute() === TRUE) {
								$success++;	
							}
						}
					}
				}
				if($success == count($tables)) {
					$success = 1;
				}
				else {
					$success = "Unable to clear";
				}
			}
			return $success;
		}

        // get nth number receord unique id
		public function getNthRecord($table, $number) {
			$unique_id = 0;
			if(!empty($table) && !empty($number)) {
				$number = $number - 1;
				$list = array(); $select_query = "";
				$select_query = "SELECT * FROM ".$table." ORDER BY ID LIMIT ".$number.", 1";
				//echo $select_query."<br>";
				if(!empty($select_query)) {
					$list = $this->getQueryRecords($table, $select_query);
					if(!empty($list)) {
						foreach($list as $data) {
							if(!empty($data['id'])) {
								$unique_id = $data['id'];
							}
						}
					}
				}
			}
			return $unique_id;	
		}

        // display category product by ordering number
		public function DisplayCategoryProductsByOrder($category_id) {
			$list = array(); $select_query = "";
			if(!empty($category_id)) {
				$select_query = "SELECT * FROM ".$GLOBALS['product_table']." WHERE category_id = '".$category_id."' AND deleted = '0' ORDER BY ordering ASC";
			}
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['product_table'], $select_query);
			}
			return $list;
		}

        public function ProductPricelist($frontend) {
			$company_logo = ""; $company_list = array();
			$company_list = $this->getTableRecords($GLOBALS['company_table'], '', '');
			if(!empty($company_list)) {
				foreach($company_list as $data) {
					if(!empty($data['logo']) && $data['logo'] != $GLOBALS['null_value']) {
						$company_logo = $data['logo'];
					}
				}
			}

			$target_dir = "";
    		$target_dir = $this->image_directory();
			$target_dir = str_replace("include/", "", $target_dir);

			$category_list = array(); $frontend_pricelist = array(); $backend_pricelist = array(); $pricelist = array();
			$category_list = $this->DisplayCategoryByOrder();
			if(!empty($category_list)) {
				foreach($category_list as $data) {

					if(!empty($frontend) && $frontend == 1) {
						if(empty($data['show_frontend'])) {
							if(!empty($data['category_id']) && !empty($data['name'])) {

								$product_list = array();
								$product_list = $this->DisplayCategoryProductsByOrder($data['category_id']);
								if(!empty($product_list)) {
									$frontend_products = array();
									foreach($product_list as $product) {
										if(!empty($product['product_image']) && $product['product_image'] != $GLOBALS['null_value']) {
											if(!file_exists($target_dir.$product['product_image']) && $company_logo != $GLOBALS['null_value']) {
												$product['product_image'] = $company_logo;
											}
										}
										$video_id = "";
										if(!empty($product['product_video']) && $product['product_video'] != $GLOBALS['null_value']) {
											$product['product_video'] = $this->encode_decode('decrypt', $product['product_video']);
											if(strpos($product['product_video'], "youtu.be/" ) !== false) {
												$matches = "";
												preg_match('/(https:|http:|)(\/\/www\.|\/\/|)(.*?)\/(.{11})/i', $product['product_video'], $matches);
												if(!empty($matches) && is_array($matches)) {
													if(!empty($matches['4'])) {
														$video_id = $matches['4'];
													}
												}
											}
										}
										$product['product_video_id'] = $video_id;

										if(empty($product['show_frontend'])) {
											$frontend_products[] = $product;
										}
									}
									$product_list = $frontend_products;
								}
								if(!empty($product_list)) {
									$frontend_pricelist[] = array('category_id' => $data['category_id'], 'category_name' => $data['name'], 'product_list' => $product_list);
								}
							}
						}
					}
					else {
						if(!empty($data['category_id']) && !empty($data['name'])) {
							$product_list = array();
							$product_list = $this->DisplayCategoryProductsByOrder($data['category_id']);
							if(!empty($product_list)) {
								$backend_pricelist[] = array('category_id' => $data['category_id'], 'category_name' => $data['name'], 'product_list' => $product_list);
							}
						}
					}

				}
			}

			if(!empty($frontend) && $frontend == 1) {
				$pricelist = $frontend_pricelist;
			}
			else {
				$pricelist = $backend_pricelist;
			}
			return $pricelist;
		}

		// get shipping address id
		public function DeliveryAddressExist($agent_id, $customer_id, $mobile_number) {
			$shipping_address_id = ""; $where = ""; $select_query = ""; $list = array();

            if(!empty($agent_id)) {
                $where = "agent_id = '".$agent_id."'";
            }
            if(!empty($customer_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_id = '".$customer_id."'";
                }
                else {
                    $where = "customer_id = '".$customer_id."'";
                }
            }
            if(!empty($mobile_number)) {
                if(!empty($where)) {
                    $where = $where." AND mobile_number = '".$mobile_number."'";
                }
                else {
                    $where = "mobile_number = '".$mobile_number."'";
                }
            }

            if(!empty($where)) {
                $select_query = "SELECT shipping_address_id FROM ".$GLOBALS['shipping_address_table']." WHERE ".$where." AND deleted = '0'";
                $list = $this->getQueryRecords($GLOBALS['shipping_address_table'], $select_query);
                if(!empty($list)) {
                    foreach($list as $data) {
                        if(!empty($data['shipping_address_id'])) {
                            $unique_id = $data['shipping_address_id'];
                        }
                    }
                }
            }

            return $shipping_address_id;
		}

		// get shipping address list
		public function getShippingAddressList($agent_id, $customer_id, $mobile_number) {
			$where = ""; $select_query = ""; $list = array();

            if(!empty($agent_id)) {
                $where = "agent_id = '".$agent_id."'";
            }
            if(!empty($customer_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_id = '".$customer_id."'";
                }
                else {
                    $where = "customer_id = '".$customer_id."'";
                }
            }
            if(!empty($mobile_number)) {
                if(!empty($where)) {
                    $where = $where." AND mobile_number = '".$mobile_number."'";
                }
                else {
                    $where = "mobile_number = '".$mobile_number."'";
                }
            }
            if(!empty($where)) {
                $select_query = "SELECT * FROM ".$GLOBALS['shipping_address_table']." WHERE ".$where." AND deleted = '0'";
                $list = $this->getQueryRecords($GLOBALS['shipping_address_table'], $select_query);
            }

            return $list;
		}

		// get customer orders by filters
		public function getCustomerOrderListByFilter($from_date, $to_date, $state, $city, $agent_id, $customer_id, $chit_id, $order_status) {
			$where = ""; $select_query = ""; $list = array();

			if(!empty($from_date)) {
                $from_date = date("Y-m-d", strtotime($from_date));
                $where = "DATE(order_date) >= '".$from_date."'";
            }
            if(!empty($to_date)) {
                $to_date = date("Y-m-d", strtotime($to_date));
                if(!empty($where)) {
                    $where = $where." AND DATE(order_date) <= '".$to_date."'";
                }
                else {
                    $where = "DATE(order_date) <= '".$to_date."'";
                }
            }
			if(!empty($state)) {
                if(!empty($where)) {
                    $where = $where." AND customer_state = '".$state."'";
                }
                else {
                    $where = "customer_state = '".$state."'";
                }
            }
			if(!empty($city)) {
                if(!empty($where)) {
                    $where = $where." AND customer_city = '".$city."'";
                }
                else {
                    $where = "customer_city = '".$city."'";
                }
            }
			if(!empty($agent_id)) {
                if(!empty($where)) {
                    $where = $where." AND agent_id = '".$agent_id."'";
                }
                else {
                    $where = "agent_id = '".$agent_id."'";
                }
            }
            if(!empty($customer_id)) {
                if(!empty($where)) {
                    $where = $where." AND customer_id = '".$customer_id."'";
                }
                else {
                    $where = "customer_id = '".$customer_id."'";
                }
            }
			if(!empty($chit_id)) {
                if(!empty($where)) {
                    $where = $where." AND FIND_IN_SET('".$chit_id."', customer_chit_ids)";
                }
                else {
                    $where = "FIND_IN_SET('".$chit_id."', customer_chit_ids)";
                }
            }            

			if(!empty($order_status)) {
				$order_status = $this->encode_decode('decrypt', $order_status);
				if($order_status == $GLOBALS['order_status_new']) {
					if(!empty($where)) {
						$where = $where." AND new_order = '1' AND confirmed = '0' AND despatched = '0'";
					}
					else {
						$where = "new_order = '1' AND confirmed = '0' AND despatched = '0'";
					}
				}
				else if($order_status == $GLOBALS['order_status_confirm']) {
					if(!empty($where)) {
						$where = $where." AND new_order = '0' AND confirmed = '1'";
					}
					else {
						$where = "new_order = '0' AND confirmed = '1'";
					}
				}
				else if($order_status == $GLOBALS['order_status_despatch']) {
					if(!empty($where)) {
						$where = $where." AND new_order = '0' AND despatched = '1'";
					}
					else {
						$where = "new_order = '0' AND despatched = '1'";
					}
				}
			}

            if(!empty($where)) {
                $select_query = "SELECT * FROM ".$GLOBALS['order_table']." WHERE ".$where." AND deleted = '0' ORDER BY id DESC";
			}
			else {
				$select_query = "SELECT * FROM ".$GLOBALS['order_table']." WHERE deleted = '0' ORDER BY id DESC";
			}	
			//echo $select_query;
			if(!empty($select_query)) {
                $list = $this->getQueryRecords($GLOBALS['order_table'], $select_query);
            }

            return $list;
		}

    }
?>