<?php
    include("include.php");

    if(isset($_POST['page_number'])) {
		$page_number = $_POST['page_number'];
		$page_limit = $_POST['page_limit'];
		$page_title = $_POST['page_title'];

		$search_text = "";
		if(isset($_POST['search_text'])) {
			$search_text = $_POST['search_text'];
		}

		$total_records_list = array();
		$total_records_list = $obj->getTableRecords($GLOBALS['orders_despatch_table'], '', '');

        if(!empty($search_text)) {
			$search_text = strtolower($search_text);
			$list = array();
			if(!empty($total_records_list)) {
				foreach($total_records_list as $val) {
					if( (strpos(strtolower($obj->encode_decode('decrypt', $val['order_number'])), $search_text) !== false)) {
						$list[] = $val;
					}
				}
			}
			$total_records_list = $list;
		}
		
		$total_pages = 0;
		if(!empty($total_records_list)) {
			$total_pages = count($total_records_list);
		}
		
		$page_start = 0; $page_end = 0;
		if(!empty($page_number) && !empty($page_limit) && !empty($total_pages)) {
			if($total_pages > $page_limit) {
				if($page_number) {
					$page_start = ($page_number - 1) * $page_limit;
					$page_end = $page_start + $page_limit;
				}
			}
			else {
				$page_start = 0;
				$page_end = $page_limit;
			}
		}

		$show_records_list = array();
        if(!empty($total_records_list)) {
            $show_records_list = array_slice($total_records_list, $page_start, $page_limit);
        }

		$target_dir = $obj->image_directory();
?>
        
		<?php if($total_pages > $page_limit) { ?>
			<div class="pagination_cover mt-3"> 
				<?php
					include("pagination.php");
				?> 
			</div> 
		<?php } ?>

		<table class="table nowrap">
			<thead class="thead-dark">
                <tr>
					<th class="text-center px-2 py-2" style="width: 75px;">S.No</th>
                    <th class="text-center px-2 py-2" style="width: 125px;">Created Date</th>
                    <th class="text-center px-2 py-2" style="width: 125px;">Despatch Date</th>
                    <th class="text-center px-2 py-2" style="width: 200px;">Order ID</th>
                    <th class="text-center px-2 py-2" style="width: 200px;">LR Number</th>
                    <th class="text-center px-2 py-2">Transport Name</th>
					<th class="text-center px-2 py-2" style="width: 150px;">Transfer Details</th>
					<th class="text-center px-2 py-2" style="width: 100px;">LR Photo</th>
                </tr>
            </thead>
            <tbody>
			<?php
				if(!empty($show_records_list)) {
					foreach($show_records_list as $key => $data) {
						$index = $key + 1;
						if(!empty($page_number) && $page_number > 1) {
							$prefix = 0;
							$prefix = ($page_number * $page_limit) - $page_limit;
							if(!empty($prefix)) {
								$index = $prefix + $index;
							}
						}
			?>
						<tr>
							<td class="text-center px-2 py-2" style="width: 75px;"><?php echo $index; ?></td>
								<td class="text-center px-2 py-2">
									<?php if(!empty($data['created_date_time']) && $data['created_date_time'] != "0000-00-00 00:00:00") { echo date("d-m-Y", strtotime($data['created_date_time'])); } ?>
								</td>
                                <td class="text-center px-2 py-2">
									<?php if(!empty($data['despatch_date']) && $data['despatch_date'] != "0000-00-00") { echo date("d-m-Y", strtotime($data['despatch_date'])); } ?>
								</td>
								<td class="text-center px-2 py-2">
									<?php
										if(!empty($data['order_number'])) {
											$data['order_number'] = $obj->encode_decode('decrypt', $data['order_number']);
											echo $data['order_number'];
										}
									?>
								</td>
                                <td class="text-center px-2 py-2">
									<?php
										if(!empty($data['lr_number'])) {
											$data['lr_number'] = $obj->encode_decode('decrypt', $data['lr_number']);
											echo $data['lr_number'];
										}
									?>
								</td>
								<td class="px-2 py-2">
									<div class="w-100">
										<?php
											if(!empty($data['transport_name'])) {
												$data['transport_name'] = $obj->encode_decode('decrypt', $data['transport_name']);
												echo $data['transport_name'];
											}
										?>
									</div>
									
									<?php
										if(!empty($data['creator_name'])) {
											$data['creator_name'] = $obj->encode_decode('decrypt', $data['creator_name']);
									?>
											<small><?php echo "Last Opened : ".$data['creator_name']; ?></small>
									<?php		
										}
									?>
								</td>
                                <td class="text-center px-2 py-2">
									<?php
										if(!empty($data['transfer_details'])) {
                                            $data['transfer_details'] = $obj->encode_decode('decrypt', $data['transfer_details']);
                                            echo $data['transfer_details'];
                                        }
									?>
								</td>
								<td class="text-center px-2 py-2">
									<?php 
										if(!empty($data['lr_number_image']) && $data['lr_number_image'] != $GLOBALS['null_value']) { 
											$lr_path = $target_dir.$data['lr_number_image'];
									?>
											<button type="button" class="btn btn-dark" onClick="Javascript:ShowLRImage('<?php if(!empty($lr_path)) { echo $lr_path; } ?>');"> <i class="fa fa-image"></i> </button>
									<?php } ?>
								</td>
							</tr>
                <?php
                        }
                    }
                    else {
                ?>
                        <tr>
                            <td colspan="8" class="text-center">Sorry! No records found</td>
                        </tr>
                <?php } ?>
            </tbody>
        </table>
<?php	
	}
?>