<?php 
	$access_page = "Approval Pending Receipts";
    include("include_user_check.php");

    $page_title = "Approval Pending Receipts";

    $receipt_list = array();
    $receipt_list = $obj->getApprovalPendingReceiptList();

    $target_dir = $obj->image_directory();
    if(!empty($target_dir)) {
        $target_dir = str_replace("include", "..", $target_dir);
    }
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title> <?php if(!empty($project_title)) { echo $project_title; } ?> - <?php if(!empty($page_title)) { echo $page_title; } ?> </title>
	<?php include "link_style_script.php"; ?>

	<script type="text/javascript" src="include/js/common.js"></script>
    <script type="text/javascript" src="include/js/chit.js"></script>
</head>
<body>
	<?php include "header.php";  ?>
	<!-- sidebar-wrapper  -->          
	<div class="page-wrapper chiller-theme toggled">
		<main class="page-content">
			<div class="container-fluid px-lg-5">
                <div class="border card-box">

                    <div class="card-header">
                        <div class="row">
                            <div class="col-sm-6">
                                <?php if(!empty($page_title)) { echo $page_title; } ?>
                            </div>
                            <div class="col-sm-6 text-right">
                                <button type="button" class="btn btn-success" onClick="Javascript:SubmitRequest('approval');">Approval</button>
                                &nbsp;
                                <button type="button" class="btn btn-danger" onClick="Javascript:SubmitRequest('cancel');">Cancel</button>
                            </div>
                        </div>
                    </div>
                    <div id="table_records_cover">
                        <div id="table_listing_records" class="table-responsive poppins px-3 py-3">
                            <input type="hidden" name="page_title" value="receipt_approval">
                        
                            <form name="approval_pending_form" class="redirection_form" method="post">
                                <input type="hidden" name="approval_receipt" value="">
                                <div class="row mx-0">
                                    <div class="col-12 px-0">
                                        <table class="table nowrap">
                                            <thead class="thead-dark">
                                                <tr>
                                                    <th class="text-center px-2 py-2" style="width: 50px;">S.No</th>
                                                    <th class="text-center px-2 py-2" style="width: 150px;">Created Date</th>
                                                    <th class="text-center px-2 py-2" style="width: 200px;">Agent</th>
                                                    <th class="text-center px-2 py-2" style="width: 200px;">Customer</th>
                                                    <th class="text-center px-2 py-2">Chit Name</th>
                                                    <th class="text-center px-2 py-2" style="width: 200px;">Receipt ID</th>
                                                    <th class="text-center px-2 py-2" style="width: 150px;">Amount</th>
                                                    <?php /* ?><th class="text-center px-2 py-2" style="width: 100px;">Approval</th><?php */ ?>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                    if(!empty($receipt_list)) {
                                                        foreach($receipt_list as $key => $data) {
                                                            $index = $key + 1;

                                                            $transaction_id = ""; $transaction_screenshot = "";
                                                            if(!empty($data['transaction_id']) && $data['transaction_id'] != $GLOBALS['null_value']) {
                                                                $transaction_id = $obj->encode_decode('decrypt', $data['transaction_id']);                                                                
                                                            }
                                                            if(!empty($data['transaction_screenshot']) && $data['transaction_screenshot'] != $GLOBALS['null_value']) {
                                                                $transaction_screenshot = $data['transaction_screenshot'];
                                                                if(!empty($transaction_screenshot) && file_exists($target_dir.$transaction_screenshot)) {
                                                                    $transaction_screenshot = $target_dir.$transaction_screenshot;
                                                                }
                                                                else {
                                                                    $transaction_screenshot = "";	
                                                                }
                                                            }
                                                            else {
                                                                $transaction_screenshot = "";
                                                            }
                                                ?>
                                                        <tr>
                                                            <td class="text-center px-2 py-2"><?php echo $index; ?></td>
                                                                <td class="text-center px-2 py-2">
                                                                    <?php if(!empty($data['created_date_time']) && $data['created_date_time'] != "0000-00-00 00:00:00") { echo date("d-m-Y", strtotime($data['created_date_time'])); } ?>
                                                                </td>
                                                                <td class="text-center px-2 py-2">
                                                                    <?php
                                                                        if(!empty($data['agent_details']) && $data['agent_details'] != $GLOBALS['null_value']) {
                                                                            $data['agent_details'] = $obj->encode_decode('decrypt', $data['agent_details']);
                                                                            echo $data['agent_details'];
                                                                        }
                                                                    ?>
                                                                </td>
                                                                <td class="text-center px-2 py-2">
                                                                    <?php
                                                                        if(!empty($data['customer_details']) && $data['customer_details'] != $GLOBALS['null_value']) {
																			$data['customer_details'] = $obj->encode_decode('decrypt', $data['customer_details']);
																			$data['customer_details'] = str_Replace("$$$", "<br>", $data['customer_details']);
																			echo $data['customer_details'];
																		}
                                                                    ?>
                                                                </td>
                                                                <td class="text-center px-2 py-2">
                                                                    <div class="w-100">
                                                                        <?php
                                                                            if(!empty($data['customer_chit_details'])) {
                                                                                $data['customer_chit_details'] = $obj->encode_decode('decrypt', $data['customer_chit_details']);
                                                                                echo $data['customer_chit_details'];
                                                                            }
                                                                        ?>
                                                                    </div>
                                                                    <?php
                                                                        if(!empty($data['creator_name'])) {
                                                                            $data['creator_name'] = $obj->encode_decode('decrypt', $data['creator_name']);
                                                                    ?>
                                                                            <small><?php echo "Last Opened : ".$data['creator_name']; ?></small>
                                                                    <?php		
                                                                        }
                                                                    ?>
                                                                </td>
                                                                <td class="text-center px-2 py-2">
                                                                    <?php
                                                                        $field_name = "";
                                                                        if(!empty($data['receipt_unique_number'])) {
                                                                            $field_name = "approval_id_".$data['receipt_unique_number'];
                                                                        }
                                                                    ?>
                                                                    <div class="w-100">
                                                                        <?php if(!empty($transaction_screenshot)) { ?>
                                                                            <div class="row">
                                                                                <div class="col-9">
                                                                                    <div class="form-check">
                                                                                        <input class="form-check-input" type="checkbox" name="<?php if(!empty($field_name)) { echo $field_name; } ?>" onClick="Javascript:CustomCheckboxToggle(this, '<?php if(!empty($field_name)) { echo $field_name; } ?>');" value="<?php if(!empty($data['receipt_id'])) { echo $data['receipt_id']; } ?>" id="<?php if(!empty($field_name)) { echo $field_name; } ?>"/>
                                                                                        <label class="form-check-label" for="<?php if(!empty($field_name)) { echo $field_name; } ?>" onClick="Javascript:CustomCheckboxToggle(this, '<?php if(!empty($field_name)) { echo $field_name; } ?>');">
                                                                                            <?php
                                                                                                if(!empty($data['receipt_unique_number'])) {
                                                                                                    $data['receipt_unique_number'] = $obj->encode_decode('decrypt', $data['receipt_unique_number']);
                                                                                                    echo $data['receipt_unique_number'];
                                                                                                }
                                                                                            ?>
                                                                                        </label>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-3">
                                                                                    <span class="d-flex align-items-center justify-content-end view_transaction_image" onClick="Javascript:ViewTransactionImage('<?php if(!empty($transaction_id)) { echo $transaction_id; } ?>', '<?php if(!empty($transaction_screenshot)) { echo $transaction_screenshot; } ?>');">
                                                                                        <i class="fa fa-image"></i>
                                                                                    </span>
                                                                                </div>
                                                                            </div>
                                                                        <?php } else { ?>
                                                                            <div class="form-check">
                                                                                <input class="form-check-input" type="checkbox" name="<?php if(!empty($field_name)) { echo $field_name; } ?>" onClick="Javascript:CustomCheckboxToggle(this, '<?php if(!empty($field_name)) { echo $field_name; } ?>');" value="<?php if(!empty($data['receipt_id'])) { echo $data['receipt_id']; } ?>" id="<?php if(!empty($field_name)) { echo $field_name; } ?>"/>
                                                                                <label class="form-check-label" for="<?php if(!empty($field_name)) { echo $field_name; } ?>" onClick="Javascript:CustomCheckboxToggle(this, '<?php if(!empty($field_name)) { echo $field_name; } ?>');">
                                                                                    <?php
                                                                                        if(!empty($data['receipt_unique_number'])) {
                                                                                            $data['receipt_unique_number'] = $obj->encode_decode('decrypt', $data['receipt_unique_number']);
                                                                                            echo $data['receipt_unique_number'];
                                                                                        }
                                                                                    ?>
                                                                                </label>
                                                                            </div>
                                                                        <?php } ?>									
                                                                    </div>
                                                                </td>
                                                                <td class="text-center px-2 py-2">
                                                                    <?php
                                                                        if(!empty($data['amount'])) {
                                                                            $data['amount'] = $obj->truncate_number($data['amount'], 2);
                                                                            echo $data['amount'];
                                                                        }
                                                                    ?>
                                                                </td>
                                                                <?php /* ?><td class="text-center px-2 py-2">
                                                                    <div class="w-100 approval_receipt_toggle_cover">
                                                                        <label class="switch">
                                                                            <input type="checkbox" name="approval_receipt_id[]" id="approval_receipt_<?php if(!empty($data['receipt_id'])) { echo $data['receipt_id']; } ?>" value="<?php if(!empty($data['receipt_id'])) { echo $data['receipt_id']; } ?>" >
                                                                            <div class="slider round"></div>
                                                                        </label>
                                                                    </div>
                                                                </td><?php */ ?>
                                                            </tr>
                                                <?php
                                                        }
                                                    }
                                                    else {
                                                ?>
                                                        <tr>
                                                            <td colspan="7" class="text-center">Sorry! No records found</td>
                                                        </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                        <?php /*if(!empty($receipt_list)) { ?>
                                        <div class="w-100 mt-3 text-center">
                                            <button class="btn btn-primary btnwidth submit_button" type="button" onClick="Javascript:SaveModalContent(event, 'approval_pending_form', 'action_changes.php', 'receipt_approval.php');">Save</button>
                                            <!--&nbsp; <button class="btn btn-success btnwidth save_send_button" type="button" onClick="Javascript:SaveAndSend();">Save & Send</button>-->
                                        </div>
                                        <?php }*/ ?>
                                    </div>
                                </div>    
                            </form>

                        </div>
                    </div>

				</div>
			</div>
		</main>
	</div>  
	<!-- page-wrapper -->

	<?php include "footer.php"; ?>

	<script>
		jQuery(document).ready(function(){
            jQuery("#approvalactive").addClass("active");
			jQuery("#receipt_approvalactive").addClass("active");			
		});	
	</script>
	
    </body>
</html>