<?php if(!empty($my_scheme_list)) { ?>
<div class="forum-right">
    <div class="accordion" id="accordionExample">
        <?php
            foreach($my_scheme_list as $data) {
                if(!empty($data['customer_chit_id'])) {
                    $card_heading = "";
                    if(!empty($data['customer_chit_unique_number'])) {
                        $card_heading = $obj->encode_decode('decrypt', $data['customer_chit_unique_number']);
                        if(!empty($data['chit_details'])) {
                            $card_heading = $card_heading." - ".$obj->encode_decode('decrypt', $data['chit_details']);
                            if(!empty($data['maturity_value'])) {
                                $card_heading = $card_heading." Rs.".$data['maturity_value'];
                            }
                        }
                    }

                    $account_merger_id = "";
                    if(!empty($data['account_merger_id']) && $data['account_merger_id'] != $GLOBALS['null_value']) {
                        $account_merger_id = $data['account_merger_id'];
                    }

                    $order_id = "";
                    if(!empty($data['order_id']) && $data['order_id'] != $GLOBALS['null_value']) {
                        $order_id = $data['order_id'];
                    }

                    $current_due_by_chit = 0;
                    $current_due_by_chit = $obj->getCurrentDueByChit($data['customer_chit_id']);

                    $current_due_by_customer = 0;
                    $current_due_by_customer = $obj->getCurrentDueByUser($filter_agent_id, $filter_customer_id, $data['customer_chit_id'], '');
                    if(!empty($current_due_by_chit) && !empty($current_due_by_customer)) {
                        if($current_due_by_customer < $current_due_by_chit) {
                            if(!empty($card_heading)) {
                                $card_heading = $card_heading." (Pending Dues)";
                            }
                        }
                    }

                    $due_duration = 0;
                    if(!empty($data['due_duration'])) {
                        $due_duration = $data['due_duration'];
                    }

                    $due_amount = 0;
                    if(!empty($data['due_amount'])) {
                        $due_amount = $data['due_amount'];
                    }

                    $chit_type = ""; $end_date = ""; $receipt_due_dates = array(); $receipt_date = "";
                    if(!empty($data['end_date']) && $data['end_date'] != "0000-00-00") {
                        $end_date = date("d-m-Y", strtotime($data['end_date']));
                    }
                    if(!empty($data['chit_type'])) {
                        $chit_type = $obj->encode_decode('decrypt', $data['chit_type']);
                        if(!empty($chit_type)) {
                            if($chit_type == $GLOBALS['chit_type_monthly']) { 
                                if(!empty($due_duration)) {
                                    $receipt_date = $end_date;
                                    $loop = $due_duration;
                                    for($d = 0; $d < $loop; $d++) {
                                        $receipt_due_dates[] = $receipt_date;
                                        if(!empty($receipt_date)) {
                                            $receipt_date = date('d-m-Y', strtotime('-1 month', strtotime($receipt_date)));
                                        }
                                    }
                                    if(!empty($receipt_due_dates)) {
                                        $receipt_due_dates = array_reverse($receipt_due_dates);
                                    }
                                }
                            }
                            else if($chit_type == $GLOBALS['chit_type_weekly']) {
                                if(!empty($due_duration)) {
                                    $receipt_date = $end_date;
                                    $loop = $due_duration;
                                    for($d = 0; $d < $loop; $d++) {
                                        $receipt_due_dates[] = $receipt_date;
                                        if(!empty($receipt_date)) {
                                            $receipt_date = date('d-m-Y', strtotime('-7 days', strtotime($receipt_date)));
                                        }
                                    }
                                    if(!empty($receipt_due_dates)) {
                                        $receipt_due_dates = array_reverse($receipt_due_dates);
                                    }
                                }
                            }
                        }
                    }
                    
                    $receipt_list = array(); $due_counts = array(); $due = 1; $receipt_ids = array(); $r = 0; $approvals = array(); $receipt_date_list = array();
                    $receipt_list = $obj->getCustomerAllPaymentListByFilter($filter_agent_id, $filter_customer_id, $data['customer_chit_id']);
                    if(!empty($receipt_list)) {
                        foreach($receipt_list as $row) {
                            if(!empty($row['chit_due_count'])) {
                                $counts = array();
                                for($j = 1; $j <= $row['chit_due_count']; $j++) {
                                    $counts[] = $due;
                                    $due++;
                                }
                                $due_counts[] = $counts;
                                if(!empty($row['receipt_id'])) {
                                    $receipt_ids[] = $row['receipt_id'];
                                }
                                if(!empty($row['receipt_date']) && $row['receipt_date'] != "0000-00-00") {
                                    $receipt_date_list[] = $row['receipt_date'];
                                }
                                $approvals[] = $row['admin_approval'];
                            }
                        }
                    }

                    $chit_wallet = 0;
                    if(!empty($customer_user) && $customer_user == 1) {
                        $chit_wallet = $obj->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $data['customer_chit_id'], 'amount_to_use_order_customer');
                    }
                    else if(!empty($agent_user) && $agent_user == 1) {
                        $chit_wallet = $obj->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $data['customer_chit_id'], 'amount_to_use_order_agent');
                    }
        ?>
                    <div class="card">
                        <div class="card-header" id="heading<?php echo $data['customer_chit_id']; ?>">
                            <h2 class="clearfix mb-0">
                                <a class="btn btn-link w-100" data-toggle="collapse" data-target="#collapse<?php echo $data['customer_chit_id']; ?>" aria-expanded="true">
                                    <span class="card_heading">
                                        <?php if(!empty($card_heading)) { echo $card_heading; } ?>
                                        - Wallet : <?php if(!empty($chit_wallet)) { echo "Rs.".$obj->truncate_number($chit_wallet, 2); } else { echo "Rs.0"; } ?>
                                    </span> 
                                    <i class="material-icons">add</i>
                                </a>
                            </h2>
                        </div>
                        <div id="collapse<?php echo $data['customer_chit_id']; ?>" class="collapse <?php if(!empty($my_scheme_list) && count($my_scheme_list) == 1) { echo "show"; } ?>" aria-labelledby="heading<?php echo $data['customer_chit_id']; ?>" data-parent="#accordionExample">
                            <div class="card-body px-1">
                                <?php include("dashboard_receipt_chit_table.php"); ?>
                            </div>
                        </div>
                    </div>
        <?php
                }
            }
        ?>

    </div>
</div> 
<?php } else { ?>
    <div class="w-100 text-center py-2">Sorry! No Schemes Found</div>
<?php } ?>

<script>
    $(document).ready(function(){
        // Add minus icon for collapse element which is open by default
        $(".collapse.show").each(function(){
            $(this).siblings(".card-header").find(".btn i").html("remove");
            $(this).prev(".card-header").addClass("highlight");
        });

        // Toggle plus minus icon on show hide of collapse element
        $(".collapse").on('show.bs.collapse', function(){
        $(this).parent().find(".card-header .btn i").html("remove");
        }).on('hide.bs.collapse', function(){
        $(this).parent().find(".card-header .btn i").html("add");
        });

        // Highlight open collapsed element
        $(".card-header .btn").click(function(){
            $(".card-header").not($(this).parents()).removeClass("highlight");
            $(this).parents(".card-header").toggleClass("highlight");
        });
    });
</script>