<?php 

	$access_page = "Direct Order";
    include("include_user_check.php");

    include("permission_check.php");
	
	$project_title = "";
	$project_title = $obj->getProjectTitle();

    $page_title = "Direct Order";

    $order_number = $obj->automate_number($GLOBALS['order_table'], 'order_number'); $order_date = date("d-m-Y");

    $customer_list = array();
    $staff_id = "";
	if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id']) && isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'])) {
		$staff_id = $obj->getTableColumnValue($GLOBALS['user_table'], 'user_id', $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'], 'staff_id');
		if(!empty($staff_id) && $staff_id != $GLOBALS['null_value']) {
			$customer_list = $obj->StaffCreatedCustomers($staff_id, '0');
		}
        else {
            $customer_list = $obj->getTableRecords($GLOBALS['customer_table'], '', '');
        }
	}
	

    $product_list = array();
    $product_list = $obj->getTableRecords($GLOBALS['product_table'], '', '');

    $customer_id = ""; $delivery_address = ""; $product_ids = array(); $product_codes = array(); $product_names = array(); $quantity_values = array();
    $rate_values = array(); $discount = array(); $extra_discount = ""; $extra_discount_extension = ""; $show_extra_discount_amount = 1; $packing_charges = "";
    $order_type = $obj->encode_decode('encrypt', $GLOBALS['backend_order']);

    $change_order_id = ""; $edit_order_id = ""; $duplicate_order_id = ""; $order_unique_id = "";
    if(isset($_REQUEST['edit_order_id'])) {
        $edit_order_id = $_REQUEST['edit_order_id'];
        $edit_order_id = trim($edit_order_id);
        if(!empty($edit_order_id)) {
            $order_unique_id = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $edit_order_id, 'id');
            if(preg_match("/^\d+$/", $order_unique_id)) {
                $change_order_id = $edit_order_id;
            }
        }
    }
    if(isset($_REQUEST['duplicate_order_id'])) {
        $duplicate_order_id = $_REQUEST['duplicate_order_id'];
        $duplicate_order_id = trim($duplicate_order_id);
        if(!empty($duplicate_order_id)) {
            $order_unique_id = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $duplicate_order_id, 'id');
            if(preg_match("/^\d+$/", $order_unique_id)) {
                $change_order_id = $duplicate_order_id;
            }
        }
    }

    if(!empty($change_order_id)) {
        $view_orders = array();
        $view_orders = $obj->getTableRecords($GLOBALS['order_table'], 'order_id', $change_order_id);
        if(!empty($view_orders)) {
            foreach($view_orders as $data) {
                if(!empty($data['order_type'])) {
                    $order_type = $data['order_type'];
                }
                if(!empty($data['order_number']) && $data['order_number'] != $GLOBALS['null_value']) {
                    $order_number = $obj->encode_decode('decrypt', $data['order_number']);
                }
                if(!empty($edit_order_id)) {
                    if(!empty($data['order_date']) && $data['order_date'] != "0000-00-00") {
                        $order_date = date("d-m-Y", strtotime($data['order_date']));
                    }
                }
                if(!empty($data['customer_id'])) {
                    $customer_id = $data['customer_id'];
                }
                if(!empty($data['delivery_address'])) {
                    $delivery_address = $obj->encode_decode('decrypt', $data['delivery_address']);
                }
                if(!empty($data['product_id'])) {
                    $product_ids = explode(",", $data['product_id']);
                }
                if(!empty($data['product_code'])) {
                    $product_codes = explode(",", $data['product_code']);
                }
                if(!empty($data['product_name'])) {
                    $product_names = explode(",", $data['product_name']);
                }
                if(!empty($data['product_content'])) {
                    $product_contents = explode(",", $data['product_content']);
                }
                if(!empty($data['quantity'])) {
                    $quantity_values = explode(",", $data['quantity']);
                }
                if(!empty($data['price'])) {
                    $rate_values = explode(",", $data['price']);
                }
                if(!empty($data['actual_price'])) {
                    $actual_rate_values = explode(",", $data['actual_price']);
                }
                if(!empty($data['discount'])) {
                    $discount_values = explode(",", $data['discount']);
                }
                if(!empty($data['extra_discount']) && $data['extra_discount'] != $GLOBALS['null_value']) {
                    $extra_discount = $data['extra_discount'];
                }
                if(!empty($data['show_extra_discount_amount'])) {
                    $show_extra_discount_amount = $data['show_extra_discount_amount'];
                }
                if(!empty($data['packing_charges']) && $data['packing_charges'] != $GLOBALS['null_value']) {
                    $packing_charges = $data['packing_charges'];
                }
                if(!empty($data['promotion_code_price']) && $data['promotion_code_price'] != $GLOBALS['null_value']) {
                    $promotion_code_price = $data['promotion_code_price'];
                }
                if(!empty($data['promotion_code_discount_value']) && $data['promotion_code_discount_value'] != $GLOBALS['null_value']) {
                    $promotion_code_discount_value = $data['promotion_code_discount_value'];
                }
            }
        }
    }
    else {        
        header("Location:dashboard.php");
        exit;
    }

    $product_lists = array();
    for($i = 0; $i < count($product_ids); $i++) {
        $product_id = ""; $product_code = ""; $product_name = ""; $product_content = ""; $actual_price = ""; $product_price = "";  $product_quantity = "";
        $product_discount = 0; $product_amount = "";

        if(!empty($product_ids[$i])) {
            $product_id = $product_ids[$i];
        }
        if(!empty($product_codes[$i])) {
            $product_code = $product_codes[$i];
        }
        if(!empty($product_names[$i])) {
            $product_name = $product_names[$i];
        }
        if(!empty($product_contents[$i])) {
            $product_content = $product_contents[$i];
        }
        if(!empty($actual_rate_values[$i])) {
            $actual_price = $actual_rate_values[$i];
        }
        if(!empty($rate_values[$i])) {
            $product_price = $rate_values[$i];
        }
        if(!empty($quantity_values[$i])) {
            $product_quantity = $quantity_values[$i];
        }
        if(!empty($order_type)) {
            if(!empty($discount_values[$i])) {
                $product_discount = $discount_values[$i];
            }
            else {
                $product_discount = 0;
            }
        }	
        
        if(!empty($product_quantity) && !empty($product_price)) {
            $product_amount = $product_quantity * $product_price;

            if(!empty($product_amount)) {
                $product_amount = number_format($product_amount, 2);
                $product_amount = str_replace(",", "", $product_amount);
            }
        }
        
        //if(!empty($product_amount)) {		
            $product_lists[] = array('product_id' => $product_id, 'code' => $product_code, 'name' => $product_name, 'content' => $product_content, 'actual_price' => $actual_price, 'product_price' => $product_price, 'quantity' => $product_quantity, 'discount' => $product_discount, 'amount' => $product_amount);
        //}
    }

    $discounts = array();
    if(!empty($product_lists)) {
        foreach($product_lists as $list) {
            if(!in_array($list['discount'], $discounts)) {
                $discounts[] = $list['discount'];
            }    
        }
    }    

?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title> <?php if(!empty($project_title)) { echo $project_title; } ?> - Direct Enquiry </title>
	<?php include "link_style_script.php"; ?>
    <script type="text/javascript" src="include/js/common.js"></script>
    <script type="text/javascript" src="include/js/direct_order.js"></script>
</head>
<body>
	<?php include "header.php";  ?>
	<!-- sidebar-wrapper  -->          
	<div class="page-wrapper chiller-theme toggled">
		<main class="page-content">
			<div class="container-fluid px-lg-1">
				<div class="border card-box">

					<div class="card-header">
                        <div class="row">
                            <div class="col-sm-4 text-center text-sm-left"> <h5 class="headfnt mb-0">Direct Enquiry</h5> </div>
                            <div class="col-sm-4 text-center"> <?php if(!empty($order_date)) { echo "Order Date : ".$order_date; } ?> </div>
                            <div class="col-sm-4 text-center text-sm-right">
                                <button class="btn btn-primary btnwidth submit_button" type="button" onClick="Javascript:SaveOrder('direct_order_form');">Submit</button>
                            </div>
                        </div>
					</div>
                    <div class="card-body px-1 py-1">
                        <div class="add_update_form_content">
                            <?php
                                $check_order_type = "";
                                if(!empty($order_type)) {
                                    $check_order_type = $obj->encode_decode('decrypt', $order_type);
                                }
                            ?>
                            <form name="direct_order_form" method="post">
                                <div class="row">
                                    <div class="col-xl-6 px-1">
                                        <?php if(!empty($change_order_id) && !empty($edit_order_id)) { ?>
                                            <input type="hidden" name="edit_order_id" value="<?php if(!empty($edit_order_id)) { echo $edit_order_id; } ?>">
                                        <?php } else { ?>
                                            <input type="hidden" name="edit_order_id" value="">
                                        <?php } ?>
                                        <input type="hidden" name="order_type" value="<?php if(!empty($order_type)) { echo $order_type; } ?>">                                            
                                        <input type="hidden" name="order_date" value="<?php if(!empty($order_date)) { echo $order_date; } ?>">
                                        <input type="hidden" name="check_order_type" value="<?php if(!empty($check_order_type)) { echo $check_order_type; } ?>">
                                        <div class="form-group">
                                            <div id="customer_list" class="form-label-group in-border mb-0">
                                                <div class="input-group">
                                                    <select name="customer_id" class="form-control" fieldindex='1' tabindex = '1' onChange="Javascript:getDeliveryAddress(this.value);">
                                                        <option value="">Select Customer</option>
                                                        <?php
                                                            if(!empty($customer_list)) {
                                                                foreach($customer_list as $data) {
                                                                    if(!empty($data['customer_id'])) {
                                                        ?>
                                                                        <option value="<?php if(!empty($data['customer_id'])) { echo $data['customer_id']; } ?>" <?php if(!empty($customer_id) && $customer_id == $data['customer_id']) { ?> selected="selected" <?php } ?> >
                                                                            <?php
                                                                                if(!empty($data['name'])) {
                                                                                    $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                                                                                    echo $data['name'];
                                                                                    if(!empty($data['city']) && $data['city'] != $GLOBALS['null_value']) {
                                                                                        $data['city'] = $obj->encode_decode('decrypt', $data['city']);
                                                                                        echo " - ".$data['city'];
                                                                                    }
                                                                                }
                                                                            ?>
                                                                        </option>
                                                        <?php     
                                                                    }       
                                                                }
                                                            }
                                                        ?>
                                                    </select>
                                                    <div style="position: inherit;" class="input-group-append">
                                                        <button class="btn btn-dark poppins" tabindex='2' style="font-size:11px;" type="button" onClick="javascript:AddCustomer();"><i class="fa fa-user"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-6 px-1">
                                        <div class="form-group">
                                            <?php
                                                if(!empty($delivery_address)) {
                                                    $delivery_address = str_replace("<br>", "\r\n", $delivery_address);
                                                }
                                            ?>
                                            <div class="form-label-group in-border mb-0">
                                                <textarea name="delivery_address" class="form-control" tabindex='3' placeholder="Address" rows="5"><?php if(!empty($delivery_address)) { echo $delivery_address; } ?></textarea>
                                                <label>Address (*)</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 px-0">
                                        <div class="row">
                                            <div class="col-xl-8 px-0">
                                                <div class="row mx-0">
                                                    <div class="col-xl-5 px-1">
                                                        <div class="form-group">
                                                            <div class="form-label-group in-border mb-0">
                                                                <div class="input-group">
                                                                    <select name="selected_product_id" class="form-control" fieldindex='4' tabindex='4' onChange="javascript:getProductDetails(this.value);">
                                                                        <option value="">Select Product</option>
                                                                        <?php
                                                                            if(!empty($product_list)) {
                                                                                foreach($product_list as $data) {
                                                                                    if(!empty($data['product_id'])) {
                                                                        ?>
                                                                                        <option value="<?php if(!empty($data['product_id'])) { echo $data['product_id']; } ?>">
                                                                                            <?php
                                                                                                if(!empty($data['product_code'])) {
                                                                                                    $data['product_code'] = $obj->encode_decode('decrypt', $data['product_code']);
                                                                                                    echo $data['product_code'];
                                                                                                    if(!empty($data['name'])) {
                                                                                                        $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                                                                                                        $data['name'] = str_replace("$", '"', $data['name']);
                                                                                                        $data['name'] = str_replace("'''", '"', $data['name']);
                                                                                                        echo " - ".$data['name'];
                                                                                                    }
                                                                                                }
                                                                                            ?>
                                                                                        </option>
                                                                        <?php     
                                                                                    }       
                                                                                }
                                                                            }
                                                                        ?>
                                                                    </select>
                                                                    <div style="position: inherit;" class="input-group-append">
                                                                        <button class="btn btn-dark poppins" tabindex='5' style="font-size:11px;" type="button" onClick="javascript:AddCustomRow();"><i class="fa fa-file"></i></button>
                                                                    </div>
                                                                </div>                                            
                                                            </div>
                                                        </div>
                                                    </div>  
                                                    <div class="col-6 col-sm-4 col-xl-2 px-1">
                                                        <div class="form-group">
                                                            <div class="form-label-group in-border mb-0">
                                                                <input type="number" name="selected_quantity" class="form-control" tabindex='6' value="" placeholder="Quantity" onKeyup="Javascript:CalProductAmount();">
                                                                <label>Qty (*)</label>
                                                            </div>                                        
                                                        </div>
                                                    </div>
                                                    <div class="col-6 col-sm-4 col-xl-2 px-1">
                                                        <div class="form-group">
                                                            <div class="form-label-group in-border mb-0">
                                                                <input type="text" name="selected_rate" class="form-control" tabindex='7' value="" placeholder="Rate" onKeyup="Javascript:CalProductAmount();">
                                                                <label>Rate (*)</label>
                                                            </div>
                                                            <div class="selected_product_content w-100 text-center mt-1" style="font-size: 13px;"></div>
                                                        </div>
                                                    </div>
                                                    <div class="col-sm-4 col-xl-3 px-1">
                                                        <div class="form-group">
                                                            <div class="form-label-group in-border mb-0">
                                                                <div class="input-group">
                                                                    <input type="text" name="selected_amount" class="form-control" disabled value="" placeholder="Amount">
                                                                    <label style="z-index:999;">Amount</label>
                                                                    <div style="position: inherit;" class="input-group-append">
                                                                        <button class="btn btn-dark poppins add_details_buttton" tabindex='8' style="font-size:11px;" type="button" onClick="javascript:AddDetails();"><i class="fa fa-plus-circle"></i></button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-12 px-1 text-center">
                                                        <div style="display: inline-block; font-size: 16px; line-height: 18px; font-weight: bold;"> Bill Total : <span class="overall_total"></span> </div>
                                                        <div class="table-responsive mb-3">
                                                            <input type="hidden" name="product_count" value="<?php if(!empty($product_ids)) { echo count($product_ids); } else { echo "0"; } ?>">
                                                            <table class="data-table table nowrap tablefont order_products_table" style="margin: auto; font-size: 14px; line-height: 15px;">
                                                                <thead class="thead-dark">
                                                                    <tr>
                                                                        <th style="text-align: center; width: 50px; padding: 5px; vertical-align: middle;">S.No</th>
                                                                        <th style="text-align: center; padding: 5px; vertical-align: middle;">Product Name</th>
                                                                        <th style="text-align: center; width: 100px; padding: 5px; vertical-align: middle;">Actual Price</th>
                                                                        <th style="text-align: center; width: 100px; padding: 5px; vertical-align: middle;">Final Price</th>
                                                                        <th style="text-align: center; width: 75px; padding: 5px; vertical-align: middle;">Quantity</th>
                                                                        <th style="text-align: center; width: 150px; padding: 5px; vertical-align: middle;">Amount</th>
                                                                        <th style="text-align: center; width: 50px; padding: 5px; vertical-align: middle;">Delete</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php
                                                                        $index = 1;
                                                                        if(!empty($discounts)) {
                                                                            foreach($discounts as $discount) {
                                                                                $discount = str_replace("%", "", $discount);
                                                                                $discount_heading = "";
                                                                                if (!empty($discount)) {
                                                                                    $discount_heading = $discount."% Products";
                                                                                }
                                                                                else {
                                                                                    $discount_heading = "Net Rate Products";
                                                                                }
                                                                                $discount = str_replace("%", "", $discount);
                                                                    ?>
                                                                                <tr class="discount_row <?php echo $discount."_discount_row"; ?>">
                                                                                    <td>
                                                                                        <?php if($check_order_type != $GLOBALS['frontend_order']) { ?>
                                                                                        <input type="checkbox" name="check_all" onClick="Javascript:CheckAllDiscountProductRows(this, '<?php echo $discount; ?>');">
                                                                                        <?php } ?>
                                                                                    </td>
                                                                                    <td colspan="2" style="font-weight: bold;">
                                                                                        <input type="hidden" name="product_top_discount" value="<?php echo $discount; ?>">
                                                                                        <?php if(!empty($discount_heading)) { echo $discount_heading; } ?>
                                                                                    </td>
                                                                                    <td colspan="3">     
                                                                                        <?php if($check_order_type != $GLOBALS['frontend_order']) { ?>                                                                     
                                                                                        <div class="input-group" style="width: 200px;">
                                                                                            <div class="input-group-preppend">
                                                                                                <span class="btn btn-secondary px-2 py-2" style="font-size: 13px; line-height: 14px;">Discount</span>
                                                                                            </div>
                                                                                            <input type="text" class="form-control shadow-none" name="new_discount" value="">
                                                                                            <div class="input-group-append">
                                                                                                <button type="button" class="btn btn-block btn-dark px-2 py-2" style="font-size: 13px; line-height: 14px;" onClick="Javascript:UpdateDiscountProductRows('<?php echo $discount; ?>');">% Apply</button>
                                                                                            </div>
                                                                                        </div> 
                                                                                        <?php } ?>
                                                                                    </td>
                                                                                </tr>
                                                                    <?php
                                                                                if(!empty($product_lists)) {
                                                                                    foreach($product_lists as $data) {
                                                                                        if($data['discount'] == $discount) {
                                                                    ?>
                                                                                            <tr class="product_row <?php echo $discount; ?>_discount_product_row">  
                                                                                                <td class="text-center" style="padding: 5px; vertical-align: middle;">
                                                                                                    <div class="sno w-100 mb-1"><?php echo $index; ?></div>
                                                                                                    <?php if($check_order_type != $GLOBALS['frontend_order']) { ?>
                                                                                                    <input type="checkbox" name="product_checkbox" value="<?php if(!empty($data['product_id'])) { echo $data['product_id'];} ?>">
                                                                                                    <?php } ?>
                                                                                                </td>  
                                                                                                <td style="padding: 5px; vertical-align: middle;">
                                                                                                    <?php
                                                                                                         if(!empty($data['name'])) {
                                                                                                            $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                                                                                                            $data['name'] = str_replace("$", '"', $data['name']);
                                                                                                            $data['name'] = str_replace("'''", '"', $data['name']);
                                                                                                        }
                                                                                                        $product_unique_id = "";
                                                                                                        $product_unique_id = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $data['product_id'], 'id');
                                                                                                        if(preg_match("/^\d+$/", $product_unique_id)) {
                                                                                                            if(!empty($data['name'])) { echo $data['name']; }
                                                                                                        }
                                                                                                        else {
                                                                                                    ?>
                                                                                                        <input type="text" name="custom_product_<?php if(!empty($data['product_id'])) { echo $data['product_id'];} ?>" value="<?php if(!empty($data['name'])) { echo $data['name']; } ?>" class="form-control">
                                                                                                    <?php
                                                                                                        }
                                                                                                    ?>
                                                                                                    <input type="hidden" name="product_id[]" value="<?php if(!empty($data['product_id'])) { echo $data['product_id'];} ?>">
                                                                                                    <input type="hidden" name="product_discount[]" value="<?php if(!empty($data['discount'])) { echo $data['discount'];} else { echo "0"; } ?>">
                                                                                                </td>
                                                                                                <td style="padding: 5px; vertical-align: middle;">
                                                                                                    <input type="text" name="actual_price[]" style="padding: 5px !important;" class="form-control w-100" onkeyup="Javascript:ProductRowCheck(this);" value="<?php if(!empty($data['actual_price'])) { echo $data['actual_price']; } ?>">
                                                                                                </td>
                                                                                                <td style="padding: 5px; vertical-align: middle;">
                                                                                                    <input type="hidden" name="rate[]" style="padding: 5px !important;" class="form-control w-100" value="<?php if(!empty($data['product_price'])) { echo $data['product_price']; } ?>">
                                                                                                    <span class="rate"><?php if(!empty($data['product_price'])) { echo $data['product_price']; } ?></span>
                                                                                                </td>
                                                                                                <td style="padding: 5px; vertical-align: middle;">
                                                                                                    <input type="text" name="quantity[]" class="form-control w-100" style="padding: 5px !important;" onkeyup="Javascript:ProductRowCheck(this);" value="<?php if(!empty($data['quantity'])) { echo $data['quantity']; } ?>">
                                                                                                </td>
                                                                                                <td class="amount text-right" style="padding: 5px; vertical-align: middle;"><?php if(!empty($data['amount'])) { echo $data['amount']; } ?></td>
                                                                                                <td class="text-center" style="padding: 5px; vertical-align: middle;">
                                                                                                    <button type="button" onClick="Javascript:DeleteProductRow(this);" class="btn"> <i class="fa fa-trash"></i></button>
                                                                                                </td>    
                                                                                            </tr>
                                                                    <?php
                                                                                            $index = $index + 1;
                                                                                        }
                                                                                    }
                                                                                }

                                                                            }
                                                                        }
                                                                    ?>
                                                                </tbody>                                   
                                                            </table>
                                                        </div>    
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-4 px-0">
                                                <div style="width: 350px; display: none;">
                                                    <div class="d-flex align-items-center">
                                                        <div style="width: 150px;">Sub Total</div>
                                                        <div style="width: 200px; font-size: 20px; font-weight: bold;" class="sub_total text-right"></div>
                                                    </div>
                                                </div>
                                                <?php if(!empty($promotion_code_price) && !empty($promotion_code_discount_value)) { ?>
                                                <div style="width: 350px;">
                                                    <div class="d-flex align-items-center">
                                                        <div style="width: 150px;">Coupon (<?php echo $promotion_code_price; ?>)</div>
                                                        <div style="width: 200px; font-size: 20px; font-weight: bold;" class="promotion_code_discount_value text-right">
                                                            <?php echo $promotion_code_discount_value; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                                <?php } ?>
                                                <div style="width: 350px;">
                                                    <div class="d-flex align-items-center">
                                                        <div style="width: 150px;">Packing Charges</div>
                                                        <div style="width: 50px;">
                                                            <input type="text" class="form-control shadow-none" tabindex='10' name="packing_charges" value="<?php if(!empty($packing_charges)) { echo $packing_charges; } ?>" onChange="Javascript:calOverallTotal();">
                                                        </div>
                                                        <div style="width: 150px; font-size: 20px; font-weight: bold;" class="packing_charges_value text-right"></div>
                                                    </div>
                                                </div>
                                                <div style="width: 350px;">
                                                    <div class="d-flex align-items-center">
                                                        <div style="width: 150px;">Extra Discount</div>
                                                        <div style="width: 50px;">
                                                            <input type="text" class="form-control shadow-none" tabindex='11' name="extra_discount" value="<?php if(!empty($extra_discount)) { echo $extra_discount; } ?>" onChange="Javascript:calOverallTotal();">
                                                        </div>
                                                        <div style="width: 150px; font-size: 20px; font-weight: bold;" class="extra_discount_value text-right"></div>
                                                    </div>
                                                </div>  
                                                <div style="width: 350px;">
                                                    <div class="d-flex align-items-center">
                                                        <div style="width: 150px;">Round OFF</div>
                                                        <div style="width: 200px; font-size: 20px; font-weight: bold;" class="round_off text-right"></div>
                                                    </div>
                                                </div>
                                                <div style="width: 350px;">
                                                    <div class="d-flex align-items-center">
                                                        <div style="width: 150px;">Overall Total</div>
                                                        <div style="width: 200px; font-size: 20px; font-weight: bold;" class="overall_total text-right"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 px-1 text-center">
                                        <button class="btn btn-primary btnwidth submit_button" type="button" onClick="Javascript:SaveOrder('direct_order_form');">Submit</button>
                                    </div>
                                </div>                                
                            </form>
                        </div>
                    </div>

				</div>
			</div>
		</main>
	</div>  
	<!-- page-wrapper -->

    <style>
        #extra_discount_cover .input-group .select2-container { width: 100% !important; }
    </style>

    <button type="button" data-toggle="modal" data-target="#AddCustomermodal" class="d-none add_customer_modal_button"></button>
    <div class="modal fade" id="AddCustomermodal" data-keyboard="false" data-backdrop="static">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="headfnt">Customer Details</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    
                </div>
            </div>
        </div>
    </div>

	<script>
		jQuery(document).ready(function(){
			jQuery("#direct_orderactive").addClass("active");

            <?php if(!empty($change_order_id)) { ?> calOverallTotal(); <?php } ?>

            if(jQuery('input[name="selected_quantity"]').length > 0) {
                jQuery('input[name="selected_quantity"]').on("keypress", function(e) {
                    if (e.keyCode == 13) {
                        AddDetails();
                        return false;
                    }
                });
            }

		});
        
        function ToggleExtraDiscount() {
            if(jQuery('#extra_discount_cover').length > 0) {
                jQuery('#extra_discount_cover').toggle();
            }
        }
	</script>

	<?php include "footer.php"; ?>
    
    <script type="text/javascript"> 
        CheckFormChangeEvent(); 
    </script>

    </body>
</html>