<?php
    if(!empty($pdf_frontend) && $pdf_frontend == 1) {
        include("../../include.php");
        require_once('../fpdf/fpdf.php');
    } 
    else {
        include("../include.php");
        require_once('../../order/fpdf/fpdf.php');
    }
	
	$pricelist = array();
    $pricelist = $obj->ProductPricelist('1');

    $company_list = array();
    $company_list = $obj->getTableRecords($GLOBALS['company_table'], '', '');

    foreach($company_list as $data){
        $company_name = ""; $company_address = ""; $company_mobile = ""; $company_email = ""; $logo = "";

        if(!empty($data['name'])) {
            $company_name = $obj->encode_decode('decrypt', $data['name']);
        }
        if(!empty($data['logo']) && $data['logo'] != $GLOBALS['null_value']) {
            $logo = $data['logo'];
        }
        if(!empty($data['address']) && $data['address'] != $GLOBALS['null_value']) {
            $company_address = $obj->encode_decode('decrypt', $data['address']);
        }
        if(!empty($data['mobile_number'])) {
            $company_mobile = $obj->encode_decode('decrypt', $data['mobile_number']);
        }
        if(!empty($data['email'])) {
            $company_email = $obj->encode_decode('decrypt', $data['email']);
        }
    }

    $logo = "../../images/logo.png";

    $format = 1;
    if(isset($_REQUEST['format'])) {
        $format = $_REQUEST['format'];
    }
    
    $pdf = new FPDF('P','mm','A4');
    $pdf->AliasNbPages(); 
    $pdf->AddPage();
    $pdf->SetAutoPageBreak(true);
    $pdf->SetTitle('Price List');
    $pdf->SetFont('Arial','B',10);
    $pdf->SetY(10);
    $pdf->Cell(0,5,strtoupper($company_name),0,1,'C',0);
    $pdf->SetFont('Arial','',7);
    $pdf->Cell(0,4,$company_address,0,1,'C',0);
    $pdf->Cell(0,4,'E-mail : '.$company_email.'   Phone : '.$company_mobile,0,1,'C',0);

    if(!empty($logo)){
        $pdf->Image($logo,10,7,25,20);
    }
    
    $pdf->SetY(7);
    $pdf->Cell(0,20,'',1,1,'L',0);
    $pdf->SetFont('Arial','B',9);
    $pdf->Cell(0,6,'PRICE LIST',1,1,'C',0);
    $pdf->SetFont('Arial','B',8);
    $pdf->SetX(10);
    $pdf->Cell(20,5,'Product Code',1,0,'C',0);
    $pdf->SetX(30);
    $pdf->Cell(50,5,'Product Name',1,0,'C',0);
    $pdf->SetX(80);
    $pdf->Cell(20,5,'Content',1,0,'C',0);
    
    $pdf->SetX(100);
    $pdf->Cell(20,5,'Rate / Qty',1,0,'C',0);
    $pdf->SetX(120);
    $pdf->Cell(20,5,'Discount',1,0,'C',0);
    $pdf->SetX(140);
    $pdf->Cell(20,5,'Final Rate',1,0,'C',0);
    $pdf->SetX(160);
    $pdf->Cell(15,5,'Quantity',1,0,'C',0);

    $pdf->SetX(175);
    $pdf->Cell(25,5,'Amount',1,1,'C',0);
    $pdf->SetFont('Arial','',8);

    if(!empty($pricelist)) {
        $sno = 1;
        foreach($pricelist as $data) {
            if($pdf->GetY()>260){
                $pdf->SetY(-10);
                $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);
                $pdf->AddPage();
                $pdf->SetFont('Arial','B',10);
                $pdf->SetY(10);
                $pdf->Cell(0,5,strtoupper($company_name),0,1,'C',0);
                $pdf->SetFont('Arial','',7);
                $pdf->Cell(0,4,$company_address,0,1,'C',0);
                $pdf->Cell(0,4,'E-mail : '.$company_email.'   Phone : '.$company_mobile,0,1,'C',0);

                if(!empty($logo)){
                    $pdf->Image($logo,10,7,25,20);
                }
                
                $pdf->SetY(7);
                $pdf->Cell(0,20,'',1,1,'L',0);
                $pdf->SetFont('Arial','B',9);
                $pdf->Cell(0,6,'PRICE LIST',1,1,'C',0);
                $pdf->SetFont('Arial','B',8);
                $pdf->SetX(10);
                $pdf->Cell(20,5,'Product Code',1,0,'C',0);
                $pdf->SetX(30);
                $pdf->Cell(50,5,'Product Name',1,0,'C',0);
                $pdf->SetX(80);
                $pdf->Cell(20,5,'Content',1,0,'C',0);
                
                $pdf->SetX(100);
                $pdf->Cell(20,5,'Rate / Qty',1,0,'C',0);
                $pdf->SetX(120);
                $pdf->Cell(20,5,'Discount',1,0,'C',0);
                $pdf->SetX(140);
                $pdf->Cell(20,5,'Final Rate',1,0,'C',0);
                $pdf->SetX(160);
                $pdf->Cell(15,5,'Quantity',1,0,'C',0);

                $pdf->SetX(175);
                $pdf->Cell(25,5,'Amount',1,1,'C',0);
                $pdf->SetFont('Arial','',8);
            }
            $category_name = "";
            if(!empty($data['category_name'])) {
                $category_name = $obj->encode_decode('decrypt', $data['category_name']);
                $category_name = str_replace("$", '"', $category_name);
                $category_name = str_replace("'''", '"', $category_name);
            }
            $category_discount = 0;
            if(!empty($data['discount'])) {
                $category_discount = $data['discount'];
            }
            if(!empty($category_name)) {
                if(!empty($category_discount)) {
                    $category_name = $category_name." (".$category_discount."% Discount)";
                }
                else {
                    $category_name = $category_name." (Net Rate)";
                }
            }
            $pdf->SetFillColor(211,211,211);
            $pdf->SetFont('Arial','B',8);
            $pdf->Cell(0,6,$category_name,1,1,'C',1);
            $pdf->SetFont('Arial','',8);
            if(!empty($data['product_list'])) {
                foreach($data['product_list'] as $product) {
                    if($pdf->GetY()>260){
                        $pdf->SetY(-10);
                        $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);
                        $pdf->AddPage();
                        $pdf->SetFont('Arial','B',10);
                        $pdf->SetY(10);
                        $pdf->Cell(0,5,strtoupper($company_name),0,1,'C',0);
                        $pdf->SetFont('Arial','',7);
                        $pdf->Cell(0,4,$company_address,0,1,'C',0);
                        $pdf->Cell(0,4,'E-mail : '.$company_email.'   Phone : '.$company_mobile,0,1,'C',0);
        
                        if(!empty($logo)){
                            $pdf->Image($logo,10,7,25,20);
                        }
                        
                        $pdf->SetY(7);
                        $pdf->Cell(0,20,'',1,1,'L',0);
                        $pdf->SetFont('Arial','B',9);
                        $pdf->Cell(0,6,'PRICE LIST',1,1,'C',0);
                        $pdf->SetFont('Arial','B',8);
                        $pdf->SetX(10);
                        $pdf->Cell(20,5,'Product Code',1,0,'C',0);
                        $pdf->SetX(30);
                        $pdf->Cell(50,5,'Product Name',1,0,'C',0);
                        $pdf->SetX(80);
                        $pdf->Cell(20,5,'Content',1,0,'C',0);
                        
                        $pdf->SetX(100);
                        $pdf->Cell(20,5,'Rate / Qty',1,0,'C',0);
                        $pdf->SetX(120);
                        $pdf->Cell(20,5,'Discount',1,0,'C',0);
                        $pdf->SetX(140);
                        $pdf->Cell(20,5,'Final Rate',1,0,'C',0);
                        $pdf->SetX(160);
                        $pdf->Cell(15,5,'Quantity',1,0,'C',0);

                        $pdf->SetX(175);
                        $pdf->Cell(25,5,'Amount',1,1,'C',0);
                        $pdf->SetFont('Arial','',8);
                    }
                    if(!empty($product['name'])) {

                        $actual_price = 0; $discounted_price = 0;
                        if(!empty($format)) {
                            if($format == 1) {
                                if(!empty($product['price'])) {
                                    $actual_price = $product['price'];
                                    if(!empty($category_discount)) {
                                        $discounted_value = 0;
                                        $discounted_value = ($actual_price * $category_discount) / 100;
                                        if(!empty($discounted_value)) {
                                            $discounted_value = number_format($discounted_value, 2);
                                            $discounted_value = str_replace(",", "", $discounted_value);
                                            $discounted_price = $actual_price - $discounted_value;
                                        }
                                    }
                                    else {
                                        $discounted_price = $actual_price;
                                    }
                                }
                            }
                            else if($format == 2) {
                                if(!empty($product['price'])) {
                                    $discounted_price = $product['price'];
                                    if(!empty($discounted_price)) {
                                        if(!empty($category_discount) && !empty($discounted_price)) {
                                            $actual_price = $obj->getActualPrice($discounted_price, $category_discount);
                                        }
                                        else {
                                            $actual_price = $discounted_price;   
                                        }
                                    }
                                }
                            }
                        }

                        $discounted_value = 0;
                        if(!empty($actual_price) && !empty($category_discount)) {                   
                            $discounted_value = ($actual_price * $category_discount) / 100;
                            if(!empty($discounted_value)) {
                                $discounted_value = number_format($discounted_value, 2);
                                $discounted_value = str_replace(",", "", $discounted_value);
                            }
                        }

                        $product['product_code'] = $obj->encode_decode('decrypt', $product['product_code']);
                        $pdf->SetX(10);
                        $pdf->Cell(20,5,$product['product_code'],1,0,'C',0);
                        $product['name'] = $obj->encode_decode('decrypt', $product['name']);
                        $product['name'] = str_replace("$", '"', $product['name']);
                        $product['name'] = str_replace("'''", '"', $product['name']);
                        $pdf->SetX(30);
                        $pdf->Cell(50,5,$product['name'],1,0,'L',0);
                        $pdf->SetX(80);
                        $product['product_content'] = $obj->encode_decode('decrypt', $product['product_content']);
                        $pdf->Cell(20,5,$product['product_content'],1,0,'C',0);
                        $pdf->SetX(100);
                        $pdf->Cell(20,5,number_format($actual_price, 2),1,0,'C',0);
                        $pdf->SetX(120);
                        if(!empty($discounted_value)) {
                            $pdf->Cell(20,5,number_format($discounted_value, 2),1,0,'C',0);
                        }
                        else {
                            $pdf->Cell(20,5,'',1,0,'C',0);
                        }
                        $pdf->SetX(140);
                        $pdf->Cell(20,5,number_format($discounted_price, 2),1,0,'C',0);
                        $pdf->SetX(160);
                        $pdf->Cell(15,5,'',1,0,'C',0);
                        $pdf->SetX(175);
                        $pdf->Cell(25,5,'',1,1,'C',0);
                    }
                }
            }
        }
    }
    
    $pdf->SetY(-10);
    $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);

    $pdf->Output();
?>