<?php
	include("include.php");
	
	if(isset($_REQUEST['show_status_count_id'])) {
        $show_status_count_id = $_REQUEST['show_status_count_id'];

        $name = ""; $color_code = "";
        if(!empty($show_status_count_id)) {
            $status_count_list = array();
			$status_count_list = $obj->getTableRecords($GLOBALS['status_count_table'], 'status_count_id', $show_status_count_id);
            if(!empty($status_count_list)) {
                foreach($status_count_list as $data) {
                    if(!empty($data['name'])) {
                        $name = $obj->encode_decode('decrypt', $data['name']);
					}
                    if(!empty($data['color_code'])) {
                        $color_code = $data['color_code'];
					}
                }
            }
		} 
?>
		
        <form class="py-4 poppins pd-20 col-xl-6 mx-auto" name="status_count_form" method="POST">
            <div class="row">
                <input type="hidden" name="edit_id" value="<?php if(!empty($show_status_count_id)) { echo $show_status_count_id; } ?>">
                <div class="form-group col-sm-8">
                    <div class="form-label-group in-border mb-0">
                        <input type="text" name="name" value="<?php if(!empty($name)) { echo $name; } ?>" class="form-control shadow-none" placeholder="Status Count Name">
                        <label>Status Count Name (*)</label>
                    </div>
                </div>
                <div class="form-group col-sm-4">
                    <div class="form-label-group in-border mb-0">
                        <input type="color" name="color_code" value="<?php if(!empty($color_code)) { echo $color_code; } ?>" class="form-control shadow-none">
                        <label>Color Code (*)</label>
                    </div>
                </div>
                <div class="col-md-12 pt-3 text-center">
                    <button class="btn btn-primary btnwidth submit_button" type="button" onClick="Javascript:SaveModalContent('status_count_form', 'status_count_changes.php', 'status_count.php');">Submit</button>
                </div>
            </div>
			<script type="text/javascript">
				jQuery(document).ready(function(){
					jQuery('form[name="status_count_form"]').find('select').select2();
				});    
			</script>
			<script type="text/javascript"> 
				CheckFormChangeEvent(); 
			</script>
        </form>
<?php        
    }

    if(isset($_POST['name'])) {	
		$name = ""; $name_error = ""; $color_code = ""; $color_code_error = "";
		$valid_status_count = ""; $form_name = "status_count_form";
	
        $name = $_POST['name'];
		$name = $valid->clean_value($name);
        $name_error = $valid->common_validation($name, "name", "text");
		if(!empty($name_error)) {
			$valid_status_count = $valid->error_display($form_name, "name", $name_error, 'text');			
		}

        $color_code = $_POST['color_code'];
        $color_code = $valid->clean_value($color_code);
        $color_code_error = $valid->common_validation($color_code, "color code", "text");
        if(!empty($color_code_error)) {
            if(!empty($valid_status_count)) {
                $valid_status_count = $valid_status_count." ".$valid->error_display($form_name, 'color_code', $color_code_error, 'text');
            }
            else {
                $valid_status_count = $valid->error_display($form_name, 'color_code', $color_code_error, 'text');
            }
        }

		if(isset($_POST['edit_id'])) {
			$edit_id = $_POST['edit_id'];
		}
		
		$result = "";
		
		if(empty($valid_status_count)) {
			$check_user_id_ip_address = "";
			$check_user_id_ip_address = $obj->check_user_id_ip_address();	
			if(preg_match("/^\d+$/", $check_user_id_ip_address)) {
				
				$lower_case_name = "";
				if(!empty($name)) {
					$name = str_replace("''", "$", $name);
					$name = str_replace('"', "$", $name);
                    $lower_case_name = strtolower($name);					
					$lower_case_name = $obj->encode_decode('encrypt', $lower_case_name);
                    $name = $obj->encode_decode('encrypt', $name);
				}

                $prev_status_count_id = ""; $status_count_error = "";
				if(!empty($lower_case_name)) {
					$prev_status_count_id = $obj->getTableColumnValue($GLOBALS['status_count_table'], 'lower_case_name', $lower_case_name, 'status_count_id');
					if(!empty($prev_status_count_id)) {
                        $status_count_error = "This status name already exist";
                    }
                }
                $prev_color_code_id = ""; $color_code_error = "";
				if(!empty($color_code)) {
					$prev_color_code_id = $obj->getTableColumnValue($GLOBALS['status_count_table'], 'color_code', $color_code, 'status_count_id');
					if(!empty($prev_color_code_id)) {
                        $color_code_error = "This status color already exist";
                    }
                }
				
				if(empty($edit_id)) {
					if(empty($prev_status_count_id) && empty($prev_color_code_id)) {
						$created_date_time = $GLOBALS['create_date_time_label']; $creator = $GLOBALS['creator'];
                        $creator_name = $obj->encode_decode('encrypt', $GLOBALS['user_name']);
						
						$action = "";
						if(!empty($name)) {
							$action = "New Status Created. Name - ".str_replace("$", '"', $obj->encode_decode('decrypt', $name));
						}

						$null_value = $GLOBALS['null_value'];
                        $columns = array('created_date_time', 'creator', 'creator_name', 'status_count_id', 'name', 'lower_case_name', 'color_code', 'deleted');
                        $values = array("'".$created_date_time."'", "'".$creator."'", "'".$creator_name."'", "'".$null_value."'", "'".$name."'", "'".$lower_case_name."'", "'".$color_code."'", "'0'");
						$status_count_insert_id = $obj->InsertSQL($GLOBALS['status_count_table'], $columns, $values, $action);						
						if(preg_match("/^\d+$/", $status_count_insert_id)) {
							$status_count_id = "";
							if($status_count_insert_id < 10) {
								$status_count_id = "status_count_0".$status_count_insert_id;
							}
							else {
								$status_count_id = "status_count_".$status_count_insert_id;
							}
                            if(!empty($status_count_id)) {
                                $status_count_id = $obj->encode_decode('encrypt', $status_count_id);
                            }
                            $columns = array(); $values = array();						
                            $columns = array('status_count_id');
                            $values = array("'".$status_count_id."'");
                            $status_count_update_id = $obj->UpdateSQL($GLOBALS['status_count_table'], $status_count_insert_id, $columns, $values, '');
                            if(preg_match("/^\d+$/", $status_count_update_id)) {
                                $result = array('number' => '1', 'msg' => 'Status Successfully Created');					
                            }
                            else {
                                $result = array('number' => '2', 'msg' => $status_count_update_id);
                            }
						}
						else {
							$result = array('number' => '2', 'msg' => $status_count_insert_id);
						}
					}
					else {
                        if(!empty($status_count_error)) {
						    $result = array('number' => '2', 'msg' => $status_count_error);
                        }
                        else if(!empty($color_code_error)) {
						    $result = array('number' => '2', 'msg' => $color_code_error);
                        }
					}
				}
				else {
					if(empty($prev_status_count_id) || $prev_status_count_id == $edit_id) {
                        if(empty($prev_color_code_id) || $prev_color_code_id == $edit_id) {
                            $getUniqueID = "";
                            $getUniqueID = $obj->getTableColumnValue($GLOBALS['status_count_table'], 'status_count_id', $edit_id, 'id');
                            if(preg_match("/^\d+$/", $getUniqueID)) {
                                $action = "";
                                if(!empty($name)) {
                                    $action = "Status Updated. Name - ".str_replace("$", '"', $obj->encode_decode('decrypt', $name));
                                }
                            
                                $columns = array(); $values = array();						
                                $columns = array('name', 'lower_case_name', 'color_code');
                                $values = array("'".$name."'", "'".$lower_case_name."'", "'".$color_code."'");
                                $status_count_update_id = $obj->UpdateSQL($GLOBALS['status_count_table'], $getUniqueID, $columns, $values, $action);
                                if(preg_match("/^\d+$/", $status_count_update_id)) {			
                                    $result = array('number' => '1', 'msg' => 'Updated Successfully');						
                                }
                                else {
                                    $result = array('number' => '2', 'msg' => $status_count_update_id);
                                }							
                            }
                        }   
                        else {
                            $result = array('number' => '2', 'msg' => $color_code_error);
                        } 
					}
					else {
						$result = array('number' => '2', 'msg' => $status_count_error);
					}
                }

			}
			else {
				$result = array('number' => '2', 'msg' => 'Invalid IP');
			}
		}
		else {
			$result = array('number' => '3', 'msg' => $valid_status_count);
		}
		
		if(!empty($result)) {
			$result = json_encode($result);
		}
		echo $result; exit;
	}	
	
	if(isset($_POST['page_number'])) {
		$page_number = $_POST['page_number'];
		$page_limit = $_POST['page_limit'];
		$page_title = $_POST['page_title'];

		$search_text = "";
		if(isset($_POST['search_text'])) {
			$search_text = $_POST['search_text'];
		}

		$total_records_list = array();
		$total_records_list = $obj->getTableRecords($GLOBALS['status_count_table'], '', '');

		if(!empty($search_text)) {
			$search_text = strtolower($search_text);
			$list = array();
			if(!empty($total_records_list)) {
				foreach($total_records_list as $val) {
					if(strpos(strtolower($obj->encode_decode('decrypt', $val['name'])), $search_text) !== false) {
						$list[] = $val;
					}
				}
			}
			$total_records_list = $list;
		}
		
		$total_pages = 0;
		if(!empty($total_records_list)) {
			$total_pages = count($total_records_list);
		}
		
		$page_start = 0; $page_end = 0;
		if(!empty($page_number) && !empty($page_limit) && !empty($total_pages)) {
			if($total_pages > $page_limit) {
				if($page_number) {
					$page_start = ($page_number - 1) * $page_limit;
					$page_end = $page_start + $page_limit;
				}
			}
			else {
				$page_start = 0;
				$page_end = $page_limit;
			}
		}

		$show_records_list = array();
        if(!empty($total_records_list)) {
            foreach($total_records_list as $key => $val) {
                if($key >= $page_start && $key < $page_end) {
                    $show_records_list[] = $val;
                }
            }
        }
?>
        
		<?php if($total_pages > $page_limit) { ?>
			<div class="pagination_cover mt-3"> 
				<?php
					include("pagination.php");
				?> 
			</div> 
		<?php } ?>

		<table class="table nowrap show_frontend_table">
            <thead>
                <tr>
					<th class="text-center px-2 py-2">S.No</th>
                    <th class="text-center px-2 py-2">Status Name</th>
                    <th class="text-center px-2 py-2" style="width: 100px;">Color</th>
                    <th class="text-center px-2 py-2">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php
                    if(!empty($show_records_list)) {
                        foreach($show_records_list as $key => $data) {
							$status_count_name = "";
							if(!empty($data['name'])) {
								$status_count_name = $obj->encode_decode('decrypt', $data['name']);
								$status_count_name = str_replace("$", '"', $status_count_name);
								$data['name'] = str_replace("'''", '"', $data['name']);
								$status_count_name = trim($status_count_name);
							}
                ?>
							<tr>
								<td class="text-center px-2 py-2"><?php echo $key + 1; ?></td>
								<td class="px-2 py-2">
									<div class="w-100">
										<?php if(!empty($status_count_name)) { echo $status_count_name; } ?>
									</div>
									
									<?php
										if(!empty($data['creator_name'])) {
											$data['creator_name'] = $obj->encode_decode('decrypt', $data['creator_name']);
									?>
											<small><?php echo "creator : ".$data['creator_name']; ?></small>
									<?php		
										}
									?>
								</td>
                                <td>
                                    <div <?php if(!empty($data['color_code'])) { ?> style="background-color:<?php echo $data['color_code']; ?>; height: 30px;" <?php } ?>></div>
                                </td>
								<td class="text-center px-2 py-2">
									<div class="dropdown">
										<a class="btn btn-dark poppins px-3" href="#" role="button" data-toggle="dropdown">
											<i class="fa fa-ellipsis-v text-white"></i>
										</a>
										<div class="dropdown-menu dropdown-menu-right dropdown-menu-icon-list">
											<a class="dropdown-item" href="Javascript:ShowModalContent('<?php if(!empty($page_title)) { echo $page_title; } ?>', '<?php if(!empty($data['status_count_id'])) { echo $data['status_count_id']; } ?>');"><i class="fa fa-pencil"></i> &ensp; View / Edit</a>
											<a class="dropdown-item" href="Javascript:DeleteModalContent('<?php if(!empty($page_title)) { echo $page_title; } ?>', '<?php if(!empty($data['status_count_id'])) { echo $data['status_count_id']; } ?>');"><i class="fa fa-trash"></i> &ensp; Delete</a>
										</div>
									</div>
								</td>
							</tr>
                <?php
                        }
                    }
                    else {
                ?>
                        <tr>
                            <td colspan="4" class="text-center">Sorry! No records found</td>
                        </tr>
                <?php } ?>
            </tbody>
        </table>
<?php	
	}
	
	if(isset($_REQUEST['delete_status_count_id'])) {
		$delete_status_count_id = $_REQUEST['delete_status_count_id'];
		$msg = "";
		if(!empty($delete_status_count_id)) {	
			$status_count_list = array(); $status_count = 0;
            $status_count_list = $obj->getTableRecords($GLOBALS['order_table'], 'order_status', $delete_status_count_id);
			if(!empty($status_count_list)) {
				$status_count = count($status_count_list);
			}

			if(empty($status_count)) {
				$status_count_unique_id = "";
				$status_count_unique_id = $obj->getTableColumnValue($GLOBALS['status_count_table'], 'status_count_id', $delete_status_count_id, 'id');
				if(preg_match("/^\d+$/", $status_count_unique_id)) {
					$name = "";
					$name = $obj->getTableColumnValue($GLOBALS['status_count_table'], 'status_count_id', $delete_status_count_id, 'name');
				
					$action = "";
					if(!empty($name)) {
						$action = "Status Deleted. Name - ".$obj->encode_decode('decrypt', $name);
					}
				
					$columns = array(); $values = array();						
					$columns = array('deleted');
					$values = array("'1'");
					$msg = $obj->UpdateSQL($GLOBALS['status_count_table'], $status_count_unique_id, $columns, $values, $action);
				}
			}
			else {
				$msg = "Unable To Delete";
			}
		}
		echo $msg;
		exit;	
	}
?>