<?php 
	$access_page = "Orders";
    include("include_user_check.php");
	
	$project_title = "";
	$project_title = $obj->getProjectTitle();

    $page_title = "Order Report";

    $from_date = date("01-01-Y"); $to_date = date("31-12-Y"); $filter_customer_id = ""; $filter_staff_id = "";
    $filter_status = ""; $filter_order_type = "";

    $staff_id = ""; $staff_name = "";
	if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id']) && isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'])) {
		$staff_id = $obj->getTableColumnValue($GLOBALS['user_table'], 'user_id', $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'], 'staff_id');
		if(!empty($staff_id) && $staff_id != $GLOBALS['null_value']) {
			$filter_staff_id = $staff_id;
			$staff_name = $obj->getTableColumnValue($GLOBALS['staff_table'], 'staff_id', $staff_id, 'name');
		}
	}

	if(!empty($staff_id) && !empty($staff_name)) {
		//$customer_list = $obj->StaffCreatedCustomers($staff_id, '1');
        $customer_list = $obj->getTableRecords($GLOBALS['customer_table'], 'creator', $staff_id);
	}
	else {
		$customer_list = $obj->getTableRecords($GLOBALS['customer_table'], '', '');
	}

    $staff_list = array();
    $staff_list = $obj->getTableRecords($GLOBALS['staff_table'], '', '');

    $order_type_list = array($GLOBALS['frontend_order'], $GLOBALS['backend_order']);

    if(isset($_POST['from_date'])) {
        $from_date = $_POST['from_date'];
    }
    if(isset($_POST['to_date'])) {
        $to_date = $_POST['to_date'];
    }    
    if(isset($_POST['filter_customer_id'])) {
        $filter_customer_id = $_POST['filter_customer_id'];
    }
    if(isset($_POST['filter_staff_id'])) {
        $filter_staff_id = $_POST['filter_staff_id'];
    }

    if(empty($filter_staff_id)) {
        if(!empty($staff_id) && !empty($staff_name)) {
            $filter_staff_id = $staff_id;
        }
    }

    if(isset($_POST['filter_status'])) {
        $filter_status = $_POST['filter_status'];
    }
    if(isset($_POST['filter_order_type'])) {
        $filter_order_type = $_POST['filter_order_type'];
    }

    $staff_id = ""; $access_orders = 0; $order_list = array();
    if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id']) && isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'])) {
        $staff_id = $obj->getTableColumnValue($GLOBALS['user_table'], 'user_id', $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'], 'staff_id');
        if(!empty($staff_id) && $staff_id != $GLOBALS['null_value']) {	
            $access_orders = $obj->CheckStaffAccessPage($staff_id, $GLOBALS['access_orders_page']);
            $order_list = $obj->DisplayCrackerOrders($from_date, $to_date, $filter_customer_id, $filter_staff_id, $filter_status, '', '', $access_orders);
        }
        else if(!empty($staff_id) && $staff_id == $GLOBALS['null_value']) {
            $order_list = $obj->DisplayCrackerOrders($from_date, $to_date, $filter_customer_id, $filter_staff_id, $filter_status, $filter_order_type, '', '');
        }
    }

    $company_name = ""; $company_logo = ""; $company_address = ""; $company_mobile_number = ""; $company_email = "";
    $target_dir = $obj->image_directory();

    $company_list = array();
    $company_list = $obj->getTableRecords($GLOBALS['company_table'], '', '');
    if(!empty($company_list)) {
        foreach($company_list as $data) {
            if(!empty($data['name'])) {
                $company_name = $obj->encode_decode('decrypt', $data['name']);
            }
            if(!empty($data['logo']) && $data['logo'] != $GLOBALS['null_value']) {
                $company_logo = $data['logo'];
            }
            if(!empty($data['address']) && $data['address'] != $GLOBALS['null_value']) {
                $company_address = $obj->encode_decode('decrypt', $data['address']);
                if(!empty($company_address)) {
                    $company_address = str_replace("\r\n", "<br>", $company_address);
                }
            }
            if(!empty($data['mobile_number'])) {
                $company_mobile_number = $obj->encode_decode('decrypt', $data['mobile_number']);
            }
            if(!empty($data['email'])) {
                $company_email = $obj->encode_decode('decrypt', $data['email']);
            }
        }
    }

?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title> <?php if(!empty($project_title)) { echo $project_title; } ?> - <?php if(!empty($page_title)) { echo $page_title; } ?> </title>
	<?php include "link_style_script.php"; ?>
	<script type="text/javascript" src="include/print_pdf/jspdf.min.js"></script>
    <script type="text/javascript" src="include/print_pdf/html2canvas.js"></script>
    <script type="text/javascript" src="include/print_pdf/print_pdf.js"></script>
</head>
<body>
	<?php include "header.php";  ?>
	<!-- sidebar-wrapper  -->          
	<div class="page-wrapper chiller-theme toggled">
		<main class="page-content">
			<div class="container-fluid px-lg-5">
				<div class="border card-box">

                    <div class="card-header">              
                        <div class="row">
                            <div class="col-sm-5 text-center text-sm-left">
                                <h5 class="headfnt"><?php if(!empty($page_title)) { echo $page_title; } ?></h5>
                            </div>
                            <div class="col-sm-3 search_text"></div>
                            <div class="col-sm-4 text-center text-sm-right">
                                <!-- <button class="btn btn-dark poppins" style="font-size:11px;" type="button" onClick="Javascript:print_content();"> <i class="fa fa-print"></i> &ensp; Print</button>&nbsp; -->
                                <button class="btn btn-dark poppins" style="font-size:11px;" type="button" onClick="window.open('reports/rpt_orders_list.php?from_date=<?php echo $from_date; ?>&to_date=<?php echo $to_date; ?>&customer_id=<?php echo $filter_customer_id; ?>&staff_id=<?php echo $filter_staff_id; ?>&status=<?php echo $filter_status; ?>&order_type=<?php echo $filter_order_type; ?>')"> <i class="fa fa-file-pdf-o"></i> &ensp; PDF</button>&nbsp;
                                <button class="btn btn-dark poppins" style="font-size:11px;" target='_self' type="button" onClick="window.open('export/exp_orders.php?from_date=<?php echo $from_date; ?>&to_date=<?php echo $to_date; ?>&customer_id=<?php echo $filter_customer_id; ?>&staff_id=<?php echo $filter_staff_id; ?>&status=<?php echo $filter_status; ?>&order_type=<?php echo $filter_order_type; ?>')"> <i class="fa fa-download"></i> &ensp; Export</button>
                                &nbsp; <a class="btn btn-danger poppins" style="font-size:11px;" href="order.php">Back</a>
                            </div>
                        </div>
                    </div>

                    <form name="report_form" method="post">
						<div class="row my-3 mx-0">
							<div class="col-sm-3 form-group">
								<input type="text" name="from_date" class="form-control date_field" onChange="Javascript:getOrderReport();" value="<?php if(!empty($from_date)) { echo $from_date; } ?>" placeholder="From Date">
							</div>
                            <div class="col-sm-3 form-group">
								<input type="text" name="to_date" class="form-control date_field" onChange="Javascript:getOrderReport();" value="<?php if(!empty($to_date)) { echo $to_date; } ?>" placeholder="To Date">
							</div>
							<div class="col-sm-6 form-group">
								<select name="filter_customer_id" class="form-control" onChange="Javascript:getOrderReport();">
									<option value="">Select Customer</option>
									<?php
										if(!empty($customer_list)) {
											foreach($customer_list as $data) {
									?>
												<option value="<?php if(!empty($data['customer_id'])) { echo $data['customer_id']; } ?>" <?php if(!empty($filter_customer_id) && $data['customer_id'] == $filter_customer_id) { ?> selected <?php } ?> >
                                                    <?php
														if(!empty($data['name'])) {
															$data['name'] = $obj->encode_decode('decrypt', $data['name']);
															echo $data['name'];
															if(!empty($data['mobile_number'])) {
																$data['mobile_number'] = $obj->encode_decode('decrypt', $data['mobile_number']);
																echo " - ".$data['mobile_number'];
															}
														}
													?>
												</option>
									<?php			
											}
										}
									?>
								</select>
							</div>
                            <?php /* ?><div class="col-sm-6 form-group">
                                <?php if(!empty($filter_staff_id)) { ?>
                                    <input type="hidden" name="filter_staff_id" value="<?php if(!empty($filter_staff_id)) { echo $filter_staff_id; } ?>">
                                <?php } else { ?>
								<select name="filter_staff_id" class="form-control" onChange="Javascript:getOrderReport();">
									<option value="">Select Staff</option>
									<?php
										if(!empty($staff_list)) {
											foreach($staff_list as $data) {
									?>
												<option value="<?php if(!empty($data['name'])) { echo $data['name']; } ?>" <?php if(!empty($filter_staff_id) && $data['name'] == $filter_staff_id) { ?> selected <?php } ?> >
													<?php
														if(!empty($data['name'])) {
															$data['name'] = $obj->encode_decode('decrypt', $data['name']);
															echo $data['name'];
														}
													?>
												</option>
									<?php			
											}
										}
									?>
								</select>
                                <?php } ?>
							</div>
                            <div class="dropdown col-sm-3 form-group status_filter">
								<button type="button" class="dropbtn" style="width:100px;height:40px; ;">
									Status
								</button>
								
								<div class="dropdown-content">
									<a href="#" onclick="check_status('1');" ><img src="images/tick1.jpg" width="100" height="35"></a>
									<a href="#" onclick="check_status('2');"><img src="images/tick2.jpg" width="100" height="35"></a>
									<a href="#" onclick="check_status('3');"><img src="images/tick3.jpg" width="100" height="35"></a>
									<a href="#" onclick="check_status('4');"><img src="images/notick.jpg" width="100" height="35"></a>
									<a href="#" onclick="check_status('5');">Unopened</a>
								</div>
							</div>
                            <?php if(empty($staff_name)) { ?>
                            <div class="col-sm-3 form-group">
								<select name="order_type" class="form-control" onChange="Javascript:table_listing_records_filter();">
									<option value="">Select Order Type</option>
									<?php
										if(!empty($order_type_list)) {
											foreach($order_type_list as $order_type) {
												if(!empty($order_type)) {
									?>
													<option value="<?php echo $obj->encode_decode('encrypt', $order_type); ?>" <?php if(!empty($filter_order_type) && $obj->encode_decode('encrypt', $order_type) == $filter_order_type) { ?> selected <?php } ?> > <?php echo $order_type; ?> </option>
									<?php				
												}
											}
										}
									?>
								</select>
							</div>
                            <?php } */ ?>
						</div>
					</form>
					
					<div class="table-responsive px-3 py-3">
                        <div id="report_area" class="w-100">
                            <table cellpadding="0" cellspacing="0" class="report_table print_order" style="width: 100%;">
                                <thead>
                                    <!--<tr>
                                        <th colspan="6" style="padding: 5px; border: 1px solid #000; text-align: center; font-size: 15px;">
                                        </th>
                                    </tr>-->
                                    <tr>
                                        <th colspan="8" style="padding: 5px; border: 1px solid #000; text-align: center; font-size: 15px;">
                                            <?php
                                                $heading = "Order Report";
                                                if(!empty($filter_customer_id)) {
                                                    $customer_name = "";
						                            $customer_name = $obj->getTableColumnValue($GLOBALS['customer_table'], 'customer_id', $filter_customer_id, 'name');
                                                    if(!empty($customer_name)) {
                                                        $customer_name = $obj->encode_decode('decrypt', $customer_name);
                                                        $heading = $customer_name." Order Report";
                                                    }
                                                }
                                                if(!empty($from_date) || !empty($to_date)) {
                                                    $heading = $heading." - ( ";
                                                    if(!empty($from_date)) { 
                                                        $heading = $heading."From Date : ".date("d-m-Y", strtotime($from_date)); 
                                                        if(!empty($to_date)) { $heading = $heading." "; }
                                                    }
                                                    if(!empty($to_date)) { $heading = $heading."To Date : ".date("d-m-Y", strtotime($to_date)); }
                                                    $heading = $heading." )";
                                                }
                                                if(!empty($heading)) { echo $heading; }
                                            ?>
                                        </th>
                                    </tr>                                    
                                    <tr>
                                        <th style="padding: 5px; border: 1px solid #000; text-align: center; width: 50px; font-size: 12px;">S.No</th>
                                        <th style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 100px; font-size: 12px;">Order Type</th>
                                        <th style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 100px; font-size: 12px;">Order Number</th>
                                        <th style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 70px; font-size: 12px;">Order Date</th>
                                        <th style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; font-size: 12px;">Customer Name</th>
                                        <th style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 125px; font-size: 12px;">City</th>
                                        <th style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 75px; font-size: 12px;">Mobile</th>
                                        <th style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 125px; font-size: 12px;">Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        if(!empty($order_list)) {
                                            $total_amount = 0;
                                            foreach($order_list as $key => $data) {
                                                if(!empty($data['order_id'])) {
                                                    if(!empty($data['customer_id'])){
                                                        $customer_id = ""; $customer_city = ""; $customer_mobile_number = "";
                                                        $customer_id = $data['customer_id'];

                                                        if(!empty($data['customer_city']) && $data['customer_city'] != $GLOBALS['null_value']){
                                                            $customer_city = $obj->encode_decode('decrypt',$data['customer_city']);
                                                        }
                                        
                                                        $customer_list = array();
                                                        $customer_list = $obj->getTableRecords($GLOBALS['customer_table'],'customer_id',$customer_id);
                                                        if(!empty($customer_list)){
                                                            foreach($customer_list as $customer){                                                                
                                                                if(!empty($customer['mobile_number'])){
                                                                    $customer_mobile_number = $obj->encode_decode('decrypt',$customer['mobile_number']);
                                                                }
                                                            }
                                                        }
                                                    }
                                    ?>
                                                    <tr>
                                                        <td style="padding: 5px; border: 1px solid #000; text-align: center; width: 50px; font-size: 12px;">
                                                            <?php echo $key + 1; ?>
                                                        </td>
                                                        <td style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 100px; font-size: 12px;">
                                                            <?php
                                                                if(!empty($data['order_type'])) {
                                                                    $data['order_type'] = $obj->encode_decode('decrypt', $data['order_type']);
                                                                    echo $data['order_type'];
                                                                }
                                                            ?>
                                                        </td>
                                                        <td style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 100px; font-size: 12px;">
                                                            <?php
                                                                if(!empty($data['order_number']) && $data['order_number'] != $GLOBALS['null_value']) {
                                                                    $data['order_number'] = $obj->encode_decode('decrypt', $data['order_number']);
                                                                    echo $data['order_number'];
                                                                }
                                                            ?>
                                                        </td>
                                                        <td style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 75px; font-size: 12px;">
                                                            <?php if(!empty($data['order_date']) && $data['order_date'] != "0000-00-00") { echo date("d-m-Y", strtotime($data['order_date'])); } ?>
                                                        </td>
                                                        <td style="padding: 5px 10px; border: 1px solid #000; border-left: none; font-size: 12px;">
                                                            <?php
																$customer_details = "";
                                                                if(!empty($data['customer_details'])) {
                                                                    $data['customer_details'] = $obj->encode_decode('decrypt', $data['customer_details']);
																	$customer_details = explode("<br>", $data['customer_details']);
                                                                    if(!empty($customer_details['0'])) {
																		echo $customer_details['0'];
																	}
                                                                }
                                                            ?>
                                                        </td>
                                                        <td style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 125px; font-size: 12px;">
                                                            <?php if(!empty($customer_city)) { echo $customer_city; } ?>
                                                        </td>
                                                        <td style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 75px; font-size: 12px;">
                                                        <?php if(!empty($customer_mobile_number)) { echo $customer_mobile_number; } ?>
                                                        </td>
                                                        <td style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 125px; font-size: 12px;">
                                                            <?php 
                                                                if(!empty($data['total_amount'])) {  
                                                                    $total_amount = $total_amount + $data['total_amount'];
                                                                    echo number_format($data['total_amount'], 2); 
                                                                } 
                                                            ?>
                                                        </td>
                                                    </tr>
                                    <?php  
                                                }
                                            }
                                    ?>
                                            <tr>
                                                <td colspan="7" style="padding: 5px; border: 1px solid #000; text-align: right; font-size: 12px; font-weight: bold;">Total</td>
                                                <td style="padding: 5px; border: 1px solid #000; border-left: none; text-align: center; width: 125px; font-size: 12px; font-weight: bold;">
                                                    <?php 
                                                        if(!empty($total_amount)) {  
                                                            echo number_format($total_amount, 2); 
                                                        } 
                                                    ?>
                                                </td>
                                            </tr>
                                    <?php        
                                        }
                                        else {
                                    ?>
                                            <tr>
                                                <td colspan="8" style="padding: 5px; border: 1px solid #000; text-align: center;">Sorry! No orders found</td>
                                            </tr>
                                    <?php        
                                        }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                    </div>

				</div>
			</div>
		</main>
	</div>  
	<!-- page-wrapper -->

    <style>
		.dropbtn {
			background-color: #4CAF50;
			color: white;
			/* padding: 16px; */
			font-size: 16px;
			border: none;
			cursor: pointer;
		}

		.dropdown {
			position: relative;
			display: inline-block;
		}

		.dropdown-content {
			display: none;
			position: absolute;
			background-color: #f9f9f9;
			min-width: 160px;
			box-shadow: 0px 8px 16px
				0px rgba(0, 0, 0, 0.2);
			z-index: 1;
		}

		.dropdown-content a {
			color: black;
			padding: 12px 16px;
			text-decoration: none;
			display: block;
		}

		.dropdown-content a:hover {
			background-color: #f1f1f1
		}

		.dropdown:hover .dropdown-content {
			display: block;
		}

		.dropdown:hover .dropbtn {
			background-color: #3e8e41;
		}

        .status_filter .dropdown-content {
            max-height: 150px;
            overflow-y: scroll;
            scrollbar-width: thin;
        }
	</style>
	<script>
		jQuery(document).ready(function(){
			jQuery("#ordersactive").addClass("active");
            //prepare_print_view();
		});

        function check_status(value)
		{
			if(value == "1"){
				$("#filter_status").val("1");
			}
			else if(value == "2"){
				$("#filter_status").val("2");
			}
			else if(value == "3"){
				$("#filter_status").val("3");
			}
			else if(value == "4"){
				$("#filter_status").val("4");
			}
			else if(value == "5"){
				$("#filter_status").val("5");
			}
			getOrderReport();
		}

        function getOrderReport() {
            if(jQuery('form[name="report_form"]').length > 0) {
                jQuery('form[name="report_form"]').submit();
            }
        }
	</script>

	<?php include "footer.php"; ?>

    </body>
</html>