

CREATE TABLE `taf_company` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `company_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `logo` mediumtext NOT NULL,
  `address` mediumtext NOT NULL,
  `state` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `gst_number` mediumtext NOT NULL,
  `primary_company` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  `cash_in_hand` mediumtext NOT NULL,
  `website_on` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO taf_company (id, created_date_time, creator, creator_name, company_id, name, lower_case_name, logo, address, state, mobile_number, gst_number, primary_company, deleted, cash_in_hand, website_on) VALUES ('1','2024-01-10 17:35:17','56564e46556c38784d773d3d','55334a706332396d64486468636d5636','5130394e5545464f575638784d4441784d6a41794e4441314d7a55784e3138774d513d3d','5647467461577868636d467a6153424761584a6c6432397961334d3d','6447467461577868636d467a6153426d61584a6c6432397961334d3d','logo_27_03_2024_09_57_18.png','6257467062694269595870365958497349484e70646d467259584e70','5647467461577767546d466b64513d3d','4f544d304f446b7a4d7a67304f513d3d','4d7a4e42515564475244677a4e5464474d317047','1','0','','0');


CREATE TABLE `taf_login` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `login_date_time` mediumtext NOT NULL,
  `logout_date_time` mediumtext NOT NULL,
  `ip_address` mediumtext NOT NULL,
  `browser` mediumtext NOT NULL,
  `os_detail` mediumtext NOT NULL,
  `type` mediumtext NOT NULL,
  `user_id` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO taf_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('1','2024-05-21 17:18:45','2024-05-21 17:18:45','103.104.58.164','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:126.0) Gecko/20100101 Firefox/126.0','Linux bom1plzcpnl494587.prod.bom1.secureserver.net 4.18.0-513.9.1.lve.el8.x86_64 #1 SMP Mon Dec 4 15:01:22 UTC 2023 x86_64','Super Admin','56564e46556c38784d773d3d','0');

INSERT INTO taf_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('2','2024-05-21 17:18:46','2024-05-21 17:18:46','103.104.58.164','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:126.0) Gecko/20100101 Firefox/126.0','Linux bom1plzcpnl494587.prod.bom1.secureserver.net 4.18.0-513.9.1.lve.el8.x86_64 #1 SMP Mon Dec 4 15:01:22 UTC 2023 x86_64','Super Admin','56564e46556c38784d773d3d','0');

INSERT INTO taf_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('3','2024-05-22 16:24:34','2024-05-22 16:24:34','103.104.58.164','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:126.0) Gecko/20100101 Firefox/126.0','Linux bom1plmcpnl503477.prod.bom1.secureserver.net 4.18.0-513.11.1.lve.el8.x86_64 #1 SMP Thu Jan 18 16:21:02 UTC 2024 x86_64','Super Admin','56564e46556c38784d773d3d','0');

INSERT INTO taf_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('4','2024-05-22 16:44:03','2024-05-22 16:44:03','106.195.41.154','Mozilla/5.0 (Linux; Android 9; CPH1931) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.104 Mobile Safari/537.36','Linux bom1plmcpnl503477.prod.bom1.secureserver.net 4.18.0-513.11.1.lve.el8.x86_64 #1 SMP Thu Jan 18 16:21:02 UTC 2024 x86_64','Super Admin','56564e46556c38784d773d3d','0');

INSERT INTO taf_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('5','2024-05-22 16:55:20','2024-05-22 16:55:20','157.45.194.168','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/25.0 Chrome/121.0.0.0 Mobile Safari/537.36','Linux bom1plmcpnl503477.prod.bom1.secureserver.net 4.18.0-513.11.1.lve.el8.x86_64 #1 SMP Thu Jan 18 16:21:02 UTC 2024 x86_64','manager','54565a4e545530764d444178','0');

INSERT INTO taf_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('6','2024-05-22 17:00:31','2024-05-22 17:00:31','106.195.41.154','Mozilla/5.0 (Linux; Android 9; CPH1931) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.104 Mobile Safari/537.36','Linux bom1plmcpnl503477.prod.bom1.secureserver.net 4.18.0-513.11.1.lve.el8.x86_64 #1 SMP Thu Jan 18 16:21:02 UTC 2024 x86_64','Super Admin','56564e46556c38784d773d3d','0');

INSERT INTO taf_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('7','2024-05-27 07:33:56','2024-05-27 07:33:56','27.62.35.164','Mozilla/5.0 (Linux; Android 9; CPH1931) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.104 Mobile Safari/537.36','Linux bom1plmcpnl503477.prod.bom1.secureserver.net 4.18.0-513.11.1.lve.el8.x86_64 #1 SMP Thu Jan 18 16:21:02 UTC 2024 x86_64','Super Admin','56564e46556c38784d773d3d','0');

INSERT INTO taf_login (id, login_date_time, logout_date_time, ip_address, browser, os_detail, type, user_id, deleted) VALUES ('8','2024-05-27 08:06:57','2024-05-27 08:06:57','117.99.252.35','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/122.0.0.0 Mobile Safari/537.36','Linux bom1plmcpnl503477.prod.bom1.secureserver.net 4.18.0-513.11.1.lve.el8.x86_64 #1 SMP Thu Jan 18 16:21:02 UTC 2024 x86_64','manager','54565a4e545530764d444179','0');


CREATE TABLE `taf_manager` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `manager_id` mediumtext NOT NULL,
  `manager_unique_id` mediumtext NOT NULL,
  `manager_name` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `address` mediumtext NOT NULL,
  `city` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `state` mediumtext NOT NULL,
  `username` mediumtext NOT NULL,
  `password` mediumtext NOT NULL,
  `wallet_balance` mediumtext NOT NULL,
  `bonus_point` mediumtext NOT NULL,
  `plan_id` mediumtext NOT NULL,
  `access_pages` mediumtext NOT NULL,
  `access_page_actions` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO taf_manager (id, created_date_time, creator, creator_name, bill_company_id, manager_id, manager_unique_id, manager_name, lower_case_name, address, city, mobile_number, state, username, password, wallet_balance, bonus_point, plan_id, access_pages, access_page_actions, deleted) VALUES ('1','2024-05-22 16:53:36','56564e46556c38784d773d3d','55334a706332396d64486468636d5636','NULL','625746755957646c636c38794d6a41314d6a41794e4441304e544d7a4e6c38774d513d3d','54565a4e545530764d444178','5543357462326868626e4a6862513d3d','6257396f595735795957303d','4d7977675a3239325a584a75625756756443426f6157646f49484e6a614739766243783061476c795a43426a636d397a6379427a623356306143427a64484a6c5a58517359577873615735685a324679625378306147567561513d3d','5647686c626d6b3d','4f5463354d4467784d546b794d673d3d','5647467461577767546d466b64513d3d','5457396f595735795957303d','516c6449554530334d4467356345413d','0','0','63477868626c38794e6a41304d6a41794e4445774d6a51784e6c38774d773d3d','62575674596d5679','566d6c6c64773d3d$$$5157526b$$$5257527064413d3d$$$524756735a58526c','0');

INSERT INTO taf_manager (id, created_date_time, creator, creator_name, bill_company_id, manager_id, manager_unique_id, manager_name, lower_case_name, address, city, mobile_number, state, username, password, wallet_balance, bonus_point, plan_id, access_pages, access_page_actions, deleted) VALUES ('2','2024-05-27 07:37:41','56564e46556c38784d773d3d','55334a706332396d64486468636d5636','NULL','625746755957646c636c38794e7a41314d6a41794e4441334d7a63304d5638774d673d3d','54565a4e545530764d444179','5579357a59584a68646d46755957343d','6332467959585a68626d4675','4d5445314c7a4567566d566c636d46775958526f61584a686269427a64484a6c5a5851674451705761584a315a476831626d466e595849674e6a49324d444178','566d6c796457526f645735685a324679','4f5467354e4467314e4449774d673d3d','5647467461577767546d466b64513d3d','5532467959585a68626d4675','55324679595734354e45413d','0','0','63477868626c38794e6a41304d6a41794e4445774d6a51784e6c38774d773d3d','62575674596d5679','566d6c6c64773d3d$$$5157526b$$$5257527064413d3d$$$524756735a58526c','0');


CREATE TABLE `taf_member` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `member_id` mediumtext NOT NULL,
  `member_unique_id` mediumtext NOT NULL,
  `reference_id` mediumtext NOT NULL,
  `member_name` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `address` mediumtext NOT NULL,
  `city` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `state` mediumtext NOT NULL,
  `username` mediumtext NOT NULL,
  `password` mediumtext NOT NULL,
  `wallet_balance` mediumtext NOT NULL,
  `bonus_point` mediumtext NOT NULL,
  `manager_id` mediumtext NOT NULL,
  `plan_id` mediumtext NOT NULL,
  `is_approved` mediumtext NOT NULL,
  `is_rejected` mediumtext NOT NULL,
  `payment_screenshot` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `taf_plan` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `plan_id` mediumtext NOT NULL,
  `plan_name` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `plan_value` mediumtext NOT NULL,
  `valid_end_date` mediumtext NOT NULL,
  `due_count` mediumtext NOT NULL,
  `payable_amount` mediumtext NOT NULL,
  `upi_id` mediumtext NOT NULL,
  `plan_upi_image` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO taf_plan (id, created_date_time, creator, creator_name, plan_id, plan_name, lower_case_name, plan_value, valid_end_date, due_count, payable_amount, upi_id, plan_upi_image, deleted) VALUES ('1','2024-04-26 10:21:44','56564e46556c38784d773d3d','55334a706332396d64486468636d5636','63477868626c38794e6a41304d6a41794e4445774d6a45304e4638774d513d3d','4d6a49774d413d3d','4d6a49774d413d3d','2200','30-10-2024','0','2200','6253357459577868636d526c646d6b784f546b79514739725958687063773d3d','plan_upi_26_04_2024_10_21_21.jpg','0');

INSERT INTO taf_plan (id, created_date_time, creator, creator_name, plan_id, plan_name, lower_case_name, plan_value, valid_end_date, due_count, payable_amount, upi_id, plan_upi_image, deleted) VALUES ('2','2024-04-26 10:23:23','56564e46556c38784d773d3d','55334a706332396d64486468636d5636','63477868626c38794e6a41304d6a41794e4445774d6a4d794d3138774d673d3d','4d6a63774d413d3d','4d6a63774d413d3d','2700','30-10-2024','0','2700','6253357459577868636d526c646d6b784f546b79514739725958687063773d3d','plan_upi_26_04_2024_10_23_17.jpg','0');

INSERT INTO taf_plan (id, created_date_time, creator, creator_name, plan_id, plan_name, lower_case_name, plan_value, valid_end_date, due_count, payable_amount, upi_id, plan_upi_image, deleted) VALUES ('3','2024-04-26 10:24:16','56564e46556c38784d773d3d','55334a706332396d64486468636d5636','63477868626c38794e6a41304d6a41794e4445774d6a51784e6c38774d773d3d','4d7a55774d413d3d','4d7a55774d413d3d','3500','30-10-2024','0','3500','6253357459577868636d526c646d6b784f546b79514739725958687063773d3d','plan_upi_26_04_2024_10_24_28.jpg','0');


CREATE TABLE `taf_plan_closingdetails` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `plan_closing_id` mediumtext NOT NULL,
  `member_id` mediumtext NOT NULL,
  `plan_id` mediumtext NOT NULL,
  `plan_value` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `taf_plan_closure` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `plan_closure_id` mediumtext NOT NULL,
  `plan_closure_number` mediumtext NOT NULL,
  `member_id` mediumtext NOT NULL,
  `member_name` mediumtext NOT NULL,
  `plan_id` mediumtext NOT NULL,
  `plan_value` mediumtext NOT NULL,
  `paid_amount` mediumtext NOT NULL,
  `description` mediumtext NOT NULL,
  `deleted` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `taf_receipt` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `receipt_id` mediumtext NOT NULL,
  `receipt_number` mediumtext NOT NULL,
  `receipt_date` date NOT NULL,
  `view_type` mediumtext NOT NULL,
  `member_id` mediumtext NOT NULL,
  `member_name` mediumtext NOT NULL,
  `manager_id` mediumtext NOT NULL,
  `plan_id` mediumtext NOT NULL,
  `amount` mediumtext NOT NULL,
  `receipt_type` mediumtext NOT NULL,
  `narration` mediumtext NOT NULL,
  `member_details` mediumtext NOT NULL,
  `deleted` int(10) NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  `is_approved` mediumtext NOT NULL,
  `is_rejected` mediumtext NOT NULL,
  `payment_screenshot` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `taf_user` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `created_date_time` datetime NOT NULL,
  `creator` mediumtext NOT NULL,
  `creator_name` mediumtext NOT NULL,
  `user_id` mediumtext NOT NULL,
  `name` mediumtext NOT NULL,
  `mobile_number` mediumtext NOT NULL,
  `type` mediumtext NOT NULL,
  `username` mediumtext NOT NULL,
  `lower_case_name` mediumtext NOT NULL,
  `password` mediumtext NOT NULL,
  `admin` int(100) NOT NULL,
  `deleted` int(100) NOT NULL,
  `bill_company_id` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;


INSERT INTO taf_user (id, created_date_time, creator, creator_name, user_id, name, mobile_number, type, username, lower_case_name, password, admin, deleted, bill_company_id) VALUES ('13','2023-07-19 13:03:21','56564e46556c38784d773d3d','55334a706332396d64486468636d5636','56564e46556c38784d773d3d','55334a706332396d64486468636d5636','4e6a4d344d4463794f546b354f413d3d','553356775a584967515752746157343d','55334a706332396d64486468636d5636','63334a706332396d64486468636d5636','51575274615734784d6a4e41','1','0','5130394e5545464f575638784d4441784d6a41794e4441314d7a55784e3138774d513d3d');
