<?php

    include("../include_user_check_and_files.php");
    include("../include/billing_functions.php");

    $member_id = ""; $view_type = "";
    if(isset($_GET['member_id'])) {
        $member_id = $_GET['member_id'];
    }
    else {
        header("Location: ../pending_overall.php");
        exit;
    }     
    
    $overall_pending_list = array(); $stock_report = array(); $product_id = ""; $stock_order = ""; $member_name = ""; $manager_name = "";


    $member_list = array(); $manager_list = array();
    $member_list = $obj->getTableRecords($GLOBALS['member_table'], '', '');
    $manager_list = $obj->getTableRecords($GLOBALS['manager_table'], '', '');

    $total_member_list = array();
    
    if(!empty($member_list)) {
        foreach($member_list as $data) {
            if(!empty($data)) {
                $total_member_list[] = $data;
            }
        }
    }  
    if(!empty($manager_list)) {
        foreach($manager_list as $data) {
            if(!empty($data)) {
                $total_member_list[] = $data;
            }
        }
    }        
   
    if(!empty($member_id)) {
        $member_name = $obj->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $member_id, 'member_name');
        if(empty($member_name)) {
            $manager_name = $obj->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $member_id, 'manager_name');
        }
                
        if(!empty($member_name)){
            $total_records_list= $obj->balance_report('member',$member_id);
        }
        else if(!empty($manager_name)) {
            $total_records_list= $obj->balance_report('manager',$member_id);
        }
    }
    else {
        $sales_list= $obj->balance_report("", "");
    }
    

    if(empty($member_id)) {
        require_once('../fpdf/fpdf.php');
        $pdf = new FPDF('P','mm','A4');
        $pdf->AliasNbPages(); 
        $pdf->AddPage();
        $pdf->SetAutoPageBreak(false);
        $pdf->SetTitle('Pending Report');
        $pdf->SetFont('Arial','B',10);
        // $pdf->SetY(7);
        $pdf->Cell(0,10,'Member Overall Pending - '.date('d-m-Y'),1,1,'C',0);
        $pdf->SetFont('Arial','B',9);

        $pdf->SetX(10);
        $pdf->Cell(15,10,'S.No.',1,0,'C',0);
        $pdf->SetX(25);
        $pdf->Cell(85,10,'Member Name',1,0,'C',0);
        $pdf->SetX(110);
        $pdf->Cell(45,10,'Credit',1,0,'C',0);
        $pdf->SetX(155);
        $pdf->Cell(45,10,'Debit',1,1,'C',0);
        $pdf->SetFont('Arial','',8);

        $index = 0;
        if(!empty($sales_list)) {
            
            $grand_pending = 0; $debit_amount =0; $debit_total =0; $debit_total_amount =0; $credit =0; $credit_amount =0; $credit_total =0; $credit_total_amount =0; $total = 0; $debit = 0; $grand_debit_total =0 ; $grand_credit_total =0; $sno = 1; $mobile_nmber = ""; 
            foreach($sales_list as $key => $data) {
                $credit_total = 0; $debit_total=0;
                // print_r($data);
                if($pdf->GetY()>250){
                    $pdf->AddPage();
                    $pdf->SetFont('Arial','B',10);
                    $pdf->SetY(7);
                    $pdf->Cell(0,10,'Pending Report',0,1,'C',0);
                    $pdf->SetFont('Arial','B',9);

                    $pdf->SetX(10);
                    $pdf->Cell(15,10,'S.No.',1,0,'C',0);
                    $pdf->SetX(25);
                    $pdf->Cell(85,10,'Member Name',1,0,'C',0);
                    $pdf->SetX(110);
                    $pdf->Cell(45,10,'Credit',1,0,'C',0);
                    $pdf->SetX(155);
                    $pdf->Cell(45,10,'Debit',1,1,'C',0);
                    $pdf->SetFont('Arial','',8);

                }
                if($data['credit'] != "" || $data['debit'] != ""){
                    $index = $key + 1;  
                    $name = ""; $pending = 0; $index = $key + 1;

                    $z = $pdf->GetY();
                    $pdf->SetX(10);
                    $pdf->Cell(15,10,$sno,0,0,'C',0);
                    $member_name = "";
                    if(!empty($data['party_name'])) {
                        $member_name = $obj->encode_decode('decrypt', $data['party_name']);
                    }  
                    if(!empty($data['party_mobile_number'])) {
                        $mobile_nmber = "(".$obj->encode_decode('decrypt',$data['party_mobile_number']).")"; 
                    }             

                    $pdf->SetX(25);
                    $pdf->Cell(85,10,$member_name. " " .$mobile_nmber,0,0,'L',0); 
                    
                    if(!empty($data['credit'])) {
                        $credit_total = $credit_total + $data['credit'];
                        $credit = $credit + $credit_total;
                    }
                    
                    if(!empty($data['debit'])) {
                        $debit_total = $debit_total + $data['debit'];
                        $debit = $debit + $debit_total;
                    }
                    if($credit_total > $debit_total)
                    {
                        $total_amount = $debit_total - $credit_total;
                    }   
                    else{
                        $total_amount = $credit_total - $debit_total;
                    }
                    if($credit_total > $debit_total) { 
                        $total_amount = $credit_total  - $debit_total; 
                        $pdf->SetX(105);
                        $pdf->Cell(45,10,number_format(($total_amount),2),0,0,'C',0);
                        $pdf->SetX(155);
                        $pdf->Cell(45,10,'-',0,0,'C',0);
                        $credit_total_amount = $credit_total_amount + $total_amount; 
                    }
                    if($debit_total > $credit_total){ 
                        $total_amount = $debit_total - $credit_total;
                        $pdf->SetX(105);
                        $pdf->Cell(45,10,'-',0,0,'C',0);
                        $pdf->SetX(155);
                        $pdf->Cell(45,10,number_format(($total_amount),2),0,0,'C',0);
                        $debit_total_amount = $debit_total_amount + $total_amount;
                    }
                    $pdf->SetY($z);
                    $pdf->SetX(10);
                    $pdf->Cell(15,10,'',1,0,'C',0);
                    $pdf->SetX(25);
                    $pdf->Cell(85,10,'',1,0,'C',0);
                    $pdf->SetX(110);
                    $pdf->Cell(45,10,'',1,0,'C',0);
                    $pdf->SetX(155);
                    $pdf->Cell(45,10,'',1,1,'C',0);
                    $sno++;
                }
            }
            $pdf->SetX(10);
            $pdf->SetFont('Arial','B',9);
            $pdf->Cell(100,10,'Sub Total',1,0,'R',0);
            // $pdf->Cell(100,10,'',1,0,'R',0);
            if(!empty($credit_total_amount)) {
                // if($credit_total_amount > $debit_total_amount) {
                    $pdf->SetX(110);
                    $pdf->Cell(45,10,(number_format(($credit_total_amount),2)),1,0,'R',0);
                    // $pdf->SetX(155);
                    // $pdf->Cell(45,10,'',1,1,'R',0);
                // }
                // if($debit_total_amount > $credit_total_amount) {
            }
            else {
                $pdf->SetX(110);
                    $pdf->Cell(45,10,'0.00',1,0,'R',0);
            }
             if(!empty($debit_total_amount)) {
                    // $pdf->Cell(45,10,'',1,0,'R',0);
                    $pdf->SetX(155);
                    $pdf->Cell(45,10,(number_format(($debit_total_amount),2)),1,1,'R',0);
                // }
            }
            else {
                $pdf->SetX(155);
                $pdf->Cell(45,10,'0.00',1,1,'R',0);
            }
            $pdf->SetX(10);
            $pdf->Cell(100,10,'Total',1,0,'R',0);
            $pdf->SetX(110);
            if(!empty($credit_total_amount) || (!empty($debit_total_amount))) {
                if($credit_total_amount > $debit_total_amount) {
                    $pdf->Cell(45,10,number_format(($credit_total_amount-$debit_total_amount),2),1,0,'R',0);
                    $pdf->SetX(155);
                    $pdf->Cell(45,10,'',1,1,'R',0);
                }
                if($debit_total_amount > $credit_total_amount) {
                    $pdf->Cell(45,10,'',1,0,'R',0);
                    $pdf->SetX(155);
                    $pdf->Cell(45,10,number_format(($debit_total_amount-$credit_total_amount),2),1,1,'R',0);
                }
            }
                       
        }
    }
    else{
        require_once('../fpdf/fpdf.php');
        $pdf = new FPDF('P','mm','A4');
        $pdf->AliasNbPages(); 
        $pdf->AddPage();
        $pdf->SetAutoPageBreak(false);
        $pdf->SetTitle('Pending Report');
        $pdf->SetFont('Arial','B',10);

        $sy = $pdf->GetY();
        $pdf->Cell(0,10,'Member Overall Pending - '.date('d-m-Y'),0,1,'C',0);
        $member_name = "";
        if(!empty($member_id)) {
            if(!empty($member_id)) {
                $member_name = $obj->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $member_id, 'member_name');
                if(empty($member_name)) {
                    $member_name = $obj->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $member_id, 'manager_name');
                }
                if(!empty($member_name)) { 
                    $member_name = $obj->encode_decode('decrypt', $member_name);
                }            
            }
            if(!empty($member_name)) { 
                $pdf->SetX(10);
                $pdf->Cell(0,5,$member_name,0,1,'C',0); 
            }             
        }
        $ey = $pdf->GetY();
        $pdf->SetY($sy);
        $pdf->Cell(0,$ey-$sy,'',1,1,'L',0);
        $pdf->SetFont('Arial','B',9);

        $pdf->SetX(10);
        $pdf->Cell(15,10,'S.No.',1,0,'C',0);
        $pdf->SetX(25);
        $pdf->Cell(25,10,'Date',1,0,'C',0);
        $pdf->SetX(50);
        $pdf->Cell(40,10,'Bill Number',1,0,'C',0);
        $pdf->SetX(90);
        $pdf->Cell(40,10,'Type',1,0,'C',0);
        $pdf->SetX(130);
        $pdf->Cell(35,10,'Credit',1,0,'C',0);
        $pdf->SetX(165);
        $pdf->Cell(35,10,'Debit',1,1,'C',0);
        $pdf->SetFont('Arial','',8);

        $index = 0;
        if(!empty($total_records_list)) {
            $credit_amount = 0; $debit_amount = 0;
                foreach($total_records_list as $key => $val) {
                    if($pdf->GetY()>250) {
                        $pdf->AddPage();
                        $pdf->SetFont('Arial','B',10);
                        $pdf->SetY(7);
                        $pdf->Cell(0,10,'Pending Report',0,1,'C',0);
                        $pdf->SetFont('Arial','B',9);    
                        $pdf->SetX(10);
                        $pdf->Cell(15,10,'S.No.',1,0,'C',0);
                        $pdf->SetX(25);
                        $pdf->Cell(25,10,'Date',1,0,'C',0);
                        $pdf->SetX(50);
                        $pdf->Cell(40,10,'Bill Number',1,0,'C',0);
                        $pdf->SetX(90);
                        $pdf->Cell(40,10,'Type',1,0,'C',0);
                        $pdf->SetX(130);
                        $pdf->Cell(35,10,'Credit',1,0,'C',0);
                        $pdf->SetX(165);
                        $pdf->Cell(35,10,'Debit',1,1,'C',0);
                        $pdf->SetFont('Arial','',8);                       
                    }
                    if(!empty($val['opening_balance']) && !empty($val['opening_balance_type'])) {
                        $pdf->Cell(120,10,'Opening Balance',1,0,'R',0);

                        if($val['opening_balance_type'] == 1) { 
                            $pdf->Cell(35,10,$val['opening_balance'],1,0,'C',0); 
                            $pdf->Cell(35,10,'',1,1,'C',0);
                            $credit_amount += $val['opening_balance'];
                        }
                        if($val['opening_balance_type'] == 2) { 
                            $pdf->Cell(35,10,'',1,0,'C',0);
                           $pdf->Cell(35,10,$val['opening_balance'],1,1,'C',0);  
                            $debit_amount += $val['opening_balance'];
                        }
                    }   
                    if(!empty($val['bill_list'])) {
                        foreach($val['bill_list'] as $key => $data) {
                            $index = $key + 1;
                            // $index = $key + 1;
                            
                            $pdf->SetX(10);
                            $pdf->Cell(15,10,$index,0,0,'C',0);
                            $pdf->SetX(25);
                            if(!empty($data['bill_date']))
                            {
                                $pdf->SetX(25);
                                $pdf->Cell(25,10,date('d-m-Y',strtotime($data['bill_date'])),0,0,'C',0);

                            }
                            
                            if(!empty($data['bill_number'])) {
                                $data['bill_number'] = $obj->encode_decode('decrypt', $data['bill_number']);
                                $pdf->SetX(50);
                                $pdf->Cell(40,10,$data['bill_number'],0,0,'C',0);
                            }
                            if(!empty($data['bill_type'])) {
                                $pdf->SetX(90);
                                $pdf->Cell(40,10,$data['bill_type'],0,0,'C',0);
                            }
                            if(!empty($data['credit']))
                            {
                                $credit_amount+=$data['credit']; 
                                $pdf->SetX(130);
                                $pdf->Cell(35,10,number_format($data['credit'],2),0,0,'C',0);
                                
                            } 
                                
                            if(!empty($data['debit']))
                            {
                                $debit_amount+=$data['debit']; 
                                $pdf->SetX(165);
                                $pdf->Cell(35,10,number_format($data['debit'],2),0,0,'C',0);
                                
                            }
                            else {
                                if(!empty($member_id)) {
                                    $plan_id = $obj->getTableColumnValue($GLOBALS['member_table'], 'member_unique_id', $member_id, 'plan_id');  
                                    if(empty($plan_id)) {
                                        $plan_id = $obj->getTableColumnValue($GLOBALS['manager_table'], 'manager_unique_id', $member_id, 'plan_id'); 
                                    }
                                    $plan_value = $obj->getTableColumnValue($GLOBALS['plan_table'], 'plan_id', $plan_id, 'plan_value'); 
                                } 
                            }

                                $pdf->SetX(10);
                                $pdf->Cell(15,10,'',1,0,'C',0);
                                $pdf->SetX(25);
                                $pdf->Cell(25,10,'',1,0,'C',0);
                                $pdf->SetX(50);
                                $pdf->Cell(40,10,'',1,0,'C',0);
                                $pdf->SetX(90);
                                $pdf->Cell(40,10,'',1,0,'C',0);
                                $pdf->SetX(130);
                                $pdf->Cell(35,10,'',1,0,'C',0);
                                $pdf->SetX(165);
                                $pdf->Cell(35,10,'',1,1,'C',0);
                             
                        }
                    } 
                }
                $display_status ="";
                if(!empty($credit_amount) && (!empty($debit_amount))) { 
                    if($credit_amount < $debit_amount)
                    {
                        $display_status="Balance";
                    }   
                    else {
                        $display_status ="";
                    }
                }
                else {
                    if($credit_amount < $plan_value)
                    {
                        $display_status="Balance";
                    }   
                    else {
                        $display_status ="";
                    }
                }
                $pdf->SetX(10);
                $pdf->Cell(120,10,'Total',1,0,'R',0);
                if(!empty($credit_amount)){ 
                    $pdf->SetX(130);
                    $pdf->Cell(35,10,$credit_amount,0,0,'R',0);
                    // $pdf->SetX(165);
                    
                } 
                if(!empty($debit_amount)){ 
                    // $pdf->SetX(130);
                    $pdf->SetX(165);
                    $pdf->Cell(35,10,$debit_amount,0,0,'R',0);
                }
                $pdf->SetX(130);
                $pdf->Cell(35,10,'',1,0,'R',0);
                $pdf->SetX(165);
                $pdf->Cell(35,10,'',1,1,'R',0);

                if(!empty($display_status)) { 
                    $pdf->SetX(10);
                    $pdf->Cell(120,10,$display_status,1,0,'C',0);
                    if(!empty($debit_amount)) { 
                        if($credit_amount > $debit_amount) { 
                            $pdf->SetX(130);
                            $pdf->Cell(35,10,number_format(($credit_amount  -$debit_amount),2),1,0,'R',0); 
                            $pdf->SetX(165);
                            $pdf->Cell(35,10,'',1,0,'R',0);
                        } 
                    }
                    if(!empty($debit_amount)) { 
                        if($debit_amount > $credit_amount) { 
                            $pdf->SetX(130);
                            $pdf->Cell(35,10,'',1,0,'R',0); 
                            $pdf->SetX(165);
                            $pdf->Cell(35,10,number_format(($debit_amount - $credit_amount),2),1,1,'R',0);
                        }
                    } else {
                        if($plan_value > $credit_amount) { 
                            $pdf->SetX(130);
                            $pdf->Cell(35,10,'',1,0,'R',0); 
                            $pdf->SetX(165);
                            $pdf->Cell(35,10,number_format(($plan_value - $credit_amount),2),1,1,'R',0);
                        }
                    }
                }
        }

    }


    $pdf->OutPut();

?>

