<?php
	include("include.php");
	
	if(isset($_POST['page_number'])) {
		$page_number = $_POST['page_number'];
		$page_limit = $_POST['page_limit'];
		$page_title = $_POST['page_title'];

		$search_text = "";
		if(isset($_POST['search_text'])) {
			$search_text = $_POST['search_text'];
		}

		$filter_from_date = "";
		if(isset($_POST['filter_from_date'])) {
			$filter_from_date = $_POST['filter_from_date'];
		}

		$filter_to_date = "";
		if(isset($_POST['filter_to_date'])) {
			$filter_to_date = $_POST['filter_to_date'];
		}

		$filter_state = "";
		if(isset($_POST['filter_state'])) {
			$filter_state = $_POST['filter_state'];
			if(!empty($filter_state)) {
				$filter_state = $obj->encode_decode('encrypt', $filter_state);
			}
		}

		$filter_city = "";
		if(isset($_POST['filter_city'])) {
			$filter_city = $_POST['filter_city'];
			if(!empty($filter_city)) {
				$filter_city = $obj->encode_decode('encrypt', $filter_city);
			}
		}

		$filter_agent_id = "";
		if(isset($_POST['filter_agent_id'])) {
			$filter_agent_id = $_POST['filter_agent_id'];
		}

		$filter_customer_id = "";
		if(isset($_POST['filter_customer_id'])) {
			$filter_customer_id = $_POST['filter_customer_id'];
		}

		$filter_chit_id = "";
		if(isset($_POST['filter_chit_id'])) {
			$filter_chit_id = $_POST['filter_chit_id'];
		}

		$filter_order_status = "";
		if(isset($_POST['filter_order_status'])) {
			$filter_order_status = $_POST['filter_order_status'];
		}

		$total_records_list = array();
		$total_records_list = $obj->getCustomerOrderListByFilter($filter_from_date, $filter_to_date, $filter_state, $filter_city, $filter_agent_id, $filter_customer_id, $filter_chit_id, $filter_order_status);

        if(!empty($search_text)) {
			$search_text = strtolower($search_text);
			$list = array();
			if(!empty($total_records_list)) {
				foreach($total_records_list as $val) {
					if( (strpos(strtolower($obj->encode_decode('decrypt', $val['order_number'])), $search_text) !== false)) {
						$list[] = $val;
					}
				}
			}
			$total_records_list = $list;
		}
		
		$total_pages = 0;
		if(!empty($total_records_list)) {
			$total_pages = count($total_records_list);
		}
		
		$page_start = 0; $page_end = 0;
		if(!empty($page_number) && !empty($page_limit) && !empty($total_pages)) {
			if($total_pages > $page_limit) {
				if($page_number) {
					$page_start = ($page_number - 1) * $page_limit;
					$page_end = $page_start + $page_limit;
				}
			}
			else {
				$page_start = 0;
				$page_end = $page_limit;
			}
		}

		$show_records_list = array();
        if(!empty($total_records_list)) {
            $show_records_list = array_slice($total_records_list, $page_start, $page_limit);
        }
?>
        
		<?php if($total_pages > $page_limit) { ?>
			<div class="pagination_cover mt-3"> 
				<?php
					include("pagination.php");
				?> 
			</div> 
		<?php } ?>

		<table class="table nowrap">
			<thead class="thead-dark">
                <tr>
					<th class="text-center px-2 py-2" style="width: 75px;">S.No</th>
                    <th class="text-center px-2 py-2" style="width: 125px;">Order Date</th>
                    <th class="text-center px-2 py-2" style="width: 200px;">Order ID</th>
                    <th class="text-center px-2 py-2">Customer Details</th>
					<th class="text-center px-2 py-2" style="width: 300px;">Chit Details</th>
					<th class="text-center px-2 py-2" style="width: 150px;">Total Amount</th>
                    <th class="text-center px-2 py-2" style="width: 100px;">Action</th>
                </tr>
            </thead>
            <tbody>
			<?php
				if(!empty($show_records_list)) {
					foreach($show_records_list as $key => $data) {
						$index = $key + 1;
						if(!empty($page_number) && $page_number > 1) {
							$prefix = 0;
							$prefix = ($page_number * $page_limit) - $page_limit;
							if(!empty($prefix)) {
								$index = $prefix + $index;
							}
						}
			?>
						<tr>
							<td class="text-center px-2 py-2" style="width: 75px;"><?php echo $index; ?></td>
								<td class="text-center px-2 py-2">
									<?php if(!empty($data['order_date']) && $data['order_date'] != "0000-00-00") { echo date("d-m-Y", strtotime($data['order_date'])); } ?>
								</td>
								<td id="order_number_<?php if(!empty($data['order_id'])) { echo $data['order_id']; } ?>" class="text-center px-2 py-2">
									<?php
										if(!empty($data['order_number'])) {
											$data['order_number'] = $obj->encode_decode('decrypt', $data['order_number']);
											echo $data['order_number'];
										}
									?>
									<?php if(!empty($data['new_order']) && $data['new_order'] == 1) { ?>
										<br> <span class="badge badge-danger">New</span>
									<?php } ?>
								</td>
								<td class="px-2 py-2">
									<div class="w-100">
										<?php
											if(!empty($data['customer_name'])) {
												$data['customer_name'] = $obj->encode_decode('decrypt', $data['customer_name']);
												echo $data['customer_name'];
												if(!empty($data['customer_mobile_number'])) {
													$data['customer_mobile_number'] = $obj->encode_decode('decrypt', $data['customer_mobile_number']);
													echo " (".$data['customer_mobile_number'].")";
												}
											}
										?>
									</div>
									
									<?php
										if(!empty($data['creator_name'])) {
											$data['creator_name'] = $obj->encode_decode('decrypt', $data['creator_name']);
									?>
											<small><?php echo "Last Opened : ".$data['creator_name']; ?></small>
									<?php		
										}
									?>
								</td>
								<td class="text-center px-2 py-2">
									<?php
										if(!empty($data['customer_chit_details']) && $data['customer_chit_details'] != $GLOBALS['null_value']) {
											$data['customer_chit_details'] = $obj->encode_decode('decrypt', $data['customer_chit_details']);
											echo $data['customer_chit_details'];
										}
									?>
								</td>
                                <td class="text-center px-2 py-2">
									<?php
										if(!empty($data['total_amount'])) {
                                            $data['total_amount'] = $obj->truncate_number($data['total_amount'], 2);
											echo $data['total_amount'];
										}
									?>
								</td>
								<td class="text-center px-2 py-2">
									<div class="dropdown">
										<a class="btn btn-dark poppins px-3" href="#" role="button" data-toggle="dropdown">
											<i class="fa fa-ellipsis-v text-white"></i>
										</a>
										<div class="dropdown-menu dropdown-menu-right dropdown-menu-icon-list">
											<a class="dropdown-item" href="orders_view.php?view_order_id=<?php if(!empty($data['order_id'])) { echo $data['order_id']; } ?>"><i class="fa fa-file"></i> &ensp; View</a>

											<?php if(!empty($data['confirmed']) && empty($data['despatched'])) { ?>
												<a class="dropdown-item" href="orders_despatch.php?view_order_id=<?php if(!empty($data['order_id'])) { echo $data['order_id']; } ?>"><i class="fa fa-truck"></i> &ensp; Despatch</a>
											<?php } ?>

											<?php if(empty($data['confirmed'])) { ?>
											<a class="dropdown-item" href="Javascript:CheckConfirmOrder('<?php if(!empty($data['order_id'])) { echo $data['order_id']; } ?>');"><i class="fa fa-check"></i> &ensp; Confirm</a>
                                            <a class="dropdown-item" href="Javascript:DeleteModalContent('<?php if(!empty($page_title)) { echo $page_title; } ?>', '<?php if(!empty($data['order_id'])) { echo $data['order_id']; } ?>');"><i class="fa fa-trash"></i> &ensp; Delete</a>
											<?php } ?>
										</div>
									</div>
								</td>
							</tr>
                <?php
                        }
                    }
                    else {
                ?>
                        <tr>
                            <td colspan="6" class="text-center">Sorry! No records found</td>
                        </tr>
                <?php } ?>
            </tbody>
        </table>
<?php	
	}

    if(isset($_REQUEST['confirm_order_id'])) {
		$confirm_order_id = $_REQUEST['confirm_order_id'];
        $confirm_order_id = trim($confirm_order_id);
        $msg = "";
        if(!empty($confirm_order_id)) {
            $orders_unique_id = "";
            $orders_unique_id = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $confirm_order_id, 'id');
            if(preg_match("/^\d+$/", $orders_unique_id)) {
				$order_amount = 0;
				$order_amount = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $confirm_order_id, 'total_amount');

				$order_agent_id = 0;
				$order_agent_id = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $confirm_order_id, 'agent_id');
				$order_customer_id = 0;
				$order_customer_id = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $confirm_order_id, 'customer_id');

				if(!empty($order_amount)) {
					$packing_charges_option = 0; $packing_charges = 0;

					$packing_charges_option = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $confirm_order_id, 'packing_charges_option');
					$packing_charges = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $confirm_order_id, 'packing_charges');
					if(!empty($packing_charges_option) && $packing_charges_option == 2) {
						if(!empty($packing_charges) && !empty($order_amount)) {
							$order_amount = $order_amount - $packing_charges;
						}
					}
				}

				$order_agent_ids = array(); $order_customer_ids = array(); $wallet_amount = 0; $balance_amount = $order_amount;

				$chit_wallet_use = array();
				$customer_chit_ids = 0;
				$customer_chit_ids = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $confirm_order_id, 'customer_chit_ids');
				if(!empty($customer_chit_ids)) {
					$chit_wallet_use = explode(",", $customer_chit_ids);
				}
				/*if(isset($_POST['chit_wallet_use'])) {
					$chit_wallet_use = $_POST['chit_wallet_use'];
				}*/

				$chit_error = ""; $show_chit = 0; $order_chit_ids = array(); $order_chit_amounts = array();
				if(!empty($chit_wallet_use)) {
					foreach($chit_wallet_use as $customer_chit_id) {
						if(!empty($customer_chit_id)) {
							$customer_chit_unique_id = "";
							$customer_chit_unique_id = $obj->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $customer_chit_id, 'id');
							if(preg_match("/^\d+$/", $customer_chit_unique_id)) {
								$show_chit = 1;

								$chit_agent_id = ""; $chit_customer_id = "";
								$chit_agent_id = $obj->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $customer_chit_id, 'agent_id');
								$chit_customer_id = $obj->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $customer_chit_id, 'customer_id');

								if(!empty($chit_agent_id)) {
									$order_agent_ids[] = $chit_agent_id;
								}
								if(!empty($chit_customer_id)) {
									$order_customer_ids[] = $chit_customer_id;
								}
								$order_chit_ids[] = $customer_chit_id;

								$chit_wallet_amount = 0;
								$chit_wallet_amount = $obj->getChitAmountToUseOrder($order_agent_id, $order_customer_id, $chit_agent_id, $chit_customer_id, $customer_chit_id);								

								if(empty($chit_wallet_amount)) {
									$account_merger_id = "";
									$account_merger_id = $obj->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $customer_chit_id, 'account_merger_id');
									if(!empty($account_merger_id)) {
										$customer_unique_id = "";
										$customer_unique_id = $obj->getTableColumnValue($GLOBALS['customer_table'], 'customer_id', $account_merger_id, 'id');
										if(preg_match("/^\d+$/", $customer_unique_id)) {
											$chit_wallet_amount = $obj->getTableColumnValue($GLOBALS['customer_table'], 'customer_id', $account_merger_id, 'merge_wallet');
										}
										else {
											$agent_unique_id = "";
											$agent_unique_id = $obj->getTableColumnValue($GLOBALS['agent_table'], 'agent_id', $account_merger_id, 'id');
											if(preg_match("/^\d+$/", $agent_unique_id)) {
												$chit_wallet_amount = $obj->getTableColumnValue($GLOBALS['agent_table'], 'agent_id', $account_merger_id, 'merge_wallet');
											}
										}
									}
								}

								//echo "balance_amount - ".$balance_amount.", chit_wallet_amount - ".$chit_wallet_amount."<br>";

								if(!empty($chit_wallet_amount) && !empty($balance_amount)) {
									if($chit_wallet_amount > $balance_amount) {
										$order_chit_amounts[] = $balance_amount;
										$balance_amount = 0;
									}
									else {
										$order_chit_amounts[] = $chit_wallet_amount;
										$balance_amount = $balance_amount - $chit_wallet_amount;
									}
								}

							}
							else {
								$chit_error = "Invalid Chit";
							}
						}
						else {
							$chit_error = "Empty Chit";
						}
					}
				}

				//echo "order_amount - ".$order_amount.", wallet_amount - ".$wallet_amount.", balance_amount - ".$balance_amount."<br>"; 
				//print_r($order_chit_amounts); exit;

				if(empty($chit_error)) {
					$check_user_id_ip_address = "";
					$check_user_id_ip_address = $obj->check_user_id_ip_address();	
					if(preg_match("/^\d+$/", $check_user_id_ip_address)) {

						$created_date_time = $GLOBALS['create_date_time_label']; $creator = $GLOBALS['creator'];
						$creator_name = $obj->encode_decode('encrypt', $GLOBALS['user_name']);

						if(!empty($confirm_order_id) && !empty($order_agent_ids) && !empty($order_customer_ids) && !empty($order_chit_ids) && !empty($order_chit_amounts)) {
							$success = 0; $chit_amount = 0;
							for($c = 0; $c < count($order_chit_ids); $c++) {
								$agent_id = ""; $customer_id = ""; $chit_id = ""; $amount = 0;
								$agent_id = $order_agent_ids[$c];
								$customer_id = $order_customer_ids[$c];
								$chit_id = $order_chit_ids[$c];
								$amount = $order_chit_amounts[$c];

								if(!empty($agent_id) && !empty($customer_id) && !empty($chit_id) && !empty($amount)) {
									$chit_amount = $chit_amount + $amount;

									$columns = array('created_date_time', 'creator', 'creator_name', 'order_id', 'agent_id', 'customer_id', 'customer_chit_id', 'amount', 'deleted');
									$values = array("'".$created_date_time."'", "'".$creator."'", "'".$creator_name."'", "'".$confirm_order_id."'", "'".$agent_id."'", "'".$customer_id."'", "'".$chit_id."'", "'".$amount."'", "'0'");
									$insert_id = $obj->InsertSQL($GLOBALS['order_chit_table'], $columns, $values, '');						
									if(preg_match("/^\d+$/", $insert_id)) {
										$success++;
									}
								}
							}
							if(!empty($success) && $success == count($order_chit_ids)) {
								if(!empty($order_chit_ids)) {
									$order_chit_ids = implode(",", $order_chit_ids);
								}

								$order_number = "";
								$order_number = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $confirm_order_id, 'order_number');

								$action = "";
								if(!empty($order_number) ) {
									$action = "Order Confirmed. Order Number - ".$obj->encode_decode('decrypt', $order_number);
								}
							
								$columns = array(); $values = array();						
								$columns = array('new_order', 'confirmed');
								$values = array("'0'", "'1'");
								$msg = $obj->UpdateSQL($GLOBALS['order_table'], $orders_unique_id, $columns, $values, $action);
								if(preg_match("/^\d+$/", $orders_unique_id)) {
									if(!empty($order_agent_ids) && !empty($order_customer_ids)) {
										for($i = 0; $i < count($order_agent_ids); $i++) {
											$agent_id = "";
											if(!empty($order_agent_ids[$i])) {
												$agent_id = $order_agent_ids[$i];
											}
											$customer_id = "";
											if(!empty($order_customer_ids[$i])) {
												$customer_id = $order_customer_ids[$i];
											}

											if(!empty($order_customer_id) && $order_customer_id != $GLOBALS['null_value']) {
												if(!empty($customer_id) && $customer_id != $GLOBALS['null_value']) {
													$update_customer_wallet = 0;
													$update_customer_wallet = $obj->UpdateCustomerWallet($customer_id);
												}			
											}			
											else if(!empty($order_agent_id) && $order_agent_id != $GLOBALS['null_value']) {
												if(!empty($agent_id) && $agent_id != $GLOBALS['null_value']) {
													$update_agent_due_count_wallet = 0;
													$update_agent_due_count_wallet = $obj->UpdateAgentWallet($agent_id);
												}
											}
										}
									}
								}

							}
						}
						
					}
					else {
						$msg = "Invalid IP";
					}
				}
				else {
					$msg = $chit_error;
				}
                
            }
			else {
				$msg = "Invalid Order";
			}
        }
		else {
			$msg = "Empty Order";
		}
		echo $msg; exit;
    }   

	if(isset($_POST['despatch_date'])) {
		$despatch_date = ""; $despatch_date_error = ""; $despatch_order_id = ""; $despatch_order_id_error = ""; $lr_number = ""; $lr_number_error = "";
		$transport_name = ""; $transport_name_error = ""; $transfer_details = ""; $transfer_details_error = ""; $lr_number_image_name = array(); $lr_number_image = "";

		$valid_despatch = ""; $form_name = "order_despatch_form";

		$despatch_date = $_POST['despatch_date'];
		$despatch_date = trim($despatch_date);
		$despatch_date_error = $valid->valid_date($despatch_date, 'Despatch date', '1');
		if(!empty($despatch_date_error)) {
			$valid_despatch = $valid->error_display($form_name, "despatch_date", $despatch_date_error, 'text');
		}

		if(isset($_POST['despatch_order_id'])) {
			$despatch_order_id = $_POST['despatch_order_id'];
			$despatch_order_id = trim($despatch_order_id);
		}
		if(!empty($despatch_order_id)) {
			$order_unique_id = "";
			$order_unique_id = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $despatch_order_id, 'id');
			if(!preg_match("/^\d+$/", $order_unique_id)) {
				$despatch_order_id_error = "Invalid order";
			}
		}
		else {
			$despatch_order_id_error = "Order ID is missing";
		}

		$lr_number = $_POST['lr_number'];
		$lr_number = trim($lr_number);
		$lr_number_error = $valid->common_validation($lr_number, "LR number", "text");
		if(!empty($lr_number_error)) {
			if(!empty($valid_despatch)) {
				$valid_despatch = $valid_despatch." ".$valid->error_display($form_name, "lr_number", $lr_number_error, 'text');
			}
			else {
				$valid_despatch = $valid->error_display($form_name, "lr_number", $lr_number_error, 'text');
			}
		}

		$transport_name = $_POST['transport_name'];
		$transport_name = trim($transport_name);
		$transport_name_error = $valid->common_validation($transport_name, "Transport name", "text");
		if(!empty($transport_name_error)) {
			if(!empty($valid_despatch)) {
				$valid_despatch = $valid_despatch." ".$valid->error_display($form_name, "transport_name", $transport_name_error, 'text');
			}
			else {
				$valid_despatch = $valid->error_display($form_name, "transport_name", $transport_name_error, 'text');
			}
		}

		$transfer_details = $_POST['transfer_details'];
		$transfer_details = trim($transfer_details);
		$transfer_details_error = $valid->common_validation($transfer_details, "Transfer details", "text");
		if(!empty($transfer_details_error)) {
			if(!empty($valid_despatch)) {
				$valid_despatch = $valid_despatch." ".$valid->error_display($form_name, "transfer_details", $transfer_details_error, 'text');
			}
			else {
				$valid_despatch = $valid->error_display($form_name, "transfer_details", $transfer_details_error, 'text');
			}
		}

		if(isset($_POST['lr_number_image_name'])) {
            $lr_number_image_name = $_POST['lr_number_image_name'];	
        }

		$result = "";
		
		$result = "";
		
		if(empty($valid_despatch) && empty($despatch_order_id_error)) {
			$check_user_id_ip_address = "";
			$check_user_id_ip_address = $obj->check_user_id_ip_address();	
			if(preg_match("/^\d+$/", $check_user_id_ip_address)) {

				if(!empty($lr_number_image_name) && is_array($lr_number_image_name)) {
                    $lr_number_image = implode("$$$", $lr_number_image_name);
                }
                if(empty($lr_number_image)) {
                    $lr_number_image = $GLOBALS['null_value'];
                }

				if(!empty($despatch_date) && $despatch_date != "0000-00-00") {
					$despatch_date = date("Y-m-d", strtotime($despatch_date));
				}

				if(!empty($lr_number)) {
					$lr_number = $obj->encode_decode('encrypt', $lr_number);
				}
				if(!empty($transport_name)) {
					$transport_name = $obj->encode_decode('encrypt', $transport_name);
				}
				if(!empty($transfer_details)) {
					$transfer_details = $obj->encode_decode('encrypt', $transfer_details);
				}

				$created_date_time = $GLOBALS['create_date_time_label']; $creator = $GLOBALS['creator'];
				$creator_name = $obj->encode_decode('encrypt', $GLOBALS['user_name']);

				$action = "";
				if(!empty($lr_number)) {
					$action = "New Despatch Created. LR Number - ".$obj->encode_decode('decrypt', $lr_number);
				}

				$order_number = "";
				if(!empty($despatch_order_id)) {
					$order_number = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $despatch_order_id, 'order_number');
				}

				$send_delivery_sms = 0;

				$null_value = $GLOBALS['null_value'];
				$columns = array('created_date_time', 'creator', 'creator_name', 'order_number', 'despatch_date', 'lr_number', 'transport_name', 'transfer_details', 'lr_number_image', 'deleted');
				$values = array("'".$created_date_time."'", "'".$creator."'", "'".$creator_name."'", "'".$order_number."'", "'".$despatch_date."'", "'".$lr_number."'", "'".$transport_name."'", "'".$transfer_details."'", "'".$lr_number_image."'", "'0'");
				$insert_id = $obj->InsertSQL($GLOBALS['orders_despatch_table'], $columns, $values, $action);						
				if(preg_match("/^\d+$/", $insert_id)) {
					if(!empty($despatch_order_id)) {
						$order_unique_id = "";
						$order_unique_id = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $despatch_order_id, 'id');
						if(preg_match("/^\d+$/", $order_unique_id)) {
							$columns = array(); $values = array();						
							$columns = array('despatched');
							$values = array("'1'");
							$update_id = $obj->UpdateSQL($GLOBALS['order_table'], $order_unique_id, $columns, $values, '');
							if(preg_match("/^\d+$/", $update_id)) {
								$image_copy = 1; $send_delivery_sms = 1;
								$result = array('number' => '1', 'msg' => 'Despatch Successfully Created');					
							}
							else {
								$result = array('number' => '2', 'msg' => $update_id);
							}
						}
					}					
				}
				else {
					$result = array('number' => '2', 'msg' => $insert_id);
				}

				if(!empty($image_copy) && $image_copy == 1) {
					$target_dir = $obj->image_directory(); $temp_dir = $obj->temp_image_directory();
					if(!empty($lr_number_image)) {				
						if(file_exists($temp_dir.$lr_number_image)) {   
							copy($temp_dir.$lr_number_image, $target_dir.$lr_number_image);
						}
					}
					$obj->clear_temp_image_directory();
				}

				if(!empty($send_delivery_sms) && $send_delivery_sms == 1) {
					if(!empty($despatch_date) && !empty($order_number) && !empty($lr_number) && !empty($transport_name) && !empty($transfer_details)) {
						$order_date = "";
						$order_date = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_number', $order_number, 'order_date');
						if(!empty($order_date)) {
							$order_date = date("d-m-Y", strtotime($order_date));
						}

						$customer_mobile_number = "";
						$customer_mobile_number = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_number', $order_number, 'customer_mobile_number');
						if(!empty($customer_mobile_number)) {
							$customer_mobile_number = $obj->encode_decode('decrypt', $customer_mobile_number);
						}

						$despatch_date = date("d-m-Y", strtotime($despatch_date));
						$order_number = $obj->encode_decode('decrypt', $order_number);
						$lr_number = $obj->encode_decode('decrypt', $lr_number);
						$transport_name = $obj->encode_decode('decrypt', $transport_name);
						$transfer_details = $obj->encode_decode('decrypt', $transfer_details);

						$delivery_sms = "Your order number ".$order_number." dt ".$order_date." has been despatched today through ".$transport_name." by ".$transfer_details." bundles. LR Number : ".$lr_number.' - '.$despatch_date;
						
						$settings_list = array(); $delivery_sms_to_user = 2;
						$settings_list = $obj->getTableRecords($GLOBALS['settings_table'], '', '');
						if(!empty($settings_list)) {
							foreach($settings_list as $data) {
								if( (!empty($data['name']) && $data['name'] == "delivery_sms_to_user") && (!empty($data['value']) && $data['value'] != $GLOBALS['null_value']) ) {
									$delivery_sms_to_user = $data['value'];
								}
							}
						}
						if(!empty($customer_mobile_number) && !empty($delivery_sms) && (!empty($delivery_sms_to_user) && $delivery_sms_to_user == 1)){ 
							$sms_type = "delivery_sms_to_user"; $sms_count = 1; $action = $delivery_sms;
							$sms_updated_unique_id = "";
							$sms_updated_unique_id = $obj->UpdateSMSCount($sms_type, $sms_count, $action);
							if(preg_match("/^\d+$/", $sms_updated_unique_id)) {
								if(!empty($delivery_sms)){ 
									$sms_encrypted = $this->encode_decode('encrypt', $delivery_sms);
									$columns = array(); $values = array(); $insert_id = "";					
									$columns = array('send_date', 'sms_type', 'action', 'deleted');
									$values = array("'".date("Y-m-d")."'", "'".$sms_type."'", "'".$sms_encrypted."'", "'0'");
									$insert_id = $this->InsertSQL($GLOBALS['sms_histroy_table'], $columns, $values, "");
									if(preg_match("/^\d+$/", $insert_id)) {
										$sms_response = "";
										//$sms_response = $obj->send_mobile_details($customer_mobile_number, '131030', $delivery_sms);
									}
								}
							}
						}
					}
				}

			}
			else {
				$result = array('number' => '2', 'msg' => 'Invalid IP');
			}
		}
		else {
			if(!empty($valid_despatch)) {
				$result = array('number' => '3', 'msg' => $valid_despatch);
			}
			else if(!empty($despatch_order_id_error)) {
				$result = array('number' => '3', 'msg' => $despatch_order_id_error);
			}
		}
		
		if(!empty($result)) {
			$result = json_encode($result);
		}
		echo $result; exit;
	}


    if(isset($_REQUEST['delete_orders_id'])) {
		$delete_orders_id = $_REQUEST['delete_orders_id'];
		$msg = "";
		if(!empty($delete_orders_id)) {	
            $orders_unique_id = "";
            $orders_unique_id = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $delete_orders_id, 'id');
            if(preg_match("/^\d+$/", $orders_unique_id)) {
                $order_number = "";
                $order_number = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $delete_orders_id, 'order_number');

                $action = "";
                if(!empty($order_number) ) {
                    $action = "Order Deleted. Order Number - ".$obj->encode_decode('decrypt', $order_number);
                }
            
                $columns = array(); $values = array();						
                $columns = array('deleted');
                $values = array("'1'");
                $msg = $obj->UpdateSQL($GLOBALS['order_table'], $orders_unique_id, $columns, $values, $action);
            }
		}
		echo $msg;
		exit;	
	}
?>