<?php
	include("include.php");
	
	if(isset($_REQUEST['show_receipt_id'])) {
        $show_receipt_id = $_REQUEST['show_receipt_id'];

        $receipt_date = date("d-m-Y"); $agent_id = ""; $customer_id = ""; $customer_chit_id = ""; $amount = 0; $payment_mode = ""; $transaction_id = "";
		$transaction_screenshot = "";

        if(!empty($show_receipt_id)) {
            $receipt_list = array();
			$receipt_list = $obj->getTableRecords($GLOBALS['receipt_table'], 'receipt_id', $show_receipt_id);
            if(!empty($receipt_list)) {
                foreach($receipt_list as $data) {
					if(!empty($data['receipt_date']) && $data['receipt_date'] != "0000-00-00") {
						$receipt_date = date("d-m-Y", strtotime($data['receipt_date']));
					}
                    if(!empty($data['agent_id'])) {
                        $agent_id = $data['agent_id'];
					}
                    if(!empty($data['customer_id'])) {
                        $customer_id = $data['customer_id'];
					}
                    if(!empty($data['customer_chit_id'])) {
                        $customer_chit_id = $data['customer_chit_id'];
					}
					if(!empty($data['amount'])) {
                        $amount = $data['amount'];
					}
					if(!empty($data['penalty_amount'])) {
                        $amount = $amount + $data['penalty_amount'];
					}
					if(!empty($data['payment_mode'])) {
                        $payment_mode = $data['payment_mode'];
					}
					if(!empty($data['transaction_id']) && $data['transaction_id'] != $GLOBALS['null_value']) {
						$transaction_id = $obj->encode_decode('decrypt', $data['transaction_id']);
					}
					if(!empty($data['transaction_screenshot'])) {
                        $transaction_screenshot = $data['transaction_screenshot'];
					}
                }
            }
		}

		$customer_list = array(); $agent_list = array(); $chit_list = array();
		$customer_list = $obj->getTableRecords($GLOBALS['customer_table'], '', '');
		$agent_list = $obj->getTableRecords($GLOBALS['agent_table'], '', '');
		$chit_list = $obj->getTableRecords($GLOBALS['customer_chit_table'], '', '');

        $customer_payment_mode_list = array();
		$customer_payment_mode_list = $GLOBALS['payment_mode_list'];

		$target_dir = $obj->image_directory();
		if(!empty($target_dir)) {
			$target_dir = str_replace("include/", "../", $target_dir);
		}

		$due_amount = 0; $penalty_amount = 0; $add_due_without_penalty = 2;
		if(!empty($customer_chit_id) && !empty($show_receipt_id)) {
			$due_amount = $obj->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $customer_chit_id, 'due_amount');
            $penalty_amount = $obj->getPenaltyAmountByChit($customer_chit_id, $show_receipt_id);
			$add_due_without_penalty = $obj->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $customer_chit_id, 'add_due_without_penalty');
		}
?>
        <form class="py-4 poppins pd-20" name="receipt_form" method="POST">
            <div class="row">
                <input type="hidden" name="edit_id" value="<?php if(!empty($show_receipt_id)) { echo $show_receipt_id; } ?>">
                <div class="col-sm-3 col-xl-2">
					<div class="form-group">
						<label class="form-control-label">Receipt Date *</label>
						<div class="w-100">
							<input type="text" class="form-control date_field" name="receipt_date" value="<?php if(!empty($receipt_date)) { echo $receipt_date; } ?>">
						</div>
					</div>
				</div>
				<div class="col-sm-4 col-xl-5">
                    <div class="form-group">
                        <label class="form-control-label">Agent</label>
                        <div class="w-100">
                            <select name="agent_id" class="form-control" onChange="Javascript:getAgentCustomerChitList(this.value, '1');">
                                <option value="">Select</option>
                                <?php
									if(!empty($agent_list)) {
										foreach($agent_list as $data) {
											if(!empty($data['agent_id'])) {
								?>
												<option value="<?php echo $data['agent_id']; ?>" <?php if(!empty($agent_id) && $data['agent_id'] == $agent_id) { ?> selected="selected" <?php } ?> >
													<?php
														if(!empty($data['name'])) {
															$data['name'] = $obj->encode_decode('decrypt', $data['name']);
															echo $data['name'];
															if(!empty($data['mobile_number'])) {
																$data['mobile_number'] = $obj->encode_decode('decrypt', $data['mobile_number']);
																echo " (".$data['mobile_number'].")";
															}
														}
													?>
												</option>
								<?php
											}
										}
									}
								?>
                            </select>
                        </div>
                    </div>
				</div>
                <div class="col-sm-4 col-xl-5">
                    <div class="form-group">
                        <label class="form-control-label">Customer</label>
                        <div id="agent_customer_cover" class="w-100">
                            <select name="customer_id" class="form-control" onChange="Javascript:getChitListByCustomer(this.value);">
                                <option value="">Select</option>
                                <?php
									if(!empty($customer_list)) {
										foreach($customer_list as $data) {
											if(!empty($data['customer_id'])) {
								?>
												<option value="<?php echo $data['customer_id']; ?>" <?php if(!empty($customer_id) && $data['customer_id'] == $customer_id) { ?> selected="selected" <?php } ?> >
													<?php
														if(!empty($data['name'])) {
															$data['name'] = $obj->encode_decode('decrypt', $data['name']);
															echo $data['name'];
															if(!empty($data['mobile_number'])) {
																$data['mobile_number'] = $obj->encode_decode('decrypt', $data['mobile_number']);
																echo " (".$data['mobile_number'].")";
															}
														}
													?>
												</option>
								<?php
											}
										}
									}
								?>
                            </select>
                        </div>                        
                    </div>
				</div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label class="form-control-label">Chit</label>
                        <div id="chit_cover" class="w-100">
                            <select name="customer_chit_id" class="form-control" onChange="Javascript:getChitDueAmount(this.value);">
                                <option value="">Select</option>
                                <?php
                                    if(!empty($chit_list)) {
                                        foreach($chit_list as $data) {
                                            if(!empty($data['customer_chit_id'])) {
                                ?>
                                                <option value="<?php echo $data['customer_chit_id']; ?>" <?php if(!empty($customer_chit_id) && $data['customer_chit_id'] == $customer_chit_id) { ?> selected="selected" <?php } ?>>
                                                    <?php
                                                        if(!empty($data['customer_chit_unique_number'])) {
															$data['customer_chit_unique_number'] = $obj->encode_decode('decrypt', $data['customer_chit_unique_number']);
															echo $data['customer_chit_unique_number'];
															if(!empty($data['chit_details'])) {
																$data['chit_details'] = $obj->encode_decode('decrypt', $data['chit_details']);
																echo " - ".$data['chit_details'];
															}
														}
                                                    ?>
                                                </option>
                                <?php
                                            }
                                        }
                                    }
                                ?>
                            </select>
                        </div>
                        <div class="w-100 chit_due_amount_cover mt-2"></div>
                        <div class="w-100 chit_due_cover mt-2">
							<?php if(!empty($due_amount)) { ?>
							<div class="chit_infos">
								<?php if(!empty($due_amount)) { ?>
								Due Amount : <span class="due_amount"><?php echo $due_amount; ?></span>
								<?php } ?>
								<?php if(!empty($penalty_amount)) { ?>
								, Penalty Amount : <span class="penalty_amount"><?php echo $penalty_amount; ?></span>
								<?php } ?>
							</div>
							<?php } ?>
						</div>
                    </div>
				</div>
				<div class="col-sm-8">
					<div class="row">
						<div id="payment_option_cover" class="col-sm-4 <?php if(empty($penalty_amount)) { ?>d-none<?php } ?>">
							<div class="form-group">
								<labal class="form-control-label">Payment Options</labal>
                                <div class="form-check" onClick="Javascript:ChangePaymentOption(this);">
                                    <input class="form-check-input" type="radio" name="payment_option" id="amount_penalty" value="1" checked>
                                    <label class="form-check-label" for="amount_penalty">Amount with Penalty</label>
                                </div>
                                <div class="form-check" onClick="Javascript:ChangePaymentOption(this);">
                                    <input class="form-check-input" type="radio" name="payment_option" id="amount_only" value="2">
                                    <label class="form-check-label" for="amount_only">Amount Without Penalty</label>
                                </div>
							</div>
						</div>
						<div class="col-sm-4">
							<div class="form-group">
								<label class="form-control-label">Amount *</label>
								<div class="w-100">
									<input type="text" class="form-control" name="receipt_amount" value="<?php if(!empty($amount)) { echo $amount; } ?>">
								</div>
								<div class="w-100 last_paid_date_cover mt-2"></div>
								<div class="w-100 last_paid_amount_cover mt-2"></div>
							</div>
						</div>
						<div class="col-sm-4">
							<div class="form-group">
								<label class="form-control-label">Payment Mode *</label>
								<div class="w-100">
									<select name="payment_mode" class="form-control" style="width: 100%;" onChange="Javascript:getTransferDetails();">
										<option value="">Select</option>
										<?php
											if(!empty($customer_payment_mode_list)) {
												foreach($customer_payment_mode_list as $mode) {
													if(!empty($mode)) {
														$mode_encrypted = $obj->encode_decode('encrypt', $mode);
										?>
														<option value="<?php echo $mode_encrypted; ?>" <?php if(!empty($payment_mode) && $mode_encrypted == $payment_mode) { ?> selected="selected" <?php } ?> >
															<?php echo $mode; ?>
														</option>
										<?php
													}
												}
											}
										?>
									</select>
								</div>
							</div>
						</div>
					</div>
				</div>
				<?php
					$check_payment_mode = "";
					if(!empty($payment_mode)) {
						$check_payment_mode = $obj->encode_decode('decrypt', $payment_mode);
					}
				?>
				<div id="transaction_details" class="col-12 <?php if(empty($check_payment_mode) || (!empty($check_payment_mode) && $check_payment_mode == $GLOBALS['payment_mode_cash']) ) { ?> d-none <?php } ?>">
					<div class="row">
						<div class="col-sm-4">
							<div class="form-group">
								<label class="form-control-label">Transaction ID *</label>
								<div class="w-100">
									<input type="text" name="transaction_id" value="<?php if(!empty($transaction_id)) { echo $transaction_id; } ?>" class="form-control shadow-none">
								</div>
							</div>
						</div>
						<div class="col-sm-4">
							<div id="transaction_screenshot_cover" class="form-group">
								<h6 class="w-100 text-center">Screenshot Max.Upload Size - 2 MB</h6> 
								<div class="image-upload text-center">
									<label for="transaction_screenshot">   
										<div class="transaction_screenshot_list row">
											<div class="col-12">
												<div class="cover">
													<?php if(!empty($transaction_screenshot) && file_exists($target_dir.$transaction_screenshot)) { ?>
														<button type="button" onclick="Javascript:delete_upload_image_before_save(this, 'transaction_screenshot', '<?php if(!empty($transaction_screenshot)) { echo $transaction_screenshot; } ?>');" class="btn btn-danger"><i class="fa fa-close"></i></button>
														<img id="transaction_screenshot_preview" src="<?php echo $target_dir.$transaction_screenshot; ?>" style="max-width: 100%; max-height: 150px;" />
														<input type="hidden" name="transaction_screenshot_name[]" value="<?php if(!empty($transaction_screenshot)) { echo $transaction_screenshot; } ?>">
													<?php } else { ?>
														<img id="transaction_screenshot_preview" src="include/images/upload_image.png" style="max-width: 150px;" />
													<?php } ?>
												</div>
											</div>        
										</div>
										<input type="file" name="transaction_screenshot" id="transaction_screenshot" style="display: none;" accept="image/*" />
									</label>
								</div>
								
								<div class="transaction_screenshot_container" style="display: none;">
									<canvas id="transaction_screenshot_canvas"></canvas>
								</div>
							</div>
						</div>
					</div>
				</div>
                <div class="col-md-12 pt-3 text-center">
                    <button class="btn btn-primary btnwidth submit_button" type="button" onClick="Javascript:SaveModalContent(event, 'receipt_form', 'receipt_changes.php', 'receipt.php');">Save</button>
					&nbsp; <a href="receipt.php" class="btn btn-danger">Back</a>
                </div>
            </div>
            <script type="text/javascript" src="include/js/bootstrap-datepicker.min.js"></script>
            <script type="text/javascript">
                jQuery(document).ready(function(){
                    if(jQuery('.date_field').length > 0) {
                        jQuery('.date_field').datepicker({
                            format: "dd-mm-yyyy",
                            autoclose: true
                        });
                    }
                });    
            </script>
			<script type="text/javascript" src="include/js/image_upload.js"></script>
            <script type="text/javascript">
				jQuery(document).ready(function(){
					jQuery('form[name="receipt_form"]').find('select').select2();
				}); 
			</script>
        </form>
<?php        
    }

    if(isset($_POST['receipt_date'])) {	
		$receipt_date = ""; $receipt_date_error = ""; $agent_id = ""; $agent_id_error = ""; $customer_id = ""; $customer_id_error = ""; $customer_chit_id = "";
		$chit_id_error = ""; $chit_due_amount = 0; $allow_split_up_due_payment = 2; $accept_advance_amount = 2; $accept_previous_due = 2; $amount = 0;
		$penalty_amount = 0; $total_amount = 0; $split_up_amount = 2; $payment_option = 1; $payment_option_error = "";

		$valid_receipt = ""; $form_name = "receipt_form";
		
		if(isset($_POST['edit_id'])) {
			$edit_id = $_POST['edit_id'];
		}

		$receipt_date = $_POST['receipt_date'];
		$receipt_date = trim($receipt_date);
		$receipt_date_error = $valid->valid_date($receipt_date, 'Receipt date', '1');
		if(!empty($receipt_date_error)) {
			$valid_receipt = $valid->error_display($form_name, "receipt_date", $receipt_date_error, 'text');
		}

		if(isset($_POST['agent_id'])) {
			$agent_id = $_POST['agent_id'];
			$agent_id = trim($agent_id);
		}
		if(!empty($agent_id)) {
			$agent_unique_id = "";
			$agent_unique_id = $obj->getTableColumnValue($GLOBALS['agent_table'], 'agent_id', $agent_id, 'id');
			if(!preg_match("/^\d+$/", $agent_unique_id)) {
				$agent_id_error = "Invalid agent";
			}
		}
		if(!empty($agent_id_error)) {
			if(!empty($valid_receipt)) {
				$valid_receipt = $valid_receipt." ".$valid->error_display($form_name, "agent_id", $agent_id_error, 'select');
			}
			else {
				$valid_receipt = $valid->error_display($form_name, "agent_id", $agent_id_error, 'select');
			}
		}

		$customer_id = $_POST['customer_id'];
		$customer_id = trim($customer_id);
		if(!empty($customer_id)) {
			$customer_unique_id = "";
			$customer_unique_id = $obj->getTableColumnValue($GLOBALS['customer_table'], 'customer_id', $customer_id, 'id');
			if(!preg_match("/^\d+$/", $customer_unique_id)) {
				$customer_id_error = "Invalid customer";
			}
		}
        else {
			if(empty($agent_id) && empty($customer_id)) {
            	$customer_id_error = "Select the customer";
			}
        }
		if(!empty($customer_id_error)) {
			if(!empty($valid_receipt)) {
				$valid_receipt = $valid_receipt." ".$valid->error_display($form_name, "customer_id", $customer_id_error, 'select');
			}
			else {
				$valid_receipt = $valid->error_display($form_name, "customer_id", $customer_id_error, 'select');
			}
		}

		$start_date = ""; $end_date = "";
        $customer_chit_id = $_POST['customer_chit_id'];
		$customer_chit_id = trim($customer_chit_id);
		if(!empty($customer_chit_id)) {
			$chit_unique_id = "";
			$chit_unique_id = $obj->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $customer_chit_id, 'id');
			if(preg_match("/^\d+$/", $chit_unique_id)) {
				$due_amount = $obj->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $customer_chit_id, 'due_amount');
				$penalty_amount = $obj->getPenaltyAmountByChit($customer_chit_id, $edit_id);

				$allow_split_up_due_payment = $obj->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $customer_chit_id, 'allow_split_up_due_payment');
				$accept_advance_amount = $obj->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $customer_chit_id, 'accept_advance_amount');
				$accept_previous_due = $obj->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $customer_chit_id, 'accept_previous_due');

				$start_date = $obj->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $customer_chit_id, 'start_date');
				$end_date = $obj->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $customer_chit_id, 'end_date');
			}
			else {
				$chit_id_error = "Invalid chit";
			}
		}
        else {
            $chit_id_error = "Select the chit";
        }
		if(!empty($chit_id_error)) {
			if(!empty($valid_receipt)) {
				$valid_receipt = $valid_receipt." ".$valid->error_display($form_name, "customer_chit_id", $chit_id_error, 'select');
			}
			else {
				$valid_receipt = $valid->error_display($form_name, "customer_chit_id", $chit_id_error, 'select');
			}
		}

		$receipt_amount = 0; $receipt_amount_error = "";
		$receipt_amount = $_POST['receipt_amount'];
		$receipt_amount = trim($receipt_amount);
		$receipt_amount_error = $valid->valid_price($receipt_amount, 'Amount', '1');

		if(isset($_POST['payment_option'])) {
			$payment_option = $_POST['payment_option'];
			$payment_option = trim($payment_option);
		}
		if(!empty($payment_option)) {
			$payment_option_error = $valid->valid_number($payment_option, "Payment option", "1");
		}

		if(!empty($receipt_amount)) {
			if(!empty($payment_option) && $payment_option == 1) {
				if(!empty($penalty_amount)) {
					$amount = $receipt_amount - $penalty_amount;
				}
				else {
					$amount = $receipt_amount;
				}
			}
			else {
				$amount = $receipt_amount;
			}
		}
		$total_amount = $amount;
		if(!empty($penalty_amount) && (!empty($payment_option)) && $payment_option == 1) {
			$total_amount = $total_amount + $penalty_amount;
		}

		$customer_due_count = 0; $amount_error = "";
		if(!empty($total_amount) && !empty($amount) && !empty($due_amount)) {
			if($amount < $due_amount) {
				if(!empty($allow_split_up_due_payment) && $allow_split_up_due_payment == 1) {
					$split_up_amount = 1;
				}
				else {
					$amount_error = "Enter the due amount. Unable to split the amount";
				}
			}
			if($amount > $due_amount) {
				$current_due_by_chit = 0;
				$current_due_by_chit = $obj->getCurrentDueByChit($customer_chit_id);

				$current_due_by_customer = 0;
				$current_due_by_customer = $obj->getCurrentDueByUser($agent_id, $customer_id, $customer_chit_id, $edit_id);

				if(!empty($current_due_by_customer) && !empty($current_due_by_chit)) {
					if($current_due_by_customer < $current_due_by_chit) {
						if(!empty($accept_previous_due) && $accept_previous_due == 2) {
							$amount_error = "Enter the due amount. Unable to give the previous due amount";
						}
					}
					else {
						if(!empty($accept_advance_amount) && $accept_advance_amount == 2) {
							$amount_error = "Enter the due amount. Unable to give the advance due amount";
						}
					}
				}			
			}
			if(empty($amount_error)) {
				$reminder = 0;
				$reminder = $amount % $due_amount;
				if($reminder != 0) {
					$amount_error = "Amount is not match to multiple of chit due amount";
				}
				$customer_due_count = $amount / $due_amount;
			}
		}

		if(!empty($total_amount) && !empty($amount) && !empty($penalty_amount) && !empty($customer_chit_id) && empty($amount_error)) {
			$receipt_total_amount = 0;
			$receipt_total_amount = $amount;

			$prev_receipt_total_amount = 0;
			$prev_receipt_total_amount = $obj->getAgentCustomerReceiptTotalAmount($agent_id, $customer_id, $customer_chit_id);
			if(!empty($prev_receipt_total_amount)) {
				$receipt_total_amount = $receipt_total_amount + $prev_receipt_total_amount;
			}		
			if(!empty($receipt_total_amount)) {
				$payable_amount = 0;
				$payable_amount = $obj->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $customer_chit_id, 'payable_amount');
				if(!empty($payable_amount) && $payable_amount == $receipt_total_amount) {
					$currrent_receipt_total_amount = 0;
					$currrent_receipt_total_amount = $amount + $penalty_amount;
					if($currrent_receipt_total_amount != $total_amount) {
						$amount_error = "This is last due. Please give the total amount. (Amount + Penalty)";
					}
				}
			}	
		}

		if(!empty($receipt_amount_error)) {
			if(!empty($valid_receipt)) {
				$valid_receipt = $valid_receipt." ".$valid->error_display($form_name, "receipt_amount", $receipt_amount_error, 'text');
			}
			else {
				$valid_receipt = $valid->error_display($form_name, "receipt_amount", $receipt_amount_error, 'text');
			}
		}

		$payment_mode = $_POST['payment_mode'];
		$payment_mode = trim($payment_mode);
		if(!empty($payment_mode)) {
			$check_payment_mode = $obj->encode_decode('decrypt', $payment_mode);
			$customer_payment_mode_list = array();
			$customer_payment_mode_list = $GLOBALS['payment_mode_list'];
			if(!in_array($check_payment_mode, $customer_payment_mode_list)) {
				$payment_mode_error = "Invalid payment mode";
			}
		}
		else {
			$payment_mode_error = "Select the payment mode";
		}
		if(!empty($payment_mode_error)) {
			if(!empty($valid_receipt)) {
				$valid_receipt = $valid_receipt." ".$valid->error_display($form_name, "payment_mode", $payment_mode_error, 'select');
			}
			else {
				$valid_receipt = $valid->error_display($form_name, "payment_mode", $payment_mode_error, 'select');
			}
		}

		if(!empty($payment_mode)) {
			$check_payment_mode = $obj->encode_decode('decrypt', $payment_mode);
			if($check_payment_mode == $GLOBALS['payment_mode_google_pay'] || $check_payment_mode == $GLOBALS['payment_mode_phone_pe'] || $check_payment_mode == $GLOBALS['payment_mode_account_transfer']) {
				if(isset($_POST['transaction_id'])) {
					$transaction_id = $_POST['transaction_id'];
					$transaction_id = trim($transaction_id);
				}
				if(isset($_POST['transaction_screenshot_name'])) {
					$transaction_screenshot_name = $_POST['transaction_screenshot_name'];	
				}
				if(!empty($transaction_screenshot_name) && is_array($transaction_screenshot_name)) {
					$transaction_screenshot = implode("$$$", $transaction_screenshot_name);
				}
				
				if(empty($transaction_id) && empty($transaction_screenshot)) {
					$transaction_id_error = "Enter the transaction id OR Upload transaction screenshot";
				}
				else {
					if(!empty($transaction_id) && empty($transaction_id_error)) {
						$transaction_id_error = $valid->common_validation($transaction_id, "Transaction ID", "text");
					}
				}
				if(!empty($transaction_id_error)) {
					if(!empty($valid_receipt)) {
						$valid_receipt = $valid_receipt." ".$valid->error_display($form_name, "transaction_id", $transaction_id_error, 'text');
					}
					else {
						$valid_receipt = $valid->error_display($form_name, "transaction_id", $transaction_id_error, 'text');
					}
				}
			}
		}

		if(empty($transaction_id)) {
			$transaction_id = $GLOBALS['null_value'];
		}
		if(empty($transaction_screenshot)) {
			$transaction_screenshot = $GLOBALS['null_value'];
		}
		
		$result = "";
		
		if(empty($valid_receipt)) {
			$check_user_id_ip_address = "";
			$check_user_id_ip_address = $obj->check_user_id_ip_address();	
			if(preg_match("/^\d+$/", $check_user_id_ip_address)) {

				$later_due = 0;
				if(!empty($receipt_date) && $receipt_date != "0000-00-00") {
					$receipt_date = date("Y-m-d", strtotime($receipt_date));

					if(!empty($customer_chit_id)) {
						$next_due_date = "";
                        $next_due_date = $obj->getNextDueDateByChit($agent_id, $customer_id, $customer_chit_id);
						if(!empty($next_due_date) && $next_due_date != "0000-00-00") {
							$next_due_date = date("Y-m-d", strtotime($next_due_date));
							if(strtotime($receipt_date) > strtotime($next_due_date)) {
								$later_due = 1;
							}
						}	
					}
				}

				if(!empty($transaction_id) && $transaction_id != $GLOBALS['null_value']) {
					$transaction_id = $obj->encode_decode('encrypt', $transaction_id);
				}
				$image_copy = 0; $prev_transaction_screenshot = "";
                if(!empty($edit_id)) {		
					$prev_transaction_screenshot = $obj->getTableColumnValue($GLOBALS['receipt_table'], 'receipt_id', $edit_id, 'transaction_screenshot');
                }

                $agent_details = ""; $agent_unique_number = "";
                if(!empty($agent_id)) {
                    $agent_list = array();
                    $agent_list = $obj->getTableRecords($GLOBALS['agent_table'], 'agent_id', $agent_id);
                    if(!empty($agent_list)) {
                        foreach($agent_list as $data) {
                            if(!empty($data['name'])) {
                                $agent_details = $obj->encode_decode('decrypt', $data['name']);
								if(!empty($data['mobile_number'])) {
									$agent_details = $agent_details." (".$obj->encode_decode('decrypt', $data['mobile_number']).")";
								}
                            }
                        }
                    }
                    if(!empty($agent_details)) {
                        $agent_details = $obj->encode_decode('encrypt', $agent_details);
                    }
					$agent_unique_number = $obj->getTableColumnValue($GLOBALS['agent_table'], 'agent_id', $agent_id, 'agent_unique_number');
                }

				if(empty($agent_id)) {
					$agent_id = $GLOBALS['null_value'];
				}
				if(empty($agent_details)) {
					$agent_details = $GLOBALS['null_value'];
				}

                $customer_details = ""; $customer_unique_number = "";
                if(!empty($customer_id)) {
                    $customer_list = array();
					$customer_list = $obj->getTableRecords($GLOBALS['customer_table'], 'customer_id', $customer_id);
					if(!empty($customer_list)) {
						foreach($customer_list as $data) {
							if(!empty($data['name'])) {
								$customer_details = $obj->encode_decode('decrypt', $data['name']);
								if(!empty($data['mobile_number'])) {
									$customer_details = $customer_details." (".$obj->encode_decode('decrypt', $data['mobile_number']).")";
								}
							}
						}
					}
                    if(!empty($customer_details)) {
                        $customer_details = $obj->encode_decode('encrypt', $customer_details);
                    }
                    $customer_unique_number = $obj->getTableColumnValue($GLOBALS['customer_table'], 'customer_id', $customer_id, 'customer_unique_number');
                }

				if(empty($customer_id)) {
					$customer_id = $GLOBALS['null_value'];
				}
				if(empty($customer_details)) {
					$customer_details = $GLOBALS['null_value'];
				}

				$receipter_details = "";
				if(!empty($customer_id) && $customer_id != $GLOBALS['null_value']) {
					$customer_list = array();
					$customer_list = $obj->getTableRecords($GLOBALS['customer_table'], 'customer_id', $customer_id);
					if(!empty($customer_list)) {
						foreach($customer_list as $data) {
							if(!empty($data['name'])) {
								$receipter_details = $obj->encode_decode('decrypt', $data['name']);
								if(!empty($data['address'])) {
									$data['address'] = $obj->encode_decode('decrypt', $data['address']);
									$data['address'] = str_replace("$$$", "<br>", $data['address']);
									$receipter_details = $receipter_details."<br>".$data['address'];
								}
								if(!empty($data['city'])) {
									$receipter_details = $receipter_details."<br>".$obj->encode_decode('decrypt', $data['city']);
								}
								if(!empty($data['state'])) {
									$receipter_details = $receipter_details.", ".$obj->encode_decode('decrypt', $data['state']);
								}
							}
						}
					}
				}
				else if(!empty($agent_id) && $agent_id != $GLOBALS['null_value']) {
					$agent_list = array();
					$agent_list = $obj->getTableRecords($GLOBALS['agent_table'], 'agent_id', $agent_id);
					if(!empty($agent_list)) {
						foreach($agent_list as $data) {
							if(!empty($data['name'])) {
								$receipter_details = $obj->encode_decode('decrypt', $data['name']);
								if(!empty($data['address'])) {
									$data['address'] = $obj->encode_decode('decrypt', $data['address']);
									$data['address'] = str_replace("$$$", "<br>", $data['address']);
									$receipter_details = $receipter_details."<br>".$data['address'];
								}
								if(!empty($data['city'])) {
									$receipter_details = $receipter_details."<br>".$obj->encode_decode('decrypt', $data['city']);
								}
								if(!empty($data['state'])) {
									$receipter_details = $receipter_details.", ".$obj->encode_decode('decrypt', $data['state']);
								}
							}
						}
					}
				} 
				if(!empty($receipter_details)) {
					$receipter_details = $obj->encode_decode('encrypt', $receipter_details);
				}

                $customer_chit_details = ""; $customer_chit_unique_number = ""; $chit_details = "";
                if(!empty($customer_chit_id)) {
				    $customer_chit_unique_number = $obj->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $customer_chit_id, 'customer_chit_unique_number');
					$chit_details = $obj->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $customer_chit_id, 'chit_details');
					if(!empty($customer_chit_unique_number)) {
						$customer_chit_unique_number = $obj->encode_decode('decrypt', $customer_chit_unique_number);
						$customer_chit_details = $customer_chit_unique_number;
						if(!empty($chit_details)) {
							$chit_details = $obj->encode_decode('decrypt', $chit_details);
							$customer_chit_details = $customer_chit_details."<br>".$chit_details;
						}
					}
					if(!empty($customer_chit_details)) {
						$customer_chit_details = $obj->encode_decode('encrypt', $customer_chit_details);
					}
                }

				$created_date_time = $GLOBALS['create_date_time_label']; $creator = $GLOBALS['creator'];
				$creator_name = $obj->encode_decode('encrypt', $GLOBALS['user_name']);

                $last_record_id = 0;
                $last_record_id = $obj->getLastRecordIDFromTable($GLOBALS['receipt_table']);

				$agent_commission = 0; $agent_commission_value = 0;
				if(!empty($customer_chit_id) && !empty($agent_id) && $agent_id != $GLOBALS['null_value']) {
					$chit_ids = ""; $commission_values = "";
					$chit_ids = $obj->getTableColumnValue($GLOBALS['agent_table'], 'agent_id', $agent_id, 'chit_id');
					$commission_values = $obj->getTableColumnValue($GLOBALS['agent_table'], 'agent_id', $agent_id, 'commission');

					$parent_chit_id = "";
					$parent_chit_id = $obj->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $customer_chit_id, 'chit_id');

					if(!empty($chit_ids) && !empty($commission_values)) {
						$chit_ids = explode(",", $chit_ids);
						$commission_values = explode("$$$", $commission_values);
						for($c = 0; $c < count($chit_ids); $c++) {
							if(!empty($chit_ids[$c]) && $chit_ids[$c] == $parent_chit_id) {
								if(!empty($commission_values[$c])) {
									$agent_commission = $commission_values[$c];
								}
							}
						}
					}
				
					if(!empty($amount) && !empty($agent_commission)) {
						$agent_commission = str_replace("%", "", $agent_commission);
						$agent_commission_value = 0;
						$agent_commission_value = ($amount * $agent_commission) / 100;
						if(!empty($agent_commission_value)) {
							$agent_commission_value = number_format($agent_commission_value, 2);
							$agent_commission_value = str_replace(",", "", $agent_commission_value);
						}
					}
				}

				if(!empty($customer_id) && $customer_id == $GLOBALS['null_value']) {
					$agent_commission_value = 0;
				}

				$admin_approval = 1; $new_receipt_unique_number = "";
				
				if(empty($edit_id)) {	
					$null_value = $GLOBALS['null_value'];
					$columns = array('created_date_time', 'creator', 'creator_name', 'receipt_id', 'receipt_unique_number', 'receipt_date', 'agent_id', 'agent_details', 'agent_commission', 'customer_id', 'customer_details', 'receipter_details', 'customer_chit_id', 'customer_chit_details', 'chit_due_amount', 'chit_due_count', 'amount', 'penalty_amount', 'total_amount', 'split_up_amount', 'payment_mode', 'transaction_id', 'transaction_screenshot', 'admin_approval', 'later_due', 'deleted');
					$values = array("'".$created_date_time."'", "'".$creator."'", "'".$creator_name."'", "'".$null_value."'", "'".$null_value."'", "'".$receipt_date."'", "'".$agent_id."'", "'".$agent_details."'", "'".$agent_commission_value."'", "'".$customer_id."'", "'".$customer_details."'", "'".$receipter_details."'", "'".$customer_chit_id."'", "'".$customer_chit_details."'", "'".$customer_due_count."'", "'".$customer_due_count."'", "'".$amount."'", "'".$penalty_amount."'", "'".$total_amount."'", "'".$split_up_amount."'", "'".$payment_mode."'", "'".$transaction_id."'", "'".$transaction_screenshot."'", "'".$admin_approval."'", "'".$later_due."'", "'0'");
					$insert_id = $obj->InsertSQL($GLOBALS['receipt_table'], $columns, $values, '');						
					if(preg_match("/^\d+$/", $insert_id)) {

						$receipt_unique_number = $obj->automate_number($GLOBALS['receipt_table'], 'receipt_unique_number', $last_record_id, $insert_id);
						$action = "";
						if(!empty($receipt_unique_number)) {          
							$action = "New Receipt Created. Receipt ID : ".$receipt_unique_number;          
							$receipt_unique_number = $obj->encode_decode('encrypt', strtoupper($receipt_unique_number));
						}

						$receipt_id = "";
						if($insert_id < 10) {
							$receipt_id = "receipt_".date("dmYhis")."_0".$insert_id;
						}
						else {
							$receipt_id = "receipt_".date("dmYhis")."_".$insert_id;
						}
						if(!empty($receipt_id)) {
							$receipt_id = $obj->encode_decode('encrypt', $receipt_id);
						}
						$columns = array(); $values = array();						
						$columns = array('receipt_id', 'receipt_unique_number');
						$values = array("'".$receipt_id."'", "'".$receipt_unique_number."'");
						$update_id = $obj->UpdateSQL($GLOBALS['receipt_table'], $insert_id, $columns, $values, $action);
						if(preg_match("/^\d+$/", $update_id)) {
							$image_copy = 1; $new_receipt_unique_number = $receipt_unique_number;
							$result = array('number' => '1', 'msg' => 'Receipt Successfully Created');					
						}
						else {
							$result = array('number' => '2', 'msg' => $update_id);
						}
					}
					else {
						$result = array('number' => '2', 'msg' => $insert_id);
					}
				}
				else {
					$getUniqueID = "";
					$getUniqueID = $obj->getTableColumnValue($GLOBALS['receipt_table'], 'receipt_id', $edit_id, 'id');
					if(preg_match("/^\d+$/", $getUniqueID)) {
						$receipt_unique_number = $obj->getTableColumnValue($GLOBALS['receipt_table'], 'receipt_id', $edit_id, 'receipt_unique_number');
						$action = "";
						if(!empty($receipt_unique_number)) {
							$new_receipt_unique_number = $receipt_unique_number;
							$action = "Receipt Updated. Receipt ID - ".$obj->encode_decode('decrypt', $receipt_unique_number);
						}
					
						$columns = array(); $values = array();						
						$columns = array('creator_name', 'receipt_date', 'agent_id', 'agent_details', 'agent_commission', 'customer_id', 'customer_details', 'receipter_details', 'customer_chit_id', 'customer_chit_details', 'chit_due_amount', 'chit_due_count', 'amount', 'penalty_amount', 'total_amount', 'split_up_amount', 'payment_mode', 'transaction_id', 'transaction_screenshot', 'later_due');
						$values = array("'".$creator_name."'", "'".$receipt_date."'", "'".$agent_id."'", "'".$agent_details."'", "'".$agent_commission_value."'", "'".$customer_id."'", "'".$customer_details."'", "'".$receipter_details."'", "'".$customer_chit_id."'", "'".$customer_chit_details."'", "'".$customer_due_count."'", "'".$customer_due_count."'", "'".$amount."'", "'".$penalty_amount."'", "'".$total_amount."'", "'".$split_up_amount."'", "'".$payment_mode."'", "'".$transaction_id."'", "'".$transaction_screenshot."'", "'".$later_due."'");
						$update_id = $obj->UpdateSQL($GLOBALS['receipt_table'], $getUniqueID, $columns, $values, $action);
						if(preg_match("/^\d+$/", $update_id)) {	
							$image_copy = 1;							
							$result = array('number' => '1', 'msg' => 'Updated Successfully');						
						}
						else {
							$result = array('number' => '2', 'msg' => $user_update_id);
						}							
					}
                }

				if(!empty($payment_option) && !empty($customer_chit_id)) {					
					$chit_unique_id = $obj->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $customer_chit_id, 'id');
					if(preg_match("/^\d+$/", $chit_unique_id)) {
						$completed_date = "0000-00-00";

						$payable_amount = 0;
						$payable_amount = $obj->getCustomerChitPayableAmount($agent_id, $customer_id, $customer_chit_id);

						$total_amount = 0;
						$total_amount = $obj->getAgentCustomerReceiptTotalAmount($agent_id, $customer_id, $customer_chit_id);
						if(!empty($payable_amount) && !empty($total_amount) && $total_amount == $payable_amount) {
							$completed_date = date("Y-m-d");
						}

						if($payment_option == 1) {
							$currrent_receipt_total_amount = 0;
							$currrent_receipt_total_amount = $amount + $penalty_amount;
							if($currrent_receipt_total_amount == $total_amount) {
								$penalty_amount = 0;
							}
						}
						else if($payment_option == 2) {
							if(!empty($penalty_amount)) {
								$prev_penalty_amount = 0;
								$prev_penalty_amount = $obj->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $customer_chit_id, 'penalty_amount');
								if(!empty($prev_penalty_amount)) {
									$penalty_amount = $penalty_amount + $prev_penalty_amount;
								}	
							}
						}

						$chit_type = ""; $last_paid_date = ""; $next_due_date = "";
						if(!empty($receipt_date) && $receipt_date != "0000-00-00") {
							$last_paid_date = date("Y-m-d", strtotime($receipt_date));
							$chit_type = $obj->getTableColumnValue($GLOBALS['customer_chit_table'], 'customer_chit_id', $customer_chit_id, 'chit_type');
							if(!empty($last_paid_date) && !empty($chit_type)) {
								$chit_type = $obj->encode_decode('decrypt', $chit_type);

								if($chit_type == $GLOBALS['chit_type_monthly']) {                         
									$next_due_date = date('Y-m-d', strtotime('+1 month', strtotime($last_paid_date)));
								}
								else if($chit_type == $GLOBALS['chit_type_weekly']) {
									$next_due_date = date('Y-m-d', strtotime('+7 days', strtotime($last_paid_date)));
								}
							}		
						} 

						$columns = array(); $values = array();						
						$columns = array('completed_date', 'penalty_amount', 'last_paid_date', 'next_due_date');
						$values = array("'".$completed_date."'", "'".$penalty_amount."'", "'".$last_paid_date."'", "'".$next_due_date."'");
						$update_id = $obj->UpdateSQL($GLOBALS['customer_chit_table'], $chit_unique_id, $columns, $values, '');
					}	
				}

				if(!empty($admin_approval) && $admin_approval == 1) {
					if(!empty($customer_chit_id)) {
						$update_customer_due_count = 0;
						$update_customer_due_count = $obj->UpdateUserDueCount($agent_id, $customer_id, $customer_chit_id);
					}
					if(!empty($customer_id) && $customer_id != $GLOBALS['null_value']) {
						$update_customer_wallet = 0;
						$update_customer_wallet = $obj->UpdateCustomerWallet($customer_id);
					}						
					if(!empty($agent_id) && $agent_id != $GLOBALS['null_value']) {
						$update_agent_wallet = 0;
						$update_agent_wallet = $obj->UpdateAgentWallet($agent_id);
					}
				}

				if(!empty($image_copy) && $image_copy == 1) {
					$target_dir = $obj->image_directory();
					if(!empty($target_dir)) {
						$target_dir = str_replace("include/", "../", $target_dir);
					}

					$temp_dir = $obj->temp_image_directory();
					if(!empty($temp_dir)) {
						$temp_dir = str_replace("include/", "../", $temp_dir);
					}
					if(!empty($transaction_screenshot)) {				
						if(file_exists($temp_dir.$transaction_screenshot)) {   
							if(!empty($prev_transaction_screenshot)) {		
								if(file_exists($target_dir.$prev_transaction_screenshot)) {   
									unlink($target_dir.$prev_transaction_screenshot);
								}
							}
							copy($temp_dir.$transaction_screenshot, $target_dir.$transaction_screenshot);
						}
						else {
							if($transaction_screenshot == $GLOBALS['null_value']) {
								if(!empty($prev_transaction_screenshot) && file_exists($target_dir.$prev_transaction_screenshot)) {   
									unlink($target_dir.$prev_transaction_screenshot);
								}
							}
						}
					}
					$obj->clear_temp_image_directory();
				}

				if(!empty($new_receipt_unique_number)) {
                    $update_send_sms = 0;
                    $update_send_sms = $obj->UpdateDueAmountPaidReceiptSendSMSCount($new_receipt_unique_number);
                }
			}
			else {
				$result = array('number' => '2', 'msg' => 'Invalid IP');
			}
		}
		else {
			if(!empty($valid_receipt)) {
				$result = array('number' => '3', 'msg' => $valid_receipt);
			}	
            else if(!empty($chits_error)) {
                $result = array('number' => '2', 'msg' => $chits_error);
            }
		}
		
		if(!empty($result)) {
			$result = json_encode($result);
		}
		echo $result; exit;
	}
	
	if(isset($_POST['page_number'])) {
		$page_number = $_POST['page_number'];
		$page_limit = $_POST['page_limit'];
		$page_title = $_POST['page_title'];

		$search_text = "";
		if(isset($_POST['search_text'])) {
			$search_text = $_POST['search_text'];
		}

		$filter_from_date = "";
		if(isset($_POST['filter_from_date'])) {
			$filter_from_date = $_POST['filter_from_date'];
		}

		$filter_to_date = "";
		if(isset($_POST['filter_to_date'])) {
			$filter_to_date = $_POST['filter_to_date'];
		}

		$filter_agent_id = "";
		if(isset($_POST['filter_agent_id'])) {
			$filter_agent_id = $_POST['filter_agent_id'];
		}

		$filter_customer_id = "";
		if(isset($_POST['filter_customer_id'])) {
			$filter_customer_id = $_POST['filter_customer_id'];
		}

		$filter_chit_id = "";
		if(isset($_POST['filter_chit_id'])) {
			$filter_chit_id = $_POST['filter_chit_id'];
		}

		$total_records_list = array();
		$total_records_list = $obj->getCustomerReceiptListByFilter($filter_from_date, $filter_to_date, $filter_agent_id, $filter_customer_id, $filter_chit_id);

        if(!empty($search_text)) {
			$search_text = strtolower($search_text);
			$list = array();
			if(!empty($total_records_list)) {
				foreach($total_records_list as $val) {
					if( (strpos(strtolower($obj->encode_decode('decrypt', $val['receipt_unique_number'])), $search_text) !== false) || (strpos(strtolower($obj->encode_decode('decrypt', $val['customer_chit_details'])), $search_text) !== false) ) {
						$list[] = $val;
					}
				}
			}
			$total_records_list = $list;
		}
		
		$total_pages = 0;
		if(!empty($total_records_list)) {
			$total_pages = count($total_records_list);
		}
		
		$page_start = 0; $page_end = 0;
		if(!empty($page_number) && !empty($page_limit) && !empty($total_pages)) {
			if($total_pages > $page_limit) {
				if($page_number) {
					$page_start = ($page_number - 1) * $page_limit;
					$page_end = $page_start + $page_limit;
				}
			}
			else {
				$page_start = 0;
				$page_end = $page_limit;
			}
		}

		$show_records_list = array();
        if(!empty($total_records_list)) {
            $show_records_list = array_slice($total_records_list, $page_start, $page_limit);
        }

		$target_dir = $obj->image_directory();
		if(!empty($target_dir)) {
			$target_dir = str_replace("include", "..", $target_dir);
		}
?>
        
		<?php if($total_pages > $page_limit) { ?>
			<div class="pagination_cover mt-3"> 
				<?php
					include("pagination.php");
				?> 
			</div> 
		<?php } ?>

		<table class="table nowrap">
			<thead class="thead-dark">
                <tr>
					<th class="text-center px-2 py-2" style="width: 75px;">S.No</th>
                    <th class="text-center px-2 py-2" style="width: 125px;">Receipt Date</th>
                    <th class="text-center px-2 py-2" style="width: 150px;">Agent</th>
                    <th class="text-center px-2 py-2" style="width: 150px;">Customer</th>
                    <th class="text-center px-2 py-2">Chit Name</th>
                    <th class="text-center px-2 py-2" style="width: 150px;">Receipt ID</th>
                    <th class="text-center px-2 py-2" style="width: 150px;">Amount</th>
                    <th class="text-center px-2 py-2" style="width: 100px;">Action</th>
                </tr>
            </thead>
            <tbody>
			<?php
				if(!empty($show_records_list)) {
					foreach($show_records_list as $key => $data) {
						$index = $key + 1;
						if(!empty($page_number) && $page_number > 1) {
							$prefix = 0;
							$prefix = ($page_number * $page_limit) - $page_limit;
							if(!empty($prefix)) {
								$index = $prefix + $index;
							}
						}

						$transaction_id = ""; $transaction_screenshot = "";
						if(!empty($data['transaction_id']) && $data['transaction_id'] != $GLOBALS['null_value']) {
							$transaction_id = $obj->encode_decode('decrypt', $data['transaction_id']);                                                                
						}
						if(!empty($data['transaction_screenshot']) && $data['transaction_screenshot'] != $GLOBALS['null_value']) {
							$transaction_screenshot = $data['transaction_screenshot'];
							if(!empty($transaction_screenshot) && file_exists($target_dir.$transaction_screenshot)) {
								$transaction_screenshot = $target_dir.$transaction_screenshot;
							}
							else {
								$transaction_screenshot = "";	
							}
						}
						else {
							$transaction_screenshot = "";
						}
			?>
						<tr>
							<td class="text-center px-2 py-2" style="width: 75px;"><?php echo $index; ?></td>
								<td class="text-center px-2 py-2">
									<?php if(!empty($data['receipt_date']) && $data['receipt_date'] != "0000-00-00") { echo date("d-m-Y", strtotime($data['receipt_date'])); } ?>
								</td>
								<td class="text-center px-2 py-2">
									<?php
                                        if(!empty($data['agent_details']) && $data['agent_details'] != $GLOBALS['null_value']) {
											$data['agent_details'] = $obj->encode_decode('decrypt', $data['agent_details']);
											echo $data['agent_details'];
										}
									?>
								</td>
                                <td class="text-center px-2 py-2">
									<?php
										if(!empty($data['customer_details']) && $data['customer_details'] != $GLOBALS['null_value']) {
											$data['customer_details'] = $obj->encode_decode('decrypt', $data['customer_details']);
											$data['customer_details'] = str_Replace("$$$", "<br>", $data['customer_details']);
											echo $data['customer_details'];
										}
									?>
								</td>
                                <td class="text-center px-2 py-2">
									<?php
                                        if(!empty($data['customer_chit_details'])) {
                                            $data['customer_chit_details'] = $obj->encode_decode('decrypt', $data['customer_chit_details']);
                                            echo $data['customer_chit_details'];
                                        }
									?>
								</td>
								<td class="px-2 py-2">
									<div class="w-100">
										<?php if(!empty($transaction_screenshot)) { ?>
											<div class="row">
												<div class="col-9">
													<?php
														if(!empty($data['receipt_unique_number'])) {
															$data['receipt_unique_number'] = $obj->encode_decode('decrypt', $data['receipt_unique_number']);
															echo $data['receipt_unique_number'];
														}
													?>
												</div>
												<div class="col-3">
													<span class="d-flex align-items-center justify-content-end view_transaction_image" onClick="Javascript:ViewTransactionImage('<?php if(!empty($transaction_id)) { echo $transaction_id; } ?>', '<?php if(!empty($transaction_screenshot)) { echo $transaction_screenshot; } ?>');">
														<i class="fa fa-image"></i>
													</span>
												</div>
											</div>
										<?php } else { ?>
											<?php
												if(!empty($data['receipt_unique_number'])) {
													$data['receipt_unique_number'] = $obj->encode_decode('decrypt', $data['receipt_unique_number']);
													echo $data['receipt_unique_number'];
												}
											?>
										<?php } ?>									
									</div>
									
									<?php
										if(!empty($data['creator_name'])) {
											$data['creator_name'] = $obj->encode_decode('decrypt', $data['creator_name']);
									?>
											<small><?php echo "Last Opened : ".$data['creator_name']; ?></small>
									<?php		
										}
									?>
								</td>
                                <td class="text-center px-2 py-2">
									<?php
                                        if(!empty($data['total_amount'])) {
                                            $data['total_amount'] = $obj->truncate_number($data['total_amount'], 2);
											echo $data['total_amount'];
										}
									?>
								</td>
								<td class="text-center px-2 py-2">
									<div class="dropdown">
										<a class="btn btn-dark poppins px-3" href="#" role="button" data-toggle="dropdown">
											<i class="fa fa-ellipsis-v text-white"></i>
										</a>
										<div class="dropdown-menu dropdown-menu-right dropdown-menu-icon-list">
											<a class="dropdown-item" target="_blank" href="reports/rpt_receipt.php?view_receipt_id=<?php if(!empty($data['receipt_id'])) { echo $data['receipt_id']; } ?>"><i class="fa fa-print"></i> &ensp; Print</a>
											<a class="dropdown-item" href="Javascript:ShowModalContent('<?php if(!empty($page_title)) { echo $page_title; } ?>', '<?php if(!empty($data['receipt_id'])) { echo $data['receipt_id']; } ?>');"><i class="fa fa-pencil"></i> &ensp; View / Edit</a>
											<a class="dropdown-item" href="Javascript:DeleteModalContent('<?php if(!empty($page_title)) { echo $page_title; } ?>', '<?php if(!empty($data['receipt_id'])) { echo $data['receipt_id']; } ?>');"><i class="fa fa-trash"></i> &ensp; Delete</a>
										</div>
									</div>
								</td>
							</tr>
                <?php
                        }
                    }
                    else {
                ?>
                        <tr>
                            <td colspan="8" class="text-center">Sorry! No records found</td>
                        </tr>
                <?php } ?>
            </tbody>
        </table>
<?php	
	}
	
	if(isset($_REQUEST['delete_receipt_id'])) {
		$delete_receipt_id = $_REQUEST['delete_receipt_id'];
		$msg = "";
		if(!empty($delete_receipt_id)) {	
			$receipt_unique_id = "";
			$receipt_unique_id = $obj->getTableColumnValue($GLOBALS['receipt_table'], 'receipt_id', $delete_receipt_id, 'id');
            if(preg_match("/^\d+$/", $receipt_unique_id)) {
                $receipt_unique_number = "";
                $receipt_unique_number = $obj->getTableColumnValue($GLOBALS['receipt_table'], 'receipt_id', $delete_receipt_id, 'receipt_unique_number');

				$chit_id = "";
                $chit_id = $obj->getTableColumnValue($GLOBALS['receipt_table'], 'receipt_id', $delete_receipt_id, 'customer_chit_id');
				$customer_id = "";
                $customer_id = $obj->getTableColumnValue($GLOBALS['receipt_table'], 'receipt_id', $delete_receipt_id, 'customer_id');
				$agent_id = "";
                $agent_id = $obj->getTableColumnValue($GLOBALS['receipt_table'], 'receipt_id', $delete_receipt_id, 'agent_id');
            
                $action = "";
                if(!empty($receipt_unique_number)) {
                    $action = "Receipt Deleted. Receipt ID - ".$obj->encode_decode('decrypt', $receipt_unique_number);
                }
            
                $columns = array(); $values = array();						
                $columns = array('deleted');
                $values = array("'1'");
                $msg = $obj->UpdateSQL($GLOBALS['receipt_table'], $receipt_unique_id, $columns, $values, $action);
				if(preg_match("/^\d+$/", $msg)) {
					if(!empty($chit_id)) {
						$update_customer_due_count = 0;
						$update_customer_due_count = $obj->UpdateUserDueCount($agent_id, $customer_id, $chit_id);
					}
					if(!empty($customer_id)) {
						$update_customer_wallet = 0;
						$update_customer_wallet = $obj->UpdateCustomerWallet($customer_id);
					}						
					if(!empty($agent_id) && $agent_id != $GLOBALS['null_value']) {
						$update_agent_due_count_wallet = 0;
						$update_agent_due_count_wallet = $obj->UpdateAgentWallet($agent_id);
					}
				}
            }
		}
		echo $msg;
		exit;	
	}
?>