<?php
    include("../include.php");
	
	$chit_list = array();
	$chit_list = $obj->getTableRecords($GLOBALS['chit_table'], '', '');

    $company_list = array();
    $company_list = $obj->getTableRecords($GLOBALS['company_table'], '', '');

    foreach($company_list as $data){
        $company_name = ""; $company_address = ""; $company_mobile = ""; $company_email = ""; $logo = "";

        if(!empty($data['name'])) {
            $company_name = $obj->encode_decode('decrypt', $data['name']);
        }
        if(!empty($data['logo']) && $data['logo'] != $GLOBALS['null_value']) {
            $logo = $data['logo'];
        }
        if(!empty($data['address']) && $data['address'] != $GLOBALS['null_value']) {
            $company_address = $obj->encode_decode('decrypt', $data['address']);
            $company_address = str_replace("$$$", " ", $company_address);
        }
        if(!empty($data['mobile_number'])) {
            $company_mobile = $obj->encode_decode('decrypt', $data['mobile_number']);
        }
        if(!empty($data['email'])) {
            $company_email = $obj->encode_decode('decrypt', $data['email']);
        }
    }

    $target_dir = '../include/images/upload/';

    require_once('../fpdf/fpdf.php');
    $pdf = new FPDF('P','mm','A4');
    $pdf->AliasNbPages(); 
    $pdf->AddPage();
    $pdf->SetAutoPageBreak(true);
    $pdf->SetTitle('Chit List');
    $pdf->SetFont('Arial','B',10);
    $pdf->SetY(10);
    $pdf->Cell(0,5,strtoupper($company_name),0,1,'C',0);
    $pdf->SetFont('Arial','',7);
    $pdf->Cell(0,4,$company_address,0,1,'C',0);
    $pdf->Cell(0,4,'E-mail : '.$company_email.'   Phone : '.$company_mobile,0,1,'C',0);
        
    if(!empty($logo) && file_exists($target_dir.$logo)){
        $pdf->Image($target_dir.$logo,10,7,25,20);
    }
    
    $pdf->SetY(7);
    $pdf->Cell(0,20,'',1,1,'L',0);
    $pdf->SetFont('Arial','B',9);
    $pdf->Cell(0,6,'Chit List',1,1,'C',0);
    $pdf->SetFont('Arial','B',8);
    $yaxis = $pdf->GetY();
    $pdf->SetX(10);
    $pdf->Cell(10,5,'S.No',0,0,'C',0);
    $pdf->SetX(20);
    $pdf->Cell(80,5,'Chit Name',0,0,'C',0);
    $pdf->SetX(100);
    $pdf->Cell(20,5,'Maturity Value',0,0,'C',0);
    $pdf->SetX(120);
    $pdf->Cell(20,5,'Start Date',0,0,'C',0);
    $pdf->SetX(140);
    $pdf->Cell(20,5,'Closing Date',0,0,'C',0);
    $pdf->SetX(160);
    $pdf->MultiCell(20,5,'Booking Open Date',0,'C',0);
    $last_y = $pdf->GetY();
    $pdf->SetY($yaxis);
    $pdf->SetX(180);
    $pdf->Cell(20,5,'No.of Users',0,1,'C',0);

    $pdf->SetY($yaxis);
    $pdf->SetX(10);
    $pdf->Cell(10,$last_y-$yaxis,'',1,0,'C',0);
    $pdf->SetX(20);
    $pdf->Cell(80,$last_y-$yaxis,'',1,0,'C',0);
    $pdf->SetX(100);
    $pdf->Cell(20,$last_y-$yaxis,'',1,0,'C',0);
    $pdf->SetX(120);
    $pdf->Cell(20,$last_y-$yaxis,'',1,0,'C',0);
    $pdf->SetX(140);
    $pdf->Cell(20,$last_y-$yaxis,'',1,0,'C',0);
    $pdf->SetX(160);
    $pdf->Cell(20,$last_y-$yaxis,'',1,0,'C',0);
    $pdf->SetX(180);
    $pdf->Cell(0,$last_y-$yaxis,'',1,1,'L',0);

    $pdf->SetFont('Arial','',8);

    $start_y = $pdf->GetY();
    $pdf->SetY($start_y);

    if(!empty($chit_list)) {
        $sno = 1;
        foreach($chit_list as $data) {
            if($pdf->GetY()>260){
                $pdf->SetY(-10);
                $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);
                $pdf->AddPage();
                $pdf->SetFont('Arial','B',10);
                $pdf->SetY(10);
                $pdf->Cell(0,5,strtoupper($company_name),0,1,'C',0);
                $pdf->SetFont('Arial','',7);
                $pdf->Cell(0,4,$company_address,0,1,'C',0);
                $pdf->Cell(0,4,'E-mail : '.$company_email.'   Phone : '.$company_mobile,0,1,'C',0);

                if(!empty($logo) && file_exists($target_dir.$logo)){
                    $pdf->Image($target_dir.$logo,10,7,25,20);
                }
                
                $pdf->SetY(7);
                $pdf->Cell(0,20,'',1,1,'L',0);
                $pdf->SetFont('Arial','B',8);
                $yaxis = $pdf->GetY();
                $pdf->SetX(10);
                $pdf->Cell(10,5,'S.No',0,0,'C',0);
                $pdf->SetX(20);
                $pdf->Cell(80,5,'Chit Name',0,0,'C',0);
                $pdf->SetX(100);
                $pdf->Cell(20,5,'Maturity Value',0,0,'C',0);
                $pdf->SetX(120);
                $pdf->Cell(20,5,'Start Date',0,0,'C',0);
                $pdf->SetX(140);
                $pdf->Cell(20,5,'Closing Date',0,0,'C',0);
                $pdf->SetX(160);
                $pdf->MultiCell(20,5,'Booking Open Date',0,'C',0);
                $last_y = $pdf->GetY();
                $pdf->SetY($yaxis);
                $pdf->SetX(180);
                $pdf->Cell(20,5,'No.of Users',0,1,'C',0);
            
                $pdf->SetY($yaxis);
                $pdf->SetX(10);
                $pdf->Cell(10,$last_y-$yaxis,'',1,0,'C',0);
                $pdf->SetX(20);
                $pdf->Cell(80,$last_y-$yaxis,'',1,0,'C',0);
                $pdf->SetX(100);
                $pdf->Cell(20,$last_y-$yaxis,'',1,0,'C',0);
                $pdf->SetX(120);
                $pdf->Cell(20,$last_y-$yaxis,'',1,0,'C',0);
                $pdf->SetX(140);
                $pdf->Cell(20,$last_y-$yaxis,'',1,0,'C',0);
                $pdf->SetX(160);
                $pdf->Cell(20,$last_y-$yaxis,'',1,0,'C',0);
                $pdf->SetX(180);
                $pdf->Cell(0,$last_y-$yaxis,'',1,1,'L',0);
            
                $pdf->SetFont('Arial','',8);
            }

            $chit_name = ""; $maturity_value = 0; $start_date = ""; $end_date = ""; $booking_open_date = 0; $no_of_users = 0; $chit_user_count = 0;
            if(!empty($data['chit_name'])) {
                $chit_name = $obj->encode_decode('decrypt', $data['chit_name']);
            }
            if(!empty($data['maturity_value'])) {
                $maturity_value = $obj->truncate_number($data['maturity_value'], 2);
            }
            if(!empty($data['start_date']) && $data['start_date'] != "0000-00-00") { 
                $start_date = date("d-m-Y", strtotime($data['start_date'])); 
            }
            if(!empty($data['end_date']) && $data['end_date'] != "0000-00-00") { 
                $end_date = date("d-m-Y", strtotime($data['end_date'])); 
            }
            if(!empty($data['booking_open_date']) && $data['booking_open_date'] != "0000-00-00") { 
                $booking_open_date = date("d-m-Y", strtotime($data['booking_open_date'])); 
            }            
            if(!empty($data['no_of_users']) && !empty($data['chit_id'])) {                
                $no_of_users = $data['no_of_users'];
                if(!empty($no_of_users)) {                    
                    $chit_user_count = $obj->getChitUsersCount($data['chit_id']);
                }
            }
            $y = $pdf->GetY();
            $pdf->SetY($y);
            $pdf->SetX(10);
            $pdf->Cell(10,5,$sno,1,0,'C',0);
            $pdf->SetX(20);
            $pdf->MultiCell(80,5,$chit_name,1,'C',0);
            $pdf->SetY($y);
            $pdf->SetX(100);
            $pdf->Cell(20,5,$maturity_value,1,0,'C',0);
            $pdf->SetX(120);
            $pdf->Cell(20,5,$start_date,1,0,'C',0);
            $pdf->SetX(140);
            $pdf->Cell(20,5,$end_date,1,0,'C',0);
            $pdf->SetX(160);
            $pdf->Cell(20,5,$booking_open_date,1,0,'C',0);
            $pdf->SetX(180);
            $pdf->Cell(20,5,$chit_user_count." / ".$no_of_users,1,1,'C',0);

            $sno++;
        }
    }
    
    $pdf->SetY(-10);
    $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);

    $pdf->Output();
?>