<?php
    include("../include.php");

    $filter_from_date = "";
    if(isset($_POST['filter_from_date'])) {
        $filter_from_date = $_POST['filter_from_date'];
    }

    $filter_to_date = "";
    if(isset($_POST['filter_to_date'])) {
        $filter_to_date = $_POST['filter_to_date'];
    }

    $filter_state = "";
    if(isset($_POST['filter_state'])) {
        $filter_state = $_POST['filter_state'];
        if(!empty($filter_state)) {
            $filter_state = $obj->encode_decode('encrypt', $filter_state);
        }
    }

    $filter_city = "";
    if(isset($_POST['filter_city'])) {
        $filter_city = $_POST['filter_city'];
        if(!empty($filter_city)) {
            $filter_city = $obj->encode_decode('encrypt', $filter_city);
        }
    }

    $filter_agent_id = "";
    if(isset($_POST['filter_agent_id'])) {
        $filter_agent_id = $_POST['filter_agent_id'];
    }

    $filter_customer_id = "";
    if(isset($_POST['filter_customer_id'])) {
        $filter_customer_id = $_POST['filter_customer_id'];
    }

    $filter_chit_id = "";
    if(isset($_POST['filter_chit_id'])) {
        $filter_chit_id = $_POST['filter_chit_id'];
    }

    $filter_order_status = "";
    if(isset($_POST['filter_order_status'])) {
        $filter_order_status = $_POST['filter_order_status'];
    }
	
	$order_list = array();
	$order_list = $obj->getCustomerOrderListByFilter($filter_from_date, $filter_to_date, $filter_state, $filter_city, $filter_agent_id, $filter_customer_id, $filter_chit_id, $filter_order_status);
    
    $company_list = array();
    $company_list = $obj->getTableRecords($GLOBALS['company_table'], '', '');

    foreach($company_list as $data){
        $company_name = ""; $company_address = ""; $company_mobile = ""; $company_email = ""; $logo = "";

        if(!empty($data['name'])) {
            $company_name = $obj->encode_decode('decrypt', $data['name']);
        }
        if(!empty($data['logo']) && $data['logo'] != $GLOBALS['null_value']) {
            $logo = $data['logo'];
        }
        if(!empty($data['address']) && $data['address'] != $GLOBALS['null_value']) {
            $company_address = $obj->encode_decode('decrypt', $data['address']);
            $company_address = str_replace("$$$", " ", $company_address);
        }
        if(!empty($data['mobile_number'])) {
            $company_mobile = $obj->encode_decode('decrypt', $data['mobile_number']);
        }
        if(!empty($data['email'])) {
            $company_email = $obj->encode_decode('decrypt', $data['email']);
        }
    }

    $target_dir = '../include/images/upload/';

    require_once('../fpdf/fpdf.php');
    $pdf = new FPDF('P','mm','A4');
    $pdf->AliasNbPages(); 
    $pdf->AddPage();
    $pdf->SetAutoPageBreak(true);
    $pdf->SetTitle('Order List');
    $pdf->SetFont('Arial','B',10);
    $pdf->SetY(10);
    $pdf->Cell(0,5,strtoupper($company_name),0,1,'C',0);
    $pdf->SetFont('Arial','',7);
    $pdf->Cell(0,4,$company_address,0,1,'C',0);
    $pdf->Cell(0,4,'E-mail : '.$company_email.'   Phone : '.$company_mobile,0,1,'C',0);
        
    if(!empty($logo) && file_exists($target_dir.$logo)){
        $pdf->Image($target_dir.$logo,10,7,25,20);
    }
    
    $pdf->SetY(7);
    $pdf->Cell(0,20,'',1,1,'L',0);
    $pdf->SetFont('Arial','B',9);
    $pdf->Cell(0,6,'Order List',1,1,'C',0);
    $pdf->SetFont('Arial','B',8);
    $pdf->SetX(10);
    $pdf->Cell(10,5,'S.No',1,0,'C',0);
    $pdf->SetX(20);
    $pdf->Cell(25,5,'Order Date',1,0,'C',0);
    $pdf->SetX(45);
    $pdf->Cell(25,5,'Order ID',1,0,'C',0);
    $pdf->SetX(70);
    $pdf->Cell(35,5,'Customer Details',1,0,'C',0);
    $pdf->SetX(105);
    $pdf->Cell(70,5,'Chit Details',1,0,'C',0);
    $pdf->SetX(175);
    $pdf->Cell(25,5,'Total Amount',1,1,'C',0);
    $pdf->SetFont('Arial','',8);

    if(!empty($order_list)) {
        $sno = 1;
        foreach($order_list as $data) {
            if($pdf->GetY()>260){
                $pdf->SetY(-10);
                $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);
                $pdf->AddPage();
                $pdf->SetFont('Arial','B',10);
                $pdf->SetY(10);
                $pdf->Cell(0,5,strtoupper($company_name),0,1,'C',0);
                $pdf->SetFont('Arial','',7);
                $pdf->Cell(0,4,$company_address,0,1,'C',0);
                $pdf->Cell(0,4,'E-mail : '.$company_email.'   Phone : '.$company_mobile,0,1,'C',0);

                if(!empty($logo) && file_exists($target_dir.$logo)){
                    $pdf->Image($target_dir.$logo,10,7,25,20);
                }
                
                $pdf->SetY(7);
                $pdf->Cell(0,20,'',1,1,'L',0);
                $pdf->SetFont('Arial','B',9);
                $pdf->Cell(0,6,'Order List',1,1,'C',0);
                $pdf->SetFont('Arial','B',8);
                $pdf->SetX(10);
                $pdf->Cell(10,5,'S.No',1,0,'C',0);
                $pdf->SetX(20);
                $pdf->Cell(25,5,'Order Date',1,0,'C',0);
                $pdf->SetX(45);
                $pdf->Cell(25,5,'Order ID',1,0,'C',0);
                $pdf->SetX(70);
                $pdf->Cell(35,5,'Customer Details',1,0,'C',0);
                $pdf->SetX(105);
                $pdf->Cell(70,5,'Chit Details',1,0,'C',0);
                $pdf->SetX(175);
                $pdf->Cell(25,5,'Total Amount',1,1,'C',0);
                $pdf->SetFont('Arial','',8);
            }

            $order_date = ""; $order_number = ""; $customer_details = ""; $chit_details = ""; $total_amount = 0;

            if(!empty($data['order_date']) && $data['order_date'] != "0000-00-00 00:00:00") { 
                $order_date = date("d-m-Y", strtotime($data['order_date'])); 
            }
            if(!empty($data['order_number'])) {
                $order_number = $obj->encode_decode('decrypt', $data['order_number']);
            }
            if(!empty($data['customer_name'])) {
                $customer_details = $obj->encode_decode('decrypt', $data['customer_name']);
            }
            if(!empty($data['customer_mobile_number'])) {
                $customer_details = $customer_details." (".$obj->encode_decode('decrypt', $data['customer_mobile_number']).")";
            }
            if(!empty($data['customer_chit_details']) && $data['customer_chit_details'] != $GLOBALS['null_value']) {
                $chit_details = $obj->encode_decode('decrypt', $data['customer_chit_details']);
                $chit_details = '<div class="customer_order_chit_details_table"><div class="chit"><div>2022CT01</div><div>300 Plan (9 Monthly)</div></div> <div class="chit"><div>2022CT01</div><div>300 Plan (9 Monthly)</div></div></div>';
               /* $chit_details = str_replace('<div class="customer_order_chit_details_table"><div class="chit"><div>', '', $chit_details);
                $chit_details = str_replace('</div><div class="chit">', '', $chit_details);
                $chit_details = str_replace('<div>', '', $chit_details);
                $chit_details = str_replace('<div class="chit">', '', $chit_details);*/
                //echo $chit_details;
                preg_match_all('/<div class="chit">(.*)<\/div>/', $chit_details, $matches);
                //print_r($matches['0']);
                if(!empty($matches['0'])) {
                    $chit_data = $matches['0'];
                    $temp = "";
                    foreach($chit_data as $chit) {
                        if(!empty($chit)) {
                            $temp = explode(")", $chit);
                        }
                    }
                    //print_r($temp); echo "<br><br>";
                    if(!empty($temp)) {
                        $chit_data = array();
                        for($c = 0; $c < count($temp) - 1; $c++) {
                            if(!empty($temp[$c])) {
                                $temp[$c] = str_replace('<div class="chit"><div>', "", $temp[$c]);
                                $temp[$c] = str_replace('</div><div>', " - ", $temp[$c]);
                                $temp[$c] = str_replace('</div></div>', "", $temp[$c]);
                                $chit_data[] = $temp[$c].")";
                            }
                        }
                        //print_r($chit_data);
                        $chit_details = implode(", ", $chit_data);
                    }
                }
            }
            if(!empty($data['total_amount'])) {
                $total_amount = $data['total_amount'];
            }

            $yaxis = $pdf->GetY();
            $pdf->SetX(10);
            $pdf->Cell(10,5,$sno,0,0,'C',0);
            $pdf->SetX(20);
            $pdf->Cell(25,5,$order_date,0,0,'C',0);
            $pdf->SetX(45);
            $pdf->Cell(25,5,$order_number,0,0,'C',0);
            $pdf->SetX(70);
            $pdf->MultiCell(35,5,$customer_details,0,'C',0);
            $customer_height = $pdf->GetY();
            $pdf->SetY($yaxis);
            $pdf->SetX(105);
            $pdf->MultiCell(70,5,$chit_details,0,'C',0);
            $chit_height = $pdf->GetY();  
            $pdf->SetY($yaxis);
            $pdf->SetX(175);
            $pdf->MultiCell(25,5,$total_amount,0,'C',0);
            $balance_height = $pdf->GetY();

            if($customer_height >= $chit_height && $customer_height >= $balance_height){
                $last_y = $customer_height;
            }
            else if($chit_height >= $customer_height && $chit_height >= $balance_height){
                $last_y = $chit_height;
            }
            else{
                $last_y = $balance_height;
            }

            $pdf->SetY($yaxis);
            $pdf->SetX(10);
            $pdf->Cell(10,$last_y-$yaxis,'',1,0,'C',0);
            $pdf->SetX(20);
            $pdf->Cell(25,$last_y-$yaxis,'',1,0,'C',0);
            $pdf->SetX(45);
            $pdf->Cell(25,$last_y-$yaxis,'',1,0,'C',0);
            $pdf->SetX(70);
            $pdf->Cell(35,$last_y-$yaxis,'',1,0,'C',0);
            $pdf->SetX(105);
            $pdf->Cell(70,$last_y-$yaxis,'',1,0,'C',0);
            $pdf->SetX(175);
            $pdf->Cell(0,$last_y-$yaxis,'',1,1,'L',0);

            $sno++;
        }
    }
    
    $pdf->SetY(-10);
    $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);

    $pdf->Output();
?>