<?php
    include("../include.php");
	
	$pricelist = array();
    $pricelist = $obj->ProductPricelist('1');

    $company_list = array();
    $company_list = $obj->getTableRecords($GLOBALS['company_table'], '', '');

    foreach($company_list as $data){
        $company_name = ""; $company_address = ""; $company_mobile = ""; $company_email = ""; $logo = "";

        if(!empty($data['name'])) {
            $company_name = $obj->encode_decode('decrypt', $data['name']);
        }
        if(!empty($data['logo']) && $data['logo'] != $GLOBALS['null_value']) {
            $logo = $data['logo'];
        }
        if(!empty($data['address']) && $data['address'] != $GLOBALS['null_value']) {
            $company_address = $obj->encode_decode('decrypt', $data['address']);
            $company_address = str_replace("$$$", " ", $company_address);
        }
        if(!empty($data['mobile_number'])) {
            $company_mobile = $obj->encode_decode('decrypt', $data['mobile_number']);
        }
        if(!empty($data['email'])) {
            $company_email = $obj->encode_decode('decrypt', $data['email']);
        }
    }

    $target_dir = '../include/images/upload/';

    require_once('../fpdf/fpdf.php');
    $pdf = new FPDF('P','mm','A4');
    $pdf->AliasNbPages(); 
    $pdf->AddPage();
    $pdf->SetAutoPageBreak(true);
    $pdf->SetTitle('Price List');
    $pdf->SetFont('Arial','B',10);
    $pdf->SetY(10);
    $pdf->Cell(0,5,strtoupper($company_name),0,1,'C',0);
    $pdf->SetFont('Arial','',7);
    $pdf->Cell(0,4,$company_address,0,1,'C',0);
    $pdf->Cell(0,4,'E-mail : '.$company_email.'   Phone : '.$company_mobile,0,1,'C',0);
        
    if(!empty($logo) && file_exists($target_dir.$logo)){
        $pdf->Image($target_dir.$logo,10,7,25,20);
    }
    
    $pdf->SetY(7);
    $pdf->Cell(0,20,'',1,1,'L',0);
    $pdf->SetFont('Arial','B',9);
    $pdf->Cell(0,6,'PRICE LIST',1,1,'C',0);
    $pdf->SetFont('Arial','B',8);
    $pdf->SetX(10);
    $pdf->Cell(20,5,'Product Code',1,0,'C',0);
    $pdf->SetX(30);
    $pdf->Cell(70,5,'Product Name',1,0,'C',0);
    $pdf->SetX(100);
    $pdf->Cell(20,5,'Content',1,0,'C',0);
    $pdf->SetX(120);
    $pdf->Cell(15,5,'Quantity',1,0,'C',0);
    $pdf->SetX(135);
    $pdf->Cell(30,5,'Price',1,0,'C',0);
    $pdf->SetX(165);
    $pdf->Cell(35,5,'Amount',1,1,'C',0);
    $pdf->SetFont('Arial','',8);

    if(!empty($pricelist)) {
        $sno = 1;
        foreach($pricelist as $data) {
            if($pdf->GetY()>260){
                $pdf->SetY(-10);
                $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);
                $pdf->AddPage();
                $pdf->SetFont('Arial','B',10);
                $pdf->SetY(10);
                $pdf->Cell(0,5,strtoupper($company_name),0,1,'C',0);
                $pdf->SetFont('Arial','',7);
                $pdf->Cell(0,4,$company_address,0,1,'C',0);
                $pdf->Cell(0,4,'E-mail : '.$company_email.'   Phone : '.$company_mobile,0,1,'C',0);

                if(!empty($logo) && file_exists($target_dir.$logo)){
                    $pdf->Image($target_dir.$logo,10,7,25,20);
                }
                
                $pdf->SetY(7);
                $pdf->Cell(0,20,'',1,1,'L',0);
                $pdf->SetFont('Arial','B',9);
                $pdf->Cell(0,6,'PRICE LIST',1,1,'C',0);
                $pdf->SetFont('Arial','B',8);
                $pdf->SetX(10);
                $pdf->Cell(20,5,'Product Code',1,0,'C',0);
                $pdf->SetX(30);
                $pdf->Cell(70,5,'Product Name',1,0,'C',0);
                $pdf->SetX(100);
                $pdf->Cell(20,5,'Content',1,0,'C',0);
                $pdf->SetX(120);
                $pdf->Cell(15,5,'Quantity',1,0,'C',0);
                $pdf->SetX(135);
                $pdf->Cell(30,5,'Price',1,0,'C',0);
                $pdf->SetX(165);
                $pdf->Cell(35,5,'Amount',1,1,'C',0);
                $pdf->SetFont('Arial','',8);
            }
            if(!empty($data['category_name'])) {
                $data['category_name'] = $obj->encode_decode('decrypt', $data['category_name']);
                $data['category_name'] = str_replace("$", '"', $data['category_name']);
                $data['category_name'] = str_replace("'''", '"', $data['category_name']);
                $pdf->SetFillColor(211,211,211);
                $pdf->SetFont('Arial','B',8);
                $pdf->Cell(0,6,$data['category_name'],1,1,'C',1);
                $pdf->SetFont('Arial','',8);
            }
            if(!empty($data['product_list'])) {
                foreach($data['product_list'] as $product) {
                    if($pdf->GetY()>260){
                        $pdf->SetY(-10);
                        $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);
                        $pdf->AddPage();
                        $pdf->SetFont('Arial','B',10);
                        $pdf->SetY(10);
                        $pdf->Cell(0,5,strtoupper($company_name),0,1,'C',0);
                        $pdf->SetFont('Arial','',7);
                        $pdf->Cell(0,4,$company_address,0,1,'C',0);
                        $pdf->Cell(0,4,'E-mail : '.$company_email.'   Phone : '.$company_mobile,0,1,'C',0);
        
                        if(!empty($logo) && file_exists($target_dir.$logo)){
                            $pdf->Image($target_dir.$logo,10,7,25,20);
                        }
                        
                        $pdf->SetY(7);
                        $pdf->Cell(0,20,'',1,1,'L',0);
                        $pdf->SetFont('Arial','B',9);
                        $pdf->Cell(0,6,'PRICE LIST',1,1,'C',0);
                        $pdf->SetFont('Arial','B',8);
                        $pdf->SetX(10);
                        $pdf->Cell(20,5,'Product Code',1,0,'C',0);
                        $pdf->SetX(30);
                        $pdf->Cell(70,5,'Product Name',1,0,'C',0);
                        $pdf->SetX(100);
                        $pdf->Cell(20,5,'Content',1,0,'C',0);
                        $pdf->SetX(120);
                        $pdf->Cell(15,5,'Quantity',1,0,'C',0);
                        $pdf->SetX(135);
                        $pdf->Cell(30,5,'Price',1,0,'C',0);
                        $pdf->SetX(165);
                        $pdf->Cell(35,5,'Amount',1,1,'C',0);
                        $pdf->SetFont('Arial','',8);
                    }
                    if(!empty($product['name'])) {
                        $product['product_code'] = $obj->encode_decode('decrypt', $product['product_code']);
                        $pdf->SetX(10);
                        $pdf->Cell(20,5,$product['product_code'],1,0,'C',0);
                        $product['name'] = $obj->encode_decode('decrypt', $product['name']);
                        $product['name'] = str_replace("$", '"', $product['name']);
                        $product['name'] = str_replace("'''", '"', $product['name']);
                        $pdf->SetX(30);
                        $pdf->Cell(70,5,$product['name'],1,0,'L',0);
                        $pdf->SetX(100);
                        $product['product_content'] = $obj->encode_decode('decrypt', $product['product_content']);
                        $pdf->Cell(20,5,$product['product_content'],1,0,'C',0);
                        $pdf->SetX(120);
                        $pdf->Cell(15,5,'',1,0,'C',0);
                        $pdf->SetX(135);
                        $pdf->Cell(30,5,number_format($product['price'], 2),1,0,'C',0);
                        $pdf->SetX(165);
                        $pdf->Cell(35,5,'',1,1,'C',0);
                    }
                }
            }
        }
    }
    
    $pdf->SetY(-10);
    $pdf->Cell(0, 5, "Page " . $pdf->PageNo() . "/{nb}", 0, 1,'C',0);

    $pdf->Output();
?>