<?php
    include("include_user_check.php");

    if(empty($login_user_id)) {
        header("Location: index.php");
        exit;
    }

    $page_title = "Dashboard";

    $filter_agent_id = ""; $filter_customer_id = ""; $fund_wallet = 0; $commission_wallet = 0; $merge_wallet = 0; $total_wallet = 0; $customer_list = array();
    if(!empty($login_user_id)) {
        if(!empty($agent_user) && $agent_user == 1) {
            $filter_agent_id = $login_user_id;

            $fund_wallet = $obj->getTableColumnValue($GLOBALS['agent_table'], 'agent_id', $login_user_id, 'fund_wallet');
            $commission_wallet = $obj->getTableColumnValue($GLOBALS['agent_table'], 'agent_id', $login_user_id, 'commission_wallet');
            $merge_wallet = $obj->getTableColumnValue($GLOBALS['agent_table'], 'agent_id', $login_user_id, 'merge_wallet');
            $total_wallet = $obj->getTableColumnValue($GLOBALS['agent_table'], 'agent_id', $login_user_id, 'total_wallet');

            $customer_list = $obj->getTableRecords($GLOBALS['customer_table'], 'agent_id', $filter_agent_id);
        }
        else {
            $filter_customer_id = $login_user_id;

            $fund_wallet = $obj->getTableColumnValue($GLOBALS['customer_table'], 'customer_id', $login_user_id, 'fund_wallet');
            $merge_wallet = $obj->getTableColumnValue($GLOBALS['customer_table'], 'customer_id', $login_user_id, 'merge_wallet');
            $total_wallet = $obj->getTableColumnValue($GLOBALS['customer_table'], 'customer_id', $login_user_id, 'total_wallet');
        }
    }

    $my_scheme_list = array();
    $my_scheme_list = $obj->getMySchemeList($filter_agent_id, $filter_customer_id, '');
?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title><?php if(!empty($project_title)) { echo $project_title; } ?> - <?php if(!empty($page_title)) { echo $page_title; } ?></title>
	<?php include("link_style_script.php"); ?>
</head>
<body>
<!--Navigation-->
	<?php include("header.php"); ?>
<!--Navigation End-->
<div class="container-fluid">
    <div class="row mx-0">
        <div class="col-12 justify-content-center px-0">
            <div class="w-100 py-3">
                <h5 class="medium mb-3"><?php if(!empty($page_title)) { echo $page_title; } ?></h5>
                
                <div class="row">

                    <div class="col-sm-6">
                        <div class="border card-box mb-3">
                            <div class="card-header">Monthly Receipts</div>
                            <div class="card-body px-1 py-1">
                                <div id="monthly_receipts_cover" class="w-100 px-3"></div>
                                <script type="text/javascript">
                                    jQuery(document).ready(function(){
                                        getMonthlyReceiptsByCalendar();

                                        $("#monthly_receipts_cover").fullCalendar({
                                            eventClick: function(event){
                                                //console.log('receipt id - '+event.receipt_id);
                                                window.open("reports/rpt_receipt.php?view_receipt_id="+event.receipt_id);
                                            }
                                        });
                                    });

                                    $('body').on('click', 'button.fc-prev-button', function() {
                                        jQuery("#monthly_receipts_cover").fullCalendar('removeEvents');
                                        getMonthlyReceiptsByCalendar();
                                    });

                                    $('body').on('click', 'button.fc-next-button', function() {
                                        jQuery("#monthly_receipts_cover").fullCalendar('removeEvents');
                                        getMonthlyReceiptsByCalendar();
                                    }); 
                                </script>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="border card-box form-group">
                            <div class="card-header">
                                <?php if(!empty($agent_user) && $agent_user == 1) { ?>
                                <div class="row">
                                    <div class="col-6 d-flex align-items-center">My Schemes</div>
                                    <div class="col-6">
                                        <select name="agent_customer_id" class="form-control" onChange="Javascript:loadChitPayment('');" >
                                            <option value="">Select Customer</option>
                                            <?php
                                                if(!empty($customer_list)) {
                                                    foreach($customer_list as $data) {
                                                        if(!empty($data['customer_id'])) {
                                            ?>
                                                            <option value="<?php echo $data['customer_id']; ?>" >
                                                                <?php
                                                                    if(!empty($data['name'])) {
                                                                        $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                                                                        echo $data['name'];
                                                                        if(!empty($data['mobile_number'])) {
                                                                            $data['mobile_number'] = $obj->encode_decode('decrypt', $data['mobile_number']);
                                                                            echo " (".$data['mobile_number'].")";
                                                                        }
                                                                    }
                                                                ?>
                                                            </option>
                                            <?php
                                                        }
                                                    }
                                                }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                                <?php } else { ?>
                                    My Schemes
                                <?php } ?>
                            </div>
                            <div class="card-body px-1 py-1">
                                <?php if(!empty($agent_user) && $agent_user == 1) { ?>
                                    <div class="row mx-0 mt-3">
                                        <?php if(!empty($fund_wallet) && !empty($total_wallet)) { ?>
                                        <div class="col-sm-4 mb-3 text-center"> 
                                            <h6>Fund Wallet : <?php if(!empty($fund_wallet)) { echo "Rs.".$obj->truncate_number($fund_wallet, 2); } ?></h6>
                                        </div>
                                        <?php } ?>
                                        <?php if(!empty($commission_wallet) && !empty($total_wallet)) { ?>
                                        <div class="col-sm-4 mb-3 text-center"> 
                                            <h6>Commission Wallet : <?php if(!empty($commission_wallet)) { echo "Rs.".$obj->truncate_number($commission_wallet, 2); } ?></h6>
                                        </div>
                                        <?php } ?>
                                        <?php if(!empty($merge_wallet) && !empty($total_wallet)) { ?>
                                        <div class="col-sm-4 mb-3 text-center"> 
                                            <h6>Merge Wallet : <?php if(!empty($merge_wallet)) { echo "Rs.".$obj->truncate_number($merge_wallet, 2); } ?></h6>
                                        </div>
                                        <?php } ?>
                                    </div>
                                <?php } else { ?>
                                    <div class="row mx-0 mt-3">
                                        <?php if(!empty($fund_wallet) && !empty($total_wallet)) { ?>
                                        <div class="col-sm-<?php if(!empty($merge_wallet)) { echo "6 text-sm-left"; } else { echo "12"; } ?> mb-3 text-center"> 
                                            <h6>Fund Wallet : <?php if(!empty($fund_wallet)) { echo "Rs.".$obj->truncate_number($fund_wallet, 2); } ?></h6>
                                        </div>
                                        <?php } ?>
                                        <?php if(!empty($merge_wallet) && !empty($total_wallet)) { ?>
                                        <div class="col-sm-6 mb-3 text-center text-sm-right"> 
                                            <h6>Merge Wallet : <?php if(!empty($merge_wallet)) { echo "Rs.".$obj->truncate_number($merge_wallet, 2); } ?></h6>
                                        </div>
                                        <?php } ?>
                                    </div>
                                <?php } ?>
                                <div id="my_schemes_cover" class="w-100 table-responsive"></div>
                            </div>
                        </div>    
                    </div>

                </div>

            </div> 
        </div>

    </div>
</div>

<script>
    $(document).ready(function(){
        loadChitPayment('');
    });
</script>

<?php include("footer.php"); ?>

</body>
</html>