<?php
	include("include.php");
	
	if(isset($_POST['page_number'])) {
		$page_number = $_POST['page_number'];
		$page_limit = $_POST['page_limit'];
		$page_title = $_POST['page_title'];

		$search_text = "";
		if(isset($_POST['search_text'])) {
			$search_text = $_POST['search_text'];
		}

		$total_records_list = array();
		if( (!empty($agent_user) && $agent_user == 1) && !empty($login_user_id)) {
			$total_records_list = $obj->getTableRecords($GLOBALS['order_table'], 'agent_id', $login_user_id);
		}
		if( (!empty($customer_user) && $customer_user == 1) && !empty($login_user_id)) {
			$total_records_list = $obj->getTableRecords($GLOBALS['order_table'], 'customer_id', $login_user_id);
		}

        if(!empty($search_text)) {
			$search_text = strtolower($search_text);
			$list = array();
			if(!empty($total_records_list)) {
				foreach($total_records_list as $val) {
					if( (strpos(strtolower($obj->encode_decode('decrypt', $val['order_number'])), $search_text) !== false) ) {
						$list[] = $val;
					}
				}
			}
			$total_records_list = $list;
		}
		
		$total_pages = 0;
		if(!empty($total_records_list)) {
			$total_pages = count($total_records_list);
		}
		
		$page_start = 0; $page_end = 0;
		if(!empty($page_number) && !empty($page_limit) && !empty($total_pages)) {
			if($total_pages > $page_limit) {
				if($page_number) {
					$page_start = ($page_number - 1) * $page_limit;
					$page_end = $page_start + $page_limit;
				}
			}
			else {
				$page_start = 0;
				$page_end = $page_limit;
			}
		}

		$show_records_list = array();
        if(!empty($total_records_list)) {
            $show_records_list = array_slice($total_records_list, $page_start, $page_limit);
        }
?>
        
		<?php if($total_pages > $page_limit) { ?>
			<div class="pagination_cover mt-3"> 
				<?php
					include("pagination.php");
				?> 
			</div> 
		<?php } ?>

		<table class="table nowrap wrdbrk">
			<thead class="thead-dark">
                <tr>
					<th class="text-center px-2 py-2" style="width: 75px;">S.No</th>
                    <th class="text-center px-2 py-2" style="width: 125px;">Created Date</th>
                    <th class="text-center px-2 py-2" style="width: 200px;">Order ID</th>
                    <th class="text-center px-2 py-2">Customer Details</th>
                    <th class="text-center px-2 py-2" style="width: 150px;">Total Amount</th>
					<th class="text-center px-2 py-2" style="width: 100px;">View</th>
                </tr>
            </thead>
            <tbody>
			<?php
				if(!empty($show_records_list)) {
					foreach($show_records_list as $key => $data) {
						$index = $key + 1;
						if(!empty($page_number) && $page_number > 1) {
							$prefix = 0;
							$prefix = ($page_number * $page_limit) - $page_limit;
							if(!empty($prefix)) {
								$index = $prefix + $index;
							}
						}
			?>
						<tr>
							<td class="text-center px-2 py-2" style="width: 75px;"><?php echo $index; ?></td>
								<td class="text-center px-2 py-2">
									<?php if(!empty($data['created_date_time']) && $data['created_date_time'] != "0000-00-00 00:00:00") { echo date("d-m-Y", strtotime($data['created_date_time'])); } ?>
								</td>
                                <td class="text-center px-2 py-2">
									<?php
										if(!empty($data['order_number'])) {
											$data['order_number'] = $obj->encode_decode('decrypt', $data['order_number']);
											echo $data['order_number'];
										}
									?>
								</td>
								<td class="px-2 py-2">
									<div class="w-100">
										<?php
											if(!empty($data['customer_name']) && $data['customer_name'] != $GLOBALS['null_value']) {
												$data['customer_name'] = $obj->encode_decode('decrypt', $data['customer_name']);
												echo $data['customer_name'];
												if(!empty($data['customer_mobile_number'])) {
													$data['customer_mobile_number'] = $obj->encode_decode('decrypt', $data['customer_mobile_number']);
													echo " (".$data['customer_mobile_number'].")";
												}
											}
										?>
									</div>
									
									<?php
										if(!empty($data['creator_name'])) {
											$data['creator_name'] = $obj->encode_decode('decrypt', $data['creator_name']);
									?>
											<small><?php echo "Last Opened : ".$data['creator_name']; ?></small>
									<?php		
										}
									?>
								</td>
                                <td class="text-center px-2 py-2">
									<?php
                                        if(!empty($data['total_amount'])) {
                                            $data['total_amount'] = $obj->truncate_number($data['total_amount'], 2);
											echo $data['total_amount'];
										}
									?>
								</td>
								<td class="text-center px-2 py-2">
									<div class="dropdown">
										<a class="btn btn-dark poppins px-3 py-2" href="#" role="button" data-toggle="dropdown">
											<i class="fa fa-ellipsis-v text-white"></i>
										</a>
										<div class="dropdown-menu dropdown-menu-right dropdown-menu-icon-list">
											<a class="dropdown-item" target="_blank" href="reports/rpt_orders_format1.php?print_order_id=<?php if(!empty($data['order_id'])) { echo $data['order_id']; } ?>"><i class="fa fa-print"></i> &ensp; Print</a>
										</div>
									</div>									
								</td>
							</tr>
                <?php
                        }
                    }
                    else {
                ?>
                        <tr>
                            <td colspan="6" class="text-center">Sorry! No records found</td>
                        </tr>
                <?php } ?>
            </tbody>
        </table>
<?php	
	}
?>