<?php 
	$access_page = "Direct Order";
   include("include_user_check.php");
	
	$project_title = "";
	$project_title = $obj->getProjectTitle();

    $page_title = "Direct Order";

    $order_number = $obj->automate_number($GLOBALS['order_table'], 'order_number'); $order_date = date("d-m-Y");

    $customer_list = array();
    $staff_id = "";
	if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id']) && isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'])) {
		$staff_id = $obj->getTableColumnValue($GLOBALS['user_table'], 'user_id', $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'], 'staff_id');
		if(!empty($staff_id) && $staff_id != $GLOBALS['null_value']) {
			$customer_list = $obj->StaffCreatedCustomers($staff_id, '0');
		}
        else {
            $customer_list = $obj->getTableRecords($GLOBALS['customer_table'], '', '');
        }
	}
	

    $product_list = array();
    $product_list = $obj->getTableRecords($GLOBALS['product_table'], '', '');

    $customer_id = ""; $delivery_address = ""; $product_ids = array(); $product_codes = array(); $product_names = array(); $quantity_values = array();
    $rate_values = array(); $discount = array(); $extra_discount = ""; $extra_discount_extension = ""; $show_extra_discount_amount = 2; $packing_charges = "";
    $order_type = $obj->encode_decode('encrypt', $GLOBALS['backend_order']);

    $edit_order_id = "";
    if(isset($_REQUEST['edit_order_id'])) {
        $edit_order_id = $_REQUEST['edit_order_id'];
        if(!empty($edit_order_id)) {

            $view_orders = array();
            $view_orders = $obj->getTableRecords($GLOBALS['order_table'], 'order_id', $edit_order_id);
            if(!empty($view_orders)) {
                foreach($view_orders as $data) {
                    if(!empty($data['order_number'])) {
                        $order_number = $data['order_number'];
                    }
                    if(!empty($data['order_date']) && $data['order_date'] != "0000-00-00") {
                        $order_date = date("d-m-Y", strtotime($data['order_date']));
                    }
                    if(!empty($data['customer_id'])) {
                        $customer_id = $data['customer_id'];
                    }
                    if(!empty($data['delivery_address'])) {
                        $delivery_address = $obj->encode_decode('decrypt', $data['delivery_address']);
                    }
                    if(!empty($data['product_id'])) {
                        $product_ids = explode(",", $data['product_id']);
                    }
                    if(!empty($data['product_code'])) {
                        $product_codes = explode(",", $data['product_code']);
                    }
                    if(!empty($data['product_name'])) {
                        $product_names = explode(",", $data['product_name']);
                    }
                    if(!empty($data['quantity'])) {
                        $quantity_values = explode(",", $data['quantity']);
                    }
                    if(!empty($data['actual_price'])) {
                        $rate_values = explode(",", $data['actual_price']);
                    }
                    if(!empty($data['discount'])) {
                        $discounts = 0;
                        $discounts = $data['discount'];
                        if(!empty($discounts)) {
                            $discounts = explode(",", $discounts);
                            foreach($discounts as $discount_value) {
                                if(!empty($discount_value)) {
                                    $discount = $discount_value;
                                }
                                if(!empty($discount)) { 
                                    $discount = str_replace("%", "", $discount);
                                    break; 
                                }
                            }
                        }
                    }
                    if(!empty($data['extra_discount'])) {
                        $extra_discount = $data['extra_discount'];
                        if (strpos($extra_discount, '%') !== false) {
                            $extra_discount = str_replace("%", "", $extra_discount);
                            $extra_discount_extension = "percentage";
                        }
                        else {
                            $extra_discount_extension = "rupees";
                        }
                    }
                    if(!empty($data['show_extra_discount_amount'])) {
                        $show_extra_discount_amount = $data['show_extra_discount_amount'];
                    }
                    if(!empty($data['packing_charges']) && $data['packing_charges'] != $GLOBALS['null_value']) {
                        $packing_charges = $data['packing_charges'];
                    }
                    if(!empty($data['order_type'])) {
                        $order_type = $data['order_type'];
                    }
                }
            }
        }
    }

    $check_order_type = "";
    if(!empty($order_type)) {
        $check_order_type = $obj->encode_decode('decrypt', $order_type);
        $discount_count = 0;
        if(!empty($order_type) && $order_type == $GLOBALS['frontend_order']) {
            if(!empty($discounts)) {
                $discounts = explode(",", $discounts);
                foreach($discounts as $discount_value) {
                    if(!empty($discount_value)) {
                        $discount_count++;
                    }
                }
            }
        }
        if(!empty($discount_count) && $discount_count == 1) {
            $discount = 0;
        }
    }

?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title> <?php if(!empty($project_title)) { echo $project_title; } ?> - Direct Enquiry </title>
	<?php include "link_style_script.php"; ?>
    <script type="text/javascript" src="include/js/common.js"></script>
    <script type="text/javascript" src="include/js/direct_order.js"></script>
</head>
<body>
	<?php include "header.php";  ?>
	<!-- sidebar-wrapper  -->          
	<div class="page-wrapper chiller-theme toggled">
		<main class="page-content">
			<div class="container-fluid px-lg-5">
				<div class="border card-box">

					<div class="card-header">
                        <div class="row">
                            <div class="col-sm-4 text-left"> <h5 class="headfnt mb-0">Direct Enquiry</h5> </div>
                            <div class="col-sm-4 text-center"> <?php if(!empty($order_date)) { echo "Order Date : ".$order_date; } ?> </div>
                            <div class="col-sm-4 text-right">
                                <button class="btn btn-primary btnwidth submit_button" type="button" onClick="Javascript:SaveOrder('direct_order_form');">Submit</button>
                            </div>
                        </div>
					</div>
					<div class="w-100 my-3 add_update_form_content">
                        <form name="direct_order_form" method="post">
                            <div class="row">
                                <div class="col-xl-3">
                                    <input type="hidden" name="order_number" value="<?php if(!empty($order_number)) { echo $order_number; } ?>">
                                    <input type="hidden" name="edit_order_id" value="<?php if(!empty($edit_order_id)) { echo $edit_order_id; } ?>">
                                    <input type="hidden" name="order_type" value="<?php if(!empty($order_type)) { echo $order_type; } ?>">                                            
                                    <input type="hidden" name="order_date" value="<?php if(!empty($order_date)) { echo $order_date; } ?>">

                                    <div class="form-group">
                                        <div id="customer_list" class="form-label-group in-border mb-0">
                                            <div class="input-group">
                                                <select name="customer_id" class="form-control" fieldindex='1' tabindex = '1' onChange="Javascript:getDeliveryAddress(this.value);">
                                                    <option value="">Select Customer</option>
                                                    <?php
                                                        if(!empty($customer_list)) {
                                                            foreach($customer_list as $data) {
                                                                if(!empty($data['customer_id'])) {
                                                    ?>
                                                                    <option value="<?php if(!empty($data['customer_id'])) { echo $data['customer_id']; } ?>" <?php if(!empty($customer_id) && $customer_id == $data['customer_id']) { ?> selected="selected" <?php } ?> >
                                                                        <?php
                                                                            if(!empty($data['name'])) {
                                                                                $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                                                                                echo $data['name'];
                                                                                if(!empty($data['city']) && $data['city'] != $GLOBALS['null_value']) {
                                                                                    $data['city'] = $obj->encode_decode('decrypt', $data['city']);
                                                                                    echo " - ".$data['city'];
                                                                                }
                                                                            }
                                                                        ?>
                                                                    </option>
                                                    <?php     
                                                                }       
                                                            }
                                                        }
                                                    ?>
                                                </select>
                                                <div style="position: inherit;" class="input-group-append">
                                                    <button class="btn btn-dark poppins" tabindex='2' style="font-size:11px;" type="button" onClick="javascript:AddCustomer();"><i class="fa fa-user"></i></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <?php
                                            if(!empty($delivery_address)) {
                                                $delivery_address = str_replace("<br>", "\r\n", $delivery_address);
                                            }
                                        ?>
                                        <div class="form-label-group in-border mb-0">
                                            <textarea name="delivery_address" class="form-control" tabindex='3' placeholder="Address" rows="5"><?php if(!empty($delivery_address)) { echo $delivery_address; } ?></textarea>
                                            <label>Address (*)</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-9">
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <div class="row">
                                                    <div class="col-6 text-left">Sub Total</div>
                                                    <div class="col-6 text-right sub_total"></div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="row">
                                                    <div class="col-4 text-left">Discount</div>
                                                    <div class="col-4">
                                                        <div class="input-group">
                                                            <input type="text" name="top_discount" class="form-control" tabindex='9' value="<?php if(!empty($discount)) { echo $discount; } ?>" onChange="Javascript:TopDiscount();">
                                                            <div style="position: inherit;" class="input-group-append">
                                                                <span class="btn btn-secondary py-1"><i class="fa fa-percent"></i></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-4 text-right discount_value"></div>
                                                </div>
                                            </div>
                                            <div class="form-group d-none">
                                                <div class="row">
                                                    <div class="col-6 text-left">Net Total</div>
                                                    <div class="col-6 text-right net_total"></div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="row">
                                                    <div class="col-4 text-left">Extra Discount</div>
                                                    <div class="col-4 px-0 discount_extension_cover">
                                                        <div class="input-group">
                                                            <input type="text" class="form-control shadow-none" tabindex='10' name="top_extra_discount" value="<?php if(!empty($extra_discount)) { echo $extra_discount; } ?>" onChange="Javascript:TopExtraDiscount();">
                                                            <div style="position: inherit;" class="input-group-append">
                                                                <select name="top_extra_discount_extension" class="form-control" fieldindex='11' tabindex='11' onChange="Javascript:TopExtraDiscount();">
                                                                    <option value="percentage" <?php if(!empty($extra_discount_extension) && $extra_discount_extension == "percentage") { ?> selected="selected" <?php } ?> >%</option>
                                                                    <option value="rupees" <?php if(!empty($extra_discount_extension) && $extra_discount_extension == "rupees") { ?> selected="selected" <?php } ?> >Rs</option>
                                                                </select>
                                                            </div>
                                                        </div>                                                        
                                                    </div>
                                                    <div class="col-4 text-right extra_discount_value"></div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="row">
                                                    <div class="col-6 text-left d-none">Total</div>
                                                    <div class="col-6 text-right total d-none"></div>
                                                    <div class="col-12">
                                                        <div class="custom-control custom-checkbox mb-3">
                                                            <input type="checkbox" class="custom-control-input" tabindex='12' id="top_show_extra_discount_amount" name="top_show_extra_discount_amount" <?php if(!empty($show_extra_discount_amount) && $show_extra_discount_amount == 1) { ?> checked="checked" <?php } ?> >
                                                            <label class="custom-control-label" for="top_show_extra_discount_amount" onClick="Javascript:TopShowExtraDiscountAmount();">Show Extra Discount Amount On Bill</label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <div class="row">
                                                    <div class="col-5 text-left">Packing Charges</div>
                                                    <div class="col-3">
                                                        <input type="text" class="form-control shadow-none" tabindex='13' name="top_packing_charges" value="<?php if(!empty($packing_charges)) { echo $packing_charges; } ?>" onChange="Javascript:TopPackingCharges();">
                                                    </div>
                                                    <div class="col-4 text-right packing_charges_value"></div>
                                                </div>
                                            </div>
                                            <div class="form-group d-none">
                                                <div class="row">
                                                    <div class="col-6 text-left">Grand Total</div>
                                                    <div class="col-6 text-right grand_total"></div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="row">
                                                    <div class="col-6 text-left">Round OFF</div>
                                                    <div class="col-6 text-right round_off"></div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="row">
                                                    <div class="col-6 text-left">Overall Total</div>
                                                    <div class="col-6 text-right overall_total"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>  
                                <div class="col-12">
                                    <div class="row">
                                        <div class="col-xl-5">
                                            <div class="form-group">
                                                <div class="form-label-group in-border mb-0">
                                                    <div class="input-group">
                                                        <select name="selected_product_id" class="form-control" fieldindex='4' tabindex='4' onChange="javascript:getProductDetails(this.value);">
                                                            <option value="">Select Product</option>
                                                            <?php
                                                                if(!empty($product_list)) {
                                                                    foreach($product_list as $data) {
                                                                        if(!empty($data['product_id'])) {
                                                            ?>
                                                                            <option value="<?php if(!empty($data['product_id'])) { echo $data['product_id']; } ?>">
                                                                                <?php
                                                                                    if(!empty($data['product_code'])) {
                                                                                        $data['product_code'] = $obj->encode_decode('decrypt', $data['product_code']);
                                                                                        echo $data['product_code'];
                                                                                        if(!empty($data['name'])) {
                                                                                            $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                                                                                            $data['name'] = str_replace("$", '"', $data['name']);
                                                                                            $data['name'] = str_replace("'''", '"', $data['name']);
                                                                                            echo " - ".$data['name'];
                                                                                        }
                                                                                    }
                                                                                ?>
                                                                            </option>
                                                            <?php     
                                                                        }       
                                                                    }
                                                                }
                                                            ?>
                                                        </select>
                                                        <div style="position: inherit;" class="input-group-append">
                                                            <button class="btn btn-dark poppins" tabindex='5' style="font-size:11px;" type="button" onClick="javascript:AddCustomRow();"><i class="fa fa-file"></i></button>
                                                        </div>
                                                    </div>                                            
                                                </div>
                                            </div>
                                        </div>  
                                        <div class="col-sm-6 col-xl-2">
                                            <div class="form-group">
                                                <div class="form-label-group in-border mb-0">
                                                    <input type="number" name="selected_quantity" class="form-control" tabindex='6' value="" placeholder="Quantity" onKeyup="Javascript:CalProductAmount();">
                                                    <label>Quantity (*)</label>
                                                </div>                                        
                                            </div>
                                        </div>
                                        <div class="col-sm-6 col-xl-2">
                                            <div class="form-group">
                                                <div class="form-label-group in-border mb-0">
                                                    <input type="text" name="selected_rate" class="form-control" tabindex='7' value="" placeholder="Rate" onKeyup="Javascript:CalProductAmount();">
                                                    <label>Rate (*)</label>
                                                </div>
                                                <div class="selected_product_content w-100 text-center mt-1" style="font-size: 13px;"></div>
                                            </div>
                                        </div>
                                        <div class="col-xl-3">
                                            <div class="form-group">
                                                <div class="form-label-group in-border mb-0">
                                                    <div class="input-group">
                                                        <input type="text" name="selected_amount" class="form-control" disabled value="" placeholder="Amount">
                                                        <label style="z-index:999;">Amount</label>
                                                        <div style="position: inherit;" class="input-group-append">
                                                            <button class="btn btn-dark poppins add_details_buttton" tabindex='8' style="font-size:11px;" type="button" onClick="javascript:AddDetails();"><i class="fa fa-plus-circle"></i> &ensp; Add</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="col-12">
                                    <div class="table-responsive">
                                        <input type="hidden" name="product_count" value="<?php if(!empty($edit_order_id) && !empty($product_ids)) { echo count($product_ids); } else { echo "0"; } ?>">
                                        <table class="data-table table nowrap tablefont order_products_table" style="margin: auto; min-width: 650px;">
                                            <thead class="thead-dark">
                                                <tr>
                                                    <th style="text-align: center; width: 10px; padding: 5px;">S.No</th>
                                                    <th style="text-align: center;">Product Name</th>
                                                    <th style="text-align: center; width: 75px;">Quantity</th>
                                                    <th style="text-align: center; width: 100px;">Price</th>
                                                    <th style="text-align: center; width: 100px;">Amount</th>
                                                    <th style="text-align: center; width: 50px;">Delete</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                    if(!empty($order_type)) {
                                                        $order_type = $obj->encode_decode('decrypt', $order_type);
                                                    }

                                                    if(!empty($edit_order_id) && !empty($product_ids)) {
                                                        $product_row_index = 0;
                                                        for($p = 0; $p < count($product_ids); $p++) {
                                                            $product_row_index = $p + 1;

                                                            $custom_product_row = 1; $custom_discount = 0;
                                                            if(!empty($product_codes[$p]) && $product_codes[$p] != $GLOBALS['null_value']) {
                                                                $custom_product_row = 0;
                                                            }
                                                            if(!empty($discounts[$p])) {
                                                                $custom_discount = $discounts[$p];
                                                                if (strpos($custom_discount, '%') !== false) {
                                                                    $custom_discount = trim(str_replace("%", "", $custom_discount));
                                                                }
                                                            }

                                                            $category_id = ""; $category_discount = 0;
                                                            if(!empty($product_ids[$p])) {
                                                                $category_id = $obj->getTableColumnValue($GLOBALS['product_table'], 'product_id', $product_ids[$p], 'category_id');                                                                
                                                                if(!empty($category_id)) {
                                                                    $category_discount = $obj->getCategoryDiscount($category_id);
                                                                    $category_discount = trim($category_discount);
                                                                }                                                                                
                                                            }

                                                            if(!empty($order_type) && $order_type == $GLOBALS['frontend_order']) {
                                                                if(!empty($category_discount)) {
                                                                    $check_discount = $category_discount;
                                                                    if (strpos($check_discount, '%') !== false) {
                                                                        $check_discount = trim(str_replace("%", "", $check_discount));
                                                                    }
                                                                    $rate_values[$p] = $obj->getActualPrice($rate_values[$p], $check_discount);
                                                                }
                                                            }

                                                            $amount = 0;
                                                            if(!empty($quantity_values[$p]) && !empty($rate_values[$p])) {
                                                                $amount = $quantity_values[$p] * $rate_values[$p];
                                                                $amount = number_format($amount, 2);
                                                            }
                                                ?>
                                                            <tr class="product_row <?php if(!empty($custom_product_row) && $custom_product_row == 1) { echo "custom_product_row"; } ?>" id="product_row<?php if(!empty($product_row_index)) { echo $product_row_index; } ?>">  
                                                                <td class="text-center sno">
                                                                    <?php if(!empty($product_row_index)) { echo $product_row_index; } ?>
                                                                </td>  
                                                                <td>
                                                                    <?php
                                                                        $product_name = "";
                                                                        if(!empty($product_names[$p])) {
                                                                            $product_name = $product_names[$p];
                                                                            if(!empty($product_name)) {
                                                                                $product_name = $obj->encode_decode('decrypt', $product_name);
                                                                                $product_name = str_replace("$", '"', $product_name);
                                                                                //echo $product_name;
                                                                            }

                                                                        }
                                                                        if(!empty($product_codes[$p]) && $product_codes[$p] != $GLOBALS['null_value']) {
                                                                            echo $product_name;
                                                                    ?>
                                                                            <input type="hidden" name="product_id[]" value="<?php if(!empty($product_ids[$p])) { echo $product_ids[$p]; } ?>">
                                                                            <input type="hidden" name="product_discount" class="product_discount" value="<?php if(!empty($category_discount)) { echo $category_discount; } else { echo "0"; } ?>">
                                                                    <?php 
                                                                        }
                                                                        else {
                                                                    ?>
                                                                        <div class="row">
                                                                            <div class="col-9">
                                                                                <input type="text" name="custom_product_<?php if(!empty($product_row_index)) { echo $obj->encode_decode('encrypt', "Custom Product - ".$product_row_index); } ?>" class="form-control" value="<?php if(!empty($product_name)) { echo $product_name; } ?>">
                                                                                <input type="hidden" name="product_id[]" value="<?php if(!empty($product_row_index)) { echo $obj->encode_decode('encrypt', "Custom Product - ".$product_row_index); } ?>">
                                                                            </div>
                                                                            <div class="col-3">
                                                                                <input type="text" class="form-control custom_discount" value="<?php if(!empty($custom_discount)) { echo "Y"; } else { echo "N"; } ?>" onkeyup="Javascript:calOverallTotal();">
                                                                                <span style="font-weight: bold; color: red; font-size: 12px; line-height: 13px;">Discount : Y / N</span>
                                                                                <input type="hidden" class="product_discount" name="custom_product_<?php if(!empty($product_row_index)) { echo $obj->encode_decode('encrypt', "Custom Product - ".$product_row_index); } ?>_discount" value="<?php if(!empty($custom_discount)) { echo $custom_discount; } ?>">
                                                                            </div>
                                                                        </div>

                                                                    <?php        
                                                                        }
                                                                    ?>
                                                                </td>
                                                                <td>
                                                                    <input type="text" name="quantity[]" class="form-control w-100" onkeyup="Javascript:ProductRowCheck(this);" value="<?php if(!empty($quantity_values[$p])) { echo $quantity_values[$p]; } ?>">
                                                                </td>
                                                                <td>
                                                                    <input type="text" name="rate[]" class="form-control w-100" onkeyup="Javascript:ProductRowCheck(this);" value="<?php if(!empty($rate_values[$p])) { echo $rate_values[$p]; } ?>">
                                                                </td>
                                                                <td class="amount text-right"><?php if(!empty($amount)) { echo $amount; } ?></td>
                                                                <td class="text-center">
                                                                    <button class="btn btn-danger w-100 align-self-center" type="button" onclick="Javascript:DeleteProductRow('<?php if(!empty($product_row_index)) { echo $product_row_index; } ?>');"> <i class="fa fa-trash" aria-hidden="true"></i></button>
                                                                </td>    
                                                            </tr>
                                                <?php            
                                                        }
                                                    } 
                                                ?>
                                            </tbody>   
                                            <tfoot>
                                                <td colspan="6" style="padding: 0;">
                                                    <table class="bill_table" cellpadding="0" cellspacing="0" style="float: right; font-size: 15px; width: 100%;">
                                                        <thead>
                                                            <tr>
                                                                <td colspan="2" style="white-space: nowrap; text-align: right; border-top: none;">
                                                                    Sub Total
                                                                </td>
                                                                <td class="sub_total" style="width: 20%; border-top: none; text-align: right;"></td>
                                                                <td style="width: 70px; border-top: none;"></td>
                                                            </tr>
                                                            <tr>
                                                                <td style="white-space: nowrap; text-align: right; border-top: none;">
                                                                    Discount
                                                                </td>
                                                                <td style="width: 150px; border-top: none;">
                                                                    <div class="input-group">
                                                                        <input type="text" name="bottom_discount" class="form-control" tabindex='14' value="<?php if(!empty($discount)) { echo $discount; } ?>" onChange="Javascript:BottomDiscount();">
                                                                        <div style="position: inherit;" class="input-group-append">
                                                                            <span class="btn btn-secondary py-1"><i class="fa fa-percent"></i></span>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td class="discount_value" style="width: 20%; border-top: none; text-align: right;"></td>
                                                                <td style="width: 70px; border-top: none;"></td>
                                                            </tr>
                                                            <tr class="d-none">
                                                                <td colspan="2" style="white-space: nowrap; text-align: right; border-top: none;">
                                                                    Net Total
                                                                </td>
                                                                <td class="net_total" style="width: 20%; border-top: none; text-align: right;"></td>
                                                                <td style="width: 70px; border-top: none;"></td>
                                                            </tr>
                                                            <tr>
                                                                <td style="white-space: nowrap; text-align: right; border-top: none;">
                                                                    Extra Discount
                                                                </td>
                                                                <td class="discount_extension_cover" style="width: 150px; border-top: none;">
                                                                    <div class="input-group">
                                                                        <input type="text" class="form-control shadow-none" tabindex='15' name="bottom_extra_discount" value="<?php if(!empty($extra_discount)) { echo $extra_discount; } ?>" onChange="Javascript:BottomExtraDiscount();">
                                                                        <div style="position: inherit;" class="input-group-append">
                                                                            <select name="bottom_extra_discount_extension" fieldindex='16' tabindex='16' class="form-control" onChange="Javascript:BottomExtraDiscount();">
                                                                                <option value="percentage" <?php if(!empty($extra_discount_extension) && $extra_discount_extension == "percentage") { ?> selected="selected" <?php } ?> >%</option>
                                                                                <option value="rupees" <?php if(!empty($extra_discount_extension) && $extra_discount_extension == "rupees") { ?> selected="selected" <?php } ?> >Rs</option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td class="extra_discount_value" style="width: 20%; border-top: none; text-align: right;"></td>
                                                                <td style="width: 70px; border-top: none;"></td>
                                                            </tr>
                                                            <tr class="d-none">
                                                                <td colspan="2" style="white-space: nowrap; text-align: right; border-top: none;">
                                                                    Total
                                                                    <div class="w-100">
                                                                        <div class="custom-control custom-checkbox mb-3">
                                                                            <input type="checkbox" class="custom-control-input" tabindex='17' id="bottom_show_extra_discount_amount" name="bottom_show_extra_discount_amount" <?php if(!empty($show_extra_discount_amount) && $show_extra_discount_amount == 1) { ?> checked="checked" <?php } ?> >
                                                                            <label class="custom-control-label" for="bottom_show_extra_discount_amount" onClick="Javascript:BottomShowExtraDiscountAmount();">Show Extra Discount Amount On Bill</label>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td class="total" style="width: 20%; border-top: none; text-align: right;"></td>
                                                                <td style="width: 70px; border-top: none;"></td>
                                                            </tr>
                                                            <tr>
                                                                <td style="white-space: nowrap; text-align: right; border-top: none;">
                                                                    Packing Charges
                                                                </td>
                                                                <td style="width: 100px; border-top: none;">
                                                                    <input type="text" class="form-control shadow-none" tabindex='18' name="bottom_packing_charges" value="<?php if(!empty($packing_charges)) { echo $packing_charges; } ?>" onChange="Javascript:BottomPackingCharges();">
                                                                </td>
                                                                <td class="packing_charges_value" style="width: 20%; border-top: none; text-align: right;"></td>
                                                                <td style="width: 70px; border-top: none;"></td>
                                                            </tr>
                                                            <tr class="d-none">
                                                                <td colspan="2" style="white-space: nowrap; text-align: right; border-top: none;">
                                                                    Grand Total
                                                                </td>
                                                                <td class="grand_total" style="width: 20%; border-top: none; text-align: right;"></td>
                                                                <td style="width: 70px; border-top: none;"></td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="white-space: nowrap; text-align: right; border-top: none;">
                                                                    Round OFF
                                                                </td>
                                                                <td class="round_off" style="width: 20%; border-top: none; text-align: right;"></td>
                                                                <td style="width: 70px; border-top: none;"></td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2" style="white-space: nowrap; text-align: right; border-top: none;">
                                                                    Overall Total
                                                                    <input type="hidden" name="discount" value="<?php if(!empty($discount)) { echo $discount; } ?>">
                                                                    <input type="hidden" name="extra_discount" value="<?php if(!empty($extra_discount)) { echo $extra_discount; } ?>">
                                                                    <input type="hidden" name="extra_discount_extension" value="<?php if(!empty($extra_discount_extension)) { echo $extra_discount_extension; } ?>">
                                                                    <input type="hidden" name="show_extra_discount_amount" value="<?php if(!empty($show_extra_discount_amount)) { echo $show_extra_discount_amount; } ?>">
                                                                    <input type="hidden" name="packing_charges" value="<?php if(!empty($packing_charges)) { echo $packing_charges; } ?>">
                                                                </td>
                                                                <td class="overall_total" style="width: 20%; border-top: none; text-align: right;"></td>
                                                                <td style="width: 70px; border-top: none;"></td>
                                                            </tr>
                                                        </thead>
                                                    </table>    
                                                </td>
                                            </tfoot>                                   
                                        </table>
                                    </div>
                                </div>               
                            </div>
                            <div class="col-md-12 pt-3 text-center">
                                <button class="btn btn-primary btnwidth submit_button" type="button" onClick="Javascript:SaveOrder('direct_order_form');">Submit</button>
                            </div>

                        </form>
                    </div>

				</div>
			</div>
		</main>
	</div>  
	<!-- page-wrapper -->

    <button type="button" data-toggle="modal" data-target="#AddCustomermodal" class="d-none add_customer_modal_button"></button>
    <div class="modal fade" id="AddCustomermodal" data-keyboard="false" data-backdrop="static">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="headfnt">Customer Details</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    
                </div>
            </div>
        </div>
    </div>

	<script>
		jQuery(document).ready(function(){
			jQuery("#direct_orderactive").addClass("active");

            <?php if(!empty($edit_order_id)) { ?> calOverallTotal(); <?php } ?>

            if(jQuery('input[name="selected_quantity"]').length > 0) {
                jQuery('input[name="selected_quantity"]').on("keypress", function(e) {
                    if (e.keyCode == 13) {
                        AddDetails();
                        return false;
                    }
                });
            }
		});
	</script>
    <script type="text/javascript"> 
        CheckFormChangeEvent(); 
    </script>

	<?php include "footer.php"; ?>

    </body>
</html>