<?php
    class Process_Functions extends Common_Functions {

		public function getNewArrivalsProductList() {
			$list = array(); $select_query = "";

			$new_arrivals_category_count = 0;
			$new_arrivals_category_count = $this->getTableColumnValue($GLOBALS['settings_table'], 'name', 'new_arrivals_category_count', 'value');
			if(!empty($new_arrivals_category_count) && $new_arrivals_category_count != $GLOBALS['null_value']) {

				$new_arrivals_headings = ""; $new_arrivals_products = "";
				$new_arrivals_headings = $this->getTableColumnValue($GLOBALS['settings_table'], 'name', 'new_arrivals_headings', 'value');				
				$new_arrivals_products = $this->getTableColumnValue($GLOBALS['settings_table'], 'name', 'new_arrivals_products', 'value');
				if(!empty($new_arrivals_headings) && $new_arrivals_headings != $GLOBALS['null_value']) {
					$new_arrivals_headings = explode("$$$", $new_arrivals_headings);

					if(!empty($new_arrivals_products) && $new_arrivals_products != $GLOBALS['null_value']) {
						$new_arrivals_products = explode("$$$", $new_arrivals_products);
					}

					for($i = 0; $i < count($new_arrivals_headings); $i++) {
						if(!empty($new_arrivals_headings[$i])) {
							$product_list = array();
							if(!empty($new_arrivals_products[$i])) {
								$select_query = "SELECT * FROM ".$GLOBALS['product_table']." WHERE 
															FIND_IN_SET(product_id, '".$new_arrivals_products[$i]."') AND show_frontend = '0' 
															AND deleted = '0'";
								$product_list = $this->getQueryRecords($GLOBALS['product_table'], $select_query);
							}
							if(!empty($product_list)) {
								$list[] = array('category_name' => $new_arrivals_headings[$i], 'product_list' => $product_list);
							}
						}
					}
				}
			}
			return $list;
		}

		public function getClearTableRecords($tables) {
			$success = 0; $con = $this->connect();
			if(!empty($tables)) {
				foreach($tables as $table) {
					if(!empty($table)) {
						$table = trim(str_replace("'", "", $table));
						$update_query = "";
						$update_query = "UPDATE ".$table." SET deleted = '1'";
						if(!empty($update_query)) {							
							$result = $con->prepare($update_query);
							if($result->execute() === TRUE) {
								$success++;	
							}
						}
					}
				}
				if($success == count($tables)) {
					$success = 1;
				}
				else {
					$success = "Unable to clear";
				}
			}
			return $success;
		}

		public function getNthRecord($table, $number) {
			$unique_id = 0;
			if(!empty($table) && !empty($number)) {
				$number = $number - 1;
				$list = array(); $select_query = "";
				$select_query = "SELECT * FROM ".$table." ORDER BY ID LIMIT ".$number.", 1";
				//echo $select_query."<br>";
				if(!empty($select_query)) {
					$list = $this->getQueryRecords($table, $select_query);
					if(!empty($list)) {
						foreach($list as $data) {
							if(!empty($data['id'])) {
								$unique_id = $data['id'];
							}
						}
					}
				}
			}
			return $unique_id;	
		}

		public function DisplayCustomerStates() {
			$list = array(); $select_query = "";
			$select_query = "SELECT * FROM ".$GLOBALS['state_city_table']." WHERE deleted = '0' ORDER BY id ASC";
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['state_city_table'], $select_query);
			}
			return $list;
		}

		public function DisplayMinOrderAmountPacking($state) {
			$list = array(); $select_query = ""; $minimum_order_amount = 0; $packing_charges = 0; $details = array();

			if(!empty($state)) {
				$select_query = "SELECT * FROM ".$GLOBALS['state_city_table']." WHERE state = '".$state."' AND deleted = '0' ORDER BY id ASC";
				if(!empty($select_query)) {
					$list = $this->getQueryRecords($GLOBALS['state_city_table'], $select_query);
					if(!empty($list)) {
						foreach($list as $data) {
							if(!empty($data['minimum_order_amount']) && $data['minimum_order_amount'] != $GLOBALS['null_value']) {
								$minimum_order_amount = $data['minimum_order_amount'];
							}
							if(!empty($data['packing_charges']) && $data['packing_charges'] != $GLOBALS['null_value']) {
								$packing_charges = $data['packing_charges'];
							}
						}
					}
				}
				$details = array('minimum_order_amount' => $minimum_order_amount, 'packing_charges' => $packing_charges);
			}

			return $details;
		}

		public function DisplayCitiesByState($state) {
			$list = array(); $select_query = "";

			if(!empty($state)) {
				$select_query = "SELECT * FROM ".$GLOBALS['state_city_table']." WHERE state = '".$state."' AND deleted = '0' ORDER BY id ASC";
				if(!empty($select_query)) {
					$list = $this->getQueryRecords($GLOBALS['state_city_table'], $select_query);
					if(!empty($list)) {
						foreach($list as $data) {
							$cities = "";
							if(!empty($data['cities']) && $data['cities'] != $GLOBALS['null_value']) {
								$cities = $this->encode_decode('decrypt', $data['cities']);
								if(!empty($cities)) {
                        			$list = explode("$$$", $cities);
								}
							}
						}
					}
				}
			}
			return $list;
		}

        public function getOrderingNumber($table, $category_id) {
			$ordering_number = 1; $select_query = "";

			if(!empty($table) && !empty($category_id)) {
				$select_query = "SELECT ordering FROM ".$table." WHERE category_id = '".$category_id."' AND deleted = '0' ORDER BY ordering DESC LIMIT 1";
			}
			else {
				$select_query = "SELECT ordering FROM ".$table." WHERE deleted = '0' ORDER BY ordering DESC LIMIT 1";
			}	

			if(!empty($select_query)) {
				$list = $this->getQueryRecords($table, $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['ordering'])) {
							$ordering_number = $data['ordering'] + 1;
						}
					}
				}
			}
			return $ordering_number;
		}

		public function DisplayCategoryByOrder() {
			$list = array(); $select_query = "";

			$select_query = "SELECT * FROM ".$GLOBALS['category_table']." WHERE deleted = '0' ORDER BY ordering ASC";

			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['category_table'], $select_query);
			}
			return $list;
		}

		public function DisplayCategoryProductsByOrder($category_id) {
			$list = array(); $select_query = "";
			if(!empty($category_id)) {
				$select_query = "SELECT * FROM ".$GLOBALS['product_table']." WHERE category_id = '".$category_id."' AND deleted = '0' ORDER BY ordering ASC";
			}
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['product_table'], $select_query);
			}
			return $list;
		}

		public function getCategoryDiscount($category_id) {
			$list = array(); $select_query = ""; $discount = 0;
			if(!empty($category_id)) {
				$select_query = "SELECT discount FROM ".$GLOBALS['discount_table']." WHERE FIND_IN_SET('".$category_id."', category_ids) AND show_frontend = '0' AND deleted = '0' ORDER BY id ASC";
			}
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['discount_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['discount'])) {
							$discount = $data['discount'];
						}
					}
				}
			}
			return $discount;
		}

		public function ProductPricelist($frontend) {
			$company_logo = ""; $company_list = array();
			$company_list = $this->getTableRecords($GLOBALS['company_table'], '', '');
			if(!empty($company_list)) {
				foreach($company_list as $data) {
					if(!empty($data['logo']) && $data['logo'] != $GLOBALS['null_value']) {
						$company_logo = $data['logo'];
					}
				}
			}

			$target_dir = "";
    		$target_dir = $this->image_directory();
			$target_dir = str_replace("../", "", $target_dir);

			$category_list = array(); $frontend_pricelist = array(); $backend_pricelist = array(); $pricelist = array();
			$category_list = $this->DisplayCategoryByOrder();
			if(!empty($category_list)) {
				foreach($category_list as $data) {

					if(!empty($frontend) && $frontend == 1) {
						if(empty($data['show_frontend'])) {
							if(!empty($data['category_id']) && !empty($data['name'])) {

								$discount = 0;
								$discount = $this->getCategoryDiscount($data['category_id']);

								$product_list = array();
								$product_list = $this->DisplayCategoryProductsByOrder($data['category_id']);
								if(!empty($product_list)) {
									$frontend_products = array();
									foreach($product_list as $product) {
										if(!empty($product['product_image'])) {

											$product_images = array(); $product_image = ""; $sub_images = array();
											$product_images = explode("$$$", $product['product_image']);
											if(!empty($product_images)) {
												for($p = 0; $p < count($product_images); $p++) {
													if(!empty($p)) {
														if(!empty($product_images[$p])) {
															$sub_images[] = $product_images[$p];
														}
													}
													else {
														if(!empty($product_images[$p])) {
															$product_image = $product_images[$p];
															/*if(!empty($product_image) && file_exists($target_dir.$product_image)) {
																$product['product_image'] = "thumb_".$product_image;
															}*/
														}
													}
												}
												if(!empty($sub_images) && count($sub_images) > 0) {
													$product['sub_images'] = $sub_images;
												}
												else {
													$product['sub_images'] = $GLOBALS['null_value'];
												}
											}
											if(!file_exists($target_dir.$product_image)) {
												/*if(file_exists($target_dir.$company_logo)) {
													$product['product_image'] = "thumb_".$company_logo;
												}*/
												if(file_exists($target_dir.$company_logo)) {
													$product['product_image'] = $company_logo;
												}
											}
											else {
												if(file_exists($target_dir.$product_image)) {
													$product['product_image'] = $product_image;
												}
											}
										}
										$video_id = "";
										if(!empty($product['product_video']) && $product['product_video'] != $GLOBALS['null_value']) {
											$product['product_video'] = $this->encode_decode('decrypt', $product['product_video']);
											if(strpos($product['product_video'], "youtu.be/" ) !== false) {
												$matches = "";
												preg_match('/(https:|http:|)(\/\/www\.|\/\/|)(.*?)\/(.{11})/i', $product['product_video'], $matches);
												if(!empty($matches) && is_array($matches)) {
													if(!empty($matches['4'])) {
														$video_id = $matches['4'];
													}
												}
											}
											else if(strpos($product['product_video'], "youtube.com/shorts" ) !== false) {
												$videos = array();
												$videos = explode("?", $product['product_video']);
												if(!empty($videos['0'])) {
													$last_position = 0;
													$last_position = strrpos($videos['0'], "/");
													if(!empty($last_position)) {
														$video_id = substr($videos['0'], $last_position + 1, strlen($videos['0']));
													}
												}
											}
										}
										$product['product_video_id'] = $video_id;

										if(empty($product['show_frontend'])) {
											$frontend_products[] = $product;
										}
									}
									$product_list = $frontend_products;
								}
								if(!empty($product_list)) {
									$frontend_pricelist[] = array('category_id' => $data['category_id'], 'category_name' => $data['name'], 'discount' => $discount, 'product_list' => $product_list);
								}
							}
						}
					}
					else {
						if(!empty($data['category_id']) && !empty($data['name'])) {
							$product_list = array();
							$product_list = $this->DisplayCategoryProductsByOrder($data['category_id']);
							if(!empty($product_list)) {
								$backend_pricelist[] = array('category_id' => $data['category_id'], 'category_name' => $data['name'], 'product_list' => $product_list);
							}
						}
					}

				}
			}

			if(!empty($frontend) && $frontend == 1) {
				$pricelist = $frontend_pricelist;
			}
			else {
				$pricelist = $backend_pricelist;
			}
			return $pricelist;
		}

		public function NoDiscountCategories($discount_edit_id) {
			$no_discount_category = array(); $category_list = array(); $discount_category_ids = "";

			if(!empty($discount_edit_id)) {
				$select_query = "SELECT * FROM ".$GLOBALS['discount_table']." WHERE discount_id = '".$discount_edit_id."' AND deleted = '0'";
				if(!empty($select_query)) {
					$list = $this->getQueryRecords($GLOBALS['discount_table'], $select_query);
					if(!empty($list)) {
						foreach($list as $data) {
							if(!empty($data['category_ids'])) {
								$discount_category_ids = explode(",", $data['category_ids']);
							}
						}
					}
				}
			}
			$category_list = $this->DisplayCategoryByOrder();
			if(!empty($category_list)) {
				foreach($category_list as $data) {
					if(!empty($data['category_id']) && !empty($data['name'])) {

						if(!empty($discount_category_ids) && in_array($data['category_id'], $discount_category_ids)) {
							$no_discount_category[] = array('category_id' => $data['category_id'], 'name' => $data['name']);
						}
						else {
							$list = array(); $select_query = ""; $discount = 0;
							$select_query = "SELECT * FROM ".$GLOBALS['discount_table']." WHERE FIND_IN_SET('".$data['category_id']."', category_ids) AND deleted = '0' ORDER BY id ASC";
							if(!empty($select_query)) {
								$list = $this->getQueryRecords($GLOBALS['discount_table'], $select_query);
								if(!empty($list)) {
									foreach($list as $val) {
										if(!empty($val['discount_id'])) {
											$discount = 1;
										}
									}
								}
							}
							if(empty($discount)) {
								$no_discount_category[] = array('category_id' => $data['category_id'], 'name' => $data['name']);
							}
						}
					}
				}
			}
			return $no_discount_category;
		}

		public function DisplayCrackerOrders($from_date, $to_date, $customer_id, $staff_id, $status, $order_type, $promotion_code_id, $transport_id, $bank_id, $access_orders) {
			$list = array(); $where = ""; $staff_where = "";
			
			if(!empty($from_date)) {
				$from_date = date("Y-m-d", strtotime($from_date));
				$where = "DATE(order_date) >= '".$from_date."'";
			}			
			if(!empty($to_date)) {
				$to_date = date("Y-m-d", strtotime($to_date));
				if(!empty($where)) {
					$where = $where." AND DATE(order_date) <= '".$to_date."'";
				}
				else {
					$where = "DATE(order_date) <= '".$to_date."'";
				}
			}			
			if(!empty($customer_id)) {
				if(!empty($where)) {
					$where = $where." AND customer_id = '".$customer_id."'";
				}
				else {
					$where = "customer_id = '".$customer_id."'";
				}
			}

			if(!empty($staff_id)) {
				if(!empty($staff_where)) {
					$staff_where = $staff_where." AND creator = '".$staff_id."'";
				}
				else {
					$staff_where = "creator = '".$staff_id."'";
				}
			}

			if(!empty($promotion_code_id)) {
				if(!empty($where)) {
					$where = $where." AND promotion_code_id = '".$promotion_code_id."'";
				}
				else {
					$where = "promotion_code_id = '".$promotion_code_id."'";
				}
			}

			if(!empty($transport_id)) {
				if(!empty($where)) {
					$where = $where." AND transport_id = '".$transport_id."'";
				}
				else {
					$where = "transport_id = '".$transport_id."'";
				}
			}

			if(!empty($bank_id)) {
				if(!empty($where)) {
					$where = $where." AND bank_id = '".$bank_id."'";
				}
				else {
					$where = "bank_id = '".$bank_id."'";
				}
			}

			if(!empty($status)) {
				if(!empty($where)) {
					$where = $where." AND order_status = '".$status."'";
				}
				else {
					$where = "order_status = '".$status."'";
				}
			}

			if(!empty($access_orders) && $access_orders == 1) {
				$order_type = $GLOBALS['frontend_order']; 
				if(!empty($order_type)) {
					$order_type = $this->encode_decode('encrypt', $order_type);
				}	
				if(!empty($staff_where)) {
					$staff_where = $staff_where." OR order_type = '".$order_type."'";
				}
				else {
					$staff_where = "order_type = '".$order_type."'";
				}
			}
			else {
				if(!empty($order_type)) {
					if(!empty($where)) {
						$where = $where." AND order_type = '".$order_type."'";
					}
					else {
						$where = "order_type = '".$order_type."'";
					}
				}
			}

			if(!empty($access_orders) && $access_orders == 1) {
				if(empty($customer_id) && !empty($staff_where)) {
					if(!empty($where)) {
						$where = $where." AND (".$staff_where.")";
					}
					else {
						$where = "(".$staff_where.")";
					}
				}
			}
			else {
				if(!empty($staff_id)) {
					$user_id = "";
					$user_id = $this->getTableColumnValue($GLOBALS['staff_table'], 'staff_id', $staff_id, 'user_id');
					if(!empty($user_id)) {
						if(!empty($where)) {
							$where = $where." AND creator = '".$user_id."'";
						}
						else {
							$where = "creator = '".$user_id."'";
						}
					}
				}
			}
			
			$select_query = "";
			if(!empty($where)) {
				$select_query = "SELECT * FROM ".$GLOBALS['order_table']." WHERE ".$where." AND deleted = '0' ORDER BY id DESC";
			}
			else {
				$select_query = "SELECT * FROM ".$GLOBALS['order_table']." WHERE deleted = '0' ORDER BY id DESC";
			}

			//echo $select_query;

			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['order_table'], $select_query);
			}

			return $list;
		}

		public function StaffCreatedCustomers($staff_id, $frontend_customer) {

			$staff_user_id = "";
			if(!empty($staff_id)) {
				$staff_user_id = $this->getTableColumnValue($GLOBALS['user_table'], 'staff_id', $staff_id, 'user_id');
			}

			$user_list = array(); $other_user_ids = array();
			$user_list = $this->getTableRecords($GLOBALS['user_table'], '', '');
			if(!empty($user_list)) {
				foreach($user_list as $data) {
					if(!empty($data['staff_id']) && $data['staff_id'] != $staff_id) {
						if(!empty($data['user_id']) && !in_array($data['user_id'], $other_user_ids)) {
							$other_user_ids[] = $data['user_id'];
						}
					}
				}
				if(!empty($other_user_ids)) {
					$other_user_ids = implode(",", $other_user_ids);
				}
			}

			$where = ""; $where2 = "c.creator = c.customer_id";
			if(!empty($staff_user_id)) {
				$where = "c.creator = '".$staff_user_id."'";
			}
			if(!empty($other_user_ids)) {
				if(!empty($where)) {
					$where = $where." AND c.creator NOT IN ('".$other_user_ids."')";
				}
				else {
					$where = "c.creator NOT IN ('".$other_user_ids."')";
				}
			}


			$select_query = ""; $list = array();
			if(!empty($staff_id) && !empty($where)) {
				if(!empty($frontend_customer) && $frontend_customer == 1) {
					$select_query = "SELECT c.* FROM ".$GLOBALS['customer_table']." as c WHERE (".$where." OR c.creator = c.customer_id) AND c.deleted = '0' ORDER BY c.id DESC";
				}
				else {
					$select_query = "SELECT c.* FROM ".$GLOBALS['customer_table']." as c WHERE ".$where." AND c.deleted = '0' ORDER BY c.id DESC";
				}
			}
			else {
				$select_query = "SELECT c.* FROM ".$GLOBALS['customer_table']." as c WHERE c.deleted = '0' ORDER BY c.id DESC";
			}

			if(!empty($select_query)) {
				//echo $select_query."<br>"; exit;
				$list = $this->getQueryRecords($GLOBALS['customer_table'], $select_query);
			}
			return $list;
		}

		public function getDiscountValueByPromotionCode($promotion_code, $sub_total) {
			$result = "";
			if(!empty($promotion_code) && !empty($sub_total)) {
				$promotion_code = strtolower($promotion_code);
				$promotion_code = $this->encode_decode('encrypt', $promotion_code);

				$list = array();
				$list = $this->getTableRecords($GLOBALS['promotion_code_table'], 'lower_case_name', $promotion_code);
				if(!empty($list)) {
					if(count($list) > 1) {
						$temp = array();
						foreach($list as $key => $data) {
							if(empty($key)) {
								$temp[] = $data;
							}
						}
						$list = $temp;
					}
					$price = 0; $expiry_date = ""; $minimum_order_amount = 0; $discount_upto_value = 0;
					foreach($list as $data) {
						if(!empty($data['price'])) {
							$price = $data['price'];
						}
						if(!empty($data['expiry_date']) && $data['expiry_date'] != "0000-00-00") {
							$expiry_date = date("d-m-Y", strtotime($data['expiry_date']));
						}
						if(!empty($data['minimum_order_amount'])) {
							$minimum_order_amount = $data['minimum_order_amount'];
						}
						if(!empty($data['discount_upto_value'])) {
							$discount_upto_value = $data['discount_upto_value'];
						}
					}
					$current_date = date("d-m-Y");
					if(!empty($price)) {
						if(!empty($expiry_date) && strtotime($current_date) <= strtotime($expiry_date)) {
							if(!empty($minimum_order_amount) && $sub_total >= $minimum_order_amount) {
								if(strpos($price, '%') !== false) {
									$price = str_replace("%", "", $price);
									$price = trim($price);

									$discount_value = 0;
									$discount_value = ($sub_total * $price) / 100;
									if(!empty($discount_value)) {
										$discount_value = number_format($discount_value, 2);
										$discount_value = str_replace(",", "", $discount_value);
										$result = $discount_value;
										if(!empty($discount_upto_value)) {
											if($result > $discount_upto_value) {
												$result = $discount_upto_value;
											}
										}
									}
								}
								else {
									$result = $price;
								}
							}
							else {
								$result = "Invalid Code";
							}
						}
						else {
							$result = "Invalid Code";
						}
					}
				}
				else {
					$result = "Invalid Code";
				}
			}

			return $result;
		}

		public function getOTPNumber() {
			$select_query = ""; $list = array(); $new_otp_number = ""; $otp_unique_id = ""; $otp_number = mt_rand(1000, 9999);
			if(!empty($otp_number)) {
				$otp_unique_id = $this->getTableColumnValue($GLOBALS['order_table'], 'otp_number', $otp_number, 'id');
				if(!empty($otp_unique_id)) {
					$this->getOTPNumber();
				}
				else {
					$new_otp_number = $otp_number;
				}
			}
			return $new_otp_number;
		}

		public function getOTPSendCount($otp_send_date, $otp_receive_mobile_number) {
            $select_query = ""; $list = array(); $otp_send_count = 0;
			if(!empty($otp_send_date) && !empty($otp_receive_mobile_number)) {
				$select_query = "SELECT SUM(otp_send_count) as otp_send_count FROM ".$GLOBALS['otp_send_phone_numbers_table']." WHERE DATE(send_date_time) = '".$otp_send_date."' AND phone_number = '".$otp_receive_mobile_number."' AND deleted = '0' ORDER BY id DESC";
				$list = $this->getQueryRecords($GLOBALS['otp_send_phone_numbers_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['otp_send_count'])) {
							$otp_send_count = $data['otp_send_count'];
						}
					}
				}
			}
			return $otp_send_count;
        }

		public function getOTPSendUniqueID($otp_send_date, $otp_receive_mobile_number) {
            $select_query = ""; $list = array(); $unique_id = "";
			if(!empty($otp_send_date) && !empty($otp_receive_mobile_number)) {
				$select_query = "SELECT id FROM ".$GLOBALS['otp_send_phone_numbers_table']." WHERE DATE(send_date_time) = '".$otp_send_date."' AND phone_number = '".$otp_receive_mobile_number."' AND deleted = '0' ORDER BY id DESC LIMIT 1";
				$list = $this->getQueryRecords($GLOBALS['otp_send_phone_numbers_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['id'])) {
							$unique_id = $data['id'];
						}
					}
				}
			}
			return $unique_id;
        }

		public function getStaffRedirectionPage($staff_id) {
			$list = array(); $select_query = ""; $redirection_page = "";
			if(!empty($staff_id)) {
				$select_query = "SELECT * FROM ".$GLOBALS['staff_table']." WHERE staff_id = '".$staff_id."' AND deleted = '0'";
			}
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['staff_table'], $select_query);
				if(!empty($list)) {
					$access_pages = "";
					foreach($list as $data) {
						if(!empty($data['access_pages'])) {
							$access_pages = $data['access_pages'];
						}
					}

					if(!empty($access_pages)) {
						$access_pages = explode(",", $access_pages);
						if(!empty($access_pages['0'])) {
							$page = $this->encode_decode('decrypt', $access_pages['0']); $page_list = $GLOBALS['staff_access_pages'];
							$redirection_pages = $GLOBALS['staff_redirection_pages'];
							if(!empty($page_list)) {
								for($p = 0; $p <= count($page_list); $p++) {
									if(!empty($page_list[$p]) && $page_list[$p] == $page) {
										if(!empty($redirection_pages[$p])) {
											$redirection_page = $redirection_pages[$p];
										}
									}
								}
							}
						}
					}
				}
			}
			return $redirection_page;
		}

		public function CheckStaffAccessPage($staff_id, $permission_page) {
			$list = array(); $select_query = ""; $acccess_permission = 0;
			if(!empty($staff_id)) {
				$select_query = "SELECT * FROM ".$GLOBALS['staff_table']." WHERE staff_id = '".$staff_id."' AND deleted = '0'";
			}
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['staff_table'], $select_query);
				if(!empty($list)) {
					$access_pages = "";
					foreach($list as $data) {
						if(!empty($data['access_pages'])) {
							$access_pages = $data['access_pages'];
						}
					}

					if(!empty($access_pages)) {
						$access_pages = explode(",", $access_pages);
						if(!empty($permission_page)) {
							$permission_page = $this->encode_decode('encrypt', $permission_page);
							if(in_array($permission_page, $access_pages)) {
								$acccess_permission = 1;
							}
						}
					}
				}
			}
			return $acccess_permission;
		}

		public function TodayOrdersCountAmount($count, $amount, $order_type) {
			$result = 0; $list = array(); $select_query = ""; $today = date("Y-m-d");
			if(!empty($order_type)) {
				$order_type = $this->encode_decode('encrypt', $order_type);
			}

			if( (!empty($count) && $count == 1) && empty($amount) ) {
				if(!empty($order_type)) {
					$select_query = "SELECT COUNT(id) as result FROM ".$GLOBALS['order_table']." WHERE DATE(order_date) = '".$today."' AND 
										order_type = '".$order_type."' AND deleted = '0'";
				}
				else {
					$select_query = "SELECT COUNT(id) as result FROM ".$GLOBALS['order_table']." WHERE DATE(order_date) = '".$today."' AND deleted = '0'";
				}
			}
			else if( empty($count) && (!empty($amount) && $amount == 1) ) {
				if(!empty($order_type)) {
					$select_query = "SELECT SUM(total_amount) as result FROM ".$GLOBALS['order_table']." WHERE DATE(order_date) = '".$today."' AND 
										order_type = '".$order_type."' AND deleted = '0'";
				}
				else {
					$select_query = "SELECT SUM(total_amount) as result FROM ".$GLOBALS['order_table']." WHERE DATE(order_date) = '".$today."' 
										AND deleted = '0'";
				}
			}
			//echo $select_query."<br>";
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['order_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['result'])) {
							$result = $data['result'];
						}
					}
				}
			}
			return $result;
		}

		public function CountOrdersByStatus($status_count_id, $from_date, $to_date, $customer_id, $staff_id, $order_type, $promotion_code_id, $transport_id) {
			$result = 0; $list = array(); $select_query = ""; $where = "";

			if(!empty($from_date)) {
				$from_date = date("Y-m-d", strtotime($from_date));
				$where = "DATE(order_date) >= '".$from_date."'";
			}			
			if(!empty($to_date)) {
				$to_date = date("Y-m-d", strtotime($to_date));
				if(!empty($where)) {
					$where = $where." AND DATE(order_date) <= '".$to_date."'";
				}
				else {
					$where = "DATE(order_date) <= '".$to_date."'";
				}
			}			
			if(!empty($customer_id)) {
				if(!empty($where)) {
					$where = $where." AND customer_id = '".$customer_id."'";
				}
				else {
					$where = "customer_id = '".$customer_id."'";
				}
			}

			if(!empty($staff_id)) {
				if(!empty($staff_where)) {
					$staff_where = $staff_where." AND creator = '".$staff_id."'";
				}
				else {
					$staff_where = "creator = '".$staff_id."'";
				}
			}

			if(!empty($promotion_code_id)) {
				if(!empty($where)) {
					$where = $where." AND promotion_code_id = '".$promotion_code_id."'";
				}
				else {
					$where = "promotion_code_id = '".$promotion_code_id."'";
				}
			}

			if(!empty($transport_id)) {
				if(!empty($where)) {
					$where = $where." AND transport_id = '".$transport_id."'";
				}
				else {
					$where = "transport_id = '".$transport_id."'";
				}
			}

			if(!empty($order_type)) {
				if(!empty($where)) {
					$where = $where." AND order_type = '".$order_type."'";
				}
				else {
					$where = "order_type = '".$order_type."'";
				}
			}

			if(!empty($status_count_id)) {
				if(!empty($where)) {
					$where = $where." AND order_status = '".$status_count_id."'";
				}
				else {
					$where = "order_status = '".$status_count_id."'";
				}
			}

			if(!empty($where)) {
				$select_query = "SELECT COUNT(id) as result FROM ".$GLOBALS['order_table']." WHERE ".$where." AND deleted = '0'";
			}
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['order_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						if(!empty($data['result'])) {
							$result = $data['result'];
						}
					}
				}
			}
			return $result;
		}

		public function getTransportListByStateCity($state, $city) {
			$transport_list = array(); $list = array(); $select_query = "";
			if(!empty($state)) {
				$select_query = "SELECT * FROM ".$GLOBALS['transport_table']." WHERE FIND_IN_SET('".$state."', state) AND deleted = '0' ORDER BY id DESC";
			}
			//echo $select_query."<br>";
			if(!empty($select_query)) {
				$list = $this->getQueryRecords($GLOBALS['transport_table'], $select_query);
				if(!empty($list)) {
					foreach($list as $data) {
						$states = array(); $state_city = array(); $selected = 0;
						if(!empty($data['state'])) {
							$states = explode(",", $data['state']);
						}
						if(!empty($data['city'])) {
							$state_city = explode("$$$", $data['city']);
						}
						if(!empty($states)) {
							for($i = 0; $i < count($states); $i++) {
								if(!empty($states[$i]) && $states[$i] == $state) {
									if(!empty($state_city[$i])) {
										$cities = array();
										$cities = explode(",", $state_city[$i]);
										if(!empty($cities) && !empty($city)) {
											for($j = 0; $j < count($cities); $j++) {
												if(!empty($cities[$j]) && $cities[$j] == $city) {
													$selected = 1;
												}
												if(!empty($selected) && $selected == 1) { break; }
											}
										}
									}
								}
								if(!empty($selected) && $selected == 1) { break; }
							}
						}
						if(!empty($selected) && $selected == 1) {
							$transport_list[] = array("transport_id" => $data['transport_id'], "name" => $data['name']);
						}
					}
				}
			}
			return $transport_list;
		}

    }
?>