<?php 
	$access_page = "Orders";
    include("include_user_check.php");
	
	include("permission_check.php");
	
	$project_title = "";
	$project_title = $obj->getProjectTitle();

    $page_title = "Order"; $page_number = $GLOBALS['page_number']; $page_limit = $GLOBALS['page_limit'];

    $from_date = date("01-01-Y"); $to_date = date("31-12-Y");
    $customer_list = array();   
	
	$staff_list = array();
    $staff_list = $obj->getTableRecords($GLOBALS['staff_table'], '', '');

	$staff_unique_id = ""; $staff_id = ""; $staff_name = ""; $filter_staff_id = "";
	if(!empty($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id']) && isset($_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'])) {
		$staff_unique_id = $obj->getTableColumnValue($GLOBALS['staff_table'], 'staff_id', $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'], 'id');								
		if(preg_match("/^\d+$/", $staff_unique_id)) {	
			$staff_id = $_SESSION[$GLOBALS['site_name_user_prefix'].'_user_id'];	
			$filter_staff_id = $staff_id;
			$staff_name = $obj->getTableColumnValue($GLOBALS['staff_table'], 'staff_id', $staff_id, 'name');
		}
	}

	if(!empty($staff_id) && !empty($staff_name)) {
		//$customer_list = $obj->StaffCreatedCustomers($staff_id, '1');
		$customer_list = $obj->getTableRecords($GLOBALS['customer_table'], 'creator', $staff_id);
	}
	else {
		$customer_list = $obj->getTableRecords($GLOBALS['customer_table'], '', '');
	}

	$order_type_list = array($GLOBALS['frontend_order'], $GLOBALS['backend_order']);

	$promotion_code_list = array();
    $promotion_code_list = $obj->getTableRecords($GLOBALS['promotion_code_table'], '', '');
	
	$show_promotion_code = 2;
	$show_promotion_code = $obj->getTableColumnValue($GLOBALS['settings_table'], 'name', 'show_promotion_code', 'value');

?>
<!DOCTYPE html>
<html lang="en">
<head>
	<title> <?php if(!empty($project_title)) { echo $project_title; } ?> - Enquiry List </title>
	<?php include "link_style_script.php"; ?>
	<script type="text/javascript" src="include/js/common.js"></script>
	<script type="text/javascript" src="include/js/order.js"></script>
</head>
<body>
	<?php include "header.php";  ?>
	<!-- sidebar-wrapper  -->          
	<div class="page-wrapper chiller-theme toggled">
		<main class="page-content">
			<div class="container-fluid px-lg-5">
				<div class="border card-box">

					<div class="card-header">
                        <div class="row">
                            <div class="col-6 text-center text-sm-left">
                                <h5 class="headfnt">Enquiry List</h5>
                            </div>
                            <div class="col-6 text-center text-sm-right">
                                <a class="btn btn-dark poppins" style="font-size:11px;" href="Javascript:OrdersPreview();"> <i class="fas fa-print"></i> &ensp; Preview</a>
                            </div>	
                        </div>
					</div>

					<div class="add_update_form_content"></div>

                    <form name="table_listing_form" method="post">
						<input type="hidden" name="page_number" value="<?php if(!empty($page_number)) { echo $page_number; } ?>">
						<input type="hidden" name="page_limit" value="<?php if(!empty($page_limit)) { echo $page_limit; } ?>">
						<input type="hidden" name="page_title" value="<?php if(!empty($page_title)) { echo $page_title; } ?>">
						<input type='hidden' name='filter_status' id='filter_status'>
						<div class="row my-3 mx-0">
							<div class="col-sm-6 col-xl-2 form-group">
								<input type="text" name="from_date" class="form-control date_field" onChange="Javascript:table_listing_records_filter();" value="<?php if(!empty($from_date)) { echo $from_date; } ?>" placeholder="From Date">
							</div>
                            <div class="col-sm-6 col-xl-2 form-group">
								<input type="text" name="to_date" class="form-control date_field" onChange="Javascript:table_listing_records_filter();" value="<?php if(!empty($to_date)) { echo $to_date; } ?>" placeholder="To Date">
							</div>
							<div class="col-sm-6 col-xl-4 form-group">
								<select name="filter_customer_id" class="form-control" onChange="Javascript:table_listing_records_filter();">
									<option value="">Select Customer</option>
									<?php
										if(!empty($customer_list)) {
											foreach($customer_list as $data) {
									?>
												<option value="<?php if(!empty($data['customer_id'])) { echo $data['customer_id']; } ?>">
													<?php
														if(!empty($data['name'])) {
															$data['name'] = $obj->encode_decode('decrypt', $data['name']);
															echo $data['name'];
															if(!empty($data['mobile_number'])) {
																$data['mobile_number'] = $obj->encode_decode('decrypt', $data['mobile_number']);
																echo " - ".$data['mobile_number'];
															}
														}
													?>
												</option>
									<?php			
											}
										}
									?>
								</select>
							</div>
							<div class="col-sm-6 col-xl-4 form-group">
								<?php if(!empty($filter_staff_id)) { ?>
									<input type="hidden" name="filter_staff_id" value="<?php if(!empty($filter_staff_id)) { echo $filter_staff_id; } ?>">
								<?php } else { ?>
								<select name="filter_staff_id" class="form-control" onChange="Javascript:table_listing_records_filter();">
									<option value="">Select Staff</option>
									<?php
										if(!empty($staff_list)) {
											foreach($staff_list as $data) {
									?>
												<option value="<?php if(!empty($data['staff_id'])) { echo $data['staff_id']; } ?>">
													<?php
														if(!empty($data['name'])) {
															$data['name'] = $obj->encode_decode('decrypt', $data['name']);
															echo $data['name'];
														}
													?>
												</option>
									<?php			
											}
										}
									?>
								</select>
								<?php } ?>
							</div>
							<div class="col-sm-6 col-xl-2 form-group">
								<?php if(empty($staff_name)) { ?>
								<select name="filter_order_type" class="form-control" onChange="Javascript:table_listing_records_filter();">
									<option value="">Select Enquiry Type</option>
									<?php
										if(!empty($order_type_list)) {
											foreach($order_type_list as $order_type) {
												if(!empty($order_type)) {
									?>
													<option value="<?php echo $obj->encode_decode('encrypt', $order_type); ?>"> <?php echo $order_type; ?> </option>
									<?php				
												}
											}
										}
									?>
								</select>
								<?php } ?>
							</div>
							<div class="col-sm-6 col-xl-2">
								<div class="dropdown status_filter">
									<button type="button" class="dropbtn" style="width:100px;height:40px; ;">
										Status
									</button>
									
									<div class="dropdown-content">
										<a href="#" onclick="check_status('');">All</a>
										<a href="#" onclick="check_status('1');" ><img src="images/tick1.jpg" width="100" height="35"></a>
										<a href="#" onclick="check_status('2');"><img src="images/tick2.jpg" width="100" height="35"></a>
										<a href="#" onclick="check_status('3');"><img src="images/tick3.jpg" width="100" height="35"></a>
										<a href="#" onclick="check_status('4');"><img src="images/notick.jpg" width="100" height="35"></a>
										<a href="#" onclick="check_status('5');">Unopened</a>
									</div>
								</div>
							</div>

							<div class="col-sm-6 col-xl-3 form-group">
								<?php if(!empty($show_promotion_code) && $show_promotion_code == 1) { ?>
									<select name="filter_promotion_code_id" class="form-control" onChange="Javascript:table_listing_records_filter();">
										<option value="">Select Promotion Code</option>
										<?php
											if(!empty($promotion_code_list)) {
												foreach($promotion_code_list as $data) {
										?>
													<option value="<?php if(!empty($data['promotion_code_id'])) { echo $data['promotion_code_id']; } ?>">
														<?php
															if(!empty($data['name'])) {
																$data['name'] = $obj->encode_decode('decrypt', $data['name']);
																echo $data['name'];
															}
														?>
													</option>
										<?php			
												}
											}
										?>
									</select>
								<?php } ?>
							</div>
							<div class="col-sm-6 col-xl-2 form-group">
								<input type="text" name="search_text" class="form-control" onKeyUp="Javascript:table_listing_records_filter();" value="" placeholder="Search By Enquiry No">
							</div>
						</div>
					</form>

					<?php /* ?><div class="row mx-0 order_listing_status_cover">
						<div class="col-xl-8 order_listing_cover"><?php */ ?>
							<div id="table_listing_records" class="table-responsive poppins"></div>
						<?php /* ?></div>
						<div class="col-xl-4 order_status_chart_cover">
							<?php
								$all_orders_count = 0; $confirmed_orders_count = 0; $despatched_orders_count = 0; $delivered_orders_count = 0; 
								$status_not_updated_orders_count = 0; $unopened_orders_count = 0;

								//$all_orders_count = $obj->CountOrdersByStatus('');
								$confirmed_orders_count = $obj->CountOrdersByStatus('1');
								$despatched_orders_count = $obj->CountOrdersByStatus('2');
								$delivered_orders_count = $obj->CountOrdersByStatus('3');
								$status_not_updated_orders_count = $obj->CountOrdersByStatus('4');
								$unopened_orders_count = $obj->CountOrdersByStatus('5');

								$status_order_count = array($all_orders_count, $confirmed_orders_count, $despatched_orders_count, $delivered_orders_count, $status_not_updated_orders_count, $unopened_orders_count);
								if(!empty($status_order_count)) {
									$status_order_count = implode(", ", $status_order_count);
								}
							?>

							<script type="text/javascript" src="include/chart/Chart.js"></script>
							<canvas id="order_status_chart" width="300" height="300"></canvas>
							<script type="text/javascript">
								var images = ['', 'images/tick1.jpg', 'images/tick2.jpg', 'images/tick3.jpg', 'images/notick.jpg', ''];

								var number_regex = /^\d+$/;
								var options = {
									type: 'pie',
									data: {
										labels: ["All", "Confirmed", "Despatched", "Delivered", "Status Not Updated", "Unopened"],
										datasets: [{
											label: 'status',
											data: [<?php echo $status_order_count; ?>],
											backgroundColor: [ "Purple", "Green", "Yellow", "Blue", "Orange", "Red" ],
											hoverBackgroundColor: [ "Purple", "Green", "Yellow", "Blue", "Orange", "Red" ]
										}]
									},
									options: {
										legend: {
											labels: {
												filter: function(legendItem, chartData) {
													if (parseInt(legendItem.index) == 0) {
														return false;
													}
													return true;
												}
											}
										},
										onClick: (e, activeEls) => {
											let datasetIndex = activeEls[0]._datasetIndex;
											let dataIndex = activeEls[0]._index;
											let datasetLabel = activeEls[0]._chart.data.datasets[datasetIndex].label;
											let value = activeEls[0]._chart.data.datasets[datasetIndex].data[dataIndex];
											let label = activeEls[0]._chart.data.labels[dataIndex];
											//console.log("In click - "+label+", "+value+', index - '+dataIndex);
											if(typeof label != "undefined" && label != null && label != "") {
												if(number_regex.test(value) == true && number_regex.test(dataIndex) == true) {
													var old_status = "";
													if(jQuery('input[name="filter_status"]').length > 0) {
														old_status = jQuery('input[name="filter_status"]').val();
														old_status = jQuery.trim(old_status);
													}
													if(parseInt(old_status) == parseInt(dataIndex)) {
														if(jQuery('input[name="filter_status"]').length > 0) {
															jQuery('input[name="filter_status"]').val('');
														}
													}
													else {
														if(jQuery('input[name="filter_status"]').length > 0) {
															jQuery('input[name="filter_status"]').val(dataIndex);
														}
													}
													table_listing_records_filter();
												}
											}
										}
									}
								}

								var ctx = document.getElementById('order_status_chart').getContext('2d');
								new Chart(ctx, options);
							</script>
						</div>
					</div><?php */ ?>

					

				</div>
			</div>
		</main>
	</div>  
	<!-- page-wrapper -->
	<link rel="stylesheet" type="text/css" href="include/css/order.css">
	<script>
		jQuery(document).ready(function(){
			jQuery("#ordersactive").addClass("active");
		});

		table_listing_records_filter();
	</script>
	<style>
		.canvasjs-chart-toolbar { display: none; }
	</style>
	<?php include "footer.php"; ?>

	<?php include "modal_content.php"; ?>

    </body>
</html>