<?php

header('Content-Type: application/json; charset=utf-8');

$json = file_get_contents('php://input');

$json_obj = json_decode($json);

$output = array();

$result = "";

$domain_name = ""; $admin_folder_name = "";
if(isset($json_obj->domain_name)) { 
    $domain_name = $json_obj->domain_name;		
    $domain_name = trim($domain_name);

    if(isset($json_obj->admin_folder_name)) { 
        $admin_folder_name = $json_obj->admin_folder_name;		
        $admin_folder_name = trim($admin_folder_name);
    }

    if(!empty($domain_name) && !empty($admin_folder_name)) {
        $domain_admin_path = "../".$domain_name."/".$admin_folder_name."/include.php";

        include($domain_admin_path);

        if (isset($json_obj->get_discount)) {
            if ($json_obj->get_discount == 1) {
        
                $total_records_list = array();
                $total_records_list = $obj->getTableRecords($GLOBALS['discount_table'], '', '');
        
                $discount_id = "";
                $discount = "";
                $show_frontend = 0;
                $discount_data = array();
                $creator_name = "";
        
                if (!empty($total_records_list)) {
                    foreach ($total_records_list as $key => $data) {
                        if (!empty($data['discount_id'])) {
                            $discount_id = $data['discount_id'];
                        }
                        if (!empty($data['discount'])) {
                            $discount = $data['discount'];
                        }
                        if (!empty($data['show_frontend'])) {
                            $show_frontend = $data['show_frontend'];
                        }
                        if (!empty($data['creator_name'])) {
                            $creator_name = $obj->encode_decode('decrypt', $data['creator_name']);
                        }
        
                        $discount_data[] = ["creator_name" => $creator_name, "discount_id" => $discount_id, "discount" => $discount, "show_frontend" => $show_frontend];
                    }
                    $output["head"]["code"] = 200;
                    $output["head"]["msg"] = ["discount_data" => $discount_data];
                } else {
                    $output["head"]["code"] = 400;
                    $output["head"]["msg"] = "No Data Available";
                }
            } else {
                $output["head"]["code"] = 400;
                $output["head"]["msg"] = "Invalid Request";
            }
        }
        
        if (isset($json_obj->show_discount_id)) {
            $show_discount_id = $json_obj->show_discount_id;
        
            $discount = "";
            $category_ids = array();
            $discount_list = array();
            $discount_data = array();
        
            if (!empty($show_discount_id)) {
                $discount_list = $obj->getTableRecords($GLOBALS['discount_table'], 'discount_id', $show_discount_id);
                if (!empty($discount_list)) {
                    foreach ($discount_list as $data) {
                        if (!empty($data['discount'])) {
                            $discount = $data['discount'];
                        }
                        if (!empty($data['category_ids'])) {
                            $category_ids = explode(",", $data['category_ids']);
                        }
                        $discount_data[] = ["discount" => $discount, "category_ids" => $category_ids];
                    }
                }
            }
        
            $category_list = array();
            $category_list = $obj->NoDiscountCategories($show_discount_id);
        
            $category_data_array = array();
            if (!empty($category_list)) {
                $category_data_array = array();
                foreach ($category_list as $data) {
                    if (!empty($data['category_id'])) {
                        $category_id_from_table = $data['category_id'];
                    }
                    if (!empty($data['name'])) {
                        $data['name'] = $obj->encode_decode('decrypt', $data['name']);
                        $data['name'] = str_replace("$", '"', $data['name']);
                        $category_name_from_table = $data['name'];
                    }
                    $category_data_array[] = [
                        "category_id" => $category_id_from_table,
                        "category_name" => $category_name_from_table,
                    ];
                }
            }
        
            if (empty($discount_data)) {
                $discount_data[] = ["discount" => '', "category_ids" => []];
            }
        
            $output["head"]["code"] = 200;
            $output["head"]["msg"] = ["discount_data" => $discount_data, "category_list" => $category_data_array];
        }
        
        if (isset($json_obj->edit_discount_id)) {
        
            $discount = "";
            $discount_error = "";
            $category_ids = array();
            $category_error = "";
            $valid_discount = "";
        
            $discount = $json_obj->discount;
            $discount = str_replace("%", "", $discount);
            $discount_error = $valid->valid_number($discount, 'Discount', '1');
            if (!empty($discount_error)) {
                $valid_discount = $discount_error;
            }
        
            if (isset($json_obj->category_ids)) {
                $category_ids = $json_obj->category_ids;
            }
        
            if (!empty($category_ids)) {
                foreach ($category_ids as $category_id) {
                    print($category_id);
                    if (!empty($category_id)) {
                        $getUniqueID = $obj->getTableColumnValue($GLOBALS['category_table'], 'category_id', $category_id, 'id');
                        if (empty($getUniqueID) || !preg_match("/^\d+$/", $getUniqueID)) {
                            $category_error = "Invalid category";
                            break; // Stop processing if any category is invalid
                        }
                    } else {
                        $category_error = "Empty category";
                        break; // Stop processing if any category is empty
                    }
                }
            } else {
                $category_error = "Select the categories";
            }
        
            if (isset($json_obj->edit_discount_id)) {
                $edit_id = $json_obj->edit_discount_id;
            }
        
            $result = "";
        
            if (empty($valid_discount) && empty($category_error)) {
        
                if (!empty($category_ids) && is_array($category_ids)) {
                    $category_ids = implode(",", $category_ids);
                }
        
                $prev_discount_id = "";
                $columns = array();
                $values = array();
                $check_discounts = array();
                $discount_error = "";
                if (!empty($discount)) {
                    $check_discounts = $obj->getTableRecords($GLOBALS['discount_table'], 'discount', $discount);
                    if (!empty($check_discounts)) {
                        foreach ($check_discounts as $data) {
                            if (!empty($data['discount']) && $data['discount'] == $discount) {
                                $prev_discount_id = $data['discount_id'];
                            }
                            if (!empty($prev_discount_id)) {
                                $discount_error = "This discount is already exist";
                                break;
                            }
                        }
                    }
                }
        
                if (empty($edit_id)) {
                    if (empty($prev_discount_id)) {
                        $creator_name = "";
                        $created_date_time = $GLOBALS['create_date_time_label'];
                        $creator = $json_obj->creator_id;
                        $creator_name = $obj->getTableColumnValue($GLOBALS['user_table'], 'user_id', $creator, 'name');
        
                        $null_value = $GLOBALS['null_value'];
                        $columns = array('created_date_time', 'creator', 'creator_name', 'discount_id', 'discount', 'category_ids', 'show_frontend', 'deleted');
                        $values = array("'" . $created_date_time . "'", "'" . $creator . "'", "'" . $creator_name . "'", "'" . $null_value . "'", "'" . $discount . "'", "'" . $category_ids . "'", "'0'", "'0'");
                        $discount_insert_id = $obj->InsertSQL($GLOBALS['discount_table'], $columns, $values, '');
                        if (preg_match("/^\d+$/", $discount_insert_id)) {
                            $discount_id = "";
                            if ($discount_insert_id < 10) {
                                $discount_id = "DISCOUNT_0" . $discount_insert_id;
                            } else {
                                $discount_id = "DISCOUNT_" . $discount_insert_id;
                            }
                            if (!empty($discount_id)) {
                                $discount_id = $obj->encode_decode('encrypt', $discount_id);
                            }
                            $columns = array();
                            $values = array();
                            $columns = array('discount_id');
                            $values = array("'" . $discount_id . "'");
                            $discount_update_id = $obj->UpdateSQL($GLOBALS['discount_table'], $discount_insert_id, $columns, $values, '');
                            if (preg_match("/^\d+$/", $discount_update_id)) {
                                $output["head"]["code"] = 200;
                                $output["head"]["msg"] = "Discount Successfully Created";
                            } else {
                                $output["head"]["code"] = 400;
                                $output["head"]["msg"] = $discount_update_id;
                            }
                        } else {
                            $output["head"]["code"] = 400;
                            $output["head"]["msg"] = $discount_insert_id;
                        }
                    } else {
                        $output["head"]["code"] = 400;
                        $output["head"]["msg"] = $discount_error;
                    }
                } else {
                    if (empty($prev_discount_id) || $prev_discount_id == $edit_id) {
                        $getUniqueID = "";
                        $getUniqueID = $obj->getTableColumnValue($GLOBALS['discount_table'], 'discount_id', $edit_id, 'id');
                        if (preg_match("/^\d+$/", $getUniqueID)) {
                            $action = "";
                            $columns = array();
                            $values = array();
                            $columns = array('discount', 'category_ids');
                            $values = array("'" . $discount . "'", "'" . $category_ids . "'");
                            $discount_update_id = $obj->UpdateSQL($GLOBALS['discount_table'], $getUniqueID, $columns, $values, $action);
                            if (preg_match("/^\d+$/", $discount_update_id)) {
                                $output["head"]["code"] = 200;
                                $output["head"]["msg"] = 'Updated Successfully';
                            } else {
                                $output["head"]["code"] = 400;
                                $output["head"]["msg"] = $discount_update_id;
                            }
                        }
                    } else {
                        $output["head"]["code"] = 400;
                        $output["head"]["msg"] = $discount_error;
                    }
                }
            } else {
                if (!empty($valid_discount)) {
                    $output["head"]["code"] = 400;
                    $output["head"]["msg"] = $valid_discount;
                } else if (!empty($category_error)) {
                    $output["head"]["code"] = 400;
                    $output["head"]["msg"] = $category_error;
                }
            }
        }
        
        if (isset($json_obj->show_hide_discount_id)) {
            $show_hide_discount_id = $json_obj->show_hide_discount_id;
            $show_frontend = $json_obj->show_frontend;
            $msg = "";
            if (!empty($show_hide_discount_id)) {
                $discount_unique_id = "";
                $discount_unique_id = $obj->getTableColumnValue($GLOBALS['discount_table'], 'discount_id', $show_hide_discount_id, 'id');
        
                if (preg_match("/^\d+$/", $discount_unique_id)) {
                    $discount = "";
                    $discount = $obj->getTableColumnValue($GLOBALS['discount_table'], 'discount_id', $show_hide_discount_id, 'discount');
        
                    $action = "";
                    if (!empty($discount)) {
                        if (!empty($show_frontend)) {
                            $action = "Discount Show in Frontend. Change to OFF. Discount - " . $discount;
                        } else {
                            $action = "Discount Show in Frontend. Change to ON. Discount - " . $discount;
                        }
                    }
                    $columns = array();
                    $values = array();
                    $columns = array('show_frontend');
                    $values = array("'" . $show_frontend . "'");
                    $msg = $obj->UpdateSQL($GLOBALS['discount_table'], $discount_unique_id, $columns, $values, $action);
                    if (preg_match("/^\d+$/", $msg)) {
                        $output["head"]["code"] = 200;
                        $output["head"]["msg"] = "Frontend updated";
                    } else {
                        $output["head"]["code"] = 400;
                        $output["head"]["msg"] = $msg;
                    }
                } else {
                    $output["head"]["code"] = 400;
                    $output["head"]["msg"] = "Product Id Missing";
                }
            }
        }
        
        if (isset($json_obj->delete_discount_id)) {
            $delete_discount_id = $json_obj->delete_discount_id;
            $msg = "";
            if (!empty($delete_discount_id)) {
                $discount_unique_id = "";
                $discount_unique_id = $obj->getTableColumnValue($GLOBALS['discount_table'], 'discount_id', $delete_discount_id, 'id');
                if (preg_match("/^\d+$/", $discount_unique_id)) {
                    $discount = "";
                    $discount = $obj->getTableColumnValue($GLOBALS['discount_table'], 'discount_id', $delete_discount_id, 'discount');
        
                    $action = "";
        
                    $columns = array();
                    $values = array();
                    $columns = array('deleted');
                    $values = array("'1'");
                    $msg = $obj->UpdateSQL($GLOBALS['discount_table'], $discount_unique_id, $columns, $values, $action);
                    if (preg_match("/^\d+$/", $msg)) {
                        $output["head"]["code"] = 200;
                        $output["head"]["msg"] = "Discount Deleted";
                    } else {
                        $output["head"]["code"] = 400;
                        $output["head"]["msg"] = $msg;
                    }
                } else {
                    $output["head"]["code"] = 400;
                    $output["head"]["msg"] = "Discount not found";
                }
            } else {
                $output["head"]["code"] = 400;
                $output["head"]["msg"] = "Invalid Request";
            }
        }        
    }
}

$result = json_encode($output, JSON_NUMERIC_CHECK);

echo $result;
