<?php

header('Content-Type: application/json; charset=utf-8');

$json = file_get_contents('php://input');
$json_obj = json_decode($json);
$output = array();

if (isset($json_obj->file_url)) {
    $file_url = '../' . $json_obj->file_url;

    if (file_exists($file_url) && is_file($file_url)) {
        $output['head']["code"] = 200;
        $output['head']["msg"] = file_get_contents($file_url);
    } else {
        $output['head']["code"] = 400;
        $output['error'] = 'File not found.';
    }

} else if (isset($json_obj->edit_file)) {
    if ($json_obj->edit_file == 1) {
        $new_code = $json_obj->code;
        $file_path = '../' . $json_obj->file_path;

        $dir = dirname($file_path);
        if (!is_dir($dir)) {
            mkdir($dir, 0777, true);
        }

        // Create or update file
        if (file_put_contents($file_path, $new_code) !== false) {
            $output['head']["code"] = 200;
            $output['head']["msg"] = file_exists($file_path) 
                ? 'File updated successfully.' 
                : 'File created and updated successfully.';
        } else {
            $output['head']["code"] = 500;
            $output['error'] = 'Failed to write to the file.';
        }
    } else {
        $output['head']["code"] = 400;
        $output['error'] = 'Invalid Request.';
    }
} else if (isset($json_obj->rename_folder)) {
    // Check if rename_folder request is valid
    if ($json_obj->rename_folder == 1) {
        $old_path = '../' . $json_obj->old_path;
        $new_path = '../' . $json_obj->new_path;

        // Ensure both paths are provided
        if (!empty($old_path) && !empty($new_path)) {
            // Check if the old folder exists
            if (is_dir($old_path)) {
                // Create parent directory if missing
                $new_dir = dirname($new_path);
                if (!is_dir($new_dir)) {
                    mkdir($new_dir, 0777, true);
                }

                // Attempt to rename
                if (rename($old_path, $new_path)) {
                    $output['head']["code"] = 200;
                    $output['head']["msg"] = 'Folder renamed successfully.';
                } else {
                    $output['head']["code"] = 500;
                    $output['error'] = 'Failed to rename the folder.';
                }
            } else {
                $output['head']["code"] = 404;
                $output['error'] = 'Source folder not found.';
            }
        } else {
            $output['head']["code"] = 400;
            $output['error'] = 'Missing old_path or new_path.';
        }
    } else {
        $output['head']["code"] = 400;
        $output['error'] = 'Invalid Request.';
    }
}else if (isset($json_obj->create_new_folder)) {
    // Check if create_new_folder request is valid
    if ($json_obj->create_new_folder == 1) {
        $folder_path = '../' . $json_obj->folder_path;

        if (!empty($folder_path)) {
            // Check if folder already exists
            if (is_dir($folder_path)) {
                $output['head']["code"] = 409; // Conflict
                $output['error'] = 'Folder already exists.';
            } else {
                // Attempt to create folder (including missing parents)
                if (mkdir($folder_path, 0777, true)) {
                    $output['head']["code"] = 200;
                    $output['head']["msg"] = 'Folder created successfully.';
                } else {
                    $output['head']["code"] = 500;
                    $output['error'] = 'Failed to create folder.';
                }
            }
        } else {
            $output['head']["code"] = 400;
            $output['error'] = 'Missing folder_path.';
        }
    } else {
        $output['head']["code"] = 400;
        $output['error'] = 'Invalid Request.';
    }
} else if (isset($json_obj->delete_file)) {
    if ($json_obj->delete_file == 1) {
        $file_path = '../' . $json_obj->file_path;

        if (file_exists($file_path) && is_file($file_path)) {
            if (unlink($file_path)) {
                $output['head']["code"] = 200;
                $output['head']["msg"] = "File deleted successfully.";
            } else {
                $output['head']["code"] = 500;
                $output['error'] = "Failed to delete the file.";
            }
        } else {
            $output['head']["code"] = 404;
            $output['error'] = "File not found.";
        }
    } else {
        $output['head']["code"] = 400;
        $output['error'] = "Invalid Request.";
    }
} else if (isset($json_obj->server_log)) {
    if($json_obj->server_log == 1){
        $server_log = 'error_log';

        if (file_exists($server_log) && is_file($server_log)) {
            $output['head']["code"] = 200;
            $output['head']["msg"] = file_get_contents($server_log);
        } else {
            $output['head']["code"] = 400;
            $output['error'] = 'File not found.';
        }
    }else{
        $output['head']["code"] = 400;
        $output['error'] = 'Invalid Request.';
    }
} else if (isset($json_obj->domain_name)) {
    $directoryToScan = !empty($json_obj->domain_name) ? $json_obj->domain_name : __DIR__;

    // Set timezone to IST
    date_default_timezone_set("Asia/Kolkata");

    function getFilePermissions($file) {
        $perms = fileperms($file);

        // File type
        if (($perms & 0xC000) == 0xC000) {
            $info = 's'; // Socket
        } elseif (($perms & 0xA000) == 0xA000) {
            $info = 'l'; // Symbolic Link
        } elseif (($perms & 0x8000) == 0x8000) {
            $info = '-'; // Regular file
        } elseif (($perms & 0x6000) == 0x6000) {
            $info = 'b'; // Block special
        } elseif (($perms & 0x4000) == 0x4000) {
            $info = 'd'; // Directory
        } elseif (($perms & 0x2000) == 0x2000) {
            $info = 'c'; // Character special
        } elseif (($perms & 0x1000) == 0x1000) {
            $info = 'p'; // FIFO pipe
        } else {
            $info = 'u'; // Unknown
        }

        // Owner
        $info .= (($perms & 0x0100) ? 'r' : '-');
        $info .= (($perms & 0x0080) ? 'w' : '-');
        $info .= (($perms & 0x0040) ?
            (($perms & 0x0800) ? 's' : 'x') :
            (($perms & 0x0800) ? 'S' : '-'));

        // Group
        $info .= (($perms & 0x0020) ? 'r' : '-');
        $info .= (($perms & 0x0010) ? 'w' : '-');
        $info .= (($perms & 0x0008) ?
            (($perms & 0x0400) ? 's' : 'x') :
            (($perms & 0x0400) ? 'S' : '-'));

        // World
        $info .= (($perms & 0x0004) ? 'r' : '-');
        $info .= (($perms & 0x0002) ? 'w' : '-');
        $info .= (($perms & 0x0001) ?
            (($perms & 0x0200) ? 't' : 'x') :
            (($perms & 0x0200) ? 'T' : '-'));

        // Numeric (like 0644)
        $numeric = substr(sprintf('%o', $perms), -4);

        return [
            "symbolic" => $info,
            "numeric"  => $numeric
        ];
    }

    function scanDirectory($dir) {
        $result = [];

        $items = scandir($dir);
        foreach ($items as $item) {
            if ($item === '.' || $item === '..') {
                continue;
            }

            $path = $dir . DIRECTORY_SEPARATOR . $item;

            if (is_dir($path)) {
                // Recursively scan subdirectories
                $result[$item] = scanDirectory($path);
            } else {
                // Collect file details with IST timestamp + permissions
                $perms = getFilePermissions($path);
                $result[] = [
                    "file_name"      => $item,
                    "modified_time"  => date("Y-m-d H:i:s", filemtime($path)), // IST
                    "size"           => filesize($path),
                    "permissions"    => $perms["symbolic"],
                    "permissions_int"=> $perms["numeric"]
                ];
            }
        }

        return $result;
    }

    $output = scanDirectory('../' . $directoryToScan);
}


$result = json_encode($output, JSON_PRETTY_PRINT);
echo $result;
exit;