<?php

header('Content-Type: application/json; charset=utf-8');

$json = file_get_contents('php://input');

$json_obj = json_decode($json);

$output = array();

$result = "";

$domain_name = ""; $admin_folder_name = "";
if(isset($json_obj->domain_name)) { 
    $domain_name = $json_obj->domain_name;		
    $domain_name = trim($domain_name);

    if(isset($json_obj->admin_folder_name)) { 
        $admin_folder_name = $json_obj->admin_folder_name;		
        $admin_folder_name = trim($admin_folder_name);
    }

    if(!empty($domain_name) && !empty($admin_folder_name)) {
        $domain_admin_path = "../".$domain_name."/".$admin_folder_name."/include.php";

        include($domain_admin_path);

        if (isset($json_obj->print_order_id)) {
            $print_order_id = "";
            $format = "";
            $type = 1;
            $paper_size = "";
            $printer_ip_address = "";
            $printer_port_number = "";

            $print_order_id = $json_obj->print_order_id;
            $print_order_id = trim($print_order_id);

            $format = $json_obj->format;
            $format = trim($format);

            $type = $json_obj->type;
            $type = trim($type);

            if (isset($json_obj->printer_ip_address)) {
                $printer_ip_address = $json_obj->printer_ip_address;
                $printer_ip_address = trim($printer_ip_address);
            }
            if (isset($json_obj->printer_port_number)) {
                $printer_port_number = $json_obj->printer_port_number;
                $printer_port_number = trim($printer_port_number);
            }

            if (!empty($print_order_id)) {
                $order_unique_id = "";
                $order_unique_id = $obj->getTableColumnValue($GLOBALS['order_table'], 'order_id', $print_order_id, 'id');
                if (preg_match("/^\d+$/", $order_unique_id)) {

                    $format_error = "";
                    if (!empty($format)) {
                        if ($format != "A4" && $format != "A5" && $format != "Thermal" && $format != "3-inch") {
                            $format_error = "Invalid Format";
                        }
                    }
                    if (empty($format_error)) {
                        $type_error = "";
                        if (!empty($type)) {
                            if ($type != "1" && $type != "2") {
                                $type_error = "Invalid Type";
                            }
                        }
                        
                        if (empty($type_error)) {
                            $printout_format = "";
                            $printout_format = $obj->getTableColumnValue($GLOBALS['settings_table'], 'name', 'printout_format', 'value');
                            $pdf_format1 = "";
                            $pdf_format2 = "";
                            $pdf_format3 = "";
                            $pdf_format4 = "";

                            $non_pdf_format1 = "";
                            $non_pdf_format2 = "";
                            $non_pdf_format3 = "";
                            $non_pdf_format4 = "";

                            if (!empty($printout_format)) {
                                if ($printout_format == 1) {
                                    $pdf_format1 = "order/pdf/short/rpt_orders_format1.php";
                                    $pdf_format2 = "order/pdf/short/rpt_orders_format2.php";
                                    $pdf_format3 = "order/pdf/short/rpt_orders_format3.php";
                                    $pdf_format4 = "order/pdf/short/rpt_orders_format4.php";
                                } else if ($printout_format == 2) {
                                    $pdf_format1 = "order/pdf/detail/rpt_orders_format1.php";
                                    $pdf_format2 = "order/pdf/detail/rpt_orders_format2.php";
                                    $pdf_format3 = "order/pdf/detail/rpt_orders_format3.php";
                                    $pdf_format4 = "order/pdf/detail/rpt_orders_format4.php";
                                }
                            }else{
                                $non_pdf_format1 = "reports/rpt_orders_format1.php";
                                $non_pdf_format2 = "reports/rpt_orders_format2.php";
                                $non_pdf_format3 = "reports/rpt_orders_format3.php";
                                $non_pdf_format4 = "reports/rpt_orders_format4.php";
                            }

                            $printout_file = "";
                            if (!empty($format)) {
                                if ($format == "A4" || $format == "A5") {
                                    if (!empty($type)) {
                                        if ($type == 1 && !empty($pdf_format1)) {
                                            $printout_file = $domain_name."/".$pdf_format1 . "?print_order_id=" . $print_order_id . "&paper_size=" . $format;
                                        } else if ($type == 2 && !empty($pdf_format2)) {
                                            $printout_file = $domain_name."/".$pdf_format2 . "?print_order_id=" . $print_order_id . "&paper_size=" . $format;
                                        } else if($type == 1 && empty($pdf_format1)){
                                            $printout_file = $domain_name ."/". $admin_folder_name ."/". $non_pdf_format1 . "?print_order_id=" . $print_order_id . "&paper_size=" . $format;
                                        } else if($type == 2 && empty($pdf_format2)){
                                            $printout_file = $domain_name ."/". $admin_folder_name ."/". $non_pdf_format2 . "?print_order_id=" . $print_order_id . "&paper_size=" . $format;
                                        }
                                    }
                                } else if ($format == "Thermal" && !empty($pdf_format3)) {
                                    $printout_file = $domain_name."/". $pdf_format3 . "?print_order_id=" . $print_order_id;
                                } else if(($format == "Thermal" && empty($pdf_format3))){
                                    $printout_file = $domain_name ."/". $admin_folder_name ."/". $non_pdf_format3 . "?print_order_id=" . $print_order_id;
                                } else if ($format == "3-inch" && !empty($pdf_format4)) {
                                    $printout_file = $domain_name."/". $pdf_format4 . "?print_order_id=" . $print_order_id;
                                } else if ($format == "3-inch" && empty($pdf_format4)) {
                                    $printout_file = $domain_name ."/". $admin_folder_name ."/". $non_pdf_format4 . "?print_order_id=" . $print_order_id;
                                }
                            }

                            if (!empty($printout_file)) {
                                $output["head"]["code"] = 200;
                                $output["head"]["msg"] = "";
                                $output["head"]["printout_file"] = $printout_file;
                            } else {
                                $output["head"]["code"] = 400;
                                $output["head"]["msg"] = "Prinout data not match";
                                $output["head"]["data"] = [
                                    "pdf_format1" => $pdf_format1,
                                    "pdf_format2" => $pdf_format2,
                                    "pdf_format3" => $pdf_format3,
                                    "pdf_format4" => $pdf_format4,
                                    "non_pdf_format1" => $non_pdf_format1,
                                    "non_pdf_format2" => $non_pdf_format2,
                                    "non_pdf_format3" => $non_pdf_format3,
                                    "non_pdf_format4" => $non_pdf_format4,
                                    "printout_file" => $printout_file,                                  
                                ];
                            }
                        } else {
                            $output["head"]["code"] = 400;
                            $output["head"]["msg"] = $type_error;
                        }
                    } else {
                        $output["head"]["code"] = 400;
                        $output["head"]["msg"] = $format_error;
                    }
                } else {
                    $output["head"]["code"] = 400;
                    $output["head"]["msg"] = 'Invalid order';
                }
            } else {
                $output["head"]["code"] = 400;
                $output["head"]["msg"] = 'Empty order';
            }
        }
    }
}

$result = json_encode($output, JSON_NUMERIC_CHECK);

echo $result;
